VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Class1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Rem FryersB.BAS  writen by Michael Day - 07/05/00
Rem Copyright 2000 Frye Electronics, Inc.
Rem Frye Instrument Packet Protocol interface program - FRYERS32.DLL
Rem This version is for Visual Basic for Windows
Rem NOTE - you *must* have the Fryers32.DLL loaded either in the
Rem Windows directory, or the directory where this program is located.
 
  Const MaxFData = 2000

  Private Type F_RegsType
    AX As Long
    BX As Long
    CX As Long
    DX As Long
    Di As Long
    SI As Long
  End Type
  
Rem //========================== NOTES ====================================
Rem //Example Object declaration. You declare a separate object for each
Rem //com port you want to use with Fryers. Don't try to use two objects on
Rem //one com port. Only one object can use a com port resource.
Rem //To change the port number of an existing object, just call OpenPacketPort
Rem //with the new parameters. It should be noted that it takes time to open a
Rem //port under windows, as long as 50 to 100mS, so don't do that a lot.
Rem //Also remember that if another porgram is using the com port, you will
Rem //not be able to open the port with Fryers. Always shut down an MSDOS
Rem //prompt window if i used the com port since the port won't be released
Rem //by Windows until the MSDOS prompt window is closed.

Rem // -- Usage --
Rem //Declare a Fryers object variable - TFryers FryersObj;
Rem //Create the object - FryersObj := Create.TFryers;
Rem //Call the FryersObj.OpenPacketPort() function of the object with the desired
Rem //parameters for the port. Call FryersObj.ClosePacketPort() before closing the
Rem //program to insure that Fryers is terminated.

Rem //How to send a command to a Fonix instrument:
Rem //1.Watch FryersObj.SendReady()==true to determine when you can send a command.
Rem //2.Call FryersObj.SendCmd() with a pointer to the array containing the
Rem //  command to be sent to the Fonix instrument.
Rem //3.Watch FryersObj.SendReady()==true to determine when the command is complete.
Rem //4.Call FryersObj.GetResponse() to read the response from the Fryers drive.
Rem //5.If you need to release the instrument to do another measurment,
Rem //  call FryersObj.QuickTerminate() to release the instrument.
Rem //5.Verify the that the response is for the command you sent.

Rem //Note: SendCmd, GetResponse, and QuickTerminate contain a callback that you
Rem //can use to monitor the progress of the command for debugging, or
Rem //if you wish to allow other Windows action to occur while waiting on a command.
Rem //Use this this sparingly though. Remember that calling Windows will
Rem //slow down the progress of the command. Also remember that Fryers is not
Rem //re-entrant, so be careful that any code that is accessed from the callback
Rem //doesn't accidently call a fryers function, which can disrupt the command
Rem //in progress.

Rem //Special notes:
Rem //If you load Fryers32.dll by using the Win32API function
Rem //"LoadLibrary", do not use the function "FreeLibrary" to detach it
Rem //from your process. Using the "FreeLibrary" call causes the
Rem //release of some globally allocated data while the threads that
Rem //were created by the DLL are still running. This may cause
Rem //exception errors such as "Access violation error". When your
Rem //program quits running, the DLL will be detached by the system, so
Rem //you don't need to call "FreeLibrary".

Rem //Always try to terminate your process in normal ways. Forcing a
Rem //process to terminate abruptly may cause some variables or
Rem //pointers in the DLL to "hang around" which might cause
Rem //exception errors.

Rem //When using Visual Basic, do not call the "End" function since
Rem //this function causes the process to terminate abruptly.

Rem //Do not close the Fryers port twice in a row and do not use the
Rem //Fryers calls above $FF00 once the port has been closed.

Rem //The Send and Receive Data arrays that you pass to the Fryers driver
Rem //do not have to be kept. Fryers copies the send data to it's own
Rem //internal buffer so that you can release the SendData array immediately
Rem //after calling the SendData function. When you call the GetResponse
Rem //function, Fryers copies the received data to you array. Upon
Rem //return from the GetResponse function, Fryers no longer needs
Rem //the array, so you can do whatever you want with it.
Rem //==============================================================

Rem type INT16 = smallint;      //Fryers data is a 16 bit integer
Const F_MAX_DATA_SIZE = 2100 '//max size of Fryers data buffer
Const AUTO_BAUD = 0        '//0=use let Fryers find the baudrate
Const F_MAX_PORT = 15
'type tFryersDataArray = array[0..F_MAX_DATA_SIZE] of INT16;
'type pFryersDataArray = ^tFryersDataArray;
'type F_Callback = procedure

Rem //This defines the call to the FRYERS32.DLL for static dll load
Rem // procedure CallFryers(var FRegs:F_RegsType); stdcall external 'Fryers32.DLL';
Rem //However, we use the dynamic dll load method so that we can catch the Error
   
'/Example send/rcv array declarations
'//SendData : array[0..F_MAX_DATA_SIZE] of INT16;
'//RcvData : array[0..F_MAX_DATA_SIZE] of INT16;

Private AutoBaud As Boolean
Private BaudSeek As Boolean
Private FRegs As F_RegsType

Public PortOpen As Boolean
Public FVersion As Integer
Public ComPort As Integer
Public Baudrate As Integer
Public PacketError As Integer

Const SUCCESS = 0
Const RECEIVE_ERROR = 1
Const RECEIVE_OVERRUN = 2
Const SEND_OVERFLOW = 3
Const SEND_OVERRUN = 4
Const ILLEGAL_PACKET = 5
Const BAD_PACKET = 6
Const RESPONSE_ERROR = 7
Const NOGO_COMMAND = 8
Const NO_FRYERS = 9
Const NO_POLL = 10
Const BAD_FRYERS = 11
Const USER_ABORT = 255

Const DEFAULT_POLL_TIME = 100 '//default poll timeout = 5.5 sec
Const DEFAULT_RSP_TIME = 20   '//default response timeout 1.1 second
Const DEFAULT_RCV_TIME = 20   '//default receive timeout 1.1 second

Rem //===============================================================
Rem // FryersObj code
Rem //===============================================================

Rem //---------------------------------------------------------------------------------
Rem //This returns true if the Fryers drive is loaded and ready for business
Public Function FryersReady() As Boolean
  FryersReady = PortOpen
End Function

Rem //---------------------------------------------------------------------------------
Rem //find out what the current selected baudrate is
Public Function GetCurrentBaudrate() As Integer
'FRegs As F_RegsType
  GetCurrentBaudrate = 1
  If (FryersReady = False) Then Return
  FRegs.AX = &HFFFF&   'get Fryers version number
  FRegs.DX = ComPort
  FRegs.Di = 0
  CallFryers (FRegs)
  If (FRegs.Di = 0) Then GetCurrentBaudrate = 9600
  Else: GetCurrentBaudrate = 115200 / Regs.Di
  End If
End Function

Rem //-----------------------------------------------------------------
Rem //Returns -1 if port not open or fryers not loaded
Rem //else returns the current packet status Regs.AX flags
Rem //See manual for definitions of the flags.
Public Function PacketStatus() As Integer
'FRegs As F_RegsType
  PacketStatus = -1
  If (FryersReady = False) Then Return
  FRegs.AX = &HFF13&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  PacketStatus = FRegs.AX
End Function

Rem //-----------------------------------------------------------------
Rem //Checks on baudrate. If baud rate is wrong, tries to switch
Rem //the baudrate (if V4.00 Fryers) to see if it will fix the problem.
Rem //If you know the new baudrate, put the value in NewBaud.
Rem //Otherwise use AUTO_BAUD as the value.
Rem //Returns BaudSeek == true if busy looking for new baudrate,
Rem //Returns Baudrate == current baudrate selection.
Rem //Function call returns 0=no changes needed, 1=seeking new baudrate,
Rem //-1=port not open, -2=packet mode not enabled, -3=baud baudrate given
Rem //To fully update the baudrate, keep calling this until BaudSeek == false
Rem //Note: if the baudrate is changed on the instrument, it can take time
Rem //for the Fryers driver to notice the change. This is particularly true if
Rem //the baudrate is set to 115200 when the previous baudrate was 9600.
Rem //Fryers looks at the polls coming from the instrument to determine the
Rem //baudrate. The Fryers autobaud routine will only update the baudrate if
Rem //it determines that the current baudrate is wrong. If things are functioning
Rem //normally, this call has no effect. Thus you can call it in the middle of
Rem //a command status check routine to automatically update the baudrate if it
Rem //changes. It should be noted that the routine looks for an error in the poll
Rem //sequence to determine that the baudrate is incorrect. This is why it can take
Rem //a while to determine that a new baudrate is needed since at least eight
Rem //failed polls in a row must be received to initiate an autobaud seek, and
Rem //at least three good polls in a row must be seen to settle into the newly
Rem //selected baudrate.
Public Function AutoBaudCheck(NewBaud As Integer) As Integer
tmp1 As Integer
tmp2 As Integer
'FRegs As F_RegsType

  AutoBaudCheck = -1
  If ((FryersReady = False) Or (FVersion < 400)) Then Return

  FRegs.DX = ComPort
  FRegs.BX = NewBaud     '//0=autobaud
  FRegs.AX = &HFF1B&
  CallFryers (FRegs)
  If ((FRegs.CX And &H20&) <> 0) Then
    BaudSeek = True
  Else: BaudSeek = False
  tmp1 = FRegs.AX  '//save status for return
  tmp2 = GetCurrentBaudrate()
  If (tmp2 > 100) Then Baudrate = tmp2
  AutoBaudCheck = tmp1
End Function

Rem //----------------------------------------------------------
Rem //Open a comport to begin packet communications through
Rem //using the specified baudrate. ComPort is 1-4
Rem //Baud is 9600, 19200, 38400, 57600, or 115200
Rem //If Baud is invalid or 0, the default baudrate of 9600 is selected
Rem //If Auto is true, autobaud is enabled while waiting on command status
Rem //returns true if port is opened. If Fast is true, te fast transfer method
Rem //is used to send commands. In most cases, you won't notice a difference
Rem //in performance, but if you are pushing things, it can gain you an extra
Rem //millisecond or so. If you have any problems, such as program crashes, or
Rem //GPFs. use the slow transfer method which is safer.
Rem //returns false if Fryers DLL not loaded, or Open failed.
Public Function OpenPacketPort(IOPort As Integer, Baud As Integer, Auto As Boolean, Fast As Boolean) As Boolean
'FRegs As F_RegsType
  OpenPacketPort = False
  Rem if not(Assigned(Self)) then return

  PortOpen = False
  BaudSeek = False
  Rem If (FryersLoaded() = False) Then '//if Fryers is not loaded, load it now
  Rem  If (LoadFryers() = False) Then Return
  Rem End If

  If (IOPort < 1) Then IOPort = 1
  If (IOPort > 15) Then IOPort = 1
  ComPort = IOPort - 1 '//comport is the defined io port in 32bit mode
  AutoBaud = Auto
  FastTransfer = Fast

  FVersion = 0
  FRegs.AX = &HFFFF&      '//get Fryers version number
  FRegs.DX = ComPort
  CallFryers (FRegs)
  PacketError = NO_FRYERS     '//assume fryers not installed
  If (((FRegs.DX And &HFFFF&) <> &HFFFF&) Or (FRegs.AX < 50)) Then Return
      Rem //Win32 needs V5.00 or above

  FRegs.BX = 0
  FRegs.SI = 0
  FRegs.Di = 0
  FRegs.AX = &HFFFE&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  FVersion = FRegs.BX

  FRegs.AX = &HFF00&      '//disable fryers interrupt procedure
  FRegs.CX = &HFF00&      '//this makes sure everything is kosher
  FRegs.DX = ComPort
  CallFryers (FRegs)

  FRegs.AX = &HFF00&      '//enable fryers interrupt procedure
  FRegs.CX = &HFFFF&
  FRegs.DX = ComPort
  CallFryers (FRegs)

  Select Case (Baud / 10)
    Case 960: FRegs.AX = &HE3&    '//init to selected baudrate
    Case 1920: FRegs.AX = &H3&    '//no parity, and one stop bit
    Case 2880: FRegs.AX = &H23&
    Case 3840: FRegs.AX = &H43&
    Case 5760: FRegs.AX = &H63&
    Case 11520: FRegs.AX = &H83&
    Case Else: FRegs.AX = &HE3&   '//default to 9600 if bad value given
  End Select '//endcase(Baudrate)
  FRegs.DX = ComPort   '//init port baudrate
  CallFryers (FRegs)

  FRegs.AX = &HFF10&      '//enable fryers packet protocol
  FRegs.CX = &HFFFF&
  FRegs.DX = ComPort
  CallFryers (FRegs)

  FRegs.AX = &HFF17&      '//set poll timer
  FRegs.CX = &HFF&
  FRegs.BX = DEFAULT_POLL_TIME '//default poll timeout = 5.5 sec
  FRegs.DX = ComPort
  CallFryers (FRegs)

  FRegs.AX = &HFF17&      '//set response timer
  FRegs.CX = &H1FF&
  FRegs.BX = DEFAULT_RSP_TIME '//20; //1.1 second
  FRegs.DX = ComPort
  CallFryers (FRegs)

  FRegs.AX = &HFF17&     '//set rcv timer
  FRegs.CX = &H2FF&
  FRegs.BX = DEFAULT_RCV_TIME '//20; //1.1 second
  FRegs.DX = ComPort
  CallFryers (FRegs)

  PortOpen = True
  Baudrate = GetCurrentBaudrate() '//update Baudrate to actual value
  If (Baudrate < 100) Then Baudrate = 9600 '//if failed, force default baud
  If ((PacketStatus() And 1) = 0) Then '//verify that status works
    PacketError = BAD_FRYERS
    Return
  End If
  PacketError = SUCCESS   '//No error, so clear PacketError
  OpenPacketPort = True
End Function

Rem //Close the specified packet communications com port
Public Sub ClosePacketPort()
  If (FryersReady = False) Then Return
  FRegs.AX = &HFF10&      '//disable fryers packet protocol
  FRegs.CX = &HFF00&
  FRegs.DX = ComPort
  CallFryers (FRegs)

  FRegs.AX = &HFF00&      '//disable fryers interrupt procedure
  FRegs.CX = &HFF00&
  FRegs.DX = ComPort
  CallFryers (FRegs)

  PortOpen = False
End Sub

Rem //----------------------------------------------------
Rem //Check to see if Fryers is ready for a command
Public Function SendReady() As Boolean
Status As Integer
  SendReady = False
  If (FryersReady = False) Then Return
  If (AutoBaud = True) Then AutoBaudCheck (AUTO_BAUD)
  Status = PacketStatus
  If ((Status And 1) <> 0) Then
    SendReady = True
  Else: SendReady = False
End Function

Rem //----------------------------------------------------
Rem //make sure any old data is flushed
Rem //This is Called in the send command procedure
Public Function ClearReceiveFlag() As Boolean
  ClearReceiveFlag = False
  If (FryersReady = False) Then Return
  FRegs.AX = &HFF16&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  ClearReceiveFlag = True
End Function

Rem //----------------------------------------------------
Rem //Waits for Fryers to be ready to accept a cmd
Rem //returns false if port not opened or polls not being received
Rem //Note: does not check for Autobaud. You should use SendReady()
Rem //to make sure that everything is ready before calling SendCommand(0
Rem //which calls this to make sure everything is ready.
Public Function SendWait() As Boolean
Status As Integer
  SendWait = False
  If (FryersReady = False) Then Return
  While True
    Status = PacketStatus
    If ((Status And &H60&) <> 0) Then
      SendWait = False
      Return
    End If
    If ((Status And 1) <> 0) Then
      SendWait = True
      Return
    End If
    Callback
  End If
End Function

Rem //-----------------------------------------------
Rem //Sends a cmd to target via the rs232 port
Rem //pData points to the data array containing the command to be sent.
Rem //Load the command to be sent in in SendData[], then call this command.
Rem //Note: if you do not want to hang around here waiting on the command,
Rem //you should use the SendReady() function to wait until Fryers is ready
Rem //for a commmand to be sent.
Public Function SendCmd(ByRef FData() As Integer) As Boolean
i As Integer
  SendCmd = False
  If (SendWait(Callback) = False) Then Return
  ClearReceiveFlag '//make sure any old data is flushed
  If (FData(1) > F_MAX_DATA_SIZE) Then Return
  For i = 0 To (FData(1) + 1)
    FRegs.AX = &HFF23&
    FRegs.DX = ComPort
    FRegs.BX = pData(i) '//load data to Fryers a word at a time
    FRegs.CX = i
    CallFryers (FRegs)
  Next
  FRegs.AX = &HFF15&  '//Now send the command
  FRegs.DX = ComPort
  CallFryers (FRegs)
  SendCmd = True
End Function

Rem //--------------------------------------------
Rem //Waits for response from target
Rem //returns true when command is completed,
Rem //returns false if command failed (low level Fryers comm failure).
Rem //The failure is only if something went wrong at the Fryers level,
Rem //you still must check the response from the instrument to see
Rem //if the instrument accepted the command, or for a high level failure.
Private Function RspWait() As Boolean
Status As Integer
  RspWait = False
  If (FryersReady = False) Then Return
  While (True)
    Status = PacketStatus()
    If ((Status And &HFC&) <> 0) Then
      RspWait = False
      Return
    End If
    If ((Status And 1) <> 0) Then
      RspWait = True
      Return
    End If
    If (AutoBaud = True) Then
      Do
        PacketStatus
        Callback
        AutoBaudCheck (AUTO_BAUD)
      While (BaudSeek = True)
    Else
      Callback
    End If
  Wend '//EndWhile(true)
  RspWait = True
End Function

Rem //--------------------------------------------------------
Rem //Gets a response packet of integers from the rs232 port1.
Rem //pData points to the data array where the response will be placed.
Rem //Warning: Make sure that the array is big enough (see MAX_RCV_SIZE)
Function GetResponse(ByRef FData() As Integer) As Boolean
i As Integer
Size As Integer
  GetResponse = False
  If (RspWait(Callback) = False) Then Return
  FRegs.AX = &HFF26&  '//{how much data?}
  FRegs.DX = ComPort
  FRegs.CX = 1
  CallFryers (FRegs)
  Size = Regs.CX
  If (Size > F_MAX_DATA_SIZE) Then Return
  For i = 0 To (Size + 1)
    FRegs.AX = &HFF26&   '//{get the data}
    FRegs.DX = ComPort
    FRegs.CX = i
    CallFryers (FRegs)
    FData(i) = FRegs.DX
  End If
  FRegs.AX = &HFF16&   '//{clear rcv flag}
  FRegs.DX = ComPort
  CallFryers (FRegs)
  GetResponse = True
End Function

Rem //----------------------------------------------------
Rem //Sends a regular quick terminate command
Rem //returns false if port not ready
Function QuickTerminate() As Boolean
i As Integer
  Let QTCmd(3) = Array(&H7FFF&, 0, 0)
  QuickTerminate = False
  If (SendWait() = False) Then Return
  For i = 0 To QTCmd(1) + 1
    FRegs.AX = &HFF23&
    FRegs.DX = ComPort
    FRegs.BX = QTCmd(i) '//load data to Fryers a word at a time
    FRegs.CX = i
    CallFryers (FRegs)
  Next
  FRegs.AX = &HFF15&  '//Now send the command
  FRegs.DX = ComPort
  CallFryers (FRegs)
  QuickTerminate = True
End Function

Rem //----------------------------------------------------
Rem //Returns the current value of the no-poll timer
Function GetPollTimeout() As Integer
  GetPollTimeout = 0
  If (FryersReady = False) Then Return
  FRegs.DX = ComPort
  FRegs.AX = &HFF17&
  FRegs.CX = 0
  CallFryers (FRegs)
  GetPollTimeout = FRegs.AX
End Function

Rem //------------------------------------------------------------
Rem //Set a new value for the no-poll timer
Function SetPollTimeout(Value As Integer) As Boolean
  SetPollTimeout = False
  If (FryersReady = False) Then Return
  FRegs.AX = &HFF17&   '//Select poll timer
  FRegs.BX = Value
  FRegs.CX = &HFF&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  SetPollTimeout = True
End Function

Rem //----------------------------------------------------
Rem //Returns the current value of the packet timer
Function GetPacketTimer() As Integer
  GetPacketTimer = 0
  If (FryersReady = False) Then Return
  FRegs.DX = ComPort
  FRegs.AX = &HFF17&
  FRegs.CX = &H300&
  CallFryers (FRegs)
  GetPacketTimer = FRegs.AX
End Function

Rem //------------------------------------------------------------
Rem //clear the packet timer to zero
Function ClearPacketTimer() As Boolean
  ClearPacketTimer = False
  If (FryersReady = False) Then Return
  FRegs.AX = &HFF17&   '//Select packet timer
  FRegs.BX = 0
  FRegs.CX = &H3FF&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  ClearPacketTimer = True
End Function

Rem//------------------------------------------------------------
Rem //If AutoQT is set, each poll from the Fonix instrument will
Rem //get a QT cmd if there is nothing to send. This is useful for
Rem //capturing realtime curves by releasing the instrument from communication
Rem //mode immediately after collecting the curve data so that the instrument can
Rem //go do another measurement. You can achieve a similar effect by
Rem //calling QuickTerminate yourself after getting the curve data,
Rem //but it tends to be erratic due to the timing variences in Windows.
Rem //It should be noted that Fryers can turn off the AutoQT
Rem //if it sees a NAK in response to a QT command.
Rem //Fryers does this to prevent a continuous stream of errors
Rem //should the instrument not be able to handle a QT command.
Rem //The AutoQT function is disabled when the packet mode is first
Rem //turned on, a packet reset command is given , or a ILL response
Rem //is received in response to the QT command
Rem //(QT commands normally have no response).
Rem //Warning: Do not repeatedly call the AutoQT. Each time you call it,
Rem //the AutoQT function has to reinitialize the QT operation.
Rem //This will cause it to miss a poll sequence. Only call AutoQT
Rem //when you want to change it's state. You can determine the current
Rem //state by using the CheckAT() function.
Function AutoQT(Enable As Boolean) As Boolean
  AutoQT = False
  If (FryersReady() = False) Then Return
  If (Enable = True) Then
    FRegs.CX = &HFFFF&
  Else: FRegs.CX = &HFF00&
  FRegs.DX = ComPort
  FRegs.AX = &HFF1A&
  CallFryers (FRegs)
  AutoQT = Enable
End Function
Rem //---------------------------------------
Rem //This returns the current status of the autoQT function
Rem //true=AutoQT is on
Function CheckQT() As Boolean
  CheckQT = False
  If (FryersReady() = False) Then Return
  FRegs.DX = ComPort
  FRegs.AX = &HFF1A
  FRegs.CX = 0
  CallFryers (FRegs)
  CheckQT = ((FRegs.AX And 1) = 1)
End Function

Rem //---------------------------------------
Rem //Checks to see if we are communicating at all
Rem //returns true if communicating ok, false if no poll being received
Function PollOK() As Boolean
  PollOK = True
  If ((PacketStatus() And &H60&) <> &H60&) Then Return
  PacketError = NO_POLL
  PollOK = False
End Function

Rem //---------------------------------------
Rem //this sets a new value in the response timer
Function SetRspTimer(Value As Integer) As Boolean
  SetRspTimer = False
  If (FryersReady() = False) Then Return
  FRegs.AX = &HFF17&      '//set response timer
  FRegs.BX = Value
  FRegs.CX = &H1FF&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  SetRspTimer = True
End Function

Rem //---------------------------------------
Rem //this returns the response timer's current value
Function GetRspTimer() As Integer
  GetRspTimer = 0
  If (FryersReady() = False) Then Return
  FRegs.CX = &H100&
  FRegs.DX = ComPort
  CallFryers (FRegs)
  GetRspTimer = FRegs.AX
End Function

Rem //==========================================================
Rem // Example call to return Fryers version number
Function GetFryersVersion() As Integer
R As F_RegsType
  GetFryersVersion = -1
  If (FryersLoaded() = False) Then Return
  R.AX = &HFFFF&
  R.DX = 0
  R.CX = 0
  CallFryers (R)
  If ((R.DX And &HFFFF&) <> &HFFFF&) Then
    R.AL = 0
  GetFryersVersion = R.AL
End Function



