
{This is the common entry unit for the Test and Test32 programs}
{all code is shared between the 16 bit and 32 bit versions.}
{V5.10 as of 2 May 2003 - med}

{$N+,E+}
Unit TSunit;
interface
{$I PLATFORM.INC}
uses TS2Unit,TestSubs,TestFIPP,ShowBlob,FryeBmp,
  {$IFDEF WIN32}
     Windows,SysUtils;
     {$APPTYPE CONSOLE}
  {$ENDIF}
  {$IFDEF WIN16}
     DosCrt,WinProcs,WinDos,WinTypes,Strings;
  {$ENDIF}
  {$IFDEF MSDOS}
     Dos;
  {$ENDIF}
  {$IFDEF PMDOS}
     DOS;
  {$ENDIF}

(* -- now located in TS2Unit
var FIPPrec:FIPPrecType;
    pfunerr,num : integer;
    temp : integer;
    Ltemp : Longint;
    chx : char;
    DeviceType : integer;
    TL : longint;
    InputString : str255;

const ABaud : boolean = true;
      QTerm : boolean = false;
      Baud : longint = 9600;
      killme : boolean = false;
      DefaultPollTime : integer = 100;
const ErrorCode : integer = 0;
const CurveSelectValid : boolean = false;
const Iam : integer = -1; {-1=unknown}
*)

procedure RunProgram;

const VerStr       : string[80] = 'Fryers RS232 Test Program - Version 5.11 as of  22 May 2003';
const CopyrightStr : string[80] = 'Copyright 1988,2003 Frye Electronics, Inc.  ';

implementation

var ExitSave:pointer;
procedure PrgExit; far;
begin
  ExitProc := ExitSave;
  if ErrorCode > 0 then
    writeln(FIPPErrorMsg(ErrorCode));
  ExitCode := ErrorCode;
  if ErrorCode > 0 then
    ClosePacketPort(FIPPrec);
  {$IFDEF WIN16}
    SelectCursor(SetOn);
    DoneDosCrtWindow;
  {$ENDIF}
end;


{+++++++++++++++++++++++++++++++++++++++++++++++}
{used for testing weird stuff}
procedure doWeird;
var tm1,tm2,tm3:integer;
begin

  with FIPPrec do
  begin
    while not KeyWaiting do
    begin
      Frequency := 2000;
      if not(SetFrequency(FIPPrec)) then {nop};
      if not(QuickTerminate(FIPPrec)) then {nop};
      if GetMicData(FIPPrec) then
        writeln('Current Microphone Input = ',Str3D(MicData),'dB')
      else
        writeln('Get mic Error');
      tm1 := MicData;
      Frequency := 500;
      if not(SetFrequency(FIPPrec)) then {nop};
      if not(QuickTerminate(FIPPrec)) then {nop};
      if GetMicData(FIPPrec) then
        writeln('Current Microphone Input = ',Str3D(MicData),'dB')
      else
        writeln('Get mic Error');
      tm2 := MicData;
      Frequency := 1000;
      if not(SetFrequency(FIPPrec)) then {nop};
      if not(QuickTerminate(FIPPrec)) then {nop};
      if GetMicData(FIPPrec) then
        writeln('Current Microphone Input = ',Str3D(MicData),'dB')
      else
        writeln('Get mic Error');
      tm3 := MicData;

      writeln('Avg:',Str3D(integer((longint(tm1)+tm2+tm3)div 3)),'dB');

    end;
  end;
  pfunerr := 0;
end;
{  if not QuickTerminate then Exit; }


procedure dobuild;
var t,i : integer;
var temp : integer;
var btemp : boolean;
begin
  with FIPPrec do
  begin
    write('Enter command number: ');
    readln(temp);
    SendArray[0] := temp;
    write('Enter data count: ');
    readln(temp);
    SendArray[1] := temp;
    if (SendArray[1] > 0) and (SendArray[1] < SRArrayMax) then
    begin
      for i := 2 to Sendarray[1]+1 do
      begin
        write('Enter data word: ');
        readln(temp);
        SendArray[i] := temp;
      end;
    end;
    write('Sending: ');
    write(SendArray[0],'  ',SendArray[1],'  ');
    if (SendArray[1] > 0) and (SendArray[1] < SRArrayMax) then
    begin
      for i := 2 to Sendarray[1]+1 do
      begin
        write(SendArray[i],'  ');
      end;
    end;
    writeln;
    if not(SendCommand(FIPPrec)) then
    begin
      writeln('Error - StatAX:',hexW(FIPPrec.StatAX),
                    '  StatCX:',hexW(FIPPrec.StatCX),
                    '  StatDX:',hexW(FIPPrec.StatDX),
                    '  Packet:',hexW(FIPPrec.PacketError) );
      writeln('Fipp Error:',FIPPErrorMsg(FIPPrec.PacketError));
      Exit;
    end;

    if SendArray[0] <> $7fff then
    begin
      write('Response: ');
      write('RcvArray[0]=[',hexW(RcvArray[0]),']');
      if RcvArray[0] > $7fff then write('(',integer(RcvArray[0]),')');
      WRITE(RcvArray[0]);
      t := integer(RcvArray[0]);
      T := ABS(T);
      case t of
        0:write(' POL ');
        4:write(' ACK ');
        5:write(' NAK ');
        6:write(' ILL ');
      end;
      writeln(' RcvArray[1] = ',RcvArray[1]);
    end
    else
    begin
      writeln('Quick Terminate');
    end;
    writeln('Status - StatAX:',hexW(FIPPrec.StatAX),
           ' StatCX:',hexW(FIPPrec.StatCX),
           ' StatDX:',hexW(FIPPrec.StatDX),
           ' Packet:',hexW(FIPPrec.PacketError) );

    if SendArray[0] <> $7fff then
    begin
      btemp := ShowInt;
      if ((SendArray[0] = 111) or (Sendarray[0] = 110)) then ShowInt := true;
      if (RcvArray[1] > 0) and (RcvArray[1] < SRArrayMax) then
      begin
        write('Data = ');
        for i := 2 to RcvArray[1]+1 do
        begin
          if ShowInt then
            write(smallint(RcvArray[i]),', ')
          else write(RcvArray[i],', ');
        end;
      end;
      ShowInt := btemp;
    end;
    writeln;
    pfunerr := 0;
  end;
end;

(*
procedure doswitch;
var temp : longint;
begin
  with FIPPrec do
  begin
    write('Enter Switch Box State (0=off, 1=on): ');
    readln(temp);
    if (temp < 0) or (temp > 1) then Exit;
    SwitchState := temp;
    if SwitchState = 1 then
    begin
      write('Enter Switch Box Command (0-65535): ');
      readln(temp);
      SwitchCmd := temp;
      SwitchState := 2; {//force an immediate cmd send}
    end;
    ExternalSwitch(SwitchState,SwitchCmd,FIPPrec);
    if (Regs.AX and $FFFF) = $FFFF then
    begin
      Writeln('Error: function not supported');
      writeln;
      exit;
    end;
    if SwitchState = 0 then
      writeln('External Switchbox packet codes disabled')
    else writeln('External Switchbox packet codes enabled: ',SwitchCmd,'($',hexw(SwitchCmd),')');
    pfunerr := 0;
  end;
end;
*)

{-----------------------------------------------}
procedure domon; {M}
label Done;
var chx : char;
    Y:integer;
    Tc,OldTickCount:longint;
    Count : integer;
  procedure ShowStatus;
  begin
    Tc := GetTick and $fffe;
    if Tc = OldTickCount then Exit;
    OldTickCount := Tc;
    {$IFDEF WIN16}
      Y := WhereY;
    {$ENDIF}
      write(Spin((Tc shr 1) and 3));
      write('Status - StatAX:',hexW(FIPPrec.StatAX),
           ' StatCX:',hexW(FIPPrec.StatCX),
           ' StatDX:',hexW(FIPPrec.StatDX),
           ' Packet:',hexW(FIPPrec.PacketError) );
    {$IFDEF WIN16}
      GotoXY(1,Y);
    {$ELSE}
      write(#13);
    {$ENDIF}
  end;
  function WaitForIt:boolean;
  begin
     while (PacketStatus(FIPPrec) and 1 = 0) and (chx <> #3) do
     begin
       if FIPPrec.AutoBaud then AutoBaudCheck(FIPPrec);
       ShowStatus;
       if keywaiting then chx := Getkey;
       if chx = #$1b then chx := #3;
     end;
     if chx = #3 then WaitForIt := false else WaitForIt := true;
  end;
begin
  writeln('Status Monitor : Press "ESCape" key to exit.');
  with FIPPrec do
  begin
    Count := 0;
    while KeyWaiting do
    begin
      chx := GetKey;
      inc(Count);
      if Count > 255 then Exit;
    end;
    chx := #13;
    while chx <> #3 do
    begin
      ShowStatus;
      if not(WaitForIt) then goto Done;
      DiscardResponse(FIPPrec);
      SendArray[0] := GetCmdStatusCmd;
      SendArray[1] := 0;
      if not(SendPacket(FIPPrec)) then goto Done;
      if not(WaitForIt) then goto Done;
      if not(ReceivePacketOK(FIPPrec)) then {nop};
      if not(GetRcvPacket(FIPPrec)) then {nop};
      if keywaiting then chx := Getkey;
      if chx = #$1b then chx := #3;
    end;
  end;
 Done:
  writeln;
end;

{-----------------------------------------------}
procedure doverify;
begin
  with FIPPrec do
  begin
    Verify := not(Verify);
    if Verify then
      writeln('Automatic Command Status Verify enabled')
    else
      writeln('Automatic Command Status Verify off');
    writeln;
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dodebug;
begin
  with FIPPrec do
  begin
    Debug := not(Debug);
    if Debug then
      writeln('Debugging enabled')
    else
      writeln('Debugging off');
    writeln;
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dopolltime;
begin
  with FIPPrec do
  begin
    writeln;
    write('Current Poll Timeout = ',PollTimer,' (ticks)'    );
    if Fversion >= 410 then
      write('  [',RealPollTime,' mS Real]');
    writeln('  {',PacketTickMultMS,' mS Per Tick}');
    writeln;
    write  ('Enter new Poll Timeout (in ticks): ');
    readln(Ltemp);
    PollTimer := Ltemp;
    SetPollTimer(FIPPrec);

    GetPollTimer(FIPPrec);                             {* -----test ---*}
    write('New Poll Timeout = ',PollTimer,' (ticks)'    );
    if Fversion >= 410 then
      write('  [',RealPollTime,' mS Real]');
    writeln('  {',PacketTickMultMS,' mS Per Tick}');
    writeln;
    writeln;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
  procedure ShowQTStatus;
  var  Tc,OldTickCount:longint;
  var Qt : boolean;
{$IFDEF WIN16}
  var Y : integer;
{$ENDIF}
  begin
    Tc := GetTick and $fffe;
    {if Tc = OldTickCount then Exit;
    OldTickCount := Tc;}
    QT := Qton(FIPPrec);
    {$IFDEF WIN16}
      Y := WhereY;
    {$ENDIF}
      write(Spin((Tc shr 1) and 3));
      write('Status - StatAX:',hexW(FIPPrec.StatAX),
           ' StatCX:',hexW(FIPPrec.StatCX),
           ' StatDX:',hexW(FIPPrec.StatDX),
           ' Packet:',hexW(FIPPrec.PacketError) );
      write(' Rd:',FIPPrec.RcvArray[0]);
      if QT then write(' Quick')
      else write('      ');
    {$IFDEF WIN16}
      GotoXY(1,Y);
    {$ELSE}
      write(#13);
    {$ENDIF}
     if keywaiting then chx := Getkey;
     if chx = #$1b then
       chx := #3;
     if chx = '1' then
     begin
       FIPPrec.QuickTerm := true;
       AutoQT(FIPPrec,true);
       chx := #0;
     end;
     if chx = '0' then
     begin
       FIPPrec.QuickTerm := false;
       AutoQT(FIPPrec,false);
       chx := #0;
     end;
  end;
  function WaitForQtStatus:boolean;
  begin
     while (PacketStatus(FIPPrec) and 1 = 0) and (chx <> #3) do
     begin
       if FIPPrec.AutoBaud then AutoBaudCheck(FIPPrec);
       ShowQtStatus;
     end;
     if chx = #3 then WaitForQtStatus := false else WaitForQtStatus := true;
  end;

procedure dofQTtest;
var Y:integer;
label QtTestDone;
begin
  writeln('QT Test : Press "ESCape" key to exit.');
  with FIPPrec do
  begin
    chx := #13;
    while chx <> #3 do
    begin
      if QuickTerm = true then
      begin
        ShowQtStatus;
      end
      else
      begin
        ShowQtStatus;
        if not(WaitForQtStatus) then goto QtTestDone;
        DiscardResponse(FIPPrec);
        SendArray[0] := $7fff;
        SendArray[1] := 0;
        if not(SendPacket(FIPPrec)) then goto QtTestDone;
        if not(WaitForQtStatus) then goto QtTestDone;
        if ReceivePacketOK(FIPPrec) then
          if not(GetRcvPacket(FIPPrec)) then {nop};
      end;
      {if keywaiting then chx := Getkey;}
      {if chx = #$1b then chx := #3;}
      {if chx = '1' then  QuickTerm := true;}
      {if chx = '0' then QuickTerm := false; }
    end;
  end;
QtTestDone:
  writeln;
  pfunerr := 0;
end;

procedure dofwakeup;
const Signal : array[0..3] of char = (^D, ^W, ^C, ^M);
begin
  if not SendWakeup(Signal,FIPPrec) then
    writeln('* Timeout Error *');
end;

{-----------------------------------------------}
{show help info}

const maxf = 999;

procedure dohelp; {dof90}{(var pfunerr:integer)}
begin
  writeln;
            { x                          x                           x                     e'}
{1} writeln(' 0/21=Set/Get Source Amp    70/71=Set/Get Option Param  13=Do RelAtt Select    ');
{2} writeln(' 1/22=Set/Get Dist Mode     75/76=Set/Get Test Ear      14=Do Battery          ');
{3} writeln(' 2/23=Set/Get Frequency     77/78=Set/Get Operation St  15=Do IO Test          ');
{4} writeln(' 3/24=Set/Get OES State     82/81=Set/Get Avg Freqs     16=Start/Stop Test     ');
{5} writeln(' 4/26=Set/Get Noise Red     84/83=Set/Get Meas Delay    17=Do Level            ');
{6} writeln(' 5/27=Set/Get Smoothing     88/87=Set/Get CIC State     38=Do Reset            ');
{7} writeln(' 7/35=Set/Get Probe State   90/91=Set/Get Avg Settle    64=Do Line Feeds       ');
{8} writeln(' 8/30=Set/Get Weighting     66/86=Set/Get Extnd Label   65=Do Print            ');
{9} writeln(' 9/25=Set/Get Curve Frame   92/93=Set/Get Printer Type                         ');
{10}writeln('10/34=Set/Get IO Mode       97/98=Set/Get A/R Params     6=Set Label           ');
{11}writeln('11/37=Set/Get TelCoil St                                89=Set Label Storage   ');
{12}writeln('12/36=Set/Get Gain State    18=Get Rel Att Data         96=Set Label Bitmap    ');
{13}writeln('39/44=Set/Get TelCoil Mode  19=Get Battery Data                                ');
{14}writeln('40/41=Set/Get Rel Att Freq  20=Get IO Data              79=Set Battery Type    ');
{15}writeln('43/45=Set/Get Zeta State    29=Get Level State          56=Set Power State     ');
{16}writeln('47/46=Set/Get Insitu        31=Get Mic Input                                   ');
{17}writeln('48/49=Set/Get Automatic     32=Get Dist Percent         28=Get Version         ');
{18}writeln('50/51=Set/Get Limit Value   42=Get Last Curve           33=Get Cmd Status      ');
{19}writeln('52/53=Set/Get RefMic State  57=Get RefMic Input         80=Get Power Status    ');
{20}writeln('54/55=Set/Get Active State  61=Get Blob                 95=Get Software Info   ');
{21}writeln('59/60=Set/Get Test State    94=Get HFA Data             "M"=More commands      ');
{22}writeln(' ');
{23}writeln('"H"=Help "M"=More "X"=Exit "B"=BuildCmd "V"=VrfyTgl "C"=ComPort');
{24}writeln(' ');
  pfunerr := 0;
end;

procedure domore;
begin
  writeln;
            { x                          x                           x                     e'}
{1} writeln('62/63=Set/Get Key Control   148/149=Set/Get Aux Port    67=Do Error            ');
{2} writeln('72/58=Set/Get Key Code      150/151=Set/Get User #      85=Do Measurement      ');
{3} writeln('73/74=Set/Get Poll Delay    165/166=Set/Get User ID                            ');
{5} writeln('104/103=Set/Get Clock                                   68=Set Spectrum        ');
{6} writeln('106/105=Set/Get Output Dev                              69=Set Phase           ');
{7} writeln('108/107=Set/Get Impulse Rej                             99=Set Blob            ');
{8} writeln('112/113=Set/Get Crv Select                             147=Set Leveling State  ');
{9} writeln('114/115=Set/Get Crv Status                              ');
{10}writeln('116/117=Set/Get Unaided                                 ');
{11}writeln('121/122=Set/Get Static Tone                             ');
{12}writeln('123/124=Set/Get Aid Type                                ');
{13}writeln('125/126=Set/Get Bias Tone                               ');
{14}writeln('129/130=Set/Get Wrbl Select 100=Get Device ID Count     ');
{15}writeln('132/133=Set/Get Rcv Timeout 101=Get Long Device ID      ');
{16}writeln('134/135=Set/Get Fit Rule    102=Get Device Data         ');
{17}writeln('136/137=Set/Get Filter      109=Get Signal Info         ');
{18}writeln('138/139=Set/Get Compression 131=Get Delay Measurments   ');
{19}writeln('140/141=Set/Get Client Age                              ');
{20}writeln('142/143=Set/Get Trans. Loc                              "N"=Toggle Show as int ');
{21}writeln('145/146=Set/Get Level List                              "L"=Tgl comma delimit');
{22}writeln(' ');
{23}writeln('"X"=Exit "O"=Monitor "T"=Timeout "B"=BuildCmd "H"=Help');
{24}writeln(' ');
  pfunerr := 0;
end;
{writeln('"X"=Exit "O"=Monitor "T"=Timeout "S"=ExtSwBox');}

{Commands currently not supported by the Test program (too complex) }

  {96,VARLEN,RS232Com_SetBitmap}        {set bitmap (printer)    }
  {110,3,RS232Com_GetRawSampleData}     {get raw sample data     }
  {111,2,RS232Com_GetMicCalibation}     {get mic cal info        }
  {118,VARLEN,RS232Coup_SetList}        {load user list (undocumented)}
  {119,1,RS232Coup_GetList}             {get user list (undocumented)}
  {120,6,RS232Com_GetBitmap}            {get screen/printer bitmap}
  {125,VARLEN,RS232Coup_SetBiasTone}    {set bias tone selection <future>}
  {126,0,RS232Coup_GetBiasTone}         {get bias tone selection <future>}
  {127,VARLEN,NULL}                     {<reserved for packet control>}
  {128,VARLEN,NULL}                     {<reserved for packet control>}
  {129,1,RS232Com_SetWarbleSelect}      {set warble selection    }
  {130,0,RS232Com_GetWarbleSelect}      {get warble selection    }

{-----------------------------------------------}
procedure docmd;
var temp:boolean;
begin
  if length(InputString) = 0 then Exit;
  case InputString[1] of
    'X','Q': begin
               killme := true;
               pfunerr := 0;
             end;
    'H','?': dohelp;
    'M': domore;
    'O': domon;
    'B': begin
           {temp := ShowInt; }
           {ShowInt := false; }
           dobuild;
           {ShowInt := temp;}
         end;
    'N': begin
           {temp := ShowInt;}
           ShowInt := not(ShowInt);
           {dobuild;        }
           {ShowInt := temp;}
         end;
    'L': Delimit := not(Delimit);
    'V': doverify;
    'W': doweird;
    'T': dopolltime;
    'D': dodebug;
    'C': doport;
    {//'S': doswitch;}
  end;
end;


{-----------------------------------------------}
{returns true if it is a number otherwise returns false}
function Cleanup(var Data:str255):boolean;
var i : integer;
var UseHex : boolean;
  function ValidNum:boolean;
  begin
    ValidNum := true;
    if Data[i] in['0','1','2','3','4','5','6','7','8','9','0','-','+','.'] then Exit;
    if UseHex then
      if Data[i] in ['A','B','C','D','E','F'] then Exit;
    ValidNum := false;
  end;
begin
  CleanUp := false;
  if length(Data) = 0 then Exit;
  while Data[1] < '!' do
  begin
    delete(Data,1,1);
    if length(Data) = 0 then Exit;
  end;
  for i := 1 to length(Data) do
    Data[i] := upcase(Data[i]);
  if not(Data[1] in['0','1','2','3','4','5','6','7','8','9','0','$']) then Exit;
  if Data[1] = '$' then
    UseHex := true
  else UseHex := false;

  if length(Data) > 1 then
  begin
    i := 2;
    while ValidNum do
      inc(i);
    if length(Data) > pred(i) then
      Data[0] := char(pred(i));
  end;
  CleanUp := true;
end;

{-----------------------------------------------}
procedure RunProgram;
var pt:boolean;
    s,Pstr : str255;
    c : char;
    pcnt,Err:integer;
begin
  ErrorCode := 255;
  ExitSave := ExitProc;
  ExitProc := @PrgExit;

 {$IFDEF WIN16}           {init WinCrt stuff}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    Windowsize.X := 1000 {639};  {make it as big as it will go}
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'TEST');
    DosCrtFont := OEM_FIXED_FONT;
    InitDosCrtWindow;
    AutoTracking := false;
    SelectCursor(setOn);
 {$ENDIF}

  writeln(VerStr);      {writeln('Fryers RS232 Test Program - Version 5.0x as of  23 Aug 2002');}
  write(CopyrightStr);  {write('Copyright 1988,2002 Frye Electronics, Inc.  ');}
  {$IFDEF MSDOS} writeln('(MS-DOS Version)'); {$ENDIF}
  {$IFDEF DPMI}  writeln('(DPMI Version)'); {$ENDIF}
  {$IFDEF WIN16} writeln('(Win16 Version)'); {$ENDIF}
  {$IFDEF WIN32} writeln('(Win32 Version)'); {$ENDIF}

  while KeyWaiting do
    c := GetKey;

  Fipprec.DoubleCheck := false;
  useIOport := 0;
  useIRQ := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    if upcase(Pstr[1]) = 'C' then
    begin
      if (Pstr[2] >= '0') or (Pstr[2] <= '9') then
        useIOport := ord(Pstr[2]) and $f
      else useIOport := 0;
    end
    else
    begin
    case upcase(Pstr[1]) of
      '2': useIOPort := 2;
      '3': if (upcase(Pstr[2]) = '5') and (length(Pstr) > 1) then
             DeviceType := 35
           else if (length(Pstr) = 1) then
             useIOPort := 3;
      '4': if (upcase(Pstr[2]) = '0') and (length(Pstr) > 1) then
             DeviceType := 40
           else if (length(Pstr) = 1) then
             useIOPort := 4;
      '6': if upcase(Pstr[2]) = '5' then
             DeviceType := 0
           else if upcase(Pstr[2]) = '4' then
             DeviceType := 1;
      'F': if (upcase(Pstr[2]) = 'P') then
           begin
             if upcase(Pstr[3]) = '4' then
               DeviceType := 40
             else if upcase(Pstr[3]) = '3' then
               DeviceType := 35;
           end;
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,useIRQ,Err);
              if (useIRQ > 15) or (Err <> 0) then UseIRQ := 0;
           end;
      'B': begin
             delete(Pstr,1,1);
             val(Pstr,TL,Err);
             case TL div 10 of
               960  : Baud := 9600;
               1920 : Baud := 19200;
               2880 : Baud := 28800;
               3840 : Baud := 38400;
               5760 : Baud := 57600;
             else
               begin
                 Baud := 9600;
                 Abaud := true;
               end;
             end;
             if TL div 10 <> 0 then
               Abaud := true;
           end;
      'A': Abaud := not(Abaud);
      'Q': QTerm := not(QTerm);
      'N': ShowInt := true;
      'L': Delimit := true;
      'T': begin
             delete(Pstr,1,1);
             val(Pstr,TL,Err);
             DefaultPollTimer := TL;
           end;
     end;
   end;
   dec(Pcnt);
  end;

  with FIPPrec do
  begin
    Fillchar(FIPPrec,sizeof(FIPPrec),0);

   {$IFDEF WIN32}
     SetConsoleCtrlHandler(nil,false);
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

    if useIOport = 0 then useIOport := 1;
    AutoBaud := Abaud;
    Baudrate := Baud;
 {   if AutoBaud then
      inc(BaudRate);}
    QuickTerm := Qterm;
    Verify := true;

    if not(OpenForBusiness) then
      Halt(1);

  repeat
    write('Verify=',Verify,' - ');
    write('Enter function to perform (H for help) : ');

    InputString := ' ';
    readln(InputString);
    if Cleanup(InputString) then
    begin
      val(InputString,Num,err);
      if err <> 0 then num := -199;
    end
    else num := -1;

    killme := false;
    FIPPrec.CmdStatusFailed := false;
    pfunerr := succ(num);
    begin
      case num of
       -1 : docmd;
        0 : dof0;
        1 : dof1;
        2 : dof2;
        3 : dof3;
        4 : dof4;
        5 : dof5;
        6 : dof6;
        7 : dof7;
        8 : dof8;
        9 : dof9;
        10 : dof10;
        11 : dof11;
        12 : dof12;
        13 : dof13;
        14 : dof14;
        15 : dof15;
        16 : dof16;
        17 : dof17;
        18 : dof18;
        19 : dof19;
        20 : dof20;
        21 : dof21;
        22 : dof22;
        23 : dof23;
        24 : dof24;
        25 : dof25;
        26 : dof26;
        27 : dof27;
        28 : dof28;
        29 : dof29;
        30 : dof30;
        31 : dof31;
        32 : dof32;
        33 : dof33;
        34 : dof34;
        35 : dof35;
        36 : dof36;
        37 : dof37;
        38 : dof38;
        39 : dof39;
        40 : dof40;
        41 : dof41;
        42 : dof42;
        43 : dof43;
        44 : dof44;
        45 : dof45;
        46 : dof46;
        47 : dof47;
        48 : dof48;
        49 : dof49;
        50 : dof50;
        51 : dof51;
        52 : dof52;
        53 : dof53;
        54 : dof54;
        55 : dof55;
        56 : dof56;
        57 : dof57;
        58 : dof58;
        59 : dof59;
        60 : dof60;
        61 : dof61;
        62 : dof62;
        63 : dof63;
        64 : dof64;
        65 : dof65;
        66 : dof66;
        67 : dof67;
        68 : dof68;
        69 : dof69;
        70 : dof70;
        71 : dof71;
        72 : dof72;
        73 : dof73;
        74 : dof74;
        75 : dof75;
        76 : dof76;
        77 : dof77;
        78 : dof78;

        79 : dof79;
        80 : dof80;
        81 : dof81;
        82 : dof82;
        83 : dof83;
        84 : dof84;
        85 : dof85;
        86 : dof86;
        87 : dof87;
        88 : dof88;
        89 : dof89;
        90 : dof90;
        91 : dof91;
        92 : dof92;
        93 : dof93;
        94 : dof94;
        95 : dof95;
        96 : dof96;
        97 : dof97;
        98 : dof98;
        99 : dof99;
       100 : dof100;
       101 : dof101;
       102 : dof102;
       103 : dof103;
       104 : dof104;
       105 : dof105;
       106 : dof106;
       107 : dof107;
       108 : dof108;
       109 : dof109;
       110 : dof110;
       {111 : dof111;}   {<get Cal Data> not implmented here}
       112 : dof112;
       113 : dof113;
       114 : dof114;
       115 : dof115;
       116 : dof116;
       117 : dof117;
       {118 : dof118;}   {<get list> not implemented here}
       {119 : dof119;}   {<set list> not implmented here}
       {120 : dof120;}   {<get bitmap> not implemented here}
       121 : dof121;
       122 : dof122;
       123 : dof123;
       124 : dof124;
       125 : dof125;
       126 : dof126;
       {127: <reserved> - packet control}
       {128: <reserved> - packet control}
       129 : dof129;
       130 : dof130;
       131 : dof131;
       132 : dof132;
       133 : dof133;
       134 : dof134;
       135 : dof135;
       136 : dof136;
       137 : dof137;
       138 : dof138;
       139 : dof139;
       140 : dof140;
       141 : dof141;
       142 : dof142;
       143 : dof143;
       {144 : <reserved> - factory automation - do calibration}
       145 : dof145;
       146 : dof146;
       147 : dof147;
       148 : dof148;
       149 : dof149;
       150 : dof150;
       151 : dof151;
       165 : dof165;
       166 : dof166;

        999 : begin {nop} killme := true; pfunerr := 0; end; {end program}
        200: dofQTtest;
        201: dofwakeup;
        199 : begin {nop} killme := true; pfunerr := 0; end; {end program}
      else
        writeln('Invalid function');
      end;
    end;
    if (pfunerr > 0) and (num <= succ(maxf)) then
      PackErr;

    if num <> -1 then
      writeln;
  until Killme or (num > 999);
  end;
  ErrorCode := 0;
  ClosePacketPort(FIPPrec);
  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}
end;


end.



