
{Convert V1.12 as of 10/07/99 - Copyright 1999 Frye Electronics, Inc.}
{converts word based composite curve frame data to decimal form}

program convert;
var fi,fo:text;
    i,Value:integer;
    count:word;
    cmd:integer;
    s : string;
const commas : boolean = false;

begin
  if ParamCount < 2 then
  begin
    writeln('Convert Composite curve data to decimal form  V1.12  10/07/99 -med');
    writeln('Format is: CONVERT INFILE OUTFILE [-D]');
    writeln('if the -D option is given, data will be comma delimited');
    writeln;
    halt;
  end;
  if ParamCount > 2 then
  begin
    s := paramstr(3);
    if (s[1] = '-') and (upcase(s[2]) = 'D') then commas := true;
  end;
  assign(fi,ParamStr(1));  {get input name}
  assign(fo,ParamStr(2));  {get output name}
  reset(fi);
  rewrite(fo);
  i := 0;
  cmd := 0;
  count := MaxInt;
  while not eof(fi) and (i <= count+1) do
  begin
    readln(fi,word(value));
    if cmd = -32658 then { (rsp=-110) }
      write(fo,value)
    else begin
      case i of
        0: begin cmd := value; end;            {do nothing - cmd}
        1: begin count := value; write(fo,word(value)) end; {number of items to read}
        2: write(fo,word(value)); {curve number}
     3..6: write(fo,word(value)); {curve flags}
        7: write(fo,value/100:0:2); {source amp}
        8: write(fo,value/100:0:2); {Peak value}
        9: write(fo,value/100:0:2); {overall RMS}
       10: write(fo,value);         {noise reduction}
   11..91: write(fo,value/100:0:2); {curve values}
       else
        write(fo,value);
      end; {case i of}
    end;
    if i > 0 then
    begin
      if commas and (i < count+1) then
      begin
        write(fo,',');
      end
      else if not commas then
        writeln(fo);
    end;
    inc(i);
  end;
  if commas then writeln(fo);
  close(fo);
  close(fi);
  writeln('Conversion Complete');
end.
