{ FCunit - Version 5.10  as of 15 Jun 2000}
{ Copyright 1989,2000 Frye Electronics, Inc. }
{ FCunit is used in conjunction with FBAT}
{ to send commands to an attached Fonix instrument }

unit FCunit;
interface

{$IFDEF MSDOS}
  uses dos;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows;
{$ENDIF}

const UsedIRQ : word = 0;

type string20 = string[20];

const
     MaxStdLabelSize  = 172;  {size of std label array (in char)}
     MaxExtLabelSize  = 224;  {size of ext label array (in char)}
     MaxCustomLabelSize  = 28+28;  {size of custom label array (in char)}
     MaxLabelBitmap   = 1024; {max size allowed for labelbitmap (in words)}

     NormalPoll = 100;  {normal poll timeout is 5.5 seconds}
     LongPoll   = 2000; {long poll timeout is 110 seconds}


{type str28 = string[28];}
{type LabelArray = array[0..10] of str28;}


{$IFDEF MSDOS}
  type F_RegsType = Registers;
{$ENDIF}

{$IFDEF WIN32}
  {$I FRYEREGS.INC}
{$ENDIF}

type SendArrayType = array[0..255] of word;
     RcvArrayType  = array[0..1024] of word;
     LabelBitmapType = array[0..MaxLabelBitmap-1] of word;
     Str255 = string[255];
     XferLabelType = array[0..400] of byte;

     FIPPrecType = packed record  {1131 bytes}
        PortOpen    : boolean;{port is open if true}
        AutoBaud    : boolean;{autobaud enabled}
        BaudSeek    : boolean;{true= seeking new baudrate}
        Fversion    : word;   {fryers version number}
        Comport     : word;   {Comport is 0 or 1}
    {    IRQnum      : byte;}   {IRQ number 0-15}
    {    IOport      : byte;}   {IOport used (1-4) (for msdos)}
        Baudrate    : longint;   {operating baudrate}
        PollTimer   : word;   {poll timeout tick count}
        PacketError : word;   {packet comm error number}
        StatAX      : word;   {PacketStatus extended status info}
        StatCX      : word;
        StatDX      : word;
        StatDI      : longint;
        StatSI      : longint;
        CmdStatus   : integer;  {result of last cmdstatus check}
        XferLabel   : XferLabelType;   {label storage used for sending}
        Lab         : Str255;      {string used for standard (old) label}
        CustomLab   : Str255;      {string used for custom label}
        LabelBitmap : LabelBitmapType; {bitmap array used for label graphics}
        SendArray   : SendArrayType;   {Array to place commands in}
        RcvArray    : RcvArrayType;    {Array to place response in}
        Regs        : F_RegsType;      {used to process via INTR}
     end;


type BmpHeaderType = packed record
       id              : word;
       Filesize        : longint;
       reserved        : longint;
       HeaderSize      : longint;
       InfoSize        : longint;
       Width           : longint;
       Height          : longint;
       biPlanes        : word;
       Bits            : word;
       biCompression   : longint;
       biSizeImage     : longint;
       biXPelsPermeter : longint;
       biYPelsPermeter : longint;
       biClrUsed       : longint;
       biClrImportant  : longint;
     end;
var BmpHeader : BmpHeaderType;

{These are the possible unsolicited FIPP responses}
const
     PacketPoll = $FFFF;
     PacketAck  = $FFFC;
     PacketNak  = $FFFB;
     PacketIll  = $FFFA;

{-------------------------------------------------------------------}
{These are the possible PacketError values}
const
     GoodPacket     = 0;
     ReceiveError   = 1;
     ReceiveOverrun = 2;
     SendOverFlow   = 3;
     SendOverRun    = 4;
     IllegalPacket  = 5;
     BadPacket      = 6;
     ResponseError  = 7;
     NoGoCommand    = 8;
     NoFryers       = 9;
     NoPoll         = 10;
     BadConfig      = 11;
     NoCommand      = 12;

var FIPPrec:FIPPrecType;

{--------------------------------------------------}

function ErrorMsg(ErrorNumber:integer):str255;
function OpenPacketPort(ThisPort,ThisIRQ:word; var FIPPrec:FIPPrecType):boolean;
procedure ClosePacketPort(var FIPPrec:FIPPrecType);
function GetWord(var Pstr:str255; var Value:word):boolean;
function GetLong(var Pstr:str255; var Value:longint):boolean;
function ConvertWord(var Pstr:str255; var Value:word):boolean;
function SendCommand(var FIPPrec:FIPPrecType):boolean;
procedure EnterLabel;
procedure EnterExtLabel;
procedure ConvertLabel(Size:word; CustomSize:word);
function LoadFryers:boolean;

type Str20 = string[20];
const Hex : array[0..15] of char = '0123456789ABCDEF';

function HexW(W:word):str20;

const ErrorCode : integer = 0;
{$IFDEF WIN32}
  const LibHandle : integer = 0;
  var CallFryers : procedure(var FIregs:F_RegsType); stdcall;
{$ENDIF}
{$IFDEF MSDOS}
  procedure CallFryers(var FRegs:F_RegsType);
{$ENDIF}

const BitReverse : array[0..255] of byte = (
   $00,$80,$40,$C0,  {//;00H - 03H}
   $20,$A0,$60,$E0,  {//;04H - 07H}
   $10,$90,$50,$D0,  {//;08H - 0BH}
   $30,$B0,$70,$F0,  {//;0CH - 0FH}
   $08,$88,$48,$C8,  {//;10H - 13H}
   $28,$A8,$68,$E8,  {//;14H - 17H}
   $18,$98,$58,$D8,  {//;18H - 1BH}
   $38,$B8,$78,$F8,  {//;1CH - 1FH}
   $04,$84,$44,$C4,  {//;20H - 23H}
   $24,$A4,$64,$E4,  {//;24H - 27H}
   $14,$94,$54,$D4,  {//;28H - 2BH}
   $34,$B4,$74,$F4,  {//;2CH - 2FH}
   $0C,$8C,$4C,$CC,  {//;30H - 33H}
   $2C,$AC,$6C,$EC,  {//;34H - 37H}
   $1C,$9C,$5C,$DC,  {//;38H - 3BH}
   $3C,$BC,$7C,$FC,  {//;3CH - 3FH}
   $02,$82,$42,$C2,  {//;40H - 43H}
   $22,$A2,$62,$E2,  {//;44H - 47H}
   $12,$92,$52,$D2,  {//;48H - 4BH}
   $32,$B2,$72,$F2,  {//;4CH - 4FH}
   $0A,$8A,$4A,$CA,  {//;50H - 53H}
   $2A,$AA,$6A,$EA,  {//;54H - 57H}
   $1A,$9A,$5A,$DA,  {//;58H - 5BH}
   $3A,$BA,$7A,$FA,  {//;5CH - 5FH}
   $06,$86,$46,$C6,  {//;60H - 63H}
   $26,$A6,$66,$E6,  {//;64H - 67H}
   $16,$96,$56,$D6,  {//;68H - 6BH}
   $36,$B6,$76,$F6,  {//;6CH - 6FH}
   $0E,$8E,$4E,$CE,  {//;70H - 73H}
   $2E,$AE,$6E,$EE,  {//;74H - 77H}
   $1E,$9E,$5E,$DE,  {//;78H - 7BH}
   $3E,$BE,$7E,$FE,  {//;7CH - 7FH}
   $01,$81,$41,$C1,  {//;80H - 83H}
   $21,$A1,$61,$E1,  {//;84H - 87H}
   $11,$91,$51,$D1,  {//;88H - 8BH}
   $31,$B1,$71,$F1,  {//;8CH - 8FH}
   $09,$89,$49,$C9,  {//;90H - 93H}
   $29,$A9,$69,$E9,  {//;94H - 97H}
   $19,$99,$59,$D9,  {//;98H - 9BH}
   $39,$B9,$79,$F9,  {//;9CH - 9FH}
   $05,$85,$45,$C5,  {//;A0H - A3H}
   $25,$A5,$65,$E5,  {//;A4H - A7H}
   $15,$95,$55,$D5,  {//;A8H - ABH}
   $35,$B5,$75,$F5,  {//;ACH - AFH}
   $0D,$8D,$4D,$CD,  {//;B0H - B3H}
   $2D,$AD,$6D,$ED,  {//;B4H - B7H}
   $1D,$9D,$5D,$DD,  {//;B8H - BBH}
   $3D,$BD,$7D,$FD,  {//;BCH - BFH}
   $03,$83,$43,$C3,  {//;COH - C3H}
   $23,$A3,$63,$E3,  {//;C4H - C7H}
   $13,$93,$53,$D3,  {//;C8H - CBH}
   $33,$B3,$73,$F3,  {//;CCH - CFH}
   $0B,$8B,$4B,$CB,  {//;D0H - D3H}
   $2B,$AB,$6B,$EB,  {//;D4H - D7H}
   $1B,$9B,$5B,$DB,  {//;D8H - DBH}
   $3B,$BB,$7B,$FB,  {//;DCH - DFH}
   $07,$87,$47,$C7,  {//;E0H - E3H}
   $27,$A7,$67,$E7,  {//;E4H - E7H}
   $17,$97,$57,$D7,  {//;E8H - EBH}
   $37,$B7,$77,$F7,  {//;ECH - EFH}
   $0F,$8F,$4F,$CF,  {//;F0H - F3H}
   $2F,$AF,$6F,$EF,  {//;F4H - F7H}
   $1F,$9F,$5F,$DF,  {//;F8H - FBH}
   $3F,$BF,$7F,$FF); {//;FCH - FFH}

{-------------------------------------------------------------------}
implementation


{$IFDEF WIN32}
  {this defines the call to the FRYERS32.DLL for static dll load }
  {however, we will use dynamic loading so as to catch the error}
//  procedure CallFryers(var FRegs:F_RegsType); stdcall external 'Fryers32.DLL';
{$ENDIF}

{$IFDEF MSDOS}
  procedure CallFryers(var FRegs:F_RegsType);
  begin
    INTR($14,FRegs);
  end;
{$ENDIF}

function LoadFryers:boolean;
begin
  LoadFryers := false;
  {$IFDEF WIN32}
    if LibHandle > 0 then Exit;
    LibHandle := LoadLibrary('fryers32.dll');
    if LibHandle < 32 then
    begin
      {showmessage('Unable to load fryers32.dll');}
      {ErrorCode := NoFryers;}
      {halt(ErrorCode);}
      Exit;
    end;
    @CallFryers := GetProcAddress(LibHandle,'CallFryers');
    if @CallFryers = nil then
    begin
     { showmessage('Failed to lookup CallFryers');}
      {ErrorCode := NoFryers;}
      {halt(ErrorCode);}
      Exit;
    end;
{$ENDIF}
  LoadFryers := true;
end;

{---------------------------}

function HexW(W:word):str20;
var S:str20;
begin
   S[0] := #4;
   S[1] := Hex[hi(W) shr 4];
   S[2] := Hex[hi(W) and $f];
   S[3] := Hex[lo(W) shr 4];
   S[4] := Hex[lo(W) and $f];
   HexW := S;
end;


  {CONV ASCII # TO BINARY - my own version}
  function Argval(var S; var Index:integer):longint;
  type ByteArray = array[0..255] of byte;
  var Data : ByteArray absolute S;
  var Done : boolean;
  var Value : integer;
  var Work : longint;
  begin
    Done := false;
    Work := 0;
    Index := 0;
    if Data[0] = ord('-') then
      inc(Index);
    while not(Done) do
    begin
      Value := Data[Index]-ord('0');
      if (Value < 0) or (Value > 10) then      
        done := true
      else
      begin
        Work := (Work*10)+Value;
        inc(Index);
      end;  
    end;
    if Data[0] = ord('-') then
      Work := -(Work);
    ArgVal := Work;  
  end;

{-------------------------------------------------------------------}
{returns a string relating to the error encountered}
function ErrorMsg(ErrorNumber:integer):str255;
var Emsg:string[20];
begin
    str(ErrorNumber,Emsg);
    case ErrorNumber of
      GoodPacket     : ErrorMsg := '';
      ReceiveError   : ErrorMsg := 'RECEIVE ERROR';
      ReceiveOverrun : ErrorMsg := 'RECEIVE OVERRUN';
      SendOverFlow   : ErrorMsg := 'SEND OVERFLOW';
      SendOverRun    : ErrorMsg := 'SEND OVERRUN';
      IllegalPacket  : ErrorMsg := 'ILLEGAL PACKET';
      BadPacket      : ErrorMsg := 'BAD PACKET';
      ResponseError  : ErrorMsg := 'RESPONSE ERROR';
      NoGoCommand    : ErrorMsg := 'COMMAND ERROR';
      NoFryers       : ErrorMsg := 'NO COMM DRIVER';
      NoPoll         : ErrorMsg := 'NO POLL';
    else
      ErrorMsg := 'UNKNOWN ERROR: '+Emsg+' ';
    end;
end;

{-------}
function GetPacketTimer(var FIPPrec:FIPPrecType):word;
begin
  FIPPrec.Regs.dx := FIPPrec.comport;
  FIPPrec.Regs.ax := $ff17;
  FIPPrec.Regs.cx := $0300;
  CallFryers(FIPPrec.Regs);
  GetPacketTimer := FIPPrec.Regs.AX;
end;

{-------------------------------------------------------------------}
{returns PacketStatus set to the current packet status value}
{The primary packet status is returned in AL as follows}
{bit 7=bad transfer, 6=no poll, 5=reserved, 4=receive overflow}
{3=send overflow, 2=send overrun, 1=receive ready, 0=send ready}
{See the Fryers manual for a description of other error info}

function PacketStatus(var FIPPrec:FIPPrecType):byte;
begin
   with FIPPrec do
   begin
     regs.ax := $ff13;
     regs.dx := comport; {make sure comport is in range}
     CallFryers(Regs);
     StatAX := regs.ax;
     StatCX := regs.cx;  {save the error status response}
     StatDX := regs.dx;
     StatDI := regs.DI;
     StatSI := regs.SI;
     PacketStatus := regs.al;  {return the primary packet status}
   end;
end;


{-------------------------------------------------------------------}
{checks to see if lost poll from 6500. If so then checks to see if}
{a key has been pressed. If so then returns PacketAbort true.}
function PacketAbort(var FIPPrec:FIPPrecType):boolean;
var Tmp : word;
begin
   PacketAbort := false;
   Tmp := PacketStatus(FIPPrec);
   if (Tmp and $40) = $40 then FIPPrec.PacketError := NoPoll;
   if (Tmp and $80) = $80 then FIPPrec.PacketError := ReceiveError;
   if (Tmp and $C0) <> 0 then PacketAbort := true;
end;

{-------------------------------------------------------------------}
{Checks to see if we are communicating at all}
{returns true if communicating ok, false if no poll being received}
function PollOK(var FIPPrec:FIPPrecType):boolean;
begin
   PollOK := true;
   if (PacketStatus(FIPPrec) and $40) <> $40 then Exit;
   FIPPrec.PacketError := NoPoll;
   PollOK := false;
end;

{-------------------------------------------------------------------}
{Checks on baudrate. If baud rate is wrong, tries to switch}
{the baudrate (if V4.00 Fryers) to see if it will fix the problem.}
procedure AutoBaudCheck(var FIPPrec:FIPPrecType);
var TAX,TBX,TCX,rax,rbx,rcx,rdx:word;
begin
  with FIPPrec do
  begin
    if not(PortOpen) then Exit;
    tcx := 0;
    if Fversion >= $40 then
    begin
      Regs.dx := FIPPrec.comport;
      Regs.bx := 0; {38400}
      Regs.ax := $FF1B;
      CallFryers(Regs);
      Regs.AH := 0;
      tax := Regs.ax;
      tcx := Regs.cx;
    end;
    if (tcx and $0020) <> 0 then
      BaudSeek := true
    else
      BaudSeek := false;
    if BaudSeek then
    begin
      tax := GetPacketTimer(FIPPrec);
      while tax = GetPacketTimer(FIPPrec) do
      if PacketAbort(FIPPrec) then Exit;
    end;
  end;
end;

{-------------------------------------------------------------------}
{Open a comport to begin packet communications through}
{using the specified baudrate. Comport is 0 or 1}
{baudrate is 300, 600, 1200, 2400, 4800, 9600, 19200, or 38400}
{if baudrate is invalid, the default of 9600 is selected}
{returns status of port that is opened (see Fryers manual)}

function OpenPacketPort(ThisPort,ThisIRQ:word; var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     OpenPacketPort := false;
     if ThisPort = 0 then ThisPort := 1;
     comport := pred(ThisPort);
   {$IFDEF MSDOS}
     if ThisPort > 4 then ThisPort := 1;  {limit ioport in msdos to 1-4}
     comport := pred(ThisPort) and 1;   {comport is either 0 or 1 in msdos}
   {$ENDIF}

     regs.ax := $ffff;            {get Fryers version number}
     regs.dx := $0000;            {com 0 default}
     CallFryers(Regs);
     CmdStatus := regs.al;        {return version in CmdStatus}
     PacketError := NoFryers;     {assume fryers not installed}
     if integer(regs.dx and $ffff) <> integer($ffff) then Exit;
     if regs.al < $30 then Exit;  {not in range, so invalid Fryers.com}
     if regs.al > $99 then Exit;  {is not installed}

     PacketError := GoodPacket;   {No error, so clear PacketError}
     Fversion := regs.al;

     regs.ax := $ff00;     {disable fryers interrupt procedure}
     regs.cx := $ff00;     {this makes sure everything is kosher}
     regs.dx := comport; {make sure comport is in range}
     CallFryers(Regs);
     PortOPen := false;

    {$IFDEF MSDOS}
     if (Fversion > $2F) then
     begin
       regs.ax := $ff0a;  {if Fryers supports it, and they are asking}
       regs.ch := $ff;    {for com3 or com4, go select that stuff}
       regs.cl := ThisIRQ;
       regs.dx := comport;
       regs.bx := (pred(ThisPort) shr 1) and $01;
       CallFryers(Regs);

       if regs.ah = $ff then
       begin
         PacketError := BadConfig;
         Exit; {alt uart access failed}
       end;
       UsedIRQ := regs.ah;  {update for real irq used}
     end;
    {$ENDIF}

     regs.ax := $ff00;     {enable fryers interrupt procedure}
     regs.cx := $ffff;
     regs.dx := comport;
     CallFryers(Regs);
     PortOPen := true;

     regs.ax := $00e3;         {default to 9600 if bad value given}
     case baudrate div 10 of
         0 : regs.ax := $00f3; {select autobaud starting at 9600}
     {   30 : regs.ax := $0043;} {init to selected baudrate}
     {   60 : regs.ax := $0063;} {no parity, and one stop bit}
     {  120 : regs.ax := $0083;}
       240 : regs.ax := $00a3;
       480 : regs.ax := $00c3;
       960 : regs.ax := $00e3;
      1920 : regs.ax := $0003;
      3840 : regs.ax := $0023;
      5760 : regs.ax := $0073; {57.6k is a special case 600 (autobaud only)}
     11520 : regs.ax := $0083;
     end;
     if (baudrate mod 10) > 0 then   {if baudrate plus one then set to}
       regs.ax := regs.ax or $0010;  {autobaud starting at that baudrate}
     regs.dx := comport;   {init port baudrate}
     CallFryers(Regs);

     regs.ax := $ff10;     {enable fryers packet protocol}
     regs.cx := $ffff;
     regs.dx := comport;
     CallFryers(Regs);

     regs.ax := $ff17;      {set poll timer}
     regs.cx := $00ff;
     regs.bx := PollTimer;
     regs.dx := comport; {make sure comport is in range}
     CallFryers(Regs);

     regs.ax := $ff17;     {set response timer}
     regs.cx := $01ff;
     regs.bx := 20;         {1.1 second}
     regs.dx := comport; {make sure comport is in range}
     CallFryers(Regs);

     regs.ax := $ff17;     {set rcv timer}
     regs.cx := $02ff;
     regs.bx := 2;         {110ms}
     regs.dx := comport; {make sure comport is in range}
     CallFryers(Regs);

     {if baudrate plus one and V4.10+ then can set to autobaud}
     AutoBaud := false;
     if (baudrate mod 10) > 0 then
     begin

       if (Fversion >= $40) then
       begin
         regs.ax := 1;   {wait till baudrate is found; neg value = failed}
         while (integer(regs.ax) > 0) do
         begin
           regs.ax := $ff1b;
           regs.bx := 0;         {autobaud starting at current baudrate}
           regs.dx := comport;   {init port baudrate}
           CallFryers(Regs);
         end;
         AutoBaud := true;
       end
       else
       begin
         if Fversion < $40 then
           writeln('Error: This version of Fryers does not support autobaud')
         else writeln('Error: Autobaud selected, but unable to find baudrate');
         Exit; {return false if autobaud requested but bad version or baud not found}
       end;
     end;
     if (PacketStatus(FIPPrec) and $01) <> 0 then
       OpenPacketPort := true;
   end;
end;

{-------------------------------------------------------------------}
{Close the specified packet communications com port}

procedure ClosePacketPort(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     regs.ax := $ff00;     {disable fryers}
     regs.cx := $ff00;
     regs.dx := comport;
     CallFryers(Regs);
   end;
end;

{-------------------------------------------------------------------}
{returns PacketReady true if a packet command can be sent, meaning}
{that a response has been received from the previous command}

function PacketReady(var FIPPrec:FIPPrecType):boolean;
begin
   if FIPPrec.AutoBaud then AutoBaudCheck(FIPPrec);
   PacketReady := (PacketStatus(FIPPrec) and $01) = 1;
end;

{-------------------------------------------------------------------}
{returns ReceivePacketOK true if a good packet response was received}

function ReceivePacketOK(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     ReceivePacketOK := true;
     if (PacketStatus(FIPPrec) and $13) <> $03 then
     begin
       ReceivePacketOK := false;
       PacketError := ReceiveError;
       if StatAX and $0010 = $0010 then PacketError := ReceiveOverrun;
       if StatAX and $0040 = $0040 then PacketError := NoPoll;
     end;
   end;
end;

{-------------------------------------------------------------------}
{Waits for PacketReady to be true or an abort situation to occur}
{returns true if Packet it ready. Returns false if aborted.}

function WaitForPacketReady(var FIPPrec:FIPPrecType):boolean;
var done:boolean;
var S: str255;
begin
   repeat
      done := PacketAbort(FIPPrec) or PacketReady(FIPPrec);
     {   if FIPPrec.Regs.AX > 0 then
          write('$'+hexw(FIPPrec.Regs.AX)+' ');}
      if (FIPPrec.PacketError = NoPoll) then
        done := true;
   until done;
   WaitForPacketReady := done;
end;

{-------------------------------------------------------------------}
{Discards any response that might be hanging around}

procedure DiscardResponse(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     regs.ax := $ff16;
     regs.dx := comport;   {make sure comport is in range}
     CallFryers(Regs);
   end;
end;


{-------------------------------------------------------------------}
{Send the command that resides in SendArray. It is assumed that}
{the command has already been placed in the array, and that the}
{packet can be sent immediately (i.e. PacketReady = true) }
{returns SendPacket true if send was OK}

function SendPacket(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     if PacketStatus(FIPPrec) and 1 <> 1 then
     begin
       SendPacket := false;
       PacketError := SendOverRun;
       Exit;
     end;
     regs.ax := $ff11;
     regs.dx := comport;   {make sure comport is in range}
     regs.cx := SendArray[1]+2;    {set array size in words}
   {$IFDEF WIN32}
     regs.bx := integer(@SendArray); {point to win32 cmd array}
   {$ELSE}
     regs.ds := Seg(SendArray);    {point to msdos cmd array}
     regs.bx := Ofs(SendArray);
   {$ENDIF}
     CallFryers(regs); {and send it}
     if regs.ax and $08 = $08 then PacketError := SendOverFlow;
     if regs.ax and $04 = $04 then PacketError := SendOverRun;
     SendPacket := (regs.ax and $0c) = 0;
   end;
end;

{-------------------------------------------------------------------}
{pick up the response and place it in the RcvArray. It is assumed that}
{the response has already been determined to be valid, and that it}
{is ready to be picked up immediately (i.e. ReceivePacketOK = true) }

function GetRcvPacket(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     regs.ax := $ff12;
     regs.dx := comport;   {make sure comport is in range}
     regs.cx := Sizeof(RcvArray) div 2;  {set max array size in words}
   {$IFDEF WIN32}  
     regs.bx := integer(@RcvArray);  {point to win32 rsp array}
   {$ELSE}
     regs.ds := Seg(RcvArray);     {point to msdos response array}
     regs.bx := Ofs(RcvArray);
   {$ENDIF}  
     CallFryers(Regs);
     if (regs.ax and $10) = $10 then PacketError := ReceiveOverrun;
     GetRcvPacket := (regs.ax and $10) = 0;
   end;
end;


{-------------------------------------------------------------------}
{Checks first word in rcvarray for ACK. If ACK returns true,}
{if not returns false.}

function RcvAcknowledge(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     RcvAcknowledge := true;
     if RcvArray[0] = PacketAck then Exit;
     if RcvArray[0] = PacketIll then
       PacketError := IllegalPacket
     else
       PacketError := BadPacket;
   end;
end;

{-------------------------------------------------------------------}
{This sends a command to the 6500 and waits for a response}
{if an abort situation occurs it returns as false, and the}
{error condition is provided in PacketError}

function SendCommand(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     SendCommand := false;
     if not(WaitForPacketReady(FIPPrec)) then Exit;
     DiscardResponse(FIPPrec);
     if not(SendPacket(FIPPrec)) then Exit;
     SendCommand := true;
     if SendArray[0] = $7fff then Exit; {QTerminate has no response}
     SendCommand := false;
     if not(WaitForPacketReady(FIPPrec)) then Exit;
     if not(ReceivePacketOK(FIPPrec)) then Exit;
     if not(GetRcvPacket(FIPPrec)) then Exit;
     SendCommand := true;
   end;
end;


{-------------------------------------------------------------------}
{SetPacket sets various modes and values inside the target machine}
{It returns a true if everything went OK, or false if not and the}
{error information is returned in PacketError.}
{SetPacket assumes that the command is already in SendArray.}

function SetPacket(var FIPPrec:FIPPrecType):boolean;
begin
  SetPacket := false;
  if SendCommand(FIPPrec) then
    if RcvAcknowledge(FIPPrec) then
      SetPacket := true;
end;


{-----------------------------------------------}

function UnHexNib(C:char; var Value:word):boolean;
begin
  UnHexNib := false;
  if (C < '0') or (C > 'F') then Exit;
  if (C > '9') and (C < 'A') then Exit;
  if C > '9' then
    Value := (ord(C) - 7) and $f
  else
    Value := ord(C) and $f;
  UnHexNib := true;
end;

function Unhex(var S:str255; var Value:word):boolean;
var i,V1,V2 : word;
begin
  UnHex := false;
  Value := 0;
  i := 2;
  while i < length(S) do
  begin
     if not(UnHexNib(S[i],V1)) then Exit;
     if not(UnHexNib(S[i+1],V2)) then Exit;
     Value := (Value shl 8)+(V1 shl 4)+V2;
     inc(i,2);
     UnHex := true;
  end;
end;
function UnhexLong(var S:str255; var Value:longint):boolean;
var i,V1,V2 : word;
begin
  UnHexLong := false;
  Value := 0;
  i := 2;
  while i < length(S) do
  begin
    if not(UnHexNib(S[i],V1)) then Exit;
    if not(UnHexNib(S[i+1],V2)) then Exit;
    Value := (Value shl 8)+(V1 shl 4)+V2;
    inc(i,2);
    UnHexLong := true;
  end;
end;

function GetLong(var pstr:str255; var Value:longint):boolean;
var Index : integer;
begin
  GetLong := false;
  Value := 0;
  if length(Pstr) = 0 then Exit;

  if Pstr[1] = '$' then
  begin
    GetLong := UnhexLong(Pstr,Value);
  end
  else
  begin
    if length(Pstr) > 254 then dec(Pstr[0]);
    Pstr[length(Pstr)+1] := #0;
    Value := Argval(Pstr[1],Index);
    if Index = 0 then
      GetLong := false
    else
      GetLong := true;
  end;
end;

function GetWord(var pstr:str255; var Value:word):boolean;
var Index : integer;
begin
  GetWord := false;
  Value := 0;
  if length(Pstr) = 0 then Exit;

  if Pstr[1] = '$' then
  begin
    GetWord := Unhex(Pstr,Value);
  end
  else
  begin
    if length(Pstr) > 254 then dec(Pstr[0]);
    Pstr[length(Pstr)+1] := #0;
    Value := Argval(Pstr[1],Index);
    if Index = 0 then
      GetWord := false
    else
      GetWord := true;
  end;
end;

{-----------------------------------------------}

function ConvertWord(var Pstr:str255; var Value:word):boolean;
var Index : integer;
begin
  Pstr[length(Pstr)+1] := #0;
  Value := Argval(Pstr[1],Index);
  if Index = 0 then
    ConvertWord := false
  else
    ConvertWord := true;
end;


{-----------------------------------------------}
procedure ConvertLabel(Size:word; CustomSize:word);
var i:word;
var k:word;
begin
  with FIPPrec do
  begin
    i := 0;
    while i < Size do
    begin
      SendArray[(i shr 1)+2] := (ord(Lab[succ(i)]) shl 8)+
                                 ord(Lab[i+2]);
      inc(i,2);
    end;
    k := 0;
    while i < (Size+CustomSize) do
    begin
      SendArray[(i shr 1)+2] := (ord(CustomLab[succ(k)]) shl 8)+
                                 ord(CustomLab[k+2]);
      inc(i,2);
      inc(k,2);
    end;
    SendArray[(i shr 1)+2] := 0;
    SendArray[1] := succ(Size+CustomSize) shr 1;
  end;
end;

{-----------------------------------------------}
function EntLab(S:Str255; L:integer):str255;
var s2 : str255;
begin
  write(S,#13);
  s2 := copy(s,1,Length(S)-succ(L));
  write(s2);
  readln(s2);
  s2 := s2+'___________________________';
  if L = 18 then
    s2 := copy(s2,1,18)
  else
    s2 := copy(s2,1,27);
  EntLab := s2;
end;

{-----------------------------------------------}
procedure EnterLabel;    {enter a label (cmd 6)}
var i : integer;
begin
  with FIPPrec do
  begin
    fillchar(Lab,sizeof(Lab),0);
    writeln('Enter Label Information');
    writeln;
    Lab :=       EntLab('       Date:__________________|',18);
    Lab := Lab + EntLab('     Model#:__________________|',18);
    Lab := Lab + EntLab('    Serial#:__________________|',18);
    Lab := Lab + EntLab('      Owner:__________________|',18);
    Lab := Lab + EntLab('   Comments:__________________|',18);
    Lab := Lab + EntLab('C2:___________________________|',27);
    Lab := Lab + EntLab('C3:___________________________|',27);
    Lab := Lab + EntLab('C4:___________________________|',27);
    ConvertLabel(MaxStdLabelSize,0);
  end;
end;

{-----------------------------------------------}
procedure EnterExtLabel;    {enter an extended label (cmd 66)}
var i : integer;
begin
  with FIPPrec do
  begin
    fillchar(Lab,sizeof(Lab),0);
    writeln('Enter Label Information');
    writeln;
    Lab :=       EntLab('L1:___________________________|',27)+#0;
    Lab := Lab + EntLab('L2:___________________________|',27)+#0;
    Lab := Lab + EntLab('L3:___________________________|',27)+#0;
    Lab := Lab + EntLab('L4:___________________________|',27)+#0;
    Lab := Lab + EntLab('L5:___________________________|',27)+#0;
    Lab := Lab + EntLab('L6:___________________________|',27)+#0;
    Lab := Lab + EntLab('L7:___________________________|',27)+#0;
    Lab := Lab + EntLab('L8:___________________________|',27)+#0;
    ConvertLabel(MaxExtLabelSize,0);
  end;
end;


{-----------------------------------------------}
{initialization code}
begin
 {$IFDEF WIN32}
  CallFryers := nil;
 {$ENDIF}
  Fillchar(FIPPrec,sizeof(FIPPrec),0);
  FIPPrec.PollTimer := NormalPoll;
end.


