{ FSunit - Version 5.12  as of 27 Feb 2003 }
{ Copyright 1989,2002 Frye Electronics, Inc. }
{ FSunit is used in conjunction with FBAT}
{ to read FIPP commands from the command line and convert }
{ them to real FIPP commands to send to the FCunit }

unit FSunit;
interface
{$IFDEF MSDOS}
  uses Dos,FCunit;
{$ENDIF}
{$IFDEF WIN32}
  uses FCunit,SysUtils,MMsystem;
  {$APPTYPE CONSOLE}
{$ENDIF}

const FileError = 200;

var f : text;
    fb : file;
    Stmp : str255;
    foname : str255;
    Pnum : byte;
    Tm,Start : integer;

CONST Quiet : boolean = false;
CONST DebugMode : boolean = false;
CONST ShowInt : boolean = false;
CONST Delimit : boolean = false;

procedure RunProgram;

const UsePort : word = 1;
const UseIRQ : word = 0;

const BitMapType : word = 2;
const BitMapXpos : word = 0;
const BitMapYpos : word = 160;
const BitMapDest : word = 0;
var   BitMapSize : longint;

implementation

{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if (ErrorCode > 0) and (ErrorCode <> NoCommand) then
    writeln(ErrorMsg(ErrorCode));
  ExitCode := ErrorCode;
  if FIPPrec.PortOpen then
    ClosePacketPort(FIPPrec);
end;

{$IFDEF WIN32}
  function FSearch(What,Where:Str255):Str255;
  begin
    FSearch := FileSearch(What,Where);
  end;
{$ENDIF}

{$IFDEF MSDOS}
   function timeGetTime:longint;
   var SysTime : longint absolute $40:$6C;
   begin
     timeGetTime := SysTime*55;
   end;

   function inttostr(V:longint):string20;
   var S:string20;
   begin
     str(V,S);
     inttostr := S;
   end;
{$ENDIF}

{------------------------------------------------}
procedure GetLabelFile(what:str255);
var i : integer;
begin
  with FIPPrec do
  begin
    if FSearch(What,'') = '' then
    begin
      writeln('File not found: ',What);
      ErrorCode := FileError;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    assign(f,What);
    reset(f);

    fillchar(Lab,sizeof(Lab),0);
    fillchar(CustomLab,sizeof(CustomLab),0);
    if SendArray[0] = 6 then             {if cmd 6 do old style label}
    begin
      while not(eof(f)) do
      begin
        for i := 1 to 5 do
        begin
          fillchar(Stmp[1],18,'_');
          readln(f,Stmp);
          Stmp[0] := #18;
          Lab := Lab+Stmp;
        end;
        for i := 6 to 8 do
        begin
          fillchar(Stmp[1],27,'_');
          readln(f,Stmp);
          Stmp[0] := #27;
          Lab := Lab+Stmp;
        end;
        Lab := Lab+#0;
      end;
    end
    else if SendArray[0] = 66 then
    begin
      while not(eof(f)) do
      begin
        for i := 1 to 8 do             {otherwise do new style label}
        begin
          fillchar(Stmp[1],27,'_');
          readln(f,Stmp);
          Stmp := Stmp+#0;
          Stmp[0] := #28;
          Lab := Lab+Stmp;
        end;
        if not(eof(f)) then
        begin
          fillchar(Stmp[1],27,' ');    {try for first custom line}
          readln(f,Stmp);
          Stmp := Stmp+#0;
          Stmp[0] := #28;
          CustomLab := Stmp;
        end;
        if not(eof(f)) then
        begin
          fillchar(Stmp[1],27,' ');    {try for second custom line}
          readln(f,Stmp);
          Stmp := Stmp+#0;
          Stmp[0] := #28;
          CustomLab := CustomLab+Stmp;
        end;
      end;
    end
    else
    begin
      writeln('Error: Command format error');
      ErrorCode := NogoCommand;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    Close(f);
    ConvertLabel(length(Lab),length(CustomLab));
  end;
end;


{------------------------------------------------}
{2/27/03 -med fixed bug that caused bad format bmp }
{file (imageSize=0) to cause an exception}
procedure GetLabelBitmapFile(what:str255);
var Err:integer;
begin
  with FIPPrec do
  begin
    if FSearch(What,'') = '' then
    begin
      writeln('File not found: ',What);
      ErrorCode := FileError;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    assign(fb,What);
    reset(fb,1);
    BlockRead(fb,BmpHeader,sizeof(BmpHeader),Err);
    if Err <> sizeof(BmpHeader) then
    begin
      writeln('Error: Bitmap format error');
      ErrorCode := NogoCommand;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;
    Seek(fb,BmpHeader.HeaderSize);
    BitMapSize := BmpHeader.biSizeImage;
    if BitMapSize = 0 then BitMapSize := BmpHeader.Width * BmpHeader.Height div 8;
    if (BitMapSize > (MaxLabelBitmap*2)) then
    begin
      writeln('Error: Bitmap format error (BMP file too big)');
      ErrorCode := NogoCommand;                    {rats, bad size }
      Halt(ErrorCode);
    end;
    if (BmpHeader.Bits <> 1) or (FileSize(fb) <> BmpHeader.FileSize) then
    begin
      writeln('Error: Bitmap format error (it needs to be a monochrome BMP file)');
      ErrorCode := NogoCommand;                    {rats, bad size }
      Halt(ErrorCode);
    end;
    fillchar(LabelBitmap,sizeof(LabelBitmap),0);
    BlockRead(fb,LabelBitmap,BitMapSize,Err);
    if Err <> BitMapSize then
    begin
      writeln('Error: Bitmap format error');
      ErrorCode := NogoCommand;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;
    Close(fb);
  end;
end;

procedure BuildBitmapSendArray;
var Data : word;
var h,w,i,x,y:integer;
var PixelsPerWord:integer;
begin
  with FIPPrec do
  begin
    SendArray[1] := (BitmapSize div 2)+10; {total data size}
    SendArray[2] := BitMapType;  {monochrome} {only monochrom currently supported}
    SendArray[3] := BitMapXpos;  {xpos}
    SendArray[4] := BitMapYpos;  {ypos}
    SendArray[5] := BmpHeader.Width;
    SendArray[6] := BmpHeader.Height;
    SendArray[7] := BitMapDest; {Only the printer can be set with this command right now}
    SendArray[8] := BitMapSize;  {image size in bytes}
    SendArray[9] := 10;

    i := 0;
    if BitMapType = 2 then
      PixelsPerWord := 16 {if monochrome, 16pixels per word}
    else PixelsPerWord := 4; {if color, 4 pixels per word}
    h := BmpHeader.Height;           {convert from bmp format to fp35 bitmap format}
    w := BmpHeader.Width div PixelsPerWord;
    if (h > 0) and (w > 0) then
    begin
      if (BmpHeader.Width mod PixelsPerWord) <> 0 then inc(w);
      for y := 0 to h-1 do
      begin
        for x := 0 to w-1 do
        begin
          Data := LabelBitMap[((h-1-y)*w)+x];
          Data := ((BitReverse[lo(Data)]) + (BitReverse[hi(Data)] shl 8));
          SendArray[10+i] := not(Data);
          inc(i);
        end;
      end;
    end;
  end;
end;


{------------------------------------------------}
procedure GetCmdLineData;
var S:str255;
var i:integer;
begin
  with FIPPrec do
  begin
    if ParamCount-Pnum < SendArray[1] then {assume zero if bad cnt}
    begin
      writeln('Error: Bad command count');
      ErrorCode := NogoCommand;       {urg, not enough data provided}
      Halt(ErrorCode);
    end;
    if SendArray[1] > 0 then             {if more than count of zero}
    begin                                       {get the data passed}
      for i := 1 to Sendarray[1] do
      begin
        S := ParamStr(Pnum+i);
        if not(GetWord(S,SendArray[i+1])) then
        begin
          writeln('Error: Bad data');
          ErrorCode := NogoCommand;      {urg, not enough or invalid}
          Halt(ErrorCode);                            {data provided}
        end;
      end;
    end;
  end;
end;


{------------------------------------------------}
procedure GetCommandFile(what:str255);
var i : integer;
begin
  i := 0;                                 {get the data from a file?}
  if FSearch(What,'') = '' then
  begin
    writeln('File not found: ',What);
    ErrorCode := FileError;                    {rats, didn't find it}
    Halt(ErrorCode);
  end;

  with FIPPrec do
  begin
    assign(f,What);
    reset(f);
    while not(eof(f)) do
    begin
      readln(f,Stmp);
      if Stmp <> '' then                           {ignore blank lines}
      begin
        if not(ConvertWord(Stmp,SendArray[i])) then    {word from file}
        begin
          writeln('Error reading file: ',What);
          ErrorCode := FileError;                {rats, didn't find it}
          Halt(ErrorCode);
        end;
        inc(i);
        if i > 255 then                              {run out of room?}
        begin
          writeln('Overflow reading file: ',What);
          ErrorCode := FileError;                   {rats, didn't work}
          Halt(ErrorCode);
        end;
      end;
    end;
  end;
end;


{----------------------------------------------------------}
{open the rs232 port for operation}
procedure OpenPort;
begin
  if not(OpenPacketPort(UsePort,UseIRQ,FIPPrec)) then
  begin
    writeln('Packet com port not open');
    ErrorCode := NoFryers;                           {ick, no can talk}
    Halt(ErrorCode);
  end;
end;

procedure ClosePort;
begin
  ClosePacketPort(FIPPrec);
end;

{------------------------------------------------}
{process any options that are given}
procedure GetOptions;
var S:str255;
    Err:integer;
begin
   while true do
   begin
      if PNum > ParamCount then Exit;
      Stmp := ParamStr(Pnum);
      if (Stmp[1] <> '-') then Exit;

      if (upcase(Stmp[2]) = 'C') then   {com port given?}
      begin
        if (Stmp[3] >= '0') or (Stmp[3] <= '9') then
        begin
          UsePort := ord(Stmp[3]) and $f;
          if UsePort = 0 then
            UsePort := 1;
          fipprec.comport := pred(UsePort);
         {$IFDEF MSDOS}
           if fipprec.comport > 3 then
           begin
             writeln('Invalid port number selected.');
             Halt(1);
           end;
         {$ENDIF}
        end
        else
        begin
          writeln('Invalid port number selected.');
          Halt(1);
        end;
      end;

    {$IFDEF MSDOS}
      if (upcase(Stmp[2]) = 'I') then   {irq num given?}
      begin
        S := Stmp;
        while ((S[1] < '0') or (S[1] > '9')) and (length(S) > 0) do
          delete(S,1,1);
        while ((s[length(s)] < '0') or
              (s[length(s)] > '9')) and (length(s) > 0) do
          dec(s[0]);
        val(s,UseIRQ,Err);
        if (UseIRQ > 15) or (Err <> 0) or
           not(UseIRQ IN [0,2,3,4,5,7,9,10,11,12,15]) then
        begin
          writeln('Invalid IRQ number given.');
          halt(1);
        end;
      end;
    {$ENDIF}

      if (upcase(Stmp[2]) = 'B') then   {baudrate given?}
      begin
        S := Stmp;
        delete(S,1,2);
        while (length(S) > 0) and (S[1] < ' ') do delete(S,1,1);
        if not(GetLong(S,Fipprec.baudrate)) then
        begin
          writeln('Invalid baudrate given.');
          Halt(1);
        end;
      end;

      if (upcase(Stmp[2]) = 'T') then   {poll timeout given?}
      begin
        S := Stmp;
        delete(S,1,2);
        while (length(S) > 0) and (S[1] < ' ') do delete(S,1,1);
        if not(GetWord(S,Fipprec.PollTimer)) then
        begin
          writeln('Invalid Poll timeout given.');
          Halt(1);
        end;
      end;

      if (upcase(Stmp[2]) = 'F') then   {output filename given?}
      begin
        inc(PNum);
        if PNum > ParamCount then
        begin
          writeln('Invalid or no output filename given.');
          Halt(1);
        end;
        foname := ParamStr(Pnum);       {yes, so pick it up}
      end;

      if (upcase(Stmp[2]) = 'N') then   {integers?}
      begin
        ShowInt := true;
      end;

      if (upcase(Stmp[2]) = 'L') then   {delimit?}
      begin
        Delimit := true;
      end;

      if (upcase(Stmp[2]) = 'Q') then   {quiet?}
      begin
        Quiet := true;
      end;

      if (upcase(Stmp[2]) = 'D') then   {debug?}
      begin
        DebugMode := true;
      end;

      inc(Pnum);
   end;
end;

procedure saveoutput;
var ii:word;
    fo:text;
begin
  assign(fo,'out.raw');
  rewrite(fo);
  for ii := 0 to fipprec.Sendarray[1]+3 do
  begin
    writeln(fo,fipprec.sendarray[ii]);
  end;
  close(fo);
end;

{---------------------------------------------------------------}
{get command to send}
procedure GetCommand;
begin
    Stmp := ParamStr(Pnum);
    if not(GetWord(Stmp,fipprec.SendArray[0])) then   {get the cmd}
      GetCommandFile(Stmp)
    else
    begin
      if ParamCount > Pnum then                   {any data parms given?}
      begin
        inc(Pnum);
        Stmp := ParamStr(Pnum);
        if fipprec.SendArray[0] = 96 then {special case hack for bitmap upload}
        begin
          if not(GetWord(Stmp,BitMapType)) then Exit;  {get the Xpos of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          if not(GetWord(Stmp,BitMapXpos)) then Exit;  {get the Xpos of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          if not(GetWord(Stmp,BitMapYpos)) then Exit;  {get the Ypos of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          if not(GetWord(Stmp,BitMapDest)) then Exit;  {get the dest page of bitmap}
          inc(Pnum);
          Stmp := ParamStr(Pnum);
          GetLabelBitmapFile(StmP);                     {get label bitmap}
          BuildBitmapSendArray;
        end
        else if GetWord(Stmp,fipprec.SendArray[1]) then {valid cmd count number?}
          GetCmdLineData                               {yes, so get data}
        else GetLabelFile(Stmp);                       {else, try for label file}
      end
      else
      begin
        if fipprec.SendArray[0] = 6 then EnterLabel         {get old style label}
        else if fipprec.SendArray[0] = 66 then EnterExtLabel   {get new style label}
        else fipprec.SendArray[1] := 0;                         {default is no data}
      end;
    end;
  if DebugMode then
    SaveOutput;
end;


{------------------------------------------------------------------}
{send the command to outside world}
procedure SendIt;
var i : integer;
var x : longint;
begin
    if not(SendCommand(FIPPrec)) then              {now send the command}
    begin
      Writeln('Error: Packet failed: AX=$',hexw(FIPPrec.StatAX));
      ErrorCode := FIPPrec.PacketError;       {ack, something went wrong}
      Halt(ErrorCode);
    end;

    if fipprec.SendArray[0] = $7fff then Exit; {no response if quick terminate command}

    if ((fipprec.RcvArray[0] and $7fff) <> fipprec.SendArray[0]) and  {we expect an ACK,}
       (fipprec.RcvArray[0] <> PacketAck) then                {or a cmd response}
    begin
      if fipprec.RcvArray[0] = $fffa then
      begin
        writeln('Error: Illegal Command:',fipprec.Sendarray[0]);
        ErrorCode := IllegalPacket;                  {anything else is bad}
        Halt(ErrorCode);
      end
      else
      begin
        writeln('Error: No response');
        ErrorCode := ResponseError;                {anything else is bad}
        Halt(ErrorCode);
      end;
    end;

    if foname <> '' then                         {output filename given?}
    begin
      assign(f,foname);                          {yes, so stick response}
      rewrite(f);                                 {in the specified file}
      for i := 0 to fipprec.RcvArray[1]+1 do
      begin
        if ShowInt = false then
          x := word(fipprec.RcvArray[i])
        else x := smallint(fipprec.RcvArray[i]);
        if (Delimit = true) and (i < fipprec.RcvArray[1]+1) then
          write(f,x,',')
        else writeln(f,x);
      end;
      close(f);
    end;

    if not quiet and (foname = '') then          {show output on screen?}
    begin
      for i := 0 to fipprec.RcvArray[1]+1 do
      begin
        if ShowInt = false then
          x := word(fipprec.RcvArray[i])
          else x := smallint(fipprec.RcvArray[i]);
        if (Delimit = true) and (i < fipprec.RcvArray[1]+1) then
          write(x,',')
        else writeln(x);
      end;
    end;

    if fipprec.SendArray[0] = 33 {GetCmdStatusCmd} then   {always follow up with}
    begin
      if fipprec.RcvArray[2] <> 0 then                    {a verification on cmd}
      begin
        writeln('Error: Bad command');
        ErrorCode := NogoCommand;                {whoops, didn't make it}
      end;
    end;
end;


{-----------------------------------------------}
{command sequence = FBAT cmd count data... }

procedure RunProgram;
begin
  Start := timeGetTime;
  ErrorCode := 255;
  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  if ParamCount < 1 then              {if no parms, tell em how to do it}
  begin
    writeln('FBAT - Version 5.12 as of 29 Jan 2003');
    writeln('Copyright 1989,2003 Frye Electronics, Inc.');
    writeln('Format is: FBAT [-Cn] [-In] [-Tn] [-Bn] [-Q] [-F Rfilename] cmd count data');
    writeln('       or: FBAT [-Cn] [-In] [-Tn] [-Bn] [-Q] [-F Rfilename] Sfilename');
    writeln('       (Items in [] are optional.)');
    writeln(' -C0 or -C1 selects com port number (C0=default)');
    writeln(' -In selects interrupt number (n) if needed (see documentation)');
    writeln(' -Tn selects optional poll timeout delay (n=ms) if needed');
    writeln(' -Bn selects baudrate (n=baudrate) if other than 9600');
    writeln(' -N save data as signed 16bit integers (default is 16bit unsigned)');
    writeln(' -L save data as comma delimited numbers');
    writeln(' -Q selects quiet mode (doesn''t show text on screen)');
    writeln(' -F selects output file for data');
    writeln(' Sfilename optional filename source for commands');
    writeln(' cmd count data : command sequence to send (see documentation)');
    ErrorCode := NoCommand;
    Halt(ErrorCode);
  end;

  PNum := 1;
  UseIRQ := 0;
  UsePORT := 0;
  fipprec.comport := 0;
  fipprec.baudrate := 9600;
  foname := '';

  Tm :=   timeGetTime;
  if DebugMode then
    write('GetOptions: ');
  GetOptions;    {any options given?}
  Tm :=   timeGetTime-Tm;
  if DebugMode then
    writeln(inttostr(TM)+'ms');

  {$IFDEF WIN32}
    if not(LoadFryers) then  {this is only used in 32bit mode}
    begin
      writeln('Fryers32.DLL not found, wrong version, or damaged');
      ErrorCode := NoFryers;
      Halt(ErrorCode);
    end;
  {$ENDIF}


  Tm := timeGetTime;
  if DebugMode then
    write('Open Port: ');
  OpenPort;      {open port for xmission}
  Tm :=   timeGetTime-Tm;
  if DebugMode then
    writeln(inttostr(TM)+'ms');

  Tm := timeGetTime;
  if DebugMode then
    write('Get Command: ');
  GetCommand;    {get the command to send}
  Tm :=   timeGetTime-Tm;
  if DebugMode then
    writeln(inttostr(TM)+'ms');

  Tm := timeGetTime;
  if DebugMode then
    write('Send the command: ');
  SendIt;        {send the command}
  Tm :=   timeGetTime-Tm;
  if DebugMode then
    writeln(inttostr(TM)+'ms');

  Tm := timeGetTime;
  if DebugMode then
    write('Close Port: ');
  ClosePort;
  Tm :=   timeGetTime-Tm;
  if DebugMode then
    writeln(inttostr(TM)+'ms');

  if DebugMode then
    writeln('All done: '+inttostr(timeGetTime-Start)+'ms');

  ErrorCode := 0;   {yeah, we're home free}
end;

end.
