{------------------------------------------------}
procedure GetLabelBitmapFile(what:str255);
var h,w,i,x,y,Size:integer;
var Err:integer;
begin
  with FIPPrec do
  begin
    if FSearch(What,'') = '' then
    begin
      writeln('File not found: ',What);
      ErrorCode := FileError;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    assign(fb,What);
    reset(fb,1);
    BlockRead(fb,BmpHeader,sizeof(BmpHeader),Err);
    if Err <> sizeof(BmpHeader) then
    begin
      writeln('Error: Bitmap format error');
      ErrorCode := NogoCommand;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;
    Seek(fb,BmpHeader.HeaderSize);
    Size := BmpHeader.biSizeImage;
    if (Size > MaxLabelBitmap) or (BmpHeader.Bits <> 1) or (FileSize(fb) <> BmpHeader.FileSize) then
    begin
      writeln('Error: Bitmap format error (it needs to be a monochrome BMP file)');
      ErrorCode := NogoCommand;                    {rats, bad size }
      Halt(ErrorCode);
    end;
    fillchar(LabelBitmap,sizeof(LabelBitmap),0);
    BlockRead(fb,LabelBitmap,Size,Err);
    if Err <> Size then
    begin
      writeln('Error: Bitmap format error');
      ErrorCode := NogoCommand;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;

    SendArray[1] := (Size div 2)+5; {total data size}
    SendArray[2] := 0;  {monochrome}
    SendArray[3] := BmpHeader.Width;
    SendArray[4] := BmpHeader.Height;
    SendArray[5] := 0;  {xpos}
    SendArray[6] := 0;  {ypos}
    SendArray[7] := Size;  {image size in bytes}

    h := BmpHeader.height;           {convert from bmp format to fp35 bitmap format}
    w := (BmpHeader.Width div 32);
    if (BmpHeader.Width mod 32) <> 0 then inc(w);
    for y := 0 to (h*2)-1 do
    begin
      for x := 0 to (w*2)-1 do
      begin
        SendArray[8+i] := LabelBitMap[(((h-1)-y)*w)+x];
        inc(i);
      end;
    end;
    for i := 0 to pred(Size div 2) do
    Close(fb);
  end;
end;

