
{Frye Instrument Packet Protocol interface unit}
{This unit is used to communicate with Frye intstruments}
{that use the packet protocol}
{Copyright 1994,2003 Frye Electronics}
{Version 5.12  Written by Michael Day  3 Dec 2003}
{warning: in 32bit mode integer = 32bits. int 16bit mode, integer = 16bits}

unit TestFIPP;
interface
{$I PLATFORM.INC}
{$IFDEF MSDOS}
  uses TestSubs,FryeBmp,Dos;
  type F_RegsType = Registers;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF PMDOS}
  uses TestSubs,FryeBmp,Dos;
  type F_RegsType = Registers;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF WIN16}
  uses TestSubs,FryeBmp,WinDos;
  type F_RegsType = tRegisters;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF WIN32}
   uses Windows,TestSubs,FryeBmp;
  {$I FRYEREGS.INC}
{$ENDIF}

const INVALID_DATA : word = $8000;
const debug : boolean = false;

const useIOport : word = 0;  {IO port user asked for}
const useIRQ : word = 0;     {IRQ user asked for}

const SwitchCmd : word = 0;   {two byte switch box command}
const SwitchState : byte = 0; {0=switch box cmds off}
const DoMeasureSettleTime : integer = 500;

const StdCurveFrameSize = 88; {std curve frame size in words}
const AudCurveFrameSize = 24; {aud curve frame size in words}
const
     MaxLabelSize     = 172;  {size of std label array (in char)}
     MaxExtLabelSize  = 224;  {size of extened label array (in char)}
     MaxUserIDTextSize = 56;  {size of User ID text array (in char)}
     MaxStatusMsgSize = 128;  {size of status msg (in char) }
     MaxCurveSize     = 256;  {size of largest curve frame (in words)}
     {MaxCurveFrameSize= 89*2;} {curve frame size in bytes}
     MaxSpectrumPos   = 80;   {size of spectrum table in words}
     MaxPhasePos      = 80;   {size of phase table in words}
     MaxBlobPos       = 256;  {max size of a blob array}
     CrvFreq1         = 8;    {pos of first amplitude in curve frame}
  {   MaxVersionPos    = 5; }   {size of version array (in integer)}
   {  VersionSize      = 10*2;} {version array size in bytes}
     MaxIOcurvePos    = 9;    {size of IO curve array (in integer)}
     IOcurveSize      = 10*2; {IOcurve size in bytes}
     ARparamsSize      = 4;    {four words in A/R parameter call}

     DefaultPoll : word = 100;  {normal poll timeout is 5.5 seconds}
     ShortPoll = 100;        {short poll timeout is 5.5 seconds}
     LongPoll  = 2000;       {long poll timeout is 110 seconds}
     AllowedAbortTime = 100; {allow keyboard abort after five seconds}

     SRArrayMax = 1023;    {max send/rcv array size}
     MaxRawSampleData = 16383; {max array size}
     MaxDeviceData = 255; {max device data array size}
     SignalInfoSize = 0;
     MaxAuxData = 2000;

type RealTimeClockRec = packed record
       Milliseconds : WORD;
       Seconds      : BYTE;
       Minutes      : BYTE;
       Hours        : BYTE;
       DayOfWeek    : BYTE;
       Day          : BYTE;
       Month        : BYTE;
       Year         : WORD;
     end;

type SignalInfoRec = packed record
       SampleRate    : word; {1}
       CaptureSize   : word; {2}
       SourceSamples : word; {3}
       RampSamples   : word; {4}
       CouplerSkew   : word; {5}
       ProbeSkew     : word; {6}
       GainA         : word; {7}
       GainB         : word; {8}
       RmsOffsetLeft  : word;{9}
       RmsOffsetRight : word;{10}
       MaxLevelLeft  : word; {11}
       MaxLevelRight : word; {12}
       {V2.12}
       GainIndexA     :word; {13}
       GainIndexB     :word; {14}
       HwGainSelectA  :word; {15}
       HwGainSelectB  :word; {16}
       {V3.20}
       InputLevelA    :word; {17}
       InputLevelB    :word; {18}
       HeadroomA      :word; {19}
       HeadroomB      :word; {20}
     end;

type InstrumentInfoRec = packed record
       Machine : word;
       Version : word;
       Language : word;
       LoaderVersion : word;
       EEromVersion : word;
       SerialNumber : array[0..7] of char; {Frye assigned serial number}
       MfgDate : longint;         {date of maufacture}
       HwCalDate : longint;       {date of Hardware calibration}
       SwCalDate: longint;        {date of Software calibration}
     end;

{Fitting parameters used to pass via RS232 set/get fitparameter}
type FitRecordType = packed record
       FitRule        : smallint;   {FX_Cur.FitRule;}
       ClientAge      : smallint;   {FX_Cur.ClientAge}
       AidGroup       : smallint;   {FX_Cur.AidGroup;}
       AidType        : smallint;   {FX_Cur.AidType;}
       AidCompression : smallint;   {FX_Cur.AidCompression;}
       OutputDevice   : smallint;   {FX_Cur.AU_OutputDevice;}
       SpeakerLoc     : smallint;   {HD_SpeakerLoc;}
       AidChannels    : smallint;   {HD_AidChannels;}
       AidLimiting    : smallint;   {HD_AidLimiting;}
       AidFitType     : smallint;   {HD_FitType;}
       AidVentType    : smallint;   {HD_AidVent;}
       AidTubingType  : smallint;   {HD_AidTubing;}
     end;

type LongDeviceIDRec = packed record
       Family : BYTE;
       Serial : array[0..5] of BYTE;
       Crc : BYTE;
     end;

type AvgFreqValuesRec = packed record
       F1 : word;
       F2 : word;
       F3 : word;
       D1 : word;
       D2 : word;
       D3 : word;
     end;

type SendArrayType = array[0..SRArrayMax] of word;
     RcvArrayType  = array[0..SRArrayMax] of word;
     LabelDataType = array[0..172] of char;
     ExtLabelDataType = array[0..224] of char;
     UserIDTextType = array[0..56] of char;
     StatusMsgType = array[0..128] of char;
     SpectrumArrayType = array[0..79] of smallint;
     PhaseArrayType = array[0..79] of word;
     BlobArrayType = array[0..1023] of word;
     OptionArrayType  = array[0..63] of word;
     VersionArrayType = array[0..16] of word;
     LevelingListType = array[0..200] of word;
     ARparamsType = array[0..ARparamsSize] of word;
     RawSampleDataType = array[0..MaxRawSampleData] of smallint;
     RawSampleDataPtr = ^RawSampleDataType;
     DeviceDataType = array[0..MaxDeviceData] of word;
     DeviceDataPtr = ^DeviceDataType;
     AuxDataType = array[0..MaxAuxData] of char;
     AuxDataPtr = ^AuxDataType;

     FIPPrecType = packed record  {1131 bytes}
        Fversion    : word;     {fryers long version number}
        Verify      : boolean;  {verify cmds with cmd stat chk}
        DoubleCheck : boolean;  {double check set values}
        QuickTerm   : boolean;
        Autobaud    : boolean;
        BaudSeek    : boolean;
        PortOpen    : boolean;
        AGCaid      : boolean;  {aid type}
        UseAvgFreqValues : boolean; {true = refer to avg/dist freq values not selection}
        CmdStatusFailed : boolean;
          TrueBaudRate: longint; {actual baud rate being used}
          IRQnum      : array[0..3] of byte;
          BaseAdr     : word;
          Comport     : word;   {16bit: Comport=0 or 1, 32bit: Comport=0->15}
          Baudrate    : word;   {operating baudrate}
          RcvTimeout  : word;   {instrument receive timeout}
          PollDelay   : word;   {poll delay time}
          PollTimer   : word;   {poll timeout tick count}
          RespTimer   : word;   {response timeout tick count}
          PacketError : word;   {packet comm error number}
          StatAX      : word;   {PacketStatus extended status info}
          StatBX      : word;
          StatCX      : word;
          StatDX      : word;
          AbortTime   : word;
          RealPollTime : word;
          PacketTickTimeMS : word;
          PacketTickMultMS : word;
        CmdStatus       : Smallint;  {result of last cmdstatus check}
        RelAttState     : Smallint;
        RelAttFreq      : Smallint;
        AttackTime      : Smallint;  {storage area for 6500 data}
        ReleaseTime     : Smallint;
          BatteryCurrent : Smallint;
          BatteryType    : Smallint;
          BatteryVolt    : Smallint;
          BatteryImp     : Smallint;
        DistMode    : Smallint;
        DistPercent : Smallint;
          Frequency  : Smallint;
          SourceAmp  : Smallint;
          MicData    : Smallint;
          RefMicData : Smallint;
          AvgMicAmp  : Smallint;
          LimitValue : Smallint;
         AvgStartTime   : Smallint;
         AvgSettleTime  : Smallint;
        SettleType       : Smallint; {0=old style, 1=new style}
        FreqSettleTime   : Smallint;
        AmpSettleTime    : Smallint;
        MeasureStartTime : Smallint;
         MeasureMicData    : Smallint;
        LevelState    : Smallint;
        GainState     : Smallint;
        WeightState   : Smallint;
        SmoothState   : Smallint;
        ProbeState    : Smallint;
        TelCoilState  : Smallint;
        TelCoilMode   : Smallint;
        OESstate      : Smallint;
        CICstate      : Smallint;
        ZetaState     : Smallint;
        AutoState     : Smallint;
        OpState       : Smallint;
        RefMicState   : Smallint;
        TestEar       : Smallint;
        EarConfig     : Smallint;
         ControlLock  : Smallint;
         KeyScanCode  : Smallint;
        AvgFreqs   : Smallint;
        OutputDevice : Smallint;
        CurveSelect : Smallint;
        CurveStatus : Smallint;
        UnaidedSelect : Smallint;
        SystemDelay : word;
        HearingAidDelay : word;
          FitRule : Smallint;
          FilterType : Smallint;
          Compression : Smallint;
          ClientAge   : Smallint;
       { SettleTime : Smallint;}
        {DefaultLabelType : Smallint;}
        PrinterType : word;
        PrinterLabelStorage : word;
          WarbleSelect : Smallint;
          WarbleAmount : Smallint;
          WarbleRate : Smallint;
          BiasToneSize : Smallint;
          BiasToneSource : Smallint;
          BiasToneFrequency : Smallint;
          BiasToneDuration : Smallint;
        MajorMachineState : Smallint;
        MinorMachineState : Smallint;
        ActiveStatus      : Smallint;
        PowerStatus       : Smallint;
        StandbyTimeout    : Smallint;
        PowerDownTimeout  : Smallint;
        PrintType         : Smallint;
        PrintFeeds        : Smallint;
         PowerVoltage : Smallint;
         PowerFlags   : word;
        ImpulseRej   : Smallint;
          RefTestGain   : Smallint;
          EqInNoise     : Smallint;
          NoiseRedCount : Smallint;
            FAvgF1    : Smallint;     {the three frequencies}
            FAvgF2    : Smallint;     {HFA/SPA averaging}
            FAvgF3    : Smallint;
           HFAData    : Smallint;     {HFA measurment data}
          IOState       : Smallint;
          IOFrequency   : Smallint;
          IOGain        : Smallint;
         BlobSize   : word;
         OptionSize : word;
         LabelType  : word;
         DeviceIDCount : word;
         DeviceIDNumber : word;
         DeviceSelection : word;
         DeviceDataSize : word;
         RawDataSelection : word;
         RawSampleCount : word;
         RawDataMethod : word;
         RawSamplePacketSize : word;
         AuxInCount : word;
         AuxOutCount : word;
         AuxCtrl      : word;
         AuxStartCtrl : word;
         AuxEndCtrl   : word;
          UserNumber : Smallint;
          MaxUser    : Smallint;
        StaticToneSelect : Smallint;
        AidTypeSelect : Smallint;
        TransducerLoc : Smallint;
        CurveNumber : Smallint;
        CurveFrameSize : Smallint;
        CurveFrame : array [0..MaxCurveSize] of smallint; {the curve frame from 6500}
        IOcurve    : array [0..9] of smallint;
        Insitu     : array [0..2] of word;   {type of Insitu conversion}
        WhichLevelingList : word;
        LevelingListSize : word;
        LevelingList : LevelingListType;
        Version    : VersionArrayType;
        LabelData  : LabelDataType;   {array to place label data in}
        ExtLabelData  : ExtLabelDataType; {array to place ext label data in}
        UserIDText : array[0..15] of UserIDTextType; {UserID text arrays (one per user, 16 max)}
        RealTimeClockData : RealTimeClockRec; {array to place real time clock data}
        InstrumentInfo : InstrumentInfoRec;   {record of instrument information}
        AvgFreqValues : AvgFreqValuesRec; {record of averaging freqs and dist freqs}
        SignalInfoSize : word;
        SignalInfo : SignalInfoRec;   {record of signal info data}
        StatusMsg  : StatusMsgType;   {array to place status msg in}
        SendArray  : SendArrayType;   {Array to place commands in}
        RcvArray   : RcvArrayType;    {Array to place response in}
        Spectrum   : SpectrumArrayType; {array to put spectrum data in}
        PhaseTable : PhaseArrayType;  {array to put phase data in}
        Blob       : BlobArrayType;   {array to stuff blob data in}
        Fit        : FitRecordType;   {record to stuff fit info into}
        Options    : OptionArrayType; {array to stuff option data in}
        ARparams   : ARparamsType;    {array for attack and release parameters}
        LongDeviceID : LongDeviceIDRec; {array to stuff long device ID in}
        Regs : F_RegsType;               {used to process via INTR}
     end;

{-------}
{These are the current possible FIPP commands that are available}
{state=target is in a condition where other commands are affected}
{example: probestate=on means that only probe cmds will work}
{mode=an option under which a specific function changes operation}
{example:distortion mode=0 only affects how distortion is measured}
const
     SetSourceAmpCmd     = 0;
     SetDistModeCmd      = 1;
     SetFrequencyCmd     = 2;
     SetOESstateCmd      = 3;
     SetNoiseRedCountCmd = 4;
     SetSmoothStateCmd   = 5;
     SetLabelCmd         = 6;
     SetProbeStateCmd    = 7;
     SetWeightStateCmd   = 8;
     SetCurveFrameCmd    = 9;
     SetIOmodeCmd        = 10;
     SetTelCoilStateCmd  = 11;
     SetGainStateCmd     = 12;
     DoRelAttSelectCmd   = 13;
     DoBatteryCmd        = 14;
     DoIOSelectCmd       = 15;
     DoTestCmd           = 16;
     DoLevelCmd          = 17;
     GetRelAttDataCmd    = 18;
     GetBatteryCmd       = 19;
     GetIOdataCmd        = 20;
     GetSourceAmpCmd     = 21;
     GetDistModeCmd      = 22;
     GetFrequencyCmd     = 23;
     GetOESstateCmd      = 24;
     GetCurveFrameCmd    = 25;
     GetNoiseRedCountCmd = 26;
     GetSmoothStateCmd   = 27;
     GetDevVersionCmd    = 28;
     GetLevelingStatusCmd= 29;
     GetWeightStateCmd   = 30;
     GetMicDataCmd       = 31;
     GetDistPercentCmd   = 32;
     GetCmdStatusCmd     = 33;
     GetIOmodeCmd        = 34;
     GetProbeStateCmd    = 35;
     GetGainStateCmd     = 36;
     GetTelCoilStateCmd  = 37;
     DoResetCmd          = 38;
     SetTelCoilModeCmd   = 39;
     SetRelAttFreqCmd    = 40;
     GetRelAttFreqCmd    = 41;
     GetLastCurveCmd     = 42;
     SetZetaStateCmd     = 43;
     GetTelCoilModeCmd   = 44;
     GetZetaStateCmd     = 45;
     GetInsituCmd        = 46;
     SetInsituCmd        = 47;
     SetAutoStateCmd     = 48;
     GetAutoStateCmd     = 49;
     SetLimitValueCmd    = 50;
     GetLimitValueCmd    = 51;
     SetRefMicStateCmd   = 52;
     GetRefMicStateCmd   = 53;
     SetActiveStatusCmd  = 54;
     GetActiveStatusCmd  = 55;
     DoSleepCmd          = 56; {6500 only}
     GetRefMicDataCmd    = 57;
     GetKeyScanCodeCmd   = 58;
     SetMachineStateCmd  = 59;
     GetMachineStateCmd  = 60;
     GetBlobCmd          = 61;
     SetControlLockCmd    = 62;
     GetControlLockCmd    = 63;
     DoLineFeedsCmd      = 64;
     DoPrintCmd          = 65;
     SetExtendedLabelCmd = 66;
     DoErrorCmd          = 67;
     SetSpectrumCmd      = 68;
     SetPhaseTableCmd    = 69;
     SetOptionParamsCmd  = 70;
     GetOptionParamsCmd  = 71;
     SetKeyScanCodeCmd   = 72;
     SetPollDelayCmd     = 73;
     GetPollDelayCmd     = 74;
     SetTestEarCmd       = 75;  {fp40}
     GetTestEarCmd       = 76;  {fp40}
     SetOpStateCmd       = 77;  {fp40}
     GetOpStateCmd       = 78;  {fp40}
     DoPowerCmd          = 56;  {fp40}
     SetBatteryTypeCmd   = 79;  {fp40}
     GetPowerStatusCmd   = 80;  {fp40}
     GetAvgFreqsCmd      = 81;
     SetAvgFreqsCmd      = 82;
     GetSettleTimeCmd    = 83;
     SetSettleTimeCmd    = 84;
     GetExtendedLabelCmd = 86;
     GetCICstateCmd      = 87;
     SetCICstateCmd      = 88;
     SetPrinterLabelStorageCmd = 89;
     {SetDefaultLabelCmd  = 89;}
     DoMeasurementCmd    = 85;  {6500 v4.14}
     SetAvgDelayCmd      = 90;  {6500 v4.14}
     GetAvgDelayCmd      = 91;  {6500 v4.14}
     SetPrinterTypeCmd   = 92;  {6500 v4.20}
     GetPrinterTypeCmd   = 93;  {6500 v4.20}
     GetHFAMeasurementCmd = 94; {6500 V4.40}

     GetInstrumentInfoCmd      = 95;  {FP35 V2.00}
     SetPrinterLabelBitMapCmd  = 96;  {FP35 V1.10}
     SetARparamsCmd             = 97;  {6500 V4.50}
     GetARparamsCmd             = 98;  {6500 V4.50}
     SetBlobCmd                = 99;  {FP35 V1.21}
     GetDeviceIDCountCmd       = 100; {FP35 V1.00}
     GetLongDeviceIDCmd        = 101; {FP35 V1.00}
     GetDeviceDataCmd          = 102; {FP35 V1.20}
     GetRealTimeClockCmd       = 103; {FP35 V1.10}
     SetRealTimeClockCmd       = 104; {FP35 V1.10}
     GetOutputDeviceCmd        = 105; {FP35 V2.00/V2.20enh}
     SetOutputDeviceCmd        = 106; {FP35 V2.00/V2.20enh}
     GetImpulseRejCmd          = 107; {FP35 V2.00}
     SetImpulseRejCmd          = 108; {FP35 V2.00}
     GetSignalInfoCmd          = 109; {FP35 V2.00}
     GetRawSampleDataCmd       = 110; {FP35 V1.10}
     SetCurveSelectCmd         = 112; {FP35 V2.00}
     GetCurveSelectCmd         = 113; {FP35 V2.00}
     SetCurveStatusCmd         = 114; {FP35 V2.00}
     GetCurveStatusCmd         = 115; {FP35 V2.00}
     SetUnaidedSelectCmd       = 116; {FP35 V2.00}
     GetUnaidedSelectCmd       = 117; {FP35 V2.00}
     SetStaticToneSelectCmd    = 121; {FP35 V2.10}
     GetStaticToneSelectCmd    = 122; {FP35 V2.10}
     SetAidTypeSelectCmd       = 123; {FP35 V2.10}
     GetAidTypeSelectCmd       = 124; {FP35 V2.10}
     SetBiasToneCmd            = 125; {future}
     GetBiasToneCmd            = 126; {future}
     {cmd 127 <reserved>}
     {cmd 128 <reserved>}
     SetWarbleSelectCmd       = 129; {FP35 V2.20}
     GetWarbleSelectCmd       = 130; {FP35 V2.20}
     GetMeasurmentDelaysCmd   = 131; {6500 V4.72}
     SetRcvTimeoutCmd        = 132;
     GetRcvTimeoutCmd        = 133;
     SetFitRuleCmd          = 134;  {FP35 V2.30}
     GetFitRuleCmd          = 135;  {FP35 V2.30}
     SetFilterCmd        = 136;  {FP35 V3.00}
     GetFilterCmd        = 137;  {FP35 V3.00}
     SetCompressionCmd   = 138;  {FP35 V3.00}
     GetCompressionCmd   = 139;  {FP35 V3.00}
     SetClientAgeCmd     = 140;  {FP35 V3.00}
     GetClientAgeCmd     = 141;  {FP35 V3.00}
     SetTransducerLocCmd = 142;  {FP35 V3.10}
     GetTransducerLocCmd = 143;  {FP35 V3.10}
     SetLevelingListCmd = 145;  {FP35 V3.20}
     GetLevelingListCmd = 146;  {FP35 V3.20}
     SetLevelingStatusCmd = 147;  {FP35 V3.20}
     SetAuxPortCmd = 148;        {FP35 V3.20}
     GetAuxPortCmd = 149;        {FP35 V3.20}
     SetUserNumberCmd = 150;        {FP35 V3.20}
     GetUserNumberCmd = 151;        {FP35 V3.20}

     SetFitTypeCmd = 152;        {fp35 V3.20}
     GetFitTypeCmd = 153;        {fp35 V3.20}
     SetVentTypeCmd = 154;       {fp35 V3.20}
     GetVentTypeCmd = 155;       {fp35 V3.20}
     SetTubingTypeCmd = 156;     {fp35 v3.20}
     GetTubingTypeCmd = 157;     {fp35 V3.20}
     SetAidChannelsCmd = 158;    {fp35 V3.20}
     GetAidChannelsCmd = 159;    {fp35 V3.20}
     SetAidLimitingCmd = 160;    {fp35 V3.20}
     GetAidLimitingCmd = 161;    {fp35 V3.20}

     SetFitParamCmd = 164;       {fp35 v3.20}
     GetFitParamCmd = 165;       {fp35 v3.20}

     SetUserIDTextCmd = 166;     {FP35 V3.20}
     GetUserIDTextCmd = 167;     {FP35 V3.20}

     QuickTerminateCmd   = $7fff;

{-------}
{These are the possible unsolicited FIPP responses}
const
     PacketPoll = $FFFF;
     PacketAck  = $FFFC;
     PacketNak  = $FFFB;
     PacketIll  = $FFFA;

{-------}
{These are the possible PacketError values}
const
     GoodPacket     = 0;
     ReceiveError   = 1;
     ReceiveOverrun = 2;
     SendOverFlow   = 3;
     SendOverRun    = 4;
     ILLegalPacket  = 5;
     BadPacket      = 6;
     ResponseError  = 7;
     NoGoCommand    = 8;
     NoFryers       = 9;
     NoPoll         = 10;
     BadFryers      = 11;
     UserAbort      = $ff;


{-------}
const DefaultPollTimer : integer = 100;  {100=5.5seconds - 55ms ticks}

{-------}
var FIPPrec : FIPPrecType;
    ch : char;
var DeviceDataArray : DeviceDataPtr; {array to stuff device data in}
var RawSampleData : RawSampleDataPtr; {array to stuff raw sample data}
var AuxInData: AuxDataPtr; {array to stuff raw aux data}
var AuxOutData: AuxDataPtr; {array to stuff raw aux data}

{++++++++++++++++++++++++++++++++++++++++++++++++++}
{Open a comport to begin packet communications through}
{using the specified baudrate. IOport is 1, 2, 3 or 4}
{IRQn is 0 to 15. 0 causes default IRQ to be used}
{baudrate is 9600, 19200, or 38400}
{returns true if port is opened. If the port could not be opened}
{ (such as Fryers not being loaded) returns false.}

function OpenPacketPort(var FIPPrec:FIPPrecType; IOPort,IRQn:word):boolean;

{-------}
{ClosePacketPort is the opposite of OpenPacketPort. It closes the }
{port, returning it to normal operation. No error condition returned.}

procedure ClosePacketPort(var FIPPrec:FIPPrecType);

{-------}
{returns PacketStatus set to the current packet status value}
{7=bad transfer, 6=no poll, 5=reserved, 4=receive overflow}
{3=send overflow, 2=send overrun, 1=receive ready, 0=send ready}

function PacketStatus(var FIPPrec:FIPPrecType):byte;


{-------}
{returns PacketReady true if a packet command can be sent, meaning}
{that a response has been received from the previous command}

function PacketReady(var FIPPrec:FIPPrecType):boolean;


{-------}
{returns ReceivePacketOK true if a good packet response was received}

function ReceivePacketOK(var FIPPrec:FIPPrecType):boolean;


{-------}
{Send the command that resides in SendArray.}
{returns SendPacket true if send was OK}

function SendPacket(var FIPPrec:FIPPrecType):boolean;


{-------}
{Get the response that resides in RcvArray.}
{returns GetRcvPacket true if response is OK}

function GetRcvPacket(var FIPPrec:FIPPrecType):boolean;

{-------}
{This skips the next poll that occurs. This is used to ignore}
{a poll following a Set cmd in order to give the target time to}
{perform a measurement. Skip2Polls skips two polls instead of one.}

procedure SkipPoll(var FIPPrec:FIPPrecType);
procedure Skip2Polls(var FIPPrec:FIPPrecType);

{-------}
{Same thing as SkipPoll, but returns true if poll was skipped}
{returns false if no poll was skipped (110ms time out).}

function BSkipPoll(var FIPPrec:FIPPrecType):boolean;

{-------}
{get or set poll or response timeout values}

procedure SetPollTimer(var FIPPrec:FIPPrecType);
procedure GetPollTimer(var FIPPrec:FIPPrecType);
procedure SetRespTimer(var FIPPrec:FIPPrecType);
procedure GetRespTimer(var FIPPrec:FIPPrecType);

{-------}
{This sends a command to the 6500 and waits for a response}
{if an abort situation occurs it returns as false, and the}
{error condition is provided in PacketError}
function SendCommand(var FIPPrec:FIPPrecType):boolean;

{-------}
{Checks to see if we are communicating at all}
function PollOK(var FIPPrec:FIPPrecType):boolean;

{-------}
{returns a string relating to the error encountered}
function FIPPerrorMsg(ErrorNumber:integer):str255;

{-------}
{checks to see if lost poll from 6500. }
{If so then returns PacketAbort true.}
function PacketAbort(var FIPPrec:FIPPrecType):boolean;

{-------}
{Discards any response that might be hanging around}
procedure DiscardResponse(var FIPPrec:FIPPrecType);

{------}
{sends wake up signal to instrument}
function SendWakeup(var Signal; var FIPPrec:FIPPrecType):boolean;

{------}
{send a byte of data out serial port}
function SendByte(What:byte; var FIPPrec:FIPPrecType):byte;

{------}
{update fryers info - updates the version info for fryers and the baud rate in use}
procedure UpdateFryersInfo(var FIPPrec:FIPPrecType);

{test if quick terminate function is on}
function QTon(var FIPPrec:FIPPrecType):boolean;

{enable or disable automatic QT}
procedure AutoQT(FIPPrec:FIPPrecType; QuickTerm:boolean);

{check if need to update the baudrate}
procedure AutoBaudCheck(var FIPPrec:FIPPrecType);

{set external switch box command}
procedure ExternalSwitch(State:byte; Cmd:word; var FIPPrec:FIPPrecType);

{+++++++++++++++++++++++}
{these are the high-level functions to communicate to the tester}
{all data is passed in FIPPrec. Set cmds should preset the proper}
{variable before issuing a command. Get cmds will return the requested}
{information in the appropriate variable. Do cmds will cause the tester}
{to perform the requested action. If Verify is on the tester is polled}
{to see if it accepted the cmd. If DoubleCheck is on the resulting value}
{in the tester after a set cmd is reloaded back into the appropriate}
{variable. All commands return true if everything went ok. All commands}
{return false if a problem occured. The specific error can be found}
{in PacketError. If needed, further information on the error can be}
{found in StatAX, StatCX, and StatDX.}

function SetSourceAmp(var FIPPrec:FIPPrecType):boolean;      {0}
function SetDistMode(var FIPPrec:FIPPrecType):boolean;       {1}
function SetFrequency(var FIPPrec:FIPPrecType):boolean;      {2}
function SetOESstate(var FIPPrec:FIPPrecType):boolean;       {3}
function SetNoiseRedCount(var FIPPrec:FIPPrecType):boolean;  {4}
function SetSmoothState(var FIPPrec:FIPPrecType):boolean;    {5}
function SetLabel(var FIPPrec:FIPPrecType):boolean;          {6}
function SetProbeState(var FIPPrec:FIPPrecType):boolean;     {7}
function SetWeightState(var FIPPrec:FIPPrecType):boolean;    {8}
function SetCurveFrame(var FIPPrec:FIPPrecType):boolean;     {9}
function SetIOmode(var FIPPrec:FIPPrecType):boolean;         {10}
function SetTelCoilState(var FIPPrec:FIPPrecType):boolean;   {11}
function SetGainState(var FIPPrec:FIPPrecType):boolean;      {12}
function SetTelCoilMode(var FIPPrec:FIPPrecType):boolean;    {39}
function SetRelAttFreq(var FIPPrec:FIPPrecType):boolean;     {40}
function SetZetaState(var FIPPrec:FIPPrecType):boolean;      {43}
function SetInsitu(var FIPPrec:FIPPrecType):boolean;         {47}
function SetAutoState(var FIPPrec:FIPPrecType):boolean;      {48}
function SetLimitValue(var FIPPrec:FIPPrecType):boolean;     {50}
function SetRefMicState(var FIPPrec:FIPPrecType):boolean;    {52}
function SetActiveStatus(var FIPPrec:FIPPrecType):boolean;   {54}
function SetMachineState(var FIPPrec:FIPPrecType):boolean;   {59}
function SetControlLock(var FIPPrec:FIPPrecType):boolean;     {62}
function SetExtendedLabel(var FIPPrec:FIPPrecType):boolean;  {66}
function SetSpectrum(var FIPPrec:FIPPrecType):boolean;       {68}
function SetPhaseTable(var FIPPrec:FIPPrecType):boolean;     {69}
function SetOptionParams(var FIPPrec:FIPPrecType):boolean;   {70}
function SetKeyScanCode(var FIPPrec:FIPPrecType):boolean;    {72}
function SetPollDelay(var FIPPrec:FIPPrecType):boolean;      {73}
function SetOpState(var FIPPrec:FIPPrecType):boolean;        {77} {fp40}

function DoRelAttSelect(var FIPPrec:FIPPrecType):boolean;    {13}
function DoBattery(var FIPPrec:FIPPrecType):boolean;         {14}
function DoIOSelect(var FIPPrec:FIPPrecType):boolean;        {15}
function DoTest(var FIPPrec:FIPPrecType):boolean;            {16}
function DoLevel(var FIPPrec:FIPPrecType):boolean;           {17}
function DoReset(var FIPPrec:FIPPrecType):boolean;           {38}
function DoSleep(var FIPPrec:FIPPrecType):boolean;           {56}
function DoLineFeeds(var FIPPrec:FIPPrecType):boolean;       {64}
function DoPrint(var FIPPrec:FIPPrecType):boolean;           {65}
function DoError(var FIPPrec:FIPPrecType):boolean;           {67}

function GetRelAttData(var FIPPrec:FIPPrecType):boolean;     {18}
function GetBattery(var FIPPrec:FIPPrecType):boolean;        {19}
function GetIOdata(var FIPPrec:FIPPrecType):boolean;         {20}
function GetSourceAmp(var FIPPrec:FIPPrecType):boolean;      {21}
function GetDistMode(var FIPPrec:FIPPrecType):boolean;       {22}
function GetFrequency(var FIPPrec:FIPPrecType):boolean;      {23}
function GetOESstate(var FIPPrec:FIPPrecType):boolean;       {24}
function GetCurveFrame(var FIPPrec:FIPPrecType):boolean;     {25}
function GetNoiseRedCount(var FIPPrec:FIPPrecType):boolean;  {26}
function GetSmoothState(var FIPPrec:FIPPrecType):boolean;    {27}
function GetDevVersion(var FIPPrec:FIPPrecType):boolean;     {28}
function GetLevelState(var FIPPrec:FIPPrecType):boolean;     {29}
function GetWeightState(var FIPPrec:FIPPrecType):boolean;    {30}
function GetMicData(var FIPPrec:FIPPrecType):boolean;        {31}
function GetDistPercent(var FIPPrec:FIPPrecType):boolean;    {32}
function GetCmdStatus(var FIPPrec:FIPPrecType):boolean;      {33}
function GetIOmode(var FIPPrec:FIPPrecType):boolean;         {34}
function GetProbeState(var FIPPrec:FIPPrecType):boolean;     {35}
function GetGainState(var FIPPrec:FIPPrecType):boolean;      {36}
function GetTelCoilState(var FIPPrec:FIPPrecType):boolean;   {37}
function GetRelAttFreq(var FIPPrec:FIPPrecType):boolean;     {41}
function GetLastCurve(var FIPPrec:FIPPrecType):boolean;      {42}
function GetTelCoilMode(var FIPPrec:FIPPrecType):boolean;    {44}
function GetZetaState(var FIPPrec:FIPPrecType):boolean;      {45}
function GetInsitu(var FIPPrec:FIPPrecType):boolean;         {46}
function GetAutoState(var FIPPrec:FIPPrecType):boolean;      {49}
function GetLimitValue(var FIPPrec:FIPPrecType):boolean;     {51}
function GetRefMicState(var FIPPrec:FIPPrecType):boolean;    {53}
function GetActiveStatus(var FIPPrec:FIPPrecType):boolean;   {55}
function GetRefMicData(var FIPPrec:FIPPrecType):boolean;     {57}
function GetKeyScanCode(var FIPPrec:FIPPrecType):boolean;    {58}
function GetMachineState(var FIPPrec:FIPPrecType):boolean;   {60}
function GetBlob(var FIPPrec:FIPPrecType):boolean;           {61}
function GetControlLock(var FIPPrec:FIPPrecType):boolean;     {63}
function GetOptionParams(var FIPPrec:FIPPrecType):boolean;   {71}
function GetPollDelay(var FIPPrec:FIPPrecType):boolean;      {74}

function SetTestEar(var FIPPrec:FIPPrecType):boolean;        {75}  {fp40}
function GetTestEar(var FIPPrec:FIPPrecType):boolean;        {76}  {fp40}
function DoPower(var FIPPrec:FIPPrecType):boolean;           {56}  {fp40}
function GetOpState(var FIPPrec:FIPPrecType):boolean;        {78}  {fp40}
function SetBatteryType(var FIPPrec:FIPPrecType):boolean;    {79}  {fp40}
function GetPowerStatus(var FIPPrec:FIPPrecType):boolean;    {80}  {fp40/fp35}

function GetAvgFreqs(var FIPPrec:FIPPrecType):boolean;       {81}
function SetAvgFreqs(var FIPPrec:FIPPrecType):boolean;       {82}
function GetSettleTime(var FIPPrec:FIPPrecType):boolean;     {83}
function SetSettleTime(var FIPPrec:FIPPrecType):boolean;     {84}
function SetNewSettleTime(var FIPPrec:FIPPrecType):boolean;    {84} {new version}

function GetExtendedLabel(var FIPPrec:FIPPrecType):boolean;  {86}
function GetCICstate(var FIPPrec:FIPPrecType):boolean;       {87}
function SetCICstate(var FIPPrec:FIPPrecType):boolean;       {88}
function SetPrinterLabelStorage(var FIPPrec:FIPPrecType):boolean; {89}
{function SetDefaultLabel(var FIPPrec:FIPPrecType):boolean; old #89}

function SetAvgDelayTime(var FIPPrec:FIPPrecType):boolean;   {90}  {7/24/96}
function GetAvgDelayTime(var FIPPrec:FIPPrecType):boolean;   {91}  {7/24/96}
function DoMeasurement(var FIPPrec:FIPPrecType):boolean;     {85}  {7/24/96}
function SetPrinterType(var FIPPrec:FIPPrecType):boolean;   {92}   {6500 4/1/97}
function GetPrinterType(var FIPPrec:FIPPrecType):boolean;   {93}   {6500 4/1/97}
function GetHFAMeasurement(var FIPPrec:FIPPrecType):boolean; {94}  {6500 5/9/98}
function GetInstrumentInfo(var FIPPrec:FIPPrecType):boolean;     {95} {FP35 05/23/00}

function SetPrinterLabelBitmap(var FIPPrec:FIPPrecType):boolean;  {96} {FP35 08/05/99}
function SetARparams(var FIPPrec:FIPPrecType):boolean;       {97} {6500}
function GetARparams(var FIPPrec:FIPPrecType):boolean;       {98} {6500}
function SetBlob(var FIPPrec:FIPPrecType):boolean;                {99} {FP35 11/11/99}
function GetDeviceIDCount(var FIPPrec:FIPPrecType):boolean; {100} {FP35 08/05/99}
function GetLongDeviceID(var FIPPrec:FIPPrecType):boolean;  {101} {FP35 08/05/99}
function GetDeviceData(var FIPPrec:FIPPrecType):boolean;    {102} {FP35 08/05/99}
function GetRealTimeClock(var FIPPrec:FIPPrecType):boolean; {103} {FP35 08/05/99}
function SetRealTimeClock(var FIPPrec:FIPPrecType):boolean; {104} {FP35 08/05/99}
function GetOutputDevice(var FIPPrec:FIPPrecType):boolean;  {105} {FP35 05/23/00}
function SetOutputDevice(var FIPPrec:FIPPrecType):boolean;  {106} {FP35 05/23/00}
function GetImpulseRej(var FIPPrec:FIPPrecType):boolean;    {107} {FP35 05/23/00}
function SetImpulseRej(var FIPPrec:FIPPrecType):boolean;    {108} {FP35 05/23/00}
function GetSignalInfo(var FIPPrec:FIPPrecType):boolean;    {109} {FP35 05/23/00}
function GetRawSampleData(var FIPPrec:FIPPrecType):boolean; {110} {FP35 08/05/99}
function SetCurveSelect(var FIPPrec:FIPPrecType):boolean;   {112} {FP35 05/23/00}
function GetCurveSelect(var FIPPrec:FIPPrecType):boolean;   {113} {FP35 05/23/00}
function SetCurveStatus(var FIPPrec:FIPPrecType):boolean;   {114} {FP35 05/23/00}
function GetCurveStatus(var FIPPrec:FIPPrecType):boolean;   {115} {FP35 05/23/00}
function SetUnaidedSelect(var FIPPrec:FIPPrecType):boolean; {116} {FP35 05/23/00}
function GetUnaidedSelect(var FIPPrec:FIPPrecType):boolean; {117} {FP35 05/23/00}
function SetStaticToneSelect(var FIPPrec:FIPPrecType):boolean; {121} {FP35 09/19/00}
function GetStaticToneSelect(var FIPPrec:FIPPrecType):boolean; {122} {FP35 09/19/00}
function SetAidTypeSelect(var FIPPrec:FIPPrecType):boolean; {123} {FP35 09/25/00}
function GetAidTypeSelect(var FIPPrec:FIPPrecType):boolean; {124} {FP35 09/25/00}
function SetBiasTone(var FIPPrec:FIPPrecType):boolean;   {125} {future}
function GetBiasTone(var FIPPrec:FIPPrecType):boolean;   {126} {future}
function SetWarbleSelect(var FIPPrec:FIPPrecType):boolean; {129} {FP35 06/29/01}
function GetWarbleSelect(var FIPPrec:FIPPrecType):boolean;   {130} {FP35 06/29/01}
function GetDelayMeasurments(var FIPPrec:FIPPrecType):boolean; {131} {6500 07/29/01}
function SetRcvTimeout(var FIPPrec:FIPPrecType):boolean;      {132} {fp35 08/01/01}
function GetRcvTimeout(var FIPPrec:FIPPrecType):boolean;      {133} {fp35 08/01/01}
function SetFitRule(var FIPPrec:FIPPrecType):boolean;      {134} {fp35 01/07/02}
function GetFitRule(var FIPPrec:FIPPrecType):boolean;      {135} {fp35 01/07/02}
function SetFilter(var FIPPrec:FIPPrecType):boolean;      {136} {fp35 01/07/02}
function GetFilter(var FIPPrec:FIPPrecType):boolean;      {137} {fp35 01/07/02}
function SetCompression(var FIPPrec:FIPPrecType):boolean;      {138} {fp35 01/30/02}
function GetCompression(var FIPPrec:FIPPrecType):boolean;      {139} {fp35 01/30/02}
function SetClientAge(var FIPPrec:FIPPrecType):boolean;      {140} {fp35 01/30/02}
function GetClientAge(var FIPPrec:FIPPrecType):boolean;      {141} {fp35 01/30/02}
function SetTransducerLoc(var FIPPrec:FIPPrecType):boolean;     {142} {fp35 08/23/02}
function GetTransducerLoc(var FIPPrec:FIPPrecType):boolean;     {143} {fp35 08/23/02}
function SetLevelingList(var FIPPrec:FIPPrecType):boolean;    {145} {fp35 v3.20 4/25/03}
function GetLevelingList(var FIPPrec:FIPPrecType):boolean;    {146} {fp35 v3.20 4/25/03}
function SetLevelingStatus(var FIPPrec:FIPPrecType):boolean;  {147} {fp35 v3.20 4/25/03}
function SetAuxPort(var FIPPrec:FIPPrecType):boolean;    {148} {fp35 v3.20 5/01/03}
function GetAuxPort(var FIPPrec:FIPPrecType):boolean;    {149} {fp35 v3.20 5/01/03}
function SetUserNumber(var FIPPrec:FIPPrecType):boolean;    {148} {fp35 v3.20 6/20/03}
function GetUserNumber(var FIPPrec:FIPPrecType):boolean;    {149} {fp35 v3.20 6/20/03}

function SetFitType(var FIPPrec:FIPPrecType):boolean;    {152} {fp35 v3.20 12/01/03}
function GetFitType(var FIPPrec:FIPPrecType):boolean;    {153} {fp35 v3.20 12/01/03}
function SetVentType(var FIPPrec:FIPPrecType):boolean;    {154} {fp35 v3.20 12/01/03}
function GetVentType(var FIPPrec:FIPPrecType):boolean;    {155} {fp35 v3.20 12/01/03}
function SetTubingType(var FIPPrec:FIPPrecType):boolean;    {156} {fp35 v3.20 12/01/03}
function GetTubingType(var FIPPrec:FIPPrecType):boolean;    {157} {fp35 v3.20 12/01/03}
function SetAidChannels(var FIPPrec:FIPPrecType):boolean;    {158} {fp35 v3.20 12/01/03}
function GetAidChannels(var FIPPrec:FIPPrecType):boolean;    {159} {fp35 v3.20 12/01/03}
function SetAidLimiting(var FIPPrec:FIPPrecType):boolean;    {160} {fp35 v3.20 12/01/03}
function GetAidLimiting(var FIPPrec:FIPPrecType):boolean;    {161} {fp35 v3.20 12/01/03}
function SetFitParam(var FIPPrec:FIPPrecType):boolean;    {164} {fp35 v3.20 12/01/03}
function GetFitParam(var FIPPrec:FIPPrecType):boolean;    {165} {fp35 v3.20 12/01/03}

{162 - not yet used}
{163 - not yet used}

function SetUserIDText(var FIPPrec:FIPPrecType):boolean;  {166} {fp35 v3.20 6/20/03}
function GetUserIDText(var FIPPrec:FIPPrecType):boolean;  {167} {fp35 v3.20 6/20/03}

function QuickTerminate(var FIPPrec:FIPPrecType):boolean;   {7fff}

{ +++++++++++++ }

{$IFDEF WIN32}
  function LoadFryers:boolean;

  {we use the dynamic dll load method so that we can catch the Error}
  const LibHandle : integer = 0;
  var CallFryers : procedure(var FIregs:F_RegsType); stdcall;
{$ELSE}
  procedure CallFryers(var FRegs:F_RegsType);
{$ENDIF}


{ *********** }

implementation

{-------------------------------------------------------------------}

{$IFDEF WIN32}
  {this defines the call to the FRYERS32.DLL for static dll load }
  {however, we will use dynamic loading so as to catch the error}
//  procedure CallFryers(var FRegs:F_RegsType); stdcall external 'Fryers32.DLL';

    {this call is used for non-dll testing of the fryers dll}
//    procedure CallFryers(var FRegs:F_RegsType);
//    begin
//      ServiceFryers(FryerDef.F_RegsType(FRegs));
//    end;
{$ELSE}
  procedure CallFryers(var FRegs:F_RegsType);
  begin
    INTR($14,FRegs);
  end;
{$ENDIF}


{$IFDEF WIN32}
  {try to load fryers32.dll}
  {returns false if cannot find Fryers}
  {this is only used in 32 bit mode}
  function LoadFryers:boolean;
  begin
    LoadFryers := true;
    if LibHandle > 0 then Exit;
    LoadFryers := false;
    LibHandle := LoadLibrary('fryers32.dll');
    if LibHandle < 32 then
    begin
      {showmessage('Unable to load fryers32.dll');}
      Exit;
    end;
    @CallFryers := GetProcAddress(LibHandle,'CallFryers');
    if @CallFryers = nil then
    begin
     { showmessage('Failed to lookup CallFryers');}
      Exit;
    end;
    LoadFryers := true;
  end;
{$ENDIF}

{-----------}
function QTon(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     Regs.AX := $ff1a;
     Regs.CX := 0;
     Regs.DX := comport;
     CallFryers(Regs);
     QTon := ((Regs.AX and $01) = $01);
   end;
end;

{-------}
function GetPacketTimer(var FIPPrec:FIPPrecType):word;
begin
   with FIPPrec do
   begin
     Regs.AX := $ff17;  {select packet timer}
     Regs.CX := $0300;
     Regs.DX := comport;
     CallFryers(Regs);
     GetPacketTimer := Regs.AX;
   end;
end;

{-------}
procedure ClearPacketTimer(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff17;  {select packet timer}
     Regs.BX := 0;
     Regs.CX := $03FF;
     Regs.DX := comport;
     CallFryers(Regs);
   end;
end;

{-------}
{set external switch box command}
procedure ExternalSwitch(State:byte; Cmd:word; var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff1D;
     Regs.BX := Cmd;
     Regs.CH := $01;
     Regs.CL := State;
     Regs.DX := comport;
     CallFryers(Regs);
   end;
end;

{-------}
{returns a string relating to the error encountered}
function FIPPerrorMsg(ErrorNumber:integer):str255;
var Emsg:string[20];
begin
    str(ErrorNumber,Emsg);
    case ErrorNumber of
      GoodPacket     : FIPPerrorMsg := '';
      ReceiveError   : FIPPerrorMsg := 'RECEIVE ERROR';
      ReceiveOverrun : FIPPerrorMsg := 'RECEIVE OVERRUN';
      SendOverFlow   : FIPPerrorMsg := 'SEND OVERFLOW';
      SendOverRun    : FIPPerrorMsg := 'SEND OVERRUN';
      ILLegalPacket  : FIPPerrorMsg := 'ILLEGAL PACKET';
      BadPacket      : FIPPerrorMsg := 'BAD PACKET';
      ResponseError  : FIPPerrorMsg := 'RESPONSE ERROR';
      NoGoCommand    : FIPPerrorMsg := 'COMMAND ERROR';
      NoFryers       : FIPPerrorMsg := 'NO COMM DRIVER';
      BadFryers      : FIPPerrorMsg := 'BAD COMM DRIVER';
      NoPoll         : FIPPerrorMsg := 'NO POLL';
    else
      FIPPerrorMsg := 'UNKNOWN ERROR: '+Emsg+' ';
    end;
end;

{-------}
{returns PacketStatus set to the current packet status value}
{The primary packet status is returned in AL as follows}
{7=bad transfer, 6=no poll, 5=reserved, 4=receive overflow}
{3=send overflow, 2=send overrun, 1=receive ready, 0=send ready}
{See the Fryers manual for a description of other error info}

function PacketStatus(var FIPPrec:FIPPrecType):byte;
begin
   with FIPPrec do
   begin
     Regs.AX := $ff13;
     Regs.DX := comport;
     CallFryers(Regs);
     StatAX := Regs.AX;
     StatBX := Regs.BX;
     StatCX := Regs.CX;  {save the error status response}
     StatDX := Regs.DX;
     PacketStatus := Regs.AL;  {return the primary packet status}
   end;
end;

{-------------------------------------------------------------------}
{Checks on baudrate. If baud rate is wrong, tries to switch}
{the baudrate (if V4.00 Fryers) to see if it will fix the problem.}
procedure AutoBaudCheck(var FIPPrec:FIPPrecType);
var TAX,TBX,TCX:word;
begin
  with FIPPrec do
  begin
    if not(PortOpen) then Exit;

    Tcx := 0;
    if Fversion >= 400 then
    begin
      Regs.AX := $ff1B;
      Regs.BX := 0;  {38400}
      Regs.DX := comport;
      CallFryers(Regs);
      Regs.AH := 0;
      TAX := Regs.AX;
      TBX := Regs.BX;
      TCX := Regs.CX;
    end;
    if (TCX and $0020) <> 0 then
      BaudSeek := true
    else
      BaudSeek := false;
    if BaudSeek then
    begin
{      TAX := GetPacketTimer(FIPPrec);        }
{      while tax = GetPacketTimer(FIPPrec) do }
{        if PacketAbort(FIPPrec) then Exit;   }
      UpdateFryersInfo(FIPPrec);
    end;
  end;
end;


{-------}
{checks to see if lost poll from 6500. If so then checks to see if}
{a key has been pressed. If so then returns PacketAbort true.}
{Warning: Remember to preset AbortTime to zero}
function PacketAbort(var FIPPrec:FIPPrecType):boolean;
const OldBX : word = 0;
var   Temp : word;
begin
   PacketAbort := false;

{   -- for debugging -->>
   begin
     if (PacketStatus(FIPPrec) and $40) <> $40 then Exit;
     writeln('Error: No poll being received from instrument');
     while keypressed do if readkey = #0 then;
     repeat
     until keypressed or (PacketStatus(FIPPrec) and $40 <> $40);
   end;
}
   Temp := PacketStatus(FIPPrec);
   if OldBX <> FIPPrec.StatBX then inc(FIPPrec.AbortTime);
   OldBX := FIPPrec.StatBX;
   if FIPPrec.AbortTime > AllowedAbortTime then
   begin
     if KeyWaiting then ch := GetKey;
     if ch = #$1b then
     begin
       FIPPrec.PacketError := UserAbort;
       PacketAbort := true;
     end;
   end;
   if ((FIPPrec.StatCX and $007f) <> 0) and ((FIPPrec.StatAX and $0001)=0) then
     Exit; {//if action in progress, don't kill it}
   if FIPPrec.StatAX and $4040 <> $40 then Exit; {//nothing happening and got a no poll}
   FIPPrec.PacketError := NoPoll;
   PacketAbort := true;
end;

{-------}
{Checks to see if we are communicating at all}
{returns true if communicating ok, false if no poll being received}
function PollOK(var FIPPrec:FIPPrecType):boolean;
begin
   PollOK := true;
   if (PacketStatus(FIPPrec) and $60) <> $60 then Exit;
   FIPPrec.PacketError := NoPoll;
   PollOK := false;
end;

{enable or disable AutoQT}
procedure AutoQT(FIPPrec:FIPPrecType; QuickTerm:boolean);
begin
  with FIPPrec do
  begin
    if QuickTerm then
      Regs.CX := $ffff
    else
      Regs.CX := $ff00;
    Regs.AX := $ff1a;
    Regs.DX := comport;
    CallFryers(Regs);
  end;
end;

{-------}
{Open a comport to begin packet communications through}
{using the specified baudrate. IOport is 1-4}
{baudrate is 300, 600, 1200, 2400, 4800, 9600, 19200, or 38400}
{if baudrate is invalid, the default of 9600 is selected}
{returns status of port that is opened (see Fryers manual)}

function OpenPacketPort(var FIPPrec:FIPPrecType; IOPort,IRQn:word):boolean;
begin
   with FIPPrec do
   begin
     OpenPacketPort := false;
     if IOport < 1 then IOport := 1;
    {$IFDEF WIN32}
      if IOport > 15 then IOport := 1;
      ComPort := pred(IOport);    {comport is the defined io port in 32bit mode}
    {$ELSE}
      if IOport > 4 then IOport := 1;
      ComPort := pred(IOport) and 1;  {comport is 0 or 1 in 16bit mode}
    {$ENDIF}

     FVersion := 0;
     Regs.AX := $ffff;     {get Fryers version number}
     Regs.DX := comport;
     CallFryers(Regs);
     PacketError := NoFryers;     {assume fryers not installed}
     if Regs.DX and $ffff <> $ffff then Exit; {not in range, so Fryers.com not installed}
     if Regs.AL < 24 then Exit;   {MSDOS needs V2.4+}
     {$IFDEF DPMI}
       if (Regs.DX and $ffff <> $ffff) or (Regs.AX < 30) then Exit; {DPMI needs V3.0+}
     {$ENDIF}
     {$IFDEF WIN16}
       if (Regs.DX and $ffff <> $ffff) or (Regs.AX < 40) then Exit; {Win3.1 needs V4.0+}
     {$ENDIF}
     {$IFDEF WIN32}
       if (Regs.DX and $ffff <> $ffff) or (Regs.AX < 50) then Exit; {Win32 needs V5.0+}
     {$ENDIF}
     if Regs.AL < $30 then
     begin
       Fversion := ( ((Regs.AL shr 4)*10) + (Regs.AL and $f) )*10;
     end
     else
     begin
       Regs.BX := 0;
       Regs.SI := 0;
       Regs.DI := 0;
       Regs.AX := $fffe;
       Regs.DX := comport;
       CallFryers(Regs);
       Fversion := Regs.BX;
     end;

     Regs.AX := $ff00;     {disable fryers interrupt procedure}
     Regs.CX := $ff00;     {this makes sure everything is kosher}
     Regs.DX := comport;
     CallFryers(Regs);

    {$IFNDEF WIN32}
     if Fversion >= 307 then
     begin
       Regs.AX := $ff0a;     {select the desired port to use}
       Regs.CH := $ff;
       Regs.CL := IRQn;    {use the selected IRQ number}
       Regs.BX := (pred(IOPort) shr 1) and 1; {select the uart to use}
       Regs.DX := ComPort;        {init the port}
       CallFryers(Regs);
       if Regs.AH = $ff then Exit;
       IRQnum[pred(IOport) and 3] := Regs.AH;
       BaseAdr := Regs.BX;
     end
     else if IOport > 2 then Exit;
    {$ENDIF}

     Regs.AX := $ff00;     {enable fryers interrupt procedure}
     Regs.CX := $ffff;
     Regs.DX := comport;
     CallFryers(Regs);

     Regs.AX := $00e3;         {default to 9600 if bad value given}
     case BaudRate div 10 of
         0 : Regs.AX := $00f3; {select autobaud starting at 9600}
       120 : Regs.AX := $0083;
       240 : Regs.AX := $00a3;
       480 : Regs.AX := $00c3;
       960 : Regs.AX := $00e3; {init to selected baudrate}
      1920 : Regs.AX := $0003; {no parity, and one stop bit}
      2880 : Regs.AX := $0023;
      3840 : Regs.AX := $0043;
      5760 : Regs.AX := $0063;
     end;
     if ((BaudRate mod 10) > 0) and AutoBaud then   {if baudrate plus one then set to}
       Regs.AX := Regs.AX or $0010;  {autobaud starting at that baudrate}


     Regs.DX := comport;   {init port baudrate}
     CallFryers(Regs);

     Regs.AX := $ff10;     {enable fryers packet protocol}
     Regs.CX := $ffff;
     Regs.DX := comport;
     CallFryers(Regs);


     if FVersion >= 410 then
     begin
       Regs.AX := $ff17;     {set poll timer}
       Regs.CX := $0400;
       Regs.BX := 0;
       Regs.DX := comport;
       CallFryers(Regs);
       PacketTickMultMS := Regs.AX;   {note: these will normally be }
       PacketTickTimeMS := Regs.BX;   {      the same in 32 bit mode}
     end
     else
     begin
       PacketTickMultMS := 55;        {the multiplier was not changable}
       PacketTickTimeMS := 55;        {prior to V4.10, it was always 55ms}
     end;

     PollTimer := DefaultPollTimer; {default poll timeout = 5.5 sec}
     Regs.AX := $ff17;     {set poll timer}
     Regs.CX := $00ff;
     Regs.BX := PollTimer;
     Regs.DX := comport;
     CallFryers(Regs);
     RealPollTime := Regs.BX;

     Regs.AX := $ff17;     {set response timer}
     Regs.CX := $01ff;
     Regs.BX := 20;         {1.1 second}
     Regs.DX := comport;
     CallFryers(Regs);

     Regs.AX := $ff17;     {set rcv timer}
     Regs.CX := $02ff;
     Regs.BX := 20;         {1.1 second}
     Regs.DX := comport;
     CallFryers(Regs);

     UpdateFryersInfo(FIPPrec);
     PacketError := GoodPacket;   {No error, so clear PacketError}
     if (PacketStatus(FIPPrec) and $01) = 0 then
     begin
       {if StatAX = $40 then}
         PacketError := BadFryers;
       Exit;
     end;
     {GetDevVersion(FIPPrec);}
     AutoQT(FIPPrec,QuickTerm);
     PortOpen := true;
     OpenPacketPort := true;
   end;
end;

{-------}
{Close the specified packet communications com port}

procedure ClosePacketPort(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff10;     {disable fryers packet protocol}
     Regs.CX := $ff00;
     Regs.DX := comport;
     CallFryers(Regs);

     Regs.AX := $ff00;     {disable fryers interrupt procedure}
     Regs.CX := $ff00;
     Regs.DX := comport;
     CallFryers(Regs);

     PortOpen := false;
   end;
end;

{------}
{update fryers info - updates the version info for fryers and the baud rate in use}
procedure UpdateFryersInfo (var FIPPrec:FIPPrecType);
begin
  with FIPPrec do
  begin
    Regs.AX := $ffff;     {get Fryers version number}
    Regs.DX := comport;
    Regs.DI := 0;
    CallFryers(Regs);
    if Regs.DI = 0 then
      TrueBaudRate := 9600
    else
      TrueBaudRate := 115200 div Regs.DI;

   if Regs.AL < $30 then
   begin
     Fversion := ( ((Regs.AL shr 4)*10) + (Regs.AL and $f) )*10;
   end
   else
   begin
       Regs.BX := 0;
       Regs.SI := 0;
       Regs.DI := 0;
       Regs.AX := $fffe;
       Regs.DX := comport;
       CallFryers(Regs);
       Fversion := Regs.BX;
   end;
 end;
end;

{-------}
{this sets a new value in the Poll timer}
procedure SetPollTimer(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff17;     {set poll timer}
     Regs.BX := PollTimer; {number of ticks before timeout}
     Regs.CX := $00ff;
     Regs.DX := comport;
     CallFryers(Regs);
     RealPollTime := Regs.BX;
   end;
end;

{-------}
{this returns the Poll timer's current value}
procedure GetPollTimer(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff17;     {read poll timer}
     Regs.CX := $0000;
     Regs.DX := comport;
     CallFryers(Regs);
     PollTimer := Regs.AX;
   end;
end;


{-------}
{this sets a new value in the response timer}
procedure SetRespTimer(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff17;     {set response timer}
     Regs.BX := RespTimer;
     Regs.CX := $01ff;
     Regs.DX := comport;
     CallFryers(Regs);
   end;
end;

{-------}
{this returns the response timer's current value}
procedure GetRespTimer(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff17;     {read response timer}
     Regs.CX := $0100;
     Regs.DX := comport;
     CallFryers(Regs);
     RespTimer := Regs.AX;
   end;
end;

{-------}
{returns PacketReady true if a packet command can be sent, meaning}
{that a response has been received from the previous command}

function PacketReady(var FIPPrec:FIPPrecType):boolean;
begin
   if FIPPrec.AutoBaud then AutoBaudCheck(FIPPrec);
   PacketReady := (PacketStatus(FIPPrec) and $01) = 1;
   if debug then
   begin
     write('Error - StatAX:',hexW(FIPPrec.StatAX),
                 '  StatCX:',hexW(FIPPrec.StatCX),
                 '  StatDX:',hexW(FIPPrec.StatDX),
                 '  Packet:',hexW(FIPPrec.PacketError) );
     write(#13);
   end;
end;

{-------}
{returns ReceivePacketOK true if a good packet response was received}

function ReceivePacketOK(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     ReceivePacketOK := true;
     if (PacketStatus(FIPPrec) and $13) <> $03 then
     begin
       ReceivePacketOK := false;
       PacketError := ReceiveError;
       if StatAX and $0010 = $0010 then PacketError := ReceiveOverrun;
       if StatAX and $0040 = $0040 then PacketError := NoPoll;
     end;
   end;
end;

{-------}
{Waits for PacketReady to be true or an abort situation to occur}
{returns true if Packet it ready. Returns false if aborted.}

function WaitForPacketReady(var FIPPrec:FIPPrecType):boolean;
var done:boolean;
begin
   done := false;
   FIPPrec.AbortTime := 0;  {clear abort timer}
   repeat
     done := PacketAbort(FIPPrec) or PacketReady(FIPPrec);
     if Fipprec.BaudSeek then
       write('<Seeking Baudrate>',#$0D);

{*** debugging code ***}
     if Debug then
       write('$A'+hexw(FIPPrec.StatAX)+'$C'+hexw(FIPPrec.StatCX));
{*** debugging code ***}

   until done;
   WaitForPacketReady := done;
end;

{-------}
{Discards any response that might be hanging around}

procedure DiscardResponse(var FIPPrec:FIPPrecType);
begin
   with FIPPrec do
   begin
     Regs.AX := $ff16;
     Regs.DX := comport;
     CallFryers(Regs);
   end;
end;

{------}
{send a byte of data out serial port}
function SendByte(What:byte; var FIPPrec:FIPPrecType):byte;
begin
   with FIPPrec do
   begin
     SendByte := 0;
    {$IFDEF WIN32}
      with FIPPrec do
      begin
        Regs.AH := 00;
        Regs.AL := What;
        CallFryers(Regs);
        if Regs.AX = -1 then
        begin
          SendByte := $80;
          Exit;
        end;
      end;
    {$ELSE}
      while Port[BaseAdr+5] and $20 = 0 do
      begin
        if GetPacketTimer(FIPPrec) > 10 then
        begin
          SendByte := $80;
          Exit;
        end;
      end;
      Port[BaseAdr] := What;
    {$ENDIF}
   end;
end;

{------}
{sends wake up signal to instrument}
function SendWakeup(var Signal; var FIPPrec:FIPPrecType):boolean;
var Data : array[0..3] of byte absolute Signal;
    i :integer;
    b : boolean;
begin
  ClosePacketPort(FIPPrec);
  ClearPacketTimer(FIPPrec);
  while GetPacketTimer(FIPPrec) < 1 do {nop};
  for i := 0 to 3 do b := SendByte(0,FIPPrec) = 0;
  for i := 0 to 3 do
  begin
    if b then
      b := SendByte(Data[i],FIPPrec) = 0;
  end;
  SendWakeUp := b;
  if not(b) then Writeln('* Ack! *');
  b := OpenPacketPort(FIPPrec,useIOPort,useIRQ);
  if not(b) then SendWakeUp := b;
end;

{-------}
{This skips the next poll that occurs. This is used to ignore a poll}
{following a Set cmd in order to give the target time to perform a}
{measurement. If >110ms of time has passed without a poll, then the}
{function aborts with SkipPoll set to false. Otherwise the Poll is}
{skipped and the function returns true.}

function BSkipPoll(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     BSkipPoll := false;
     ClearPacketTimer(FIPPrec);
     repeat
       if GetPacketTimer(FIPPrec) > 1 then Exit; {timeout period passed}
       if (PacketStatus(FIPPrec) and $60) = $60 then Exit;  {no poll}
     until (StatCX and 1) = 1;                 {wait for poll signal}
     repeat
       if GetPacketTimer(FIPPrec) > 1 then Exit; {timeout period passed}
       if (PacketStatus(FIPPrec) and $60) = $60 then Exit;  {no poll}
     until (StatCX and 1) = 0;            {wait for poll to complete}
     BSkipPoll := true;
   end;
end;

{-------}
{Same thing as BSkipPoll but as a procedure call}
procedure SkipPoll(var FIPPrec:FIPPrecType);
begin
  if BSkipPoll(FIPPrec) then begin end;  {dummy if/then}
end;

{-------}
{Same thing as SkipPoll but skips two polls instead of just one.}
procedure Skip2Polls(var FIPPrec:FIPPrecType);
begin
   SkipPoll(FIPPrec);
   SkipPoll(FIPPrec);
end;

{-------}
{Send the command that resides in SendArray. It is assumed that}
{the command has already been placed in the array, and that the}
{packet can be sent immediately (i.e. PacketReady = true) }
{returns SendPacket true if send was OK}

function SendPacket(var FIPPrec:FIPPrecType):boolean;
var i : word;
begin
 {$IFDEF MSDOS}
   with FIPPrec do
   begin
     regs.ax := $ff11;
     regs.dx := comport;
     regs.ds := Seg(SendArray);    {point to cmd array}
     regs.bx := Ofs(SendArray);
     CallFryers(Regs);
     if regs.ax and $08 = $08 then PacketError := SendOverFlow;
     if regs.ax and $04 = $04 then PacketError := SendOverRun;
     SendPacket := (regs.ax and $0c) = 0;
   end;
 {$ELSE}
   with FIPPrec do
   begin
     for i := 0 to succ(Sendarray[1]) do
     begin
       regs.ax := $ff23;
       regs.dx := comport;
       regs.cx := i;
       regs.bx := SendArray[i];
       CallFryers(Regs);
     end;
     regs.ax := $ff15;
     regs.dx := comport;
     CallFryers(Regs);
     if regs.ax and $08 = $08 then PacketError := SendOverFlow;
     if regs.ax and $04 = $04 then PacketError := SendOverRun;
     SendPacket := (regs.ax and $0c) = 0;
   end;
 {$ENDIF}
end;


{-------}
{pick up the response and place it in the RcvArray. It is assumed that}
{the response has already been determined to be valid, and that it}
{is ready to be picked up immediately (i.e. ReceivePacketOK = true) }

function GetRcvPacket(var FIPPrec:FIPPrecType):boolean;
var i,Size:word;
begin
{$IFDEF MSDOS}
   with FIPPrec do
   begin
     regs.ax := $ff12;
     regs.dx := comport;
     regs.ds := Seg(RcvArray);     {point to response array}
     regs.bx := Ofs(RcvArray);
     CallFryers(Regs);
     if (regs.ax and $10) = $10 then PacketError := ReceiveOverrun;
     GetRcvPacket := (regs.ax and $10) = 0;
   end;
 {$ELSE}
   with FIPPrec do
   begin
     regs.ax := $ff26; {how much data?}
     regs.dx := comport;
     regs.cx := 1;
     CallFryers(Regs);
     Size := regs.cx;
     for i := 0 to Succ(Size) do
     begin
       regs.ax := $ff26;  {get the data}
       regs.dx := comport;
       regs.cx := i;
       CallFryers(Regs);
       RcvArray[i] := regs.dx;
     end;
     regs.ax := $ff16;  {clear rcv flag}
     regs.dx := comport;
     CallFryers(Regs);
     if (regs.ax and $10) = $10 then PacketError := ReceiveOverrun;
     GetRcvPacket := (regs.ax and $10) = 0;
   end;
 {$ENDIF}
end;


{-------}
{Checks first word in rcvarray for ACK. If ACK returns true,}
{if not returns false.}

function RcvAcknowledge(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     RcvAcknowledge := true;
     if RcvArray[0] = PacketAck then Exit;
     RcvAcknowledge := false;
     if RcvArray[0] = PacketIll then
       PacketError := IllegalPacket
     else
       PacketError := BadPacket;
   end;
end;

{-------}
{This sends a command to the 6500 and waits for a response}
{if an abort situation occurs it returns as false, and the}
{error condition is provided in PacketError}

function SendCommand(var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     SendCommand := false;
     if not(WaitForPacketReady(FIPPrec)) then Exit;
     DiscardResponse(FIPPrec);
     if not(SendPacket(FIPPrec)) then Exit;
     if not(WaitForPacketReady(FIPPrec)) then Exit;
     if SendArray[0] <> $7fff then
     begin
       if not(ReceivePacketOK(FIPPrec)) then Exit;
       if not(GetRcvPacket(FIPPrec)) then Exit;
     end;
     SendCommand := true;
   end;
end;

{-------}
{checks rcvarray for good cmd status response. Returns true if good.}
{Returns false if bad, with the error in PacketError.}

function CmdStatCheck(Var FIPPrec:FIPPrecType):boolean;
begin
   with FIPPrec do
   begin
     CmdStatCheck := false;
     if (RcvArray[0] and $7fff) <> GetCmdStatusCmd then
       PacketError := ResponseError
     else
       if RcvArray[2] <> 0 then
         PacketError := NoGoCommand
       else
         CmdStatCheck := true;
   end;
end;

{-------}
{Go ask for the status of the last command. Returns true if good,}
{returns false if bad.}

function CommandStatusOK(var FIPPrec:FIPPrecType):boolean;
var SA1,SA2:word;
begin
   with FIPPrec do
   begin
     CommandStatusOK := false;
     CmdStatusFailed := true;
     SA1 := SendArray[0];
     SA2 := SendArray[1];
     SendArray[0] := GetCmdStatusCmd;
     SendArray[1] := 0;
     if not(SendCommand(FIPPrec)) then Exit;
     SendArray[0] := SA1;
     SendArray[1] := SA2;
     if not(CmdStatCheck(FIPPrec)) then Exit;
     CommandStatusOK := true;
     CmdStatusFailed := false;
   end;
end;

{-------}
{SetPacket sets various modes and values inside the target machine}
{It returns a true if everything went OK, or false if not and the}
{error information is returned in PacketError.}
{SetPacket assumes that the command is already in SendArray.}

function SetPacket(var FIPPrec:FIPPrecType):boolean;
begin
  SetPacket := false;
  if SendCommand(FIPPrec) then
  begin
    if RcvAcknowledge(FIPPrec) then
    begin
      SetPacket := true;
      if FIPPrec.Verify then
        if not(CommandStatusOK(FIPPrec)) then
          SetPacket := false;
    end;
  end;
end;

{-------}
{The DoPacket works exactly the same as SetPacket, but it is kept}
{seperate so as to allow possible future modification since the}
{function in the 6500 works differently than a SetPacket call}
{it is up to the calling procedure to collect any data it wants}
{after performing a DoPacket.}
{DoPacket assumes that the command is already in SendArray.}
{Returns a true if everything went OK, or false if not and the}
{error information is returned in PacketError.}
{Note: the 6500 indicates that it is done "doing" by responding to}
{the next command sent. Thus the simplest way to determine if it}
{is ready is to ask for cmd status.}

function DoPacket(var FIPPrec:FIPPrecType):boolean;
begin
  DoPacket := false;
  if SendCommand(FIPPrec) then
  begin
    if RcvAcknowledge(FIPPrec) then
    begin
      DoPacket := true;

  {    if FIPPrec.Verify then
        if not(CommandStatusOK(FIPPrec)) then
          DoPacket := false;}
    end;
  end;
end;

{-------}
{GetPacket is used to pickup data from the target machine.}
{GetPacket assumes that the command is already in SendArray.}
{Returns a true if everything went OK, or false if not and the}
{error information is returned in PacketError.}
{It is up to the calling procedure to pull the resulting response}
{data out of RcvArray.}

function GetPacket(var FIPPrec:FIPPrecType):boolean;
begin
  with FIPPrec do
  begin
    GetPacket := false;
    if SendCommand(FIPPrec) then
    begin
      if (RcvArray[0] and $7fff) = SendArray[0] then
      begin
        GetPacket := true;
        Exit;
      end;
      PacketError := ResponseError;
    end;
{    if FIPPrec.Verify and not(SendArray[0] = GetCmdStatusCmd) then
      if not(CommandStatusOK(FIPPrec)) then
        GetPacket := false;}
  end;
end;


{-------}
{SetValue is used for most of the set functions since they all pass}
{a single integer value. Makes it much simpler.}
function SetValue(SetCmd,GetCmd:word; var ValueToSet:SmallInt;
                  var FIPPrec:FIPPrecType):boolean;
begin
  with FIPPrec do
  begin
    SetValue := false;
    PacketError := GoodPacket;
    SendArray[0] := SetCmd;
    SendArray[1] := 1;
    SendArray[2] := word(ValueToSet);
    if not(SetPacket(FIPPrec)) then Exit;
    if DoubleCheck then
    begin
      SendArray[0] := GetCmd;
      SendArray[1] := 0;
      if not(GetPacket(FIPPrec)) then Exit;
      ValueToSet := integer(RcvArray[2]);
    end;
    SetValue := true;
  end;
end;



{-------}
{GetValue is used for most of the get functions since they all pass}
{a single integer value. Makes it much simpler.}
function GetValue(GetCmd:word; var ValueToGet:smallint;
                  var FIPPrec:FIPPrecType):boolean;
begin
  with FIPPrec do
  begin
    GetValue := false;
    PacketError := GoodPacket;
    SendArray[0] := GetCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    ValueToGet := integer(RcvArray[2]);
    GetValue := true;
  end;
end;



function QuickTerminate(var FIPPrec:FIPPrecType):boolean;   {7fff}
begin
  QuickTerminate := false;
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := QuickTerminateCmd;
    SendArray[1] := 0;
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  QuickTerminate := true;
end;


{++++++++}
{The following procedures handle the standard FIPP Set commands}
{the command simply updates the appropriate variable in FIPPrec}
{it is up to the calling routine to insure that the desired variables}
{are properly updated before using them.}
{If verify is on, the target is asked if it is ok after the Set cmd.}
{If DoubleCheck is on, the set value is read back from the target and}
{the proper variable is updated with the real value. It is up to the}
{caller to determine if there is any discrepancy.}

{Set cmds - return true if everything went ok. }
{false if not (error in PacketError)}


{-------}
{Assumes that the caller has set SourceAmp to the desired value.}

function SetSourceAmp(var FIPPrec:FIPPrecType):boolean; {0}
begin
   SetSourceAmp :=
      SetValue(SetSourceAmpCmd,GetSourceAmpCmd,FIPPrec.SourceAmp,FIPPrec);
end;

{-------}
{Assumes that the caller has set DistMode to the desired value.}

function SetDistMode(var FIPPrec:FIPPrecType):boolean;  {1}
begin
   SetDistMode :=
      SetValue(SetDistModeCmd,GetDistModeCmd,FIPPrec.DistMode,FIPPrec);
end;

{-------}
{Assumes that the caller has set Frequency to the desired value.}

function SetFrequency(var FIPPrec:FIPPrecType):boolean; {2}
begin
   SetFrequency :=
      SetValue(SetFrequencyCmd,GetFrequencyCmd,FIPPrec.Frequency,FIPPrec);
end;

{-------}
{Assumes that the caller has set OESstate to the desired value.}

function SetOESstate(var FIPPrec:FIPPrecType):boolean;   {3}
begin
   SetOESstate :=
      SetValue(SetOESstateCmd,GetOESstateCmd,FIPPrec.OESstate,FIPPrec);
end;

{-------}
{Assumes that the caller has set NoiseRedCount to the desired value.}

function SetNoiseRedCount(var FIPPrec:FIPPrecType):boolean;  {4}
begin
  SetNoiseRedCount :=
      SetValue(SetNoiseRedCountCmd,GetNoiseRedCountCmd,FIPPrec.NoiseRedCount,FIPPrec);
end;

{-------}
{Assumes that the caller has set SmoothState to the desired value.}

function SetSmoothState(var FIPPrec:FIPPrecType):boolean; {5}
begin
   SetSmoothState :=
      SetValue(SetSmoothStateCmd,GetSmoothStateCmd,FIPPrec.SmoothState,FIPPrec);
end;

{-------}
{Assumes that the caller has set LabelData to the desired value.}
{Note: does not do double check. Note: Label is an ASCIIZ string.}
{Label should be padded with spaces.}

function SetLabel(var FIPPrec:FIPPrecType):boolean;    {6}
var i : integer;
begin
  with FIPPrec do
  begin
    SetLabel := false;
    PacketError := GoodPacket;
    SendArray[0] := SetLabelCmd;
    SendArray[1] := MaxLabelSize shr 1; {div 2}
    LabelData[pred(MaxLabelSize)] := #0; {force last byte to null}
    i := 0;
    while i <= MaxLabelSize do
    begin
      SendArray[(i shr 1)+2] := (ord(LabelData[i]) shl 8)+
                                 ord(LabelData[succ(i)]);
      inc(i,2);
    end;
    SetLabel := SetPacket(FIPPrec);
  end;
end;

{-------}
{Assumes that the caller has set ProbeState to the desired value.}

function SetProbeState(var FIPPrec:FIPPrecType):boolean;     {7}
begin
   SetProbeState :=
      SetValue(SetProbeStateCmd,GetProbeStateCmd,FIPPrec.ProbeState,FIPPrec);
end;

{-------}
{Assumes that the caller has set WeightState to the desired value.}

function SetWeightState(var FIPPrec:FIPPrecType):boolean; {8}
begin
   SetWeightState :=
      SetValue(SetWeightStateCmd,GetWeightStateCmd,FIPPrec.WeightState,FIPPrec);
end;

{-------}
{Assumes that the caller has set the CurveFrame to the desired value.}
{Note: does not do double check}

function SetCurveFrame(var FIPPrec:FIPPrecType):boolean; {9}
var CurveFormat: word;
var ByteSize : word;
begin
  with FIPPrec do
  begin
    SetCurveFrame := false;
    PacketError := GoodPacket;
    CurveFormat := (SendArray[3] shr 10) and 7;
    if ((CurveFormat = 2) or (CurveFormat = 3)) then
     CurveFrameSize := AudCurveFrameSize
    else CurveFrameSize := StdCurveFrameSize;
    ByteSize := (CurveFrameSize+3)*2; {cmd,len,crv#,crv}
    SendArray[0] := SetCurveFrameCmd;
    SendArray[1] := CurveFrameSize+1;
    SendArray[2] := word(CurveNumber);
    move(CurveFrame,SendArray[3],ByteSize);
    SetCurveFrame := SetPacket(FIPPrec);
  end;
end;

{-------}
{Assumes that the caller has set the IOmode to the desired value.}

function SetIOmode(var FIPPrec:FIPPrecType):boolean;      {10}
begin
  with FIPPrec do
  begin
    SetIOmode := false;
    PacketError := GoodPacket;
    SendArray[0] := SetIOmodeCmd;
    SendArray[1] := 2;
    SendArray[2] := word(IOFrequency);
    SendArray[3] := word(IOGain);
    if not(SetPacket(FIPPrec)) then Exit;
    if DoubleCheck then
    begin
      SendArray[0] := GetIOmodeCmd;
      SendArray[1] := 0;
      if not(GetPacket(FIPPrec)) then Exit;
      IOFrequency := integer(RcvArray[2]);
      IOGain := integer(RcvArray[3]);
    end;
    SetIOmode := true;
  end;
end;

{-------}
{Assumes that the caller has set the TelCoilState to the desired value.}

function SetTelCoilState(var FIPPrec:FIPPrecType):boolean;     {11}
begin
   SetTelCoilState :=
      SetValue(SetTelCoilStateCmd,GetTelCoilStateCmd,FIPPrec.TelCoilState,FIPPrec);
end;

{-------}
{Assumes that the caller has set the GainState to the desired value.}

function SetGainState(var FIPPrec:FIPPrecType):boolean;    {12}
begin
   SetGainState :=
     SetValue(SetGainStateCmd,GetGainStateCmd,FIPPrec.GainState,FIPPrec);
end;

{-------}
{Assumes that the caller has set the TelCoilMode to the desired value.}

function SetTelCoilMode(var FIPPrec:FIPPrecType):boolean;     {39}
begin
   SetTelCoilMode :=
     SetValue(SetTelCoilModeCmd,GetTelCoilModeCmd,FIPPrec.TelCoilMode,FIPPrec);
end;

{-------}
{Assumes that the caller has set the RelAttFreq to the desired value.}

function SetRelAttFreq(var FIPPrec:FIPPrecType):boolean;    {40}
begin
   SetRelAttFreq :=
     SetValue(SetRelAttFreqCmd,GetRelAttFreqCmd,FIPPrec.RelAttFreq,FIPPrec);
end;

{-------}
function SetZetaState(var FIPPrec:FIPPrecType):boolean;    {43}
begin
   SetZetaState :=
     SetValue(SetZetaStateCmd,GetZetaStateCmd,FIPPrec.ZetaState,FIPPrec);
end;


{-------}
{Assumes that the caller has set the Insitu data to the desired value.}

function SetInsitu(var FIPPrec:FIPPrecType):boolean;      {47}
begin
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SetInsitu := false;
    SendArray[0] := SetInsituCmd;
    SendArray[1] := 3;
    SendArray[2] := word(Insitu[0]);
    SendArray[3] := word(Insitu[1]);
    SendArray[4] := word(Insitu[2]);
    if not(SetPacket(FIPPrec)) then Exit;
    if DoubleCheck then
    begin
      SendArray[0] := GetInsituCmd;
      SendArray[1] := 0;
      if not(GetPacket(FIPPrec)) then Exit;
      Insitu[0] := word(RcvArray[2]);
      Insitu[1] := word(RcvArray[3]);
      Insitu[2] := word(RcvArray[4]);
    end;
    SetInsitu := true;
  end;
end;


{-------}
function SetAutoState(var FIPPrec:FIPPrecType):boolean;    {48}
begin
   SetAutoState :=
     SetValue(SetAutoStateCmd,GetAutoStateCmd,FIPPrec.AutoState,FIPPrec);
end;


{-------}
function SetLimitValue(var FIPPrec:FIPPrecType):boolean;    {50}
begin
   SetLimitValue :=
     SetValue(SetLimitValueCmd,GetLimitValueCmd,FIPPrec.LimitValue,FIPPrec);
end;


{-------}
function SetRefMicState(var FIPPrec:FIPPrecType):boolean;    {52}
begin
   SetRefMicState :=
     SetValue(SetRefMicStateCmd,GetRefMicStateCmd,FIPPrec.RefMicState,FIPPrec);
end;


{-------}
function SetActiveStatus(var FIPPrec:FIPPrecType):boolean;    {54}
VAR OldTimer:word;
begin
   GetPollTimer(FIPPrec);      {get real poll timeout value}
   with FIPPrec do
   begin
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 1800 then    {If less than 60 sec}
     begin
       PollTimer := 1800;        {force it to 60 sec abort}
       SetPollTimer(FIPPrec);
     end;
     SetActiveStatus :=
       SetValue(SetActiveStatusCmd,GetActiveStatusCmd,FIPPrec.ActiveStatus,FIPPrec);
     PollTimer := OldTimer;
     SetPollTimer(FIPPrec);      {restore original poll timeout value}
   end;
end;


{-- new v2.6x -----}
function SetMachineState(var FIPPrec:FIPPrecType):boolean;   {59}
var OldTimer : word;
begin
  with FIPPrec do
  begin
    SetMachineState := false;
    PacketError := GoodPacket;
     GetPollTimer(FIPPrec);      {get real poll timeout value}
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 1800 then    {If less than 60 seconds}
     begin
       PollTimer := 1800;        {force it to 60 seconds abort}
       SetPollTimer(FIPPrec);
     end;
    SendArray[0] := SetMachineStateCmd;
    SendArray[1] := 2;
    SendArray[2] := word(MajorMachineState);
    SendArray[3] := word(MinorMachineState);
    SetMachineState := SetPacket(FIPPrec);
    PollTimer := OldTimer;
    SetPollTimer(FIPPrec);      {restore original poll timeout value}
  end;
end;

{-- new v2.6x -----}
function SetControlLock(var FIPPrec:FIPPrecType):boolean;     {62}
begin
   SetControlLock :=
     SetValue(SetControlLockCmd,GetControlLockCmd,FIPPrec.ControlLock,FIPPrec);
end;

{-- new v2.6x -----}
function SetExtendedLabel(var FIPPrec:FIPPrecType):boolean;  {66}
var i : integer;
begin
  with FIPPrec do
  begin
    SetExtendedLabel := false;
    PacketError := GoodPacket;
    SendArray[0] := SetExtendedLabelCmd;
    SendArray[1] := MaxExtLabelSize shr 1; {div 2}
    ExtLabelData[pred(MaxExtLabelSize)] := #0; {force last byte to null}
    i := 0;
    while i < MaxExtLabelSize do
    begin
      SendArray[(i shr 1)+2] := (ord(ExtLabelData[i]) shl 8)+
                                 ord(ExtLabelData[succ(i)]);
      inc(i,2);
    end;
    SetExtendedLabel := SetPacket(FIPPrec);
  end;
end;


{-- new v2.6x -----}
function SetSpectrum(var FIPPrec:FIPPrecType):boolean;       {68}
begin
  with FIPPrec do
  begin
    SetSpectrum := false;
    PacketError := GoodPacket;
    SendArray[0] := SetSpectrumCmd;
    SendArray[1] := MaxSpectrumPos;
    move(Spectrum,SendArray[2],MaxSpectrumPos*sizeof(word));
    SetSpectrum := SetPacket(FIPPrec);
  end;
end;

{-- new v2.6x -----}
function SetPhaseTable(var FIPPrec:FIPPrecType):boolean;     {69}
begin
  with FIPPrec do
  begin
    SetPhaseTable := false;
    PacketError := GoodPacket;
    SendArray[0] := SetPhaseTableCmd;
    SendArray[1] := MaxPhasePos;
    move(PhaseTable,SendArray[2],MaxPhasePos*sizeof(word));
    SetPhaseTable := SetPacket(FIPPrec);
  end;
end;

{-- new v2.6x -----}
function SetOptionParams(var FIPPrec:FIPPrecType):boolean;   {70}
begin
  with FIPPrec do
  begin
    SetOptionParams := false;
    PacketError := GoodPacket;
    if OptionSize = 0 then OptionSize := 5;
    SendArray[0] := SetOptionParamsCmd;
    SendArray[1] := word(OptionSize);
    move(Options,SendArray[2],OptionSize*2);
    SetOptionParams := SetPacket(FIPPrec);
  end;
end;

{-- new v2.6x -----}
function SetKeyScanCode(var FIPPrec:FIPPrecType):boolean;        {72}
begin
  SetKeyScanCode :=
    SetValue(SetKeyScanCodeCmd,GetKeyScanCodeCmd,FIPPrec.KeyScanCode,FIPPrec);
end;

{-- new v3.2x -----}
function SetPollDelay(var FIPPrec:FIPPrecType):boolean;        {73}
var Temp : smallint;
begin
  Temp := FIPPrec.PollDelay;
  SetPollDelay := SetValue(SetPollDelayCmd,GetPollDelayCmd,Temp,FIPPrec);
  FIPPrec.PollDelay := Temp;
end;

{-- fp40 -----}
function SetTestEar(var FIPPrec:FIPPrecType):boolean;        {75}
begin
{   SetTestEar :=}
{     SetValue(SetTestEarCmd,GetTestEarCmd,FIPPrec.TestEar,FIPPrec);}
  with FIPPrec do
  begin
    SetTestEar := false;
    PacketError := GoodPacket;
    SendArray[0] := SetTestEarCmd;
    if EarConfig = 0 then SendArray[1] := 2 else SendArray[1] := 1;
    SendArray[2] := TestEar;
    SendArray[3] := EarConfig;
    SetTestEar := SetPacket(FIPPrec);
  end;
end;

{-- fp40 -----}
function SetOpState(var FIPPrec:FIPPrecType):boolean;    {77}
var OldTimer:word;
begin
  SetOpState :=
    SetValue(SetOpStateCmd,GetOpStateCmd,FIPPrec.OpState,FIPPrec);
end;



{-- fp40 -----}
function SetBatteryType(var FIPPrec:FIPPrecType):boolean;        {79}
begin
  SetBatteryType := false;
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := SetBatteryTypeCmd;
    SendArray[1] := 1;
    SendArray[2] := word(BatteryType);
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  SetBatteryType := true;
end;


{-- new v3.3x -----}
function SetAvgFreqs(var FIPPrec:FIPPrecType):boolean;        {82}
begin
{   SetAvgFreqs :=}
{     SetValue(SetAvgFreqsCmd,GetAvgFreqsCmd,integer(FIPPrec.AvgFreqs),FIPPrec);}
  with FIPPrec do
  begin
    SetAvgFreqs := false;
    PacketError := GoodPacket;
    SendArray[0] := SetAvgFreqsCmd;
    if UseAvgFreqValues then
    begin
      SendArray[1] := 6;
      move(AvgFreqValues,SendArray[2],sizeof(AvgFreqValues));
    end
    else
    begin
      SendArray[1] := 1;
      SendArray[2] := AvgFreqs;
    end;
    SetAvgFreqs := SetPacket(FIPPrec);
  end;
end;

{-- new v3.3x -----}
function SetSettleTime(var FIPPrec:FIPPrecType):boolean;        {84}
begin
   SetSettleTime :=
     SetValue(SetSettleTimeCmd,GetSettleTimeCmd,FIPPrec.FreqSettleTime,FIPPrec);
end;

function SetNewSettleTime(var FIPPrec:FIPPrecType):boolean;  {84} {new verison}
begin
{   SetSettleTime := }
{     SetValue(SetSettleTimeCmd,GetSettleTimeCmd,integer(FIPPrec.SettleTime),FIPPrec); }
  SetNewSettleTime := false;
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := SetSettleTimeCmd;
    SendArray[1] := 3;
    SendArray[2] := FreqSettleTime;
    SendArray[3] := AmpSettleTime;
    SendArray[4] := MeasureStartTime;
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  SetNewSettleTime := true;
end;

{-------}
{Assumes that the caller has set CICstate to the desired value.}

function SetCICstate(var FIPPrec:FIPPrecType):boolean;   {88}
begin
   SetCICstate :=
      SetValue(SetCICstateCmd,GetCICstateCmd,FIPPrec.CICstate,FIPPrec);
end;


{-- 6500 -----}
(* old cmd 89
function SetDefaultLabel(var FIPPrec:FIPPrecType):boolean;        {89}
begin
  SetDefaultLabel := false;
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := SetDefaultLabelCmd;
    SendArray[1] := 1;
    SendArray[2] := word(DefaultLabelType);
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  SetDefaultLabel := true;
end;
*)

function SetPrinterLabelStorage(var FIPPrec:FIPPrecType):boolean;   {89}
begin
  with FIPPrec do
  begin
    SetPrinterLabelStorage := false;
    PacketError := GoodPacket;
    SendArray[0] := SetPrinterLabelStorageCmd;
    SendArray[1] := 1;
    SendArray[2] := word(PrinterLabelStorage);
    if not SetPacket(FIPPrec) then Exit;
    SetPrinterLabelStorage := true;
  end;
end;

{---6500 V4.14--}
function SetAvgDelayTime(var FIPPrec:FIPPrecType):boolean;   {90}
begin
  with FIPPrec do
  begin
    SetAvgDelayTime := false;
    PacketError := GoodPacket;
    SendArray[0] := SetAvgDelayCmd;
    SendArray[1] := 2;
    SendArray[2] := word(AvgStartTime);
    SendArray[3] := word(AvgSettleTime);
    if not SetPacket(FIPPrec) then Exit;
  end;
  SetAvgDelayTime := true;
end;


{---6500 V4.20--}
function SetPrinterType(var FIPPrec:FIPPrecType):boolean;   {92}
begin
  with FIPPrec do
  begin
    SetPrinterType := false;
    PacketError := GoodPacket;
    SendArray[0] := SetPrinterTypeCmd;
    SendArray[1] := 1;
    SendArray[2] := word(PrinterType);
    if not SetPacket(FIPPrec) then Exit;
  end;
  SetPrinterType := true;
end;

{FP35 V1.10}
function SetPrinterLabelBitmap(var FIPPrec:FIPPrecType):boolean;   {96}
begin
  with FIPPrec do
  begin
    SetPrinterLabelBitmap := false;
    if (FryeBitmapSize = 0) or (FryeBitmap = nil) then Exit;
    PacketError := GoodPacket;
    SendArray[0] := SetPrinterLabelBitmapCmd;
    move(FryeBitmap^[1],SendArray[1],FryeBitmapSize*2);
    if not SetPacket(FIPPrec) then Exit;
  end;
  SetPrinterLabelBitmap := true;
end;

{---6500---}
function SetARparams(var FIPPrec:FIPPrecType):boolean;       {97} {6500}
begin
  with FIPPrec do
  begin
    SetARparams := false;
    PacketError := GoodPacket;
    SendArray[0] := SetARparamsCmd;
    SendArray[1] := 4;
    move(ARparams[0],SendArray[2],ARparamsSize*2);
    if not(SetPacket(FIPPrec)) then Exit;
    SetARparams := true;
  end;
end;

{-- FP35 v1.21 -----}
function SetBlob(var FIPPrec:FIPPrecType):boolean;           {99}
begin
  with FIPPrec do
  begin
    SetBlob := false;
    PacketError := GoodPacket;
    SendArray[0] := SetBlobCmd;
    SendArray[1] := BlobSize;
    move(Blob,SendArray[2],BlobSize*2);
    if not(SetPacket(FIPPrec)) then Exit;
    SetBlob := true;
  end;
end;


{---FP35 V1.00--}
function SetRealTimeClock(var FIPPrec:FIPPrecType):boolean;   {104}
var i : integer;
begin
  with FIPPrec do
  begin
    SetRealTimeClock := false;
    PacketError := GoodPacket;
    SendArray[0] := SetRealTimeClockCmd;
    SendArray[1] := 5;
    move(RealTimeClockData,SendArray[2],sizeof(RealTimeClockData));
    if not(SetPacket(FIPPrec)) then Exit;
    SetRealTimeClock := true;
  end;
end;

{--FP35 V2.00--}
{Assumes that the caller has set OutputDevice to the desired value.}
function SetOutputDevice(var FIPPrec:FIPPrecType):boolean; {106}
begin
   SetOutputDevice :=
      SetValue(SetOutputDeviceCmd,GetOutputDeviceCmd,FIPPrec.OutputDevice,FIPPrec);
end;

{--FP35 V2.00--}
{Assumes that the caller has set ImpulseRej to the desired value.}
function SetImpulseRej(var FIPPrec:FIPPrecType):boolean; {108}
begin
   SetImpulseRej :=
      SetValue(SetImpulseRejCmd,GetImpulseRejCmd,FIPPrec.ImpulseRej,FIPPrec);
end;

{--FP35 V2.00--}
{Assumes that the caller has set CurveSelect to the desired value.}
function SetCurveSelect(var FIPPrec:FIPPrecType):boolean; {112}
begin
   SetCurveSelect :=
      SetValue(SetCurveSelectCmd,GetCurveSelectCmd,FIPPrec.CurveSelect,FIPPrec);
end;

{--FP35 V2.00--}
{Assumes that the caller has set CurveStatus to the desired value.}
function SetCurveStatus(var FIPPrec:FIPPrecType):boolean; {114}
begin
  SetCurveStatus := false;
 {     SetValue(SetCurveStatusCmd,GetCurveStatusCmd,FIPPrec.CurveStatus,FIPPrec);}
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := SetCurveStatusCmd;
    SendArray[1] := 2;
    SendArray[2] := CurveSelect;
    SendArray[3] := CurveStatus;
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  SetCurveStatus := true;
end;

{--FP35 V2.00--}
{Assumes that the caller has set UnaidedSelect to the desired value.}
function SetUnaidedSelect(var FIPPrec:FIPPrecType):boolean; {116}
begin
   SetUnaidedSelect :=
      SetValue(SetUnaidedSelectCmd,GetUnaidedSelectCmd,FIPPrec.UnaidedSelect,FIPPrec);
end;

{--FP35 V2.10--}
{Assumes that the caller has set StaticToneSelect to the desired value.}
function SetStaticToneSelect(var FIPPrec:FIPPrecType):boolean; {121}
begin
   SetStaticToneSelect :=
      SetValue(SetStaticToneSelectCmd,GetStaticToneSelectCmd,FIPPrec.StaticToneSelect,FIPPrec);
end;

{--FP35 V2.10--}
{Assumes that the caller has set AidTypeSelect to the desired value.}
function SetAidTypeSelect(var FIPPrec:FIPPrecType):boolean; {123}
begin
   SetAidTypeSelect :=
      SetValue(SetAidTypeSelectCmd,GetAidTypeSelectCmd,FIPPrec.AidTypeSelect,FIPPrec);
end;

{future}
function SetBiasTone(var FIPPrec:FIPPrecType):boolean; {125}
begin
  SetBiasTone := false;
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := SetBiasToneCmd;
    SendArray[1] := 3;
    SendArray[2] := BiasToneSource;
    SendArray[3] := BiasToneFrequency;
    SendArray[4] := BiasToneDuration;
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  SetBiasTone := true;
end;

{--FP35 V2.20--}
{Assumes that the caller has set WarbleSelect to the desired value.}
{Only warble rate selection supported by this command. }
{Use Build command if enhanced warblerate selection is available}
function SetWarbleSelect(var FIPPrec:FIPPrecType):boolean; {129}
begin
   SetWarbleSelect :=
      SetValue(SetWarbleSelectCmd,GetWarbleSelectCmd,FIPPrec.WarbleSelect,FIPPrec);
end;


{-- new fp35 v2.20 -----}
function SetRcvTimeout(var FIPPrec:FIPPrecType):boolean;        {132}
var Temp : smallint;
begin
  Temp := FIPPrec.RcvTimeout;
  SetRcvTimeout := SetValue(SetRcvTimeoutCmd,GetRcvTimeoutCmd,Temp,FIPPrec);
  FIPPrec.RcvTimeout := Temp;
end;

{-- new fp35 v2.30 -----}
function SetFitRule(var FIPPrec:FIPPrecType):boolean;        {134}
var Temp : smallint;
begin
  Temp := FIPPrec.FitRule;
  SetFitRule := SetValue(SetFitRuleCmd,GetFitRuleCmd,Temp,FIPPrec);
  FIPPrec.FitRule := Temp;
end;


{-- new fp35 v3.00 -----}
function SetFilter(var FIPPrec:FIPPrecType):boolean;        {136}
var Temp : smallint;
begin
  Temp := FIPPrec.FilterType;
  SetFilter := SetValue(SetFilterCmd,GetFilterCmd,Temp,FIPPrec);
  FIPPrec.FilterType := Temp;
end;

{--FP35 V3.00--}
{Assumes that the caller has set compression to the desired value.}
function SetCompression(var FIPPrec:FIPPrecType):boolean; {138}
begin
   SetCompression :=
      SetValue(SetCompressionCmd,GetCompressionCmd,FIPPrec.Compression,FIPPrec);
end;

{--FP35 V3.00--}
{Assumes that the caller has set age to the desired value.}
function SetClientAge(var FIPPrec:FIPPrecType):boolean; {140}
begin
   SetClientAge :=
      SetValue(SetClientAgeCmd,GetClientAgeCmd,FIPPrec.ClientAge,FIPPrec);
end;

{--FP35 V3.10--}
{Assumes that the caller has set location to the desired value.}
function SetTransducerLoc(var FIPPrec:FIPPrecType):boolean; {142}
begin
   SetTransducerLoc :=
      SetValue(SetTransducerLocCmd,GetTransducerLocCmd,FIPPrec.TransducerLoc,FIPPrec);
end;


{-- FP35 v3.20 -----}
function SetLevelingList(var FIPPrec:FIPPrecType):boolean;       {145}
begin
  with FIPPrec do
  begin
    SetLevelingList := false;
    PacketError := GoodPacket;
    SendArray[0] := SetLevelingListCmd;
    SendArray[1] := LevelingListSize;
    move(LevelingList,SendArray[2],LevelingListSize*sizeof(word));
    SetLevelingList := SetPacket(FIPPrec);
  end;
end;

{--FP35 V3.20--}
{Assumes that the caller has set location to the desired value.}
function SetLevelingStatus(var FIPPrec:FIPPrecType):boolean; {147}
begin
   SetLevelingStatus :=
      SetValue(SetLevelingStatusCmd,GetLevelingStatusCmd,FIPPrec.LevelState,FIPPrec);
end;


{-- FP35 v3.20 -----}
function SetAuxPort(var FIPPrec:FIPPrecType):boolean;       {148}
var Index : integer;
begin
  with FIPPrec do
  begin
    SetAuxPort := false;
    PacketError := GoodPacket;
    SendArray[0] := SetAuxPortCmd;
    SendArray[2] := $0100;
    Index := 3;
    if integer(AuxStartCtrl) <> -1 then
    begin
      SendArray[2] := SendArray[2] or $0001;
      SendArray[3] := AuxStartCtrl;
      AuxCtrl := AuxStartCtrl;
      Index := Index + 1;
    end;
    SendArray[Index] := AuxOutCount;
    Index := Index + 1;
    if AuxOutCount > 0 then
    begin
      move(AuxOutData^,SendArray[Index],AuxOutCount);
      Index := Index + ((AuxOutCount + 1) div 2);
    end;
    if integer(AuxEndCtrl) <> -1 then
    begin
      SendArray[Index] := AuxEndCtrl;
      AuxCtrl := AuxEndCtrl;
      SendArray[2] := SendArray[2] or $0002;
      Index := Index + 1;
    end;
    SendArray[1] := Index - 2;
    SetAuxPort := SetPacket(FIPPrec);
  end;
end;

{--FP35 V3.20--}
{Assumes that the caller has set UserNumber to the desired value.}
function SetUserNumber(var FIPPrec:FIPPrecType):boolean; {150}
begin
   SetUserNumber :=
      SetValue(SetUserNumberCmd,GetUserNumberCmd,FIPPrec.UserNumber,FIPPrec);
end;


{-- new FP35 V3.20 -----}
function SetFitType(var FIPPrec:FIPPrecType):boolean;    {152} {fp35 v3.20 12/01/03}
begin
   SetFitType :=
      SetValue(SetFitTypeCmd,GetFitTypeCmd,FIPPrec.Fit.AidFitType,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function SetVentType(var FIPPrec:FIPPrecType):boolean;    {154} {fp35 v3.20 12/01/03}
begin
   SetVentType :=
      SetValue(SetVentTypeCmd,GetVentTypeCmd,FIPPrec.Fit.AidVentType,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function SetTubingType(var FIPPrec:FIPPrecType):boolean;    {156} {fp35 v3.20 12/01/03}
begin
   SetTubingType :=
      SetValue(SetTubingTypeCmd,GetTubingTypeCmd,FIPPrec.Fit.AidTubingType,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function SetAidChannels(var FIPPrec:FIPPrecType):boolean;    {158} {fp35 v3.20 12/01/03}
begin
   SetAidChannels :=
      SetValue(SetAidChannelsCmd,GetAidChannelsCmd,FIPPrec.Fit.AidChannels,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function SetAidLimiting(var FIPPrec:FIPPrecType):boolean;    {160} {fp35 v3.20 12/01/03}
begin
   SetAidLimiting :=
      SetValue(SetAidLimitingCmd,GetAidLimitingCmd,FIPPrec.Fit.AidLimiting,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function SetFitParam(var FIPPrec:FIPPrecType):boolean;    {164} {fp35 v3.20 12/01/03}
begin
  SetFitParam := false;
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := SetFitParamCmd;
    SendArray[1] := sizeof(FIPPrec.Fit) div sizeof(word);
    move(FIPPrec.Fit,SendArray[2],sizeof(FIPPrec.Fit));
    if not(SetPacket(FIPPrec)) then Exit;
  end;
  SetFitParam := true;
end;


{-- FP35 V3.20 -----}
function SetUserIDText(var FIPPrec:FIPPrecType):boolean;  {166}
var i : integer;
begin
  with FIPPrec do
  begin
    SetUserIDText := false;
    PacketError := GoodPacket;
    if UserNumber > 15 then UserNumber := 15;
    SendArray[0] := SetUserIDTextCmd;
    SendArray[1] := (MaxUserIDTextSize shr 1) + 1; {div 2}
    SendArray[2] := UserNumber;
    UserIDText[UserNumber][pred(MaxUserIDTextSize)] := #0; {force last byte to null}
    i := 0;
    while i < MaxUserIDTextSize do
    begin
      SendArray[(i shr 1)+3] := (ord(UserIDText[UserNumber][i]) shl 8)+
                                 ord(UserIDText[UserNumber][succ(i)]);
      inc(i,2);
    end;
    SetUserIDText := SetPacket(FIPPrec);
  end;
end;

{++++++++}
{The following procedures handle the standard FIPP Get commands}
{the command simply updates the appropriate variable in FIPPrec}
{it is up to the calling routine to insure that the desired variables}
{are properly updated before using them.}

{Get cmds return true if everything went ok. false if not
{(error in PacketError) if everything went ok,}
{value is returned in indicated variable}


{---------}
function GetRelAttData(var FIPPrec:FIPPrecType):boolean;      {18}
begin
  with FIPPrec do
  begin
    GetRelAttData := false;
    PacketError := GoodPacket;
    SendArray[0] := GetRelAttDataCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    AttackTime := integer(RcvArray[2]);
    ReleaseTime := integer(RcvArray[3]);
    GetRelAttData := true;
  end;
end;

{-------}
function GetBattery(var FIPPrec:FIPPrecType):boolean;     {19}
begin
  with FIPPrec do
  begin
    GetBattery := false;
    PacketError := GoodPacket;
    SendArray[0] := GetBatteryCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    BatteryCurrent := integer(RcvArray[2]);
    BatteryType := integer(RcvArray[3]);
    if RcvArray[1] > 2 then
      BatteryVolt := integer(RcvArray[4]);
    if RcvArray[1] > 3 then
      BatteryImp := integer(RcvArray[5]);
    GetBattery := true;
  end;
end;

{-------}
function GetIOdata(var FIPPrec:FIPPrecType):boolean;      {20}
begin
  with FIPPrec do
  begin
    GetIOdata := false;
    PacketError := GoodPacket;
    SendArray[0] := GetIOdataCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    move(RcvArray[2],IOcurve,IOcurveSize);
    GetIOdata := true;
  end;
end;

{-------}
function GetSourceAmp(var FIPPrec:FIPPrecType):boolean;   {21}
begin
   GetSourceAmp :=
     GetValue(GetSourceAmpCmd,FIPPrec.SourceAmp,FIPPrec);
end;

{-------}
function GetDistMode(var FIPPrec:FIPPrecType):boolean;    {22}
begin
   GetDistMode :=
     GetValue(GetDistModeCmd,FIPPrec.DistMode,FIPPrec);
end;

{-------}
function GetFrequency(var FIPPrec:FIPPrecType):boolean;   {23}
begin
   GetFrequency :=
     GetValue(GetFrequencyCmd,FIPPrec.Frequency,FIPPrec);
end;

{-------}
function GetOESstate(var FIPPrec:FIPPrecType):boolean;   {24}
begin
   GetOESstate :=
     GetValue(GetOESstateCmd,FIPPrec.OESstate,FIPPrec);
end;

{-------}
function GetCurveFrame(var FIPPrec:FIPPrecType):boolean;  {25}
var CurveFormat: word;
var ByteSize : word;
begin
  with FIPPrec do
  begin
    PacketError := 0;
    PacketError := GoodPacket;
    GetCurveFrame := false;
    SendArray[0] := GetCurveFrameCmd;
    SendArray[1] := 1;
    SendArray[2] := word(CurveNumber);
    if not(GetPacket(FIPPrec)) then Exit;

    fillchar(CurveFrame,sizeof(CurveFrame),0);
    CurveNumber := integer(RcvArray[2]);
    CurveFormat := (RcvArray[3] shr 10) and 7;
    if ((CurveFormat = 2) or (CurveFormat = 3)) then
     CurveFrameSize := AudCurveFrameSize
    else CurveFrameSize := StdCurveFrameSize;
    ByteSize := CurveFrameSize*2;
    move(RcvArray[3],CurveFrame,ByteSize);
    GetCurveFrame := true;
  end;
end;

{-------}
function GetNoiseRedCount(var FIPPrec:FIPPrecType):boolean;    {26}
begin
   GetNoiseRedCount :=
     GetValue(GetNoiseRedCountCmd,FIPPrec.NoiseRedCount,FIPPrec);
end;

{--------}
function GetSmoothState(var FIPPrec:FIPPrecType):boolean; {27}
begin
   GetSmoothState :=
     GetValue(GetSmoothStateCmd,FIPPrec.SmoothState,FIPPrec);
end;

{-------}
function GetDevVersion(var FIPPrec:FIPPrecType):boolean;      {28}
begin
  with FIPPrec do
  begin
    GetDevVersion := false;
    PacketError := GoodPacket;
    SendArray[0] := GetDevVersionCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    fillchar(Version,sizeof(Version),0);
    move(RcvArray[2],Version,Sizeof(Version));
    UpdateFryersInfo(FIPPrec);
    GetDevVersion := true;
  end;
end;

{-------}
function GetLevelState(var FIPPrec:FIPPrecType):boolean;  {29}
begin
   GetLevelState :=
     GetValue(GetLevelingStatusCmd,FIPPrec.LevelState,FIPPrec);
end;

{-------}
function GetWeightState(var FIPPrec:FIPPrecType):boolean; {30}
begin
   GetWeightState :=
     GetValue(GetWeightStateCmd,FIPPrec.WeightState,FIPPrec);
end;

{-------}
function GetMicData(var FIPPrec:FIPPrecType):boolean;       {31}
begin
   GetMicData :=
      GetValue(GetMicDataCmd,FIPPrec.MicData,FIPPrec);
end;

{-------}
function GetDistPercent(var FIPPrec:FIPPrecType):boolean;    {32}
begin
   GetDistPercent :=
     GetValue(GetDistPercentCmd,FIPPrec.DistPercent,FIPPrec);
end;

{-------}
function GetCmdStatus(var FIPPrec:FIPPrecType):boolean;    {33}
begin
  GetCmdStatus := false;
  with FIPPrec do
  begin
    CmdStatusFailed := true;
    PacketError := GoodPacket;
    SendArray[0] := GetCmdStatusCmd;
    SendArray[1] := 0;
    if SendCommand(FIPPrec) then
    begin
      if (RcvArray[0] and $7fff) <> SendArray[0] then
      begin
        PacketError := ResponseError;
        Exit;
      end;
    end;
    if PacketError <> 0 then Exit;
    FIPPrec.CmdStatus := integer(RcvArray[2]);
    UpdateFryersInfo(FIPPrec);
    CmdStatusFailed := false;
  end;
  GetCmdStatus := true;
end;

{-------}
function GetIOmode(var FIPPrec:FIPPrecType):boolean;       {34}
begin
  with FIPPrec do
  begin
    GetIOmode := false;
    PacketError := GoodPacket;
    SendArray[0] := GetIOmodeCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    IOFrequency := integer(RcvArray[2]);
    IOGain := integer(RcvArray[3]);
    GetIOmode := true;
  end;
end;

{-------}
function GetProbeState(var FIPPrec:FIPPrecType):boolean;    {35}
begin
   GetProbeState :=
     GetValue(GetProbeStateCmd,FIPPrec.ProbeState,FIPPrec);
end;

{-------}
function GetGainState(var FIPPrec:FIPPrecType):boolean;   {36}
begin
   GetGainState :=
     GetValue(GetGainStateCmd,FIPPrec.GainState,FIPPrec);
end;

{-------}
function GetTelCoilState(var FIPPrec:FIPPrecType):boolean; {37}
begin
   GetTelCoilState :=
     GetValue(GetTelCoilStateCmd,FIPPrec.TelCoilState,FIPPrec);
end;

{-------}
function GetRelAttFreq(var FIPPrec:FIPPrecType):boolean;    {41}
begin
   GetRelAttFreq :=
     GetValue(GetRelAttFreqCmd,FIPPrec.RelAttFreq,FIPPrec);
end;

{-------}
function GetLastCurve(var FIPPrec:FIPPrecType):boolean;     {42}
var CurveFormat: word;
var ByteSize : word;
begin
  with FIPPrec do
  begin
    GetLastCurve := false;
    PacketError := GoodPacket;
    SendArray[0] := GetLastCurveCmd;      {- last curve is number 99}
    SendArray[1] := 0;                    {- note last curve is same}
    if not(GetPacket(FIPPrec)) then Exit; {- as normal curve, but no}
    CurveNumber := 99;                    {- curve number is provided}
    CurveFormat := (RcvArray[3] shr 10) and 7;
    if ((CurveFormat = 2) or (CurveFormat = 3)) then
     CurveFrameSize := AudCurveFrameSize
    else CurveFrameSize := StdCurveFrameSize;
    ByteSize := (CurveFrameSize+3)*2; {cmd,len,crv#,crv}
    move(RcvArray[2],CurveFrame,ByteSize);
    GetLastCurve := true;
  end;
end;

{-------}
function GetTelCoilMode(var FIPPrec:FIPPrecType):boolean; {44}
begin
   GetTelCoilMode :=
     GetValue(GetTelCoilModeCmd,FIPPrec.TelCoilMode,FIPPrec);
end;

{-------}
function GetZetaState(var FIPPrec:FIPPrecType):boolean;    {45}
begin
   GetZetaState :=
     GetValue(GetZetaStateCmd,FIPPrec.ZetaState,FIPPrec);
end;

{-------}
function GetInsitu(var FIPPrec:FIPPrecType):boolean;       {46}
begin
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    GetInsitu := false;
    SendArray[0] := GetInsituCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    Insitu[0] := word(RcvArray[2]);
    Insitu[1] := word(RcvArray[3]);
    Insitu[2] := word(RcvArray[4]);
    GetInsitu := true;
  end;
end;

{-------}
function GetAutoState(var FIPPrec:FIPPrecType):boolean;    {49}
begin
   GetAutoState :=
     GetValue(GetAutoStateCmd,FIPPrec.AutoState,FIPPrec);
end;


{-------}
function GetLimitValue(var FIPPrec:FIPPrecType):boolean;    {51}
begin
   GetLimitValue :=
     GetValue(GetLimitValueCmd,FIPPrec.LimitValue,FIPPrec);
end;


{-------}
function GetRefMicState(var FIPPrec:FIPPrecType):boolean;    {53}
begin
   GetRefMicState :=
     GetValue(GetRefMicStateCmd,FIPPrec.RefMicState,FIPPrec);
end;



{-------}
function GetActiveStatus(var FIPPrec:FIPPrecType):boolean;    {55}
begin
   GetActiveStatus :=
     GetValue(GetActiveStatusCmd,FIPPrec.ActiveStatus,FIPPrec);
end;


{-------}
function GetRefMicData(var FIPPrec:FIPPrecType):boolean;       {57}
begin
   GetRefMicData :=
      GetValue(GetRefMicDataCmd,FIPPrec.RefMicData,FIPPrec);
end;


{-- new v2.6x -----}
function GetKeyScanCode(var FIPPrec:FIPPrecType):boolean;        {58}
begin
   GetKeyScanCode :=
     GetValue(GetKeyScanCodeCmd,FIPPrec.KeyScanCode,FIPPrec);
end;

{-- new v2.6x -----}
function GetMachineState(var FIPPrec:FIPPrecType):boolean;   {60}
begin
  with FIPPrec do
  begin
    GetMachineState := false;
    PacketError := GoodPacket;
    SendArray[0] := GetMachineStateCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    MajorMachineState := integer(RcvArray[2]);
    MinorMachineState := integer(RcvArray[3]);
    GetMachineState := true;
  end;
end;

{-- new v2.6x -----}
function GetBlob(var FIPPrec:FIPPrecType):boolean;           {61}
begin
  with FIPPrec do
  begin
    GetBlob := false;
    FillWord(Blob,Sizeof(Blob) div 2,$8000);
    PacketError := GoodPacket;
    SendArray[0] := GetBlobCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    BlobSize := word(RcvArray[1]);
    move(RcvArray[2],Blob,BlobSize*2);
    GetBlob := true;
  end;
end;

{-- new v2.6x -----}
function GetControlLock(var FIPPrec:FIPPrecType):boolean;     {63}
begin
   GetControlLock :=
     GetValue(GetControlLockCmd,FIPPrec.ControlLock,FIPPrec);
end;

{-- new v2.6x -----}
function GetOptionParams(var FIPPrec:FIPPrecType):boolean;   {71}
begin
  with FIPPrec do
  begin
    GetOptionParams := false;
    FillWord(Options[1],(Sizeof(Options) div 2)-1,$8000);
    PacketError := GoodPacket;
    SendArray[0] := GetOptionParamsCmd;
    SendArray[1] := 1;
    SendArray[2] := word(Options[0]);
    if not(GetPacket(FIPPrec)) then Exit;
    OptionSize := word(RcvArray[1]);
    move(RcvArray[2],Options,OptionSize*2);
    GetOptionParams := true;
  end;
end;


{-- new v2.6x -----}
function GetPollDelay(var FIPPrec:FIPPrecType):boolean;     {74}
var Temp : smallint;
begin
   GetPollDelay := GetValue(GetPollDelayCmd,Temp,FIPPrec);
   FIPPrec.PollDelay := Temp;
end;

{-- fp40 -----}
function GetTestEar(var FIPPrec:FIPPrecType):boolean;     {76}
begin
  with FIPPrec do
  begin
    GetTestEar := false;
    PacketError := GoodPacket;
    SendArray[0] := GetTestEarCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    TestEar := integer(RcvArray[2]);
    if (RcvArray[1] > 1) then
      EarConfig := integer(RcvArray[3])
    else EarConfig := -1;
    GetTestEar := true;
   { if EarConfig >= 0 then EarCmdType = 1 else EarCmdType = 2;}
  end;
   {GetTestEar :=
     GetValue(GetTestEarCmd,integer(FIPPrec.TestEar),FIPPrec);}
end;

{-- fp40 -----}
function GetOpState(var FIPPrec:FIPPrecType):boolean;    {78}
begin
   GetOpState :=
     GetValue(GetOpStateCmd,FIPPrec.OpState,FIPPrec);
end;



{-- fp40 -----}
function GetPowerStatus(var FIPPrec:FIPPrecType):boolean;   {80}
begin
  with FIPPrec do
  begin
    GetPowerStatus := false;
    PacketError := GoodPacket;
    SendArray[0] := GetPowerStatusCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    PowerVoltage := integer(RcvArray[2]);
    PowerFlags := word(RcvArray[3]);
    if (RcvArray[1] > 2) then
      StandbyTimeout := word(RcvArray[4])
    else StandbyTimeout := -1;
    if (RcvArray[1] > 3) then
      PowerDownTimeout := word(RcvArray[5])
    else PowerDownTimeout := -1;
    GetPowerStatus := true;
  end;
end;


{-- new v3.3x -----}
function GetAvgFreqs(var FIPPrec:FIPPrecType):boolean;     {81}
begin
   {GetAvgFreqs :=}
   {  GetValue(GetAvgFreqsCmd,integer(FIPPrec.AvgFreqs),FIPPrec);}
  with FIPPrec do
  begin
    GetAvgFreqs := false;
    PacketError := GoodPacket;
    SendArray[0] := GetAvgFreqsCmd;
    if UseAvgFreqValues then
    begin
      SendArray[1] := 1;
      SendArray[2] := AvgFreqs;
    end
    else SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    if not(UseAvgFreqValues) and (smallint(RcvArray[2]) = -1) then
    begin
      AvgFreqs := -1;
      SendArray[1] := 1;
      SendArray[2] := RcvArray[2];
      UseAvgFreqValues := true;
    end;
    if not(GetPacket(FIPPrec)) then Exit;
    if UseAvgFreqValues then
      move(RcvArray[2],AvgFreqValues,sizeof(AvgFreqValues))
    else AvgFreqs := smallint(RcvArray[2]);
    GetAvgFreqs := true;
  end;
end;

{-- new v3.3x -----}
function GetSettleTime(var FIPPrec:FIPPrecType):boolean;     {83}
begin
   {GetSettleTime := }
   {  GetValue(GetSettleTimeCmd,integer(FIPPrec.SettleTime),FIPPrec); }
  with FIPPrec do
  begin
    GetSettleTime := false;
    PacketError := GoodPacket;
    SendArray[0] := GetSettleTimeCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    FreqSettleTime := integer(RcvArray[2]);
    if RcvArray[1] > 1 then
    begin
      SettleType := 1;
      AmpSettleTime := integer(RcvArray[3]);
      MeasureStartTime := integer(RcvArray[4]);
    end
    else
    begin
      SettleType := 0;
      AmpSettleTime := 0;
      MeasureStartTime := 0;
    end;
    GetSettleTime := true;
  end;
end;


{-- new v4.0x -----}
function GetExtendedLabel(var FIPPrec:FIPPrecType):boolean;  {86}
var i : integer;
begin
  with FIPPrec do
  begin
    GetExtendedLabel := false;
    PacketError := GoodPacket;
    SendArray[0] := GetExtendedLabelCmd;
    SendArray[1] := 1;
    SendArray[2] := LabelType;
    if not(GetPacket(FIPPrec)) then Exit;
    i := 0;
    while i < MaxExtLabelSize do
    begin
      ExtLabelData[i] := char(RcvArray[(i shr 1)+2] shr 8);
      ExtLabelData[succ(i)] := char(RcvArray[(i shr 1)+2] and $ff);
      inc(i,2);
    end;
    ExtLabelData[pred(MaxExtLabelSize)] := #0; {force last byte to null}
    GetExtendedLabel := true;
  end;
end;

{-------}
function GetCICstate(var FIPPrec:FIPPrecType):boolean;   {87}
begin
   GetCICstate :=
     GetValue(GetCICstateCmd,FIPPrec.CICstate,FIPPrec);
end;


{---6500 V4.14--}
function GetAvgDelayTime(var FIPPrec:FIPPrecType):boolean;   {91}
begin
  with FIPPrec do
  begin
    GetAvgDelayTime := false;
    PacketError := GoodPacket;
    SendArray[0] := GetAvgDelayCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    AvgStartTime := integer(RcvArray[2]);
    AvgSettleTime := integer(RcvArray[3]);
    GetAvgDelayTime := true;
  end;
end;

{---6500 V4.20--}
function GetPrinterType(var FIPPrec:FIPPrecType):boolean;   {93}
begin
  with FIPPrec do
  begin
    GetPrinterType := false;
    PacketError := GoodPacket;
    SendArray[0] := GetPrinterTypeCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    PrinterType := integer(RcvArray[2]);
    GetPrinterType := true;
  end;
end;


{---6500 V4.40--}
function GetHFAMeasurement(var FIPPrec:FIPPrecType):boolean;   {94}
begin
  with FIPPrec do
  begin
    GetHFAMeasurement := false;
    PacketError := GoodPacket;
    SendArray[0] := GetHFAMeasurementCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    HFAData := integer(RcvArray[2]);
    GetHFAMeasurement := true;
  end;
end;

{---FP35 V2.00-- : SerialNumber & mfg/cal dates added in V2.20}
function GetInstrumentInfo(var FIPPrec:FIPPrecType):boolean;   {95}
var Size : integer;
begin
  with FIPPrec do
  begin
    GetInstrumentInfo := false;
    PacketError := GoodPacket;
    SendArray[0] := GetInstrumentInfoCmd;
    SendArray[1] := 0;
    fillchar(InstrumentInfo,sizeof(InstrumentInfo),0);
    fillchar(InstrumentInfo.SerialNumber,sizeof(InstrumentInfo.SerialNumber),'?');
    InstrumentInfo.SerialNumber := 'UNKNOWN?';
    if not(GetPacket(FIPPrec)) then Exit;
    Size := RcvArray[1];
    if Size < 0 then Size := 0;
    if Size > (sizeof(InstrumentInfo) div 2) then
      Size := sizeof(InstrumentInfo) div 2;
    move(RcvArray[2],InstrumentInfo,Size*2);
    GetInstrumentInfo := true;
  end;
end;

{------- 6500 ------}
function GetARparams(var FIPPrec:FIPPrecType):boolean;       {98} {6500}
begin
  with FIPPrec do
  begin
    GetARparams := false;
    PacketError := GoodPacket;
    SendArray[0] := GetARparamsCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    move(RcvArray[2],ARparams,ARparamsSize);
    GetARparams := true;
  end;
end;

{---FP35 V1.00--}
function GetDeviceIDCount(var FIPPrec:FIPPrecType):boolean;   {100}
begin
  with FIPPrec do
  begin
    GetDeviceIDCount := false;
    PacketError := GoodPacket;
    SendArray[0] := GetDeviceIDCountCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    DeviceIDCount := integer(RcvArray[2]);
    GetDeviceIDCount := true;
  end;
end;

{---FP35 V1.00--}
function GetLongDeviceID(var FIPPrec:FIPPrecType):boolean;   {101}
{var i : integer;}
begin
  with FIPPrec do
  begin
    GetLongDeviceID := false;
    PacketError := GoodPacket;
    SendArray[0] := GetLongDeviceIDCmd;
    SendArray[1] := 1;
    SendArray[2] := DeviceIDNumber;
    if not(GetPacket(FIPPrec)) then Exit;
    move(RcvArray[2],LongDeviceID,sizeof(LongDeviceID));
    GetLongDeviceID := true;
  end;
end;


{---FP35 V2.00--}
function GetDeviceData(var FIPPrec:FIPPrecType):boolean;   {102}
var i : integer;
begin
  with FIPPrec do
  begin
    GetDeviceData := false;
    PacketError := GoodPacket;
    SendArray[0] := GetDeviceDataCmd;
    SendArray[1] := 2;
    SendArray[2] := DeviceIDNumber;
    SendArray[3] := DeviceSelection;
    if not(GetPacket(FIPPrec)) then Exit;
    DeviceDataSize := word(RcvArray[1]);
    if DeviceDataSize > sizeof(DeviceDataArray^) then
      DeviceDataSize := sizeof(DeviceDataArray^);
    move(RcvArray[2],DeviceDataArray^,DeviceDataSize*2);
    GetDeviceData := true;
  end;
end;

{---FP35 V1.00--}
function GetRealTimeClock(var FIPPrec:FIPPrecType):boolean;   {103}
var i : integer;
begin
  with FIPPrec do
  begin
    GetRealTimeClock := false;
    PacketError := GoodPacket;
    SendArray[0] := GetRealTimeClockCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    move(RcvArray[2],RealTimeClockData,sizeof(RealTimeClockData));
    GetRealTimeClock := true;
  end;
end;

{--FP35 V2.00---}
function GetOutputDevice(var FIPPrec:FIPPrecType):boolean;   {105}
begin
   GetOutputDevice :=
     GetValue(GetOutputDeviceCmd,FIPPrec.OutputDevice,FIPPrec);
end;

{--FP35 V2.00---}
function GetImpulseRej(var FIPPrec:FIPPrecType):boolean;   {107}
begin
   GetImpulseRej :=
     GetValue(GetImpulseRejCmd,FIPPrec.ImpulseRej,FIPPrec);
end;

{---FP35 V2.00--}
function GetSignalInfo(var FIPPrec:FIPPrecType):boolean;   {109}
begin
  with FIPPrec do
  begin
    GetSignalInfo := false;
    PacketError := GoodPacket;
    SendArray[0] := GetSignalInfoCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    if RcvArray[1] > (sizeof(SignalInfo) div 2) then
      SignalInfoSize := sizeof(SignalInfo) div 2
    else SignalInfoSize := RcvArray[1];
    move(RcvArray[2],SignalInfo,SignalInfoSize*2);
    GetSignalInfo := true;
  end;
end;


{---FP35 V1.00--}
function GetRawSampleData(var FIPPrec:FIPPrecType):boolean;   {110}
var i : integer;
begin
  with FIPPrec do
  begin
    GetRawSampleData := false;
    PacketError := GoodPacket;
    SendArray[0] := GetRawSampleDataCmd;
    SendArray[1] := 3;
    SendArray[2] := RawDataSelection;
    SendArray[3] := RawDataMethod;
    SendArray[4] := RawSampleCount;
    if not(GetPacket(FIPPrec)) then Exit;
    RawSamplePacketSize := word(RcvArray[1]+2);
    if RawSamplePacketSize > MaxRawSampleData then
      RawSamplePacketSize := MaxRawSampleData;
    move(RcvArray[0],RawSampleData^,RawSamplePacketSize*2);
    GetRawSampleData := true;
  end;
end;

{--FP35 V2.00---}
function GetCurveSelect(var FIPPrec:FIPPrecType):boolean;   {113}
begin
   GetCurveSelect :=
     GetValue(GetCurveSelectCmd,FIPPrec.CurveSelect,FIPPrec);
end;

{--FP35 V2.00---}
function GetCurveStatus(var FIPPrec:FIPPrecType):boolean;   {115}
begin
  GetCurveStatus := false;
  {GetValue(GetCurveStatusCmd,FIPPrec.CurveStatus,FIPPrec);}
  with FIPPrec do
  begin
    PacketError := GoodPacket;
    SendArray[0] := GetCurveStatusCmd;
    SendArray[1] := 1;
    SendArray[2] := CurveSelect; {use curve select for the curve we want}
    if not(GetPacket(FIPPrec)) then Exit;
    CurveStatus := RcvArray[2];
  end;
  GetCurveStatus := true;
end;

{--FP35 V2.00---}
function GetUnaidedSelect(var FIPPrec:FIPPrecType):boolean;   {117}
begin
   GetUnaidedSelect :=
     GetValue(GetUnaidedSelectCmd,FIPPrec.UnaidedSelect,FIPPrec);
end;

{--FP35 V2.10---}
function GetStaticToneSelect(var FIPPrec:FIPPrecType):boolean;   {122}
begin
   GetStaticToneSelect :=
     GetValue(GetStaticToneSelectCmd,FIPPrec.StaticToneSelect,FIPPrec);
end;

{--FP35 V2.10---}
function GetAidTypeSelect(var FIPPrec:FIPPrecType):boolean;   {124}
begin
   GetAidTypeSelect :=
     GetValue(GetAidTypeSelectCmd,FIPPrec.AidTypeSelect,FIPPrec);
end;

{--FP35 V2.10---}
function GetBiasTone(var FIPPrec:FIPPrecType):boolean;   {126}
begin
  with FIPPrec do
  begin
    GetBiasTone := false;
    PacketError := GoodPacket;
    SendArray[0] := GetBiasToneCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    BiasToneSize := RcvArray[1]; {number items actually received}
    BiasToneSource := RcvArray[2];
    BiasToneFrequency := RcvArray[3];
    BiasToneDuration := RcvArray[4];
    GetBiasTone := true;
  end;
end;

{--FP35 V2.20---}
function GetWarbleSelect(var FIPPrec:FIPPrecType):boolean;   {130}
begin
  with FIPPrec do
  begin
    GetWarbleSelect := false;
    PacketError := GoodPacket;
    SendArray[0] := GetWarbleSelectCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    WarbleSelect := RcvArray[2];
    if RcvArray[1] > 1 then
      WarbleAmount := RcvArray[3]
    else WarbleAmount := 0;
    if RcvArray[1] > 2 then
      WarbleRate := RcvArray[4]
    else WarbleRate := 0;
    GetWarbleSelect := true;
  end;
end;

{--6500 V4.72---}
function GetDelayMeasurments(var FIPPrec:FIPPrecType):boolean;   {131}
begin
  with FIPPrec do
  begin
    GetDelayMeasurments := false;
    PacketError :=GoodPacket;
    SendArray[0] := GetMeasurmentDelaysCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    SystemDelay := word(RcvArray[2]);
    HearingAidDelay := word(RcvArray[3]);
    GetDelayMeasurments := true;
  end;
end;

{-- new fp35 v2.20 -----}
function GetRcvTimeout(var FIPPrec:FIPPrecType):boolean;     {133}
var Temp : smallint;
begin
   GetRcvTimeout := GetValue(GetRcvTimeoutCmd,Temp,FIPPrec);
   FIPPrec.RcvTimeout := Temp;
end;


{-- new fp35 v2.30 -----}
function GetFitRule(var FIPPrec:FIPPrecType):boolean;     {135}
var Temp : smallint;
begin
   GetFitRule := GetValue(GetFitRuleCmd,Temp,FIPPrec);
   FIPPrec.FitRule := Temp;
end;

{-- new fp35 v3.00 -----}
function GetFilter(var FIPPrec:FIPPrecType):boolean;     {137}
var Temp : smallint;
begin
   GetFilter := GetValue(GetFilterCmd,Temp,FIPPrec);
   FIPPrec.FilterType := Temp;
end;

{--FP35 V3.00---}
function GetCompression(var FIPPrec:FIPPrecType):boolean;   {139}
begin
   GetCompression :=
     GetValue(GetCompressionCmd,FIPPrec.Compression,FIPPrec);
end;

{--FP35 V3.00---}
function GetClientAge(var FIPPrec:FIPPrecType):boolean;   {141}
begin
   GetClientAge :=
     GetValue(GetClientAgeCmd,FIPPrec.ClientAge,FIPPrec);
end;

{--FP35 V3.10---}
function GetTransducerLoc(var FIPPrec:FIPPrecType):boolean;   {143}
begin
   GetTransducerLoc :=
     GetValue(GetTransducerLocCmd,FIPPrec.TransducerLoc,FIPPrec);
end;


{-------}
function GetLevelingList(var FIPPrec:FIPPrecType):boolean;  {146}
var CurveFormat: word;
var ByteSize : word;
begin
  with FIPPrec do
  begin
    PacketError := 0;
    PacketError := GoodPacket;
    GetLevelingList := false;
    SendArray[0] := GetLevelingListCmd;
    SendArray[1] := WhichLevelingList;
    if not(GetPacket(FIPPrec)) then Exit;
    LevelingListSize := RcvArray[1];
    ByteSize := LevelingListSize*2;
    if ByteSize > sizeof(LevelingList) then
    begin
      ByteSize := sizeof(LevelingList);
      LevelingListSize := ByteSize div 2;
    end;
    fillchar(LevelingList,sizeof(LevelingList),0);
    move(RcvArray[2],LevelingList,ByteSize);
    GetLevelingList := true;
  end;
end;

{--FP35 V3.20---}
function GetAuxPort(var FIPPrec:FIPPrecType):boolean;   {149}
begin
  with FIPPrec do
  begin
    GetAuxPort := false;
    PacketError :=GoodPacket;
    SendArray[0] := GetAuxPortCmd;
    SendArray[1] := 1;
    SendArray[2] := $0101;
    if not(GetPacket(FIPPrec)) then Exit;
    AuxCtrl := word(RcvArray[2]);
    if RcvArray[1] > 1 then
    begin
      fillchar(AuxInData^,sizeof(AuxInData^),0);
      AuxInCount := RcvArray[3];
      if AuxInCount > 0 then
        move(RcvArray[4],AuxInData^,AuxInCount);
    end;
    GetAuxPort := true;
  end;
end;


{--FP35 V3.20---}
function GetUserNumber(var FIPPrec:FIPPrecType):boolean;   {151}
begin
  with FIPPrec do
  begin
    GetUserNumber := false;
    PacketError :=GoodPacket;
    SendArray[0] := GetUserNumberCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    UserNumber := word(RcvArray[2]);
    if RcvArray[1] > 1 then
      MaxUser := RcvArray[3];
    GetUserNumber := true;
  end;
end;

{-- new FP35 V3.20 -----}
function GetFitType(var FIPPrec:FIPPrecType):boolean;    {153} {fp35 v3.20 12/01/03}
begin
   GetFitType :=
     GetValue(GetFitTypeCmd,FIPPrec.Fit.AidFitType,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function GetVentType(var FIPPrec:FIPPrecType):boolean;    {155} {fp35 v3.20 12/01/03}
begin
   GetVentType :=
     GetValue(GetVentTypeCmd,FIPPrec.Fit.AidVentType,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function GetTubingType(var FIPPrec:FIPPrecType):boolean;    {157} {fp35 v3.20 12/01/03}
begin
   GetTubingType :=
     GetValue(GetTubingTypeCmd,FIPPrec.Fit.AidTubingType,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function GetAidChannels(var FIPPrec:FIPPrecType):boolean;    {159} {fp35 v3.20 12/01/03}
begin
   GetAidChannels :=
     GetValue(GetAidChannelsCmd,FIPPrec.Fit.AidChannels,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function GetAidLimiting(var FIPPrec:FIPPrecType):boolean;    {161} {fp35 v3.20 12/01/03}
begin
   GetAidLimiting :=
     GetValue(GetAidLimitingCmd,FIPPrec.Fit.AidLimiting,FIPPrec);
end;

{-- new FP35 V3.20 -----}
function GetFitParam(var FIPPrec:FIPPrecType):boolean;    {165} {fp35 v3.20 12/01/03}
var FitSize : word;
begin
  with FIPPrec do
  begin
    GetFitParam := false;
    PacketError := GoodPacket;
    SendArray[0] := GetFitParamCmd;
    SendArray[1] := 0;
    if not(GetPacket(FIPPrec)) then Exit;
    if RcvArray[1] > (sizeof(Fit) div 2) then
      FitSize := sizeof(Fit) div 2
    else FitSize := RcvArray[1];
    move(RcvArray[2],FIPPrec.Fit,FitSize*2);
    GetFitParam := true;
  end;
end;

{-- new FP35 V3.20 -----}
function GetUserIDText(var FIPPrec:FIPPrecType):boolean;  {167}
var i : integer;
begin
  with FIPPrec do
  begin
    GetUserIDText := false;
    PacketError := GoodPacket;
    if UserNumber > 15 then UserNumber := 0;
    SendArray[0] := GetUserIDTextCmd;
    SendArray[1] := 1;
    SendArray[2] := UserNumber;
    if not(GetPacket(FIPPrec)) then Exit;
    i := 0;
    while i < MaxUserIDTextSize do
    begin
      UserIDText[UserNumber][i] := char(RcvArray[(i shr 1)+2] shr 8);
      UserIDText[UserNumber][succ(i)] := char(RcvArray[(i shr 1)+2] and $ff);
      inc(i,2);
    end;
    UserIDText[UserNumber][pred(MaxUserIDTextSize)] := #0; {force last byte to null}
    GetUserIDText := true;
  end;
end;



{+++++++++}
{The following procedures handle the standard FIPP Do commands}

{-------}
{SendDoCmd is used for most of the Do functions since they all pass}
{a single integer value. Makes it much simpler.}
function SendDoCmd(DoCmd:word; var FIPPrec:FIPPrecType):boolean;
begin
  with FIPPrec do
  begin
    SendDoCmd := false;
    PacketError := GoodPacket;
    SendArray[0] := DoCmd;
    SendArray[1] := 0;
    if not(DoPacket(FIPPrec)) then Exit;
    SendDoCmd := true;
  end;
end;


{++++++}
{Do cmds - return true if everything went ok. }
{false if not (error in PacketError)}


{-------}
{Assumes that the desired state has been stored to RelAttState.}
{Note: Must be called with RelAttState "0" to exit this mode.}

function DoRelAttSelect(var FIPPrec:FIPPrecType):boolean;  {13}
var OldTimer:integer;
begin
  with FIPPrec do
  begin
     PacketError := GoodPacket;
     GetPollTimer(FIPPrec);      {get real poll timeout value}
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 500 then    {If less than 27 seconds}
     begin
       PollTimer := 500;        {force it to 27 seconds abort}
       SetPollTimer(FIPPrec);
     end;
     DoRelAttSelect := false;
     SendArray[0] := DoRelAttSelectCmd;
     SendArray[1] := 1;
     SendArray[2] := word(RelAttState);
     if DoPacket(FIPPrec) then
       DoRelAttSelect := true;
     PollTimer := OldTimer;
     SetPollTimer(FIPPrec);      {restore original poll timeout value}
  end;
end;

{-------}
function DoBattery(var FIPPrec:FIPPrecType):boolean;      {14}
begin
   DoBattery :=
     SendDoCmd(DoBatteryCmd,FIPPrec);
end;

{-------}
{Assumes that the desired state has been stored to IOState.}
{Note: Must be called with IOState "0" to exit this mode.}

function DoIOSelect(var FIPPrec:FIPPrecType):boolean;  {15}
var OldTimer:integer;
begin
  with FIPPrec do
  begin
     DoIOSelect := false;
     PacketError := GoodPacket;
     GetPollTimer(FIPPrec);      {get real poll timeout value}
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 300 then    {If less than 15 seconds}
     begin
       PollTimer := 300;        {force it to 15 seconds abort}
       SetPollTimer(FIPPrec);
     end;
    SendArray[0] := DoIOSelectCmd;
    SendArray[1] := 1;
    SendArray[2] := word(IOstate);
    if DoPacket(FIPPrec) then
      DoIOSelect := true;
    PollTimer := OldTimer;
    SetPollTimer(FIPPrec);      {restore original poll timeout value}
  end;
end;

{-------}
{note: since the sweep can take an excessive time this command forces the}
{timeout value to two minutes unless it is equal to or greater than that}

function DoTest(var FIPPrec:FIPPrecType):boolean;     {16}
var OldTimer:integer;
begin
   with FIPPrec do
   begin
     PacketError := GoodPacket;
     GetPollTimer(FIPPrec);      {get real poll timeout value}
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 1800 then    {If less than two minutes}
     begin
       PollTimer := 1800;        {force it to two minute abort}
       SetPollTimer(FIPPrec);
     end;
     DoTest := SendDoCmd(DoTestCmd,FIPPrec);  {do the sweep}
     PollTimer := OldTimer;
     SetPollTimer(FIPPrec);      {restore original poll timeout value}
   end;
end;

{-------}
function DoLevel(var FIPPrec:FIPPrecType):boolean;        {17}
var OldTimer:integer;
begin
   GetPollTimer(FIPPrec);      {get real poll timeout value}
   with FippRec do
   begin
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 1800 then    {If less than two minutes}
     begin
       PollTimer := 1800;        {force it to two minute abort}
       SetPollTimer(FIPPrec);
     end;
     DoLevel := SendDoCmd(DoLevelCmd,FIPPrec);
     PollTimer := OldTimer;
     SetPollTimer(FIPPrec);
   end;
end;

{-------}
function DoReset(var FIPPrec:FIPPrecType):boolean;        {38}
var OldTimer,OldResp:integer;
begin
   with FippRec do
   begin
     GetPollTimer(FIPPrec);      {get real poll timeout value}
     GetRespTimer(FIPPrec);      {get real resp timeout value}
     OldResp := RespTimer;
     OldTimer := PollTimer;      {update current timer value}
     if PollTimer < 1800 then    {If less than two minutes}
     begin
       PollTimer := 1800;        {force it to two minute abort}
       SetPollTimer(FIPPrec);
     end;
(*     if RespTimer < (100) then    {If less than 5 seconds}
     begin
       RespTimer := (100);        {force it to 5 seconds abort}
       SetRespTimer(FIPPrec);
     end; *)

     DoReset := SendDoCmd(DoResetCmd,FIPPrec);
     PollTimer := OldTimer;
     SetPollTimer(FIPPrec);
     RespTimer := OldResp;
(*     SetRespTimer(FIPPrec);      {restore original resp timeout value} *)
   end;
end;

{-------}
{Note: if sleep status = 2 does not verify cmd because it can't }
function DoSleep(var FIPPrec:FIPPrecType):boolean;        {56}
begin
  with FIPPrec do
  begin
    DoSleep := false;
    PacketError := GoodPacket;
    DoSleep := SendDoCmd(DoSleepCmd,FIPPrec);
  end;
end;

function DoPower(var FIPPrec:FIPPrecType):boolean;           {56}  {fp40}
begin
  with FIPPrec do
  begin
    DoPower := false;
    PacketError := GoodPacket;
    SendArray[0] := DoPowerCmd;
    SendArray[1] := 1;
    SendArray[2] := word(PowerStatus);
    if PowerStatus > 1 then
    begin
      if SendCommand(FIPPrec) then
        if not(RcvAcknowledge(FIPPrec)) then Exit;
    end
    else
    begin
      if not(DoPacket(FIPPrec)) then Exit;
    end;
    DoPower := true;
  end;
end;

{-- new v2.6x -----}
function DoLineFeeds(var FIPPrec:FIPPrecType):boolean;       {64}
var OldTimer,OldResp:integer;
begin
  with FIPPrec do
  begin
    DoLineFeeds := false;
    PacketError := GoodPacket;
    GetPollTimer(FIPPrec);      {get real poll timeout value}
    OldTimer := PollTimer;      {update current timer value}
    GetRespTimer(FIPPrec);      {get real resp timeout value}
    OldResp := RespTimer;
    if PollTimer < 1800 then    {If less than 30 seconds}
    begin
      PollTimer := 1800;        {force it to 30 seconds abort}
      SetPollTimer(FIPPrec);
    end;
    if RespTimer < (100) then    {If less than 5 seconds}
    begin
      RespTimer := (100);        {force it to 5 seconds abort}
      SetRespTimer(FIPPrec);
    end;

    SendArray[0] := DoLineFeedsCmd;
    SendArray[1] := 1;
    SendArray[2] := word(PrintFeeds);
    if DoPacket(FIPPrec) then
      DoLineFeeds := true;

    PollTimer := OldTimer;
    SetPollTimer(FIPPrec);      {restore original poll timeout value}
    RespTimer := OldResp;
    SetRespTimer(FIPPrec);      {restore original resp timeout value}
  end;
end;


{-- new v2.6x -----}
function DoPrint(var FIPPrec:FIPPrecType):boolean;           {65}
var OldTimer,OldResp:integer;
begin
  with FIPPrec do
  begin
    DoPrint := false;
    PacketError := GoodPacket;
    GetPollTimer(FIPPrec);      {get real poll timeout value}
    OldTimer := PollTimer;      {update current timer value}
    GetRespTimer(FIPPrec);      {get real resp timeout value}
    OldResp := RespTimer;
    if PollTimer < 1800 then    {If less than 60 seconds}
    begin
      PollTimer := 1800;        {force it to 60 seconds abort}
      SetPollTimer(FIPPrec);
    end;
    if RespTimer < (100) then    {If less than 5 seconds}
    begin
      RespTimer := (100);        {force it to 5 seconds abort}
      SetRespTimer(FIPPrec);
    end;

    SendArray[0] := DoPrintCmd;
    SendArray[1] := 1;
    SendArray[2] := word(PrintType);
    if DoPacket(FIPPrec) then
      DoPrint := true;
    PollTimer := OldTimer;
    SetPollTimer(FIPPrec);      {restore original poll timeout value}
    RespTimer := OldResp;
    SetRespTimer(FIPPrec);      {restore original resp timeout value}
  end;
end;



{-------}
function DoError(var FIPPrec:FIPPrecType):boolean;        {67}
begin
   DoError :=
     SendDoCmd(DoErrorCmd,FIPPrec);
end;



{---6500 V4.14--}
function DoMeasurement(var FIPPrec:FIPPrecType):boolean;  {85}
var OldTimer,OldResp:integer;
    STime : longint;
    Valid : boolean;
begin
  with FIPPrec do
  begin
     DoMeasurement := false;
     Valid := false;
     PacketError := GoodPacket;
     stime := DoMeasureSettleTime div 55;
     GetPollTimer(FIPPrec);      {get real poll timeout value}
     OldTimer := PollTimer;      {update current timer value}
     GetRespTimer(FIPPrec);      {get real resp timeout value}
     OldResp := RespTimer;
     if PollTimer < (100+stime) then    {If less than 5+settle seconds}
     begin
       PollTimer := (100+stime);        {force it to 5+settle seconds abort}
       SetPollTimer(FIPPrec);
     end;
     if RespTimer < (100+stime) then    {If less than 5+settle seconds}
     begin
       RespTimer := (100+stime);        {force it to 5+settle seconds abort}
       SetRespTimer(FIPPrec);
     end;
    SendArray[0] := DoMeasurementCmd;
    SendArray[1] := 3;
    SendArray[2] := word(Frequency);
    SendArray[3] := word(SourceAmp);
    SendArray[4] := word(DoMeasureSettleTime);

    if GetPacket(FIPPrec) then  {we need a response from this one}
    begin
      MeasureMicData := integer(RcvArray[2]);
      Valid := true;
    end;
    PollTimer := OldTimer;
    SetPollTimer(FIPPrec);      {restore original poll timeout value}
    RespTimer := OldResp;
    SetRespTimer(FIPPrec);      {restore original resp timeout value}

    if FIPPrec.Verify and Valid then
      if not(CommandStatusOK(FIPPrec)) then Exit;

    DoMeasurement := Valid;
  end;
end;





{ ********** }
{initialization section}

begin
  new(RawSampleData);
  new(DeviceDataArray);
  new(AuxInData);
  new(AuxOutData);
end.


