
{This unit creates a variable that works similar to the GetTickCount}
{function in Windows. The value in TickCount is incremented by 55}
{on each clock tick resulting in a variable that contains the }
{number of milliseconds elapsed since the program was started. }
{Public Domain}
{ modified : 12 Aug 1993  by Michael Day }

{$A+,D-,F+,G-,I-,L-,O-,P-,Q-,R-,S-,T-,V-,X-,Y-}
Unit Ticker;
interface


var TickCount : longint;

function GetTickCount:longint;

implementation
uses dos;

function GetTickCount:longint;
begin
  GetTickCount := TickCount;
end;

var Old1Cvec:pointer;
var ExitSave : pointer;

procedure TickerHook; far; assembler;
asm
  push ds
  push ax
  mov ax,SEG @Data
  mov ds,ax
  add word ptr [TickCount],55
  jnc @done
  inc word ptr [TickCount+2]
 @done:
  pushf
  call dword ptr [Old1Cvec]
  pop ax
  pop ds
  iret
end;

procedure TickerExit; far;
begin
  SetIntVec($1C,Old1Cvec);
  ExitProc := ExitSave;
end;

{----------}
begin
  GetIntVec($1C,Old1Cvec);
  ExitSave := ExitProc;
  ExitProc := @TickerExit;
  SetIntVec($1C,@TickerHook);
end.

(*
{alternate call format eliminating stack usage}
 @done:
  lds ax,[Old1Cvec]
  mov word ptr @Local,ax
  mov word ptr @Local+2,ds
  pop ax
  pop ds
  jmp Dword ptr cs:[@Local]
 @Local: DD 0
*)

