//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Fryers.h"
#include "BcForm.h"
#include "BcUnit.h"

//externally accessed code
void StartGraph(void) {
  Form1->tw = 8; //{Form1.PaintBox.canvas.textwidth('X'); }
  Form1->th = 8; //{Form1.PaintBox.canvas.textheight('X');}
  Form1->MemImage->Canvas->Font = Form1->PaintBox->Font;
  Form1->MemImage->Canvas->Pen->Color = BackColor;
  Form1->MemImage->Canvas->Brush->Color = BackColor;
  Form1->MemImage->Canvas->Rectangle(0,0,Form1->MemImage->Width,Form1->MemImage->Height);
};

void Plot(int x, int y, TColor c) {
  Form1->WritePixel(x,y,c);
};

void SetPixelColor(TColor FColor, TColor BColor) {
  Form1->MemImage->Canvas->Pen->Color = FColor;
};

//{-----------------------------------------------------------}
void xyWrite(int x, int y, char* s1, char* s2, TColor Color) {
  int x1,y1,x2,y2;
  char Str[40] = "";
  if (s1 != NULL) strcat(Str,s1);
  if (s2 != NULL) strcat(Str,s2);
  x1 = (x-1)*Form1->tw;
  y1 = (y-1)*Form1->th;
  x2 = x1+(strlen(Str)*Form1->tw);
  y2 = y1+Form1->th;
  Form1->MemImage->Canvas->Pen->Color = BackColor;
  Form1->MemImage->Canvas->Brush->Color = BackColor;
  Form1->MemImage->Canvas->Rectangle(x1,y1,x2,y2);
  Form1->MemImage->Canvas->Font->Color = Color;
  Form1->MemImage->Canvas->TextOut(x1,y1,Str);
};


//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}

void __fastcall TForm1::RefreshBitmap()
{
  Form1->PaintBox->Canvas->CopyMode = cmSrcCopy;
  Form1->PaintBox->Canvas->StretchDraw(Form1->PaintBox->Canvas->ClipRect,Form1->MemImage);
}

void __fastcall TForm1::WritePixel(int x, int y, TColor c)
{
  Form1->MemImage->Canvas->Pixels[x][y] = c;
}

//---------------------------------------------------------------------------;

//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  SerialPort = (WORD)ComRadioGroup->ItemIndex+1;
  LoadFryers();
  Form1->MemImage = new Graphics::TBitmap;
  Form1->MemImage->Width = Form1->PaintBox->Width;
  Form1->MemImage->Height = Form1->PaintBox->Height;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
  if ((Key == 0x1B) || (Key == 0x03))
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormPaint(TObject *Sender)
{
  RefreshBitmap();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormResize(TObject *Sender)
{
  RefreshBitmap();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
  RefreshBitmap();
}

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  IamRunning = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComRadioGroupClick(TObject *Sender)
{
  IamRunning = false;
  while (IamBusy == true) {
    Application->ProcessMessages();
  }
  SerialPort = (WORD)ComRadioGroup->ItemIndex+1;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::StartStopButtonClick(TObject *Sender)
{
  if (IamRunning == true) {
    IamRunning = false;
    return;
  }else{
    IamRunning = true;
    StartStopButton->Caption = "Stop";
  }
  Application->ProcessMessages();
  Form1->BaudrateLabel->Caption = "Initializing";
  if (StartMeUp() == false) {
    IamRunning = false;
    BaudrateLabel->Caption = "Port Init Failed";
    StartStopButton->Caption = "Start";
  }else{
    GetBaudrate();
    Form1->BaudrateLabel->Caption = BaudrateString;
  }
  Form1->Label1->Caption = FryersVersionString;
  Application->ProcessMessages();

  while (IamRunning == true) {
    if (DoMe() == false) {
      IamRunning = false;
    }else{
      GetBaudrate();
      Form1->BaudrateLabel->Caption = BaudrateString;
      Form1->RefreshBitmap();
    }
    Application->ProcessMessages();
  }

  CloseRS232();
  StartStopButton->Caption = "Start";
  BaudrateLabel->Caption = "Press Start to begin";
}
//-----------------------------------------------------------
//<eof>

void __fastcall TForm1::PawsButtonClick(TObject *Sender)
{
   if (Paws == true) {
     PawsButton->Caption = "Pause";
     Paws = false;
   }else{
     PawsButton->Caption = "Run";
     Paws = true;
   }
}
//---------------------------------------------------------------------------
