#define fryersH
#ifdef fryersH
#pragma -a1

typedef void (*PROCEDURE)();  //procedure declaration (used by callback)
typedef short int INT16;      //Fryers data is a 16 bit integer
#define F_MAX_DATA_SIZE 2100    //max size of Fryers data buffers
#define AUTO_BAUD 0           //0=use let Fryers find the baudrate
#define F_MAX_PORT 15

//register structure to use with Fryers
//Note: these are 32 bit values,
//*NOT* 16bit as with the 16 bit version of Fryers
//* WARNING* You *MUST* compile this with BYTE alignment.
//  failure to use byte alignment will cause all sorts of problems.
struct F_RegsType { union { struct { int EAX;
			             int EBX;
			             int ECX;
			             int EDX;
			             int EDI;
			             int ESI; };
		            struct { unsigned char AL;
			             unsigned char AH;
			             unsigned char EAL;
			             unsigned char EAH;
			             unsigned char BL;
			             unsigned char BH;
			             unsigned char EBL;
			             unsigned char EBH;
			             unsigned char CL;
			             unsigned char CH;
			             unsigned char ECL;
			             unsigned char ECH;
			             unsigned char DL;
			             unsigned char DH;
			             unsigned char EDL;
			             unsigned char EDH;
			             int RDI;
			             int RSI; };
		            struct { int AX;
			             int BX;
			             int CX;
			             int DX;
			             int DI;
			             int SI; };
		          };
                  };

//Example send/rcv array declarations
//INT16 SendData[MAX_SEND_SIZE+1];
//INT16 RcvData[MAX_RCV_SIZE+1];

typedef void __stdcall (*tCallFryers)(F_RegsType* Freg);
extern bool __stdcall LoadFryers(void);
extern bool __stdcall FryersLoaded(void);
extern HINSTANCE FryersLibHandle;
extern tCallFryers CallFryers;

#define SUCCESS 0
#define RECEIVE_ERROR 1
#define RECEIVE_OVERRUN 2
#define SEND_OVERFLOW 3
#define SEND_OVERRUN 4
#define ILLEGAL_PACKET 5
#define BAD_PACKET 6
#define RESPONSE_ERROR 7
#define NOGO_COMMAND 8
#define NO_FRYERS 9
#define NO_POLL 10
#define BAD_FRYERS 11
#define USER_ABORT 255


class TFryers {
  private:
    //void Constructor(void);
    //void Destructor(void);
    bool __stdcall SendWait(PROCEDURE Callback);
    bool __stdcall RspWait(PROCEDURE Callback);
  public:

    bool __stdcall FryersReady(void);
    bool __stdcall OpenPacketPort(int IOPort, int Baud, bool Auto, bool Fast);
    void __stdcall ClosePacketPort(void);
    bool __stdcall ClearReceiveFlag(void);
    int  __stdcall PacketStatus(void);
    bool __stdcall SendReady(void);
    bool __stdcall SendCmd(INT16* pData, PROCEDURE Callback);
    bool __stdcall GetResponse(INT16* pData, PROCEDURE Callback);
    bool __stdcall QuickTerminate(PROCEDURE Callback);

    int  __stdcall GetCurrentBaudrate(void);
    int  __stdcall AutoBaudCheck(int NewBaud);
    int  __stdcall GetPollTimeout(void);
    bool __stdcall SetPollTimeout(int Value);
    int  __stdcall GetPacketTimer(void);
    bool __stdcall ClearPacketTimer(void);
    bool __stdcall AutoQT(bool Enable);
    bool __stdcall CheckQT(void);
    bool __stdcall PollOK(void);
    bool __stdcall SetRspTimer(int Value);
    int  __stdcall GetRspTimer(void);

    F_RegsType Regs;
    bool PortOpen;
    bool AutoBaud;
    bool BaudSeek;
    bool FastTransfer;
    int FVersion;
    int ComPort;
    int Baudrate;
    int PacketError;
  };

//Example send/rcv array declarations
//INT16 SendData[MAX_SEND_SIZE+1];
//INT16 RcvData[MAX_RCV_SIZE+1];

#endif
