unit AptUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, AdPort, MMSystem;

type
  TForm1 = class(TForm)
    PortSelect: TRadioGroup;
    GoButton: TButton;
    CmdTimeLabel: TLabel;
    Label1: TLabel;
    ApdComPort: TApdComPort;
    QuitButton: TButton;
    SpinLabel: TLabel;
    SeqLabel: TLabel;
    NoSpinCheckBox: TCheckBox;
    PollErrorEdit: TEdit;
    Label2: TLabel;
    QuietCheckBox: TCheckBox;
    RcvDataEdit: TEdit;
    CountLabel: TLabel;
    AutoZeroCheckBox: TCheckBox;
    TimeCheckBox: TCheckBox;
    procedure GoButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ApdComPortTriggerAvail(CP: TObject; Count: Word);
    procedure QuitButtonClick(Sender: TObject);
    procedure Spinner(var SpinLabel:TLabel; Var spin:integer);
    procedure NoSpinCheckBoxClick(Sender: TObject);
    procedure PollErrorEditDblClick(Sender: TObject);
    procedure AutoZeroCheckBoxClick(Sender: TObject);
    procedure TimeCheckBoxClick(Sender: TObject);
  private
    { Private declarations }
    procedure InitPort;
  public { Public declarations }
    Total : integer;
    SpinVar : integer;
  end;

var
  Form1: TForm1;

var PortInitialized : boolean = false;
var Running : boolean = false;
var Start,Stop : integer;
var Rcv : array[0..127] of integer;
var RcvIndex : integer;
var ZeroRcv : boolean = true;
var DoTime : boolean = true;

const QTermCmd : array[0..2] of word = ($7FFF,$0000,$8000);
var PollSeq : integer = 0;
var NoSpin : boolean = false;
var PollError : integer = 0;
var DataCount : integer = 0;

implementation

{$R *.DFM}

type str8 = string[8];
const hex : array[0..15] of char = (
  '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
function HexB(B:integer):str8;
var s : string[8];
begin
  s[0] := char(2);
  s[1] := hex[(B shr 4) and $f];
  s[2] := hex[B and $f];
  hexb := s;
end;

procedure TForm1.Spinner(var SpinLabel:TLabel; Var spin:integer);
begin
  Spin := succ(Spin) and $3;
  case Spin of
   0: SpinLabel.caption := '|';
   1: SpinLabel.caption := '/';
   2: SpinLabel.caption := '--';
   3: SpinLabel.caption := '\';
  end;
end;

procedure TForm1.InitPort;
begin
  ApdComPort.Open := false;
  ApdComPort.ComNumber := succ(PortSelect.itemIndex); {use Com1}
  PortInitialized := true;
  ApdComPort.Open := true;
 // ApdComPort.Output := 'ATZ'^M;
end;

procedure TForm1.ApdComPortTriggerAvail(CP: TObject; Count: Word);
var Data : char;
begin
  DataCount := Count;
  if not(NoSpin) then
    Spinner(SpinLabel,SpinVar);
  while Count > 0 do
  begin
    Dec(Count);
    Data := ApdComPort.GetChar;
    Rcv[RcvIndex] := ord(Data);
    inc(RcvIndex);
    case PollSeq of
      0: begin
           if DoTime then
           begin
             Stop := timeGetTime;
             Total := Stop-Start;
             Start := timeGetTime;
           end;  
           if Data = #$FF then inc(PollSeq) else PollSeq := 0;
         end;
      1: if Data = #$FF then inc(PollSeq) else PollSeq := 0;
      2: if Data = #$00 then inc(PollSeq) else PollSeq := 0;
      3: if Data = #$00 then inc(PollSeq) else PollSeq := 0;
      4: if Data = #$00 then inc(PollSeq) else PollSeq := 0;
      5: if Data = #$00 then inc(PollSeq) else PollSeq := 0;
    end;
    if PollSeq = 0 then
      inc(PollError);
    if PollSeq > 5 then
    begin
      PollSeq := 0;
//    ApdComPort.FlushInBuffer;
      ApdComPort.PutBlock(QTermCmd,sizeof(QtermCmd));
  //    RcvIndex := 0;
      Rcv[RcvIndex] := 1;
      if ZeroRcv then
        RcvIndex := 0
      else  
        inc(RcvIndex);
    end;
{  end
  else
  begin
    Rcv[RcvIndex] := -1;
    inc(RcvIndex);}
  end;            
  if RcvIndex > 15 then RcvIndex := 0;
end;


procedure TForm1.GoButtonClick(Sender: TObject);
var s : string[80];
var i : integer;
begin
   if Running then
   begin
     Running := false;
     Exit;
   end;
   GoButton.Caption := 'Stop';
   if not(PortInitialized) then
     InitPort;
   running := true;
   while running do
   begin
     if not(QuietCheckBox.checked) then
     begin
       CmdTimelabel.caption := inttostr(Total);
       Seqlabel.caption := inttostr(PollSeq);
       PollErrorEdit.text := inttostr(PollError);
       CountLabel.caption := inttostr(DataCount);
       s := '                                                   ';
       for i := 0 to 15 do
       begin
         if Rcv[i] < 0 then
         begin
           S[(I*3)+1] := '-';
           S[(I*3)+2] := '1';
           S[(I*3)+3] := ' ';
         end
         else
         begin
           S[(i*3)+1] := hex[Rcv[i] shr 4];
           S[(i*3)+2] := hex[Rcv[i] and $f];
           s[(I*3)+3] := ' ';
         end;
       end;
       RcvDataEdit.text := s;
     end;
     application.processmessages;
   end;
   GoButton.Caption := 'Go';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
//  ApdComPort := TApdComPort.Create(Self);
//  ApdComPort.ComNumber := 1; {use Com1}
//  ApdComPort.Baud := 9600;
//  ApdComPort.Parity := pNone;
//  ApdComPort.DataBits := 8;
//  ApdComPort.StopBits := 1;
  ApdComPort.DispatcherMode := dCommEvents;
  ApdComPort.CommNotificationLevel := 1;
  ApdComPort.TriggerLength := 1;
  ApdComPort.Open := True;
end;

procedure TForm1.QuitButtonClick(Sender: TObject);
begin
   Running := false;
   ApdComPort.Open := false;
  // ApdComPort.free;
   Close;
end;

procedure TForm1.NoSpinCheckBoxClick(Sender: TObject);
begin
  NoSpin := NoSpinCheckBox.checked;
end;

procedure TForm1.PollErrorEditDblClick(Sender: TObject);
begin
  PollError := 0;
end;

procedure TForm1.AutoZeroCheckBoxClick(Sender: TObject);
begin
   ZeroRcv := AutoZeroCheckBox.checked;
end;

procedure TForm1.TimeCheckBoxClick(Sender: TObject);
begin
  DoTime := TimeCheckbox.checked;
end;

end.
