{------------------------------------------------}
procedure GetLabelFile(what:str255);
var i : integer;
begin
  with FIPPrec do
  begin
    if FSearch(What,'') = '' then
    begin
      writeln('File not found: ',What);
      ErrorCode := FileError;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    assign(f,What);
    reset(f);

    fillchar(Lab,sizeof(Lab),0);
    fillchar(CustomLab,sizeof(CustomLab),0);
    if SendArray[0] = 6 then             {if cmd 6 do old style label}
    begin
      while not(eof(f)) do
      begin
        for i := 1 to 5 do
        begin
          fillchar(Stmp[1],18,'_');
          readln(f,Stmp);
          Stmp[0] := #18;
          Lab := Lab+Stmp;
        end;
        for i := 6 to 8 do
        begin
          fillchar(Stmp[1],27,'_');
          readln(f,Stmp);
          Stmp[0] := #27;
          Lab := Lab+Stmp;
        end;
        Lab := Lab+#0;
      end;
    end
    else if SendArray[0] = 66 then
    begin
      while not(eof(f)) do
      begin
        for i := 1 to 8 do             {otherwise do new style label}
        begin
          fillchar(Stmp[1],27,'_');
          readln(f,Stmp);
          Stmp := Stmp+#0;
          Stmp[0] := #28;
          Lab := Lab+Stmp;
        end;
        if not(eof(f)) then
        begin
          fillchar(Stmp[1],27,' ');    {try for first custom line}
          readln(f,Stmp);
          Stmp := Stmp+#0;
          Stmp[0] := #28;
          CustomLab := Stmp;
        end;
        if not(eof(f)) then
        begin
          fillchar(Stmp[1],27,' ');    {try for second custom line}
          readln(f,Stmp);
          Stmp := Stmp+#0;
          Stmp[0] := #28;
          CustomLab := CustomLab+Stmp;
        end;
      end;
    end
    else
    begin
      writeln('Error: Command format error');
      ErrorCode := NogoCommand;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    Close(f);
    ConvertLabel(length(Lab),length(CustomLab));
  end;
end;


{------------------------------------------------}
{2/27/03 -med fixed bug that caused bad format bmp }
{file (imageSize=0) to cause an exception}
procedure GetLabelBitmapFile(what:str255);
var Err:integer;
begin
  BmpPalette.Item[0] := 0;  {Init default palette entries}
  BmpPalette.Item[1] := $00ffffff;

  with FIPPrec do
  begin
    if FSearch(What,'') = '' then
    begin
      writeln('File not found: ',What);
      ErrorCode := FileError;                    {rats, didn't find it}
      Halt(ErrorCode);
    end;
    assign(fb,What);
    reset(fb,1);
    BlockRead(fb,BmpHeader,sizeof(BmpHeader),Err);
    if Err <> sizeof(BmpHeader) then
    begin
      writeln('Error: Bitmap format error (header)');
      ErrorCode := NogoCommand;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;
    if BmpHeader.HeaderSize >= (sizeof(BmpHeader) + 8) then
    begin
      BlockRead(fb,BmpPalette,sizeof(BmpPalette),Err);
      if Err <> sizeof(BmpPalette) then
      begin
        writeln('Error: Bitmap format error (palette)');
        ErrorCode := NogoCommand;                    {rats, bad bitmap file }
        Halt(ErrorCode);
      end;
    end;
    Seek(fb,BmpHeader.HeaderSize);
    BitMapSize := BmpHeader.biSizeImage;
    if BitMapSize = 0 then BitMapSize := BmpHeader.Width * BmpHeader.Height div 8;
    if (BitMapSize > (MaxLabelBitmap*2)) then
    begin
      writeln('Error: Bitmap format error (BMP file too big)');
      ErrorCode := NogoCommand;                    {rats, bad size }
      Halt(ErrorCode);
    end;
    if (BmpHeader.Bits <> 1) or (FileSize(fb) <> BmpHeader.FileSize) then
    begin
      writeln('Error: Bitmap format error (it needs to be a monochrome BMP file)');
      ErrorCode := NogoCommand;                    {rats, bad size }
      Halt(ErrorCode);
    end;
    fillchar(LabelBitmap,sizeof(LabelBitmap),0);
    BlockRead(fb,LabelBitmap,BitMapSize,Err);
    if Err <> BitMapSize then
    begin
      writeln('Error: Bitmap format error');
      ErrorCode := NogoCommand;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;
    Close(fb);
  end;
end;

procedure BuildBitmapSendArray;
var Data : word;
var h,w,i,x,y:integer;
var PixelsPerWord:integer;
begin
  with FIPPrec do
  begin
    SendArray[1] := (BitmapSize div 2)+10; {total data size}
    SendArray[2] := BitMapType;  {monochrome} {only monochrom currently supported}
    SendArray[3] := BitMapXpos;  {xpos}
    SendArray[4] := BitMapYpos;  {ypos}
    SendArray[5] := BmpHeader.Width;
    SendArray[6] := BmpHeader.Height;
    SendArray[7] := BitMapDest; {Only the printer can be set with this command right now}
    SendArray[8] := BitMapSize;  {image size in bytes}
    SendArray[9] := 10;

    i := 0;
    if BitMapType = 2 then
      PixelsPerWord := 16 {if monochrome, 16pixels per word}
    else PixelsPerWord := 4; {if color, 4 pixels per word}
    h := BmpHeader.Height;           {convert from bmp format to fp35 bitmap format}
    w := BmpHeader.Width div PixelsPerWord;
    if (h > 0) and (w > 0) then
    begin
      if (BmpHeader.Width mod PixelsPerWord) <> 0 then inc(w);
      for y := 0 to h-1 do
      begin
        for x := 0 to w-1 do
        begin
          Data := LabelBitMap[((h-1-y)*w)+x];
          Data := ((BitReverse[lo(Data)]) + (BitReverse[hi(Data)] shl 8));
          {Need to read the palette to determine black and white pixel settings}
          if (BmpPalette.Item[0] = 0) then
            SendArray[10+i] := not(Data) {pal[0]=black}
          else SendArray[10+i] := Data;  {pal[0]=white}
          inc(i);
        end;
      end;
    end;
  end;
end;
