program Bmp2Hex; {convert big bmp to hex file}
uses dos;
var k,ErrorCode : integer;
var fb : file;
var ft : text;
var st:string;

type BmpHeaderType = record
       id              : word;
       Filesize        : longint;
       reserved        : longint;
       HeaderSize      : longint;
       InfoSize        : longint;
       Width           : longint;
       Height          : longint;
       biPlanes        : word;
       Bits            : word;
       biCompression   : longint;
       biSizeImage     : longint;
       biXPelsPermeter : longint;
       biYPelsPermeter : longint;
       biClrUsed       : longint;
       biClrImportant  : longint;
     end;
var BmpHeader : BmpHeaderType;
const MaxLabelBitmap = 50240; {max size allowed for labelbitmap (in bytes)}

type BmpPaletteType = packed record
       Item : array[0..1] of longint;
     end;
var BmpPalette : BmpPaletteType;

type LabelBitMapType = array[0..MaxLabelBitMap] of byte;
type LabelImageType = array[0..127,0..255] of byte;
var pLabelBitMap : ^LabelBitMapType;
var pLabelImage : ^LabelImageType;


{;BIT REVERSAL TABLE. BITS IN ELEMENTS ARE IN  }
{;REVERSED ORDER OF BITS IN LOWER BYTE ADDRESS.}
{;*********************************************}

const BitReverse : array[0..255] of byte = (
   $00,$80,$40,$C0,  {//;00H - 03H}
   $20,$A0,$60,$E0,  {//;04H - 07H}
   $10,$90,$50,$D0,  {//;08H - 0BH}
   $30,$B0,$70,$F0,  {//;0CH - 0FH}
   $08,$88,$48,$C8,  {//;10H - 13H}
   $28,$A8,$68,$E8,  {//;14H - 17H}
   $18,$98,$58,$D8,  {//;18H - 1BH}
   $38,$B8,$78,$F8,  {//;1CH - 1FH}
   $04,$84,$44,$C4,  {//;20H - 23H}
   $24,$A4,$64,$E4,  {//;24H - 27H}
   $14,$94,$54,$D4,  {//;28H - 2BH}
   $34,$B4,$74,$F4,  {//;2CH - 2FH}
   $0C,$8C,$4C,$CC,  {//;30H - 33H}
   $2C,$AC,$6C,$EC,  {//;34H - 37H}
   $1C,$9C,$5C,$DC,  {//;38H - 3BH}
   $3C,$BC,$7C,$FC,  {//;3CH - 3FH}
   $02,$82,$42,$C2,  {//;40H - 43H}
   $22,$A2,$62,$E2,  {//;44H - 47H}
   $12,$92,$52,$D2,  {//;48H - 4BH}
   $32,$B2,$72,$F2,  {//;4CH - 4FH}
   $0A,$8A,$4A,$CA,  {//;50H - 53H}
   $2A,$AA,$6A,$EA,  {//;54H - 57H}
   $1A,$9A,$5A,$DA,  {//;58H - 5BH}
   $3A,$BA,$7A,$FA,  {//;5CH - 5FH}
   $06,$86,$46,$C6,  {//;60H - 63H}
   $26,$A6,$66,$E6,  {//;64H - 67H}
   $16,$96,$56,$D6,  {//;68H - 6BH}
   $36,$B6,$76,$F6,  {//;6CH - 6FH}
   $0E,$8E,$4E,$CE,  {//;70H - 73H}
   $2E,$AE,$6E,$EE,  {//;74H - 77H}
   $1E,$9E,$5E,$DE,  {//;78H - 7BH}
   $3E,$BE,$7E,$FE,  {//;7CH - 7FH}
   $01,$81,$41,$C1,  {//;80H - 83H}
   $21,$A1,$61,$E1,  {//;84H - 87H}
   $11,$91,$51,$D1,  {//;88H - 8BH}
   $31,$B1,$71,$F1,  {//;8CH - 8FH}
   $09,$89,$49,$C9,  {//;90H - 93H}
   $29,$A9,$69,$E9,  {//;94H - 97H}
   $19,$99,$59,$D9,  {//;98H - 9BH}
   $39,$B9,$79,$F9,  {//;9CH - 9FH}
   $05,$85,$45,$C5,  {//;A0H - A3H}
   $25,$A5,$65,$E5,  {//;A4H - A7H}
   $15,$95,$55,$D5,  {//;A8H - ABH}
   $35,$B5,$75,$F5,  {//;ACH - AFH}
   $0D,$8D,$4D,$CD,  {//;B0H - B3H}
   $2D,$AD,$6D,$ED,  {//;B4H - B7H}
   $1D,$9D,$5D,$DD,  {//;B8H - BBH}
   $3D,$BD,$7D,$FD,  {//;BCH - BFH}
   $03,$83,$43,$C3,  {//;COH - C3H}
   $23,$A3,$63,$E3,  {//;C4H - C7H}
   $13,$93,$53,$D3,  {//;C8H - CBH}
   $33,$B3,$73,$F3,  {//;CCH - CFH}
   $0B,$8B,$4B,$CB,  {//;D0H - D3H}
   $2B,$AB,$6B,$EB,  {//;D4H - D7H}
   $1B,$9B,$5B,$DB,  {//;D8H - DBH}
   $3B,$BB,$7B,$FB,  {//;DCH - DFH}
   $07,$87,$47,$C7,  {//;E0H - E3H}
   $27,$A7,$67,$E7,  {//;E4H - E7H}
   $17,$97,$57,$D7,  {//;E8H - EBH}
   $37,$B7,$77,$F7,  {//;ECH - EFH}
   $0F,$8F,$4F,$CF,  {//;F0H - F3H}
   $2F,$AF,$6F,$EF,  {//;F4H - F7H}
   $1F,$9F,$5F,$DF,  {//;F8H - FBH}
   $3F,$BF,$7F,$FF); {//;FCH - FFH}


const hex : array[0..15] of char = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
function hexb(Value:byte):string;
var S : string;
begin
  S[0] := #2;
  S[1] := hex[Value shr 4];
  S[2] := hex[Value and $f];
  hexb := S;
end;

procedure ConvertBmpFile(What:string; Where:string);
var BitMapSize : longint;
var e,j,h,w,i,x,y:integer;
var Err:integer;
begin
  BmpPalette.Item[0] := 0;  {Init default palette entries}
  BmpPalette.Item[1] := $00ffffff;

  if ParamCount < 2 then
  begin
    writeln('Error: No parameters given');
    writeln('Format is: BMP2HEX SOURCE.BMP TARGET.HEX');
    ErrorCode := 1;                    {rats, didn't find it}
    Halt(ErrorCode);
  end;
  if FSearch(What,'') = '' then
  begin
    writeln('File not found: ',What);
    ErrorCode := 1;                    {rats, didn't find it}
    Halt(ErrorCode);
  end;

  assign(fb,What);
  reset(fb,1);
  BlockRead(fb,BmpHeader,sizeof(BmpHeader),Err);
  if Err <> sizeof(BmpHeader) then
  begin
    writeln('Error: Bitmap format error');
    ErrorCode := 2;                    {rats, bad bitmap file }
    Halt(ErrorCode);
  end;
  if (BmpHeader.HeaderSize >= (sizeof(BmpHeader) + 8)) then
  begin
    BlockRead(fb,BmpPalette,sizeof(BmpPalette),Err);
    if Err <> sizeof(BmpPalette) then
    begin
      writeln('Error: Bitmap format error (palette)');
      ErrorCode := 2;                    {rats, bad bitmap file }
      Halt(ErrorCode);
    end;
  end;

  Seek(fb,BmpHeader.HeaderSize);
  BitMapSize := BmpHeader.biSizeImage;

  if BitMapSize = 0 then BitMapSize := BmpHeader.Width * BmpHeader.Height div 8;
  if (BitMapSize > (MaxLabelBitmap*2)) then
  begin
    writeln('Error: Bitmap format error (BMP file too big)');
    ErrorCode := 2;                    {rats, bad size }
    Halt(ErrorCode);
  end;
  if (BmpHeader.Bits <> 1) or (FileSize(fb) <> BmpHeader.FileSize) then
  begin
    writeln('Error: Bitmap format error (it needs to be a monochrome BMP file)');
    ErrorCode := 2;                    {rats, bad size }
    Halt(ErrorCode);
  end;

  fillchar(pLabelBitmap^,sizeof(pLabelBitmap^),0);
  h := BmpHeader.height;           {convert from bmp format to fp35 bitmap format}
  w := BmpHeader.Width div 32;
  if (BmpHeader.Width mod 32) <> 0 then inc(w);
  w := w*4;
  fillchar(pLabelBitmap^,sizeof(pLabelBitmap^),0);
  BlockRead(fb,pLabelBitmap^,BitMapSize,Err);
  if (Err <> BitMapSize) or (h=0) or (w=0) then
  begin
    writeln('Error: Bitmap format error');
    ErrorCode := 4;                    {rats, bad bitmap file }
      Halt(ErrorCode);
  end;

  k := 0;
  for y := 0 to h-1 do  {h=height in lines}
  begin
    for x := 0 to w-1 do {w=width in bytes}
    begin
      pLabelImage^[y,x] := BitReverse[pLabelBitMap^[(((h-1)-y)*w)+x]];
      inc(k);
    end;
  end;

  assign(ft,Where);
  rewrite(ft);
  writeln(ft,'//Width:',BmpHeader.Width,'  Height:',BmpHeader.Height,'  Size:',BitMapSize);
  writeln(ft,'tPrinterLabelGraphic BigLabelGraphic = {');
  j := 16;
  e := k div j;
  for y := 0 to h-1 do
  begin
    write(ft,'  ');
    for x := 0 to w-1 do
    begin
      if (BmpPalette.Item[0] = 0) then
        write(ft,'0x',hexb(pLabelImage^[y,x] xor $ff),',')
      else  write(ft,'0x',hexb(pLabelImage^[y,x]),',');
    end;
    writeln(ft);
  end;
  writeln(ft,'};');
  Close(fb);
  Close(ft);
  writeln('Done');
end;


begin
  new(pLabelBitMap);
  new(pLabelImage);
  ConvertBmpFile(ParamStr(1),ParamStr(2));
end.
