{ D3CURVE   writen by Michael Day - 06/29/00 }
{ Copyright 1987,2000 Frye Electronics, Inc. }
{ Sample Delphi V3.0 program to show usage of the }
{ Frye Instrument Packet Protocol interface program - FRYERS32.DLL}
{ This version is for Delphi V3.0 and above for Windows}
{ NOTE - you *must* have the Fryers32.DLL loaded either in the}
{ Windows directory, or the directory where this program is}

{program directives}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I+}    {I/O checking on}

unit Dc3unit;
interface
uses Fryers;

const SerialPort : integer = 1; //start with com1 for serial port
const FryersbaudRate : integer = 9600;
const Quick : boolean = false;
const FryersVersionString : string[255] = 'Fryers';
const BaudrateString : string[255] = '96700';

var  FryersObj : TFryers;

function DoMe:boolean;
procedure CloseRS232;

var SendData : array[0..F_MAX_DATA_SIZE] of INT16;
var RcvData : array[0..F_MAX_DATA_SIZE] of INT16;
var DispData : array[0..100] of INT16;


const FirstTime : boolean = true;
const IamBusy : boolean = false;
const KillMe : boolean = false;
implementation
uses forms,DcForm,Windows,Graphics,mmsystem,dialogs;

const  TextColor = clLime;  {text color}
       BoxColor = clAqua;  {box color}
       CrvColor = clYellow;  {curve color}
       BackColor = clBlack;  {background color}
       ForeColor = clWhite;  {foreGround color}
       cltype  : byte = 0;  {0=dot/x, 1=x&y, 2=x&y smoothed}

       {this plots the vertices to draw the graph with}
       xtab : array [0..79] of integer =
           (0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228);

const  NoShow = -32768;
TYPE   string2 = string[2];
       string4 = string[4];
       sarray = array[1..200] of smallint;
       parray = array[1..1200] of smallint;

VAR    raryx : parray;
       pary1 : parray;
       pary2 : parray;
       debug : boolean;
       ts,scale,poff : integer;
       rax,rbx,rcx,rdx:word;
       Err : integer;
       tw,th:integer;
       pcnt:word;
       Pstr : string;
       icnt : word;
Const GotError : boolean = false;

{poff = offset used to plot starting at bottom of box}
{scale = used to print numbers on left of box}

procedure pause(Duration:integer);
var t1:integer;
begin
  t1 := timeGetTime;
  while timeGetTime-t1 < Duration do {nop};
end;

{----------------------------------------------------}
{convert a byte to hex}
function HexString(Byt : byte) : string2;
const
  Hex : array[0..15] of char = '0123456789ABCDEF';
begin
  HexString := Hex[Byt shr 4] + Hex[Byt and 15];
end; { HexString }

{convert a word to hex}
function hexword(wrd:integer):string4;
Begin
  Hexword := hexstring(wrd shr 8) + hexstring(wrd and $ff);
end;

function fstr(L:longint):string;
var S:string;
begin
  str(l,s);
  fstr := s;
end;

{-----------------------------------------------------------------------}
{ set screen to graphic mode}

procedure StartGraph;
begin
  tw := 8; {Form1.PaintBox.canvas.textwidth('X'); }
  th := 8; {Form1.PaintBox.canvas.textheight('X');}
  with form1.memimage,canvas do
  begin
    font := form1.paintbox.font;
    pen.color := BackColor;
    brush.color := BackColor;
    rectangle(0,0,width,height);
  end;
end;

procedure Plot(x,y:word; c:Tcolor);
begin
  form1.writepixel(x,y,c);
end;

procedure SetPixelColor(FColor,BColor:Tcolor);
begin
  form1.memimage.canvas.pen.color := FColor;
end;

{-----------------------------------------------------------}
procedure xywrite(x,y:word; s:string; color:tColor);
var x1,y1,x2,y2:integer;
begin
  x1 := pred(x)*tw;
  y1 := pred(y)*th;
  x2 := x1+(length(s)*tw);
  y2 := y1+th;
  with form1.memimage.canvas do
  begin
    pen.color := BackColor;
    brush.color := BackColor;
    rectangle(x1,y1,x2,y2);
    font.color := color;
    textout(x1,y1,s);
  end;
end;

procedure xswrite(x,y,n:integer; l:byte; color:tColor);
var s : string;
begin
  s := fstr(n);
  while length(S) < l do
    s := s+' ';
  xywrite(x,y,s,color);
end;

{-----------------------------------------------------------------}
{this displays debug informaton while waiting for response}

procedure ShowStatus;
begin
   if debug then
   begin
     xywrite(34,19,'STATUS',textcolor);
     xywrite(34,20,'AX:'+hexword(rax),textcolor);
     xywrite(34,21,'BX:'+hexword(rbx),textcolor);
     xywrite(34,22,'CX:'+hexword(rcx),textcolor);
     xywrite(34,23,'DX:'+hexword(rdx),textcolor);

     if (rax and $0040) <> 0 then
     begin
       xywrite(6,2,'NO POLL',textcolor);
       GotError := true;
     end
     else
     begin
       if (rax and $ff9c) <> 0 then
       begin
         xywrite(6,2,'ERROR  ',textcolor);
         GotError := true;
       end;
     end;
   end;
end;

//{-----------------------------------------------------------------------}
//{ This procedure enables the RS232 port1 for use with the software. }

function InitRS232:boolean;
type str20 = string[20];
var bResult:boolean;
    Size,i,tmp:integer;
    s:str20;
    st:str20;
begin
  bResult := FryersObj.OpenPacketPort(SerialPort, FryersBaudrate, true, false);
  if (bResult = false) then
  begin
    ShowMessage('Cannot run program, FRYERS not loaded');
    InitRS232 := false;
    Exit;
  end;

  tmp := FryersObj.FVersion;
  system.str(tmp div 100,s);
  FryersVersionString := 'Fryers Version '+s+'.';
  tmp := tmp mod 100;
  system.str(tmp,st);
  if (system.length(st) = 1) then
    FryersVersionString := FryersVersionString+'0'+st
  else FryersVersionString := FryersVersionString+st;
  if (FryersObj.FVersion > 400) then
  begin
    FryersVersionString[0] := #0;
    Regs.AX := $0FFFD;
    Regs.DX := FryersObj.ComPort;
    Regs.CX := 0;
    CallFryers(Regs);
    Size := Regs.AX;
    if (Size < 255) then
    begin
      for i:=1 to Size do
      begin
        Regs.AX := $0FFFD;
        Regs.DX := FryersObj.ComPort;
        Regs.CX := i;
        CallFryers(Regs);
        st[0] := char(Regs.AL);
        st[1] := #0;
        FryersVersionString := FryersVersionString+st;
      end;//endfor(i)
    end; //endif(Size)
  end; //endif(Ver)
  InitRS232 := true;
end;

//----------------------------------
procedure CloseRS232;
begin
  FryersObj.ClosePacketPort();
  IamBusy := false;
end;

//----------------------------------------------------
//Get the current baudrate in use
//returns true if currently seeking new baudrate
function GetBaudrate:boolean;
var BaudOK:boolean;
begin
  Quick := FryersObj.CheckQT();
  if (FryersObj.GetCurrentBaudrate() > 100) then
  begin
    str(FryersObj.Baudrate,BaudrateString);
    FryersBaudrate := FryersObj.Baudrate;
    BaudOK := true;
  end
  else
  begin
    BaudrateString := ' (Baudrate Unknown)';
    BaudOK := false;
  end;
  if (FryersObj.BaudSeek = true) then
  begin
    BaudrateString := Baudratestring+' (Seeking)';
  end
  else if (BaudOK = true) then
  begin
    BaudrateString := BaudrateString +' Baud';
    if (Quick = true) then
      BaudrateString := BaudrateString+' Quick';
  end;
  GetBaudrate := FryersObj.BaudSeek;
end;

//--------------------------------------------------------
procedure DebugMonitor;
begin
  Rax := FryersObj.Regs.AX;
  Rbx := FryersObj.Regs.BX;
  Rcx := FryersObj.Regs.CX;
  Rdx := FryersObj.Regs.DX;
  ShowStatus();
  //if (FryersObj.BaudSeek = true) then
  //begin
    GetBaudrate();
    Form1.BaudrateLabel.Caption := BaudrateString;
  //end
end;

//--------------------------------------------------------
//Sends a cmd to target via Fryers}
function SendCmd(scmd:INT16; scnt:INT16; sdat:INT16):boolean;
begin
  SendCmd := false;
  if (FryersObj.SendReady() = false) then Exit;
  SendData[0] := scmd;
  SendData[1] := scnt;
  SendData[2] := sdat;
  SendCmd := FryersObj.SendCmd(@SendData[0],DebugMonitor);
end;

//---------------------------------------------------------
//Gets a response packet of integers from the rs232 port1.
function GetRsp:boolean;
var i:integer;
begin
  GetRsp := false;
  if (FryersObj.GetResponse(@RcvData[0],DebugMonitor) = false) then Exit;
  GotError := false;
  for i:=0 to 100 do
    DispData[i] := RcvData[i]; //{ convert rsp to plot format}
  GetRsp := true;
end;

//---------------------------------------------------------
//release instrument from comm mode
function QuickTerm:boolean;
begin
  QuickTerm := FryersObj.QuickTerminate(DebugMonitor);
end;

{--------------------------------------------}
{plot a curve on screen, clip to only within box}
procedure dodraw(a,b,c,d:integer; color:Tcolor; ct:integer);
var  x1,y1,x2,y2,x,y,xstep,ystep,deltax,deltay,direction : integer;
begin
  SetPixelColor(color,BackColor);
  x1 := a;
  x2 := c;
  if b > 190 then y1 := 190 else if b < 1 then y1 := 1 else y1 := b;
  if d > 190 then y2 := 190 else if d < 1 then y2 := 1 else y2 := d;
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  plot(x,y,color);   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (ct > 0)) then
        plot(x,y,color);   {plot first dot}
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (ct > 1)) then
        plot(x,y,color);   {plot first dot}
    end;
  until ((y = y2) and (x = x2));
end;

{----------------------------------------------------------------}
{draw the fixed stuff of the screen}

procedure dobox;
var i:integer;
begin
  dodraw(30,186,262,186,boxcolor,1);
  dodraw(262,186,262,0,boxcolor,1);
  dodraw(262,0,30,0,boxcolor,1);
  dodraw(30,0,30,186,boxcolor,1);

  for i := 1 to 18 do
  begin
    dodraw(succ(25),(i*10),29,(i*10),boxcolor,1);
  end;

  for i := 1 to 19 do
  begin
    dodraw((i*12)+31,187,(i*12)+31,190,boxcolor,1);
  end;

  xywrite(5,25,'.12',textcolor);
  xywrite(9,25,'.25',textcolor);
  xywrite(14,25,'.5',textcolor);
  xywrite(19,25,'1',textcolor);
  xywrite(24,25,'2',textcolor);
  xywrite(28,25,'4',textcolor);
  xywrite(33,25,'8',textcolor);

  xywrite(34,1,'SOURCE',textcolor);
  xywrite(34,4,'RMS OUT',textcolor);
  xywrite(34,7,'TOP SPL',textcolor);
  xywrite(34,10,'N.R.',textcolor);
  xywrite(34,13,'FLAGS',textcolor);
end;

{------------------------------------------------------}
{update the numbers for the curve}

procedure miscinfo;
begin
  xywrite(34,2,'      ',textcolor); {src}
  if pary1[8] = 0 then xywrite(34,2,'OFF',textcolor) else xywrite(34,2,fstr(pary1[8]),textcolor);

  xywrite(34,5,'      ',textcolor);
  xywrite(34,5,fstr(pary1[10]),textcolor);{rms out}

  xywrite(34,8,'      ',textcolor);
  xywrite(34,8,fstr(pary1[9]),textcolor); {top val}

  xywrite(34,11,'      ',textcolor);    {noise reduction}
  if pary1[11] = 0 then xywrite(34,11,'OFF',textcolor) else xywrite(34,11,fstr(pary1[11]),textcolor);

  xywrite(34,14,'      ',textcolor);
  xywrite(34,14,hexword(pary1[4]),textcolor); {flags a}

  xywrite(34,15,'      ',textcolor); {flags b}
  xywrite(34,15,hexword(pary1[5]),textcolor);
end;

{-------------------------}
{figure out what the scale is and show it on the graph}

procedure findscale;
begin
  ts := (pary1[9] div 100);
  scale := (ts div 20)*20 + 20;
  poff := (scale*2)+10;

  if not(GotError) then
  begin
   if (pary1[1] and $4000) <> 0 then xywrite(6,2,'BAD RSP',textcolor) {unexpected response}
   else
    if pary1[4] = $0400 then xywrite(6,2,'INVALID',textcolor)  {bad curve}
    else
     if (pary1[4] and $4000) = 0 then xywrite(6,2,'dBSPL  ',textcolor) {power curve}
     else
       xywrite(6,2,'GAIN   ',textcolor);  {none of the above, so must be gain}
  end;

  xswrite(1,2,scale+00,3,textcolor);
  xswrite(1,7,scale-20,3,textcolor);
  xswrite(1,12,scale-40,3,textcolor);
  xswrite(1,17,scale-60,3,textcolor);
  xswrite(1,22,scale-80,3,textcolor);
end;

{-------------------------}
Procedure dispcurve;
//var dd:integer;
var da,db,xa,xb,ya,yb,x,i : integer;
const lm = 32;  {left margin on graph}
  function GetPoint(i:integer):integer;
  var k : integer;
  begin
    k := i;
    while (pary1[k] = NoShow) and (k < 79) do
      inc(k);
    GetPoint := pary1[k];
  end;
begin
  i := 12; {start with 100hz plot}
  x := 0;
  while (pary1[i] = NoShow) and (i < 79) do
  begin
    inc(i);
    inc(x);
  end;
  repeat
    da := GetPoint(i);
    db := GetPoint(i+1);
    if not(da = NoShow) then
      da := poff - (da div 50);
    if not (db = NoShow) then
      db := poff - (db div 50);
//    if da < 0 then
//      dd := da;

    ya := pary2[i];
    yb := pary2[i+1];
    pary2[i] := da;
    xa := xtab[x]+lm;
    xb := xtab[x+1]+lm;
    i := i + 1;
    x := x + 1;
    if xa = xb then   { skip next when xa = xb }
    begin
      i := i + 1;
      x := x + 1;
    end;
    if not((xa = NoShow) or (xb = NoShow)) then
      dodraw(xa,ya,xb,yb,BackColor,0); {undraw}
    if not((da = NoShow) or (db = NoShow)) then
      dodraw(xa,da,xb,db,crvcolor,0); {draw new one}
  until x > 78;
  pary2[i] := db;
  miscinfo;
end;

{--------------------------------------------}
{set the arrays at start up to a known value}

procedure clrarys;
var i : integer;
begin
  for i := 1 to 100 do pary1[i] := 2000;
  pary1[2] := 89;
  for i := 1 to 100 do pary2[i] := 2000;
  pary2[2] := 89;

  for i := 1 to 100 do raryx[i] := 2000;
  raryx[2] := 89;
end;

{$IFNDEF WIN32}
  procedure setlength(var s:string; L:byte);
  begin
    S[0] := char(L);
  end;
{$ENDIF}

{-----------------------------------------------}
{main program starts here}

function StartMeUp:boolean;
begin
  StartMeUp := false;
  comport := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    if (Pstr[1] >= '0') and (Pstr[1] <= '9') then
    begin
      comport := ord(Pstr[1]) and $0f;
    end
    else
    begin
      case upcase(Pstr[1]) of
      'C': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                setlength(Pstr,length(Pstr)-1);
              val(Pstr,comport,Err);
              if (comport > 15) or (Err <> 0) then comport := 0;
           end;
      end;
    end;
    dec(Pcnt);
  end;
  if comport > 0 then comport := pred(comport);
  if comport > 15 then comport := 0;

  debug := true;
  if not(initRS232) then Exit; {Halt(1);}

  startgraph;
  fillchar(pary1,sizeof(pary1),0);
  scale := 120;
  clrarys;
  icnt := 0;
  FirstTime := false;
  StartMeUp := true;
end;

function DoMe:boolean;
begin
  DoMe := false;
  IamBusy := true;
  try
    if FirstTime then
      if not StartMeUp then Exit;
    if KillMe then Exit;

    dobox;        {put the fixed stuff on the screen}
    form1.refreshbitmap;
{//    xywrite(6,2,'----------',BackColor);}
    sendcmd(25,1,0);      {ask for curve 0}
    form1.refreshbitmap;
    FryersObj.GetResponse(@RcvData[0],DebugMonitor);   {get the response}
    form1.refreshbitmap;
{//    xywrite(1,10,fstr(icnt),ForeColor);  }
    findscale;            {figure out scaling}
    dispcurve;   {now show the curve}
    form1.refreshbitmap;
    inc(icnt);
  finally
    IamBusy := false;
    DoMe := true;
  end;
end;


end.


