unit Dcform;
interface
{$IFDEF WIN32}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,DCunit, StdCtrls;
{$ELSE}
uses
  WinTypes,WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,DCunit, StdCtrls;
{$ENDIF}

type
  TForm2 = class(TForm)
    PaintBox: TPaintBox;
    Timer2: TTimer;
    Label1: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    procedure AppIdle(Sender: TObject; var Done: Boolean);
  public
    { Public declarations }
     MemImage : TBitmap;
     procedure RefreshBitMap;
     procedure WritePixel(x,y:integer; c:tcolor);
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.RefreshBitMap;
begin
  Form2.PaintBox.Canvas.CopyMode := cmSrcCopy;
  Form2.PaintBox.Canvas.StretchDraw(Form2.PaintBox.Canvas.ClipRect,Form2.MemImage);
end;

procedure TForm2.WritePixel(x,y:integer; c:tcolor);
begin
   memimage.canvas.pixels[x,y] := c;
end;

procedure TForm2.AppIdle(Sender: TObject; var Done: Boolean);
begin
{//  Done := true;}
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  KillMe := true;
  while IamBusy do
    application.processmessages;
  CloseRS232;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  LoadFryers;
{//  Application.OnIdle := AppIdle;}
  form2.MemImage := TBitmap.Create;
  form2.MemImage.Width := Form2.PaintBox.Width;
  form2.MemImage.Height := Form2.PaintBox.Height;
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
 {// FreeFryers;}
  form2.MemImage.free;
end;

procedure TForm2.Timer2Timer(Sender: TObject);
begin
  if IamBusy then Exit;
  if not DoMe then Close;
end;


procedure TForm2.FormPaint(Sender: TObject);
begin
  RefreshBitmap;
end;

procedure TForm2.FormResize(Sender: TObject);
begin
  RefreshBitMap;
end;

procedure TForm2.FormShow(Sender: TObject);
begin
   Refreshbitmap;
end;

procedure TForm2.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #$1B) or (Key = ^C) then
    Close;
end;

end.
