//---------------------------------------------------------------------------
#ifndef FryeDataH
#define FryeDataH
//---------------------------------------------------------------------------

#define ERROR_COLOR clRed        //something went wrong
#define WARNING_COLOR clFuchsia  //Warning message
#define NOTICE_COLOR clYellow    //Please notice this message
#define STATUS_COLOR clWhite     //normal process
#define ACTION_COLOR clSilver    //What's going on
#define SUCCESS_COLOR clLime     //done
#define NO_COLOR ((TColor)0)     //don't change the color

//Possible errors that might be returned
//Fryers Errors are -1000 series numbers
#define FRYERS_FILE_NOT_FOUND -1000  //device driver file not found
#define FRYERS_ENTRY_NOT_FOUND -1001 //entry point to fryers driver not found
#define FRYERS_SUCCESS 0             //Fryers driver is loaded and entry point found

//---------------------------------------------------------------------------
//Program Error code definitions
#define PRG_CANCEL CANCEL //cancel and success are the same as rs232
#define PRG_SUCCESS SUCCESS
#define PRG_NO SAY_NO

//main program errors use the 1000 series
//#define PRG_NO_OPTION_LIST 1003
//#define PRG_ID_NOT_FOUND 1005
//#define PRG_DISK_WRITE_FAILED 1010
#define PRG_DEVICE_ID_WRONG 1012
//#define PRG_UPDATE_OPTION_FAILED 1016
#define PRG_FLASH_ERASE_FAILED 1017
#define PRG_FLASH_WRITE_FAILED 1018
#define PRG_OPTION_WRITE_FAILED 1019

//error title numbers
#define PRG_ERROR_CHECK_INST 1100
#define PRG_ERROR_UPDATE_OPTIONS 1200
#define PRG_ERROR_UPDATE_FLASH 1300
#define PRG_ERROR_WRITE_DISK 1400
#define PRG_ERROR_WRITE_FILE 1500

//Flash Error flag definitions
#define FLASH_ERASERR BIT0    // Unable to erase target
#define FLASH_WRITERR BIT1    // Unable to write to target
#define FLASH_TARGERR BIT2    // Target not supported by this command
#define FLASH_ADDRERR BIT3    // Address is outside of target
#define FLASH_BUFFERR BIT4    // Command would cause Buffer overflow
#define FLASH_CRCERR  BIT5    // CRC error
#define FLASH_RECTERR BIT6    // Unknown record type error
#define FLASH_ENTRERR BIT7    // Bad entry address

//File errors are 2000 series numbers
#define FILE_NOT_SELECTED 2000
#define FILE_NOT_FOUND 2001
#define FILE_FORMAT_BAD 2002
#define FILE_NO_EOF 2003
#define FILE_ERROR 2004
#define FILE_COMPRESSION_ERROR 2005

//common errors
#define RS232_CANCEL CANCEL   //CANCEL =-1
#define RS232_SUCCESS SUCCESS //SUCCESS=0

//Fryers errors use the 9000 series
#define RS232_BAD_FRYERS_DRIVER 9000 //bad version of Fryers Driver
#define RS232_PORT_NOT_FOUND 9001    //Requested port not available
#define RS232_PORT_NOT_OPEN 9002     //Requested port not open for communication
#define RS232_PACKET_NOT_OPEN 9003   //Requested port not open for packet xfer
#define RS232_NO_POLL 9004           //no polls from the instrument
#define RS232_SEND_ERROR 9005        //error while trying to send the command
#define RS232_NO_RESPONSE 9006       //no response recieved
#define RS232_RESPONSE_ERROR 9007    //error while recieveing the response
#define RS232_CMD_FAIL 9008          //unexpected response to a command
#define RS232_ILL_RSP 9010           //illegal command rcvd as a response
#define RS232_NAK_RSP 9011           //NAK rcvd as a respond
#define RS232_IN_BOOTLOADER 9012     //tried to give non-BL cmd while in BL

#define RS232_AUTOBAUD_FAILED 9100  //could not find baudrate
#define RS232_BAD_BAUDRATE 9101     //tried to set an invalid baudrate

extern char ErrorFilename[256];

#endif
