// BCURVE   writen by Michael Day - 06/22/00 }
// Copyright 1987,2000 Frye Electronics, Inc. }
// Sample C++ Builder V1.0 program to show usage of the }
// Frye Instrument Packet Protocol interface program - FRYERS32.DLL}
// This version is for borland C++ Builder V1.0 and above for Windows}
// NOTE - you *must* have the Fryers32.DLL loaded either in the}
// Windows directory, or the directory where this program is}
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Fryers.h"
#include "BcUnit.h"
#include "BcForm.h"
#include "MMSystem.h"
#include "Stdlib.h"
#include "mem.h"

//---------------------------------------------------------------------------

#define FAST_XFER //undef this to use the slower (but more reliable xfer method)

typedef short INT16;
typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef long int INT32;

bool FirstTime = true;
bool IamBusy = false;
bool PauseMe = false;
bool KillMe = false;
bool IamRunning = false;
bool ReadResponse = false;
bool BaudSeek = false;
bool PortOpen = false;
bool SendResult = false;
bool RspResult = false;
WORD ComPort = 0;   //{COM port to use - 0 or 1 }
int Fversion = 0;
int Baudrate = 9600;
char FryersVersionString[255] = "Fryers";
char BaudrateString[40] = "9600";

F_RegsType Regs;               //used to process via Fryers driver

TColor TextColor = clLime;  //{text color}
TColor BoxColor = clAqua;  //{box color}
TColor CrvColor = clYellow;  //{curve color}
TColor BackColor = clBlack;  //{background color}
TColor ForeColor = clWhite;  //{foreGround color}
BYTE   cltype  = 0;  //{0=dot/x, 1=x&y, 2=x&y smoothed}

//{this plots the vertices to draw the graph with}
int Xtab[80] = {
            0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228};

#define NoShow -32768
#define RX_SIZE 1200
#define SX_SIZE 200
typedef INT16 Sarray[SX_SIZE+10];
typedef INT16 Parray[RX_SIZE+10];

Sarray Sary;
Parray RaryX;
Parray Pary1;
Parray Pary2;
bool Debug;
int ts;
int Scale,Poff;
WORD Rax,Rbx,Rcx,Rdx;
int Err;
int Pcnt;

bool GotError = false;
char Hex[16] = {"0123456789ABCDEF"};
char PStr[255];

//{Poff = offset used to plot starting at bottom of box}
//{Scale = used to print numbers on left of box}

void Pause(int Duration) {
  INT32 t1 = (INT32)timeGetTime();
  while ((((INT32)(timeGetTime()))-t1) < Duration) {};
};

//{----------------------------------------------------}
//{convert a byte to hex}
char* HexString(BYTE Byt, char* Str) {
  Str[0] = Hex[Byt >> 4];
  Str[1] = Hex[Byt & 15];
  Str[2] = 0;
  return(Str);
};

//{convert a word to hex}
char* HexWord(WORD Wrd, char* Str) {
  Str[0] = Hex[(Wrd >> 12) & 0xf];
  Str[1] = Hex[(Wrd >> 8) & 0xf];
  Str[2] = Hex[(Wrd >> 4) & 0xf];
  Str[3] = Hex[Wrd & 0xf];
  Str[4] = 0;
  return(Str);
};

void xsWrite(int x, int y, int Val, BYTE Len, TColor Color) {
  int k;
  char Str[20];
  itoa(Val,Str,10);
  k = strlen(Str);
  while (k < Len) {
    Str[k] = ' ';
    k++;
  }
  Str[k] = 0;
  xyWrite(x,y,Str,0,Color);
};

//{-----------------------------------------------------------------}
//{this displays debug informaton while waiting for response}

void ShowRegs(WORD rax, WORD rbx, WORD rcx, WORD rdx) {
  char Str[20];
   if (Debug == true) {
     xyWrite(34,19,"STATUS",0,TextColor);
     xyWrite(34,20,"AX:",HexWord(rax,Str),TextColor);
     xyWrite(34,21,"BX:",HexWord(rbx,Str),TextColor);
     xyWrite(34,22,"CX:",HexWord(rcx,Str),TextColor);
     xyWrite(34,23,"DX:",HexWord(rdx,Str),TextColor);

     if ((rax & 0x0040) != 0) {
       xyWrite(6,2,"NO POLL",0,TextColor);
       GotError = true;
     }else{
       if ((rax & 0x0ff9c) != 0) {
         xyWrite(6,2,"ERROR  ",0,TextColor);
         GotError = true;
       }
     }
   }
};

//{-------------------------------------------------------------------}
//{returns PacketStatus set to the current packet status value}
//{The primary packet status is returned in AL as follows}
//{7=bad transfer, 6=no poll, 5=reserved, 4=receive overflow}
//{3=send overflow, 2=send overrun, 1=receive ready, 0=send ready}
//{See the Fryers manual for a description of other error info}
BYTE PacketStatus(void) {
  //error out everything if driver not loaded
  if (FryersLoaded() == false) return(0x0ff);
  Regs.AX = 0x0FF13;
  Regs.DX = ComPort;
  CallFryers(&Regs);
  Rax = (WORD)Regs.AX;
  Rbx = (WORD)Regs.BX;
  Rcx = (WORD)Regs.CX;  //{save the error status response}
  Rdx = (WORD)Regs.DX;
  return((BYTE)(Regs.AX & 0x0FF));  //{return primary packet status (reg al)}
};

//{-------------------------------------------------------------------}
//{checks to see if lost poll from 6500. If so then checks to see if}
//{a key has been pressed. If so then returns PacketAbort true.}
bool PacketAbort(void) {
  if ((PacketStatus() & 0x40) != 0x40) return(false);
  return(true);
};


//{-------}
WORD GetPacketTimer(void) {
  if (FryersLoaded() == false) return(0);
  Regs.DX = ComPort;
  Regs.AX = 0x0FF17;
  Regs.CX = 0x0300;
  CallFryers(&Regs);
  return((WORD)Regs.AX);
};

//{----------------------------------------------------}
//{Get the current baudrate in use}
void GetCurrentBaudrate(void) {
  if (FryersLoaded() == false) return;
  Regs.DX = ComPort;
  Regs.AX = 0x0FFFF;
  CallFryers(&Regs);
  if ((Regs.DI > 0) && (Regs.DI < 24)) {
    Baudrate = 115200 / Regs.DI;
    itoa(Baudrate,BaudrateString,10);
  }else{
    strcpy(BaudrateString,"Baudrate Unknown");
  }
  if (BaudSeek == true)
    strcat(BaudrateString," (Seeking)");
  else strcat(BaudrateString," Baud");
  if (FirstTime != true)
    Form1->BaudrateLabel->Caption = BaudrateString;
};

//{-------------------------------------------------------------------}
//{Checks on baudrate. If baud rate is wrong, tries to switch}
//{the baudrate (if V4.00 Fryers) to see if it will fix the problem.}
bool AutoBaudCheck(void) {
WORD tax;
  if ((PortOpen == false) || (FryersLoaded() == false) || (Fversion < 400))
    return(false);
  Regs.DX = ComPort;
  Regs.BX = 0; //{0=autobaud}
  Regs.AX = 0xFF1B;
  CallFryers(&Regs);
  if (Regs.BX > 0)
    Baudrate = Regs.BX;
  if ((Regs.CX & 0x0020) != 0)
    BaudSeek = true;
  else
    BaudSeek = false;
  if (BaudSeek == true) {
    tax = GetPacketTimer();
    while (tax == GetPacketTimer()) {
      if (KillMe == true) return(false);
      //if (PacketAbort() == true) return(false);
    }
  }
  GetCurrentBaudrate();
  return(true);
};


//{-----------------------------------------------------------------------}
//{ This procedure enables the RS232 port1 for use with the software. }

bool InitRS232(void) {
  int Size,i;
  char s[20];
  char st[20];
  PortOpen = false;
  if (FryersLoaded() == true) {
    Regs.DX = ComPort;
    Regs.AX = (int)(0x0ffff);
    CallFryers(&Regs);
  }else{
    Regs.DX = 0;
    Regs.AX = 0;
  }
  if ( ((int)(Regs.DX & 0x0ffff) != (int)(0x0ffff)) || (Regs.AX < 0x40) )
  {
    ShowMessage("Cannot run program, FRYERS not loaded");
    return(false);
  }

  Regs.DX = ComPort;
  Regs.AX = (int)(0x0fffe);
  Regs.SI = 0;
  Regs.DI = 0;
  CallFryers(&Regs);
  Fversion = Regs.BX;
  itoa(Regs.BX / 100,s,10);
  strcpy(FryersVersionString,"Fryers Version ");
  strcat(FryersVersionString,s);
  strcat(FryersVersionString,".");
  Regs.BX = Regs.BX % 100;
  itoa(Regs.BX,st,10);
  if (strlen(st) == 1) {
     strcat(FryersVersionString,"0");
     strcat(FryersVersionString,st);
   }else{
     strcat(FryersVersionString,st);
   }
   if (Fversion > 400) {
     FryersVersionString[0] = 0;
     Regs.AX = (int)(0x0FFFD);
     Regs.DX = ComPort;
     Regs.CX = 0;
     CallFryers(&Regs);
     Size = Regs.AX;
     if (Size < 255) {
       for (i=1; i<=Size; i++) {
         Regs.AX = (int)(0x0FFFD);
         Regs.DX = ComPort;
         Regs.CX = i;
         CallFryers(&Regs);
         st[0] = char(Regs.AL);
         st[1] = 0;
         strcat(FryersVersionString,st);
       }
     }
   }

   Regs.AX = (int)(0x0ff00); //{disable fryers interrupt procedure}
   Regs.CX = (int)(0x0ff00); //{this makes sure everything is kosher}
   Regs.DX = ComPort;
   CallFryers(&Regs);

   Regs.AX = (int)(0x0ff00); //{enable fryers interrupt procedure}
   Regs.CX = (int)(0x0ffff);
   Regs.DX = ComPort;
   CallFryers(&Regs);
   Regs.AX = (int)(0x0ff10); //{enable fryers packet protocol}
   Regs.CX = (int)(0x0ffff);
   Regs.DX = ComPort;
   CallFryers(&Regs);
   Regs.AX = 0x00f3;  //{init to 9600 baud, no parity, 8 data bits}
   Regs.DX = ComPort;    //{use autobaud}
   CallFryers(&Regs);
   Rax = (WORD)(Regs.AX & 0x0ffff);
   Rbx = (WORD)(Regs.BX & 0x0ffff);
   Rcx = (WORD)(Regs.CX & 0x0ffff);
   Rdx = (WORD)(Regs.DX & 0x0ffff);
   PortOpen = true;
  AutoBaudCheck();
  GetCurrentBaudrate();
  Form1->Label1->Caption = FryersVersionString;
  return(true);
};

void CloseRS232(void) {
  if ((FryersLoaded() == false)||(PortOpen == false)) return;
  Regs.AX = (int)(0x0ff00); //{disable fryers interrupt procedure}
  Regs.CX = (int)(0x0ff00); //{this makes sure everything is kosher}
  Regs.DX = ComPort;
  CallFryers(&Regs);
  PortOpen = false;
};

//{-----------------------------------------------------------------------}
//{ waits for int14 to be ready to accept send cmd}

bool SendWait(void) {
  int Status;

  GotError = false;
  if (FryersLoaded() == false) {
    KillMe = true;
    return(false);
  }
  do {
    AutoBaudCheck();
    if (BaudSeek == true) return(false);
    if (KillMe == true) return(false);
    Status = PacketStatus();
    if ((Status & 0x0060) != 0) return(false);
    if ((Status & 0x0001) != 0) return(true);

//    Regs.AX = (int)(0x0ff13);
//    Regs.DX = ComPort;
//    CallFryers(&Regs);
//    Rax = (WORD)(Regs.AX & 0x0ffff);
    ShowRegs(Rax,Rbx,Rcx,Rdx);
//    if (((Rax & 0x0060) != 0) || (KillMe == true))
//      return(false);
  }while(true);// ((Rax & 0x0001) == 0);
  //return(true);
};

//{-----------------------------------------------------------------------}
//{ sends a cmd to target via the rs232 port}

bool SendCmd(INT16 scmd, INT16 scnt, INT16 sdat) {
 // int i;
  if (SendWait() == false) return(false);
  Sary[1] = scmd;
  Sary[2] = scnt;
  Sary[3] = sdat;

#ifdef FAST_XFER
  //Live fast and take risks!
  Regs.AX = 0x0ff11;
  Regs.CX = SX_SIZE;
  Regs.DX = ComPort;
  Regs.EBX = (int)(&Sary[1]);
  CallFryers(&Regs);
#else
  //this is a slightly slower but more reliable transfer method
  for (i=1; i<=scnt+2; i++) {
    Regs.AX = (int)(0x0ff23);
    Regs.DX = ComPort;
    Regs.BX = Sary[i];
    Regs.CX = (i-1);
    CallFryers(&Regs);
  }
  Regs.AX = int (0x0ff15);
  Regs.DX = ComPort;
  CallFryers(&Regs);
#endif
  return(true);
};

//{-----------------------------------------------------------------------}
//{ waits for response from target}

bool RspWait(void) {
  int Status;

  if (FryersLoaded() == false) {
    KillMe = true;
    return(false);
  }
  do {
    AutoBaudCheck();
    if (BaudSeek == true) return(false);
    if (KillMe == true) return(false);
    Status = PacketStatus();
    if ((Status & 0x0060) != 0) return(false);
    if ((Status & 0x0001) != 0) return(true);
    ShowRegs(Rax,Rbx,Rcx,Rdx);
  } while(true);
  //return(true);
};

//{-----------------------------------------------------------------------}
//{ gets a response packet of integers from the rs232 port1. }

bool GetResponse(void) {
  int i; //,Size;
  if (RspWait() == false) return(false);
#ifdef FAST_XFER
  //Live fast and take risks!
  Regs.AX = 0x0ff12;
  Regs.CX = RX_SIZE;
  Regs.DX = ComPort;
  Regs.EBX = (int)(&RaryX[1]);
  CallFryers(&Regs);
#else
  //this is a slightly slower but more reliable transfer method
  Regs.AX = (int)(0x0ff26); //{how much data?}
  Regs.DX = ComPort;
  Regs.CX = 1;
  CallFryers(&Regs);
  Size = Regs.CX;
  for (i=1; i<=Size+2; i++) {
    Regs.AX = (int)(0x0ff26);  //{get the data}
    Regs.DX = ComPort;
    Regs.CX = (i-1);
    CallFryers(&Regs);
    RaryX[i] = (INT16)(Regs.DX);
  }
  Regs.AX = (int)(0x0ff16);  //{clear rcv flag}
  Regs.DX = ComPort;
  CallFryers(&Regs);
#endif
  for (i=1; i<=100; i++)
    Pary1[i] = RaryX[i]; //{ convert rsp to plot format}
  RaryX[2] = 0;
  return(true);
};

//----------------------------------------------
//send quick terminate to release instrument form communication mode
//(alternately the instrument will autoexit if you don't respond within 50ms).
bool QuickTerminate(void) {
  return(SendCmd(0x7fff,0,0));
};

// --------------------------------------------
// plot a line on screen, clip to only within box

void DoDraw(int x1, int y1, int x2, int y2, TColor color, int cltype)
{
    int x;
    int y;
    int xstep;
    int ystep;
    int deltax;
    int deltay;
    int direction;

    if (y1 > 185) y1 = 185;    // clip to boundry
    if (y1 < 1) y1 = 1;
    if (y2 > 185) y2 = 185;
    if (y2 < 1) y2 = 1;

    x = x1;
    y = y1;

    if (x1 == x2) xstep = 0;
    else
      if (x1 > x2) xstep = -1;
      else
        xstep = 1;

    if (y1 == y2) ystep = 0;
    else
      if (y1 > y2) ystep = -1;
      else
        ystep = 1;

    deltax = abs(x2 - x1);
    deltay = abs(y2 - y1);
    if (deltax == 0) direction = -1;
    else
      direction = 0;

    Plot(x,y,color);
    do
    {
      if (direction < 0)
      {
        y = y + ystep;
        direction = direction + deltax;
        if ((direction >= 0) || (cltype > 0)) Plot(x, y, color);
      }
      else
      {
        x = x + xstep;
        direction = direction - deltay;
        if ((direction >= 0) || (cltype > 1)) Plot(x, y, color);
      }
    }
    while (!(( x == x2 ) && ( y == y2 )));
}

//{----------------------------------------------------------------}
//{draw the fixed stuff of the screen}

void DoBox(void) {
  int i;
  DoDraw(30,186,262,186,BoxColor,1);
  DoDraw(262,186,262,0,BoxColor,1);
  DoDraw(262,0,30,0,BoxColor,1);
  DoDraw(30,0,30,186,BoxColor,1);

  for (i=1; i<=18; i++) {
    DoDraw(25+1,(i*10),29,(i*10),BoxColor,1);
  }

  for (i=1; i<=19; i++) {
    DoDraw((i*12)+31,187,(i*12)+31,190,BoxColor,1);
  }

  xyWrite(5,25,".12",0,TextColor);
  xyWrite(9,25,".25",0,TextColor);
  xyWrite(14,25,".5",0,TextColor);
  xyWrite(19,25,"1",0,TextColor);
  xyWrite(24,25,"2",0,TextColor);
  xyWrite(28,25,"4",0,TextColor);
  xyWrite(33,25,"8",0,TextColor);

  xyWrite(34,1,"SOURCE",0,TextColor);
  xyWrite(34,4,"RMS OUT",0,TextColor);
  xyWrite(34,7,"TOP SPL",0,TextColor);
  xyWrite(34,10,"N.R.",0,TextColor);
  xyWrite(34,13,"FLAGS",0,TextColor);
};

//{------------------------------------------------------}
//{update the numbers for the curve}

void MiscInfo(void) {
  char s[20];
  xyWrite(34,2,"      ",0,TextColor); //{src}
  if (Pary1[8] == 0) {
    xyWrite(34,2,"OFF",0,TextColor);
  }else{
    itoa(Pary1[8],s,10);
    xyWrite(34,2,s,0,TextColor);
  }
  xyWrite(34,5,"      ",0,TextColor);
  itoa(Pary1[10],s,10);
  xyWrite(34,5,s,0,TextColor);//{rms out}

  xyWrite(34,8,"      ",0,TextColor);
  itoa(Pary1[9],s,10);
  xyWrite(34,8,s,0,TextColor); //{top val}

  xyWrite(34,11,"      ",0,TextColor);    //{noise reduction}
  if (Pary1[11] == 0) {
    xyWrite(34,11,"OFF",0,TextColor);
  }else{
    itoa(Pary1[11],s,10);
    xyWrite(34,11,s,0,TextColor);
  }
  xyWrite(34,14,"      ",0,TextColor);
  HexWord(Pary1[4],s);
  xyWrite(34,14,s,0,TextColor); //{flags a}

  xyWrite(34,15,"      ",0,TextColor); //{flags b}
  itoa(Pary1[5],s,10);
  xyWrite(34,15,s,0,TextColor);
};

//{-------------------------}
//{figure out what the scale is and show it on the graph}

void FindScale(void) {
  ts = (Pary1[9] / 100);
  Scale = (ts / 20)*20 + 20;
  Poff = (Scale*2)+10;

  if (GotError == false) {
    if (BaudSeek == true) {
      xyWrite(6,2,"BAUDSEEK",0,TextColor); //{unexpected response}
    }else if ((Pary1[1] & 0x4000) != 0) {
      xyWrite(6,2,"BAD RSP",0,TextColor); //{unexpected response}
    }else{
      if (Pary1[4] == 0x0400) {
        xyWrite(6,2,"INVALID",0,TextColor);  //{bad curve}
      }else{
        if ((Pary1[4] & 0x4000) == 0) {
          xyWrite(6,2,"dBSPL  ",0,TextColor); //{power curve}
        }else{
          xyWrite(6,2,"GAIN   ",0,TextColor);  //{none of the above, so must be gain}
        }
      }
    }
  }//endif(GotError)

  xsWrite(1,2,Scale+00,3,TextColor);
  xsWrite(1,7,Scale-20,3,TextColor);
  xsWrite(1,12,Scale-40,3,TextColor);
  xsWrite(1,17,Scale-60,3,TextColor);
  xsWrite(1,22,Scale-80,3,TextColor);
};

//{-------------------------}
int GetPoint(int i) {
  int k = i;
  while ((Pary1[k] == NoShow) && (k < 79)) {
    k++;
  }
  return(Pary1[k]);
};

void DispCurve(void) {
  int da,db,xa,xb,ya,yb,x,i;
  int lm = 32;  //{left margin on graph}

  i = 12; //{start with 100hz plot}
  x = 0;
  while ((Pary1[i] == NoShow) & (i < 79)) {
    i++;
    x++;
  }
  do {
    da = GetPoint(i);
    db = GetPoint(i+1);
    if (da != NoShow)
      da = Poff - (da / 50);
    if (db != NoShow)
      db = Poff - (db / 50);
//    if (da < 0)
//      dd = da;

    ya = Pary2[i];
    yb = Pary2[i+1];
    Pary2[i] = (INT16)da;
    xa = Xtab[x]+lm;
    xb = Xtab[x+1]+lm;
    i = i + 1;
    x = x + 1;
    if (xa == xb) {  //{ skip next when xa = xb }
      i = i + 1;
      x = x + 1;
    }
    if ((xa != NoShow) && (xb != NoShow))
      DoDraw(xa,ya,xb,yb,BackColor,0); //{undraw}
    if ((da != NoShow) && (db != NoShow))
      DoDraw(xa,da,xb,db,CrvColor,0); //{draw new one}
  }while(x <= 78);
  Pary2[i] = (INT16)db;
  MiscInfo();
};


//{--------------------------------------------}
//{set the arrays at start up to a known value}

void ClrArys(void) {
  int i;
  for (i=1; i<=100; i++) Pary1[i] = 2000;
  Pary1[2] = 89;
  for (i=1; i<=100; i++) Pary2[i] = 2000;
  Pary2[2] = 89;

  for (i=1; i<=100; i++) RaryX[i] = 2000;
  RaryX[2] = 89;
};

//{-----------------------------------------------}
//{main program starts here}

bool StartMeUp(void) {
  Debug = true;
  Form1->BaudrateLabel->Caption = "Initializing";
  Application->ProcessMessages();
  if (InitRS232() == false) return(false); //{Halt(1);}

  StartGraph();
  setmem(Pary1,sizeof(Pary1),0);
  Scale = 120;
  ClrArys();
  FirstTime = false;
  Form1->RefreshBitmap();
  Application->ProcessMessages();
  return(true);
};

//---------------------------------------------------
//do a run on the Fonix instrument
bool DoMe(void) {
  IamBusy = true;
    if (FirstTime == true) {
      if (StartMeUp() == false) {
        IamBusy = false;
        return(false);
      }
    }
    if (KillMe == true) {
      IamBusy = false;
      return(false);
    }
    if (PauseMe == true) {
      IamBusy = false;
      return(true);
    }
    DoBox();       // {put the fixed stuff on the screen}
    if (ReadResponse == true) {
      RspResult = GetResponse(); //{get the response}
      if (RspResult == true) {
        ReadResponse = false;
        QuickTerminate();
      }
    }
    SendResult = SendCmd(25,1,0);  //{ask for curve 0}
    if (SendResult == true) {
      ReadResponse = true;
    }
    FindScale();            //{figure out scaling and errors}
    if (RspResult == true) {
      DispCurve();   //{now show the curve}
    }
    Form1->RefreshBitmap();
    IamBusy = false;
  return(true);
};


