//---------------------------------------------------------------------------
#include <windows.h>
#pragma anon_struct on
#include "Fryers.h"

//---------------------------------------------------------------------------
#define F_MAX_PORT 15
TFryers* FryersObj[F_MAX_PORT];

#define DEFAULT_POLL_TIME 100 //default poll timeout = 5.5 sec
#define DEFAULT_RSP_TIME 20   //default response timeout 1.1 second
#define DEFAULT_RCV_TIME 20   //default receive timeout 1.1 second

enum {
  SUCCESS = 0,
  NO_FRYERS = 1,
};

HINSTANCE FryersLibHandle = NULL;
tCallFryers CallFryers = NULL;  //this is __stdcall

bool __stdcall FryersLoaded(void) {
  return(FryersLibHandle != NULL);
};

bool __stdcall LoadFryers(void)
{
  FryersLibHandle = LoadLibrary("fryers32.dll");
  if (FryersLibHandle != NULL) {
    CallFryers = (tCallFryers)GetProcAddress(FryersLibHandle, "CallFryers");
    if (CallFryers != NULL)
      return(TRUE);
  } return(FALSE);
}

bool __stdcall ReleaseFryers(void){
  bool fFreeResult = FreeLibrary(FryersLibHandle);
  return(fFreeResult);
}

//===============================================================
// FryersObj code
//===============================================================


//---------------------------------------------------------------------------------
//update fryers info - updates the version info for fryers and the baud rate in use
/*
void __stdcall TFryers::UpdateBaudrate(void) {
  FRegs.AX = 0x0ffff;     //get Fryers version number
  FRegs.DX = ComPort;
  FRegs.DI = 0;
  CallFryers(&FRegs);
  if (FRegs.DI == 0)
    TrueBaudRate = 9600;
  else TrueBaudRate = 115200 / FRegs.DI;
};
*/

//----------------------------------------------------------
//Open a comport to begin packet communications through
//using the specified baudrate. ComPort is 1-4
//baudrate is 9600, 19200, 38400, 57600, or 115200
//if baud is invalid or 0, the default baudrate of 9600 is selected
//returns true if port is opened.
bool __stdcall TFryers::OpenPacketPort(int IOPort) {

  PortOpen = false;
  if (IOPort < 1) IOPort = 1;
  if (IOPort > 15) IOPort = 1;
  ComPort = IOPort-1; //comport is the defined io port in 32bit mode

  FVersion = 0;
  Regs.AX = 0x0ffff;     //get Fryers version number
  Regs.DX = ComPort;
  CallFryers(&Regs);
  PacketError = NO_FRYERS;     //assume fryers not installed
  if (((Regs.DX & 0x0ffff) != 0x0ffff) || (Regs.AX < 50))
    return(false); //Win32 needs V5.00 or above
  Regs.BX = 0;
  Regs.SI = 0;
  Regs.DI = 0;
  Regs.AX = 0x0fffe;
  Regs.DX = ComPort;
  CallFryers(&Regs);
  FVersion = Regs.BX;

  Regs.AX = 0x0ff00;     //disable fryers interrupt procedure
  Regs.CX = 0x0ff00;     //this makes sure everything is kosher
  Regs.DX = ComPort;
  CallFryers(&Regs);

  Regs.AX = 0x0ff00;     //enable fryers interrupt procedure
  Regs.CX = 0x0ffff;
  Regs.DX = ComPort;
  CallFryers(&Regs);

  switch(Baudrate / 10) {
    case   960: Regs.AX = 0x00e3; //init to selected baudrate
                break;
    case  1920: Regs.AX = 0x0003; //no parity, and one stop bit
                break;
    case  2880: Regs.AX = 0x0023;
                break;
    case  3840: Regs.AX = 0x0043;
                break;
    case  5760: Regs.AX = 0x0063;
                break;
    case 11520: Regs.AX = 0x0083;
                break;
    default:    Regs.AX = 0x00e3; //default to 9600 if bad value given
  }//endswitch(Baudrate)
  Regs.DX = ComPort;   //init port baudrate
  CallFryers(&Regs);

  Regs.AX = 0x0ff10;     //enable fryers packet protocol
  Regs.CX = 0x0ffff;
  Regs.DX = ComPort;
  CallFryers(&Regs);

  Regs.AX = 0x0ff17;     //Get poll timer info
  Regs.CX = 0x0400;
  Regs.BX = 0;
  Regs.DX = ComPort;
  CallFryers(&Regs);
//  PacketTickMultMS = Regs.AX;   //note: these will normally be
//  PacketTickTimeMS = Regs.BX;   //      the same in 32 bit mode

  Regs.AX = 0x0ff17;     //set poll timer
  Regs.CX = 0x00ff;
  Regs.BX = DEFAULT_POLL_TIME; //default poll timeout = 5.5 sec
  Regs.DX = ComPort;
  CallFryers(&Regs);
  //RealPollTime = Regs.BX;

  Regs.AX = 0x0ff17;     //set response timer
  Regs.CX = 0x01ff;
  Regs.BX = DEFAULT_RSP_TIME; //20; //1.1 second
  Regs.DX = ComPort;
  CallFryers(&Regs);

  Regs.AX = 0x0ff17;     //set rcv timer
  Regs.CX = 0x02ff;
  Regs.BX = DEFAULT_RCV_TIME; //20; //1.1 second
  Regs.DX = ComPort;
  CallFryers(&Regs);

  //UpdateBaudrate();
  PacketError = SUCCESS;   //No error, so clear PacketError
//  if ((PacketStatus() & 0x01) == 0)
//    PacketError := BadFryers;
//    Exit;
//  }
  PortOpen = true;
  return(true);
};

//Close the specified packet communications com port
void __stdcall TFryers::ClosePacketPort(void) {
  Regs.AX = 0x0ff10;     //disable fryers packet protocol
  Regs.CX = 0x0ff00;
  Regs.DX = ComPort;
  CallFryers(&Regs);

  Regs.AX = 0x0ff00;     //disable fryers interrupt procedure
  Regs.CX = 0x0ff00;
  Regs.DX = ComPort;
  CallFryers(&Regs);

  PortOpen = false;
};

void TFryers::Constructor(void) {
  PortOpen = false;
};

// Example call to return Fryers version number
int GetFryersVersion(void) {
 F_RegsType R;
  if (FryersLibHandle == NULL)
    if (!LoadFryers()) return(-1);
  R.AX = 0xFFFF;
  R.DX = 0;
  R.CX = 0;
  CallFryers(&R);
  if ((R.DX & 0xFFFF) != 0xFFFF)
    R.AL = 0;
  return(R.AL);
}

