#define fryersH
#ifdef fryersH
#pragma -a1

//register structure to use with Fryers
//Note: these are 32 bit values,
//*NOT* 16bit as with the 16 bit version of Fryers
//* WARNING* You *MUST* compile this with BYTE alignment.
//  failure to use byte alignment will cause all sorts of problems.
struct F_RegsType { union { struct { int EAX;
			             int EBX;
			             int ECX;
			             int EDX;
			             int EDI;
			             int ESI; };
		            struct { unsigned char AL;
			             unsigned char AH;
			             unsigned char EAL;
			             unsigned char EAH;
			             unsigned char BL;
			             unsigned char BH;
			             unsigned char EBL;
			             unsigned char EBH;
			             unsigned char CL;
			             unsigned char CH;
			             unsigned char ECL;
			             unsigned char ECH;
			             unsigned char DL;
			             unsigned char DH;
			             unsigned char EDL;
			             unsigned char EDH;
			             int RDI;
			             int RSI; };
		            struct { int AX;
			             int BX;
			             int CX;
			             int DX;
			             int DI;
			             int SI; };
		          };
                  };

typedef void __stdcall (*tCallFryers)(F_RegsType* Freg);
extern bool __stdcall LoadFryers(void);
extern bool __stdcall ReleaseFryers(void);
extern bool __stdcall FryersLoaded(void);
extern HINSTANCE FryersLibHandle;
extern tCallFryers CallFryers;

#define MAX_SEND_SIZE 2100    //max size of send buffer
#define MAX_RCV_SIZE 2100     //max size of receive buffer

class TFryers {
  private:
    void Constructor(void);
  public:
    bool __stdcall OpenPacketPort(int ComPort);
    void __stdcall ClosePacketPort(void);

  F_RegsType Regs;
  bool PortOpen;
  int FVersion;
  int ComPort;
  int Baudrate;
  int PacketError;
  short int SendData[MAX_SEND_SIZE];
  short int RcvData[MAX_RCV_SIZE];
};

#endif
