// BCURVE   writen by Michael Day - 06/22/00 }
// Copyright 1987,2000 Frye Electronics, Inc. }
// Sample C++ Builder V1.0 program to show usage of the }
// Frye Instrument Packet Protocol interface program - FRYERS32.DLL}
// This version is for borland C++ Builder V1.0 and above for Windows}
// NOTE - you *must* have the Fryers32.DLL loaded either in the}
// Windows directory, or the directory where this program is}
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "FryersC.h"
#include "BcUnit.h"
#include "BcForm.h"
#include "MMSystem.h"
#include "Stdlib.h"
#include "mem.h"

//---------------------------------------------------------------------------

int SerialPort = 1;   //serial port to use - 1,2,3 or 4
TFryers FryersObj;     //declare the Fryers object for this port

bool Paws = false;
bool IamBusy = false;
bool IamRunning = false;
bool ReadResponse = false;
bool SendResult = false;
bool RspResult = false;
bool Quick = false;
int  FryersBaudrate = 9600;
char FryersVersionString[255] = "Fryers";
char BaudrateString[40] = "9600";

TColor TextColor = clLime;  //{text color}
TColor BoxColor = clAqua;  //{box color}
TColor CrvColor = clYellow;  //{curve color}
TColor BackColor = clBlack;  //{background color}
TColor ForeColor = clWhite;  //{foreGround color}
//int cltype  = 0;  //{0=dot/x, 1=x&y, 2=x&y smoothed}

//{this plots the vertices to draw the graph with}
int Xtab[80] = {
            0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228};

#define INVALID_DATA -32768
INT16 SendData[F_MAX_DATA_SIZE+1];  //Command array
INT16 RcvData[F_MAX_DATA_SIZE+1];    //Response array
INT16 DispData[101];              //Data for graph
INT16 OldData[101];               //Previous graph data (for undraw)

int ts;
int Scale,Poff;
int Rax,Rbx,Rcx,Rdx;

bool Debug = false;
bool GotError = false;
char Hex[16] = {"0123456789ABCDEF"};
char PStr[255];

//{Poff = offset used to plot starting at bottom of box}
//{Scale = used to print numbers on left of box}

//void Pause(int Duration) {
//  int t1 = timeGetTime();
//  while (((int)(timeGetTime())-t1) < Duration) {};
//};

//{----------------------------------------------------}
//{convert a byte to hex}
char* HexString(BYTE Byt, char* Str) {
  Str[0] = Hex[Byt >> 4];
  Str[1] = Hex[Byt & 15];
  Str[2] = 0;
  return(Str);
};

//{convert a word to hex}
char* HexWord(WORD Wrd, char* Str) {
  Str[0] = Hex[(Wrd >> 12) & 0xf];
  Str[1] = Hex[(Wrd >> 8) & 0xf];
  Str[2] = Hex[(Wrd >> 4) & 0xf];
  Str[3] = Hex[Wrd & 0xf];
  Str[4] = 0;
  return(Str);
};

void xsWrite(int x, int y, int Val, BYTE Len, TColor Color) {
  int k;
  char Str[20];
  itoa(Val,Str,10);
  k = strlen(Str);
  while (k < Len) {
    Str[k] = ' ';
    k++;
  }
  Str[k] = 0;
  xyWrite(x,y,Str,0,Color);
};

//{-----------------------------------------------------------------}
//{this displays debug informaton while waiting for response}

void ShowStatus(void) {
  char Str[20];
   if (Debug == true) {
     xyWrite(34,19,"STATUS",0,TextColor);
     xyWrite(34,20,"AX:",HexWord((WORD)Rax,Str),TextColor);
     xyWrite(34,21,"BX:",HexWord((WORD)Rbx,Str),TextColor);
     xyWrite(34,22,"CX:",HexWord((WORD)Rcx,Str),TextColor);
     xyWrite(34,23,"DX:",HexWord((WORD)Rdx,Str),TextColor);

     if (((WORD)FryersObj.Regs.AX & 0x0040) != 0) {
       xyWrite(6,2,"NO POLL",0,TextColor);
       GotError = true;
     }else{
       if (((WORD)FryersObj.Regs.AX & 0x0ff9c) != 0) {
         xyWrite(6,2,"ERROR  ",0,TextColor);
         GotError = true;
       }
     }
   }
};


//{-----------------------------------------------------------------------}
//{ This procedure enables the RS232 port1 for use with the software. }

bool InitRS232(void) {
  bool Result;
  int Size,i,tmp;
  char s[20];
  char st[20];

  Result = FryersObj.OpenPacketPort(SerialPort, FryersBaudrate, true, false);
  if (Result == false) {
    ShowMessage("Cannot run program, FRYERS not loaded");
    return(false);
  }

  tmp = FryersObj.FVersion;
  itoa(tmp / 100,s,10);
  strcpy(FryersVersionString,"Fryers Version ");
  strcat(FryersVersionString,s);
  strcat(FryersVersionString,".");
  tmp = tmp % 100;
  itoa(tmp,st,10);
  if (strlen(st) == 1) {
    strcat(FryersVersionString,"0");
    strcat(FryersVersionString,st);
  }else{
    strcat(FryersVersionString,st);
  }
  if (FryersObj.FVersion > 400) {
    FryersVersionString[0] = 0;
    FryersObj.Regs.AX = (int)(0x0FFFD);
    FryersObj.Regs.DX = FryersObj.ComPort;
    FryersObj.Regs.CX = 0;
    CallFryers(&FryersObj.Regs);
    Size = FryersObj.Regs.AX;
    if (Size < 255) {
      for (i=1; i<=Size; i++) {
        FryersObj.Regs.AX = (int)(0x0FFFD);
        FryersObj.Regs.DX = FryersObj.ComPort;
        FryersObj.Regs.CX = i;
        CallFryers(&FryersObj.Regs);
        st[0] = char(FryersObj.Regs.AL);
        st[1] = 0;
        strcat(FryersVersionString,st);
      }
    }
  }
  return(true);
};

//----------------------------------
void CloseRS232(void) {
  FryersObj.ClosePacketPort();
  IamBusy = false;
};

//----------------------------------------------------
//Get the current baudrate in use
//returns true if currently seeking new baudrate
bool GetBaudrate(void) {
  bool BaudOK;
  Quick = FryersObj.CheckQT();
  if (FryersObj.GetCurrentBaudrate() > 100) {
    itoa(FryersObj.Baudrate,BaudrateString,10);
    FryersBaudrate = FryersObj.Baudrate;
    BaudOK = true;
  }else{
    strcpy(BaudrateString," (Baudrate Unknown)");
    BaudOK = false;
  }
  if (FryersObj.BaudSeek == true)
    strcat(BaudrateString," (Seeking)");
  else if (BaudOK == true) {
    strcat(BaudrateString," Baud");
    if (Quick == true)
      strcat(BaudrateString," Quick");
  }
  return(FryersObj.BaudSeek);
};

//--------------------------------------------------------
void DebugMonitor(void) {
  Rax = FryersObj.Regs.AX;
  Rbx = FryersObj.Regs.BX;
  Rcx = FryersObj.Regs.CX;
  Rdx = FryersObj.Regs.DX;
  ShowStatus();
  //if (FryersObj.BaudSeek == true) {
    GetBaudrate();
    Form1->BaudrateLabel->Caption = BaudrateString;
  //}
};

//--------------------------------------------------------
//Sends a cmd to target via Fryers}
bool SendCmd(INT16 scmd, INT16 scnt, INT16 sdat) {
  if (FryersObj.SendReady() == false) return(false);
  SendData[0] = scmd;
  SendData[1] = scnt;
  SendData[2] = sdat;
  return(FryersObj.SendCmd(SendData,0)); //DebugMonitor));
};

//---------------------------------------------------------
//Gets a response packet of integers from the rs232 port1.
bool GetRsp(void) {
  int i;                             //DebugMonitor
  if (FryersObj.GetResponse(RcvData,0) == false) return(false);
  GotError = false;
  for (i=0; i<=100; i++)
    DispData[i] = RcvData[i]; //{ convert rsp to plot format}
  return(true);
};

//---------------------------------------------------------
//release instrument from comm mode
bool QuickTerm(void) {
  return(FryersObj.QuickTerminate(0));
};

//--------------------------------------------
//plot a line on screen, clip to only within box
void DoDraw(int x1, int y1, int x2, int y2, TColor color, int cltype)
{
    int x;
    int y;
    int xstep;
    int ystep;
    int deltax;
    int deltay;
    int direction;

    if (y1 > 185) y1 = 185;    // clip to boundry
    if (y1 < 1) y1 = 1;
    if (y2 > 185) y2 = 185;
    if (y2 < 1) y2 = 1;

    x = x1;
    y = y1;

    if (x1 == x2) xstep = 0;
    else
      if (x1 > x2) xstep = -1;
      else
        xstep = 1;

    if (y1 == y2) ystep = 0;
    else
      if (y1 > y2) ystep = -1;
      else
        ystep = 1;

    deltax = abs(x2 - x1);
    deltay = abs(y2 - y1);
    if (deltax == 0) direction = -1;
    else
      direction = 0;

    Plot(x,y,color);
    do
    {
      if (direction < 0)
      {
        y = y + ystep;
        direction = direction + deltax;
        if ((direction >= 0) || (cltype > 0)) Plot(x, y, color);
      }
      else
      {
        x = x + xstep;
        direction = direction - deltay;
        if ((direction >= 0) || (cltype > 1)) Plot(x, y, color);
      }
    }
    while (!(( x == x2 ) && ( y == y2 )));
}

//----------------------------------------------------
//draw the fixed stuff of the screen

void DoBox(void) {
  int i;
  DoDraw(30,186,262,186,BoxColor,1);
  DoDraw(262,186,262,0,BoxColor,1);
  DoDraw(262,0,30,0,BoxColor,1);
  DoDraw(30,0,30,186,BoxColor,1);

  for (i=1; i<=18; i++) {
    DoDraw(25+1,(i*10),29,(i*10),BoxColor,1);
  }

  for (i=1; i<=19; i++) {
    DoDraw((i*12)+31,187,(i*12)+31,190,BoxColor,1);
  }

  xyWrite(5,25,".12",0,TextColor);
  xyWrite(9,25,".25",0,TextColor);
  xyWrite(14,25,".5",0,TextColor);
  xyWrite(19,25,"1",0,TextColor);
  xyWrite(24,25,"2",0,TextColor);
  xyWrite(28,25,"4",0,TextColor);
  xyWrite(33,25,"8",0,TextColor);

  xyWrite(34,1,"SOURCE",0,TextColor);
  xyWrite(34,4,"RMS OUT",0,TextColor);
  xyWrite(34,7,"TOP SPL",0,TextColor);
  xyWrite(34,10,"N.R.",0,TextColor);
  xyWrite(34,13,"FLAGS",0,TextColor);
};

//------------------------------------------------------
//update the numbers for the curve

void MiscInfo(void) {
  char s[20];
  xyWrite(34,2,"      ",0,TextColor); //{src}
  if (DispData[7] == 0) {
    xyWrite(34,2,"OFF",0,TextColor);
  }else{
    itoa(DispData[7],s,10);
    xyWrite(34,2,s,0,TextColor);
  }
  xyWrite(34,5,"      ",0,TextColor);
  itoa(DispData[9],s,10);
  xyWrite(34,5,s,0,TextColor);//{rms out}

  xyWrite(34,8,"      ",0,TextColor);
  itoa(DispData[8],s,10);
  xyWrite(34,8,s,0,TextColor); //{top val}

  xyWrite(34,11,"      ",0,TextColor);    //{noise reduction}
  if (DispData[10] == 0) {
    xyWrite(34,11,"OFF",0,TextColor);
  }else{
    itoa(DispData[10],s,10);
    xyWrite(34,11,s,0,TextColor);
  }
  xyWrite(34,14,"      ",0,TextColor);
  HexWord(DispData[3],s);
  xyWrite(34,14,s,0,TextColor); //{flags a}

  xyWrite(34,15,"      ",0,TextColor); //{flags b}
  itoa(DispData[4],s,10);
  xyWrite(34,15,s,0,TextColor);
};

//{-------------------------}
//{figure out what the scale is and show it on the graph}

void FindScale(void) {
  ts = (DispData[8] / 100);
  Scale = (ts / 20)*20 + 20;
  Poff = (Scale*2)+10;

  if (GotError == false) {
    if (FryersObj.BaudSeek == true) {
      xyWrite(6,2,"BAUDSEEK",0,TextColor); //{unexpected response}
    }else if ((DispData[0] & 0x4000) != 0) {
      xyWrite(6,2,"BAD RSP",0,TextColor); //{unexpected response}
    }else{
      if (DispData[3] == 0x0400) {
        xyWrite(6,2,"INVALID",0,TextColor);  //{bad curve}
      }else{
        if ((DispData[3] & 0x4000) == 0) {
          xyWrite(6,2,"dBSPL  ",0,TextColor); //{power curve}
        }else{
          xyWrite(6,2,"GAIN   ",0,TextColor);  //{none of the above, so must be gain}
        }
      }
    }
  }//endif(GotError)

  xsWrite(1,2,Scale+00,3,TextColor);
  xsWrite(1,7,Scale-20,3,TextColor);
  xsWrite(1,12,Scale-40,3,TextColor);
  xsWrite(1,17,Scale-60,3,TextColor);
  xsWrite(1,22,Scale-80,3,TextColor);
};

//{-------------------------}
int GetPoint(int i) {
  int k = i;
  while ((DispData[k] == INVALID_DATA) && (k < 79)) {
    k++;
  }
  return(DispData[k]);
};

void DispCurve(void) {
  int da,db,xa,xb,ya,yb,x,i;
  int lm = 32;  //{left margin on graph}

  i = 11; //{start with 100hz plot}
  x = 0;
  while ((DispData[i] == INVALID_DATA) & (i < 79)) {
    i++;
    x++;
  }
  do {
    da = GetPoint(i);
    db = GetPoint(i+1);
    if (da != INVALID_DATA)
      da = Poff - (da / 50);
    if (db != INVALID_DATA)
      db = Poff - (db / 50);
//    if (da < 0)
//      dd = da;

    ya = OldData[i];
    yb = OldData[i+1];
    OldData[i] = (INT16)da;
    xa = Xtab[x]+lm;
    xb = Xtab[x+1]+lm;
    i = i + 1;
    x = x + 1;
    if (xa == xb) {  //{ skip next when xa = xb }
      i = i + 1;
      x = x + 1;
    }
    if ((xa != INVALID_DATA) && (xb != INVALID_DATA))
      DoDraw(xa,ya,xb,yb,BackColor,0); //{undraw}
    if ((da != INVALID_DATA) && (db != INVALID_DATA))
      DoDraw(xa,da,xb,db,CrvColor,0); //{draw new one}
  }while(x <= 78);
  OldData[i] = (INT16)db;
  MiscInfo();
};


//{--------------------------------------------}
//{set the arrays at start up to a known value}

void ClrArys(void) {
  setmem(DispData,sizeof(DispData),0);
  setmem(OldData,sizeof(OldData),0);
  setmem(RcvData,sizeof(RcvData),0);
};

//{-----------------------------------------------}
//{main program starts here}

bool StartMeUp(void) {
  Debug = true;
  if (InitRS232() == false) return(false);
  StartGraph();
  Scale = 120;
  ClrArys();
  FryersObj.AutoQT(true); //turn on autoQT
  Quick = FryersObj.CheckQT();
  return(true);
};

//---------------------------------------------------
//do a run on the Fonix instrument
bool DoMe(void) {
  IamBusy = true;
//  Quick = FryersObj.CheckQT();
  if (Quick == false)
    FryersObj.AutoQT(true); //turn on autoQT if it got turned off

  DoBox();       // {put the fixed stuff on the screen}
  if (ReadResponse == true) {
    RspResult = GetRsp(); //{get the response}
    if (RspResult == true) {
      ReadResponse = false;
      QuickTerm();   //let instrument out of comm mode so it can get another curve
    }
  }
  FryersObj.PacketStatus();
  DebugMonitor();
  if (FryersObj.SendReady() == true) {
    if (Paws == false)
      SendResult = SendCmd(25,1,0);  //{ask for curve 0}
    if (SendResult == true) {
      ReadResponse = true;
    }
  }
  FindScale();            //{figure out scaling and errors}
  if (RspResult == true) {
    DispCurve();   //{now show the curve}
  }
  IamBusy = false;
  return(true);
};


