

;CURVE.ASM  writen by Michael Day - 11/06/87  updated 06/30/89
;Copyright 1987,1989 Frye Electronics, Inc.
;Sample Assembler program to show usage of the               
;Frye Instrument Packet Protocol interface program - FRYERS.COM 
; NOTE - you *must* have the latest version (1987 or later) 
; of FRYERS.COM loaded in the computer to use this program  
;program derived from Turbo Pascal version 
;development time - 20 hours 


	org 100h

start:
	cli
	mov ax,cs	;init segment regs
	mov es,ax
	mov ds,ax
	mov ss,ax
	lea sp,[stack]
	sti
	jmp main

true	equ 0ffffh
false	equ 0

debug	equ true;  show debug info
palette	equ 0	;  {CGA palette to use 0=rgy 1=brw}
tcolor  equ 3	;  {text color}
bcolor  equ 2	;  {box color}
ccolor  equ 1	;  {curve color}
black   equ 0	;  {background color}
comport equ 0	;  {COM port to use - 0 or 1 }
cltype	equ 0	;  curve type 0=dot/x 1=x&y 2=x&y smooth

;this plots the vertices to draw the graph with
xtab    DW    0, 36, 57, 72, 84, 93,102,108,114,120
        DW  125,129,134,137,141,144,148,151,153,156
        DW  159,161,163,165,168,170,172,173,175,177
        DW  179,180,182,184,185,187,188,189,191,192
        DW  193,195,196,197,198,199,200,202,203,204
        DW  205,206,207,208,209,210,210,211,212,213
        DW  214,215,216,216,217,218,219,219,220,221
        DW  222,222,223,224,225,225,226,227,227,228

ts      DW 120
scale   DW 120
poff    DW 250 
regax	DW 0
regbx	DW 0
regcx	DW 0
regdx	DW 0
regdi	DW 0
regsi	DW 0
temp	DW 0
x	DW 0
i	DW 0
da	DW 0
db	DW 0
drawc	DW 0
x1	DW 0
y1	DW 0
x2	DW 0
y2	DW 0
xstep	DW 0
ystep	DW 0


;poff = offset used to plot starting at bottom of box
;scale = used to print numbers on left of box

;{----------------------------------------------------}
;{convert a word to hex and print it}

hexword:
	push ax
	mov al,ah
	call hexbyte	;convert the upper byte
	pop ax
	push ax
	call hexbyte	;convert the lower byte
	pop ax
	ret
hexbyte:
	push ax
	push cx
	mov cl,4
	shr al,cl
	call hexnible	;convert the upper nibble
	pop cx
	pop ax		;then the lower one
hexnible:
	and al,0fh
	cmp al,0ah	;if 10 or above add 7 to get letters
	jc hexok
	add al,7
hexok:
	add al,30h	;convert to ascii format
	call typer	;and type it out
	ret

;{-----------------------------------------------------------------}
;test to see if key has been hit on keyboard

brkchk:
	push ax
	push bx
	push cx
	push dx
	push si
	push di
	mov ax,0100h	;returns nz if key was pressed
	int 16h
	jnz wexit
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	ret

wait:
	call brkchk	;wait til a key is hit
	jz wait
	push ax
	push bx
	push cx
	push dx
	push si
	push di
	mov ax,0000h
	int 16h
	cmp al,3
	jz wexit
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	ret

wexit:
	mov ax,2	;80x25 bw
	int 10h		;switch back to normal text mode
	int 20h		;and go home
	ret

;{-----------------------------------------------------------------}
;{this displays debug informaton while waiting for response}

showregs:
	mov [regax],ax	;save registers
	mov [regbx],bx
	mov [regcx],cx
	mov [regdx],dx 
	mov [regdi],di
	mov [regsi],si

	push ax
	push bx
	push cx
	push dx
	push si
	push di

   if debug 		;only do this if debug on

	call gotoxy	;write status heading to screen
	DB 34,19
	call write
	DB "STATUS",0

	call gotoxy	;show register AX
	DB 34,20
	call write 
	DB "AX:",0
	mov ax,[regax]
	call hexword

	call gotoxy	;show register BX
	DB 34,21
	call write
	DB "BX:",0
	mov ax,[regbx]
	call hexword

	call gotoxy	;show register CX
	DB 34,22
	call write
	DB "CX:",0
	mov ax,[regcx]
	call hexword

	call gotoxy	;show register dx
	DB 34,23
	call write
	DB "DX:",0
	mov ax,[regdx]
	call hexword

;*	call gotoxy	;show register di
;*	DB 34,24
;*	call write
;*	DB "DI:",0
;*	mov ax,[regdi]
;*	call hexword
;*
;*	call gotoxy	;show register si
;*	DB 34,25
;*	call write
;*	DB "SI:",0
;*	mov ax,[regsi]
;*	call hexword

	call gotoxy	;also show io status if there is a problem
	DB 6,2

	mov ax,[regax]
	and ax,0040h	;no poll beeing received
	jnz nopoll

	mov ax,[regax]
	and ax,0ff9ch	;response error
	jnz rsperr

     endif

statext:
	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	ret		;go home

nopoll:
	call write
	DB "NO POLL",0
	jmp statext

rsperr:
	call write 
	DB "ERROR  ",0
	jmp statext


;{-----------------------------------------------------------------------}
;{ set screen to graphic mode}

initgraph:
	mov ax,0004h	;select 40x25 color graphics
;*	mov ax,010h	;(10h = ega mode)
	int 10h

	mov ax,0b00h	;set background color
	mov bh,00h
	mov bl,black
	int 10h

	mov ax,0b00h	;select palette
	mov bh,01h
	mov bl,palette
	int 10h

	ret

;{-----------------------------------------------------------------------}
;{ This procedure enables the RS232 port1 for use with the software. }

InitRS232:
;	mov bx,14h	; check if fryers driver is loaded
;	add bx,bx
;	add bx,bx
;	xor ax,ax       ; * don't use this method anymore *
;	mov es,ax
;	seg es
;	les bx,[bx]
;	sub bx,16
;	mov al,'F'
;	seg es
;	cmp al,[bx]
;	jnz nofrys

        mov dx,0  	; check if fryers driver is loaded
        mov ax,0ffffh
        int 14h
        cmp dx,0ffffh
        jnz nofrys

	mov ax,0ff00h	; {disable fryers interrupt procedure}
	mov cx,0ff00h	; {this makes sure everything is kosher}
	mov dx,comport	
	int 14h

	mov ax,0ff00h	; {enable fryers interrupt procedure}
	mov cx,0ffffh 
	mov dx,comport
	int 14h
	mov ax,0ff10h	; {enable fryers packet protocol}
	mov cx,0ffffh
	mov dx,comport
	int 14h
	mov ax,0ffffh	; {check on the version number}
	mov dx,comport	
	int 14h
	cmp al,21h	; {if 21h or above we can do autobaud}
	jc notnew
	mov ax,00f3h	; {init to 9600 baud, no parity, 8 data bits}
	mov dx,comport  ; {using autobaud}
	int 14h
	jmp contrs
notnew:
	mov ax,00e3h	; {init to 9600 baud, no parity, 8 data bits}
	mov dx,comport  ; {but no autobaud}
	int 14h
contrs:
	ret

nofrys:
	mov ax,2	;80x25 bw
	int 10h		;switch back to normal text mode
	push cs
	pop ds
	mov dx,nofmsg	;no fryers loaded, so show msg
	mov ah,9
	int 21h
	int 20h

nofmsg	db 13,10,'Cannot run program, FRYERS.COM not loaded',13,10,'$'


closeRS232:
	mov ax,0ff00h	; {disable fryers interrupt procedure}
	mov cx,0ff00h	; {this makes sure everything is kosher}
	mov dx,comport	
	int 14h
        ret

;{-----------------------------------------------------------------------}
;{ waits for int14 to be ready to accept send cmd}

sendwait:
	call brkchk	;check if ^C struck (break exit)

	mov ax,0ff13h	;otherwise wait for send to be ready
	mov dx,comport
	int 14h
	and ax,0001h
	jz sendwait
	ret

;{-----------------------------------------------------------------------}
;{ sends a cmd to target via the rs232 port}

sendcmd:
	call sendwait	;wait for send to be ready
	mov dx,comport 	;then send the command
	lea bx,[sary]	;our ds is passed direct
	mov ax,0ff11h
	int 14h
	ret

;{-----------------------------------------------------------------------}
;{ waits for response from target}

rspwait:
	call brkchk	;check if ^C struck (break exit)

	mov ax,0ff13h
	mov dx,comport	;wait till we get a response
	int 14h
	call showregs	;show the status registers
	and ax,00001h
	jz rspwait
	ret

;{-----------------------------------------------------------------------}
;{ gets a response packet of integers from the rs232 port1. }

getresponse
	call rspwait	;wait until a response is received
	mov dx,comport	;now copy the response into our own array
	lea bx,[pary1]	;our ds is passed direct
	mov ax,0ff12h
	int 14h
	ret


;{----------------------------------------------------------------}
; move cursor to requested position

gotoxy:
	mov [temp],bx	;save bx
	pop bx		;get instruction pointer
	push dx
	push cx		;save our world
	push ax
	push si
	push di

	mov dx,[bx]	;get the x,y data following command 
	add bx,2	;point to next instruction
	push bx		;save it
	dec dl
	dec dh
	mov ax,0200h	;move the cursor
	mov bx,0
	int 10h
	pop bx		;restore things

	pop di
	pop si
	pop ax
	pop cx
	pop dx
	push bx		;push the return address back on stack
	mov bx,[temp]	;restore register bx
	ret

;{----------------------------------------------------------------}
; display the text following the call to here

write:
	mov [temp],bx	;save bx
	pop bx		;get instruction pointer
	push ax

writelp:
	mov al,[bx]	;get the character following command 
	inc bx		;point to next byte
	cmp al,0
	jz writex	;type out till get null
	call typer
	jmp writelp	;loop til done

writex:
	pop ax
	push bx		;push the return address back on stack
	mov bx,[temp]	;restore register bx
	ret

;{----------------------------------------------------------------}
;display the value in ax on the screen

axwrite:
	push si
	push di
	push ax
	push bx
	push cx
	push dx
	xor di,di
	mov bx,ax
	or bx,bx
	jns posnum
	mov al,"-"	;print minus if neg number
	call typer	;then negate to print as positive
	neg bx

posnum:
	mov cx,10000
	call dhlde
	jz axw1
	call bcdot
axw1:
	mov cx,1000
	call dhlde
	jz axw2
	call bcdot
axw2:
	mov cx,100
	call dhlde
	jz axw3
	call bcdot
axw3:
	mov cx,10
	call dhlde
	jz axw4
	call bcdot
axw4:
	mov al,bl
	call bcdot

	pop dx
	pop cx
	pop bx
	pop ax
	pop di
	pop si
	ret


;--- display the value in al ----

bcdot:
	add al,48
	call typer
	ret


;------ 8 bit divide ---------
;enter with number to divide in bx
;and divisor in cx. exits with dividend
;in ax, and remainder in bx.
;at the beginning of the divide sequence
;set di to zero. As long as a zero result
;occurs from the divide it will return a 
;zero condition. When the first non-zero
;divide occurs a non-zero condition will 
;be returned until di is set to zero again.
;(used for leading zero suppression.)
;(set di to -1 if zero supression not wanted.)

dhlde:
	mov ax,bx	;set up for the divide
	mov dx,0
	call doidiv	;do a signed divide
	mov bx,dx	;copy remainder to bx
	cmp ax,di	;check on zero supression
	jz zerdiv
	dec di		;ret non-zero if no supression
zerdiv:
	ret


;--------- 16 bit divide ------------
;divisor is expected to be in cx
;and signed number to divide in ax
;returns number in ax with remainder in dx

doidiv:
	mov dx,0		;for this curve
	or ax,ax
	jns dopdiv
	dec dx
dopdiv:
	idiv ax,cx
	ret

;{---------------------------------------------------}
;print char in al on screen 

typer:
	push si
	push di
	push ax		;save regs
	push bx
	push cx
	push dx
	mov ah,14	;move the cursor
	mov bh,0
	mov bl,tcolor	;text color
	int 10h		;tty char out of char in al
	pop dx
	pop cx
	pop bx		;restore things
	pop ax
	pop di
	pop si 
	ret

;{------------------------------------------}
;special write formated to print scale numbers
;at left of graph. no more then three digits
;allowed for positive numbers, or two and minus
;sign for negative numbers.
;scaling will never be greater than 999 or
;less than -99.

swrite:
	push si
	push di
	push ax
	push bx
	push cx
	push dx
	xor di,di

	mov bx,ax
	or bx,bx	;check if negative number
	jns saxw1 	;no, so do it as positive

	neg bx		;make the number positive now
	mov al,"-"
	call typer	;print minus sign
	jmp saxw3a

saxw1:
	mov cx,100
	call dhlde
	jnz saxw3
	mov al," "	;if no hundreds print a space
	call typer
	jmp saxw3a
saxw3:
	call bcdot
saxw3a:
	mov cx,10
	call dhlde
	jnz saxw4
	mov al," "	;if no tens print space
	call typer
	jmp saxw4a
saxw4:
	call bcdot
saxw4a:
	mov al,bl	;always print units
	call bcdot

saxwext:
	pop dx
	pop cx
	pop bx
	pop ax
	pop di
	pop si
	ret


;{----------------------------------------------------------------}
;{draw the fixed stuff of the screen}

dobox:
	mov ax,bcolor		;set box color
	mov [drawc],ax

	mov ax,30	;x1	;draw the box
	mov bx,186	;y1
	mov cx,262	;x2
	mov dx,186	;y2
	call ldraw

	mov ax,262	;x1
	mov bx,186	;y1
	mov cx,262	;x2
	mov dx,0	;y2
	call ldraw

	mov ax,262	;x1
	mov bx,0	;y1
	mov cx,30	;x2
	mov dx,0	;y2
	call ldraw

	mov ax,30	;x1
	mov bx,0	;y1
	mov cx,30	;x2
	mov dx,186	;y2
	call ldraw

	mov bx,0
	mov dx,0
dobox3:
	mov ax,25	;x1	;do tick marks
	add bx,10	;y1
	mov cx,29	;x2
	add dx,10	;y2
	call ldraw
	cmp bx,180
	jc dobox3

	mov ax,31
	mov cx,31
dobox4:
	add ax,12	;x1	;do more tick marks
	mov bx,187	;y1
	add cx,12	;x2
	mov dx,190	;y2
	call ldraw
	cmp cx,252
	jc dobox4

	call gotoxy	;write frequency numbers
	DB 5,25		;along bottom of box
	call write
;**     0        1         2         3         
;**     123456789012345678901234567890123456789
	DB ".12 .25  .5   1    2   4    8",0

	call gotoxy	;write labels to the right of the box
	DB 34,1
	call write
	DB "SOURCE",0
	call gotoxy
	DB 34,4
	call write
	DB "RMS OUT",0
	call gotoxy
	DB 34,7
	call write
	DB "TOP VAL",0
	call gotoxy
	DB 34,10
	call write
	DB "N.R.",0
	call gotoxy
	DB 34,13
	call write
	DB "FLAGS",0
	ret

;{------------------------------------------------------}
;{update the numbers for the curve}

flagsa	equ 3*2		;curve flags a
flagsb	equ 4*2		;curve flags b
sflagsa	equ 5*2		;spare flags a
sflagsb	equ 6*2		;spare flags b
source	equ 7*2		;source amplitude
topval	equ 8*2		;top value in curve frame
rmsout	equ 9*2		;rms out
nred	equ 10*2	;noise reduction

miscinfo:
	call gotoxy
	DB 34,2
	call write
	DB "      ",0	;clear old data
	call gotoxy
	DB 34,2		; {source}
	lea si,[pary1+source]
	mov ax,[si]
	cmp ax,0
	jz mscsrcof		;if 0 show as "off"
	call axwrite	;else show value
	jmp mscsrcex
mscsrcof:
	call write
	DB "OFF",0
mscsrcex:

	call gotoxy
	DB 34,5
	call write
	DB "      ",0	;clear old data
	call gotoxy
	DB 34,5		;   {rms out}
	mov ax,[pary1+rmsout]
	call axwrite

	call gotoxy
	DB 34,8
	call write
	DB "      ",0	;clear old data
	call gotoxy
	DB 34,8		;    {top val}
	mov ax,[pary1+topval]
	call axwrite

	call gotoxy
	DB 34,11
	call write
	DB "      ",0	;clear old data  
	call gotoxy
	DB 34,11	;    {noise reduction}
	cmp w,[pary1+nred],0	;if 0 write "off"
	jz miscnrof
	mov ax,[pary1+nred]	;else show value
	call axwrite
	jmp miscnrex
miscnrof:
	call write
	DB "OFF",0
miscnrex:

	call gotoxy
	DB 34,14
	call write
	DB "      ",0	;clear old data
	call gotoxy
	DB 34,14	;   {flags a}
	mov ax,[pary1+flagsa]
	call hexword

	call gotoxy
	DB 34,15
	call write
	DB "      ",0	;clear old data
	call gotoxy
	DB 34,15	; {flags b}
	mov ax,[pary1+flagsb]
	call hexword
	ret

;{-------------------------}
;{figure out what the scale is and show it on the graph}

findscale:
	mov ax,[pary1+topval]	;calculate new scale
	mov dx,0		;for this curve
	mov cx,100
	call doidiv 
	mov [ts],ax
upscale:
	mov dx,0	;set scale in 20 db increments
	mov cx,20
	call doidiv 
	mul ax,cx
	add ax,20
	cmp ax,0
	jg fswok1 	;limit number to no less than 0
	mov ax,0
fswok1:
	cmp ax,180	;and no more than 180
	jl fswok2
	mov ax,180
fswok2:
	mov [scale],ax

	add ax,ax	;calculate graph offset
	add ax,10
	mov [poff],ax

	call gotoxy
  	DB 6,2
	mov ax,[pary1]
	and ax,4000h
	jnz badrsp		;unknown response 
	mov ax,[pary1+flagsa]
	cmp ax,0400h
	jz invcrv		;bad response 
	and ax,4000h
	jnz gaincrv		;if nz it is a gain curve
	call write
	DB "dBSPL  ",0	; {power curve}
	jmp fscont
gaincrv:
	call write
	DB "GAIN   ",0	; gain curve
	jmp fscont
badrsp:
	call write
	DB "BAD RSP",0	; {unexpected response}
	jmp fscont
invcrv:
	call write
	DB "INVALID",0	;  {bad curve}
fscont:

	call gotoxy
	DB 1,2
	mov ax,[scale]	;display the scale at the left of the graph
	call swrite
	call gotoxy
	DB 1,7
 	mov ax,[scale]
	sub ax,20
	call swrite
	call gotoxy
	DB 1,12
	mov ax,[scale]
	sub ax,40
	call swrite
	call gotoxy
	DB 1,17
 	mov ax,[scale]
	sub ax,60
	call swrite
	call gotoxy
	DB 1,22
	mov ax,[scale]
	sub ax,80
	call swrite
	ret

;{------------------------------------------------------}
;draw a straight line between the indicated points
;ax=x1, bx=y1, cx=x2, dx=y2, draw color=[drawc] 

ldraw:
	push ax
	push bx
	call plot	;x=ax, y=bx
ldrawlp:
	cmp bx,dx
	jnc ldrawlp2	;adj Y if not there
	inc bx
ldrawlp2:
	cmp dx,bx
	jnc ldrawlp3
	dec bx
ldrawlp3:
	cmp ax,cx	;adj X if not there
	jnc ldrawlp4
	inc ax
ldrawlp4:
	cmp cx,ax
	jnc ldrawlp5
	dec ax
ldrawlp5:
	call plot
	cmp ax,cx
	jnz ldrawlp
	cmp bx,dx
	jnz ldrawlp
	pop bx
	pop ax
	ret


;-------------------------------------------------------------
;*	draw a line from (x1, y1) to (x2, y2).
;*	x1 is in ax, y1 is in bx, x2 is in cx, and y2 is in dx.
;*	on return all registers are intact
;*	11/01/87 -mng (68k version)
;-      11/04/87 -med modified for 8086

;*	if starting and ending x values are the same plot a single
;*	point at (x1, y1).

draw:
	call	dxlimit	;limit and save x1, x2 and y1, y2 to memory
	mov	[x1],ax 

	mov	ax,bx
	call	dylimit
	mov 	[y1],ax

	mov	ax,cx
	call	dxlimit 
	mov	[x2],ax

	mov	ax,dx
	call	dylimit 
	mov	[y2],ax  

	mov	bx,[x2]
	sub	bx,[x1]		; are x values both the same
	jz 	lsk1
	dec 	bx		; or if single point spread
	jnz	lsk0
lsk1:
	mov 	ax,[x1]
	mov	bx,[y1]
	call	plot		; if so plot one point at (x1, y1)
	ret
lsk0:

	push 	si 
	push 	di


;*	deal with multiple points that need drawing
;*	NOTE that slope is always maintained as slope * 256 for acuracy
;*	and the scaling down is done at the very last moment possible,
;*	this assures us that errors don't accumulate throughout the y
;*	position calculation.
;entry:
;	ax=x1, bx=y1, cx=x2, dx=y2 
;after setup:
;	ax=y, bx=x, si=vector, dx=temp, di=delta x

	mov	di,[x2]		; copy of x2
	sub	di,[x1]		; (x2 - x1)  (di=delta x)

	xor	dx,dx
	mov	ax,[y2]
	sub	ax,[y1]		; (y2 - y1)  (ax=delta y)
	jns	llidiv		; multiply by 256 to keep acuracy
	dec	dx		; extend dx based on sign for divide
llidiv:
	mov	dl,ah		; (delta y * 256 / delta x)
	mov	ah,al 
	xor	al,al

	idiv	ax,di		; (((y2 - y1) * 256) / (x2 - x1))
	mov	si,ax 		; si = vector  (slope * 256) 
	mov	bx,[x1]		; bx = x

llp0:
	mov	ax,[x2]		; x2
	sub	ax,bx		; (x2 - x3)       ... (bx = x)
	imul	ax,si		; (slope * 256 * (x2 - x3))
	mov	al,ah
	mov	ah,dl		; scale back down (divide by 256)
	sub	ax,[y2]		; (slope * (x2 - x3)) - y2
	neg ax
	xchg	ax,bx 
	call	plot		; finally draw the point
	xchg	ax,bx
	inc	bx		; go for next x value
	dec	di		; use delta x (x2 - x1) as the counter
	jnz	llp0

	pop	di
	pop 	si
	ret



;----------------------------------------------
;plot point on screen defined by bx,ax (x,y) 
;color used is in [drawc]


plot:
	push ax
	push bx
	push cx
	push dx
	push si
	push di

	mov cx,ax	;x
	mov dx,bx	;y
	mov al,[drawc]
	mov ah,12
	mov bx,0
	int 10h

	pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	ret
 

;------------------------------------------------------
;alternate drawing routine
;ax=x1, bx=y1, cx=x2, dx=y2
;
;  if y1 = y2 then ystep = 0 else 
;     if y1 > y2 then ystep = -1 else ystep = 1
;  if x1 = x2 then xstep = 0 else
;     if x1 > x2 then xstep = -1 else ystep = 1
;  deltay = abs(y2-y1)
;  deltax = abs(x2-x1)
;  if deltax = 0 then direction = -1 else direction = 0
;  y = y1
;  x = x1
;loop
;  plot x,y
;  if direction < 0 then 
;    y = y + ystep
;    direction = direction + deltax
;  else
;    x = x + xstep
;    direction = direction - deltay
;  if (x <> x2) and (y <> y2) then goto loop
;

adraw:
	mov [x2],cx	;save x2 and y2
	mov [y2],dx

	mov di,-1	;if x1 = x2 then
	cmp ax,cx	;  xstep = 0
	jz adraw1	;else
	jg adraw2	;  if x1 > x2 then
	inc di		;    xstep = -1
adraw1:	inc di		;  else 
adraw2:	mov [xstep],di	;    xstep = 1

	mov di,-1	;if y1 = y2 then
	cmp bx,dx	;  ystep = 0
	jz adraw3	;else
	jg adraw4	;  if y1 > y2 then
	inc di		;    ystep = -1
adraw3:	inc di		;  else 
adraw4:	mov [ystep],di	;    ystep = 1

	sub dx,bx	;deltay = abs(y2-y1)
	jns adraw6
	neg dx		;dx=deltay
adraw6:
	sub cx,ax	;deltax = abs(x2-x1)
	jns adraw8
	neg cx		;cx=deltax
adraw8:

	mov di,-1	;di = direction
	or cx,cx	;if deltax = 0 
	jz adraw9	;then direction = -1
	xor di,di	;else direction = 0
adraw9:
	mov si,cltype	;get line type
	jmp adrawlx	;plot first point
	
adrawlp:
	or di,di	;if direction < 0 
	jns adrawld
	add bx,[ystep]	;then y = y + ystep
	add di,cx	;     dir = dir + deltax  
	jns adrawlx	; if dir >= 0
	cmp si,1	;   or cltype > 0
	jge adrawlx	; then plot x,y  
	jmp adrawll
adrawld:
	add ax,[xstep]	;else x = x + xstep
	sub di,dx	;     dir = dir - deltay
	jns adrawlx	; if dir >=0 
	cmp si,2	;   or cltype > 1
	jge adrawlx	; then plot x,y
	jmp adrawll
adrawlx:
	call plot	;plot(x,y,color)
adrawll:
	cmp bx,[y2]	;if y <> y2 then goto adrawlp
	jnz adrawlp
	cmp ax,[x2]	;if x <> x2 then goto adrawlp
	jnz adrawlp
	ret


;{-----------------------------------------------------}
;now write the curve onto the screen

lm	equ 32	;  {left dot margin on graph}

dispcurve:
	mov ax,11
	mov [i],ax	; {start with 100hz plot}
	mov ax,0
	mov [x],ax

disprep:
	mov si,[i]
	add si,si
	add si,pary1	;da := poff - (pary1[i] div 50)
	mov ax,[si]
	mov cx,50
	call doidiv 
	mov bx,[poff]
	sub bx,ax
	mov ax,bx	;if da > 185 then da = 185
	call dylimit	;if da < 1 then da = 1
	mov [da],ax

	mov si,[i]
	add si,si
	add si,pary1
	mov ax,[si+2]	;db := poff - (pary1[i+1] div 50)
	mov cx,50
	call doidiv 
	mov bx,[poff]
	sub bx,ax
	mov ax,bx	;if db > 185 then db = 185
	call dylimit	;if db < 1 then db = 1
	mov [db],ax


	mov si,[i]	;bx=pary2[i] : (y1)
	add si,si
	add si,pary2
	mov bx,[si]
	mov dx,[si+2]	;dx=pary2[i+1] : (y2)
	mov ax,[da]
	mov [si],ax	;pary2[i] = [da]

	mov si,[x]	;ax=xtab[x]+lm : (x1)
	add si,si
	add si,xtab
	mov ax,[si]
	add ax,lm
	mov cx,[si+2]	;cx=xtab[x+1]+lm : (x2)
	add cx,lm

	mov si,[x]	;x = x + 1
	inc si
	mov [x],si
	mov si,[i]	;i = i + 1
	inc si
	mov [i],si

	cmp ax,cx	;if ax < cx
	jl disprp2

	mov si,[x]	;x = x + 1
	inc si
	mov [x],si
	mov si,[i]	;i = i + 1
	inc si
	mov [i],si

disprp2:
	mov si,black		;undraw old curve
	mov [drawc],si

	push ax		;save ax and cx now that we have them
	push cx
	call adraw	;undraw old line
	pop cx
	pop ax

	mov si,ccolor	;now draw new line
	mov [drawc],si
	mov bx,[da]	;bx=[da] : (y1)
	mov dx,[db]	;dx=[db] : (y2)
	call adraw

	mov ax,[x]
	cmp ax,78	;if x < 80 then loop
	jnc dispext
	jmp disprep
 
dispext:
	mov bx,[i]	;pary2[i] = [db]
	add bx,bx
	add bx,pary2
	mov ax,[db]
	mov [bx],ax

	call miscinfo	;show the numbers and stuff
	ret

;{-------------------------------}
;clip value in ax to screen y size

dylimit:
	cmp ax,186
	jl dy1ok 
	mov ax,185
dy1ok:
	cmp ax,0
	jg dy2ok
	mov ax,1
dy2ok:
	ret


;{-------------------------------}
;clip value in ax to screen x size

dxlimit:
	cmp ax,262
	jl dx1ok 
	mov ax,261
dx1ok:
	cmp ax,30
	jg dx2ok
	mov ax,31
dx2ok:
	ret


;{--------------------------------------------}
;{set the arrays at start up to a known value}

clrarys:
	mov ax,2000
	mov cx,100
	lea bx,[pary1]	;clear plot array
cpary1:
	mov [bx],ax
	add bx,2
	dec cx
	jnz cpary1
	mov ax,89
	mov [pary1+2],ax

	mov ax,0
	mov cx,100
	lea bx,[pary2]	;clear undraw array
cpary2:
	mov [bx],ax
	add bx,2
	dec cx
	jnz cpary2
	mov ax,89
	mov [pary2+2],ax

	mov ax,2000
	mov cx,100
	lea bx,[raryx]	;clear response array
craryx:
	mov [bx],ax
	add bx,2
	dec cx
	jnz craryx
	mov ax,89
	mov [raryx+2],ax
	ret

;{-----------------------------------------------}
;{main program starts here}

main:
	call initgraph	;init graphics mode
	call initRS232	;init rs232 port
	call clrarys	;clear the arrays

mainlp:
	call dobox		;{put the fixed stuff on the screen}

	mov ax,25
	mov [sary],ax
	mov ax,1
	mov [sary+2],ax
	mov ax,0		;{ask for curve 0}
	mov [sary+4],ax
	call sendcmd

	call getresponse	;{get the response}
	call findscale		;{figure out scaling}
 	call dispcurve		;{now show the curve}

exit:
	call brkchk	;loop until ^C is struck
	jmp mainlp
gohome:
	call closeRS232	;close rs232 port
	mov ax,2	;80x25 bw
	int 10h		;switch back to normal text mode
	int 20h		;and go home

;----------------------------------------------------------------------
;data arrays and stack put here so that disk space won't be wasted

sary    DS 200
raryx   DS 2200
pary1   DS 2200
pary2   DS 2200
estack	DS 1000h	;our own stack here
stack	DS 2

	end	100h

