{ TPWCRV.PAS   writen by Michael Day - 09/30/9;  rev 04/03/97-med }
{ Copyright 1987,1989, 1992,1997 Frye Electronics, Inc. }
{ Sample Turbo Pascal program to show usage of the }
{ Frye Instrument Packet Protocol interface program - FRYERS.COM }
{ This program requires Turbo Pascal V1.5 for Windows or
{ Borland Pascal V7.0 for Windows }
{ NOTE - you *must* have the latest version (V3.0 - 1992 or later) }
{ of FRYERS.COM loaded in the computer to use this program  }

{program directives}

{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$S-}    {stack checking off}

program realtimecurve;
Uses DosCrt,  WinDos,  WinProcs, WinTypes, Strings;

{$R FRYE.RES}    {link in the resources - just the Frye logo for now}

TYPE   string2 = string[2];
       string4 = string[4];

const  IRQn : byte = 0;       {IRQ = 0 - 15}
       comport : word = 0 ;   {COM port to use - 0 or 1 }
       cltype  : byte = 0  ;  {0=dot/x, 1=x&y, 2=x&y smoothed}

       {this plots the vertices to draw the graph with}
       xtab : array [0..79] of integer =
           (0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228);

       ftab : array [1..7] of string4 =
          ('.12','.25','.5 ',' 1 ',' 2 ',' 4 ',' 8 ');

type   sarray = array[1..200] of integer;
       parray = array[1..1200] of integer;

VAR    sary : sarray;
       raryx : parray;
       pary1 : parray;
       pary2 : parray;
       debug : boolean;
       ts,poff : integer;
       GtWidth : integer;
       GxStart : integer;
       Gblpt : integer;   {bottom left point on graph}
       Mtm,Grm,Gy,Gyt,Glm : integer; {y pixels / left margin on graph in pixels}
       Ptick,Tscale,Pscale : integer; {pixels per scale division}
       rax,rbx,rcx,rdx:word;
       hw,Err : integer;
       psy : real;
       Ch : char;
       pcnt : word;
       Pstr : string;


const  tcolor : word= yellow;  {text color}
       bcolor : word= lightgreen  ;  {box color}
       ccolor : word= white;  {curve color}
       bkcolor : word= black;  {background color}


{poff = offset used to plot starting at bottom of box}
{scale = used to print numbers on left of box}

{----------------------------------------------------}
{convert a byte to hex}
function HexString(Byt : byte) : string2;
const
  Hex : array[0..15] of char = '0123456789ABCDEF';
begin
  HexString := Hex[Byt shr 4] + Hex[Byt and 15];
end; { HexString }

{convert a word to hex}
function hexword(wrd:integer):string4;
Begin
  Hexword := hexstring(wrd shr 8) + hexstring(wrd and $ff);
end;

function fstr(L:longint):string;
var S:string;
begin
  str(l,s);
  fstr := s;
end;

procedure xywrite(x,y:word; s:string; color:byte);
{var i:word;}
begin
  GotoXY(x,y);
  TextColor(color);
  write(s); 
{  for i := 1 to length(s) do
    WriteChar(s[i]); }
end;

procedure xswrite(x,y,n:integer; l,color:byte);
var s : string;
    i : byte;
begin
  s := fstr(n);
  for i := 1 to L-Length(s) do
    s := ' '+s;
  xywrite(x,y,s,color);
end;

procedure ShowErrMsg(s:string);
begin
  xywrite(5,1,s,lightred);
end;

{-----------------------------------------------------------------}
{this displays debug informaton while waiting for response}

procedure showregs(Rax,Rbx,Rcx,Rdx:word);
begin
   if debug then
   begin
     xywrite(Mtm,19,'STATUS',tcolor);
     xywrite(Mtm,20,'AX:'+hexword(rax),tcolor);
     xywrite(Mtm,21,'BX:'+hexword(rbx),tcolor);
     xywrite(Mtm,22,'CX:'+hexword(rcx),tcolor);
     xywrite(Mtm,23,'DX:'+hexword(rdx),tcolor);

     if (rax and $0040) <> 0 then xywrite(6,2,'NO POLL',tcolor) else
       if (rax and $ff9c) <> 0 then xywrite(6,2,'ERROR  ',tcolor);
   end;
end;

{-----------------------------------------------------------------------}
{ This procedure enables the RS232 port1 for use with the software. }

function InitRS232:boolean;
begin
   InitRs232 := false;
     asm
       mov dx,0
       mov ax,$ffff
       int $14
       mov [rdx],dx
       mov [rax],ax
     end;
     if (rdx <> $ffff) or (rax < $30) then
     begin
       ShowErrMsg('Cannot run program, FRYERS.COM not loaded');
       Exit;
     end;
     asm
       mov ax,$ff00 {disable fryers interrupt procedure}
       mov cx,$ff00 {this makes sure everything is kosher}
       mov dx,[comport]
       and dx,1
       INT $14

       mov ax,$ff0a     {select the desired port to use}
       mov ch,$ff
       mov cl,[IRQn]      {use the selected IRQ number}
       mov bx,[comport]
       shr bx,1         {select the uart to use}
       and bx,1
       mov dx,[comport]  {init the port}
       and dx,1
       INT $14
       mov [rax],ax
     end;
     if rax = $ff then
     begin
       ShowErrMsg('Error: unable to configure specified COM port');
       Exit;
     end;

     asm
       mov ax,$ff00 {enable fryers interrupt procedure}
       mov cx,$ffff
       mov dx,[comport]
       and dx,1
       INT $14
       mov ax,$ff10 {enable fryers packet protocol}
       mov cx,$ffff
       mov dx,[comport]
       and dx,1
       INT $14
       mov ax,$FFFF  {check on version number}
       mov dx,[comport]
       and dx,1
       INT $14
       mov ax,$00f3  {init to 9600 baud, no parity, 8 data bits}
       mov dx,[comport]    {no autobaud}
       and dx,1
       INT $14
       mov [rax],ax
       mov [rbx],bx
       mov [rcx],cx
       mov [rdx],dx
     end;
     InitRS232 := true;
end;

procedure CloseRS232;
begin
   asm
     mov ax,$ff00 {disable fryers interrupt procedure}
     mov cx,$ff00 {this makes sure everything is kosher}
     mov dx,[comport]
     and dx,1
     INT $14
   end;
end;

{-----------------------------------------------------------------------}
{ waits for int14 to be ready to accept send cmd}

function Sendwait:boolean;
begin
  sendwait := false;
   repeat
     asm
       mov ax,$0ff13
       mov dx,[comport]
       and dx,1
       INT $14
       mov [rax],ax
       mov [rbx],bx
       mov [rcx],cx
       mov [rdx],dx
     end;
     showregs(rax,rbx,rcx,rdx);
    if ((rax and $0060) <> 0) or keypressed then Exit;
   until ((rax and $0001) <> 0);
   sendwait := true;
end;

{-----------------------------------------------------------------------}
{ sends a cmd to target via the rs232 port}

Procedure sendcmd(scmd,scnt,sdat:integer);
var i,value : word;
begin
  if not(sendwait) then Exit;
  sary[1] := scmd;
  sary[2] := scnt;
  sary[3] := sdat;
    for i := 1 to 3 do
    begin
      value := sary[i];
      asm
        mov dx,[comport]
        and dx,1
        mov ax,$ff23
        mov cx,[i]
        dec cx
        mov bx,[value]
        int $14
      end;
    end;
    asm
      mov ax,$ff15
      mov dx,[comport]
      and dx,1
      int $14
    end;
end;

{-----------------------------------------------------------------------}
{ waits for response from target}

function Rspwait:boolean;
begin
  rspwait := false;
   repeat
     asm
       mov ax,$0ff13
       mov dx,[comport]
       and dx,1
       INT $14
       mov [rax],ax
       mov [rbx],bx
       mov [rcx],cx
       mov [rdx],dx
     end;
     showregs(rax,rbx,rcx,rdx);
    if ((rax and $0060) <> 0) or keypressed then Exit;
   until ((rax and $0001) = 1);
   rspwait := true;
end;

{-----------------------------------------------------------------------}
{ gets a response packet of integers from the rs232 port1. }

Procedure getresponse;
VAR  i : integer;
     Size,value : word;
begin
  if not(rspwait) then Exit;
    asm
      mov ax,$ff26
      mov dx,[comport]
      and dx,1
      mov cx,1
      int $14
      mov [Size],cx
    end;
    for i := 1 to Size+2 do
    begin
      asm
        mov ax,$ff26
        mov dx,[comport]
        and dx,1
        mov cx,[i]
        dec cx
        int $14
        mov [value],dx
      end;
      raryx[i] := value;
    end;
    asm
      mov ax,$ff16
      mov dx,[comport]
      and dx,1
      int $14
      mov [rax],ax
      mov [rbx],bx
      mov [rcx],cx
      mov [rdx],dx
    end;
  {  showregs(rax,rbx,rcx,rdx); }
  for i := 1 to 100 do
    pary1[i] := raryx[i]; { convert rsp to plot format}
  raryx[2] := 0;
end;

procedure Plot(DC,x,y,c:word);
begin
  SetPixel(DC,x,y,DosColor[c]);
end;

{--------------------------------------------}
{plot a curve on screen, clip to only within box}
procedure dodraw(a,b,c,d,color,ct:integer);
var  x1,y1,x2,y2,x,y,xstep,ystep,deltax,deltay,direction : integer;
begin
  InitDeviceContext;
  x1 := a;
  x2 := c;
  if b > GraphGetMaxY then y1 := GraphGetMaxY else if b < 1 then y1 := 1 else y1 := b;
  if d > GraphGetMaxY then y2 := GraphGetMaxY else if d < 1 then y2 := 1 else y2 := d;
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  plot(dcwDC,x,y,color);   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (ct > 0)) then
        plot(dcwDC,x,y,color);   {plot first dot}
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (ct > 1)) then
        plot(dcwDC,x,y,color);   {plot first dot}
    end;
  until ((y = y2) and (x = x2));
  DoneDeviceContext;
end;


procedure dorect(x1,y1,x2,y2:word; c,ct:byte);
begin
  dodraw(x1,y1,x2,y1,c,ct);
  dodraw(x2,y1,x2,y2,c,ct);
  dodraw(x2,y2,x1,y2,c,ct);
  dodraw(x1,y2,x1,y1,c,ct);
end;

{----------------------------------------------------------------}
{draw the fixed stuff of the screen}

procedure dobox;
var i,Gx,Gxx:integer;
begin
  GtWidth := round((TextHeight div TextWidth) * 8); {TextWidth + (TextWidth div 2);}
  GxStart := (TextWidth*3)+((TextWidth div 3)*2);
  Ptick := (TextHeight)+(TextHeight div 4);   {pixels per tick}
  psy := Ptick*2*0.001;    {pixels per 0.01db}

  Gx := GxStart;
  dorect(Gx,0,Gx+(GtWidth*29),(18*Ptick),bcolor,1);

  for i := 1 to 17 do   {5db per tick}
  begin
    Gy := Ptick*i;
    dodraw(Gx-(TextWidth div 3),Gy,Gx,Gy,bcolor,1);
  end;

  for i := 1 to 19 do {1/6 octive per tick}
  begin
    Gy := 18*Ptick;
    Gxx :=  Gx+ (i*GtWidth)+(i*(GtWidth div 2));
    dodraw(Gxx,Gy,Gxx,Gy+(TextHeight div 3),bcolor,1);
    if i mod 3 = 1 then
      xywrite(Gxx div TextWidth,24,ftab[succ(i div 3)],tcolor);
  end;

  Gblpt := TextHeight*23;
  Glm := TextWidth*4;  {left margin offset on graph in pixels}
  Grm := Gx+(GtWidth*29);
  Gyt := 19; {Y ticks on graph}
  Gy := TextHeight + (TextHeight div 4);

  Mtm := (Grm+(TextWidth*2)) div TextWidth;
  xywrite(Mtm,1,'SOURCE',tcolor);
  xywrite(Mtm,4,'RMS OUT',tcolor);
  xywrite(Mtm,7,'TOP SPL',tcolor);
  xywrite(Mtm,10,'N.R.',tcolor);
  xywrite(Mtm,13,'FLAGS',tcolor);
(*
  gotoxy(6,10);
  write('Mtm:',Mtm,' Tw:',TextWidth,' Th:',TextHeight,' GtW:',GtWidth,'  ');
  gotoxy(6,11);
  write('P1:',Pary1[12],' Pscale:',Pscale,'  ');
  gotoxy(6,12);
  write('Tscale:',Tscale,' Tspl:',pary1[9],'   ');
  gotoxy(6,13);
  write(' psy:',psy:4:4,' Ptick:',ptick,'  ');
*)

end;

{------------------------------------------------------}
{update the numbers for the curve}

procedure miscinfo;
begin
  xywrite(Mtm,2,'      ',tcolor); {src}
  if pary1[8] = 0 then xywrite(Mtm,2,'OFF',tcolor)
    else xywrite(Mtm,2,fstr(pary1[8]),tcolor);

  xywrite(Mtm,5,'      ',tcolor);
  xywrite(Mtm,5,fstr(pary1[10]),tcolor);{rms out}

  xywrite(Mtm,8,'      ',tcolor);
  xywrite(Mtm,8,fstr(pary1[9]),tcolor); {top val}

  xywrite(Mtm,11,'      ',tcolor);    {noise reduction}
  if pary1[11] = 0 then xywrite(Mtm,11,'OFF',tcolor)
    else xywrite(Mtm,11,fstr(pary1[11]),tcolor);

  xywrite(Mtm,14,'      ',tcolor);
  xywrite(Mtm,14,hexword(pary1[4]),tcolor); {flags a}

  xywrite(Mtm,15,'      ',tcolor); {flags b}
  xywrite(Mtm,15,hexword(pary1[5]),tcolor);
end;

{-------------------------}
{figure out what the scale is and show it on the graph}

procedure findscale;
begin
  ts := (pary1[9] div 100);      {top spl in db}
  Tscale := (ts div 20)*20 + 20;  {set scale on 20db margin text}
  Pscale := trunc(Tscale/5*Ptick);
  poff := Pscale+Ptick; {graph plot start location (bottom left)}

   if (pary1[1] and $4000) <> 0 then
     xywrite(6,2,'BAD RSP',tcolor) {unexpected response}
   else if pary1[4] = $0400 then
      xywrite(6,2,'INVALID',tcolor)  {bad curve}
    else if (pary1[4] and $4000) = 0 then
       xywrite(6,2,'dBSPL  ',tcolor) {power curve}
     else xywrite(6,2,'GAIN   ',tcolor);  {none of the above, so must be gain}

  xswrite(1,2,Tscale+00,3,tcolor);
  xswrite(1,7,Tscale-20,3,tcolor);
  xswrite(1,12,Tscale-40,3,tcolor);
  xswrite(1,17,Tscale-60,3,tcolor);
  xswrite(1,22,Tscale-80,3,tcolor);
end;

{-------------------------}
Procedure dispcurve(ct:byte);
var da,db,xa,xb,ya,yb,x,i,ty : integer;
begin
  i := 12; {start with 100hz plot}
  x := 0;
  ty := (Tscale-20)*100;
  repeat
    da := pary1[i];
    if da <> $8000 then
      da := poff - trunc(psy * pary1[i]);
    db := pary1[i+1];
    if db <> $8000 then
      db := poff - trunc(psy * pary1[i+1]);
{    gotoxy(6,15);
    write('da:',da,' db:',db,'  '); }
    ya := pary2[i];
    yb := pary2[i+1];
    pary2[i] := da;
    xa := trunc((xtab[x] / 8) * Gtwidth)+Glm;
    xb := trunc((xtab[x+1] / 8) * Gtwidth)+Glm;
    i := i + 1;
    x := x + 1;
    if xa = xb then   { skip next when xa = xb }
    begin
      i := i + 1;
      x := x + 1;
    end;
    if not((xa = $8000) and (xb <> $8000)) then
      dodraw(xa,ya,xb,yb,bkcolor,ct); {undraw}
    if not((da = $8000) and (db <> $8000)) then
      dodraw(xa,da,xb,db,ccolor,ct); {draw new one}
  until x > 78;
  pary2[i] := db;
  miscinfo;
end;

{--------------------------------------------}
{set the arrays at start up to a known value}

procedure clrarys;
var top,i : integer;
begin
  for i := 1 to 100 do pary1[i] := 2000;
  pary1[2] := 89;

  for i := 1 to 100 do pary2[i] := 2000;
  pary2[2] := 89;

  top := -32767;
  for i := 1 to 100 do
  begin
    if i > 10 then
      raryx[i] := {((i and $fff8)-4) *50}1920;
    if raryx[i] > top then top := raryx[i];
  end;
  raryx[9] := top;
  raryx[2] := 89;
end;

{-----------------------------------------------}
{main program starts here}

begin
    ScreenSize.X := 60;
    ScreenSize.Y := 25;
    WindowSize.X := 800;
    WindowSize.Y := 1000;
    StrCopy(WindowTitle,'TPW CURVE');
    DosCrtFont := Oem_Fixed_Font;
    GraphSetBkColor(BkColor);
    TextBackground(BkColor);
    InitDosCrtWindow;
    AutoTracking := false;

  comport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
      '2': comport := 1;
      '3': comport := 2;
      '4': comport := 3;
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,Irqn,Err);
              if (IrqN > 15) or (Err <> 0) then IrqN := 0;
           end;
    end;
    dec(Pcnt);
  end;

  debug := true;
  fillchar(pary1,sizeof(pary1),0);
  Tscale := 120;
  clrarys;

  if initRS232 then
  begin
    repeat
      dobox;                {put the fixed stuff on the screen}
      sendcmd(25,1,0);      {ask for curve 0}
      getresponse;          {get the response}
      findscale;            {figure out scaling}
      dispcurve(0);         {now show the curve 0=dot/x, 1=x&y, 2=smooth}
    until keypressed;       {if key pressed abort the program}
  end
  else
    ch := readkey;

  CloseRS232;
  DoneDosCrtWindow;
end.

