{ D2CURVE   writen by Michael Day - 06/29/00 }
{ Copyright 1987,2000 Frye Electronics, Inc. }
{ Sample Delphi V2.0 program to show usage of the }
{ Frye Instrument Packet Protocol interface program - FRYERS32.DLL}
{ This version is for Delphi V2.0 and above for Windows}
{ NOTE - you *must* have the Fryers32.DLL loaded either in the}
{ Windows directory, or the directory where this program is}

{program directives}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I+}    {I/O checking on}

unit Dc2unit;
interface
uses FryersP,Forms,Windows,Graphics,mmSystem,Dialogs;

const SerialPort : integer = 1; //start with com1 for serial port
const FryersBaudrate : integer = 9600;
const Paws : boolean = false;
const Quick : boolean = false;
const ReadResponse : boolean = false;
const SendResult : boolean = false;
const RspResult : boolean = false;
const Debug : boolean = false;
const FirstTime : boolean = true;
const IamBusy : boolean = false;
const IamRunning : boolean = false;
const KillMe : boolean = false;
const FryersVersionString : string[255] = 'Fryers';
const BaudrateString : string[255] = '9600';

const  TextColor = clLime;  {text color}
       BoxColor = clAqua;  {box color}
       CrvColor = clYellow;  {curve color}
       BackColor = clBlack;  {background color}
       ForeColor = clWhite;  {foreGround color}

var  FryersObj : TFryers;

function StartMeUp:boolean;
function DoMe:boolean;
function GetBaudrate:boolean;
procedure CloseRS232;

var SendData : array[0..F_MAX_DATA_SIZE] of INT16;
var RcvData : array[0..F_MAX_DATA_SIZE] of INT16;
var DispData : array[0..100] of INT16;
var OldData : array[0..100] of INT16;

implementation
uses Dc2Form;

Const GotError : boolean = false;
       //cltype  : byte = 0;  {0=dot/x, 1=x&y, 2=x&y smoothed}

       {this plots the vertices to draw the graph with}
       xtab : array [0..79] of integer =
           (0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228);

const  INVALID_DATA = -32768;
TYPE   string2 = string[2];
       string4 = string[4];

VAR    ts,Scale,Poff : integer;
       rax,rbx,rcx,rdx:word;

{poff = offset used to plot starting at bottom of box}
{scale = used to print numbers on left of box}

//procedure pause(Duration:integer);
//var t1:integer;
//begin
//  t1 := timeGetTime;
//  while timeGetTime-t1 < Duration do {nop};
//end;

{----------------------------------------------------}
{convert a byte to hex}
function HexString(Byt : byte) : string2;
const
  Hex : array[0..15] of char = '0123456789ABCDEF';
begin
  HexString := Hex[Byt shr 4] + Hex[Byt and 15];
end; { HexString }

{convert a word to hex}
function hexword(wrd:integer):string4;
Begin
  Hexword := hexstring(wrd shr 8) + hexstring(wrd and $ff);
end;

function fstr(L:longint):string;
var S:string;
begin
  str(l,s);
  fstr := s;
end;

procedure xsWrite(x,y,n:integer; l:byte; color:tColor);
var s : string;
begin
  s := fstr(n);
  while length(S) < l do
    s := s+' ';
  xywrite(x,y,s,color);
end;

{-----------------------------------------------------------------}
{this displays debug informaton while waiting for response}

procedure ShowStatus;
begin
   if debug then
   begin
     xywrite(34,19,'STATUS',textcolor);
     xywrite(34,20,'AX:'+hexword(rax),textcolor);
     xywrite(34,21,'BX:'+hexword(rbx),textcolor);
     xywrite(34,22,'CX:'+hexword(rcx),textcolor);
     xywrite(34,23,'DX:'+hexword(rdx),textcolor);

     if (rax and $0040) <> 0 then
     begin
       xywrite(6,2,'NO POLL',textcolor);
       GotError := true;
     end
     else
     begin
       if (rax and $ff9c) <> 0 then
       begin
         xywrite(6,2,'ERROR  ',textcolor);
         GotError := true;
       end;
     end;
   end;
end;

//{-----------------------------------------------------------------------}
//{ This procedure enables the RS232 port1 for use with the software. }

function InitRS232:boolean;
type str20 = string[20];
var bResult:boolean;
    Size,i,tmp:integer;
    s:str20;
    st:str20;
begin
  bResult := FryersObj.OpenPacketPort(SerialPort, FryersBaudrate, true, false);
  if (bResult = false) then
  begin
    ShowMessage('Cannot run program, FRYERS not loaded');
    InitRS232 := false;
    Exit;
  end;

  tmp := FryersObj.FVersion;
  system.str(tmp div 100,s);
  FryersVersionString := 'Fryers Version '+s+'.';
  tmp := tmp mod 100;
  system.str(tmp,st);
  if (system.length(st) = 1) then
    FryersVersionString := FryersVersionString+'0'+st
  else FryersVersionString := FryersVersionString+st;
  if (FryersObj.FVersion > 400) then
  begin
    FryersVersionString[0] := #0;
    FryersObj.Regs.AX := $0FFFD;
    FryersObj.Regs.DX := FryersObj.ComPort;
    FryersObj.Regs.CX := 0;
    CallFryers(FryersObj.Regs);
    Size := FryersObj.Regs.AX;
    if (Size < 255) then
    begin
      for i:=1 to Size do
      begin
        FryersObj.Regs.AX := $0FFFD;
        FryersObj.Regs.DX := FryersObj.ComPort;
        FryersObj.Regs.CX := i;
        CallFryers(FryersObj.Regs);
        st := char(FryersObj.Regs.AL);
        //st[1] := #0;
        FryersVersionString := FryersVersionString+st;
      end;//endfor(i)
    end; //endif(Size)
  end; //endif(Ver)
  InitRS232 := true;
end;

//----------------------------------
procedure CloseRS232;
begin
  FryersObj.ClosePacketPort();
  IamBusy := false;
end;

//----------------------------------------------------
//Get the current baudrate in use
//returns true if currently seeking new baudrate
function GetBaudrate:boolean;
var BaudOK:boolean;
begin
  Quick := FryersObj.CheckQT();
  if (FryersObj.GetCurrentBaudrate() > 100) then
  begin
    str(FryersObj.Baudrate,BaudrateString);
    FryersBaudrate := FryersObj.Baudrate;
    BaudOK := true;
  end
  else
  begin
    BaudrateString := ' (Baudrate Unknown)';
    BaudOK := false;
  end;
  if (FryersObj.BaudSeek = true) then
  begin
    BaudrateString := Baudratestring+' (Seeking)';
  end
  else if (BaudOK = true) then
  begin
    BaudrateString := BaudrateString +' Baud';
    if (Quick = true) then
      BaudrateString := BaudrateString+' Quick';
  end;
  GetBaudrate := FryersObj.BaudSeek;
end;

//--------------------------------------------------------
procedure DebugMonitor;
begin
  Rax := FryersObj.Regs.AX;
  Rbx := FryersObj.Regs.BX;
  Rcx := FryersObj.Regs.CX;
  Rdx := FryersObj.Regs.DX;
  ShowStatus();
  //if (FryersObj.BaudSeek = true) then
  //begin
    GetBaudrate();
    Form1.BaudrateLabel.Caption := BaudrateString;
  //end
end;

//--------------------------------------------------------
//Sends a cmd to target via Fryers}
function SendCmd(scmd:INT16; scnt:INT16; sdat:INT16):boolean;
begin
  SendCmd := false;
  if (FryersObj.SendReady() = false) then Exit;
  SendData[0] := scmd;
  SendData[1] := scnt;
  SendData[2] := sdat;
  SendCmd := FryersObj.SendCmd(@SendData[0],DebugMonitor);
end;

//---------------------------------------------------------
//Gets a response packet of integers from the rs232 port1.
function GetRsp:boolean;
var i:integer;
begin
  GetRsp := false;
  if (FryersObj.GetResponse(@RcvData[0],DebugMonitor) = false) then Exit;
  GotError := false;
  for i:=0 to 100 do
    DispData[i] := RcvData[i]; //{ convert rsp to plot format}
  GetRsp := true;
end;

//---------------------------------------------------------
//release instrument from comm mode
function QuickTerm:boolean;
begin
  QuickTerm := FryersObj.QuickTerminate(DebugMonitor);
end;

{--------------------------------------------}
{plot a curve on screen, clip to only within box}
procedure DoDraw(a,b,c,d:integer; color:Tcolor; ct:integer);
var  x1,y1,x2,y2,x,y,xstep,ystep,deltax,deltay,direction : integer;
begin
  SetPixelColor(color,BackColor);
  x1 := a;
  x2 := c;
  if b > 190 then y1 := 190 else if b < 1 then y1 := 1 else y1 := b;
  if d > 190 then y2 := 190 else if d < 1 then y2 := 1 else y2 := d;
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  plot(x,y,color);   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (ct > 0)) then
        plot(x,y,color);   {plot first dot}
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (ct > 1)) then
        plot(x,y,color);   {plot first dot}
    end;
  until ((y = y2) and (x = x2));
end;

{----------------------------------------------------------------}
{draw the fixed stuff of the screen}

procedure DoBox;
var i:integer;
begin
  DoDraw(30,186,262,186,BoxColor,1);
  DoDraw(262,186,262,0,BoxColor,1);
  DoDraw(262,0,30,0,BoxColor,1);
  DoDraw(30,0,30,186,BoxColor,1);

  for i := 1 to 18 do
  begin
    DoDraw(succ(25),(i*10),29,(i*10),BoxColor,1);
  end;

  for i := 1 to 19 do
  begin
    DoDraw((i*12)+31,187,(i*12)+31,190,BoxColor,1);
  end;

  xyWrite(5,25,'.12',TextColor);
  xyWrite(9,25,'.25',TextColor);
  xyWrite(14,25,'.5',TextColor);
  xyWrite(19,25,'1',TextColor);
  xyWrite(24,25,'2',TextColor);
  xyWrite(28,25,'4',TextColor);
  xyWrite(33,25,'8',TextColor);

  xyWrite(34,1,'SOURCE',TextColor);
  xyWrite(34,4,'RMS OUT',TextColor);
  xyWrite(34,7,'TOP SPL',TextColor);
  xyWrite(34,10,'N.R.',TextColor);
  xyWrite(34,13,'FLAGS',TextColor);
end;

{------------------------------------------------------}
{update the numbers for the curve}
procedure MiscInfo;
begin
  xyWrite(34,2,'      ',TextColor); {src}
  if DispData[7] = 0 then xyWrite(34,2,'OFF',TextColor)
  else xyWrite(34,2,fstr(DispData[7]),TextColor);

  xyWrite(34,5,'      ',TextColor);
  xyWrite(34,5,fstr(DispData[9]),TextColor);{rms out}

  xyWrite(34,8,'      ',TextColor);
  xyWrite(34,8,fstr(DispData[8]),TextColor); {top val}

  xyWrite(34,11,'      ',TextColor);    {noise reduction}
  if DispData[10] = 0 then xyWrite(34,11,'OFF',TextColor)
  else xyWrite(34,11,fstr(DispData[10]),TextColor);

  xyWrite(34,14,'      ',TextColor);
  xyWrite(34,14,HexWord(DispData[3]),TextColor); {flags a}

  xyWrite(34,15,'      ',TextColor); {flags b}
  xyWrite(34,15,HexWord(DispData[4]),TextColor);
end;

{-------------------------}
{figure out what the scale is and show it on the graph}
procedure FindScale;
begin
  ts := (DispData[8] div 100);
  Scale := (ts div 20)*20 + 20;
  Poff := (Scale*2)+10;

  if not(GotError) then
  begin
    if (FryersObj.BaudSeek = true) then
      xyWrite(6,2,'BAUDSEEK',TextColor) {unexpected response}
    else if (DispData[0] and $4000) <> 0 then
      xyWrite(6,2,'BAD RSP',TextColor)
    else begin
      if DispData[3] = $0400 then
        xyWrite(6,2,'INVALID',TextColor)  {bad curve}
      else begin
        if (DispData[3] and $4000) = 0 then
          xyWrite(6,2,'dBSPL  ',TextColor) {power curve}
        else xyWrite(6,2,'GAIN   ',textcolor);  {none of the above, so must be gain}
      end;
    end;
  end;

  xsWrite(1,2,Scale+00,3,TextColor);
  xsWrite(1,7,Scale-20,3,TextColor);
  xsWrite(1,12,Scale-40,3,TextColor);
  xsWrite(1,17,Scale-60,3,TextColor);
  xsWrite(1,22,Scale-80,3,TextColor);
end;

{-------------------------}
Procedure DispCurve;
//var dd:integer;
var da,db,xa,xb,ya,yb,x,i : integer;
const lm = 32;  {left margin on graph}
  function GetPoint(i:integer):integer;
  var k : integer;
  begin
    k := i;
    while (DispData[k] = INVALID_DATA) and (k < 79) do
      inc(k);
    GetPoint := DispData[k];
  end;
begin
  i := 11; {start with 100hz plot}
  x := 0;
  while (DispData[i] = INVALID_DATA) and (i < 79) do
  begin
    inc(i);
    inc(x);
  end;
  repeat
    da := GetPoint(i);
    db := GetPoint(i+1);
    if not(da = INVALID_DATA) then
      da := Poff - (da div 50);
    if not (db = INVALID_DATA) then
      db := Poff - (db div 50);
//    if da < 0 then
//      dd := da;

    ya := OldData[i];
    yb := OldData[i+1];
    OldData[i] := da;
    xa := xtab[x]+lm;
    xb := xtab[x+1]+lm;
    i := i + 1;
    x := x + 1;
    if xa = xb then   { skip next when xa = xb }
    begin
      i := i + 1;
      x := x + 1;
    end;
    if not((xa = INVALID_DATA) or (xb = INVALID_DATA)) then
      DoDraw(xa,ya,xb,yb,BackColor,0); {undraw}
    if not((da = INVALID_DATA) or (db = INVALID_DATA)) then
      DoDraw(xa,da,xb,db,CrvColor,0); {draw new one}
  until x > 78;
  OldData[i] := db;
  MiscInfo;
end;

{--------------------------------------------}
{set the arrays at start up to a known value}
procedure ClrArys;
begin
  FillChar(DispData,sizeof(DispData),0);
  FillChar(OldData,sizeof(OldData),0);
  FillChar(RcvData,sizeof(RcvData),0);
end;

{-----------------------------------------------}
{main program starts here}
function StartMeUp:boolean;
begin
  StartMeUp := false;
  Debug := true;
  if (InitRS232 = false) then Exit;
  StartGraph;
  Scale := 120;
  ClrArys;
  FryersObj.AutoQT(true); {turn on autoQT}
  Quick := FryersObj.CheckQT();
  StartMeUp := true;
end;

//--------------------------------
//do a run on the Fonix instrument
function DoMe:boolean;
begin
  IamBusy := true;
{  Quick = FryersObj.CheckQT();}
  if (Quick = false) then
    FryersObj.AutoQT(true); {turn on autoQT if it got turned off}

  DoBox;       {put the fixed stuff on the screen}
  if (ReadResponse = true) then
  begin
    RspResult := GetRsp; {get the response}
    if (RspResult = true) then
    begin
      ReadResponse := false;
      QuickTerm;   {let instrument out of comm mode so it can get another curve}
    end;
  end;
  FryersObj.PacketStatus;
  DebugMonitor;
  if (FryersObj.SendReady = true) then
  begin
    if (Paws = false) then
      SendResult := SendCmd(25,1,0);  {ask for curve 0}
    if (SendResult = true) then
      ReadResponse := true;
  end;
  FindScale;            {figure out scaling and errors}
  if (RspResult = true) then
    DispCurve;   {now show the curve}
  IamBusy := false;
  DoMe := true;
end;

begin
  if not(Assigned(FryersObj)) then  //check need to create the object
    FryersObj := TFryers.Create;
  if not(Assigned(FryersObj)) then
  begin
    ShowMessage('Error Creating Fryers Object');
    Halt;
  end;
end.


