
{Example Pascal code for skipping polls and reading status}
{Written by Michael Day 05/08/90}

Unit PollUnit;
interface

uses DOS;

const ComPort : word = 0;  {0=com1, 1=com2}

var StatAX : integer;
    StatCX : integer;
    StatDX : integer;
    regs   : Registers;

{===================================================================}

implementation

{-------------------------------------------------------------------}
{returns PacketStatus set to the current packet status value}
{The primary packet status is returned in AL as follows}
{7=bad transfer, 6=no poll, 5=reserved, 4=receive overflow}
{3=send overflow, 2=send overrun, 1=receive ready, 0=send ready}
{See the Fryers manual for a description of other error info}

function PacketStatus:byte;
begin
   regs.ax := $ff13;
   regs.dx := comport and $01; {make sure comport is in range}
   INTR($14,Dos.Registers(regs));
   StatAX := regs.ax;
   StatCX := regs.cx;  {save the error status response}
   StatDX := regs.dx;
   PacketStatus := regs.al;  {return the primary packet status}
end;

{-------------------------------------------------------------------}
{this clears the packet timer variable to zero}
procedure ClearPacketTimer;
begin
   regs.ax := $ff17;     {select packet timer}
   regs.cx := $03ff;
   regs.bx := 0;
   regs.dx := comport and $01; {make sure comport is in range}
   INTR($14,Dos.Registers(regs));
end;

{-------------------------------------------------------------------}
{this returns the packet timer's current value}
function GetPacketTimer:integer;
begin
   regs.ax := $ff17;     {read packet timer}
   regs.cx := $0300;
   regs.dx := comport and $01; {make sure comport is in range}
   INTR($14,Dos.Registers(regs));
   GetPacketTimer := regs.ax;
end;

{-------------------------------------------------------------------}
{This skips the next poll that occurs. This is used to ignore a poll}
{following a Set cmd in order to give the target time to perform a}
{measurement. If >110ms of time has passed without a poll, then the}
{function aborts with SkipPoll set to false. Otherwise the Poll is}
{skipped and the function returns true.}

function BSkipPoll:boolean;
begin
   BSkipPoll := false;
   ClearPacketTimer;
   repeat
     if GetPacketTimer > 1 then Exit; {timeout period passed}
     if (PacketStatus and $40) = $40 then Exit;  {no poll}
   until (StatCX and 1) = 1;                 {wait for poll signal}
   repeat
     if GetPacketTimer > 1 then Exit; {timeout period passed}
     if (PacketStatus and $40) = $40 then Exit;  {no poll}
   until (StatCX and 1) = 0;            {wait for poll to complete}
   BSkipPoll := true;
end;


{--------------}
{no init code}
end.