
{ TP6CURVE.PAS   writen by Michael Day - 09/10/92; }
{ rev 04/03/97-med; rev 06/22/00 -med }
{ Copyright 1987,1989, 1992,1997,2000 Frye Electronics, Inc. }
{ Sample Turbo Pascal program to show usage of the }
{ Frye Instrument Packet Protocol interface program - FRYERS.COM }
{ This version is for Turbo Pascal V6.0 or V7.0 for DOS }
{ NOTE - you *must* have the latest version (V3.0 - 1992 or later) }
{ of FRYERS.COM loaded in the computer to use this program  }
{ You can compile this with TP6 or BP7. }
{ Warning: Win98 has a broken vcpi interface. To use tp6 or bp7, }
{ you should include "novcpi" in your emm386 statement in config.sys}

{ Note: This program requires a VGA or better to run }
{ The program provides an example of using the Borland BGI drivers }
{ to implement graphics. The supplied BGI256.OBJ is a VESA compliant }
{ BGI driver for 256 color mode operation. For more information }
{ about the drivers, contact Borland International. }

{program directives}

{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$S-}
{$G+}   {use 286 instruction set}

program realtimecurve;
Uses crtx, Graph, dos;

const  tcolor = yellow  ;  {text color}
       bcolor = cyan ;  {box color}
       ccolor = green  ;  {curve color}
       BackColor = black; {background color}
       comport : word = 0 ;   {COM port to use - 0 or 1 }
       cltype  : byte = 0  ;  {0=dot/x, 1=x&y, 2=x&y smoothed}
       IRQn : byte = 0;       { IRQ to use 0-15 }
       NoShow : integer = -32768;

       {this plots the vertices to draw the graph with}
       xtab : array [0..79] of integer =
           (0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228);


TYPE   string2 = string[2];
       string4 = string[4];
       sarray = array[1..200] of integer;
       parray = array[1..1200] of integer;
       cpuregs = Registers;

  const  black = 0   ;  {background color}
         gd : integer = 0;
         gm : integer = 0;

VAR    sary : sarray;
       raryx : parray;
       pary1 : parray;
       pary2 : parray;
       debug : boolean;
       ts,scale,poff : integer;
       rax,rbx,rcx,rdx:word;
       Err : integer;
       tw,th:integer;
       dt : word;
       pcnt:word;
       Pstr : string;
       icnt : word;

{poff = offset used to plot starting at bottom of box}
{scale = used to print numbers on left of box}

{----------------------------------------------------}
{convert a byte to hex}
function HexString(Byt : byte) : string2;
const
  Hex : array[0..15] of char = '0123456789ABCDEF';
begin
  HexString := Hex[Byt shr 4] + Hex[Byt and 15];
end; { HexString }

{convert a word to hex}
function hexword(wrd:integer):string4;
Begin
  Hexword := hexstring(wrd shr 8) + hexstring(wrd and $ff);
end;

function fstr(L:longint):string;
var S:string;
begin
  str(l,s);
  fstr := s;
end;

procedure xywrite(x,y:word; s:string; color:byte);
var i:word;
    c:byte;
begin
  moveto(pred(x)*tw,pred(y)*th);
  setcolor(color);
  setfillstyle(SolidFill,black);
  bar(pred(x)*tw,pred(y)*th,(pred(x)*tw)+(tw*length(S)),y*th);
  outtext(s);
end;

procedure xswrite(x,y,n:integer; l,color:byte);
var s : string;
begin
  s := '                         ';
  s := fstr(n);
  s[0] := char(l);
  xywrite(x,y,s,color);
end;

{-----------------------------------------------------------------}
{this displays debug informaton while waiting for response}

procedure showregs(Rax,Rbx,Rcx,Rdx:word);
begin
   if debug then
   begin
     xywrite(34,19,'STATUS',tcolor);
     xywrite(34,20,'AX:'+hexword(rax),tcolor);
     xywrite(34,21,'BX:'+hexword(rbx),tcolor);
     xywrite(34,22,'CX:'+hexword(rcx),tcolor);
     xywrite(34,23,'DX:'+hexword(rdx),tcolor);

     if (rax and $0040) <> 0 then xywrite(6,2,'NO POLL',tcolor) else
       if (rax and $ff9c) <> 0 then xywrite(6,2,'ERROR  ',tcolor);
   end;
end;

{-----------------------------------------------------------------------}
{ set screen to graphic mode}

  function AutoDet:integer; far;
  begin
    AutoDet := 0;
  end;

  procedure Bgi256Proc; External;
  {$L BGI256.OBJ}

  function startgraph:boolean;
  begin
    startgraph := false;
    asm
      mov ax,$1A00
      push bp
      push ds
      int $10
      pop ds
      pop bp
      mov [dt],bx
    end;
    if dt < 7 then
    begin
      writeln('** Error: This program requires a VGA type display');
      Exit;
    end;

    Err := InstallUserDriver('BGI256',@AutoDet);
    Err := RegisterBGIdriver(@Bgi256Proc);
    Gd := 0;
    Gm := 0;
    initgraph(gd,gm,'');
    if GraphResult < 0 then
    begin
      writeln('Can''t start graph mode');
      Exit;
    end;
    th := TextHeight('X');
    tw := TextWidth('X');
    startgraph := true;
  end;


procedure ClearPacket;
begin
  asm
    mov ax,$FF16
    mov dx,comport
    and dx,1
    int $14
  end;
end;

{-----------------------------------------------------------------------}
{ This procedure enables the RS232 port1 for use with the software. }

function InitRS232:boolean;
begin
  InitRS232 := false;

     asm
       mov dx,0
       mov ax,$ffff
       int $14
       mov [rdx],dx
       mov [rax],ax
     end;
     if (rdx <> $ffff) or (rax < $20) then
     begin
       writeln('Cannot run program, FRYERS.COM not loaded');
       Exit;
     end;

     asm
       mov ax,$ff00 {disable fryers interrupt procedure}
       mov cx,$ff00 {this makes sure everything is kosher}
       mov dx,[comport]
       and dx,1
       INT $14

       mov ax,$ff0a     {select the desired port to use}
       mov ch,$ff
       mov cl,[IRQn]      {use the selected IRQ number}
       mov bx,[comport]
       shr bx,1         {select the uart to use}
       and bx,1
       mov dx,[comport]  {init the port}
       and dx,1
       INT $14
       mov [rax],ax
     end;
     if rax = $ff then
     begin
       writeln('Error: unable to configure specified COM port');
       Exit;
     end;

     asm
       mov ax,$ff00 {enable fryers interrupt procedure}
       mov cx,$ffff
       mov dx,[comport]
       and dx,1
       INT $14
       mov ax,$ff10 {enable fryers packet protocol}
       mov cx,$ffff
       mov dx,[comport]
       and dx,1
       INT $14
       mov ax,$00e3  {init to 9600 baud, no parity, 8 data bits}
       mov dx,[comport]
       and dx,1
       INT $14
       mov [rax],ax
       mov [rbx],bx
       mov [rcx],cx
       mov [rdx],dx
     end;
 InitRS232 := true;
end;

procedure CloseRS232;
begin
   asm
     mov ax,$ff00 {disable fryers interrupt procedure}
     mov cx,$ff00 {this makes sure everything is kosher}
     mov dx,[comport]
     and dx,1
     INT $14
   end;
end;

{-----------------------------------------------------------------------}
{ waits for int14 to be ready to accept send cmd}

function Sendwait:boolean;
begin
  SendWait := false;
   repeat
     asm
       mov ax,$0ff13
       mov dx,[comport]
       and dx,1
       INT $14
       mov [rax],ax
     end;
     if keypressed or ((rax and $0040) = $40) then Exit;
   until ((rax and $0001) <> 0);
   SendWait := true;
end;

{-----------------------------------------------------------------------}
{ sends a cmd to target via the rs232 port}

function sendcmd(scmd,scnt,sdat:integer):boolean;
var P : pointer;
begin
  sendcmd := false;
  if not sendwait then Exit;
  ClearPacket; {clears the packet protocol to insure we are in sync}
  P := @sary;
  sary[1] := scmd;
  sary[2] := scnt;
  sary[3] := sdat;
    asm
      push ds
      mov dx,[comport]
      and dx,1
      lds bx,[P]
      mov ax,$ff11
      INT $14
      pop ds
    end;
  sendcmd := true;
end;

{-----------------------------------------------------------------------}
{ waits for response from target}

function Rspwait:boolean;
begin
  RspWait := false;
   repeat
     asm
       mov ax,$0ff13
       mov dx,[comport]
       and dx,1
       INT $14
       mov [rax],ax
       mov [rbx],bx
       mov [rcx],cx
       mov [rdx],dx
     end;
     showregs(rax,rbx,rcx,rdx);
     if ((rax and $0040) = $40) or keypressed then Exit;
   until ((rax and $0001) = 1);
   RspWait := true;
end;

{-----------------------------------------------------------------------}
{ gets a response packet of integers from the rs232 port1. }

function getresponse:boolean;
VAR  p : pointer;
     i : integer;
begin
  getresponse := false;
  if not rspwait then Exit;
  p := @raryx;
    asm
      push ds
      mov ax,$ff12
      mov dx,[comport]
      and dx,1
      lds bx,[p]
      INT $14
      pop ds
    end;
  for i := 1 to 100 do
    pary1[i] := raryx[i]; { convert rsp to plot format}
  raryx[2] := 0;
  getresponse := true;
end;



procedure Plot(x,y,c:word);
begin
   PutPixel(x,y,c);

(*
    asm
      mov ah,$0c
      mov al,byte ptr [c]   {plot via bios call}
      mov dx,[y]
      mov cx,[x]
      int $10
    end;
*)
end;

{--------------------------------------------}
{plot a curve on screen, clip to only within box}
procedure dodraw(a,b,c,d,color,ct:integer);
var  x1,y1,x2,y2,x,y,xstep,ystep,deltax,deltay,direction : integer;
begin
  x1 := a;
  x2 := c;
  if b > 190 then y1 := 190 else if b < 1 then y1 := 1 else y1 := b;
  if d > 190 then y2 := 190 else if d < 1 then y2 := 1 else y2 := d;
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  plot(x,y,color);   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (ct > 0)) then
        plot(x,y,color);   {plot first dot}
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (ct > 1)) then
        plot(x,y,color);   {plot first dot}
    end;
  until ((y = y2) and (x = x2));
end;

{----------------------------------------------------------------}
{draw the fixed stuff of the screen}

procedure dobox;
var i:integer;
begin
  dodraw(30,186,262,186,bcolor,1);
  dodraw(262,186,262,0,bcolor,1);
  dodraw(262,0,30,0,bcolor,1);
  dodraw(30,0,30,186,bcolor,1);

  for i := 1 to 18 do
  begin
    dodraw(succ(25),(i*10),29,(i*10),bcolor,1);
  end;

  for i := 1 to 19 do
  begin
    dodraw((i*12)+31,187,(i*12)+31,190,bcolor,1);
  end;

  xywrite(5,25,'.12',tcolor);
  xywrite(9,25,'.25',tcolor);
  xywrite(14,25,'.5',tcolor);
  xywrite(19,25,'1',tcolor);
  xywrite(24,25,'2',tcolor);
  xywrite(28,25,'4',tcolor);
  xywrite(33,25,'8',tcolor);

  xywrite(34,1,'SOURCE',tcolor);
  xywrite(34,4,'RMS OUT',tcolor);
  xywrite(34,7,'TOP SPL',tcolor);
  xywrite(34,10,'N.R.',tcolor);
  xywrite(34,13,'FLAGS',tcolor);
end;

{------------------------------------------------------}
{update the numbers for the curve}

procedure miscinfo;
begin
  xywrite(34,2,'      ',tcolor); {src}
  if pary1[8] = 0 then xywrite(34,2,'OFF',tcolor) else xywrite(34,2,fstr(pary1[8]),tcolor);

  xywrite(34,5,'      ',tcolor);
  xywrite(34,5,fstr(pary1[10]),tcolor);{rms out}

  xywrite(34,8,'      ',tcolor);
  xywrite(34,8,fstr(pary1[9]),tcolor); {top val}

  xywrite(34,11,'      ',tcolor);    {noise reduction}
  if pary1[11] = 0 then xywrite(34,11,'OFF',tcolor) else xywrite(34,11,fstr(pary1[11]),tcolor);

  xywrite(34,14,'      ',tcolor);
  xywrite(34,14,hexword(pary1[4]),tcolor); {flags a}

  xywrite(34,15,'      ',tcolor); {flags b}
  xywrite(34,15,hexword(pary1[5]),tcolor);
end;

{-------------------------}
{figure out what the scale is and show it on the graph}

procedure findscale;

begin
  ts := (pary1[9] div 100);
  scale := (ts div 20)*20 + 20;
  poff := (scale*2)+10;

   if (pary1[1] and $4000) <> 0 then xywrite(6,2,'BAD RSP:'+hexword(pary1[1]),tcolor) {unexpected response}
   else
    if pary1[4] = $0400 then xywrite(6,2,'INVALID',tcolor)  {bad curve}
    else
     if (pary1[4] and $4000) = 0 then xywrite(6,2,'dBSPL  ',tcolor) {power curve}
     else
       xywrite(6,2,'GAIN   ',tcolor);  {none of the above, so must be gain}

  xswrite(1,2,scale+00,3,tcolor);
  xswrite(1,7,scale-20,3,tcolor);
  xswrite(1,12,scale-40,3,tcolor);
  xswrite(1,17,scale-60,3,tcolor);
  xswrite(1,22,scale-80,3,tcolor);
end;

{-------------------------}
Procedure dispcurve;
var da,db,xa,xb,ya,yb,x,i,dd : integer;
const lm = 32;  {left margin on graph}
  function GetPoint(i:integer):integer;
  var k : integer;
  begin
    k := i;
    while (pary1[k] = NoShow) and (k < 79) do
      inc(k);
    GetPoint := pary1[k];
  end;
begin
  i := 12; {start with 100hz plot}
  x := 0;
  while (pary1[i] = NoShow) and (i < 79) do
  begin
    inc(i);
    inc(x);
  end;
  repeat
    da := GetPoint(i);
    db := GetPoint(i+1);
    if not(da = NoShow) then
      da := poff - (da div 50);
    if not (db = NoShow) then
      db := poff - (db div 50);
    if da < 0 then
      dd := da;

    ya := pary2[i];
    yb := pary2[i+1];
    pary2[i] := da;
    xa := xtab[x]+lm;
    xb := xtab[x+1]+lm;
    i := i + 1;
    x := x + 1;
    if xa = xb then   { skip next when xa = xb }
    begin
      i := i + 1;
      x := x + 1;
    end;
    if not((xa = NoShow) or (xb = NoShow)) then
      dodraw(xa,ya,xb,yb,BackColor,0); {undraw}
    if not((da = NoShow) or (db = NoShow)) then
      dodraw(xa,da,xb,db,ccolor,0); {draw new one}
  until x > 78;
  pary2[i] := db;
  miscinfo;
end;


{--------------------------------------------}
{set the arrays at start up to a known value}

procedure clrarys;
var i : integer;
begin
  for i := 1 to 100 do pary1[i] := 2000;
  pary1[2] := 89;
  for i := 1 to 100 do pary2[i] := 2000;
  pary2[2] := 89;

  for i := 1 to 100 do raryx[i] := 2000;
  raryx[2] := 89;
end;

{-----------------------------------------------}
{main program starts here}

begin
  comport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
      '2': comport := 1;
      '3': comport := 2;
      '4': comport := 3;
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,Irqn,Err);
              if (IrqN > 15) or (Err <> 0) then IrqN := 0;
           end;
    end;
    dec(Pcnt);
  end;

  debug := true;
  if not(initRS232) then Halt(1);
  if not(startgraph) then
  begin
    CloseRS232;
  end;

  fillchar(pary1,sizeof(pary1),0);
  scale := 120;
  clrarys;

  icnt := 0;
  repeat

    dobox;        {put the fixed stuff on the screen}

   {xywrite(6,2,'----------',black);}
    if sendcmd(25,1,0) then   {ask for curve 0}
    begin
      if getresponse then   {get the response}
      begin
   {xywrite(1,10,fstr(icnt),white);}
       inc(icnt);
       findscale;            {figure out scaling}
       dispcurve;   {now show the curve}
      end;
    end;
  until keypressed;     {if key pressed abort the program}

  Closegraph;
  CloseRS232;
  while keypressed do
    if readkey = #0 then {nop};
end.
