unit D2form;
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,DCunit, StdCtrls;

type
  TForm1 = class(TForm)
    PaintBox: TPaintBox;
    Timer1: TTimer;
    Label1: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
     MemImage : TBitmap;
     procedure RefreshBitMap;
     procedure WritePixel(x,y:integer; c:tcolor);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.RefreshBitMap;
begin
  Form1.PaintBox.Canvas.CopyMode := cmSrcCopy;
  Form1.PaintBox.Canvas.StretchDraw(Form1.PaintBox.Canvas.ClipRect,Form1.MemImage);
end;

procedure TForm1.WritePixel(x,y:integer; c:tcolor);
begin
   memimage.canvas.pixels[x,y] := c;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Timer1.Enabled := false;
  KillMe := true;
  while IamBusy do
    application.processmessages;
  CloseRS232;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadFryers;
//  Application.OnIdle := AppIdle;
  form1.MemImage := TBitmap.Create;
  form1.MemImage.Width := Form1.PaintBox.Width;
  form1.MemImage.Height := Form1.PaintBox.Height;
  Timer1.Enabled := true;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 // FreeFryers;
  form1.MemImage.free;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if IamBusy then Exit;
  if not DoMe then Close;
end;


procedure TForm1.FormPaint(Sender: TObject);
begin
  RefreshBitmap;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  RefreshBitMap;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
   Refreshbitmap;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #$1B) or (Key = ^C) then
    Close;
end;

end.
