{ FRYERSDB.PAS  Adapted from software by Michael Day - 06/28/89 }
{ MODIFIED 11/9/92 GJF}
{ Modified 11/12/92 GJF}
{ Adapted by Brian D. Woodruff 1-1-92 }
{ modified 3/16/93 GJF}
{ added label code-set label proc, moded sendcmd, added pollchk}
{ adapted for general use 10/14/94 by Michael Day }

{ Earlier versions Copyright 1987,1989 Frye Electronics, Inc. }
{ Earlier versions Copyright 1992 Argosy Electronics, Inc. }
{ This release Copyright 1994 Frye Electronics, Inc. }
{ Frye Instrument Packet Protocol interface program - FRYERS.COM }
{ this version for Turbo Pascal V6.0 or V7.0}
{ NOTE - you *must* have a recent version (1992 or later) }
{ of FRYERS.COM loaded in the computer to use this program  }

{ Note: this is a real mode only program. It is intended to be }
{ loaded into a Dbase/Foxbase program as a BIN file. It cannot be }
{ run as a separate DOS program. You must use the MAKEBIN program }
{ to convert the resulting EXE into the required BIN file for Dbase use.}

{program directives}

{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I-}    {I/O checking off}
{$N-}    {No numeric coprocessor}
{$M 4096,0,0} {set size of stack and heap}
{$S-}    {stack checking off}
{$F+}    {Allocate as Far}

program realtimecurve;

Uses   Dos, BinIpc;
{ Point is table of freq amplitudes collected from the FP40/6500 data }
CONST
       POINT : array[3..53] of integer =
     ((12), { 200Hz}
      (13), { 300Hz}
      (14), { 400Hz}
      (15), { 500Hz}
      (16), { 600Hz}
      (17), { 700Hz}
      (18), { 800Hz}
      (19), { 900Hz}
      (20), {1000Hz}
      (21), {1100Hz}
      (22), {1200Hz}
      (23), {1300Hz}
      (24), {1400Hz}
      (25), {1500Hz}
      (26), {1600Hz}
      (27), {1700Hz}
      (28), {1800Hz}
      (29), {1900Hz}
      (30), {2000Hz}
      (31), {2100Hz}
      (32), {2200Hz}
      (33), {2300Hz}
      (34), {2400Hz}
      (35), {2500Hz}
      (36), {2600Hz}
      (37), {2700Hz}
      (38), {2800Hz}
      (39), {2900Hz}
      (40), {3000Hz}
      (41), {3100Hz}
      (42), {3200Hz}
      (43), {3300Hz}
      (44), {3400Hz}
      (45), {3500Hz}
      (46), {3600Hz}
      (47), {3700Hz}
      (48), {3800Hz}
      (49), {3900Hz}
      (50), {4000Hz}
      (52), {4200Hz}
      (55), {4500Hz}
      (57), {4700Hz}
      (60), {5000Hz}
      (63), {5300Hz}
      (66), {5600Hz}
      (69), {6000Hz}
      (70), {6300Hz}
      (72), {6700hZ}
      (73), {7100Hz}
      (74), {7500Hz}
      (75));{8000hZ}

       comport : word = 0;  {COM port to use - 0 or 1 }
       version : word = 0;

TYPE
       string2 = string[2];
       string4 = string[4];
       string20 = string[20];
       sarray  = array[1..10] of integer;
       parray  = array[1..300] of integer;

VAR
       J    : integer;
       sary : sarray;
       rary : parray;
       Dbs  : string;
       TPtr : pointer;
       ts   : string[4];
       rax  : word;
       rbx  : word;
       rcx  : word;
       rdx  : word;
       Err  : integer;

{----------------------------------------------------}
const Hex : array[0..15] of char = '0123456789ABCDEF';

{convert a byte to hex}
function HexByte(B:byte):string2;
begin
  Ts[0] := #2;
  Ts[1] := Hex[B shr 4];
  Ts[2] := Hex[B and 15];
  HexByte := Ts;
end;

{convert a word to hex}
function HexWord(W:word):string4;
Begin
  Ts[0] := #4;
  Ts[1] := Hex[hi(W) shr 4];
  Ts[2] := Hex[hi(W) and 15];
  Ts[3] := Hex[lo(W) shr 4];
  Ts[4] := Hex[lo(W) and 15];
  Hexword := Ts;
end;

{--------------------------------------------}
{ Convert an Integer type to a four character string }

function Int4Str(i: integer): string4;
begin
  Int4Str := '    ';
  if i <> $8000 then Exit;  {if invalid value, exit}
  if i > 9999 then          {clip value to four digit range}
    i := 9999
  else if i < -999 then
    i := -999;
  Str(i:4, ts);             {pad to 4 positions}
  Int4Str := ts;
end;



{-----------------------------------------------------------------}
{ This procedure enables the RS232 port1 for use with the software. }

Procedure InitRS232;
begin
   asm
     mov ax,$ff00   {disable fryers interrupt procedure}
     mov cx,$ff00 {this makes sure everything is kosher}
     mov dx,[comport]
     INT $14
     mov ax,$ff00 {enable fryers interrupt procedure}
     mov cx,$ffff
     mov dx,[comport]
     INT $14
     mov ax,$ff10 {enable fryers packet protocol}
     mov cx,$ffff
     mov dx,[comport]
     INT $14
     mov ax,$FFFF {check on version number}
     mov dx,[comport]
     INT $14
     mov [version],ax
     mov ax,$00e3 {init to 9600 baud, no parity, 8 data bits}
     mov dx,[comport]
     INT $14
   end;
end;

{-----------------------------------------------------------------------}
{ calls for a pollcheck}


{Initialize port and wait five seconds for valid polls}
{if no valid polls after ten seconds } 
procedure PollCheck;
begin
  asm
    mov ax,$ffff
    mov dx,0
    int $14
    mov [rax],ax
    mov [rdx],dx
  end;
  if rdx <> $ffff then
  begin
    Dbs := 'NODRIVER';     {fryers driver not installed}
    Exit;
  end;
  if (lo(rax) < $27) or (lo(rax) > $99) then
  begin
    Dbs := 'BADVERSION';   {won't work with this fryers version}
    Exit;
  end;

  initRS232;
  asm
    mov ax,$ff17  {clear timeout register}
    mov dx,[comport]
    mov cx,$03ff  {counts in 55ms increments}
    mov bx,0
    int $14
  end;

  while true do
  begin
    asm
      mov ax,$ff13
      mov dx,[comport]
      int $14
      mov [rax],ax
      mov [rcx],cx
    end;
    if (rcx and $01 = $01) then
    begin
      Dbs := 'POLLOK';      {it works!}
      Exit;
    end;
    if (rax and $0040 = $0040) then
    begin
      Dbs := 'NOPOLL';      {6500 ain't talking}
      Exit;
    end;
    asm
      mov ax,$ff17       {check timeout register}
      mov dx,[comport]
      mov cx,$0300
      int $14
      mov [rbx],bx
    end;
    if rbx > 200 then   {more than ten seconds gone by?}
    begin
      Dbs := 'TIMEOUT';     {Eek! something is seriously wrong}
      Exit;
    end;
  end;
end;

{-----------------------------------------------------------------------}
{ waits for int14 to be ready to accept send cmd}

Procedure Sendwait;
begin
   repeat
     asm
       mov ax,$0ff13
       mov dx,[comport]
       INT $14
       mov [rax],ax
     end;
   until (rax and $0001) <> 0;
end;

{-----------------------------------------------------------------------}
{ Modifies the printed label in the 6500}

procedure SetLabel;
var i,k : word;
begin
  Sary[1] := 66;               {set label cmd}
  Sary[2] := 112;              {length of cmd (in words)}
  move(Dbs[1],sary[3],224);
  for i := 0 to 111 do
  begin
    k := i+3;
    Sary[k] := Swap(Sary[k]);  {make it Motorola format}
    if i mod 28 = 27 then
      Sary[k] := Sary[k] and $ff00;  {null terminate the strings}
  end;
end;

{-----------------------------------------------------------------------}
{ sends a cmd to target via the rs232 port}

Procedure sendcmd(command : string);
begin
  sendwait;
  val(copy(command, 1,4),sary[1],err);  {cmd}
  val(copy(command, 5,4),sary[2],err);  {len}
  if sary[1] <> 66 then
  begin
    val(copy(command, 9,4),sary[3],err); {data1}
    val(copy(command,13,4),sary[4],err); {data2}
    val(copy(command,17,4),sary[5],err); {data3}
    val(copy(command,21,4),sary[6],err); {data4}
    val(copy(command,25,4),sary[7],err); {data5}
    val(copy(command,29,4),sary[8],err); {data6}
  end
  else
  begin
    setlabel;
  end;
  Tptr := @sary;
  asm
    push ds
    mov dx,[comport]
    lds bx,[tptr]
    mov ax,$ff11
    INT $14
    pop ds
  end;
end;

{-----------------------------------------------------------------------}
{ waits for response from target}

Procedure Rspwait;
begin
  repeat
    asm
      mov ax,$0ff13
      mov dx,[comport]
      INT $14
    end;
  until (rax and $0001) = 1;
end;

{-----------------------------------------------------------------------}
{ gets a response packet of integers from the rs232 port1. }

Procedure getresponse;
begin
  rspwait;
  tptr := @rary;
  asm
    push ds
    mov ax,$ff12
    mov dx,[comport]
    lds bx,[tptr]
    INT $14
    pop ds
  end;
end;

{-----------------------------------------------}
{pads out string to make same length as input string}

procedure Pad(var S:string);
begin
  while length(S) < pred(sizeof(S)) do
  begin
    inc(S[0]);
    S[length(S)] := ' ';
  end;
end;


{-----------------------------------------------}
{main program starts here}

label Done;
begin
  if IPC = nil then
  begin
    writeln('Hey, you''re trying to run this from DOS. No can do.');
    halt(1);
  end;
  BinLoadCheck;
  if GetDbString(Dbs) then
  begin
    val(copy(Dbs,1,4),sary[1],sary[9]);
    if (sary[1] < 1000) or (sary[1] > 4000) then
    begin
      initrs232;
      sendcmd(Dbs);      {send database command string to device}
      getresponse;       {get the response}
    end;

    {get default response}
    DbsLen := length(Dbs);
    Dbs := hexword(rary[1]);  {Clear old Dbs; store status word to output}

    {check for data response type message}
    case sary[1] of

      {single absolute return values}
      18,19,22,23,24,26,27,29,30,33,34,35,
      36,37,39,40,44,45,46,49,53,55,58,60,63,71:  {no div 10}
      begin
        for J := 2 to 44 do
          Dbs:=Dbs+Int4Str(rary[J]);
      end;

      20,21,31,32,42,51:       {Div 10}
      begin
        for J := 2 to 44 do
          Dbs:=Dbs+Int4Str(rary[J] div 10);
      end;

      28:                      {Hexword}
      begin
        for J := 2 to 44 do
          Dbs := Dbs + hexword(rary[J]);
      end;

      {get curve frame}
      25:                      {curve frame}
      begin
        Dbs := Dbs + Int4Str(rary[8] div 10);
        for j := 3 to 53 do
          Dbs := Dbs + Int4Str(rary[POINT[J]  ] div 10); {51 freq points}

        Dbs := Dbs + Int4Str(rary[77] div 10);  {harmonic dist's}
        Dbs := Dbs + Int4Str(rary[80] div 10);
        Dbs := Dbs + Int4Str(rary[88] div 10);
        KillNeg := false;
      end;

      {check if instrument is out there}
      2000:
      begin
        PollCheck;
        goto Done;
      end;

      {decompose ansi blob}
      2001:                    {ANSI curve 1 from BLOB}
      begin
        Dbs := '0256' + Int4Str(rary[8+103] div 10);
        for j := 3 to 53 do
          Dbs := Dbs + Int4Str(rary[POINT[J]+103] div 10); {51 freq points}

        Dbs := Dbs + Int4Str(rary[198] div 10);  {harmonic dist's}
        Dbs := Dbs + Int4Str(rary[199] div 10);
        Dbs := Dbs + Int4Str(rary[200] div 10);
        KillNeg := true;
      end;


      2003:                     {ANSI curve 3 from BLOB}
      begin
        Dbs := '0256' + Int4Str(rary[13+8] div 10);
        for j := 3 to 53 do
          Dbs := Dbs + Int4Str(rary[POINT[J]+13] div 10); {51 freq points}

        Dbs := Dbs + Int4Str(rary[77+13] div 10);   {harmonic dist's}
        Dbs := Dbs + Int4Str(rary[80+13] div 10);
        Dbs := Dbs + Int4Str(rary[88+13] div 10);
        KillNeg := true;
      end;

      2004:                                     {ANSI IO data}
      begin
        Dbs :=   Int4Str(rary[205]   div 10);
        for j := 2 to 9 do
          Dbs := Dbs + Int4Str(rary[204+j] div 10);
        KillNeg := true;
      end;

      2005:                                     {ANSI OT data}
      begin
        Dbs := '0000';                        {MPO max SPL value}
        Dbs := Dbs +Int4Str(rary[105] div 10);    {SSPL90}
        Dbs := Dbs +Int4Str((rary[105]-1700) div 10); {Intended RTG}
        Dbs := Dbs +Int4Str(rary[106] div 10);    {HF avg FOG}
        Dbs := Dbs +Int4Str(rary[ 13] div 10);    {FOG input level}
        Dbs := Dbs +Int4Str(rary[ 16] div 10);    {Actual RTG}
        Dbs := Dbs +Int4Str(rary[203] div 10);    {EIN}
        Dbs := Dbs +Int4Str(rary[ 14] div 10);    {Telecoil Meas.}
        Dbs := Dbs +'0000';                         {Maximum FOG}
        Dbs := Dbs +Int4Str(rary[195] div 10);    {resp limit}
        Dbs := Dbs +'0000';                         {FOG Freq}
        Dbs := Dbs +Int4Str(rary[214]);           {Att time}
        Dbs := Dbs +Int4Str(rary[215]);           {Rel time}
        Dbs := Dbs +Int4Str(rary[201]);           {Batt Curr}
        if rary[202]=3
        then Dbs := Dbs +Int4Str(0)                {Batt Type}
        else Dbs := Dbs +Int4Str(rary[202]);
        Dbs := Dbs +'0000';                         {MPO Freq}
        Dbs := Dbs +Int4Str(rary[196]);           {F1}
        Dbs := Dbs +Int4Str(rary[197]);           {F2}
        KillNeg := true;
      end;
      2006:                     {ANSI ET data}
      begin
      end
    else {case}
        for J := 2 to 44 do
          Dbs:=Dbs+Int4Str(rary[J] div 10);
    end; {case sary[1] of}
  end;

  {do post cleanup on data string}
  for i := 1 to length(Dbs) do
  begin
    if Dbs[i] = ' ' then Dbs[i] := '0';  {convert blanks to zeros}
    if KillNeg and (Dbs[i] = '-') then
      Dbs[i] := '0';                     {convert '-' to zeros if kill neg}
  end;

Done:
  Pad(Dbs);                              {fill out the string with blanks}
  if SetDbString(DbS) then {nop};
end.
