
{ TP4CURVE.PAS   writen by Michael Day - 06/28/89; rev 04/02/97-med}
{ Copyright 1987,1989,1997 Frye Electronics, Inc. }
{ Sample Turbo Pascal program to show usage of the }
{ Frye Instrument Packet Protocol interface program - FRYERS.COM }
{ this version for Turbo Pascal V4.0, V5.0, V5.5}
{ NOTE - you *must* have the latest version (1987 or later) }
{ of FRYERS.COM loaded in the computer to use this program  }
{ Original program - development time - 20 hours }

{program directives}

{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}
{$S-}

program realtimecurve;

Uses
  Crt,  Dos,  Graph3;

CONST
       tcolor = 3  ;  {text color}
       bcolor = 2  ;  {box color}
       ccolor = 1  ;  {curve color}
       black = 0   ;  {background color}
       comport = 0 ;  {COM port to use - 0 or 1 }
       cltype = 0  ;  {0=dot/x, 1=x&y, 2=x&y smoothed}

       {this plots the vertices to draw the graph with}
       xtab : array [0..79] of integer =
           (0, 36, 57, 72, 84, 93,102,108,114,120,
          125,129,134,137,141,144,148,151,153,156,
          159,161,163,165,168,170,172,173,175,177,
          179,180,182,184,185,187,188,189,191,192,
          193,195,196,197,198,199,200,202,203,204,
          205,206,207,208,209,210,210,211,212,213,
          214,215,216,216,217,218,219,219,220,221,
          222,222,223,224,225,225,226,227,227,228);

TYPE
       string2 = string[2];
       string4 = string[4];
       sarray = array[1..200] of integer;
       parray = array[1..1200] of integer;
       cpuregs = Registers;
VAR
       regs : cpuregs;
       sary : sarray;
       raryx : parray;
       pary1 : parray;
       pary2 : parray;
       debug : boolean;
       ts,scale,poff : integer;

{poff = offset used to plot starting at bottom of box}
{scale = used to print numbers on left of box}

{----------------------------------------------------}
{convert a byte to hex}
function HexString(Byt : byte) : string2;
const
  Hex : array[0..15] of char = '0123456789ABCDEF';
begin
  HexString := Hex[Byt shr 4] + Hex[Byt and 15];
end; { HexString }

{convert a word to hex}
function hexword(wrd:integer):string4;
Begin
  Hexword := hexstring(wrd shr 8) + hexstring(wrd and $ff);
end;

{-----------------------------------------------------------------}
{this displays debug informaton while waiting for response}

procedure showregs(regs:cpuregs);
begin
   if debug then
   begin
     gotoxy(34,19);
     write('STATUS');
     gotoxy(34,20);
     write('AX:',hexword(regs.ax));
     gotoxy(34,21);
     write('BX:',hexword(regs.bx));
     gotoxy(34,22);
     write('CX:',hexword(regs.cx));
     gotoxy(34,23);
     write('DX:',hexword(regs.dx));

     gotoxy(6,2);
      if (regs.ax and $0040) <> 0 then write('NO POLL') else
       if (regs.ax and $ff9c) <> 0 then write('ERROR  ');
   end;
end;

{-----------------------------------------------------------------------}
{ set screen to graphic mode}
procedure initgraph;
begin
  textcolor(tcolor);
  graphcolormode;
  graphbackground(black);
end;

{-----------------------------------------------------------------------}
{ This procedure enables the RS232 port1 for use with the software. }

function InitRS232:boolean;
VAR   regs : cpuregs;
begin
  InitRS232 := false;
     regs.dx := 0;
     regs.ax := $ffff;
     INTR($14,Dos.Registers(regs));
     if (regs.dx <> $ffff) or (regs.ax < $20) then
     begin
       textmode(2);
       writeln('Cannot run program, FRYERS.COM not loaded');
       Exit;
     end;

     regs.ax := $ff00; {disable fryers interrupt procedure}
     regs.cx := $ff00; {this makes sure everything is kosher}
     regs.dx := comport;
     INTR($14,Dos.Registers(regs));
     regs.ax := $ff00; {enable fryers interrupt procedure}
     regs.cx := $ffff;
     regs.dx := comport;
     INTR($14,Dos.Registers(regs));
     regs.ax := $ff10; {enable fryers packet protocol}
     regs.cx := $ffff;
     regs.dx := comport;
     INTR($14,Dos.Registers(regs));
     regs.ax := $FFFF; {check on version number}
     regs.dx := comport;
     INTR($14,Dos.Registers(regs));
     if regs.al > $20 then   {in version 20 can't do autobaud}
     begin
       regs.ax := $00f3; {init to 9600 baud, no parity, 8 data bits}
       regs.dx := comport;    {with autobaud}
       INTR($14,Dos.Registers(regs));
     end
     else
     begin
       regs.ax := $00e3; {init to 9600 baud, no parity, 8 data bits}
       regs.dx := comport;    {no autobaud}
       INTR($14,Dos.Registers(regs));
     end;
  InitRS232 := true;
end;

procedure CloseRS232;
begin
  regs.ax := $ff00; {disable fryers interrupt procedure}
  regs.cx := $ff00; {this makes sure everything is kosher}
  regs.dx := comport;
  INTR($14,Dos.Registers(regs));
end;

{-----------------------------------------------------------------------}
{ waits for int14 to be ready to accept send cmd}

function Sendwait:boolean;
VAR  regs : cpuregs;
begin
  SendWait := false;
   repeat
     regs.ax := $0ff13;
     regs.dx := comport;
     INTR($14,Dos.Registers(regs));
     if KeyPressed then Exit;
   until ((regs.ax and $0001) <> 0);
  SendWait := true;
end;

{-----------------------------------------------------------------------}
{ sends a cmd to target via the rs232 port}

Procedure sendcmd(scmd,scnt,sdat:integer);
VAR  regs : cpuregs;
begin
  if sendwait then
  begin
    sary[1] := scmd;
    sary[2] := scnt;
    sary[3] := sdat;
    regs.dx := comport;
    regs.ds := seg(sary);
    regs.bx := ofs(sary);
    regs.ax := $ff11;
    INTR($14,Dos.Registers(regs));
  end;
end;

{-----------------------------------------------------------------------}
{ waits for response from target}

function Rspwait:boolean;
VAR  regs : cpuregs;
begin
   RspWait := false;
   repeat
     regs.ax := $0ff13;
     regs.dx := comport;
     INTR($14,Dos.Registers(regs));
     showregs(regs);
     if KeyPressed then Exit;
   until (regs.ax and $0001) = 1;
   Rspwait := true;
end;

{-----------------------------------------------------------------------}
{ gets a response packet of integers from the rs232 port1. }

Procedure getresponse;
VAR  regs : cpuregs;
     i : integer;
begin
  if rspwait then
  begin
    regs.ax := $ff12;
    regs.dx := comport;
    regs.ds := seg(raryx);
    regs.bx := ofs(raryx);
    INTR($14,Dos.Registers(regs));
    for i := 1 to 100 do
      pary1[i] := raryx[i]; { convert rsp to plot format}
    raryx[2] := 0;
  end;
end;

{--------------------------------------------}
{plot a curve on screen, clip to only within box}
procedure dodraw(a,b,c,d,color:integer);
var  x1,y1,x2,y2,x,y,xstep,ystep,deltax,deltay,direction : integer;
begin
  x1 := a;
  x2 := c;
  if b > 185 then y1 := 185 else if b < 1 then y1 := 1 else y1 := b;
  if d > 185 then y2 := 185 else if d < 1 then y2 := 1 else y2 := d;
  x := x1;
  y := y1;
  if x1 = x2 then xstep := 0
  else
    if x1 > x2 then xstep := -1
    else
      xstep := 1;
  if y1 = y2 then ystep := 0
  else
    if y1 > y2 then ystep := -1
    else
      ystep := 1;
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax = 0 then direction := -1
  else
    direction := 0;
  plot(x,y,color);   {plot first dot}

  repeat
    if direction < 0 then
    begin
      y := y + ystep;
      direction := direction + deltax;
      if ((direction >= 0) or (cltype > 0)) then
        plot(x,y,color);
    end
    else
    begin
      x := x + xstep;
      direction := direction - deltay;
      if ((direction >= 0) or (cltype > 1)) then
        plot(x,y,color);
    end;
  until ((y = y2) and (x = x2));
end;

{----------------------------------------------------------------}
{draw the fixed stuff of the screen}

procedure dobox;
var i:integer;
begin
  draw(30,186,262,186,bcolor);
  draw(262,186,262,0,bcolor);
  draw(262,0,30,0,bcolor);
  draw(30,0,30,186,bcolor);

  for i := 1 to 18 do
  begin
    draw(25,(i*10),29,(i*10),bcolor);
  end;

  for i := 1 to 19 do
  begin
    draw((i*12)+31,187,(i*12)+31,190,bcolor);
  end;

  gotoxy(5,25);   write('.12');
  gotoxy(9,25);   write('.25');
  gotoxy(14,25);  write('.5');
  gotoxy(19,25);  write('1');
  gotoxy(24,25);  write('2');
  gotoxy(28,25);  write('4');
  gotoxy(33,25);  write('8');

  gotoxy(34,1);   write('SOURCE');
  gotoxy(34,4);   write('RMS OUT');
  gotoxy(34,7);   write('TOP SPL');
  gotoxy(34,10);  write('N.R.');
  gotoxy(34,13);  write('FLAGS');
end;

{------------------------------------------------------}
{update the numbers for the curve}

procedure miscinfo;
begin
  gotoxy(34,2);
  write('      ');
  gotoxy(34,2); {source}
  if pary1[8] = 0 then write('OFF') else write(pary1[8]);

  gotoxy(34,5);
  write('      ');
  gotoxy(34,5);   {rms out}
  write(pary1[10]);

  gotoxy(34,8);
  write('      ');
  gotoxy(34,8);    {top val}
  write(pary1[9]);

  gotoxy(34,11);
  write('      ');    {noise reduction}
  gotoxy(34,11);
  if pary1[11] = 0 then write('OFF') else write(pary1[11]);

  gotoxy(34,14);
  write('      ');
  gotoxy(34,14);   {flags a}
  write(hexword(pary1[4]));

  gotoxy(34,15);
  write('      '); {flags b}
  gotoxy(34,15);
  write(hexword(pary1[5]));
end;

{-------------------------}
{figure out what the scale is and show it on the graph}

procedure findscale;

begin
  ts := (pary1[9] div 100);
  scale := (ts div 20)*20 + 20;
  poff := (scale*2)+10;

  gotoxy(6,2);
   if (pary1[1] and $4000) <> 0 then write('BAD RSP') {unexpected response}
   else
    if pary1[4] = $0400 then write('INVALID')  {bad curve}
    else
     if (pary1[4] and $4000) = 0 then write('dBSPL  ') {power curve}
     else
       write('GAIN   ');  {none of the above, so must be gain}

  gotoxy(1,2);  write(scale+00:3);
  gotoxy(1,7);  write(scale-20:3);
  gotoxy(1,12); write(scale-40:3);
  gotoxy(1,17); write(scale-60:3);
  gotoxy(1,22); write(scale-80:3);
end;

{-------------------------}
Procedure dispcurve;
var da,db,xa,xb,ya,yb,x,i : integer;
const lm = 32;  {left margin on graph}

begin
  i := 12; {start with 100hz plot}
  x := 0;
  repeat
    da := pary1[i];
    if da <> $8000 then
      da := poff - (da div 50);
    db := pary1[i+1];
    if db <> $8000 then
      db := poff - (db div 50);
    ya := pary2[i];
    yb := pary2[i+1];
    pary2[i] := da;
    xa := xtab[x]+lm;
    xb := xtab[x+1]+lm;
    i := i + 1;
    x := x + 1;
    if xa = xb then   { skip next when xa = xb }
    begin
      i := i + 1;
      x := x + 1;
    end;
    if (ya <> $8000) and (yb <> $8000) then
      dodraw(xa,ya,xb,yb,black); {undraw}
    if (db <> $8000) and (db <> $8000) then
      dodraw(xa,da,xb,db,ccolor); {draw new one}
  until x > 78;
  pary2[i] := db;
  miscinfo;
end;

{--------------------------------------------}
{set the arrays at start up to a known value}

procedure clrarys;
var i : integer;
begin
  for i := 1 to 100 do pary1[i] := 2000;
  pary1[2] := 89;

  for i := 1 to 100 do pary2[i] := 2000;
  pary2[2] := 89;

  for i := 1 to 100 do raryx[i] := 2000;
  raryx[2] := 89;
end;

{-----------------------------------------------}
{main program starts here}

begin
  debug := true;
  if not initRS232 then
  begin
    writeln('Error: cannot open comm port');
  end;
  initgraph;

  scale := 120;
  clrarys;

  repeat
    dobox;        {put the fixed stuff on the screen}
    sendcmd(25,1,0);      {ask for curve 0}
    getresponse;   {get the response}
    findscale;            {figure out scaling}
    dispcurve;   {now show the curve}
  until keypressed;     {if key pressed abort the program}
  textmode(2);
  closers232;
end.
