unit D1form;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox: TPaintBox;
    Label1: TLabel;
    Timer1: TTimer;
    procedure FormPaint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
     MemImage : TBitmap;
     procedure RefreshBitMap;
     procedure WritePixel(x,y:integer; c:tcolor);
  end;

var
  Form1: TForm1;

implementation
uses DCunit;
{$R *.DFM}

procedure TForm1.RefreshBitMap;
begin
  Form1.PaintBox.Canvas.CopyMode := cmSrcCopy;
  Form1.PaintBox.Canvas.StretchDraw(Form1.PaintBox.Canvas.ClipRect,Form1.MemImage);
end;

procedure TForm1.WritePixel(x,y:integer; c:tcolor);
begin
   memimage.canvas.pixels[x,y] := c;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  RefreshBitMap;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  RefreshBitMap;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  RefreshBitMap;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Timer1.Enabled := false;
  KillMe := true;
  while IamBusy do
    application.processmessages;
  CloseRS232;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadFryers;
{//  Application.OnIdle := AppIdle;}
  form1.MemImage := TBitmap.Create;
  form1.MemImage.Width := Form1.PaintBox.Width;
  form1.MemImage.Height := Form1.PaintBox.Height;
  Timer1.Enabled := true;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
{ // FreeFryers;}
  form1.MemImage.free;
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #$1B) or (Key = ^C) then
    Close;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if IamBusy then Exit;
  if not DoMe then Close;
end;

end.
