// Fryers simplified interface register definitions  for C++
//-----------------File FryeRegx.h-------------------------------
#ifndef FryeRegxH
#define FryeRegxH
#pragma pack(push, 1)   //make sure data is byte aligned

//simple limited register structure to use with Fryers
//for use with compilers that cannot handle anon. 
//You will have to modify your code, to deal with the new structure.
//All this does is eliminate the union from the preferred FryeRegs.h
//structure. In most cases you just have to change references from
//AX to EAX. Fryers only uses 32bit values for pointers.
//For byte values in the AL, AH, CL, CH, etc.. registers you will
//have to build your self using shift and or instructions, or build
//a union structure that is supported by your compiler. 
//Note: these are 32 bit values 
//*NOT* 16bit as with the 16 bit version of Fryers.
//* WARNING* You *MUST* compile this with BYTE alignment.
//  failure to use byte alignment may cause all sorts of problems.
//This structure shown below is the core structure used by the Fryers
//dll to pass data between itself and the calling program. 
struct F_RegsType { 
  int EAX;
  int EBX;
  int ECX;
  int EDX;
  int EDI;
  int ESI; 
};//end_struct
#pragma pack(pop)  //restore default alignment method
#endif  //FryeRegxH

