unit SimpleU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, MMSystem;

type
  TForm1 = class(TForm)
    GoButton: TButton;
    VerLabel: TLabel;
    FstrLabel: TLabel;
    TestType: TRadioGroup;
    CmdTimeLabel: TLabel;
    Label1: TLabel;
    procedure GoButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

const Running : boolean = false;
const PortInitialized : boolean = false;
const ComPort : integer = 0;
const Qterm : boolean = false;
var ThisPort : integer = 0;
var KillMe : boolean = false;

{$I FRYEREGS.INC}
  const LibHandle : integer = 0;
  var CallFryers : procedure(var FIregs:F_RegsType); stdcall;

implementation
{$R *.DFM}

type str255 = string[255];
const hex : array[0..15] of char = (
  '0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

const MaxSize = 2000;
const FVersion : string = 'Fryers V??.?';
const FryersStr : string = 'Fryers Driver';
type PAtype = packed array[0..MaxSize] of word;
type PAtypeP = ^PAtype;
var RcvData : PAtype;
var SndData : PAtype;
//var SendArray : packed array[0..MaxSize] of integer;
//var RcvArray : packed array[0..MaxSize] of integer;


const VerCmd : array[0..1] of word = (
         $001C,  {;Version command (28)}
	 $0000);
const StatusCmd : array[0..1] of word = (
         $0021,  {;Version command (33)}
	 $0000);
const AudVerCmd : array[0..1] of word = (
         $101C,  {;audiometer Version command ($1000+28)}
	 $0000);
const AudStatusCmd : array[0..1] of word = (
         $1021,  {;audiometer Version command ($1000+33)}
	 $0000);

const GetCrvCmd : array[0..2] of word = (
         $0019,  {;get curve command (25)}
	 $0001,
         $0000);
const GetPanelCmd : array[0..1] of word = (
         $1006,  {;get panel command (?)}
         $0000);
const SetPollDelayCmd : array[0..2] of word = (
         $0049,  {;set poll delay command (73)}
	 $0001,
         50);
const GetPollDelayCmd : array[0..1] of word = (
         $004A,  {;Get poll delay command (74)}
	 $0000);
const QTCmd : array[0..1] of word = (
         $7FFF,  {;do quick terminate (32767)}
	 $0000);


  {we use the dynamic dll load method so that we can catch the Error}

  {try to load fryers32.dll}
  {returns false if cannot find Fryers}
  {this is only used in 32 bit mode}
  function LoadFryers:boolean;
  begin
    LoadFryers := true;
    if LibHandle > 0 then Exit;
    LoadFryers := false;
    LibHandle := LoadLibrary('fryers32.dll');
    if LibHandle < 32 then
    begin
      showmessage('Unable to load fryers32.dll');
      Exit;
    end;
    @CallFryers := GetProcAddress(LibHandle,'CallFryers');
    if @CallFryers = nil then
    begin
      showmessage('Failed to lookup CallFryers');
      Exit;
    end;
    LoadFryers := true;
  end;

function FreeFryers:boolean;
begin
   FreeFryers := false;
   if LibHandle <= 0 then Exit;
   FreeLibrary(LibHandle);
   FreeFryers := true;
end;

function str2d(V:integer):string;
var t : string;
begin
  T := inttostr(V div 100)+'.';
  if v mod 100 > 9 then
    T := T+inttostr(v mod 100)
  else T := T+'0'+inttostr(v mod 100);
  str2d := t;
end;
function HexB(B:integer):str255;
var s : string[8];
begin
  s[0] := char(2);
  s[1] := hex[(B shr 4) and $f];
  s[2] := hex[B and $f];
  hexb := s;
end;

function HexW(W:integer):str255;
var s : string[8];
begin
  s[0] := char(4);
  s[1] := hex[(W shr 12) and $f];
  s[2] := hex[(W shr 8) and $f];
  s[3] := hex[(W shr 4) and $f];
  s[4] := hex[W and $f];
  hexw := s;
end;

{UsePort = 1-4 for com1-com4, UseIRQ=2-15 for irq2-irq15}
function InitRS232(ThisPort:word):boolean;
var Regs : F_RegsType;
var L,i:integer;
var rbx: integer;
var T : string;
begin
   InitRs232 := false;
   if not(LoadFryers) then Exit;

   if ThisPort = 0 then ThisPort := 1;
   if ThisPort > 15 then
   begin
     MessageBox(0,'Cannot use the requested port','Fryers32 Error',MB_OK);
     Exit;
   end;
   comport := pred(ThisPort);

   Regs.dx := comport;
   Regs.ax := integer($ffff);
   CallFryers(Regs);
   FVersion := 'Fryers V'+hex[regs.al shr 4]+'.'+hex[regs.al and $f]+'0';
   if (integer(Regs.dx and $ffff) <> integer($ffff)) or (Regs.al < $40) then
   begin
     MessageBox(0,'Requested port not available','Fryers32 Error',MB_OK);
     Exit;
   end;

   Regs.ax := integer($fffe);
   Regs.bx := 0;
   Regs.dx := comport;
   Regs.cx := 0;
   Regs.si := 0;
   Regs.di := 0;
   CallFryers(Regs);
   rbx := regs.bx;
   FVersion := 'Fryers V'+str2d(rbx);
   form1.VerLabel.caption := FVersion;

   Regs.ax := integer($fffd);
   Regs.dx := comport;
   Regs.cx := 0;
   CallFryers(Regs);
   L := regs.ax-3;
   T := '';
   for i := 1 to L do
   begin
     Regs.ax := integer($fffd);
     Regs.dx := comport;
     Regs.cx := i;
     CallFryers(Regs);
     T := T+char(regs.al);
   end;
   FryersStr := T;
   form1.FstrLabel.caption := FryersStr;

   Regs.ax := integer($ff00); {disable fryers interrupt procedure}
   Regs.cx := integer($ff00); {this makes sure everything is kosher}
   Regs.dx := comport;        {-->the Packet driver *must* be disabled}
   CallFryers(Regs);          {-->before you can configure the port}

    Regs.ax := integer($ff00); {enable fryers interrupt procedure}
    Regs.cx := integer($ffff);
    Regs.dx := comport;
    CallFryers(Regs);

    Regs.ax := integer($ff10); {enable fryers packet protocol}
    Regs.cx := integer($ffff);
    Regs.dx := comport;
    CallFryers(Regs);

    Regs.ax := $00e3;  {init to 9600 baud, no parity, 8 data bits}
    Regs.dx := comport;
    CallFryers(Regs);

    if Qterm then
      Regs.CL := $FF
    else Regs.CL := $00;
    Regs.CH := $FF;
    Regs.AX := integer($FF1A);
    Regs.DX := comport;
    CallFryers(Regs);
  PortInitialized := true;
  InitRs232 := true;
end;

procedure CloseRS232;
var Regs : F_RegsType;
begin
  PortInitialized := false;
  if LibHandle = 0 then Exit;
  Regs.ax := integer($ff00); {disable fryers interrupt procedure}
  Regs.cx := integer($ff00); {this makes sure everything is kosher}
  Regs.dx := comport;
  CallFryers(Regs);
end;

function Sendwait:boolean;
var Regs:F_RegsType;
begin
  SendWait := false;
  if LibHandle = 0 then Exit;
  repeat
    if KillMe then Exit;
    Regs.ax := integer($0ff13);
    Regs.dx := comport;
    CallFryers(Regs);
//    if regs.ax and $fffc <> 0 then
//      Form1.EditAX.text := '$'+Hexw(Regs.AX);
 //   if regs.cx and $C1A0 <> 0 then
//      Form1.EditCX.text := '$'+Hexw(Regs.CX);
//      Form1.EditDX.text := '$'+Hexw(Regs.DX);
//      application.processmessages;
  until ((Regs.ax and $0001) <> 0);
  SendWait := true;
end;
function RcvWait:boolean;
var Regs : F_RegsType;
begin
  RcvWait := false;
  if LibHandle = 0 then Exit;
  repeat
    if KillMe then Exit;
    Regs.ax := integer($0ff13);
    Regs.dx := comport;
    CallFryers(Regs);
//    if regs.ax and $fffc <> 0 then
//      Form1.EditAX.text := '$'+Hexw(Regs.AX);
 //   if regs.cx and $C1A0 <> 0 then
//      Form1.EditCX.text := '$'+Hexw(Regs.CX);
//      Form1.EditDX.text := '$'+Hexw(Regs.DX);
//      application.processmessages;
  until ((Regs.ax and $0001) <> 0);
  RcvWait := true;
end;

function SendCommand(Data:PAtypeP):boolean;
var Regs : F_RegsType;
var i : integer;
var Size : integer;
begin
  SendCommand := false;
  if LibHandle = 0 then Exit;
  if not(SendWait) then Exit;
  Size := Data[1]+2;
  move(Data^,SndData,Size*2);
  if (Size >= MaxSize) or (Size < 2) then Exit;
  for i := 0 to pred(Size) do
  begin
    Regs.AX := integer($ff23);
    Regs.DX := comport;
    Regs.CX := i;
    Regs.BX := SndData[i];
    CallFryers(Regs);
  end;
  Regs.AX := integer($ff15);
  Regs.DX := comport;
  CallFryers(Regs);
  SendCommand := true;
end;

function RcvCommand:boolean;
var Regs:F_RegsType;
var Size,i : integer;
begin
  RcvCommand := false;
  if LibHandle = 0 then Exit;
  if not(RcvWait) then Exit;
  if SndData[0] <> QTcmd[0] then
  begin
    Regs.AX := integer($ff26);  {get size}
    Regs.DX := comport;
    Regs.CX := 1;
    CallFryers(Regs);
    Size := Regs.CX+2;
    if (Size >= MaxSize) or (Size < 2) then Exit;
    for i := 0 to pred(Size) do
    begin
      Regs.AX := integer($ff26);
      Regs.DX := comport;
      Regs.CX := i;
      CallFryers(Regs);
      RcvData[i] := word(Regs.DX and $ffff);
    end;
    Regs.AX := integer($ff16);
    Regs.DX := comport;
    CallFryers(Regs);
  end;

//  if (RcvData[0] and integer($FFFF)) = NAKrsp then
//     inc(NAKCount);
//  if (RcvData[0] and integer($FFFF)) = ACKrsp then
//     inc(ACKCount);
//  if (RcvData[0] and integer($FFFF)) = ILLrsp then
//    inc(ILLCount);
//  if (RcvData[0] and integer($FFFF)) = POLrsp then
//    inc(POLCount);
//  RcvCommand := true;
end;


procedure DoRepeatCmd;
var Ps:PATypeP;
begin
//  form1.Spinner(form1.LoopSpinLabel,form1.LSpin);
  Ps := nil;
  case form1.TestType.itemindex of
   0: PS := nil;
   1: Ps := @QTcmd;
   2: Ps := @StatusCmd;
   3: Ps := @VerCmd;
   4: Ps := @GetCrvCmd;
   5: Ps := @GetPanelCmd;
   6: Ps := @AudVerCmd;
   7: Ps := @AudStatusCmd;
  end;
  if ps = nil then Exit;
  if SendCommand(ps) then
  begin
    if not(RcvCommand) then {nop};
  end
end;

procedure TForm1.GoButtonClick(Sender: TObject);
var Start,Stop:integer;
begin
   If Running then
   begin
     Running := false;
     Exit;
   end;
   GoButton.caption := 'Stop';
   Running := true;
   if not(PortInitialized) then
   begin
     if not InitRs232(ThisPort) then
     begin
       ShowMessage('Unable to initialize selected port:'+inttostr(ThisPort));
       Running := false;
       Exit;
     end;
   end;
   while Running do
   begin
     Start := timeGetTime;
     DoRepeatCmd;
     Stop := timeGetTime;
     CmdTimeLabel.caption := inttostr(Stop-Start);
     application.processmessages;
   end;
   GoButton.Caption := 'Go';
   Running := false;
end;

end.
