Attribute VB_Name = "VBCunit"
#If Win16 Then
  Declare Function timeGetTime Lib "MMSYSTEM" () As Long
#End If
#If Win32 Then
  Declare Function timeGetTime Lib "winmm.dll" () As Long
#End If

Rem VBCURVE.BAS  writen by Michael Day - 07/07/00
Rem Copyright 1987,2000   Frye Electronics, Inc.
Rem Sample Visual Basic program to show usage of the
Rem Frye Instrument Packet Protocol interface program
Rem  16bit version requires FRYERS16.DLL + FRYERSCOM
Rem  32bit version requires FRYERS32.DLL
Rem  NOTE - you *must* have the latest version (1997 or later)
Rem  of FRYERS.COM and FRYERS16.DLL loaded to use 16bit version
Rem Program derived from Turbo Pascal version
Rem this sample works for 16bit or 32bit version of Visual Basic


Public Const comport = 0 'Rem  {COM port to use - 0 or 1 }
Public Const Dodebug = True 'Rem init stuff
Public Const TIMEOUT = 1000 'Rem mS to wait before giving up
Public Const NoShow = -32768 'non-data point

  Public hexwrd As Long
  Public poff As Integer
  Public BoxScale As Integer
  Public Xm As Integer
  Public Ym As Integer
  Public IamBusy As Boolean
  Public FirstTime As Boolean
  Public FryersVersionString As String

  Public txtcolor As Long 'Rem text color
  Public boxcolor As Long 'Rem box color
  Public crvcolor As Long 'Rem curve color
  Public undcolor As Long 'Rem undraw color

  Public Const MaxFData = 1000
  Public Type F_DataType
    Sary(MaxFData) As Integer  'Rem define the xfer arrays
    Rary(MaxFData) As Integer
  End Type
  Public F_Data As F_DataType

  Dim pary(MaxFData, 2) As Integer
  Rem  DefInt A-Z


#If Win16 Then
  Public Type F_RegsType
    AX As Integer
    BX As Integer
    CX As Integer
    DX As Integer
    Di As Integer
    SI As Integer
    ES As Integer
    DS As Integer
  End Type
#End If
#If Win32 Then
  Public Type F_RegsType
    AX As Long
    BX As Long
    CX As Long
    DX As Long
    Di As Long
    SI As Long
  End Type
#End If

Public FRegs As F_RegsType

Rem {----------------------------------------------------}
Rem {convert an integer word to hex string}

Function HexWord(L As Long) As String
Dim W As Long
    W = L And &HFFFF&
    h$ = Hex$(W)
    While Len(h$) < 4
       h$ = "0" + h$
    Wend
    HexWord = h$
End Function

Rem {-----------------------------------------------------------------}
Rem {this displays debug informaton while waiting for response}

Sub ShowRegs()
    If Dodebug = False Then Exit Sub
    Xm = 8 'Form1.TextHeight("X")
    Ym = 8 'Form1.TextWidth("Y")
   
    Form1.CurrentY = ((18 - 1) * Ym): Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "STATUS";
    Form1.CurrentY = ((19 - 1) * Ym) + (Ym / 2): Form1.CurrentX = (34 - 1) * Xm
    hexwrd = FRegs.AX: Form1.Print "AX:" + HexWord(hexwrd);
    Form1.CurrentY = ((21 - 1) * Ym): Form1.CurrentX = (34 - 1) * Xm
    hexwrd = FRegs.BX: Form1.Print "BX:" + HexWord(hexwrd);
    Form1.CurrentY = ((22 - 1) * Ym) + (Ym / 2): Form1.CurrentX = (34 - 1) * Xm
    hexwrd = FRegs.CX: Form1.Print "CX:" + HexWord(hexwrd);
    Form1.CurrentY = (24 - 1) * Ym: Form1.CurrentX = (34 - 1) * Xm
    hexwrd = FRegs.DX: Form1.Print "DX:" + HexWord(hexwrd);

    Form1.CurrentY = (2 - 1) * Ym: Form1.CurrentX = (6 - 1) * Xm
    If (FRegs.AX And &HFF9C&) <> 0 Then Form1.Print "ERROR  ";
    Form1.CurrentY = (2 - 1) * Ym: Form1.CurrentX = (6 - 1) * Xm
    If (FRegs.AX And &H40&) <> 0 Then Form1.Print "NO POLL";
End Sub

Rem {------------------------------------------------}
Rem {init screen parameters}

Sub InitGraph()
  IamBusy = True
  FirstTime = True
  txtcolor = ForeColor 'Rem text color
  boxcolor = vbRed     'Rem box color
  crvcolor = vbBlue    'Rem curve color
  undcolor = BackColor 'Rem background (undraw) color
  BoxScale = 120 'Rem used to print numbers on left of box
  poff = (BoxScale * 2) + 10 'Rem offset used to plot starting at bottom of box
  IamBusy = False
End Sub

Rem {--------------------------------------------------------------------}
Rem { This procedure enables the RS232 comport for use with the software. }
Rem { we'll assume that fryers is loaded already. }

Function InitRS232()
Dim rax, rdx, Size As Long
   InitRS232 = False
    FRegs.AX = &HFFFF 'Rem {check on version number}
    FRegs.DX = comport
    CallFryers FRegs
    rax = CLng(FRegs.AX) And &HFFFF&
    rdx = CLng(FRegs.DX) And &HFFFF&
    If (rdx <> &HFFFF&) Or (rax < &H30&) Then
      InitRS232 = False
      Exit Function
    End If
    FRegs.AX = &HFFFE
    FRegs.DX = comport
    FRegs.SI = 0
    FRegs.Di = 0
    CallFryers FRegs
    FryersVersionString = "Fryers Version " + Format(FRegs.BX / 100, "###0.00")
    If rax > &H40& Then
      FRegs.AX = &HFFFD
      FRegs.DX = comport
      FRegs.CX = 0
      CallFryers FRegs
      Size = FRegs.AX
      If Size > 0 Then FryersVersionString = ""
      For i = 1 To Size
        FRegs.AX = &HFFFD
        FRegs.DX = comport
        FRegs.CX = i
        CallFryers FRegs
        FryersVersionString = FryersVersionString + Chr(FRegs.AX)
      Next i
    End If

    FRegs.AX = &HFF00 'Rem {disable fryers interrupt procedure}
    FRegs.CX = &HFF00 'Rem {this makes sure everything is kosher}
    FRegs.DX = comport
    CallFryers FRegs
    FRegs.AX = &HFF00 'Rem {enable fryers interrupt procedure}
    FRegs.CX = &HFFFF
    FRegs.DX = comport
    CallFryers FRegs
    FRegs.AX = &HFF10 'Rem {enable fryers packet protocol}
    FRegs.CX = &HFFFF
    FRegs.DX = comport
    CallFryers FRegs
    FRegs.AX = &HE3    'Rem {init to 9600 baud, no parity, 8 data bits}
    FRegs.DX = comport 'Rem {no autobaud}
    CallFryers FRegs
   InitRS232 = True
End Function
 
Rem {---------------------------------------------------------------------}
Rem { kills the fryers packets and returns the port to normal operation}
Rem *Warning* make sure you call this on your way out.
Rem  Failure to do so will cause all sorts of problems.
Sub CloseRS232()
    
  Rem  T = timeGetTime + 2000
  Rem   While timeGetTime < T
  Rem    DoEvents
  Rem  Wend
      
    
    FRegs.AX = &HFF00  'Rem {disable fryers interrupt procedure}
    FRegs.CX = &HFF00  'Rem {this makes sure everything is kosher}
    FRegs.DX = comport
    CallFryers FRegs
End Sub

Rem {---------------------------------------------------------------------}
Rem { waits for int14 to be ready to accept send cmd}
Public Function SendWait() As Integer
Dim t1, t2, rax As Long

  t1 = timeGetTime
  Do
    FRegs.AX = &HFF13
    FRegs.DX = comport
    CallFryers FRegs
    rax = CLng(FRegs.AX) And &HFFFF&
    t2 = timeGetTime
    If (t2 - t1) >= TIMEOUT Then
      Beep
      SendWait = -1  'Rem error
      Exit Function
    End If
  Loop Until (rax And &H41&) <> 0
  If (rax And &H40&) <> 0 Then
    SendWait = -2 'No poll error
    Exit Function
  End If
  SendWait = 0  'Rem success
End Function


Rem {--------------------------------------------------------------------}
Rem { sends a cmd to target via the rs232 port}
Public Function SendCmd() As Integer
Dim x, i, Counter As Integer

  Rem send the command in the buffer
  x = SendWait  'Rem wait till ready flag is set
  If x < 0 Then
    SendCmd = x
    Exit Function
  End If

  Counter = F_Data.Sary(2) + 2
  For i = 1 To Counter
    FRegs.DX = comport  'Rem indexed send buffer write
    FRegs.AX = &HFF23
    FRegs.CX = i - 1
    FRegs.BX = F_Data.Sary(i)
    CallFryers FRegs
  Next i

  FRegs.AX = &HFF15  'Rem Send the command
  FRegs.DX = comport
  CallFryers FRegs
  SendCmd = 0
End Function


Rem {------------------------------------}
Rem {wait for a reponse from target}

Function RspWait() As Integer
Dim t1, t2, rax As Long
  t1 = timeGetTime
  Do
    FRegs.AX = &HFF13
    FRegs.DX = comport
    CallFryers FRegs
    rax = CLng(FRegs.AX) And &HFFFF&
    t2 = timeGetTime
    ShowRegs
    If (t2 - t1) >= TIMEOUT Then
      Beep
      RspWait = -1  'Rem error
      Exit Function
    End If
  Loop Until (rax And &H41&) <> 0
  If (rax And &H40&) <> 0 Then
    RspWait = -2 'No poll error
    Exit Function
  End If
  RspWait = 0  'Rem success
End Function


Rem {----------------------------------------------------------------------}
Rem { gets a response packet of integers from the rs232 comport. }

Function GetResponse() As Integer
Dim x, i, rdx As Integer
Dim Counter As Long

  x = RspWait  'Rem wait till ready flag is set
  If x < 0 Then
    GetResponse = x
    Exit Function
  End If

  Rem indexed response buffer read
  FRegs.AX = &HFF26
  FRegs.DX = comport
  FRegs.CX = 1  'Rem read indexed buffer for data word count
  CallFryers FRegs
  Counter = FRegs.CX + 2  'Rem data word count
  If Counter >= MaxFData Then
    GetResponse = -1
    Exit Function
  End If
      
  For i = 1 To Counter
    FRegs.AX = &HFF26
    FRegs.DX = comport
    FRegs.CX = i - 1
    CallFryers FRegs
    rdx = FRegs.DX Mod 65536 'Rem convert to 16 bit format
    F_Data.Rary(i) = rdx
  Next i

  FRegs.AX = &HFF16
  FRegs.DX = comport
  CallFryers FRegs

  For i = 1 To Counter
    pary(i, 1) = F_Data.Rary(i) 'Rem { convert rsp to plot format}
  Next i
  F_Data.Rary(2) = 0

  GetResponse = 0
End Function


Rem {----------------------------------------------------------------}
Rem {draw the fixed stuff on the screen}

Sub DoBox()
Dim i, ii As Integer

    Xm = 8 'Form1.TextHeight("X")
    Ym = 8 'Form1.TextWidth("Y")
    Form1.FillColor = Form1.BackColor
    Form1.FillStyle = Solid
    Form1.Line (30, 0)-(262, 186), boxcolor, B
 
    'Form1.Line (30, 186)-(262, 186), boxcolor
    'Form1.Line (262, 186)-(262, 0), boxcolor
    'Form1.Line (262, 0)-(30, 0), boxcolor
    'Form1.Line (30, 0)-(30, 186), boxcolor
    For i = 1 To 18
      ii = i * 10
      Form1.Line (25, ii)-(29, ii), boxcolor
    Next i
    For i = 1 To 19
      ii = (i * 12) + 31
      Form1.Line (ii, 187)-(ii, 190), boxcolor
    Next i

    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (5 - 1) * Xm: Form1.Print ".12";
    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (9 - 1) * Xm: Form1.Print ".25";
    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (14 - 1) * Xm: Form1.Print ".5";
    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (19 - 1) * Xm: Form1.Print "1";
    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (24 - 1) * Xm: Form1.Print "2";
    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (28 - 1) * Xm: Form1.Print "4";
    Form1.CurrentY = (25 - 1) * Ym: Form1.CurrentX = (33 - 1) * Xm: Form1.Print "8";

    Form1.CurrentY = (1 - 1) * Ym: Form1.CurrentX = (34 - 1) * Xm: Form1.Print "SOURCE";
    Form1.CurrentY = (4 - 1) * Ym: Form1.CurrentX = (34 - 1) * Xm: Form1.Print "RMS OUT";
    Form1.CurrentY = (7 - 1) * Ym: Form1.CurrentX = (34 - 1) * Xm: Form1.Print "TOP VAL";
    Form1.CurrentY = (10 - 1) * Ym: Form1.CurrentX = (34 - 1) * Xm: Form1.Print "N.R.";
    Form1.CurrentY = (13 - 1) * Ym: Form1.CurrentX = (34 - 1) * Xm: Form1.Print "FLAGS";
End Sub

Rem {------------------------------------------------------}
Rem {update the numbers for the curve}

Sub MiscInfo()
    Xm = 8 'Form1.TextHeight("X")
    Ym = 8 'Form1.TextWidth("Y")

    Form1.CurrentY = ((2 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "      ";
    Form1.CurrentY = ((2 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm 'Rem {source}
    h$ = Str$(pary(8, 1))
    If Len(h$) > 1 Then h$ = Right$(h$, Len(h$) - 1)
    If pary(8, 1) = 0 Then Form1.Print "OFF"; Else Form1.Print h$;

    Form1.CurrentY = ((5 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "      ";
    Form1.CurrentY = ((5 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm 'Rem {rms out}
    h$ = Str$(pary(10, 1))
    If Len(h$) > 1 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.Print h$;

    Form1.CurrentY = ((8 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "      ";
    Form1.CurrentY = ((8 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm 'Rem {top val}
    h$ = Str$(pary(9, 1))
    If Len(h$) > 1 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.Print h$;

    Form1.CurrentY = ((11 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "      ";
    Form1.CurrentY = ((11 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm 'Rem {noise reduction}
    h$ = Str$(pary(11, 1))
    If Len(h$) > 1 Then h$ = Right$(h$, Len(h$) - 1)
    If pary(11, 1) = 0 Then Form1.Print "OFF" Else Form1.Print h$;

    Form1.CurrentY = ((14 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "      ";
    Form1.CurrentY = ((14 - 1) * Ym) + (Ym / 3): Form1.CurrentX = (34 - 1) * Xm 'Rem {flags a}
    hexwrd = pary(4, 1): Form1.Print HexWord(hexwrd);

    Form1.CurrentY = ((15 - 1) * Ym) + Ym: Form1.CurrentX = (34 - 1) * Xm
    Form1.Print "      ";
    Form1.CurrentY = ((15 - 1) * Ym) + Ym: Form1.CurrentX = (34 - 1) * Xm 'Rem {flags b}
    hexwrd = pary(5, 1): Form1.Print HexWord(hexwrd);

    'Form1.CurrentY = ((20 - 1) * Ym) + (Ym / 2): Form1.CurrentX = (1 - 1) * Xm 'rem version info
    'Form1.Print FryersVersionString
    Form1.Label1.Caption = FryersVersionString
End Sub

Rem {-------------------------}
Rem {figure out what the scale is and show it on the graph}

Sub FindScale()
Dim ts As Integer

   Xm = 8 'Form1.TextHeight("X")
   Ym = 8 'Form1.TextWidth("Y")
   ts = Int(pary(9, 1) / 100)
    BoxScale = (Int(ts / 20) * 20) + 20
    If BoxScale < 0 Then BoxScale = 0
    If BoxScale > 185 Then BoxScale = 185
    poff = (BoxScale * 2) + 10

    Form1.CurrentY = (2 - 1) * Ym: Form1.CurrentX = (6 - 1) * Xm 'Rem check if power or gain curve
    If (pary(4, 1) And &H4000&) = 0 Then Form1.Print "dBSPL   "; Else Form1.Print "GAIN   ";
    Form1.CurrentY = (2 - 1) * Ym: Form1.CurrentX = (6 - 1) * Xm
    If pary(4, 1) = &H400& Then Form1.Print "INVALID";: Rem bad curve
    Form1.CurrentY = (2 - 1) * Ym: Form1.CurrentX = (6 - 1) * Xm
    If (pary(1, 1) And &H4000&) <> 0 Then Form1.Print "BAD RSP";: Rem unexpected rsp

    h$ = Str$(BoxScale + 0)
    If Len(h$) > 3 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.CurrentY = (2 - 1) * Ym: Form1.CurrentX = (1 - 1) * Xm: While Len(h$) < 3: h$ = " " + h$: Wend: Form1.Print h$;
    h$ = Str$(BoxScale - 20)
    If Len(h$) > 3 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.CurrentY = (7 - 1) * Ym: Form1.CurrentX = (1 - 1) * Xm: While Len(h$) < 3: h$ = " " + h$: Wend: Form1.Print h$;
    h$ = Str$(BoxScale - 40)
    If Len(h$) > 3 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.CurrentY = (12 - 1) * Ym: Form1.CurrentX = (1 - 1) * Xm: While Len(h$) < 3: h$ = " " + h$: Wend: Form1.Print h$;
    h$ = Str$(BoxScale - 60)
    If Len(h$) > 3 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.CurrentY = (17 - 1) * Ym: Form1.CurrentX = (1 - 1) * Xm: While Len(h$) < 3: h$ = " " + h$: Wend: Form1.Print h$;
    h$ = Str$(BoxScale - 80)
    If Len(h$) > 3 Then h$ = Right$(h$, Len(h$) - 1)
    Form1.CurrentY = (22 - 1) * Ym: Form1.CurrentX = (1 - 1) * Xm: While Len(h$) < 3: h$ = " " + h$: Wend: Form1.Print h$;
End Sub

Rem {------------------------------------------------}
Function GetDataPoint(Di As Integer) As Integer
Dim k As Integer
  k = Di
  While (pary(k, 1) = NoShow) And (k < 79)
     k = k + 1
  Wend
  GetDataPoint = pary(k, 1)
End Function

Rem {------------------------------------------------}
Rem {display the curve we just receieved}

Sub DispCurve()
Dim y1, y2, x1, x2 As Integer
Dim xa, xb, ya, yb As Integer
Dim da, db, dd As Integer
Dim q, x, lm As Integer
Dim i As Integer
  xtab = Array( _
         0, 36, 57, 72, 84, 93, 102, 108, 114, 120, _
       125, 129, 134, 137, 141, 144, 148, 151, 153, 156, _
       159, 161, 163, 165, 168, 170, 172, 173, 175, 177, _
       179, 180, 182, 184, 185, 187, 188, 189, 191, 192, _
       193, 195, 196, 197, 198, 199, 200, 202, 203, 204, _
       205, 206, 207, 208, 209, 210, 210, 211, 212, 213, _
       214, 215, 216, 216, 217, 218, 219, 219, 220, 221, _
       222, 222, 223, 224, 225, 225, 226, 227, 227, 228)

  lm = 32: Rem  {left margin on graph}
  i = 12: Rem  {start with 100hz plot}
  x = 0

While (pary(i, 1) = NoShow) And (i < 79)
  i = i + 1
  x = x + 1
Wend

dispcloop:
  Rem get x,y points (draw and undraw)
  
  da = GetDataPoint(i)
  db = GetDataPoint(i + 1)
  If Not (da = NoShow) Then
    da = poff - (pary(i, 1) / 50)
  End If
  If Not (db = NoShow) Then
    db = poff - (pary(i + 1, 1) / 50)
  End If
  If da < 0 Then dd = da
  
  y1 = pary(i, 2)
  y2 = pary(i + 1, 2)
  pary(i, 2) = da
  x1 = xtab(x) + lm
  x2 = xtab(x + 1) + lm
  i = i + 1
  x = x + 1
  Rem skip next when xa = xb
  If x1 < x2 Then GoTo noadj
  i = i + 1
  x = x + 1
noadj:
  Rem undraw old curve
  If Not ((da = NoShow) Or (db = NoShow)) Then
 ' If Not FirstTime Then
 '   Form1.Line (X1, Y1)-(X2, Y2), Form1.BackColor 'undcolor
 '   FirstTime = False
 ' End If
  End If
  Rem now draw new curve
  Rem get new y points to draw new line with (we still have current x points)
  If Not ((da = NoShow) Or (db = NoShow)) Then
    y1 = da
    y2 = db
    Form1.Line (x1, y1)-(x2, y2), crvcolor
  End If
  
  If x < 79 Then GoTo dispcloop
  pary(i, 2) = db
  MiscInfo
End Sub

Rem {--------------------------------------------}
Rem {set the arrays at start up to a known value}

Sub Clrarys()
Dim i As Integer
    For i = 1 To 100
      pary(i, 1) = 2000
    Next i
    pary(2, 1) = 89
    For i = 1 To 100
      pary(i, 2) = 2000
    Next i
    pary(2, 2) = 89
    For i = 1 To 100
      F_Data.Rary(i) = 2000
    Next i
    F_Data.Rary(2) = 89
End Sub

Rem {----------------------------------------------------}
Rem  this is used to init things at startup
Function StartMeUp() As Boolean
  IamBusy = True
  StartMeUp = True
  Clrarys
  InitGraph
  If Not InitRS232 Then StartMeUp = False
  IamBusy = False
End Function

Rem {-----------------------------------------------}
Rem {main program starts here}

Sub DoMe()
  IamBusy = True

  F_Data.Sary(1) = 25
  F_Data.Sary(2) = 1
  F_Data.Sary(3) = 0  'Rem {ask for curve 0}
  R = SendCmd
  If R = 0 Then
    R = GetResponse
    If R = -1 Then
      Form1.Caption = "VB Sample : Rsp Error" 'Rem {failed get response}
    End If
  Else
    If R = -1 Then
      Form1.Caption = "VB Sample : Send Error"
    End If
  End If
  If R = 0 Then
    Form1.Caption = "VB Sample" 'Rem {failed get response}
  End If
  If R = -2 Then
    Form1.Caption = "VB Sample : No Poll"
  End If
  If R < -2 Then
    Form1.Caption = "VB Sample : Error unknown"
  End If
  'Form1.Cls    'Rem couldn't get undraw to work right, so just clear the form
  DoBox        'Rem draw the box on the screen
  FindScale    'Rem {figure out scaling}
  DispCurve    'Rem {now show the curve}
  ShowRegs
  IamBusy = False
End Sub

