Attribute VB_Name = "Module3"
'*NOTE: Changes from v4.0 to v4.1 file and & data structures are marked by BOLD
'Described below are :
'1. Constants & data structure needed by the DSL file functions
'2.  WriteDSL40String (needed by WriteDSL40Client)
'3.  WriteDSL40Client (Write the contents of gClient to a .DSL (v4.0) file) - No longer available in DSL.  Here for reference only.
'4.  WriteDSL41Client (Write the contents of gClient to a .DSL (v4.1) file)
'5.  ReadDSL40String (needed by OpenDSL40Client)
'6.  OpenDSL40Client (Reads the contents of a .DSL (V4.0) file and puts information in gClient)
'7.  OpenDSL41Client (Reads the contents of a .DSL (V4.1) file)
'8.  Client40To41 (Converts and adds defaults to newer fields which did not exists in 4.0)

'---------------------------
'CONSTANTS & DATA STRUCTURES
'---------------------------

'DSL Versions numbers
Global Const vExeName = "DSL"
Global Const vVerNum400 = "04.00"
Global Const vVerNum410 = "04.10"
Global Const vUserDefBeta = "BETA22"
Global Const vBeta4100 = "BT4100"

    '''''''''''''''''''''''''''''''''''''
    Global Const cEar = 1               '
    Global Const cCoupler = 2           '
    
    Global Const cLoLevel = 1           '
    Global Const cMidLevel = 2          '
    Global Const cHiLevel = 3           '
    
    Global Const cAge0_12 = 1           '
    Global Const cAge13_24 = 2          '
    Global Const cAge25_48 = 3          '
    Global Const cAge49_60 = 4          '
    Global Const cAge61_ = 5            '
    '''''''''''''''''''''''''''''''''''''

Global Const cNumFreqs = 8
Global Const c31NumFreqs = 9 'Backward compatibility
Global Const cEarLeft = 1
Global Const cEarRight = 2

'Input measures
Global Const c40Thresh = 0
Global Const c40LDL = 1
Global Const c40LF = 2
Global Const c40RECD = 3
Global Const c40REUR = 4
Global Const c40REDD = 5

'Verification input level
Global Const cInputSoft = 0
Global Const cInputAverage = 1
Global Const cInputLoud = 2
Global Const cInputMax = 3

'Transducers
Global Const cNumXducer = 8
Global Const cXducerER3 = 0
Global Const cXducerTDH = 1
Global Const cXducerLS0 = 2
Global Const cXducerLS45 = 3
Global Const cXducerLS90 = 4
Global Const cXducerDUD = 5
Global Const cXducerER3Cust = 6
Global Const cXducerRESPL = 7

'HL to SPL transform
Global Const cNumXform = 4
Global Const cXformPred = 0
Global Const cXformRECD = 1
Global Const cXformREUR = 2
Global Const cXformREDD = 3

'Hearing aid transform
Global Const cNumHAXform = 2
Global Const cHAXformPred = 0
Global Const cHAXformMeas = 1

'Spectrum type
Global Const cNumSpect = 3
Global Const cSpectDSL = 0
Global Const cSpectCM = 1
Global Const cSpectINT = 2
Global Const cSpectSOFT = 3
Global Const cSpectLOUD = 4

Global Const cNumPresc = 3
Global Const cPrescLinear = 0
Global Const cPrescWDRCFix = 1
Global Const cPrescWDRCVar = 2
                      
'Maximum output
Global Const cNumMaxO = 2
Global Const cMaxOPred = 0
Global Const cMaxOMeas = 1

'Input dynamic range
Global Const cNumIDR = 2
Global Const cIDRExt = 0
Global Const cIDRNorm = 1

'Compression type
Global Const cNumComp = 2
Global Const cIOCompLin = 0
Global Const cIOCompCurv = 1

'Compression threshold
Global Const cNumCT = 7
Global Const cCTIMin = 0
Global Const cCT40 = 1
Global Const cCT45 = 2
Global Const cCT50 = 3
Global Const cCT55 = 4
Global Const cCT60 = 5
Global Const cCT65 = 6

'Input Type
'Global Const cInputSoft = 0
'Global Const cInputAverage = 1
'Global Const cInputLoud = 2
'Global Const cInputMax = 3

'Hearing aid type - constants & strings
Global Const cNumHAType = 5
Global Const cBTE = 0
Global Const sBTE = "BTE"
Global Const cCIC = 1
Global Const sCIC = "CIC"
Global Const cITC = 2
Global Const sITC = "ITC"
Global Const cITE = 3
Global Const sITE = "ITE"
Global Const cBody = 4
Global Const sBody = "BODY AID"

'Veirification Hi-Level Measures
Global Const cNumVerHi = 2
Global Const cVerHiRE = 0
Global Const cVerHiCoup = 1

'Verification Mid-Level Measures
Global Const cNumVerMid = 4
Global Const cREOut = 0
Global Const cREGain = 1
Global Const cCoupOut = 2
Global Const cCoupGain = 3

'Verification Lo-Level measured
Global Const cNumVerLo = 3
Global Const cAz0 = 0
Global Const cAz45 = 1
Global Const cAz90 = 2

'Earmold type - constants & strings
Global Const cNumEMType = 6
Global Const cEMTypeSkel = 0
Global Const sEMTypeSkel = "SKELETON"
Global Const cEMTypeShell = 1
Global Const sEMTypeShell = "SHELL"
Global Const cEMTypeCanal = 2
Global Const sEMTypeCanal = "CANAL"
Global Const cEMTypeOpen = 3
Global Const sEMTypeOpen = "OPEN"
Global Const cEMTypeNA = 4
Global Const sEMTypeNA = "NOT SPECIFIED"
Global Const cEMTypeOther = 5

'Earmold bore - constants & strings
Global Const cNumEMBore = 7
Global Const cEMBoreStd = 0
Global Const sEMBoreStd = "STANDARD #13"
Global Const cEMBoreBel = 1
Global Const sEMBoreBel = "BELLED"
Global Const cEMBoreLH3 = 2
Global Const sEMBoreLH3 = "LIBBY HORN 3MM"
Global Const cEMBoreLH4 = 3
Global Const sEMBoreLH4 = "LIBBY HORN 4MM"
Global Const cEMBoreRvrs = 4
Global Const sEMBoreRvrs = "REVERSE BELL"
Global Const cEMBoreNA = 5
Global Const sEMBoreNA = "NOT SPECIFIED"
Global Const cEMBoreOther = 6

'Earmold tube - constants & strings
Global Const cNumEMTube = 4
Global Const cEMTubeNorm = 0
Global Const sEMTubeNorm = "NORMAL #13"
Global Const cEMTubeThick = 1
Global Const sEMTubeThick = "THICK WALLED"
Global Const cEMTubeNA = 2
Global Const sEMTubeNA = "NOT SPECIFIED"
Global Const cEMTubeOther = 3

'Earmold vent - constants & strings
Global Const cNumEMVent = 8
Global Const cEMVentSel = 0
Global Const sEMVentSel = "SELECT-A-VENT"
Global Const cEMVentPar = 1
Global Const sEMVentPar = "PARALLEL"
Global Const cEMVentLat = 2
Global Const sEMVentLat = "LATERAL"
Global Const cEMVentPres1 = 3
Global Const sEMVentPres1 = "PRESSURE 1MM"
Global Const cEMVentPres2 = 4
Global Const sEMVentPres2 = "PRESSURE 2MM"
Global Const cEMVentPres3 = 5
Global Const sEMVentPres3 = "PRESSURE 3MM"
Global Const cEMVentNA = 6
Global Const sEMVentNA = "NOT SPECIFIED"
Global Const cEMVentOther = 7

'Earmold material - constants & strings
Global Const cNumEmMat = 14
Global Const cEMMatDermatex = 0
Global Const sEMMatDermatex = "DERMATEX"
Global Const cEMMatFormaseal = 1
Global Const sEMMatFormaseal = "FORMASEAL"
Global Const cEMMatLucite = 2
Global Const sEMMatLucite = "LUCITE"
Global Const cEMMatMedicryl = 3
Global Const sEMMatMedicryl = "MEDICRYL"
Global Const cEMMatMediflex = 4
Global Const sEMMatMediflex = "MEDIFLEX"
Global Const cEMMatNewsil = 5
Global Const sEMMatNewsil = "NEWSIL"
Global Const cEMMatProtint = 6
Global Const sEMMatProtint = "PROTINT"
Global Const cEMMatSilicone = 7
Global Const sEMMatSilicone = "SILICONE"
Global Const cEMMatSoftex = 8
Global Const sEMMatSoftex = "SOFTEX"
Global Const cEMMatUltraflex = 9
Global Const sEMMatUltraflex = "ULTRAFLEX"
Global Const cEMMatUltrasoft = 10
Global Const sEMMatUltrasoft = "ULTRASOFT"
Global Const cEMMatVinylflex = 11
Global Const sEMMatVinylflex = "VINYLFLEX"
Global Const cEMMatNA = 12
Global Const sEMMatNA = "NOT SPECIFIED"
Global Const cEMMatOther = 13

'Data
Type tMeasLevel
       mlMeas As String * 40
       mlLevels(0 To c31NumFreqs) As String * 3
End Type 'TMeasLevel

'Client information - See WRITEDSL40CLIENT for description
Type TAudAreaClient41
        aaPatientID As String
        aaLastName As String
        aaGivenName As String
        aaTestDate(cEarLeft To cEarRight) As Variant
        aaVerHiLoDate(cEarLeft To cEarRight) As Variant '14
        aaVerMidDate(cEarLeft To cEarRight) As Variant '14
        aaBirDate As Variant
        aaSex As String
        aaStreet As String
        aaCity As String
        aaProvince As String
        aaCode As String
        aaCountry As String
        aaPhone As String
        aaTester As String
        aaEar(cEarLeft To cEarRight, c40Thresh To c40REDD) As tMeasLevel
        aaVerifyMid(cEarLeft To cEarRight, 0 To 2) As tMeasLevel
        aaVerifyHiLo(cEarLeft To cEarRight, 0 To 1) As tMeasLevel
        aaVerHi(cEarLeft To cEarRight) As Integer
        aaVerHiVal(cEarLeft To cEarRight) As Integer
        aaVerMid(cEarLeft To cEarRight) As Integer
        aaVerMidInput(cEarLeft To cEarRight) As Integer
        aaVerMidVal(cEarLeft To cEarRight, 0 To 2) As Integer
        aaVerLo(cEarLeft To cEarRight) As Integer
        aaXducer(cEarLeft To cEarRight) As Integer
        aaXdcXform(cEarLeft To cEarRight) As Integer
        aaHA(cEarLeft To cEarRight) As Integer
        aaHAXform(cEarLeft To cEarRight) As Integer
        aaLtass(cEarLeft To cEarRight) As Integer
        aaPresc(cEarLeft To cEarRight) As Integer
        aaMaxO(cEarLeft To cEarRight) As Integer
        aaComp(cEarLeft To cEarRight) As Integer
        aaIDR(cEarLeft To cEarRight) As Integer
        aaLoud(cEarLeft To cEarRight) As Integer
        aaCT(cEarLeft To cEarRight) As Integer
        aaReserve(cEarLeft To cEarRight) As Integer
        aaUserInput(cEarLeft To cEarRight) As Integer
        aaEMType(cEarLeft To cEarRight) As String
        aaEMMat(cEarLeft To cEarRight) As String
        aaEMBore(cEarLeft To cEarRight) As String
        aaEMTube(cEarLeft To cEarRight) As String
        aaEMVent(cEarLeft To cEarRight) As String
        aaHAMake(cEarLeft To cEarRight) As String
        aaHAModel(cEarLeft To cEarRight) As String
        aaHASerial(cEarLeft To cEarRight) As String
        aaComment(cEarLeft To cEarRight) As String
        aaRECDCouplerType(cEarLeft To cEarRight)  As Integer
End Type 'TAudAreaClient

    
    
    'Client information - See WRITEDSL40CLIENT for description
    Type TAudAreaClient40
            aaPatientID As String
            aaLastName As String
            aaGivenName As String
            aaTestDate(cEarLeft To cEarRight) As Variant
            aaVerDate(cEarLeft To cEarRight) As Variant
            aaBirDate As Variant
            aaSex As String
            aaStreet As String
            aaCity As String
            aaProvince As String
            aaCode As String
            aaCountry As String
            aaPhone As String
            aaTester As String
            aaEar(cEarLeft To cEarRight, c40Thresh To c40REDD) As tMeasLevel
            aaVerifyMid(cEarLeft To cEarRight, cInputSoft To cInputLoud) As tMeasLevel
            aaVerifyHiLo(cEarLeft To cEarRight, 0 To 1) As tMeasLevel
            aaVerHi(cEarLeft To cEarRight) As Integer
            aaVerMid(cEarLeft To cEarRight) As Integer
            aaVerMidVal(cEarLeft To cEarRight, cInputSoft To cInputLoud) As Integer
            aaVerLo(cEarLeft To cEarRight) As Integer
            aaXducer(cEarLeft To cEarRight) As Integer
            aaXdcXform(cEarLeft To cEarRight) As Integer
            aaHA(cEarLeft To cEarRight) As Integer
            aaHAXform(cEarLeft To cEarRight) As Integer
            aaLtass(cEarLeft To cEarRight) As Integer
            aaPresc(cEarLeft To cEarRight) As Integer
            aaMaxO(cEarLeft To cEarRight) As Integer
            aaComp(cEarLeft To cEarRight) As Integer
            aaIDR(cEarLeft To cEarRight) As Integer
            aaCT(cEarLeft To cEarRight) As Integer
            aaReserve(cEarLeft To cEarRight) As Integer
            aaEMType(cEarLeft To cEarRight) As String
            aaEMMat(cEarLeft To cEarRight) As String
            aaEMBore(cEarLeft To cEarRight) As String
            aaEMTube(cEarLeft To cEarRight) As String
            aaEMVent(cEarLeft To cEarRight) As String
            aaHAMake(cEarLeft To cEarRight) As String
            aaHAModel(cEarLeft To cEarRight) As String
            aaHASerial(cEarLeft To cEarRight) As String
            aaComment(cEarLeft To cEarRight) As String
            aaRECDCouplerType(cEarLeft To cEarRight)  As Integer
    End Type 'TAudAreaClient

'Client information - See WRITEDSL40CLIENT for description
Type TAudAreaClient
        aaPatientID As String
        aaLastName As String
        aaGivenName As String
        aaTestDate(cEarLeft To cEarRight) As Variant
        aaVerDate(cEarLeft To cEarRight) As Variant 'only 4.0
        aaVerHiLoDate(cEarLeft To cEarRight) As Variant 'only 4.1
        aaVerMidDate(cEarLeft To cEarRight) As Variant 'only 4.1
        aaBirDate As Variant
        aaSex As String
        aaStreet As String
        aaCity As String
        aaProvince As String
        aaCode As String
        aaCountry As String
        aaPhone As String
        aaTester As String
        aaEar(cEarLeft To cEarRight, c40Thresh To c40REDD) As tMeasLevel
        aaVerifyMid(cEarLeft To cEarRight, 0 To 2) As tMeasLevel
        aaVerifyHiLo(cEarLeft To cEarRight, 0 To 1) As tMeasLevel
        aaVerHi(cEarLeft To cEarRight) As Integer
        aaVerHiVal(cEarLeft To cEarRight) As Integer
        aaVerMid(cEarLeft To cEarRight) As Integer
        aaVerMidInput(cEarLeft To cEarRight) As Integer
        aaVerMidVal(cEarLeft To cEarRight, 0 To 2) As Integer
        aaVerLo(cEarLeft To cEarRight) As Integer
        aaXducer(cEarLeft To cEarRight) As Integer
        aaXdcXform(cEarLeft To cEarRight) As Integer
        aaHA(cEarLeft To cEarRight) As Integer
        aaHAXform(cEarLeft To cEarRight) As Integer
        aaLtass(cEarLeft To cEarRight) As Integer
        aaPresc(cEarLeft To cEarRight) As Integer
        aaMaxO(cEarLeft To cEarRight) As Integer
        aaComp(cEarLeft To cEarRight) As Integer
        aaIDR(cEarLeft To cEarRight) As Integer
        aaLoud(cEarLeft To cEarRight) As Integer
        aaCT(cEarLeft To cEarRight) As Integer
        aaReserve(cEarLeft To cEarRight) As Integer
        aaUserInput(cEarLeft To cEarRight) As Integer
        aaEMType(cEarLeft To cEarRight) As String
        aaEMMat(cEarLeft To cEarRight) As String
        aaEMBore(cEarLeft To cEarRight) As String
        aaEMTube(cEarLeft To cEarRight) As String
        aaEMVent(cEarLeft To cEarRight) As String
        aaHAMake(cEarLeft To cEarRight) As String
        aaHAModel(cEarLeft To cEarRight) As String
        aaHASerial(cEarLeft To cEarRight) As String
        aaComment(cEarLeft To cEarRight) As String
        aaRECDCouplerType(cEarLeft To cEarRight)  As Integer
End Type 'TAudAreaClient
    
    'DSL Versions numbers
    Public gExeName As String * 8
    Public gVerNum As String * 6
    Public gUserDef As String * 6

'Main record to hold clienbt information - accessed everywhere!
Global gClient40 As TAudAreaClient40    ' Client tinformation
Global gClient41 As TAudAreaClient41    ' Client tinformation
Global gClient As TAudAreaClient    'common structure
Global DSLVersion As String
Public filenum As Integer

Sub open_client_file(filename As String)
filenum = FreeFile
    Open filename For Binary As filenum

    'Get some version information
    Get filenum, , gExeName
    Get filenum, , gVerNum
    Get filenum, , gUserDef
    
    If Trim(gVerNum) = vVerNum400 Then
        OpenDSL40Client (filenum)
        transfer_DSL40Client2General
    Else
        If Trim(gVerNum) = vVerNum410 Then
            OpenDSL41Client (filenum)
            transfer_DSL41Client2General
        End If
    End If
End Sub


Sub transfer_DSL40Client2General()
Dim i, j, k As Integer
    gClient.aaPatientID = gClient40.aaPatientID
    gClient.aaLastName = gClient40.aaLastName
    gClient.aaGivenName = gClient40.aaGivenName
    For i = cEarLeft To cEarRight
            gClient.aaTestDate(i) = gClient40.aaTestDate(i)
            gClient.aaVerDate(i) = gClient40.aaVerDate(i)
    Next i
    gClient.aaBirDate = gClient40.aaBirDate
    gClient.aaSex = gClient40.aaSex
    gClient.aaStreet = gClient40.aaStreet
    gClient.aaCity = gClient40.aaCity
    gClient.aaProvince = gClient40.aaProvince
    gClient.aaCode = gClient40.aaCode
    gClient.aaCountry = gClient40.aaCountry
    gClient.aaPhone = gClient40.aaPhone
    gClient.aaTester = gClient40.aaTester
    For i = cEarLeft To cEarRight
        For j = c40Thresh To c40REDD
            For k = 0 To cNumFreqs
                gClient.aaEar(i, j).mlLevels(k) = gClient40.aaEar(i, j).mlLevels(k)
            Next k
        Next j
        For j = cInputSoft To cInputLoud
            For k = 0 To cNumFreqs
                gClient.aaVerifyMid(i, j).mlLevels(k) = gClient40.aaVerifyMid(i, j).mlLevels(k)
            Next k
        Next j
        For j = 0 To 1
            For k = 0 To cNumFreqs
                gClient.aaVerifyHiLo(i, j).mlLevels(k) = gClient40.aaVerifyHiLo(i, j).mlLevels(k)
            Next k
        Next j
            gClient.aaVerHi(i) = gClient40.aaVerHi(i)
            gClient.aaVerMid(i) = gClient40.aaVerMid(i)
        For j = cInputSoft To cInputLoud
            gClient.aaVerMidVal(i, j) = gClient40.aaVerMidVal(i, j)
        Next j
            gClient.aaVerLo(i) = gClient40.aaVerLo(i)
            gClient.aaXducer(i) = gClient40.aaXducer(i)
            gClient.aaXdcXform(i) = gClient40.aaXdcXform(i)
            gClient.aaHA(i) = gClient40.aaHA(i)
            gClient.aaHAXform(i) = gClient40.aaHAXform(i)
            gClient.aaLtass(i) = gClient40.aaLtass(i)
            gClient.aaPresc(i) = gClient40.aaPresc(i)
            gClient.aaMaxO(i) = gClient40.aaMaxO(i)
            gClient.aaComp(i) = gClient40.aaComp(i)
            gClient.aaIDR(i) = gClient40.aaIDR(i)
            gClient.aaCT(i) = gClient40.aaCT(i)
            gClient.aaReserve(i) = gClient40.aaReserve(i)
            gClient.aaEMType(i) = gClient40.aaEMType(i)
            gClient.aaEMMat(i) = gClient40.aaEMMat(i)
            gClient.aaEMBore(i) = gClient40.aaEMBore(i)
            gClient.aaEMTube(i) = gClient40.aaEMTube(i)
            gClient.aaEMVent(i) = gClient40.aaEMVent(i)
            gClient.aaHAMake(i) = gClient40.aaHAMake(i)
            gClient.aaHAModel(i) = gClient40.aaHAModel(i)
            gClient.aaHASerial(i) = gClient40.aaHASerial(i)
            gClient.aaComment(i) = gClient40.aaComment(i)
            gClient.aaRECDCouplerType(i) = gClient40.aaRECDCouplerType(i)
    Next i
End Sub

Sub transfer_DSL41Client2General()
Dim i, j, k As Integer
    gClient.aaPatientID = gClient41.aaPatientID
    gClient.aaLastName = gClient41.aaLastName
    gClient.aaGivenName = gClient41.aaGivenName
    For i = cEarLeft To cEarRight
            gClient.aaTestDate(i) = gClient41.aaTestDate(i)
            gClient.aaVerHiLoDate(i) = gClient41.aaVerHiLoDate(i)
            gClient.aaVerMidDate(i) = gClient41.aaVerMidDate(i)
    Next i
    gClient.aaBirDate = gClient41.aaBirDate
    gClient.aaSex = gClient41.aaSex
    gClient.aaStreet = gClient41.aaStreet
    gClient.aaCity = gClient41.aaCity
    gClient.aaProvince = gClient41.aaProvince
    gClient.aaCode = gClient41.aaCode
    gClient.aaCountry = gClient41.aaCountry
    gClient.aaPhone = gClient41.aaPhone
    gClient.aaTester = gClient41.aaTester
    For i = cEarLeft To cEarRight
        For j = c40Thresh To c40REDD
            For k = 0 To cNumFreqs
                gClient.aaEar(i, j).mlLevels(k) = gClient41.aaEar(i, j).mlLevels(k)
            Next k
        Next j
        '''''
        For j = cInputSoft To cInputLoud
            For k = 0 To cNumFreqs
                gClient.aaVerifyMid(i, j).mlLevels(k) = gClient41.aaVerifyMid(i, j).mlLevels(k)
            Next k
        Next j
        '''''
        For j = 0 To 1
            For k = 0 To cNumFreqs
                gClient.aaVerifyHiLo(i, j).mlLevels(k) = gClient41.aaVerifyHiLo(i, j).mlLevels(k)
            Next k
        Next j
        '''''
        gClient.aaVerHi(i) = gClient41.aaVerHi(i)
        '''''
        gClient.aaVerHiVal(i) = gClient41.aaVerHiVal(i)
        '''''
        gClient.aaVerMid(i) = gClient41.aaVerMid(i)
        gClient.aaVerMidInput(i) = gClient41.aaVerMidInput(i)
        '''''
        For j = cInputSoft To cInputLoud
            gClient.aaVerMidVal(i, j) = gClient41.aaVerMidVal(i, j)
        Next j
        '''''
        gClient.aaVerLo(i) = gClient41.aaVerLo(i)
        gClient.aaXducer(i) = gClient41.aaXducer(i)
        gClient.aaXdcXform(i) = gClient41.aaXdcXform(i)
        gClient.aaHA(i) = gClient41.aaHA(i)
        gClient.aaHAXform(i) = gClient41.aaHAXform(i)
        gClient.aaLtass(i) = gClient41.aaLtass(i)
        gClient.aaPresc(i) = gClient41.aaPresc(i)
        gClient.aaMaxO(i) = gClient41.aaMaxO(i)
        gClient.aaComp(i) = gClient41.aaComp(i)
        gClient.aaIDR(i) = gClient41.aaIDR(i)
        gClient.aaLoud(i) = gClient41.aaLoud(i)
        gClient.aaCT(i) = gClient41.aaCT(i)
        gClient.aaReserve(i) = gClient41.aaReserve(i)
        gClient.aaUserInput(i) = gClient41.aaUserInput(i)
        gClient.aaEMType(i) = gClient41.aaEMType(i)
        gClient.aaEMMat(i) = gClient41.aaEMMat(i)
        gClient.aaEMBore(i) = gClient41.aaEMBore(i)
        gClient.aaEMTube(i) = gClient41.aaEMTube(i)
        gClient.aaEMVent(i) = gClient41.aaEMVent(i)
        gClient.aaHAMake(i) = gClient41.aaHAMake(i)
        gClient.aaHAModel(i) = gClient41.aaHAModel(i)
        gClient.aaHASerial(i) = gClient41.aaHASerial(i)
        gClient.aaComment(i) = gClient41.aaComment(i)
        gClient.aaRECDCouplerType(i) = gClient41.aaRECDCouplerType(i)
    Next i
End Sub

Sub transfer_General2DSL40Client()
Dim i, j, k As Integer
    gClient40.aaPatientID = gClient.aaPatientID
    gClient40.aaLastName = gClient.aaLastName
    gClient40.aaGivenName = gClient.aaGivenName
    For i = cEarLeft To cEarRight
            gClient40.aaTestDate(i) = gClient.aaTestDate(i)
            gClient40.aaVerDate(i) = gClient.aaVerDate(i)
    Next i
    gClient40.aaBirDate = gClient.aaBirDate
    gClient40.aaSex = gClient.aaSex
    gClient40.aaStreet = gClient.aaStreet
    gClient40.aaCity = gClient.aaCity
    gClient40.aaProvince = gClient.aaProvince
    gClient40.aaCode = gClient.aaCode
    gClient40.aaCountry = gClient.aaCountry
    gClient40.aaPhone = gClient.aaPhone
    gClient40.aaTester = gClient.aaTester
    For i = cEarLeft To cEarRight
        For j = c40Thresh To c40REDD
            For k = 0 To cNumFreqs
                gClient40.aaEar(i, j).mlLevels(k) = gClient.aaEar(i, j).mlLevels(k)
            Next k
        Next j
        For j = cInputSoft To cInputLoud
            For k = 0 To cNumFreqs
                gClient40.aaVerifyMid(i, j).mlLevels(k) = gClient.aaVerifyMid(i, j).mlLevels(k)
            Next k
        Next j
        For j = 0 To 1
            For k = 0 To cNumFreqs
                gClient40.aaVerifyHiLo(i, j).mlLevels(k) = gClient.aaVerifyHiLo(i, j).mlLevels(k)
            Next k
        Next j
            gClient40.aaVerHi(i) = gClient.aaVerHi(i)
            gClient40.aaVerMid(i) = gClient.aaVerMid(i)
        For j = cInputSoft To cInputLoud
            gClient40.aaVerMidVal(i, j) = gClient.aaVerMidVal(i, j)
        Next j
            gClient40.aaVerLo(i) = gClient.aaVerLo(i)
            gClient40.aaXducer(i) = gClient.aaXducer(i)
            gClient40.aaXdcXform(i) = gClient.aaXdcXform(i)
            gClient40.aaHA(i) = gClient.aaHA(i)
            gClient40.aaHAXform(i) = gClient.aaHAXform(i)
            gClient40.aaLtass(i) = gClient.aaLtass(i)
            gClient40.aaPresc(i) = gClient.aaPresc(i)
            gClient40.aaMaxO(i) = gClient.aaMaxO(i)
            gClient40.aaComp(i) = gClient.aaComp(i)
            gClient40.aaIDR(i) = gClient.aaIDR(i)
            gClient40.aaCT(i) = gClient.aaCT(i)
            gClient40.aaReserve(i) = gClient.aaReserve(i)
            gClient40.aaEMType(i) = gClient.aaEMType(i)
            gClient40.aaEMMat(i) = gClient.aaEMMat(i)
            gClient40.aaEMBore(i) = gClient.aaEMBore(i)
            gClient40.aaEMTube(i) = gClient.aaEMTube(i)
            gClient40.aaEMVent(i) = gClient.aaEMVent(i)
            gClient40.aaHAMake(i) = gClient.aaHAMake(i)
            gClient40.aaHAModel(i) = gClient.aaHAModel(i)
            gClient40.aaHASerial(i) = gClient.aaHASerial(i)
            gClient40.aaComment(i) = gClient.aaComment(i)
            gClient40.aaRECDCouplerType(i) = gClient.aaRECDCouplerType(i)
    Next i

End Sub

Sub transfer_General2DSL41Client()
Dim i, j As Integer
    gClient41.aaPatientID = gClient.aaPatientID
    gClient41.aaLastName = gClient.aaLastName
    gClient41.aaGivenName = gClient.aaGivenName
    For i = cEarLeft To cEarRight
            gClient41.aaTestDate(i) = gClient.aaTestDate(i)
            gClient41.aaVerHiLoDate(i) = gClient.aaVerHiLoDate(i)
            gClient41.aaVerMidDate(i) = gClient.aaVerMidDate(i)
    Next i
    gClient41.aaBirDate = gClient.aaBirDate
    gClient41.aaSex = gClient.aaSex
    gClient41.aaStreet = gClient.aaStreet
    gClient41.aaCity = gClient.aaCity
    gClient41.aaProvince = gClient.aaProvince
    gClient41.aaCode = gClient.aaCode
    gClient41.aaCountry = gClient.aaCountry
    gClient41.aaPhone = gClient.aaPhone
    gClient41.aaTester = gClient.aaTester
    For i = cEarLeft To cEarRight
        For j = c40Thresh To c40REDD
            For k = 0 To cNumFreqs
                gClient41.aaEar(i, j).mlLevels(k) = gClient.aaEar(i, j).mlLevels(k)
            Next k
        Next j
        '''''
        For j = cInputSoft To cInputLoud
            For k = 0 To cNumFreqs
                gClient41.aaVerifyMid(i, j).mlLevels(k) = gClient.aaVerifyMid(i, j).mlLevels(k)
            Next k
        Next j
        '''''
        For j = 0 To 1
            For k = 0 To cNumFreqs
                gClient41.aaVerifyHiLo(i, j).mlLevels(k) = gClient.aaVerifyHiLo(i, j).mlLevels(k)
            Next k
        Next j
        '''''
        gClient41.aaVerHi(i) = gClient.aaVerHi(i)
        '''''
        gClient41.aaVerHiVal(i) = gClient.aaVerHiVal(i)
        '''''
        gClient41.aaVerMid(i) = gClient.aaVerMid(i)
        gClient41.aaVerMidInput(i) = gClient.aaVerMidInput(i)
        '''''
        For j = cInputSoft To cInputLoud
            gClient41.aaVerMidVal(i, j) = gClient.aaVerMidVal(i, j)
        Next j
        '''''
        gClient41.aaVerLo(i) = gClient.aaVerLo(i)
        gClient41.aaXducer(i) = gClient.aaXducer(i)
        gClient41.aaXdcXform(i) = gClient.aaXdcXform(i)
        gClient41.aaHA(i) = gClient.aaHA(i)
        gClient41.aaHAXform(i) = gClient.aaHAXform(i)
        gClient41.aaLtass(i) = gClient.aaLtass(i)
        gClient41.aaPresc(i) = gClient.aaPresc(i)
        gClient41.aaMaxO(i) = gClient.aaMaxO(i)
        gClient41.aaComp(i) = gClient.aaComp(i)
        gClient41.aaIDR(i) = gClient.aaIDR(i)
        gClient41.aaLoud(i) = gClient.aaLoud(i)
        gClient41.aaCT(i) = gClient.aaCT(i)
        gClient41.aaReserve(i) = gClient.aaReserve(i)
        gClient41.aaUserInput(i) = gClient.aaUserInput(i)
        gClient41.aaEMType(i) = gClient.aaEMType(i)
        gClient41.aaEMMat(i) = gClient.aaEMMat(i)
        gClient41.aaEMBore(i) = gClient.aaEMBore(i)
        gClient41.aaEMTube(i) = gClient.aaEMTube(i)
        gClient41.aaEMVent(i) = gClient.aaEMVent(i)
        gClient41.aaHAMake(i) = gClient.aaHAMake(i)
        gClient41.aaHAModel(i) = gClient.aaHAModel(i)
        gClient41.aaHASerial(i) = gClient.aaHASerial(i)
        gClient41.aaComment(i) = gClient.aaComment(i)
        gClient41.aaRECDCouplerType(i) = gClient.aaRECDCouplerType(i)
    Next i
End Sub

Sub WriteDSL40String(StringToWrite As Variant)
    Dim Strlength As Integer

    Strlength = Len(StringToWrite)
    Put filenum, , Strlength               'Put the string length count
    Put filenum, , StringToWrite           'write it
End Sub

'----------------
'WRITEDSL40CLIENT
'----------------

'Write the gCLIENT info to a file.  Make sure this is written in the same
'order as the ReadDSL40Client reads
'
Function WriteDSL40Client(filename) As Integer

    WriteDSL40Client = 1
    ' The client is begin written from GCLIENT.  Therefore
    ' all information must first be transferred from the
    ' forms to gGLIENT.
    
    Dim DSL40Day As String
    Dim DSL40Mon As String
    Dim DSL40Year As String

    On Error GoTo WriteError

    filenum = FreeFile
    Open filename For Binary As filenum
    
    gExeName = vExeName
    gVerNum = vVerNum400
    gUserDef = vUserDefBeta

    'Write EXE name, & version info
    Put filenum, , gExeName
    Put filenum, , gVerNum
    Put filenum, , gUserDef
    
    Call WriteDSL40String(gClient40.aaPatientID)
    
    Call WriteDSL40String(gClient40.aaLastName)
    Call WriteDSL40String(gClient40.aaGivenName)
    
    Call WriteDSL40String(gClient40.aaBirDate)
    
    Call WriteDSL40String(gClient40.aaStreet)
    Call WriteDSL40String(gClient40.aaCity)
    Call WriteDSL40String(gClient40.aaProvince)
    Call WriteDSL40String(gClient40.aaCode)
    Call WriteDSL40String(gClient40.aaCountry)
    Call WriteDSL40String(gClient40.aaPhone)
    Call WriteDSL40String(gClient40.aaTester)
    Call WriteDSL40String(gClient40.aaSex)

    'For each ear...
    For i = cEarLeft To cEarRight
        
        '------------------------
        ' WRITE AUDIOMETRIC DATA
        '------------------------

        'Test date
        Call WriteDSL40String(gClient40.aaTestDate(i))

    'Audiometric data - for each measure type...
        For j = c40Thresh To c40REDD
            ' for each frequency...
            For k = 0 To cNumFreqs
                Call WriteDSL40String(gClient40.aaEar(i, j).mlLevels(k))
            Next k
        Next j
        
        '-------------------------
        ' WRITE VERIFICATION DATA
        '-------------------------
    
        'Verification date
        Call WriteDSL40String(gClient40.aaVerDate(i))

        '3 levels of mid-level data
        For j = cInputSoft To cInputLoud
            For k = 0 To cNumFreqs
                Call WriteDSL40String(gClient40.aaVerifyMid(i, j).mlLevels(k))
            Next k
        Next j
        ' Hi and low level
        For j = 0 To 1
            For k = 0 To cNumFreqs
                Call WriteDSL40String(gClient40.aaVerifyHiLo(i, j).mlLevels(k))
            Next k
        Next j
        
    'Write DSL[i/o] related constants
        Put filenum, , gClient40.aaXducer(i)          'tranducer
        Put filenum, , gClient40.aaXdcXform(i)            'HL to SPL transform
        Put filenum, , gClient40.aaHA(i)          'Hearing aid type
        Put filenum, , gClient40.aaHAXform(i)         'Hearing aid transform
        Put filenum, , gClient40.aaLtass(i)           'Speech spectrum
        Put filenum, , gClient40.aaPresc(i)           'HA prescription
        Put filenum, , gClient40.aaMaxO(i)            'Maximum output
        Put filenum, , gClient40.aaComp(i)            'Compression type
        Put filenum, , gClient40.aaIDR(i)         'Input dynamic range
        Put filenum, , gClient40.aaCT(i)          'Compression threshold
        Put filenum, , gClient40.aaRECDCouplerType(i)     'NOT NECESSARY
        Put filenum, , gClient40.aaVerMid(i)          'Mid level verification type (RE/2cc, Input/gain)
        Put filenum, , gClient40.aaVerMidVal(i, 0)        'Mid level verification levels (soft)
        Put filenum, , gClient40.aaVerMidVal(i, 1)        'Mid level verification levels (average)
        Put filenum, , gClient40.aaVerMidVal(i, 2)        'Mid level verification levels (loud)
        Put filenum, , gClient40.aaVerHi(i)           'Hi level veirifcation type (RE/2cc)
        Put filenum, , gClient40.aaVerLo(i)           'Low level verification azimuth (0/45/90)
        Put filenum, , gClient40.aaReserve(i)         'Reserve gain

        'Earmold information - Strings
        Call WriteDSL40String(gClient40.aaEMType(i))
        Call WriteDSL40String(gClient40.aaEMBore(i))
        Call WriteDSL40String(gClient40.aaEMTube(i))
        Call WriteDSL40String(gClient40.aaEMVent(i))
        Call WriteDSL40String(gClient40.aaEMMat(i))
        
        'HEaring aid information - Strings
        Call WriteDSL40String(gClient40.aaHAMake(i))
        Call WriteDSL40String(gClient40.aaHAModel(i))
        Call WriteDSL40String(gClient40.aaHASerial(i))
        Call WriteDSL40String(gClient40.aaComment(i))

    Next i
    
    Close filenum
    Exit Function

WriteError:
    WriteDSL40Client = 104
    Exit Function
End Function


'----------------
'READDSL40STRING
'----------------

Sub ReadDSL40String(StringToRead As Variant)
    Dim Strlength As Integer

    On Error GoTo OuttaHere

    Get filenum, , Strlength                'Get the string length count
    StringToRead = String$(Strlength, " ")  'cast the length
    Get filenum, , StringToRead             'read it
    Exit Sub
OuttaHere:
    Exit Sub
End Sub

'----------------
'OPENDSL40CLIENT
'----------------

Sub OpenDSL40Client(filenum As Integer)
    'Dim DSL40Day As String
    'Dim DSL40Mon As String
    'Dim DSL40Year As String

    'filenum = FreeFile
    'Open filename For Binary As filenum

    'Get some version information
    'Get filenum, , gExeName
    'Get filenum, , gVerNum
    'Get filenum, , gUserDef
    
    Call ReadDSL40String(gClient40.aaPatientID)
    
    Call ReadDSL40String(gClient40.aaLastName)
    Call ReadDSL40String(gClient40.aaGivenName)
    
    Call ReadDSL40String(gClient40.aaBirDate)
    
    Call ReadDSL40String(gClient40.aaStreet)
    Call ReadDSL40String(gClient40.aaCity)
    Call ReadDSL40String(gClient40.aaProvince)
    Call ReadDSL40String(gClient40.aaCode)
    Call ReadDSL40String(gClient40.aaCountry)
    Call ReadDSL40String(gClient40.aaPhone)
    Call ReadDSL40String(gClient40.aaTester)
    Call ReadDSL40String(gClient40.aaSex)

    For i = cEarLeft To cEarRight
        
        ' Read audiometric data
        Call ReadDSL40String(gClient40.aaTestDate(i))
        For j = c40Thresh To c40REDD '0 to 5
            For k = 0 To cNumFreqs
                Call ReadDSL40String(gClient40.aaEar(i, j).mlLevels(k))
            Next k
        Next j
        
        ' Read verification data
        Call ReadDSL40String(gClient40.aaVerDate(i))
        ' 3 mid-levels
        For j = cInputSoft To cInputLoud '0 to 2
            For k = 0 To cNumFreqs
                Call ReadDSL40String(gClient40.aaVerifyMid(i, j).mlLevels(k))
            Next k
        Next j
        ' Hi and Low level
        For j = 0 To 1
            For k = 0 To cNumFreqs
                Call ReadDSL40String(gClient40.aaVerifyHiLo(i, j).mlLevels(k))
            Next k
        Next j
        
        Get filenum, , gClient40.aaXducer(i)
        Get filenum, , gClient40.aaXdcXform(i)
        Get filenum, , gClient40.aaHA(i)
        Get filenum, , gClient40.aaHAXform(i)
        Get filenum, , gClient40.aaLtass(i)
        Get filenum, , gClient40.aaPresc(i)
        Get filenum, , gClient40.aaMaxO(i)
        Get filenum, , gClient40.aaComp(i)
        Get filenum, , gClient40.aaIDR(i)
        Get filenum, , gClient40.aaCT(i)
        Get filenum, , gClient40.aaRECDCouplerType(i)
        Get filenum, , gClient40.aaVerMid(i)
        Get filenum, , gClient40.aaVerMidVal(i, 0)
        Get filenum, , gClient40.aaVerMidVal(i, 1)
        Get filenum, , gClient40.aaVerMidVal(i, 2)
        Get filenum, , gClient40.aaVerHi(i)
        Get filenum, , gClient40.aaVerLo(i)

        Get filenum, , gClient40.aaReserve(i)

        Call ReadDSL40String(gClient40.aaEMType(i))
        Call ReadDSL40String(gClient40.aaEMBore(i))
        Call ReadDSL40String(gClient40.aaEMTube(i))
        Call ReadDSL40String(gClient40.aaEMVent(i))
        Call ReadDSL40String(gClient40.aaEMMat(i))
        
        Call ReadDSL40String(gClient40.aaHAMake(i))
        Call ReadDSL40String(gClient40.aaHAModel(i))
        Call ReadDSL40String(gClient40.aaHASerial(i))
        Call ReadDSL40String(gClient40.aaComment(i))

    Next i

    Close filenum

    ' Move Data from 4.0 to 4.1 format
    'Call Client40To41
End Sub

'-------------
'CLIENT40To41
'-------------
' After a 4.0 client has been read to the gClient data structure, this routine fill the newly introduced fileds  with some default values.
Sub Client40To41()
    Dim i As Integer, j As Integer, k As Integer

    For i = cEarLeft To cEarRight
    ' 3 mid-levels
    For j = cInputSoft To cInputLoud '0 to 2
        'Input Type : NOT READ - Set to cTONE
        gClient.aaVerMidInput(i) = cTone
        'Loudness type : NOT READ - Set to predicted
        gClient.aaLoud(i) = cLoudPred
    Next j

    'Mid level output type needs to be offset by 2 (extra menu choices) and separator (1)
    gClient.aaVerMid(i) = gClient.aaVerMid(i) + cNumVerMidType + 1

    'Hi Input Levels : NOT READ - Set to 90
    gClient.aaVerHiVal(i) = 90
    
    'HiLo Ver date - set to the same as Mid-level date
    gClient.aaVerHiLoDate(i) = gClient.aaVerMidDate(i)

    'User gain input tone level
    gClient.aaUserInput(i) = 65
    
    'Based upon Compression type and IDR, set the type of WDRC aid
    If gClient.aaPresc(i) <> cPrescLinear Then
        Select Case gClient.aaComp(i)
        Case cIOCompLin: gClient.aaPresc(i) = cPrescWDRCFix
        Case cIOCompCurv: gClient.aaPresc(i) = cPrescWDRCVar
        End Select
    End If
    Next i
End Sub


'-------------
'OPENDSL41CLIENT
'-------------

 Sub OpenDSL41Client(filenum As Integer)
    
    Call ReadDSL40String(gClient41.aaPatientID)
    
    Call ReadDSL40String(gClient41.aaLastName)
    Call ReadDSL40String(gClient41.aaGivenName)
    
    Call ReadDSL40String(gClient41.aaBirDate)
    
    Call ReadDSL40String(gClient41.aaStreet)
    Call ReadDSL40String(gClient41.aaCity)
    Call ReadDSL40String(gClient41.aaProvince)
    Call ReadDSL40String(gClient41.aaCode)
    Call ReadDSL40String(gClient41.aaCountry)
    Call ReadDSL40String(gClient41.aaPhone)
    Call ReadDSL40String(gClient41.aaTester)
    Call ReadDSL40String(gClient41.aaSex)

    For i = cEarLeft To cEarRight
    
    ' Read audiometric data
    Call ReadDSL40String(gClient41.aaTestDate(i))
    For j = c40Thresh To c40REDD '0 to 5
        For k = 0 To cNumFreqs
        Call ReadDSL40String(gClient41.aaEar(i, j).mlLevels(k))
        Next k
    Next j
    
    ' Read Mid-level verification data
    Call ReadDSL40String(gClient41.aaVerMidDate(i))
    
    ' 3 mid-levels
    For j = cInputSoft To cInputLoud '0 to 2
        'Input Type
        Get filenum, , gClient41.aaVerMidInput(i)
        'Input Level
        Get filenum, , gClient41.aaVerMidVal(i, j)
        'RE/2cc Output/Gain
        Get filenum, , gClient41.aaVerMid(i)
        'Measured levels
        For k = 0 To cNumFreqs
        Call ReadDSL40String(gClient41.aaVerifyMid(i, j).mlLevels(k))
        Next k
    Next j

    ' Read HiLo-level verification data
    Call ReadDSL40String(gClient41.aaVerHiLoDate(i))
    'Hi Input Levels
    Get filenum, , gClient41.aaVerHiVal(i)
    'Verification levels
    For j = 0 To 1
        For k = 0 To cNumFreqs
        Call ReadDSL40String(gClient41.aaVerifyHiLo(i, j).mlLevels(k))
        Next k
    Next j
    
    Get filenum, , gClient41.aaXducer(i)
    Get filenum, , gClient41.aaXdcXform(i)
    Get filenum, , gClient41.aaHA(i)
    Get filenum, , gClient41.aaHAXform(i)
    Get filenum, , gClient41.aaLtass(i)
    Get filenum, , gClient41.aaPresc(i)
    Get filenum, , gClient41.aaMaxO(i)
    Get filenum, , gClient41.aaLoud(i)
    Get filenum, , gClient41.aaCT(i)
    Get filenum, , gClient41.aaRECDCouplerType(i)
    Get filenum, , gClient41.aaVerHi(i)
    Get filenum, , gClient41.aaVerLo(i)

    Get filenum, , gClient41.aaReserve(i)
    Get filenum, , gClient41.aaUserInput(i)

    Call ReadDSL40String(gClient41.aaEMType(i))
    Call ReadDSL40String(gClient41.aaEMBore(i))
    Call ReadDSL40String(gClient41.aaEMTube(i))
    Call ReadDSL40String(gClient41.aaEMVent(i))
    Call ReadDSL40String(gClient41.aaEMMat(i))
    
    Call ReadDSL40String(gClient41.aaHAMake(i))
    Call ReadDSL40String(gClient41.aaHAModel(i))
    Call ReadDSL40String(gClient41.aaHASerial(i))
    Call ReadDSL40String(gClient41.aaComment(i))

    Next i

    Close filenum
End Sub


'-------------
'WRITEDSL41CLIENT
'-------------
Function WriteDSL41Client(filename) As Integer

    WriteDSL41Client = 1
    ' The client is begin written from GCLIENT.  Therefore
    ' all information must first be transferred from the
    ' forms to gGLIENT.
    
    Dim DSL40Day As String
    Dim DSL40Mon As String
    Dim DSL40Year As String

    filenum = FreeFile
    Open filename For Binary As filenum
    
    gExeName = vExeName
    gVerNum = vVerNum410
    gUserDef = vBeta4100

    'Write EXE name, & version info
    Put filenum, , gExeName
    Put filenum, , gVerNum
    Put filenum, , gUserDef
    
    Call WriteDSL40String(gClient41.aaPatientID)
    
    Call WriteDSL40String(gClient41.aaLastName)
    Call WriteDSL40String(gClient41.aaGivenName)
    
    Call WriteDSL40String(gClient41.aaBirDate)
    
    Call WriteDSL40String(gClient41.aaStreet)
    Call WriteDSL40String(gClient41.aaCity)
    Call WriteDSL40String(gClient41.aaProvince)
    Call WriteDSL40String(gClient41.aaCode)
    Call WriteDSL40String(gClient41.aaCountry)
    Call WriteDSL40String(gClient41.aaPhone)
    Call WriteDSL40String(gClient41.aaTester)
    Call WriteDSL40String(gClient41.aaSex)

    For i = cEarLeft To cEarRight
    
    ' Write audiometric data
    Call WriteDSL40String(gClient41.aaTestDate(i))
    For j = c40Thresh To c40REDD
        For k = 0 To cNumFreqs
        Call WriteDSL40String(gClient41.aaEar(i, j).mlLevels(k))
        Next k
    Next j
    
    ' Write mid verification date
    Call WriteDSL40String(gClient41.aaVerMidDate(i))
    
    ' 3 mid-levels
    For j = cInputSoft To cInputLoud '0 to 2
        'Input Type
        Put filenum, , gClient41.aaVerMidInput(i)
        'Input Level
        Put filenum, , gClient41.aaVerMidVal(i, j)
        'RE/2cc Output/Gain
        Put filenum, , gClient41.aaVerMid(i)
        'Measured levels
        For k = 0 To cNumFreqs
        Call WriteDSL40String(gClient41.aaVerifyMid(i, j).mlLevels(k))
        Next k
    Next j

    'Write HiLo verification date
    Call WriteDSL40String(gClient41.aaVerHiLoDate(i))
    'Hi Input Levels
    Put filenum, , gClient41.aaVerHiVal(i)
    'Measured levels
    For j = 0 To 1
        For k = 0 To cNumFreqs
        Call WriteDSL40String(gClient41.aaVerifyHiLo(i, j).mlLevels(k))
        Next k
    Next j
    
    Put filenum, , gClient41.aaXducer(i)
    Put filenum, , gClient41.aaXdcXform(i)
    Put filenum, , gClient41.aaHA(i)
    Put filenum, , gClient41.aaHAXform(i)
    Put filenum, , gClient41.aaLtass(i)
    Put filenum, , gClient41.aaPresc(i)
    Put filenum, , gClient41.aaMaxO(i)
    Put filenum, , gClient41.aaLoud(i)
    Put filenum, , gClient41.aaCT(i)
    Put filenum, , gClient41.aaRECDCouplerType(i)
    Put filenum, , gClient41.aaVerHi(i)
    Put filenum, , gClient41.aaVerLo(i)

    Put filenum, , gClient41.aaReserve(i)
    Put filenum, , gClient41.aaUserInput(i)

    Call WriteDSL40String(gClient41.aaEMType(i))
    Call WriteDSL40String(gClient41.aaEMBore(i))
    Call WriteDSL40String(gClient41.aaEMTube(i))
    Call WriteDSL40String(gClient41.aaEMVent(i))
    Call WriteDSL40String(gClient41.aaEMMat(i))
    
    Call WriteDSL40String(gClient41.aaHAMake(i))
    Call WriteDSL40String(gClient41.aaHAModel(i))
    Call WriteDSL40String(gClient41.aaHASerial(i))
    Call WriteDSL40String(gClient41.aaComment(i))

    Next i
    
    Close filenum
End Function
    

