Attribute VB_Name = "Module2"
' User Profile Routines
Declare Function GetProfileInt Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Integer) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Function WriteProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String) As Integer
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetSystemDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
Declare Function GetTimerResolution Lib "User" () As Long
Declare Function GetSystemMsecCount Lib "System" () As Long
Declare Sub int14reg Lib "c:\windows\system\int14reg.dll" Alias "#1" (IRegs As IRegsType)


Sub Sleep(Msecs As Long)
    Dim t1, t2 As Long
    t1 = GetSystemMsecCount
   Do
    t2 = GetSystemMsecCount
    If (t2 - t1) >= Msecs Then
       Exit Do
    End If
   Loop
End Sub

'-----------------------------------------------------------
' FUNCTION: ReadIniFile
'
' Reads a value from the specified section/key of the
' specified .INI file
'
' IN: [strIniFile] - name of .INI file to read
'     [strSection] - section where key is found
'     [strKey] - name of key to get the value of
'
' Returns: non-zero terminated value of .INI file key
'-----------------------------------------------------------
'
Function ReadIniFile(ByVal strIniFile As String, ByVal strSECTION As String, ByVal strKey As String) As String
    Dim strBuffer As String
    'If successful read of .INI file, strip any trailing zero returned by the Windows API GetPrivateProfileString
    strBuffer = Space$(MAX_PATH_SIZE)
    
    If GetPrivateProfileString(strSECTION, strKey, "", strBuffer, MAX_PATH_SIZE, strIniFile) > 0 Then
        ReadIniFile = RTrim$(StripTerminator(strBuffer))
    Else
        ReadIniFile = DefPath
    End If
End Function


'-----------------------------------------------------------
' SUB: AddDirSep
' Add a trailing directory path separator (back slash) to the
' end of a pathname unless one already exists
'
' IN/OUT: [strPathName] - path to add separator to
'-----------------------------------------------------------
'
Sub AddDirSep(strPathName As String)
    If Right$(RTrim$(strPathName), 1) <> "\" Then
        strPathName = RTrim$(strPathName) & "\"
    End If
End Sub

'-----------------------------------------------------------
' FUNCTION: GetWindowsDir
'
' Calls the windows API to get the windows directory and
' ensures that a trailing dir separator is present
'
' Returns: The windows directory
'-----------------------------------------------------------
'
Function GetWindowsDir() As String
    Dim strBuf As String

    strBuf = Space$(MAX_PATH_SIZE)

    '
    'Get the windows directory and then trim the buffer to the exact length
    'returned and add a dir sep (backslash) if the API didn't return one
    '
    If GetWindowsDirectory(strBuf, MAX_PATH_SIZE) > 0 Then
        strBuf = StripTerminator$(strBuf)
        AddDirSep strBuf

        GetWindowsDir = UCase(strBuf)
    Else
        GetWindowsDir = ""
    End If
End Function


'-----------------------------------------------------------
' FUNCTION: StripTerminator
'
' Returns a string without any zero terminator.  Typically,
' this was a string returned by a Windows API call.
'
' IN: [strString] - String to remove terminator from
'
' Returns: The value of the string passed in minus any
'          terminating zero.
'-----------------------------------------------------------
'
Function StripTerminator(ByVal strString As String) As String
    Dim intZeroPos As Integer

    intZeroPos = InStr(strString, Chr$(0))
    If intZeroPos > 0 Then
        StripTerminator = Left$(strString, intZeroPos - 1)
    Else
        StripTerminator = strString
    End If
End Function


Function GetMachineType() As Integer
  If InitRs232 Then
    SendCmd 28, 0, ArrCommand.Results
    ArrCommand = GetResponse
    Select Case ArrCommand.Results(5)
        Case 0:
                GetMachineType = Machine6500
                MachineVersion = ArrCommand.Results(0)
                AnalyzerLoLimit = 50
        Case 40:
                GetMachineType = MachineFP40
                MachineVersion = ArrCommand.Results(0)
                AnalyzerLoLimit = 45
        Case MachineFA10, MachineFA12, MachineFA18:
                GetMachineType = MachineFA1x
                MachineVersion = ArrCommand.Results(0)
                AnalyzerLoLimit = 0
        Case Else:
                GetMachineType = MachineUnknown
                AnalyzerLoLimit = 0
                MachineVersion = -1
    End Select
    CloseRS232
  Else
    MsgBox "Can not initialize the serial port! Exiting...", vbOKOnly + vbCritical, WarningTitle
    End
  End If
End Function


Public Function GetResponse() As ResType
Dim temp As ResType
Dim i, Counter As Integer
    'RspWait
    'indexed response buffer read
    IRegs.AX = &HFF26
    IRegs.DX = SelectedPort
    IRegs.CX = 1            'read indexed buffer for data word count
    int14reg IRegs
    Counter = IRegs.CX      'data word count
    
    For i = 2 To Counter + 1
        IRegs.AX = &HFF26
        IRegs.DX = SelectedPort
        IRegs.CX = i
        int14reg IRegs
        If IRegs.DX > 32767 Then
          MsgBox "Invalid data " & IRegs.DX, vbOKOnly + vbCritical, ErrorTitle
        End If
        temp.Results(i - 2) = IRegs.DX
        IRegs.AX = &HFF16
        IRegs.DX = SelectedPort
        int14reg IRegs
    Next i
    GetResponse = temp
End Function

Public Function SendCmd(scmd As Integer, scnt As Integer, sdat() As Integer) As Integer
Dim i As Integer
GlobalError = False
'wait till ready flag is set
For i = 1 To scnt + 2
    'indexed send buffer write
    IRegs.DX = SelectedPort
    IRegs.AX = &HFF23
    IRegs.CX = i - 1
    Select Case i
        Case Is = 1: IRegs.BX = scmd
        Case Is = 2: IRegs.BX = scnt
        Case Else:  IRegs.BX = sdat(i - 3)
    End Select
    int14reg IRegs
Next i
'resend the command already in the buffer
X% = SendWait
If X% = -1 Then
    SendCmd = -1
    Exit Function
End If
IRegs.AX = &HFF15
IRegs.DX = SelectedPort
int14reg IRegs
X% = SendWait
If X% = -1 Then
    SendCmd = -1
    Exit Function
End If
SendCmd = 0
End Function

Public Sub RspWait()
 Do
    IRegs.AX = &HFF13
    IRegs.DX = SelectedPort
    int14reg IRegs
'    ShowRegs
 Loop Until (IRegs.AX And 1) = 1
End Sub

Public Function SendWait() As Integer
Dim t1, t2 As Long
t1 = GetSystemMsecCount
Do 'Or inkey$ <> ""
    IRegs.AX = &HFF13
    IRegs.DX = SelectedPort
    int14reg IRegs
'    If (IRegs.AX And 1) <> 0 Then
'        GlobalError = False
'        Exit Do
'    End If
    t2 = GetSystemMsecCount
    If (t2 - t1) >= TIMEOUT Then
        FrmMain.Label5 = "Connection: FAILED"
        Beep
        MsgBox "Timeout occured." & Chr(10) & Chr(13) & "Please check your instruments or configuration settings...", vbOKOnly + vbCritical, ErrorTitle
        GlobalError = True
        SendWait = -1   'error
        Exit Function
    End If
Loop Until (IRegs.AX And 1) <> 0
    SendWait = 0 'success
End Function

Public Sub CloseRS232()
'disable fryers packet protocol
IRegs.AX = &HFF10
IRegs.CX = &HFF00
IRegs.DX = SelectedPort
int14reg IRegs

'disable fryers interrupt procedure
IRegs.AX = &HFF00
IRegs.CX = &HFF00
IRegs.DX = SelectedPort
int14reg IRegs
End Sub

Public Function InitRs232()
InitRs232 = False

'get version number
IRegs.DX = 0
IRegs.AX = &HFFFF
int14reg IRegs

If IRegs.DX <> &HFFFF Or IRegs.AX < &H30 Then
  MsgBox "Cannot run program, FRYERS.COM not loaded", vbOKOnly + vbCritical, ErrorTitle
  InitRs232 = False
  Exit Function
End If
  
'disable fryers interrupt procedure
IRegs.AX = &HFF00
IRegs.CX = &HFF00
IRegs.DX = SelectedPort
int14reg IRegs

'enabled fryers interrupt procedure
IRegs.AX = &HFF00
IRegs.CX = &HFFFF
IRegs.DX = SelectedPort
int14reg IRegs

'initialize the port to 9600 baud - default
IRegs.AX = &HE3
IRegs.DX = SelectedPort
int14reg IRegs

'enable fryers packet protocol
IRegs.AX = &HFF10
IRegs.CX = &HFFFF
IRegs.DX = SelectedPort
int14reg IRegs

InitRs232 = True
End Function

