function ConvertBmpToFrye:integer;
const StartOfs = 10;
var k,w,h,x,y,i:integer;
var Data,Tmp : Lval;
var style : integer;
var L : longint;
begin
  ConvertBmpToFrye := -1;  {assume failure}
  style := 2;           {currently only monochrome allowed}
  w := BmpHeader.Width;
  h := BmpHeader.Height;
  if (h <= 0) or (w <= 0) then
  begin
    writeln('Error: Bitmap error (no data found)');
    Exit;
  end;
  w := (BmpHeader.Width div 32);   {BMP is in DWORD format}
  if (BmpHeader.Width mod 32) <> 0 then inc(w);
  i := 0;
  for y := 0 to h-1 do
  begin
    k := ((h-1)-y)*w;
    for x := 0 to w-1 do
    begin
      if ((StartOfs+i)*2) >= sizeof(FryeBitmap^) then
      begin
        writeln('Error: Bitmap error (image too big)');
        ConvertBmpToFrye := -2;
        Exit;
      end;
      {PrinterLabelBitmap^[StartOfs+i] := LabelFileBitmap^[k+x];}
      Data := Lval(WinBitmap^[k+x]);
      L := longint(Data);
      if (BmpPalette.Item[0] = 0) then
        L := not(L);  {pal[0]=black so need to invert the image}
      Data := Lval(L); 
      Tmp.b0 := BitReverse[Data.b0 xor $FF];
      Tmp.b1 := BitReverse[Data.b1 xor $FF];
      Tmp.b2 := BitReverse[Data.b2 xor $FF];
      Tmp.b3 := BitReverse[Data.b3 xor $FF];
      {Need to read the palette to determine black and white pixel settings}
      FryeBitmap^[StartOfs+i] := Dval(Tmp).Lw;
      inc(i);
      FryeBitmap^[StartOfs+i] := Dval(Tmp).Hw;
      inc(i);
    end;
  end;
  FryeBitmapSize := i+StartOfs; {total bitmap size in words}
  FryeBitmapDataSize := i*2;    {bitmap data size in bytes}
  FryeBitmap^[0] := 96;  {printer label bitmap}
  FryeBitmap^[1] := FryeBitmapSize;  {header+data-1 size in words}
  FryeBitmap^[2] := Style;  {mono(2)/color(16)}
  FryeBitmap^[3] := 0;    {xpos}
  FryeBitmap^[4] := 160;  {ypos}
  FryeBitmap^[5] := BmpHeader.Width;  {width}
  FryeBitmap^[6] := BmpHeader.Height; {height}
  FryeBitmap^[7] := 0;    {page}
  FryeBitmap^[8] := FryeBitmapDataSize; {image size in bytes}
  FryeBitmap^[9] := StartOfs; {bitmap data start index (in words)}
  ConvertBmpToFrye := 0;  {success!}
end;
