{-------------------------------------------------------------------}
{Checks on baudrate. If baud rate is wrong, tries to switch}
{the baudrate (if V4.00 Fryers) to see if it will fix the problem.}
procedure AutoBaudCheck(var FIPPrec:FIPPrecType);
var TAX,TBX,rax,rbx,rcx,rdx,cp:word;
begin
  with FIPPrec do
  begin
    cp := comport and 1;  {make sure comport is in range}
    if not(PortOpen) then Exit;
    if Fversion >= $40 then
    begin
      asm
        mov dx,[cp]
        mov bx,0 {38400}
        mov ax,$FF1B
        int $14
        MOV AH,0
        mov [Tax],AX
        mov [Tbx],bx
      end;
      if Tbx <> 0 then
        BaudSeek := true;

{
      asm
        MOV DX,[CP]
        MOV AX,$FF19
        MOV CX,0
        INT $14
        MOV [RAX],AX
        MOV [RBX],BX
        MOV [RCX],CX
        MOV [RDX],DX
      end;
      writemsg('TAX:'+fstr(Tax)+' TBX:'+fstr(Tbx)+
               ' AX:'+fstr(rax)+' BH:'+fstr(hi(rbx))+' BL:'+fstr(lo(rbx))+
               ' CX:'+fstr(rcx)+' DL:'+fstr(lo(rdx))+' DH:'+fstr(hi(rdx)));
}
    end;
  end;
end;

