
{This is an extension of the TS2unit for the Test and Test32 programs}
{It was added on because TS2unit ran out of code space for 16bit systems}
{all code is shared between the 16 bit and 32 bit versions.}
{V5.12 as of 3 Dec 2003 - med}

{$N+,E+}
Unit TS3unit;
interface
{$I PLATFORM.INC}
uses TestSubs,TestFIPP,ShowBlob,FryeBmp,TS2Unit,
  {$IFDEF WIN32}
     Windows,SysUtils;
     {$APPTYPE CONSOLE}
  {$ENDIF}
  {$IFDEF WIN16}
     DosCrt,WinProcs,WinDos,WinTypes,Strings;
  {$ENDIF}
  {$IFDEF MSDOS}
     Dos;
  {$ENDIF}
  {$IFDEF PMDOS}
     DOS;
  {$ENDIF}


{command procedures}
procedure dof100; {get device id count}
procedure dof101; {get long device id}
procedure dof102; {get device data}
procedure dof103; {get realtime clock}
procedure dof104; {set realtime clock}
procedure dof105; {get output transducer selection}
procedure dof106; {set output transducer selection}
procedure dof107; {get impulse rejection}
procedure dof108; {set impulse rejection}
procedure dof109; {get signal info}
procedure dof110; {get raw capture data}

procedure dof112; {set curve selection}
procedure dof113; {get curve selection}
procedure dof114; {set curve status}
procedure dof115; {get curve status }
procedure dof116; {set unaided curve selection}
procedure dof117; {get unaided curve selection}
{118 - set list   - not coded here}
{119 - get list   - not coded here}
{120 - get bitmap - not coded here}
procedure dof121; {set curve selection}
procedure dof122; {get static tone selection}
procedure dof123; {set aid type}
procedure dof124; {get aid type selection}
procedure dof125; {set bias tone Params}
procedure dof126; {get bias tone parameters}
{127 = reserved for external control}
{128 = reserved for external control}
procedure dof129; {set warble type}
procedure dof130; {get warble selection}
procedure dof131; {get delay measurments}
procedure dof132; {set Rcv Timeout}
procedure dof133; {get Rcv Timeout}
procedure dof134; {set Fit Rule}
procedure dof135; {get Fit Rule}
procedure dof136; {set Filter}
procedure dof137; {get Filter}
procedure dof138; {set Compression threshold}
procedure dof139; {get Compression threshold}
procedure dof140; {Set ClientAge}
procedure dof141; {get ClientAge}
procedure dof142; {Set Transducer location}
procedure dof143; {get transducer location}
procedure dof145; {Set leveling list}
procedure dof146; {Get leveling list}
procedure dof147; {Set leveling status}
procedure dof148; {Set aux port}
procedure dof149; {Get aux port}
procedure dof150; {Set user Number}
procedure dof151; {Get user Number}

procedure dof152; {Set Fit Type     fp35 V3.20}
procedure dof153; {Get Fit Type     fp35 V3.20}
procedure dof154; {Set Vent Type    fp35 V3.20}
procedure dof155; {Get Vent Type    fp35 V3.20}
procedure dof156; {Set Tubing Type  fp35 v3.20}
procedure dof157; {Get Tubing Type  fp35 V3.20}
procedure dof158; {Set Aid Channels fp35 V3.20}
procedure dof159; {Get Aid Channels fp35 V3.20}
procedure dof160; {Set Aid Limiting fp35 V3.20}
procedure dof161; {Get Aid Limiting fp35 V3.20}


procedure dof164; {Set Fit Param    fp35 v3.20}
procedure dof165; {Get Fit Param    fp35 v3.20}

procedure dof166; {Set UserID text}
procedure dof167; {Get UserID text}

const FIT_VENT_OPEN =     0;  {Vent Open}
const FIT_VENT_OCCLUDED = 1;  {Vent Occluded}
const FIT_VENT_TIGHT =    2;  {Vent tight}
const FIT_VENT_MM1 =      3;  {Vent 1mm}
const FIT_VENT_MM2 =      4;  {Vent 2mm}
const FIT_VENT_MM3 =      5;  {Vent 3mm}

const FIT_TUBING_NONE   = 0;  {Tubing None  [cic, itc, ite aids] }
const FIT_TUBING_LIBBY4 = 1;  {Tubing Libby 4                    }
const FIT_TUBING_LIBBY3 = 2;  {Tubing Libby 3                    }
const FIT_TUBING_CFA2   = 3;  {Tubing CFA #2 horn                }
const FIT_TUBING_CFA3   = 4;  {Tubing CFA #3 stepped bore        }
const FIT_TUBING_No13   = 5;  {Tubing #13                        }
const FIT_TUBING_sixC5  = 6;  {Tubing 6C5                        }
const FIT_TUBING_sixC10 = 7;  {Tubing 6C10                       }

implementation


{---------}
procedure dof100; {get device id count}
begin
  with FIPPrec do
  begin
    if not(GetDeviceIDCount(FIPPrec)) then Exit;
    writeln('Number of Devices: ',(DeviceIDCount));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof101; {get long device id}
var i : integer;
begin
  with FIPPrec do
  begin
    write  ('Enter Device number read Long ID from: ');
    readln(temp);
    DeviceIDNumber := temp;
    if not(GetLongDeviceID(FIPPrec)) then Exit;
    writeln('Family: $',HexB(LongDeviceID.Family));
    write('Serial: $');
      for i := 0 to 5 do
        write(HexB(LongDeviceID.Serial[i]));
    writeln;
    writeln('   CRC: $',HexB(LongDeviceID.Crc));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof102; {get device data}
var i,t:word;
begin
  with FIPPrec do
  begin
    write  ('Enter Device number to read from: ');
    readln(temp);
    DeviceIDNumber := temp;
    write  ('Enter Device selection to read from: ');
    readln(temp);
    DeviceSelection := temp;
    if not(GetDeviceData(FIPPrec)) then Exit;
    for i := 0 to DeviceDataSize-1 do
    begin
      write('$',HexW(DeviceDataArray^[i]),' ');
    end;
    writeln;
  end;
  pfunerr := 0;
end;

{---------}
procedure ShowRealTimeClock;
begin
  with FIPPrec do
  begin
    writeln('Milliseconds:',RealTimeClockData.Milliseconds);
    writeln('     Seconds:',RealTimeClockData.Seconds);
    writeln('     Minutes:',RealTimeClockData.Minutes);
    writeln('       Hours:',RealTimeClockData.Hours);
    writeln('   DayOfWeek:',RealTimeClockData.DayOfWeek);
    writeln('         Day:',RealTimeClockData.Day);
    writeln('       Month:',RealTimeClockData.Month);
    writeln('        Year:',RealTimeClockData.Year);
  end;
end;

procedure dof103; {get realtime clock}
var fc:text;
begin
  with FIPPrec do
  begin
    if not(GetRealTimeClock(FIPPrec)) then Exit;
    ShowRealTimeClock;
    assign(fc,'REALTIME.DAT');
    rewrite(fc);
    writeln(fc,RealTimeClockData.Milliseconds);
    writeln(fc,RealTimeClockData.Seconds);
    writeln(fc,RealTimeClockData.Minutes);
    writeln(fc,RealTimeClockData.Hours);
    writeln(fc,RealTimeClockData.DayOfWeek);
    writeln(fc,RealTimeClockData.Day);
    writeln(fc,RealTimeClockData.Month);
    writeln(fc,RealTimeClockData.Year);
    close(fc);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof104; {set realtime clock}
var what:string80;
var fc:text;
begin
  with FIPPrec do
  begin
    What := 'REALTIME.DAT';
    if FileExists(what) then
    begin
      assign(fc,What);
      writeln('Loading real time clock data from REALTIME.DAT file');
      reset(fc);
      readln(fc,RealTimeClockData.Milliseconds);
      readln(fc,RealTimeClockData.Seconds);
      readln(fc,RealTimeClockData.Minutes);
      readln(fc,RealTimeClockData.Hours);
      readln(fc,RealTimeClockData.DayOfWeek);
      readln(fc,RealTimeClockData.Day);
      readln(fc,RealTimeClockData.Month);
      readln(fc,RealTimeClockData.Year);
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find REALTIME.DAT file');
      Exit;
    end;
    ShowRealTimeClock;
    if not(SetRealTimeClock(FIPPrec)) then Exit;
  end;
  pfunerr := 0;
end;

{---------}
procedure dof105; {get output transducer selection}
begin
  with FIPPrec do
  begin
    if not(GetOutputDevice(FIPPrec)) then Exit;
    writeln('Output Device Selection : ',OutputDevice);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof106; {set output transducer selection}
begin
  with FIPPrec do
  begin
    if not(GetOutputDevice(FIPPrec)) then Exit;
    writeln('Output Device = ',OutputDevice);
    write('Enter new output device selection : ');
    readln(temp);
    OutputDevice := temp;
    if not(SetOutputDevice(FIPPrec)) then Exit;
    writeln('New Output Device selection = ',OutputDevice);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof107; {get impulse rejection}
begin
  with FIPPrec do
  begin
    if not(GetImpulseRej(FIPPrec)) then Exit;
    writeln('Current Impulse Rejection = ',DbStr100(ImpulseRej,true));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof108; {set impulse rejection}
var tmp:single;
begin
  with FIPPrec do
  begin
    if not(GetImpulseRej(FIPPrec)) then Exit;
    writeln('Current Impulse Rejection = ',ImpulseRej div 100,'dB');
    write('Enter new Impulse Rejection value (3, 6, etc. 0=off) : ');
    readln(tmp);
    if tmp > 40 then Exit;
    ImpulseRej := trunc(tmp * 100);
    if not(SetImpulseRej(FIPPrec)) then Exit;
    writeln('New Impulse Rejection = ',DbStr100(ImpulseRej,true));
  end;
  pfunerr := 0;
end;

{---------}
procedure ShowSignalInfo;
begin
  with FIPPrec do
  begin
    writeln(' Sample Rate:',SignalInfo.SampleRate,' Hz');
    writeln('Capture Size:',SignalInfo.CaptureSize,' Samples');
    writeln(' Source Size:',SignalInfo.SourceSamples,' Samples');
    writeln('   Ramp Size:',SignalInfo.RampSamples,' Samples');
    writeln('Coupler Skew:',SignalInfo.CouplerSkew,' Samples');
    writeln('  Probe Skew:',SignalInfo.ProbeSkew,' Samples');
    writeln(' Input GainA:',DbStr(SignalInfo.GainA,false));
    writeln(' Input GainB:',DbStr(SignalInfo.GainB,false));
    writeln('Rms Offset L:',DbStr(SignalInfo.RmsOffsetLeft,false));
    writeln('Rms Offset R:',DbStr(SignalInfo.RmsOffsetRight,false));
    writeln(' Max Level L:',DbStr(SignalInfo.MaxLevelLeft,false));
    writeln(' Max Level R:',DbStr(SignalInfo.MaxLevelRight,false));
   if SignalInfoSize > 12 then
   begin
    writeln(' Gain IndexA:',SignalInfo.GainIndexA);  {13}
    writeln(' Gain IndexB:',SignalInfo.GainIndexB); {14}
    writeln('Hw Gain SelA:',SignalInfo.HwGainSelectA);  {15}
    writeln('Hw Gain SelB:',SignalInfo.HwGainSelectB); {16}
   end;
   if SignalInfoSize > 16 then
   begin
    writeln('InputLevelA:',DbStr(SignalInfo.InputLevelA,false));  {17}
    writeln('InputLevelB:',DbStr(SignalInfo.InputLevelB,false)); {18}
    writeln('  HeadroomA:',DbStr(SignalInfo.HeadroomA,false));  {19}
    writeln('  HeadroomB:',DbStr(SignalInfo.HeadroomB,false)); {20}
   end;
  end;
end;

procedure dof109; {get signal info}
var fc:text;
begin
  with FIPPrec do
  begin
    SignalInfoSize := 0;
    if not(GetSignalInfo(FIPPrec)) then Exit;
    ShowSignalInfo;
    assign(fc,'SIGINFO.DAT');
    rewrite(fc);
    writeln(fc,SignalInfo.SampleRate);   {1}
    writeln(fc,SignalInfo.CaptureSize);  {2}
    writeln(fc,SignalInfo.SourceSamples);{3}
    writeln(fc,SignalInfo.RampSamples);  {4}
    writeln(fc,SignalInfo.CouplerSkew);  {5}
    writeln(fc,SignalInfo.ProbeSkew);    {6}
    writeln(fc,SignalInfo.GainA);        {7}
    writeln(fc,SignalInfo.GainB);        {8}
    writeln(fc,SignalInfo.RmsOffsetLeft); {9}
    writeln(fc,SignalInfo.RmsOffsetRight);{10}
    writeln(fc,SignalInfo.MaxLevelLeft);  {11}
    writeln(fc,SignalInfo.MaxLevelRight); {12}
    if SignalInfoSize > 12 then
    begin
      writeln(fc,SignalInfo.GainIndexA);  {13}
      writeln(fc,SignalInfo.GainIndexB); {14}
      writeln(fc,SignalInfo.HwGainSelectA);  {15}
      writeln(fc,SignalInfo.HwGainSelectB); {16}
    end;
    if SignalInfoSize > 16 then
    begin
      writeln(fc,SignalInfo.InputLevelA);  {17}
      writeln(fc,SignalInfo.InputLevelB); {18}
      writeln(fc,SignalInfo.HeadroomA);  {19}
      writeln(fc,SignalInfo.HeadroomB); {20}
    end;
    close(fc);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof110; {get raw capture data}
var s:string80;
var fc:text;
var i : integer;
var N : longint;
begin
  with FIPPrec do
  begin
    write('Enter Data Sample to Get (0-1) : ');
    readln(temp);
    RawDataSelection := temp;
    write('Enter Colection Method (0=current, 1=new) : ');
    readln(temp);
    RawDataMethod := temp;
    write('Enter Number of Samples to Get (0=default) : ');
    readln(temp);
    RawSampleCount := temp;
    if not(GetRawSampleData(FIPPrec)) then Exit;
    s := 'Sample'+fstr(RawDataSelection)+'.DAT';
 {//   ShowSample(FIPPrec);}
    write('Sample ',RawDataSelection,' Saved to: ',S);
    write(' Bits:',RawSampleData^[3]);
    write(' Trg:',RawSampleData^[4]);
    write(' Rate:',RawSampleData^[5]);
    write(' Gain:',Str3D(RawSampleData^[6]),'dB');
    writeln;
    assign(fc,S);
    rewrite(fc);
    for i := 0 to pred(RawSamplePacketSize) do
    begin
      if ShowInt = true then
        N := smallint(RawSampleData^[i])
      else N := word(RawSampleData^[i]);
      if (Delimit = true) and (i < pred(RawSamplePacketSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof112; {set curve selection}
begin
  with FIPPrec do
  begin
    if not(GetCurveSelect(FIPPrec)) then Exit;
    CurveSelectValid := true;
    writeln('Selected Curve = ',CurveSelect);
    write('Enter new Curve selection : ');
    readln(temp);
    CurveSelect := temp;
    if not(SetCurveSelect(FIPPrec)) then Exit;
    writeln('New Curve selection = ',CurveSelect);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof113; {get curve selection}
begin
  with FIPPrec do
  begin
    if not(GetCurveSelect(FIPPrec)) then Exit;
    writeln('Curve Selection : ',CurveSelect);
    CurveSelectValid := true;
  end;
  pfunerr := 0;
end;

{---------}
procedure dof114; {set curve status}
begin
  with FIPPrec do
  begin
    write('Enter Status Curve Number: ');
    readln(temp);
    CurveSelect := temp;
{//    if not CurveSelectValid then              }
{//    begin                                      }
{//      if not(GetCurveSelect(FIPPrec)) then Exit;}
{//      CurveSelectValid := true;                  }
{//    end;                                          }
    if not(GetCurveStatus(FIPPrec)) then Exit;
    writeln('Curve Selection = ',CurveSelect);
    writeln('Curve Status    = ',CurveStatus);
      write('Enter new Curve Status: ');
    readln(temp);
    CurveStatus := temp;
    if not(SetCurveStatus(FIPPrec)) then Exit;
    writeln('New Curve Status = ',CurveStatus);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof115; {get curve status }
begin
  with FIPPrec do
  begin
    write('Enter Status Curve Number: ');
    readln(temp);
    CurveSelect := temp;
{//    if not CurveSelectValid then           }
{//    begin                                   }
{//      if not(GetCurveSelect(FIPPrec)) then Exit;}
{//      CurveSelectValid := true;            }
{//    end;                                    }
    if not(GetCurveStatus(FIPPrec)) then Exit;
    writeln('Curve Selection = ',CurveSelect);
    writeln('   Curve Status = ',CurveStatus);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof116; {set unaided curve selection}
begin
  with FIPPrec do
  begin
    if not(GetUnaidedSelect(FIPPrec)) then Exit;
    write('Selected Unaided Curve = ',UnaidedSelect);
    if UnaidedSelect = 0 then
      writeln(' (Custom)')
    else writeln(' (Average)');
    write('Enter new Unaided Curve Selection (0=Custom, 1=Average) : ');
    readln(temp);
    UnaidedSelect := temp;
    if not(SetUnaidedSelect(FIPPrec)) then Exit;
    write('New Unaided Curve selection = ',UnaidedSelect);
    if UnaidedSelect = 0 then
      writeln(' (Custom)')
    else writeln(' (Average)');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof117; {get unaided curve selection}
begin
  with FIPPrec do
  begin
    if not(GetUnaidedSelect(FIPPrec)) then Exit;
    write('Unaided Curve Selection : ',UnaidedSelect);
    if UnaidedSelect = 0 then
      writeln(' (Custom)')
    else writeln(' (Average)');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof121; {set curve selection}
begin
  with FIPPrec do
  begin
    if not(GetStaticToneSelect(FIPPrec)) then Exit;
    writeln('Selected Static Tone = ',StaticToneSelect);
    write('Enter New Static Tone Selection : ');
    readln(temp);
    StaticToneSelect := temp;
    if not(SetStaticToneSelect(FIPPrec)) then Exit;
    writeln('New Static Tone Selection = ',StaticToneSelect);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof122; {get static tone selection}
begin
  with FIPPrec do
  begin
    if not(GetStaticToneSelect(FIPPrec)) then Exit;
    writeln('Static Tone Selection : ',StaticToneSelect);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof123; {set aid type}
begin
  with FIPPrec do
  begin
    if not(GetStaticToneSelect(FIPPrec)) then Exit;
    writeln('Selected Aid Type = ',AidTypeSelect);
    write('Enter New Aid Type Selection : ');
    readln(temp);
    AidTypeSelect := temp;
    if not(SetAidTypeSelect(FIPPrec)) then Exit;
    writeln('New Aid Type Selection = ',AidTypeSelect);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof124; {get aid type selection}
begin
  with FIPPrec do
  begin
    if not(GetAidTypeSelect(FIPPrec)) then Exit;
    writeln('Aid Type Selection : ',AidTypeSelect);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof125; {set bias tone Params}
begin
  with FIPPrec do
  begin
    if not(GetBiasTone(FIPPrec)) then Exit;
    if BiasToneSize = 1 then {if only one item, must be intermode dist freq diff}
    begin
      writeln('Current Intermod Distortion Frequency Difference:');
       if BiasToneSource = INVALID_DATA then writeln('Frequency Diff: OFF ($8000)')
       else if BiasToneSource = 0 then writeln('Frequency Diff: HARM (0)')
       else writeln('Frequency Diff:',BiasToneSource,'Hz');
      writeln;
      write  ('Enter new Frequency Difference: ');
      readln(temp);
      BiasToneSource := temp;
      BiasToneFrequency := INVALID_DATA;
      BiasToneDuration := INVALID_DATA;
      if not(SetBiasTone(FIPPrec)) then Exit;
      writeln;
       writeln('Frequency Diff:',BiasToneSource,'Hz');
    end
    else
    begin
      writeln('Current Bias Tone Parameters:');
       writeln('   Source:',DbStr(BiasToneSource,true));
       writeln('Frequency:',BiasToneFrequency,'Hz');
       writeln(' Duration:',BiasToneDuration,'mS');
      writeln;
      write  ('Enter new Bias Tone Source: ');
      readln(temp);
      BiasToneSource := temp;
      write  ('Enter new Bias Tone Frequency: ');
      readln(temp);
      BiasToneFrequency := temp;
      write  ('Enter new Bias Tone Duration:');
      readln(temp);
      BiasToneDuration := temp;
      if not(SetBiasTone(FIPPrec)) then Exit;
      writeln;
       writeln('   Source:',DbStr(BiasToneSource,true),'dB');
       writeln('Frequency:',BiasToneFrequency,'Hz');
       writeln(' Duration:',BiasToneDuration,'mS');
    end;
    pfunerr := 0;
  end;
end;

{---------}
procedure dof126; {get bias tone parameters}
begin
  with FIPPrec do
  begin
    if not(GetBiasTone(FIPPrec)) then Exit;
    if BiasToneSize = 1 then {if only one item, must be intermode dist freq diff}
    begin
      writeln('Current Intermod Distortion Frequency Difference:');
       if BiasToneSource = INVALID_DATA then writeln('Frequency Diff: OFF ($8000)')
       else if BiasToneSource = 0 then writeln('Frequency Diff: HARM (0)')
       else writeln('Frequency Diff:',BiasToneSource,'Hz');
      writeln;
    end
    else
    begin
      writeln('Current Bias Tone Parameters:');
      writeln('   Source:',DbStr(BiasToneSource,true));
      writeln('Frequency:',BiasToneFrequency,'Hz');
      writeln(' Duration:',BiasToneDuration,'mS');
    end;
  end;
  pfunerr := 0;
end;

{---------}
function WarbleStr(WarbleSelect:integer):string20;
begin
  if WarbleSelect = 0 then WarbleStr := ' (OFF)'
  else if WarbleSelect = 1 then WarbleStr := ' (AUTO)'
  else if WarbleSelect = 2 then WarbleStr := ' (FAST)'
  else if WarbleSelect = 3 then WarbleStr := ' (SLOW)'
  else WarbleStr := '';
end;

procedure dof129; {set warble type}
begin
  with FIPPrec do
  begin
    if not(GetWarbleSelect(FIPPrec)) then Exit;
    writeln('Selected Warble = ',WarbleSelect,WarbleStr(WarbleSelect));
    write('Enter New Warble Selection : ');
    readln(temp);
    WarbleSelect := temp;
    if not(SetWarbleSelect(FIPPrec)) then Exit;
    writeln('New Warble Selection = ',WarbleSelect,WarbleStr(WarbleSelect));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof130; {get warble selection}
begin
  with FIPPrec do
  begin
    if not(GetWarbleSelect(FIPPrec)) then Exit;
    writeln('Warble Selection : ',WarbleSelect,WarbleStr(WarbleSelect));
    if (WarbleAmount > 0) then
    writeln('   Warble Amount : ',Str3D(WarbleAmount),'%');
    if (WarbleRate > 0) then
    writeln('     Warble Rate : ',Str3D(WarbleRate),'%');
  end;
  pfunerr := 0;
end;


{---------}
procedure dof131; {get delay measurments}
begin
  with FIPPrec do
  begin
    if not(GetDelayMeasurments(FIPPrec)) then Exit;
    writeln('System Delay      :',SystemDelay,'uS');
    if (WarbleAmount > 0) then
    writeln('Hearing Aid Delay : ',HearingAidDelay,'uS');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof132; {set Rcv Timeout}
begin
  with FIPPrec do
  begin
    if not(GetRcvTimeout(FIPPrec)) then Exit;
    writeln('Current Receive Timeout = ',RcvTimeout);
    write('Enter new Receive Timeout (mS): ');
    readln(temp);
    RcvTimeout := temp;
    if not(SetRcvTimeout(FIPPrec)) then Exit;
    writeln('New Receive Timeout = ',RcvTimeout);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof133; {get Rcv Timeout}
begin
  with FIPPrec do
  begin
    if not(GetRcvTimeout(FIPPrec)) then Exit;
    writeln('Receive Timeout : ',RcvTimeout);
  end;
  pfunerr := 0;
end;



{---------}
procedure dof134; {set Fit Rule}
begin
  with FIPPrec do
  begin
    if not(GetFitRule(FIPPrec)) then Exit;
    writeln('Current Fit Rule = ',FitRule);
    write('Enter new Fit Rule : ');
    readln(temp);
    FitRule := temp;
    if not(SetFitRule(FIPPrec)) then Exit;
    writeln('New Fit Rule = ',FitRule);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof135; {get Fit Rule}
begin
  with FIPPrec do
  begin
    if not(GetFitRule(FIPPrec)) then Exit;
    writeln('Fit Rule: ',FitRule);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof136; {set Filter}
begin
  with FIPPrec do
  begin
    if not(GetFilter(FIPPrec)) then Exit;
    writeln('Current Filter = ',FilterType);
    write('Enter new Filter : ');
    readln(temp);
    FilterType := temp;
    if not(SetFilter(FIPPrec)) then Exit;
    writeln('New Filter = ',FilterType);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof137; {get Filter}
begin
  with FIPPrec do
  begin
    if not(GetFilter(FIPPrec)) then Exit;
    writeln('Filter: ',FilterType);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof138; {set compression value}
var tmp:single;
begin
  with FIPPrec do
  begin
    if not(GetCompression(FIPPrec)) then Exit;
    writeln('Current Compression Threshold = ',Compression div 100,'dB');
    write('Enter new Compression Treashold (40, 50, etc. 0=min) : ');
    readln(tmp);
    {if tmp > 40 then Exit;}
    Compression := trunc(tmp * 100);
    if not(SetCompression(FIPPrec)) then Exit;
    writeln('New Compression Threshold = ',DbStr100(Compression,true));
  end;
  pfunerr := 0;
end;


{---------}
procedure dof139; {get compression value}
begin
  with FIPPrec do
  begin
    if not(GetCompression(FIPPrec)) then Exit;
    writeln('Current Compression = ',DbStr100(Compression,true));
  end;
  pfunerr := 0;
end;


{---------}
procedure dof140; {set age}
begin
  with FIPPrec do
  begin
    if not(GetClientAge(FIPPrec)) then Exit;
    writeln('Current Age = ',ClientAge,' Mo');
    write('Enter new Age (12, 24, etc. 0=none) : ');
    readln(temp);
    ClientAge := temp;
    if not(SetClientAge(FIPPrec)) then Exit;
    writeln('New Age = ',ClientAge,' Mo');
  end;
  pfunerr := 0;
end;


{---------}
procedure dof141; {get ClientAge}
begin
  with FIPPrec do
  begin
    if not(GetClientAge(FIPPrec)) then Exit;
    writeln('Current Age = ',ClientAge,' Mo');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof142; {set transducer loc}
begin
  with FIPPrec do
  begin
    if not(GetTransducerLoc(FIPPrec)) then Exit;
    writeln('Location = ',TransducerLoc);
    write('Enter Location (0, 45) : ');
    readln(temp);
    TransducerLoc := temp;
    if not(SetTransducerLoc(FIPPrec)) then Exit;
    writeln('New Location = ',TransducerLoc);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof143; {get transducer loc}
begin
  with FIPPrec do
  begin
    if not(GetTransducerLoc(FIPPrec)) then Exit;
    writeln('Location = ',TransducerLoc);
  end;
  pfunerr := 0;
end;



{------}
procedure dof145; {Set leveling list}
var What : string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
    ii:word;
    i : integer;
begin
  with FIPPrec do
  begin
    What := 'LEVELING.DAT';
    if FileExists(What) then
    begin
      assign(fc,What);
      writeln('Loading Leveling data from LEVELING.DAT file');
      reset(fc);
      for i := 0 to pred(LevelingListSize) do
      begin
        readln(fc,LevelingList[i]);
      end;
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find LEVELING.DAT file');
      Exit;
    end;

    if not(SetLevelingList(FIPPrec)) then Exit;
    ii := 0;
    for i := 0 to pred(LevelingListSize) do
    begin
      write(fStr(LevelingList[i]),' ');
      inc(ii);
      if ii > 9 then
      begin
        writeln;
        ii := 0;
      end;
    end;

  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof146;        {get leveling list}
var i,ii : integer;
    N : longint;
    fc:text;
begin
  with FIPPrec do
  begin
    write('Enter Leveling List to Get (0-1) : ');
    readln(temp);
    WhichLevelingList := temp;
    if not(GetLevelingList(FIPPrec)) then Exit;
    writeln('Leveling List ',WhichLevelingList,':  Saved to LEVELING.DAT');
    assign(fc,'LEVELING.DAT');
    rewrite(fc);
    for i := 0 to pred(LevelingListSize) do
    begin
      if (ShowInt = true) then
        N := smallint(LevelingList[i])
        else N:= word(LevelingList[i]);
      if (Delimit = true) and (i < pred(LevelingListSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof147; {set leveling status }
begin
  with FIPPrec do
  begin
    if not(GetLevelState(FIPPrec)) then Exit;
    write('Current Leveling State = ');
    case LevelState of
      0 : writeln('Leveled      (0)');
      1 : writeln('Semi-leveled (1)');
      2 : writeln('Un-leveled   (2)');
    else
      writeln(LevelState);
    end;

    write('Enter new Leveling State: ');
    readln(temp);
    LevelState := temp;
    if not(SetLevelingStatus(FIPPrec)) then Exit;
    writeln('New Leveling State = ',LevelState);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof148; {set aux port}
var tstr:string[255];
begin
  with FIPPrec do
  begin
    if not(GetAuxPort(FIPPrec)) then Exit;
    write('Current Aux Control State = $',HEXW(AuxCtrl),'   Input:');
    if AuxInCOunt = 0 then write('<none>') else write('$',HexB(BYTE(AuxInData^[0])));
    writeln;

    write('Enter Start Aux Ctrl State ($nnnn) (-1=none):');
    readln(temp);
    AuxStartCtrl := temp;

    write('Enter text to send ("."=none): ');
    readln(tstr);
    if ((tstr[1] = '.') and (length(tstr) = 1)) or (Length(tstr) = 0) then
    begin
      AuxOutCount := 0;
    end
    else
    begin
      AuxOutCount := ord(tstr[0]);
      move(tstr[1],AuxOutData^,AuxOutCount);
    end;

    write('Enter Stop Aux Ctrl State ($nnnn) (-1=none):');
    readln(temp);
    AuxEndCtrl := temp;

    if not(SetAuxPort(FIPPrec)) then Exit;
    writeln('Done');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof149; {get aux port}
begin
  with FIPPrec do
  begin
    if not(GetAuxPort(FIPPrec)) then Exit;
    write('Current Aux Control State = $',HEXW(AuxCtrl),'   Input:');
    if AuxInCount = 0 then write('<none>')
     else ShowBytes(FIPPrec,AuxInData^,AuxInCount,2);  {write('$',HexB(BYTE(AuxInData^[0])));}
    writeln;
  end;
  pfunerr := 0;
end;


{---------}
procedure dof150; {set User Number }
begin
  with FIPPrec do
  begin
    if not(GetUserNumber(FIPPrec)) then Exit;
    writeln('Current User Number = ',UserNumber);
    writeln('Maximum User Number = ',MaxUser);
    writeln('Enter new User Number');
    write('0=default, 1=User#1, 2=User#2, etc.): ');
    readln(temp);
    UserNumber := temp;
    if not(SetUserNumber(FIPPrec)) then Exit;
    writeln('New User Number = ',UserNumber);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof151; {Get User Number }
begin
  with FIPPrec do
  begin
    if not(GetUserNumber(FIPPrec)) then Exit;
    writeln('Current User Number (0=default) = ',UserNumber);
    writeln('Maximum User Number = ',MaxUser);
  end;
  pfunerr := 0;
end;

{---------}
function FitTypeStr(FitType:integer):string20;
begin
  if FitType = 0 then FitTypeStr := ' (OFF)'
  else if FitType = 1 then FitTypeStr := ' (UNILATERAL)'
  else if FitType = 2 then FitTypeStr := ' (BILATERAL)'
  else FitTypeStr := '';
end;

procedure dof152;   {get fit type}
begin
  with FIPPrec do
  begin
    if not(GetFitType(FIPPrec)) then Exit;    {153} {fp35 v3.20 12/01/03}
    writeln('Fit Type : ',Fit.AidFitType,FitTypeStr(Fit.AidFitType));
    write('Enter Fit Type : (1=Unilateral, 2=Bilateral)');
    readln(temp);
    Fit.AidFitType := temp;
    if not(SetFitType(FIPPrec)) then Exit;    {152} {fp35 v3.20 12/01/03}
    writeln('New Fit Type = ',Fit.AidFitType,FitTypeStr(Fit.AidFitType));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof153;
begin
  with FIPPrec do
  begin
    if not(GetFitType(FIPPrec)) then Exit;    {153} {fp35 v3.20 12/01/03}
    writeln('Fit Type = ',Fit.AidFitType,FitTypeStr(Fit.AidFitType));
  end;
  pfunerr := 0;
end;

{---------}
function VentTypeStr(VentType:integer):string20;
begin
  case VentType of
    FIT_VENT_OPEN:      {0 Vent Open}
      VentTypeStr := ' (Open)';
    FIT_VENT_OCCLUDED:  {1 Vent Occluded}
      VentTypeStr := ' (Occluded)';
    FIT_VENT_TIGHT:     {2 Vent tight}
      VentTypeStr := ' (Tight)';
    FIT_VENT_MM1:       {3 Vent 1mm}
      VentTypeStr := ' (1mm)';
    FIT_VENT_MM2:       {4 Vent 2mm}
      VentTypeStr := ' (2mm)';
    FIT_VENT_MM3:       {5 Vent 3mm}
      VentTypeStr := ' (3mm)';
    else
      VentTypeStr := '';
  end;
end;

procedure dof154;
begin
  with FIPPrec do
  begin
    if not(GetVentType(FIPPrec)) then Exit;    {155} {fp35 v3.20 12/01/03}
    writeln('Vent Type : ',Fit.AidVentType,VentTypeStr(Fit.AidVentType));
    write('Enter Vent Type : ');
    readln(temp);
    Fit.AidVentType := temp;
    if not(SetVentType(FIPPrec)) then Exit;    {154} {fp35 v3.20 12/01/03}
    writeln('New Vent Type = ',Fit.AidVentType,VentTypeStr(Fit.AidVentType));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof155;
begin
  with FIPPrec do
  begin
    if not(GetVentType(FIPPrec)) then Exit;    {155} {fp35 v3.20 12/01/03}
    writeln('Vent Type = ',Fit.AidVentType,VentTypeStr(Fit.AidVentType));
  end;
  pfunerr := 0;
end;

{---------}
function TubingTypeStr(TubingType:integer):string80;
begin
  case TubingType of
    FIT_TUBING_NONE:    {0 Tubing ( None ) [cic, itc, ite aids] }
      TubingTypeStr := ' (None)';
    FIT_TUBING_LIBBY4:  {1 Tubing ( Libby 4 )                   }
      TubingTypeStr := ' (Libby 4)';
    FIT_TUBING_LIBBY3:  {2 Tubing ( Libby 3 )                   }
      TubingTypeStr := ' (Libby 3)';
    FIT_TUBING_CFA2:    {3 Tubing ( CFA #2 horn )               }
      TubingTypeStr := ' (CFA #2 horn)';
    FIT_TUBING_CFA3:    {4 Tubing ( CFA #3 stepped bore )       }
      TubingTypeStr := ' (CFA #3 stepped bore)';
    FIT_TUBING_No13:    {5 Tubing ( #13 )                       }
      TubingTypeStr := ' (#13)';
    FIT_TUBING_sixC5:   {6 Tubing ( 6C5 )                       }
      TubingTypeStr := ' (6C5)';
    FIT_TUBING_sixC10:  {7 Tubing ( 6C10 )                      }
      TubingTypeStr := ' (6C10)';
    else
      TubingTypeStr := '';
  end;
end;

procedure dof156;
begin
  with FIPPrec do
  begin
    if not(GetTubingType(FIPPrec)) then Exit;    {157} {fp35 v3.20 12/01/03}
    writeln('Tubing Type : ',Fit.AidTubingType,TubingTypeStr(Fit.AidTubingType));
    write('Enter Tubing Type : ');
    readln(temp);
    Fit.AidTubingType := temp;
    if not(SetTubingType(FIPPrec)) then Exit;    {156} {fp35 v3.20 12/01/03}
    writeln('New Tubing Type = ',Fit.AidTubingType,TubingTypeStr(Fit.AidTubingType));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof157;
begin
  with FIPPrec do
  begin
    if not(GetTubingType(FIPPrec)) then Exit;    {157} {fp35 v3.20 12/01/03}
    writeln('Tubing Type = ',Fit.AidTubingType,TubingTypeStr(Fit.AidTubingType));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof158;
begin
  with FIPPrec do
  begin
    if not(GetAidChannels(FIPPrec)) then Exit;    {159} {fp35 v3.20 12/01/03}
    writeln('Aid Channels : ',Fit.AidChannels);
    write('Enter Aid Channels : ');
    readln(temp);
    Fit.AidChannels := temp;
    if not(SetAidChannels(FIPPrec)) then Exit;    {158} {fp35 v3.20 12/01/03}
    writeln('New Aid Channels = ',Fit.AidChannels,Fit.AidChannels);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof159;
begin
  with FIPPrec do
  begin
    if not(GetAidChannels(FIPPrec)) then Exit;    {159} {fp35 v3.20 12/01/03}
    writeln('Aid Channels = ',Fit.AidChannels,Fit.AidChannels);
  end;
  pfunerr := 0;
end;

{---------}
function AidLimitingStr(Limiting:integer):string20;
begin
  case Limiting of
    0: AidLimitingStr := ' (NONE)';
    1: AidLimitingStr := ' (WIDEBAND)';
    2: AidLimitingStr := ' (MULTICHAN.)';
    else AidLimitingStr := '';
  end;
end;

procedure dof160;
begin
  with FIPPrec do
  begin
    if not(GetAidLimiting(FIPPrec)) then Exit;    {161} {fp35 v3.20 12/01/03}
    writeln('Aid Limiting : ',Fit.AidLimiting,AidLimitingStr(Fit.AidLimiting));
    write('Enter Aid Limiting : ');
    readln(temp);
    Fit.AidLimiting := temp;
    if not(SetAidLimiting(FIPPrec)) then Exit;    {160} {fp35 v3.20 12/01/03}
    writeln('New Aid Limiting = ',Fit.AidLimiting,AidLimitingStr(Fit.AidLimiting));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof161;
begin
  with FIPPrec do
  begin
    if not(GetAidLimiting(FIPPrec)) then Exit;    {161} {fp35 v3.20 12/01/03}
    writeln('Aid Limiting = ',Fit.AidLimiting,AidLimitingStr(Fit.AidLimiting));
  end;
  pfunerr := 0;
end;

{---------}
{type FitRecordType = packed record}
{       FitRule:integer;       }
{       ClientAge:integer;     }
{       AidGroup:integer;      }
{       AidType:integer;       }
{       AidCompression:integer;}
{       OutputDevice:integer;  }
{       SpeakerLoc:integer;    }
{       AidChannels:integer;   }
{       AidLimiting:integer;   }
{       AidFitType:integer;    }
{       AidVentType:integer;   }
{       AidTubingType:integer; }
{     end;}
procedure ShowFitParam;
begin
  writeln('Fit Rule    :',FIPPrec.Fit.FitRule);
  writeln('Client Age  :',FIPPrec.Fit.ClientAge);
  writeln('Aid Group   :',FIPPrec.Fit.AidGroup);
  writeln('Aid Type    :',FIPPrec.Fit.AidType);
  writeln('Aid Compres.:',FIPPrec.Fit.AidCompression);
  writeln('Output Dev. :',FIPPrec.Fit.OutputDevice);
  writeln('Speaker Loc.:',FIPPrec.Fit.SpeakerLoc);
  writeln('Aid Chan.   :',FIPPrec.Fit.AidChannels);
  writeln('Limiting    :',FIPPrec.Fit.AidLimiting);
  writeln('Fit Type    :',FIPPrec.Fit.AidFitType);
  writeln('Vent Type   :',FIPPrec.Fit.AidVentType);
  writeln('Tubing Type :',FIPPrec.Fit.AidTubingType);
end;

{---------}
procedure dof164; {set fit params}
var what:string80;
var fc:text;
begin
  with FIPPrec do
  begin
    What := 'FITPARAM.DAT';
    if FileExists(what) then
    begin
      assign(fc,What);
      writeln('Loading Fitting params FITPARAM.DAT file');
      reset(fc);
      readln(fc,Fit.FitRule);
      readln(fc,Fit.ClientAge);
      readln(fc,Fit.AidGroup);
      readln(fc,Fit.AidType);
      readln(fc,Fit.AidCompression);
      readln(fc,Fit.OutputDevice);
      readln(fc,Fit.SpeakerLoc);
      readln(fc,Fit.AidChannels);
      readln(fc,Fit.AidLimiting);
      readln(fc,Fit.AidFitType);
      readln(fc,Fit.AidVentType);
      readln(fc,Fit.AidTubingType);
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find FITPARAM.DAT file');
      Exit;
    end;
    ShowFitParam;
    if not(SetFitParam(FIPPrec)) then Exit;
  end;
  pfunerr := 0;
end;

{---------}
procedure dof165;  {get fit params}
var fc:text;
begin
  with FIPPrec do
  begin
    if not(GetFitParam(FIPPrec)) then Exit;    {162} {fp35 v3.20 12/01/03}
    ShowFitParam;
    assign(fc,'FITPARAM.DAT');
    rewrite(fc);
    writeln(fc,Fit.FitRule);
    writeln(fc,Fit.ClientAge);
    writeln(fc,Fit.AidGroup);
    writeln(fc,Fit.AidType);
    writeln(fc,Fit.AidCompression);
    writeln(fc,Fit.OutputDevice);
    writeln(fc,Fit.SpeakerLoc);
    writeln(fc,Fit.AidChannels);
    writeln(fc,Fit.AidLimiting);
    writeln(fc,Fit.AidFitType);
    writeln(fc,Fit.AidVentType);
    writeln(fc,Fit.AidTubingType);
    close(fc);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof166;    {set User ID text}
var Uid : str255;
    i : integer;
    c : char;
begin
  writeln;
  write('Enter User ID Text set (0=Default, 1=User#1, 2=User#2, etc.): ');
  readln(temp);
  if (Temp < 0) or (Temp > 15) then Temp := 0;
  FIPPrec.UserNumber := temp;
  if not(GetUserIDText(FIPPrec)) then Exit;
  c := #255;
  if not(LabelBlank) then
  begin
    ShowLabel(1);
    writeln;
    writeln('Press ESCape to send this User ID,');
    write('Press any other key to enter new text: ');
    c := GetKey;
    writeln;
  end
  else
  begin
    writeln('Enter User ID Text');
  end;
  writeln;
  if (c <> #$1b) then
  begin
    Uid :=       EntLab('L1:___________________________|',27)+#0;
    Uid := Uid + EntLab('L2:___________________________|',27)+#0;
    i := 1;
    while i < MaxUserIDTextSize do
    begin
      FIPPrec.UserIDText[FIPPrec.UserNumber][pred(i)] := Uid[i];
      inc(i);
    end;
    FIPPrec.UserIDText[FIPPrec.UserNumber][pred(i)] := #0;
  end;
  if not(SetUserIDText(FIPPrec)) then Exit;
  writeln;
  writeln('* User ID Sent *');
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof167;    {get User ID TEXT }
var temp : integer;
begin
  write('Enter User ID text to read (0=Default, 1=User#1, 2=User#2, etc.): ');
  readln(temp);
  if (temp > 15) or (Temp < 0) then Temp := 0;
  FIPPrec.UserNumber := temp;
  if not(GetUserIDText(FIPPrec)) then Exit;
  writeln('Current User ID Text:');
  writeln;
  ShowLabel(1);
  writeln;
  pfunerr := 0;
end;

end.

