
{blob display routines for use with test programs}
{Copyright 1992,1998,2003 Frye Electronics -- writen by Michael Day}
{V5.10 as of 2 May 2003}

unit ShowBlob;
interface
uses TestFipp,TestSubs;

procedure ShowCurve(var FIPPrec:FIPPrecType);
procedure ShowAnsiBlob(var FIPPrec:FIPPrecType);
procedure ShowIecBlob(var FIPPrec:FIPPrecType);
procedure ShowJisBlob(var FIPPrec:FIPPrecType);
procedure ShowAnsi92Blob(var FIPPrec:FIPPrecType);
procedure ShowUnknownBlob(var FIPPrec:FIPPrecType);
procedure ShowBytes(var FIPPrec:FIPPrecType; var Data; Size:word; Show:WORD);

implementation

procedure ShowCurve(var FIPPrec:FIPPrecType);
var i,ii:integer;
    Tw2,Tw3 : word;
    Ts : longint;
    V : boolean;
begin
  ii := 0;
  with FIPPrec do
  begin
    Tw2 := CurveFrame[2]; {convert to word to keep compiler happy}
    Tw3 := CurveFrame[3]; {when it converts to long int}
    Ts := longint(Tw2)+(longint(Tw3) shl 16); {time stamp}
    for i := 0 to pred(CurveFrameSize) do
    begin
      if (i >= 4) and (word(CurveFrame[i]) = $8000) then write(' -----')
      else
      begin
        case i of
         0..1: write(' ',HexW(word(CurveFrame[i])),'H');
            2: if ValidTimeStamp(Ts) then
               begin
                 write(' ',GetStampDateStr(Ts,V),' ',GetStampTimeStr(Ts,true,V))
               end
               else
               begin
                 write(' ',HexW(word(CurveFrame[2])),'H');
                 write(' ',HexW(word(CurveFrame[3])),'H');
                 write('      ');
               end;
            3: {nop};
            4: write(Str2d(CurveFrame[i]));
         5..6: write(Str2d(CurveFrame[i]));
            7: write(rstr(CurveFrame[7],6));
         8..MaxCurveSize-1:
               write(Str2d(CurveFrame[i]));
          else write(' ',HexW(word(CurveFrame[i])),'H');
        end;
      end;
      if (i=7) then
      begin
        writeln;
        ii := 0;
      end
      else
      begin
        inc(ii);
        if ii > 11 then
        begin
          writeln;
          ii := 0;
        end;
      end;
    end;
  end;
end;

{blob display for ansi87/96}
procedure ShowAnsiBlob(var FIPPrec:FIPPrecType);
var ii,i:integer;
begin
  with FIPPrec do
  begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=14) and (i<=17)) or
              ((i>=104) and (i<=107)) or
              ((i>=273) and (i<=276))) and
          (Blob[i] = $8000) then write(' -----')
       else
       begin
        case i of
            0..2  : write(Blob[i]:6);              {maj,min,blobsize}
            3..5  : write(Blob[i]:6);              {avg freqs}
            6..8  : write(Blob[i]:6);              {dist freqs}
               9  : write(Blob[i]:6);              {aidtyp}
          10..13 : write(Str2D(integer(Blob[i]))); {fogsrc,coil,calcrtg,measrtg}

          14..17 : write(' ',Hexw(Blob[i]),'H');   {sspl90 cf}
          18..20 : write(Str2D(integer(Blob[i])));
              21 : write(Blob[i]:6);
          22..101: write(Str2D(integer(Blob[i])));

         102..103: write(Str2D(integer(Blob[i])));  {avgospl90,fogavg}

         104..107: write(' ',Hexw(Blob[i]),'H');    {rsp cf}
         108..110: write(Str2D(integer(Blob[i])));
              111: write(Blob[i]:6);
         112..191: write(Str2D(integer(Blob[i])));

              192: write(Str2D(integer(Blob[i])));  {rsp limit}
         193..194: write(Blob[i]:6);                {f1,f2}
         195..197: write(Str2D(integer(Blob[i])));  {tdh1,thd2,thd3}
              198: write(Str2D(integer(Blob[i])));  {battcur}
              199: write(Blob[i]:6);                {batt type}
              200: write(Str2D(integer(Blob[i])));  {eqin}
              201: write(Blob[i]:6);                {iofreq #1}
         202..210: write(Str2D(integer(Blob[i])));  {iodata[9]}
         211..212: write(Blob[i]:6);                {attack,release}
              {ansi97 only below here}
              213: write(Blob[i]:6);                {iofreq #2}
         214..222: write(Str2D(integer(Blob[i])));  {iodata[9]}
              223: write(Blob[i]:6);                {iofreq #3}
         224..232: write(Str2D(integer(Blob[i])));  {iodata[9]}
              233: write(Blob[i]:6);                {iofreq #4}
         234..242: write(Str2D(integer(Blob[i])));  {iodata[9]}
              243: write(Blob[i]:6);                {iofreq #5}
         244..252: write(Str2D(integer(Blob[i])));  {iodata[9]}
              253: write(Blob[i]:6);                {iofreq #6}
         254..262: write(Str2D(integer(Blob[i])));  {iodata[9]}

         263..267: write(Blob[i]:6);                {attack[5]}
         268..272: write(Blob[i]:6);                {release[5]}

         273..276: write(' ',Hexw(Blob[i]),'H');    {splits cf}
         277..279: write(Str2D(integer(Blob[i])));
              280: write(Blob[i]:6);
         281..360: write(Str2D(integer(Blob[i])));
              361: write(Str2D(integer(Blob[i])));  {splitsavg}

              else write(' ',Hexw(Blob[i]),'H');
        end;
       end;
       if (i=2) or (i=13) or (i=101) or (i=103) or (i=191) or
          (i=212) or (i=222) or (i=232) or (i=242) or (i=252) or (i=262) or
          (i=272) or (i=360) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
  end;
end;

procedure ShowIecBlob(var FIPPrec:FIPPrecType);
var ii,i:word;
begin
  with FIPPrec do
  begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=9) and (i<=12)) or
              ((i>=97) and (i<=100)) or
              ((i>=187) and (i<=190))  ) and
          (Blob[i] = $8000) then write(' -----')
       else
       begin
        case i of
           0..5  : write(Blob[i]:6);
           6..8  : write(Str2D(integer(Blob[i])));

           9..12 : write(' ',Hexw(Blob[i]),'H');
          13..15 : write(Str2D(integer(Blob[i])));
              16 : write(Blob[i]:6);
          17..96 : write(Str2D(integer(Blob[i])));

          97..100: write(' ',Hexw(Blob[i]),'H');
         101..103: write(Str2D(integer(Blob[i])));
              104: write(Blob[i]:6);
         105..184: write(Str2D(integer(Blob[i])));

              185: write(Str2D(integer(Blob[i])));
              186: write(Blob[i]:6);

         187..190: write(' ',Hexw(Blob[i]),'H');
         191..193: write(Str2D(integer(Blob[i])));
              194: write(Blob[i]:6);
         195..274: write(Str2D(integer(Blob[i])));

         275..276: write(Str2D(integer(Blob[i])));
              277: write(Blob[i]:6);
         278..286: write(Str2D(integer(Blob[i])));
         287..288: write(Blob[i]:6);
              else write(' ',Hexw(Blob[i]),'H');
        end;
       end;
       if (i=2) or (i=8) or (i=96) or (i=184) or (I=186) or (i=274) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
  end;
end;

procedure ShowJisBlob(var FIPPrec:FIPPrecType);
var ii,i:word;
begin
  with FIPPrec do
  begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=9) and (i<=12)) or
              ((i>=97) and (i<=100)) or
              ((i>=187) and (i<=190))) and
          (Blob[i] = $8000) then write(' -----')
       else
       begin
        case i of
           0..5  : write(Blob[i]:6);
           6..8  : write(Str2D(integer(Blob[i])));

           9..12 : write(' ',Hexw(Blob[i]),'H');  {sspl cf}
          13..15 : write(Str2D(integer(Blob[i])));
              16 : write(Blob[i]:6);
          17..96 : write(Str2D(integer(Blob[i])));

          97..100: write(' ',Hexw(Blob[i]),'H');   {fog cf}
         101..103: write(Str2D(integer(Blob[i])));
              104: write(Blob[i]:6);
         105..184: write(Str2D(integer(Blob[i])));

              185: write(Str2D(integer(Blob[i])));
              186: write(Blob[i]:6);

         187..190: write(' ',Hexw(Blob[i]),'H');   {resp cf}
         191..193: write(Str2D(integer(Blob[i])));
              194: write(Blob[i]:6);
         195..274: write(Str2D(integer(Blob[i])));

         275..278: write(Str2D(integer(Blob[i])));
              279: write(Blob[i]:6);
         280..288: write(Str2D(integer(Blob[i])));
         289..290: write(Blob[i]:6);
              else write(' ',Hexw(Blob[i]),'H');
        end;
       end;
       if (i=2) or (i=8) or (i=96) or (i=184) or (I=186) or (i=274) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
  end;
end;


procedure ShowAnsi92Blob(var FIPPrec:FIPPrecType);
var ii,i:integer;
begin
  with FIPPrec do
  begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=9) and (i<=12)) or
              ((i>=97) and (i<=100)) or
              ((i>=185) and (i<=188)) or
              ((i>=273) and (i<=276)) or
              ((i>=362) and (i<=365)) or
              ((i>454))) and
             (Blob[i] = $8000) then write(' -----')
       else
       begin
         case i of
           0..2 : write(Blob[i]:6);
           3..6 : write(Str2D(integer(Blob[i])));
           7..8 : write(Blob[i]:6);

           9..12: write(' ',Hexw(Blob[i]),'H');  {50db}
          13..15: write(Str2D(integer(Blob[i])));
              16: write(Blob[i]:6);
          17..96: write(Str2D(integer(Blob[i])));

         97..100: write(' ',Hexw(Blob[i]),'H');  {60db}
        101..103: write(Str2D(integer(Blob[i])));
             104: write(Blob[i]:6);
        105..184: write(Str2D(integer(Blob[i])));

        185..188: write(' ',Hexw(Blob[i]),'H');  {70db}
        189..191: write(Str2D(integer(Blob[i])));
             192: write(Blob[i]:6);
        193..272: write(Str2D(integer(Blob[i])));

        273..276: write(' ',Hexw(Blob[i]),'H');  {80db}
        277..279: write(Str2D(integer(Blob[i])));
             280: write(Blob[i]:6);
        281..360: write(Str2D(integer(Blob[i])));

        361..364: write(' ',Hexw(Blob[i]),'H');  {90db}
        365..367: write(Str2D(integer(Blob[i])));
             368: write(Blob[i]:6);
        369..448: write(Str2D(integer(Blob[i])));

        449..453: write(Str2D(integer(Blob[i])));

              else write(' ',Hexw(Blob[i]),'H');
         end; {case i}
       end;
       if (i=2) or (i=8) or (i=96) or (i=184) or (i=272) or (i=360) or (i=448) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
  end;
end;

procedure ShowProfileBlob(var FIPPrec:FIPPrecType);
var ii,i:integer;
begin
  with FIPPrec do
  begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
       if not(((i>=3) and (i<=6)) or
              ((i>=91) and (i<=94)) or
              ((i>=179) and (i<=182)) or
              ((i>=267) and (i<=270)) or
              ((i>=355) and (i<=358))) and
          (Blob[i] = $8000) then write(' -----')
       else
       begin
        case i of
            0..2 : write(Blob[i]:6);

            3..6 : write(' ',Hexw(Blob[i]),'H');   {crv 1}
            7..9 : write(Str2D(integer(Blob[i])));
              10 : write(Blob[i]:6);
           11..90: write(Str2D(integer(Blob[i])));

          91..94 : write(' ',Hexw(Blob[i]),'H');   {crv 2}
          95..97 : write(Str2D(integer(Blob[i])));
              98 : write(Blob[i]:6);
          99..178: write(Str2D(integer(Blob[i])));

         179..182: write(' ',Hexw(Blob[i]),'H');   {crv 3}
         183..185: write(Str2D(integer(Blob[i])));
              186: write(Blob[i]:6);
         187..266: write(Str2D(integer(Blob[i])));

         267..270: write(' ',Hexw(Blob[i]),'H');   {crv 4}
         271..273: write(Str2D(integer(Blob[i])));
              274: write(Blob[i]:6);
         275..354: write(Str2D(integer(Blob[i])));

         355..358: write(' ',Hexw(Blob[i]),'H');   {crv 5}
         359..361: write(Str2D(integer(Blob[i])));
              362: write(Blob[i]:6);
         363..442: write(Str2D(integer(Blob[i])));

              443: write(Str2D(integer(Blob[i])));  {eqin}
              444: write(' -----');
              445: write(Str2D(integer(Blob[i])));  {battcur}
              446: write(' -----');
              447: write(Blob[i]:6);                {batt type}
              448: write(' -----');

         449..464: write(Str2D(integer(Blob[i])));  {dist[16]}

              465: write(Str2D(integer(Blob[i])));  {peak}
              466: write(' -----');
              467: write(Str2D(integer(Blob[i])));  {rmsout crv2}
              468: write(' -----');
              469: write(Blob[i]:6);                {nr at 50db}
              470: write(' -----');

              else write(' ',Hexw(Blob[i]),'H');
        end;
       end;
       if (i=2) or (i=90) or (i=178) or (i=266) or (i=354) or (i=442) or
          (i=448) or (i=464) then
       begin
         writeln;
         ii := 0;
       end
       else
       begin
         inc(ii);
         if ii > 11 then
         begin
           writeln;
           ii := 0;
         end;
       end;
      end;
    end;
  end;
end;



procedure ShowUnknownBlob(var FIPPrec:FIPPrecType);
var ii,i:word;
begin
  with FIPPrec do
  begin
    ii := 0;
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
        write(HexW(Blob[i]),' ');
        inc(ii);
        if ii > 13 then
        begin
          writeln;
          ii := 0;
        end;
      end;
    end;
  end;
end;

{if Show=0, only char is shown, if Show = 1, only hex is shown, if Show = 2, both are shown}
procedure ShowBytes(var FIPPrec:FIPPrecType; var Data; Size:word; Show:word);
var ii,i:word;
var CharData : AuxDataType absolute Data;
begin
  with FIPPrec do
  begin
    ii := 0;
    if Size > 0 then
    begin
      for i := 0 to pred(Size) do
      begin
        if Show = 0 then
          write(CharData[i])
        else if Show = 1 then
          write('$',HexB(BYTE(CharData[i])),' ')
        else write('$',HexB(BYTE(CharData[i])),'(',CharData[i],') ');
        inc(ii);
        if ii > 13 then
        begin
          writeln;
          ii := 0;
        end;
      end;
    end;
  end;
end;

end.
