{--------------------------------------------------------}
function GetBinTimeStamp:longint;
var Year,Month,Day,DayofWeek:word;
var hour,minute,second,sec100:word;
    Temp,Temp1,Temp2 : longint;
begin
  GetBinTimeStamp := 0; {fail with zero}
  GetTime(Hour,Minute,Second,Sec100);
  Temp1 := longint(Hour)*longint(Minute)*longint(Second);
  GetDate(Year,Month,Day,DayofWeek);
  GetTime(Hour,Minute,Second,Sec100);
  Temp2 := longint(Hour)*longint(Minute)*longint(Second);
  if Temp1 <> Temp2 then  {catch the midnight rollover}
    GetDate(Year,Month,Day,DayofWeek);

  if Year < 1991 then Exit;
  Temp := ((Year-1990) shl 10) or
          ((succ(Month) and $f) shl 6) or
          ((succ(Day) and $1f) shl 1);
  Temp := Temp shl 16;
  GetBinTimeStamp := Temp2 or Temp;
end;

{-----------------------------------------------------}
function GetStampDateStr(Stamp:longint; var Valid:boolean):string;
var Year,Month,Day:word;
    S1,S2 : string[12];
begin
  Valid := false;
  GetStampDateStr := '        ';
  if Stamp = 0 then Exit;
  Year := (Stamp shr 26) + 1990;
  Month := (Stamp shr 22) and $000f;
  Day := (Stamp shr 17) and $001f;
  if (Day > 31) or (Day = 0) then Exit;
  if (Month > 12) or (Month = 0) then Exit;
  if Year < 1991 then Exit;

  S1 := fstr(Month)+'/';
  if length(S1) < 3 then S1 := '0'+S1;
  S2 := fstr(Day)+'/';
  if length(S2) < 3 then S2 := '0'+S2;
  GetStampDateStr := S1 + S2 + copy(fstr(Year),3,2);
  Valid := true;
end;

{-----------------------------------------------------}
function GetStampTimeStr(Stamp:longint; LongStr:boolean; var Valid:boolean):string;
var hour,minute,second:word;
    S1,S2,S3:string[12];
begin
  Valid := false;
  GetStampTimeStr := '        ';
  if Stamp = 0 then Exit;
  asm
    mov ax,word ptr [Stamp]
    mov dx,word ptr [Stamp+2]
    and dx,$0001
    mov cx,60
    div cx
    mov [Second],dx
    mov dx,0
    div cx
    mov [Minute],dx
    mov [Hour],ax
  end;
  if Minute > 59 then Exit;
  if Second > 59 then Exit;
  if Hour > 23 then Exit;

  S1 := fstr(Hour)+':';
  if length(S1) < 3 then S1 := '0'+S1;
  S2 := fstr(Minute);
  if length(S2) < 2 then S2 := '0'+S2;
  S3 := fstr(second);
  if length(S3) < 2 then S3 := ':0'+S3
  else S3 := ':'+S3;
  if not(LongStr) then
    GetStampTimeStr := S1 + S2
  else
    GetStampTimeStr := S1 + S2 + S3;
  Valid := true;
end;

{----------------------------------------------------}
function ValidTimeStamp(Stamp:longint):boolean;
var t,Second,Hour,Minute:word;
begin
  ValidTimeStamp := false;
  if Stamp = 0 then Exit;
  if (Stamp shr 26) = 0 then Exit; {year}
  t := (Stamp shr 22) and $000f;
  if (t = 0) or (t > 12) then Exit; {month}
  t := (Stamp shr 17) and $001f;
  if (t = 0) or (t > 31) then Exit; {day}
  asm
    mov ax,word ptr [Stamp]
    mov dx,word ptr [Stamp+2]
    and dx,$0001
    mov cx,60
    div cx
    mov [Second],dx
    mov dx,0
    div cx
    mov [Minute],dx
    mov [Hour],ax
  end;
  if Hour > 23 then Exit;
  if Minute > 59 then Exit;
  if Second > 59 then Exit;

  ValidTimeStamp := true;
end;

