
{misc subroutines for use with test programs}
{Copyright 1992,1997,2001,2002,2003,2004 Frye Electronics -- writen by Michael Day}
{V5.15 as of 24 May 2004}
{24May04 - med, fixed time stamp conversion bug caused by compiler bug}

{$I+,R+}
unit TestSubs;
interface
{$I PLATFORM.INC}
{$IFDEF WIN32}   {for win95/winNT}
  uses Windows,SysUtils;
{$ENDIF}
{$IFDEF WIN16}  {for win3.1x}
  uses Strings,WinProcs,WinDos,DosCrt;
{$ENDIF}
{$IFDEF PMDOS}
  uses dos,RawKey;
{$ENDIF}
{$IFDEF MSDOS}
  uses dos,RawKey;
{$ENDIF}

type string2 = string[2];
     string4 = string[4];
     string8 = string[8];
     string9 = string[9];
     string12 = string[12];
     string20 = string[20];
     string80 = string[80];
     str255 = string[255];
     LongArray = array[0..65520 div 4] of Longint;
     WordArray = array[0..65520 div 2] of word;
     IntArray = array[0..65520 div 2] of integer;
     Dval=packed Record  Lw, Hw:word; End;
     Lval=packed Record b0,b1,b2,b3:byte; End;

const Hex : array[0..15] of char = '0123456789ABCDEF';

const BitReverse : array[0..255] of byte = (
    $00,$80,$40,$C0,  {;00H - 03H}
    $20,$A0,$60,$E0,  {;04H - 07H}
    $10,$90,$50,$D0,  {;08H - 0BH}
    $30,$B0,$70,$F0,  {;0CH - 0FH}
    $08,$88,$48,$C8,  {;10H - 13H}
    $28,$A8,$68,$E8,  {;14H - 17H}
    $18,$98,$58,$D8,  {;18H - 1BH}
    $38,$B8,$78,$F8,  {;1CH - 1FH}
    $04,$84,$44,$C4,  {;20H - 23H}
    $24,$A4,$64,$E4,  {;24H - 27H}
    $14,$94,$54,$D4,  {;28H - 2BH}
    $34,$B4,$74,$F4,  {;2CH - 2FH}
    $0C,$8C,$4C,$CC,  {;30H - 33H}
    $2C,$AC,$6C,$EC,  {;34H - 37H}
    $1C,$9C,$5C,$DC,  {;38H - 3BH}
    $3C,$BC,$7C,$FC,  {;3CH - 3FH}
    $02,$82,$42,$C2,  {;40H - 43H}
    $22,$A2,$62,$E2,  {;44H - 47H}
    $12,$92,$52,$D2,  {;48H - 4BH}
    $32,$B2,$72,$F2,  {;4CH - 4FH}
    $0A,$8A,$4A,$CA,  {;50H - 53H}
    $2A,$AA,$6A,$EA,  {;54H - 57H}
    $1A,$9A,$5A,$DA,  {;58H - 5BH}
    $3A,$BA,$7A,$FA,  {;5CH - 5FH}
    $06,$86,$46,$C6,  {;60H - 63H}
    $26,$A6,$66,$E6,  {;64H - 67H}
    $16,$96,$56,$D6,  {;68H - 6BH}
    $36,$B6,$76,$F6,  {;6CH - 6FH}
    $0E,$8E,$4E,$CE,  {;70H - 73H}
    $2E,$AE,$6E,$EE,  {;74H - 77H}
    $1E,$9E,$5E,$DE,  {;78H - 7BH}
    $3E,$BE,$7E,$FE,  {;7CH - 7FH}
    $01,$81,$41,$C1,  {;80H - 83H}
    $21,$A1,$61,$E1,  {;84H - 87H}
    $11,$91,$51,$D1,  {;88H - 8BH}
    $31,$B1,$71,$F1,  {;8CH - 8FH}
    $09,$89,$49,$C9,  {;90H - 93H}
    $29,$A9,$69,$E9,  {;94H - 97H}
    $19,$99,$59,$D9,  {;98H - 9BH}
    $39,$B9,$79,$F9,  {;9CH - 9FH}
    $05,$85,$45,$C5,  {;A0H - A3H}
    $25,$A5,$65,$E5,  {;A4H - A7H}
    $15,$95,$55,$D5,  {;A8H - ABH}
    $35,$B5,$75,$F5,  {;ACH - AFH}
    $0D,$8D,$4D,$CD,  {;B0H - B3H}
    $2D,$AD,$6D,$ED,  {;B4H - B7H}
    $1D,$9D,$5D,$DD,  {;B8H - BBH}
    $3D,$BD,$7D,$FD,  {;BCH - BFH}
    $03,$83,$43,$C3,  {;COH - C3H}
    $23,$A3,$63,$E3,  {;C4H - C7H}
    $13,$93,$53,$D3,  {;C8H - CBH}
    $33,$B3,$73,$F3,  {;CCH - CFH}
    $0B,$8B,$4B,$CB,  {;D0H - D3H}
    $2B,$AB,$6B,$EB,  {;D4H - D7H}
    $1B,$9B,$5B,$DB,  {;D8H - DBH}
    $3B,$BB,$7B,$FB,  {;DCH - DFH}
    $07,$87,$47,$C7,  {;E0H - E3H}
    $27,$A7,$67,$E7,  {;E4H - E7H}
    $17,$97,$57,$D7,  {;E8H - EBH}
    $37,$B7,$77,$F7,  {;ECH - EFH}
    $0F,$8F,$4F,$CF,  {;F0H - F3H}
    $2F,$AF,$6F,$EF,  {;F4H - F7H}
    $1F,$9F,$5F,$DF,  {;F8H - FBH}
    $3F,$BF,$7F,$FF);  {;FCH - FFH}

function hexB(B:byte):string2;
function hexW(W:word):string4;
function hexL(L:longint):string8;
function hexP(P:pointer):string9;
function fstr(L:longint):string12;
function KeyWaiting:boolean;
function GetKey:char;

procedure FillWord(var D; Ws,V:word);
procedure FillInt(var D; Ws,V:integer);
procedure FillLong(var D; Ws:word; V:longint);
procedure outint(i:integer; d:byte);           {print a decimal integer}
function rstr(i:integer; L:byte):str255;       {right justified integer}
function lstr(i:integer; L:byte):str255;        {left justified integer}
function spc(cnt:integer):str255;                    {return cnt spaces}
function Str2D(value:integer):string9;
function Str2Df(value:integer):string12;
function Str3D(value:integer):string9;
function sTrim(S:str255):str255;
function GetTick:longint;
procedure ClkWait(Value:word);
function GetBinTimeStamp:longint;
function GetStampDateStr(Stamp:longint; var Valid:boolean):str255;
function GetStampTimeStr(Stamp:longint; LongStr:boolean; var Valid:boolean):str255;
function ValidTimeStamp(Stamp:longint):boolean;
function FryeDateToStr(CalDate:longint; var Valid:boolean):str255;

{$IFNDEF WIN32}
  function FileExists(What:string):boolean;
{$ENDIF}

implementation

{++++++++++++++++++++++++++++++++++++++++++}
{hex conversion routines}

{convert a byte to hex}
function hexB(B:byte):string2;
begin
  hexB[1] := Hex[B shr 4];
  hexB[2] := Hex[B and $f];
  hexB[0] := #2;
end;

{convert a word to hex}
function hexW(W:word):string4;
Begin
  hexW[1] := Hex[hi(W) shr 4];
  hexW[2] := Hex[hi(W) and $f];
  hexW[3] := Hex[lo(W) shr 4];
  hexW[4] := Hex[lo(W) and $f];
  hexW[0] := #4;
end;

{convert a longint to hex}
function hexL(L:longint):string8;
Begin
  hexL := hexW(Dval(L).Hw)+hexW(Dval(L).Lw);
end;

{hex value of a pointer}
function hexP(P:Pointer):String9;
Begin
  hexP := hexW(Dval(longint(P)).Hw)+':'+hexW(Dval(longint(P)).Lw);
End;

{Note: this is not called in win32. Instead the SysUtils version is used}
function FileExists(What:string):boolean;
{$IFDEF WIN16}
  var Dest,Src:PChar;
{$ENDIF}
begin
   FileExists := false;
  {$IFDEF WIN16}
    StrPCopy(Src,What);
    FileSearch(Dest,Src,'');
    FileExists := Dest[0] <> #0;
  {$ENDIF}
  {$IFDEF MSDOS}
    FileExists := Fsearch(What,'') <> '';
  {$ENDIF}
  {$IFDEF PMDOS}
    FileExists := Fsearch(What,'') <> '';
  {$ENDIF}
end;

{++++++++++++++++++++++++++++++++++++++++++}
{misc input routines}

{$IFDEF WIN32}
  var KeyData : integer = -1;
  function KeyWaiting:boolean;
  var InputEvents : DWORD;
  var InputEventsRead : DWORD;
  var KeyBuf : TInputRecord;
  begin
    if KeyData < 0 then
    begin
      GetNumberOfConsoleInputEvents(GetStdHandle(STD_INPUT_HANDLE),InputEvents);
      if InputEvents <> 0 then
      begin
        ReadConsoleInput(GetStdHandle(STD_INPUT_HANDLE),KeyBuf,1,InputEventsRead);
        if (KeyBuf.EventType = KEY_EVENT) and (KeyBuf.KeyEvent.bKeyDown) then
        begin
          KeyData := integer(KeyBuf.KeyEvent.AsciiChar);
        end;
      end;
    end;
    KeyWaiting := KeyData >= 0;
  end;
  function GetKey:char;
  begin
    if KeyData < 0 then
      while not(KeyWaiting) do {nop};
    if KeyData >= 0 then
      GetKey := char(KeyData)
    else GetKey := #255;  
    KeyData := -1;
  end;
{$ELSE}
  function KeyWaiting:boolean;
  begin
    Keywaiting := KeyPressed;
  end;
  function GetKey:char;
  begin
    GetKey := ReadKey;
  end;
{$ENDIF}

{++++++++++++++++++++++++++++++++++++++++++}
{misc time routines}

{get number ms that have passed}
function GetTick:longint;
{$IFDEF MSDOS}
  var SysClock : longint absolute $40:$6c;
  begin
    GetTick := SysClock*55;
  end;
{$ENDIF}
{$IFDEF PMDOS}
  var SysClock : longint absolute $40:$6c;
  begin
    GetTick := SysClock*55;
  end;
{$ENDIF}
{$IFDEF WIN16}
  begin
    GetTick := GetTickCount;
  end;
{$ENDIF}
{$IFDEF WIN32}
  begin
    GetTick := GetTickCount;
  end;
{$ENDIF}


{-------------------------------------------------}
{waits for the number of 55ms ticks given in Value}
procedure ClkWait(Value:word);
var Start : longint;
begin
  Start := GetTick;
  while GetTick-Start < Value*55 do
  begin
    if KeyWaiting then Exit;
  end;
end;


{-------------------------------------------------}
{code used to emulate old dos calls}
{$IFDEF WIN32}
  procedure GetTime(var Hour,Minute,Second,Sec100:word);
  var Present : TDateTime;
  begin
    Present := Now;
    DecodeTime(Present,Hour,Minute,Second,Sec100);
  end;

  procedure GetDate(var Year,Month,Day,WeekDay:word);
  var Present : TDateTime;
  begin
    Present := Now;
    DecodeDate(Present,year,Month,Day);
    WeekDay := DayofWeek(Present);
  end;
{$ENDIF}

{--------------------------------------------------------}
function GetBinTimeStamp:longint;
var Year,Month,Day,DayofWeek:word;
var hour,minute,second,sec100:word;
    Temp,Temp1,Temp2 : longint;
begin
  GetBinTimeStamp := 0; {fail with zero}
  GetTime(Hour,Minute,Second,Sec100);
  Temp1 := longint(Hour)*longint(Minute)*longint(Second);
  GetDate(Year,Month,Day,DayofWeek);
  GetTime(Hour,Minute,Second,Sec100);
  Temp2 := longint(Hour)*longint(Minute)*longint(Second);
  if Temp1 <> Temp2 then  {catch the midnight rollover}
    GetDate(Year,Month,Day,DayofWeek);

  if Year < 1991 then Exit;
  Temp := ((Year-1990) shl 10) or
          ((succ(Month) and $f) shl 6) or
          ((succ(Day) and $1f) shl 1);
  Temp := Temp shl 16;
  GetBinTimeStamp := Temp2 or Temp;
end;

{-----------------------------------------------------}
function GetStampDateStr(Stamp:longint; var Valid:boolean):str255;
var Year,Month,Day:word;
    S1,S2 : string[12];
begin
  Valid := false;
  GetStampDateStr := '        ';
  if Stamp = 0 then Exit;
  Year := (Stamp shr 26) + 1990;
  Month := (Stamp shr 22) and $000f;
  Day := (Stamp shr 17) and $001f;
  if (Day > 31) or (Day = 0) then Exit;
  if (Month > 12) or (Month = 0) then Exit;
  if Year < 1991 then Exit;

  S1 := fstr(Month)+'/';
  if length(S1) < 3 then S1 := '0'+S1;
  S2 := fstr(Day)+'/';
  if length(S2) < 3 then S2 := '0'+S2;
  GetStampDateStr := S1 + S2 + copy(fstr(Year),3,2);
  Valid := true;
end;

{-----------------------------------------------------}
function GetStampTimeStr(Stamp:longint; LongStr:boolean; var Valid:boolean):str255;
var hour,minute,second:word;
    S1,S2,S3:string[12];
    Temp : longint;
begin
  Valid := false;
  GetStampTimeStr := '        ';
  if Stamp = 0 then Exit;
  Temp := Stamp and $1ffff;
  Second := Temp mod 60;
  Minute := (Temp div 60) mod 60;
  Hour := Temp div 3600;
{  asm
    mov ax,word ptr [Stamp]
    mov dx,word ptr [Stamp+2]
    and dx,$0001
    mov cx,60
    div cx
    mov [Second],dx
    mov dx,0
    div cx
    mov [Minute],dx
    mov [Hour],ax
  end;}
  if Minute > 59 then Exit;
  if Second > 59 then Exit;
  if Hour > 23 then Exit;

  S1 := fstr(Hour)+':';
  if length(S1) < 3 then S1 := '0'+S1;
  S2 := fstr(Minute);
  if length(S2) < 2 then S2 := '0'+S2;
  S3 := fstr(second);
  if length(S3) < 2 then S3 := ':0'+S3
  else S3 := ':'+S3;
  if not(LongStr) then
    GetStampTimeStr := S1 + S2
  else
    GetStampTimeStr := S1 + S2 + S3;
  Valid := true;
end;

{----------------------------------------------------}
function ValidTimeStamp(Stamp:longint):boolean;
var t,Second,Hour,Minute:word;
    Temp : longint;
begin
  ValidTimeStamp := false;
  if Stamp = 0 then Exit;
  if (Stamp shr 26) = 0 then Exit; {year}
  t := (Stamp shr 22) and $000f;
  if (t = 0) or (t > 12) then Exit; {month}
  t := (Stamp shr 17) and $001f;
  if (t = 0) or (t > 31) then Exit; {day}
  Temp := Stamp and $1ffff;
  Second := word(Temp mod 60);
  Minute := word(longint(Temp div 60) mod 60);
  Hour := word(Temp div 3600);

{  asm
    mov ax,word ptr [Stamp]
    mov dx,word ptr [Stamp+2]
    and dx,$0001
    mov cx,60
    div cx
    mov [Second],dx
    mov dx,0
    div cx
    mov [Minute],dx
    mov [Hour],ax
  end;}
  if Hour > 23 then Exit;
  if Minute > 59 then Exit;
  if Second > 59 then Exit;

  ValidTimeStamp := true;
end;

{-------------------------------------------------}
function FryeDateToStr(CalDate:longint; var Valid:boolean):str255;
var Year,Month,Day:word;
    S1,S2 : string[12];
begin
  Valid := false;
  FryeDateToStr := '        ';
  Day := (CalDate shr 24) and $ff;
  Month := CalDate and $f;
  Year := (CalDate shr 4) and $fff;
  if CalDate = 0 then Exit;

  if (Day > 31) or (Day = 0) then Exit;
  if (Month > 12) or (Month = 0) then Exit;
  if Year = 0 then Exit;

  S1 := fstr(Month)+'/';
  if length(S1) < 3 then S1 := '0'+S1;
  S2 := fstr(Day)+'/';
  if length(S2) < 3 then S2 := '0'+S2;
  FryeDateToStr := S1 + S2 + copy(fstr(Year),3,2);
  Valid := true;
end;

{++++++++++++++++++++++++++++++++++++++++++}
{misc output string formating routines}

function fstr(L:longint):string12;
var S : string12;
begin
  str(L,S);
  fstr := s;
end;

procedure outint(i:integer; d:byte);
var stemp:string[8];
begin
  str(i:d,stemp);
  write(stemp);
end;
function rstr(i:integer; L:byte):str255;
var stemp:str255;
begin
  str(i,stemp);
  while length(stemp) < L do
    stemp := ' '+stemp;
  rstr:=stemp;
end;
function lstr(i:integer; L:byte):str255;
var stemp:str255;
begin
  str(i,stemp);
  while length(stemp) < L do
    stemp := stemp+' ';
  lstr:=stemp;
end;
function spc(cnt:integer):str255;
var temp:str255;
    i:integer;
begin
   temp := '';
   for i := 1 to cnt do
     temp := temp+' ';
   spc := temp;
end;

{------------------------------------------------}
function Str2D(value:integer):string9;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value{+5}) div 100;  {force roundup}
  str(ts,ts1);
  if ((value{+5}) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value{+5}) mod 100) div 10;
  str(ts,ts2);
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str2D := ts3+ts1+'.'+ts2;
end;

{------------------------------------------------}
function Str2Df(value:integer):string12;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value{+5}) div 100;
  str(ts,ts1);
  if ((value{+5}) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value{+5}) mod 100);  {force roundup}
  str(ts,ts2);
  if length(ts2) < 2 then ts2 := ts2+'0';
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str2Df := ts3+ts1+'.'+ts2;
end;

{------------------------------------------------------}
function Str3D(value:integer):string9;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value{+5}) div 100;  {force roundup}
  str(ts,ts1);
  if ((value{+5}) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value{+5}) mod 100) {div 10};
  str(ts,ts2);
  if length(ts2) < 2 then ts2 := '0'+ts2;
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str3D := ts3+ts1+'.'+ts2;
end;

{--------------------------------------}
function sTrim(S:str255):str255;
var tS:str255;
begin
  tS := S;
  while (tS[0] > #0) and (ord(tS[1]) < $21) {"!"}
  do delete(tS,1,1);
  while (tS[length(tS)] > #0) and (ord(tS[1]) < $21) {"!"}
  do delete(tS,length(tS),1);
  sTrim := tS;
end;


{+++++++++++++++++++++++++++++++++}
{misc fill routines}

procedure fillword(var D; Ws,V:word);
var Da : wordarray absolute D;
var i : integer;
begin
  for i := 0 to pred(Ws) do
    Da[i] := V;
end;

procedure fillint(var D; Ws,V:integer);
var Da : IntArray absolute D;
var i : integer;
begin
  for i := 0 to pred(Ws) do
    Da[i] := V;
end;

procedure fillLong(var D; Ws:word; V:longint);
var Da : LongArray absolute D;
var i : integer;
begin
  for i := 0 to pred(Ws) do
    Da[i] := V;
end;


{------}
end.


