
{This is an extension of the TSunit for the Test and Test32 programs}
{It was added on because TSunit ran out of code space for 16bit systems}
{all code is shared between the 16 bit and 32 bit versions.}
{V5.16 as of 26 July 2004 - med}
{12 Jun 2006 V5.20 -med added new commands and adapted battery commands for 7000}

{$N+,E+}
Unit TS2unit;
interface
{$I PLATFORM.INC}
uses TestSubs,TestFIPP,ShowBlob,FryeBmp,
  {$IFDEF WIN32}
     Windows,SysUtils;
     {$APPTYPE CONSOLE}
  {$ENDIF}
  {$IFDEF WIN16}
     DosCrt,WinProcs,WinDos,WinTypes,Strings;
  {$ENDIF}
  {$IFDEF MSDOS}
     Dos;
  {$ENDIF}
  {$IFDEF PMDOS}
     DOS;
  {$ENDIF}

{var FIPPrec:FIPPrecType;}
var pfunerr,num : integer;
    temp : integer;
    Ltemp : Longint;
    chx : char;
    DeviceType : integer;
    TL : longint;
    InputString : str255;

const ABaud : boolean = true;
      QTerm : boolean = false;
      Baud : longint = 9600;
      killme : boolean = false;
      DefaultPollTime : integer = 100;
const DefinedPort : boolean = false;
const ErrorCode : integer = 0;
const CurveSelectValid : boolean = false;
const Iam : integer = -1; {-1=unknown}
const Delimit : boolean = false;
const ShowInt : boolean = false;

{support functions}
function Spin(Count:word):char;
function onoff(value:integer):string8;
function FverStr(var FIPPrec:FIPPrecType):str255;
function DbStr(Value:integer; ShowOff:boolean):string20;
function DbStr100(Value:integer; ShowOff:boolean):string20;
procedure PackErr;
procedure SkipPollTick(T:integer; var FIPPrec:FIPPrecType);
function WaitLongPoll(var FIPPrec:FIPPrecType):boolean;
function OpenForBusiness:boolean;
procedure doport;
function LabelBlank:boolean;
procedure ShowLabel(Which:integer);
function EntLab(S:Str255; L:integer):str255;

{command procedures}
procedure dof0;   {set source amp}
procedure dof1;   {set distortion}
procedure dof2;   {set frequency}
procedure dof3;
procedure dof4;   {set noise reduction}
procedure dof5;   {set smoothing}
procedure dof6;   {set label}
procedure dof7;   {set probe state}
procedure dof8;   {set weighting}
procedure dof9;   {set curve frame}
procedure dof10;  {io mode}
procedure dof11;    {set telecoil state}
procedure dof12;       {set gain status}
procedure dof13; {do relatt}
procedure dof14;            {do batt}
procedure dof15;   {do io}
procedure dof16; {do test}
procedure dof17;  {do level}
procedure dof18;   {rel Attack data}
procedure dof19;     {get batt}
procedure dof20;     {get io data}
procedure dof21; {get source amp}
procedure dof22;   {get dist mode}
procedure dof23;     {get freq}
procedure dof24;      {get OES state}
procedure dof25;        {get curve frame}
procedure dof26;         {get noise red}
procedure dof27;         {get smoothing}
procedure dof28;    {version}
procedure dof29;       {get level state}
procedure dof30;   {get weighting}
procedure dof31;       {get mic input value}
procedure dof32;      {get distortion reading}
procedure dof33;    {get cmd status}
procedure dof34;   {get io mode}
procedure dof35;   {get probe state}
procedure dof36;   {get gain state}
procedure dof37;    {get telecoil state}
procedure dof38;    {do reset}
procedure dof39;   {set tcoil mode }
procedure dof40;   {set rel att frq}
procedure dof41;  {get att/rel test freq}
procedure dof42;   {get last measured curve}
procedure dof43;   { set new zeta state }
procedure dof44; {get tel coil mode}
procedure dof45;   { get Zeta state - }
procedure dof46;   {get insitu mode}
procedure dof47;   {set insitu mode}
procedure dof48;   { set new automatic state }
procedure dof49;   { get automatic state - }
procedure dof50;   { set new limit value }
procedure dof51;   { get Ouput Limit value - }
procedure dof52;   { set new refmic state }
procedure dof53;   { get RefMic state - }
procedure dof54; {set active mode}
procedure dof55; {Get Active mode}
procedure dof56; {do sleep}
procedure dof57; {get ref mic value}
procedure dof58; {get key scan code}
procedure dof59; {Set machine state}
procedure dof60; {Get machine state}
procedure dof61; {Get BLOB}
procedure dof62; {set control lock}
procedure dof63; {get key control}
procedure dof64; {Do line feeds}
procedure dof65; {do print }
procedure dof66;    {set extended label}
procedure dof67;    {do error}
procedure dof68; {Set spectrum}
procedure dof69; {Set phase}
procedure dof70; {Set option params}
procedure dof71; {Get option params}
procedure dof72; {set key scan code}
procedure dof73; {set POLL DELAY}
procedure dof74; {get POLL DELAY}
procedure dof75; {set test ear}
procedure dof76; {get test ear}
procedure dof77;   { set new operation state }
procedure dof78;   { get operating state - }
procedure dof79; {set batt type}
procedure dof80; {Get power status}
procedure dof81; {get avg freqs}
procedure dof82; {set avg freqs}
procedure dof83; {get measurment settle delay}
procedure dof84; {set measurment settle DELAY}
procedure dof85; {do measurment}
procedure dof86;    {get extended label}
procedure dof87;      {get CIC state}
procedure dof88;
procedure dof89;    {set default label}
procedure dof90; {set avg DELAY time}
procedure dof91; {get avg delay time}
procedure dof92; {set printer type}
procedure dof93; {get printer Type}
procedure dof94; {get HFA measurement}
procedure dof95; {get software info}
procedure dof96; {set printer label bitmap}
procedure dof97; {set A&R Params}
procedure dof98; {get attack and release}
procedure dof99; {Set BLOB}

(*
procedure dof100; {get device id count}
procedure dof101; {get long device id}
procedure dof102; {get device data}
procedure dof103; {get realtime clock}
procedure dof104; {set realtime clock}
procedure dof105; {get output transducer selection}
procedure dof106; {set output transducer selection}
procedure dof107; {get impulse rejection}
procedure dof108; {set impulse rejection}
procedure dof109; {get signal info}
procedure dof110; {get raw capture data}

procedure dof112; {set curve selection}
procedure dof113; {get curve selection}
procedure dof114; {set curve status}
procedure dof115; {get curve status }
procedure dof116; {set unaided curve selection}
procedure dof117; {get unaided curve selection}
{118 - set list   - not coded here}
{119 - get list   - not coded here}
{120 - get bitmap - not coded here}
procedure dof121; {set curve selection}
procedure dof122; {get static tone selection}
procedure dof123; {set aid type}
procedure dof124; {get aid type selection}
procedure dof125; {set bias tone Params}
procedure dof126; {get bias tone parameters}
{127 = reserved for external control}
{128 = reserved for external control}
procedure dof129; {set warble type}
procedure dof130; {get warble selection}
procedure dof131; {get delay measurments}
procedure dof132; {set Rcv Timeout}
procedure dof133; {get Rcv Timeout}
procedure dof134; {set Fit Rule}
procedure dof135; {get Fit Rule}
procedure dof136; {set Filter}
procedure dof137; {get Filter}
procedure dof138; {set Compression threshold}
procedure dof139; {get Compression threshold}
procedure dof140; {Set ClientAge}
procedure dof141; {get ClientAge}
procedure dof142; {Set Transducer location}
procedure dof143; {get transducer location}
procedure dof145; {Set leveling list}
procedure dof146; {Get leveling list}
procedure dof147; {Set leveling status}
procedure dof148; {Set aux port}
procedure dof149; {Get aux port}
procedure dof150; {Set user Number}
procedure dof151; {Get user Number}

procedure dof152; {Set Fit Type     fp35 V3.20}
procedure dof153; {Get Fit Type     fp35 V3.20}
procedure dof154; {Set Vent Type    fp35 V3.20}
procedure dof155; {Get Vent Type    fp35 V3.20}
procedure dof156; {Set Tubing Type  fp35 v3.20}
procedure dof157; {Get Tubing Type  fp35 V3.20}
procedure dof158; {Set Aid Channels fp35 V3.20}
procedure dof159; {Get Aid Channels fp35 V3.20}
procedure dof160; {Set Aid Limiting fp35 V3.20}
procedure dof161; {Get Aid Limiting fp35 V3.20}
procedure dof162; {Set Fit Param    fp35 v3.20}
procedure dof163; {Get Fit Param    fp35 v3.20}


procedure dof166; {Set UserID text}
procedure dof167; {Get UserID text}

const FIT_VENT_OPEN =     0;  {Vent Open}
const FIT_VENT_OCCLUDED = 1;  {Vent Occluded}
const FIT_VENT_TIGHT =    2;  {Vent tight}
const FIT_VENT_MM1 =      3;  {Vent 1mm}
const FIT_VENT_MM2 =      4;  {Vent 2mm}
const FIT_VENT_MM3 =      5;  {Vent 3mm}

const FIT_TUBING_NONE   = 0;  {Tubing None  [cic, itc, ite aids] }
const FIT_TUBING_LIBBY4 = 1;  {Tubing Libby 4                    }
const FIT_TUBING_LIBBY3 = 2;  {Tubing Libby 3                    }
const FIT_TUBING_CFA2   = 3;  {Tubing CFA #2 horn                }
const FIT_TUBING_CFA3   = 4;  {Tubing CFA #3 stepped bore        }
const FIT_TUBING_No13   = 5;  {Tubing #13                        }
const FIT_TUBING_sixC5  = 6;  {Tubing 6C5                        }
const FIT_TUBING_sixC10 = 7;  {Tubing 6C10                       }
*)

implementation

{-------------------------------------------------}
function Spin(Count:word):char;
begin
  case Count and 3 of
   0:Spin := '/';
   1:Spin := '-';
   2:Spin := '\';
   3:Spin := '|';
  else Spin := ' ';
  end;
end;

{------------------------------------------------}
function onoff(value:integer):string8;
var temp : string8;
begin
  str(value,temp);
  case value of
    0 : onoff := 'OFF (0)';
    1 : onoff := 'ON  (1)';
  else
    onoff := temp;
  end;
end;

function FverStr(var FIPPrec:FIPPrecType):str255;
var s:str255;
begin
  with FIPPrec do
  begin
    s := fstr(Fversion div 100) + '.';
    if Fversion mod 100 < 10 then s := s + '0';
    S := s + fstr(Fversion mod 100);
    if (Fversion div 100) < 3 then s[length(s)] := 'x';
    Fverstr := s;
  end;
end;

function DbStr(Value:integer; ShowOff:boolean):string20;
begin
  if (Value = 0) and ShowOff then
    DbStr := 'OFF (0dB)'
  else
    DbStr := Str2Df(Value)+'dB';
end;

function DbStr100(Value:integer; ShowOff:boolean):string20;
begin
  if (Value = 0) and ShowOff then
    DbStr100 := 'OFF (0dB)'
  else
    DbStr100 := fstr(Value div 100)+'dB';
end;

{------------------------------------------------}
function LabelBlank:boolean;
begin
  LabelBlank := false;
{
  for i := 0 to pred(MaxExtLabelSize) do
    if (FIPPrec.ExtLabelData[i] <> #0) and
       (FIPPrec.ExtLabelData[i] <> #32) then Exit;
  LabelBlank := true;
}
end;

{------------------------------------------------}
procedure ShowLabel(Which:integer);
var i,ii:word;
    c : char;
    MaxSize : integer;
begin
  i := 1;
  if Which = 1 then
    MaxSize := MaxUserIDTextSize
  else MaxSize := MaxExtLabelSize;

  while i < MaxSize do
  begin
    ii := 0;
    c := #255;
    while (ii < 28) and (c <> #0) do
    begin
      if Which = 1 then
        c := FIPPrec.UserIDText[FIPPrec.UserNumber][pred(i)]
      else c := FIPPrec.ExtLabelData[pred(i)];
      write(c);
      inc(ii);
      inc(i)
    end;
    writeln;
    while ii < 28 do
    begin
      inc(i);
      inc(ii);
    end;
  end;
  {FIPPrec.ExtLabelData[pred(i)] := #0;}
end;

{-----------------------------------------------}
function EntLab(S:Str255; L:integer):str255;
var s2 : str255;
begin
  write(S,#13);
  s2 := copy(s,1,Length(S)-succ(L));
  write(s2);
  readln(s2);
  s2 := s2+'___________________________';
  if L = 18 then
    s2 := copy(s2,1,18)
  else
    s2 := copy(s2,1,27);
  EntLab := s2;
end;


{------------------------------------------------}
procedure PackErr;
begin
  with FIPPrec do
  begin
    writeln;
    write('** Packet error ** ',FIPPrec.PacketError,' -> ');
    write(FIPPerrorMsg(FIPPrec.PacketError));
    writeln(' (AX:',hexW(StatAX),' CX:',hexW(StatCX),' DX:',hexW(StatDX),')');

    writeln('SendArray[0]=',SendArray[0],'  SendArray[1]=',SendArray[1],
            '  SendArray[2]=',SendArray[2]);
    write('RcvArray[0]=[',hexW(RcvArray[0]),']');
    if RcvArray[0] > $7fff then write('(',integer(RcvArray[0]),')');
    WRITE(RcvArray[0]);
    writeln('  RcvArray[1]=',RcvArray[1],
            '  RcvArray[2]=',RcvArray[2]);
    if Verify and CmdStatusFailed then
      writeln('Command failed - bad status (33)');
  end;
end;

{------------------------------------------------------------------------}
{same as SkipPoll, but waits for T clock ticks after skipping poll}

procedure SkipPollTick(T:integer; var FIPPrec:FIPPrecType);
begin
  SkipPoll(FIPPrec);
  ClkWait(T);
end;

function WaitLongPoll(var FIPPrec:FIPPrecType):boolean;
var tb:boolean;
begin
  WaitLongPoll := false;
  with FIPPrec do
  begin
    PollTimer := LongPoll;     {set for long poll timeout}
    SetPollTimer(FIPPrec);
    SkipPollTick(2,FIPPrec);   {skip a single poll}
    tb := not(GetCmdStatus(FIPPrec));
    PollTimer := DefaultPoll;   {restore normal poll timeout}
    SetPollTimer(FIPPrec);
    if tb then Exit;           {Exit if something went wrong}
  end;
  WaitLongPoll := true;
end;


{------------------------------------------------}
function OpenForBusiness:boolean;
var sP : str255;
var s : str255;
var cS : pchar;
begin
  OpenForBusiness := false;
  with FIPPrec do
  begin
    cS := ' ';
    if not(OpenPacketPort(FIPPrec,useIOport,useIRQ)) then
    begin
      sP := fstr(useIOport);
      writeln;
      writeln;
      writeln('****************************************************');
      writeln('*** Error: Could not open selected Fryers port ',sP,' ***');
      writeln('****************************************************');
      writeln;
     {$IFDEF WIN32}
       if DefinedPort = true then
       begin
         s := 'Error: Could not open selected Fryers port ' + sP;
         StrPCopy(cS,s);
         MessageBox(0,Cs,'TEST32 Error',MB_OK);
         Halt(1);
       end
       else
       begin
         Exit;
       end;
     {$ELSE}
       {writeln('Error: FRYERS.COM not loaded, or bad version.');}
       Halt(1);
     {$ENDIF}
    end;

    {now make sure the port is synced}
    if (SyncPort(FIPPrec) <> SUCCESS) then
    begin
      sP := fstr(useIOport);
      writeln;
      writeln;
      writeln('****************************************************************');
      writeln('*** Error: Could not sync Fryers to the instrument on port ',sP,' ***');
      writeln('****************************************************************');
      writeln;
     {$IFDEF WIN32}
       if DefinedPort = true then
       begin
         s := 'Error: Could not sync Fryers to the instrument on port ' + sP;
         StrPCopy(cS,s);
         MessageBox(0,Cs,'TEST32 Error',MB_OK);
         Halt(1);
       end
       else
       begin
         Exit;
       end;
     {$ELSE}
       {writeln('Error: FRYERS.COM not loaded, or bad version.');}
       Halt(1);
     {$ENDIF}
    end;

    UpdateFryersInfo(FIPPrec);
    s := FverStr(FIPPrec);
    write('Fryers V',s);
    write('  using COM',useIOPort);
   {$IFNDEF WIN32}
     write('  with IRQ',Fipprec.IRQnum[pred(useIOport)]);
   {$ENDIF}
    write('  at ',RealBaudRate,' Baud  ');
    if QuickTerm or AutoBaud then
    begin
      write('(');
      if QuickTerm then write('Q');
      if Autobaud then write('A');
      write(')');
    end;
  end;
  writeln;
  writeln;
  OpenForBusiness := true;
end;

procedure doport;
var PrevIOport,PrevIRQ : integer;
var sP : str255;
var s : str255;
var cS : pchar;
begin
    cS := ' ';
   PrevIOport := useIOport;
   PrevIRQ := useIRQ;

   if FIPPrec.FVersion < 520 then
   begin
     write('Enter new Com port to use (1-9) : ');
   end
   else
   begin
     write('Enter new Com port to use (1-99) : ');
   end;
   readln(temp);
   if temp <= 0 then temp := 1;
   if temp > 99 then temp := 1;
  {$IFNDEF WIN32}
    if temp > 4 then temp := 1;
  {$ELSE}
    if FIPPrec.FVersion < 520 then
    begin
      if temp > 9 then temp := 9;
    end
    else
    begin
      if temp > 99 then temp := 9;
    end;
  {$ENDIF}
   useIOport := temp;
  {$IFNDEF WIN32}
     write('Enter new IRQ to use (1-15) 0=use default : ');
     readln(temp);
     if temp < 0 then temp := 0;
     if temp > 15 then temp := 1;
     useIRQ := temp;
  {$ENDIF}

  ClosePacketPort(FIPPrec);
  if not(OpenForBusiness) then
  begin
    useIOport := PrevIOport;
    useIRQ := PrevIRQ;
    if not(OpenForBusiness) then
    begin
       if (DefinedPort = true) then
       begin
         Halt(1);
       end;
    end;
  end;
end;


{------------------------------------------------}
procedure dof0;   {set source amp}
var tmp:single;
begin
  with FIPPrec do
  begin
    if not(GetSourceAmp(FIPPrec)) then Exit;
    writeln('Current source = ',SourceAmp div 100,'dB');
    write('Enter new Source Amp value (50, 60, etc. 0=off) : ');
    readln(tmp);
    if tmp > 300 then Exit;
    SourceAmp := trunc(tmp * 100);
    if not(SetSourceAmp(FIPPrec)) then Exit;
    writeln('New source = ',DbStr(SourceAmp,true));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof1;   {set distortion}
begin
  with FIPPrec do
  begin
    if not(GetDistmode(FIPPrec)) then Exit;
    write('Current Distortion mode = ');
    case DistMode of
      0 : writeln('None  (0)');
      1 : writeln('2nd   (1)');
      2 : writeln('3rd   (2)');
      3 : writeln('Total (3)');
    else
      writeln(DistMode);
    end;
    write('Enter new Distortion mode value (0=Off, 1=2nd, 2=3rd, 3=Tot): ');
    readln(temp);
    Distmode := temp;
    if not(SetDistmode(FIPPrec)) then Exit;
    write('New Distortion mode = ');
    case DistMode of
      0 : writeln('None  (0)');
      1 : writeln('2nd   (1)');
      2 : writeln('3rd   (2)');
      3 : writeln('Total (3)');
    else
      writeln(DistMode);
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof2;    {set frequency}
begin
  with FIPPrec do
  begin
    if not(GetFrequency(FIPPrec)) then Exit;
    write('Current Frequency = ');
    if Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Frequency,'Hz');
    write('Enter new Frequency (Composite = 0) : ');
    readln(temp);
    Frequency := temp;
    if not(SetFrequency(FIPPrec)) then Exit;
    write('New Frequency = ');
    if Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Frequency,'Hz');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof3;
begin
  with FIPPrec do
  begin
    if not(GetOESstate(FIPPrec)) then Exit;
    writeln('Current OES state = ',OnOff(OESstate));
    write('Enter new OES state (0=off 1=on) : ');
    readln(temp);
    OESstate := temp;
    if not(SetOESstate(FIPPrec)) then Exit;
    writeln('New OES state = ',OnOff(OESstate));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof4;   {set noise reduction}
begin
  with FIPPrec do
  begin
    if not(GetNoiseRedCount(FIPPrec)) then Exit;
    writeln('Current Noise Reduction Count = ',NoiseRedCount);
    write('Enter new Noise Reduction Count (0, 2, 4, 8, 16) : ');
    readln(temp);
    NoiseRedCount := temp;
    if not(SetNoiseRedCount(FIPPrec)) then Exit;
    writeln('New Noise Reduction Count = ',NoiseRedCount);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof5;   {set smoothing}
begin
  with FIPPrec do
  begin
    if not(GetSmoothState(FIPPrec)) then Exit;
    write('Current Smoothing = ',SmoothState);
    case SmoothState of
     0: writeln(' (OFF)');
     1: writeln(' (100Hz)');
     2: writeln(' (Log)');
    end;
    write('Enter new Smoothing (0=off 1=100Hz, 2=Log) : ');
    readln(temp);
    SmoothState := temp;
    if not(SetSmoothState(FIPPrec)) then Exit;
    write('New Smoothing State = ',SmoothState);
    case SmoothState of
     0: writeln(' (OFF)');
     1: writeln(' (100Hz)');
     2: writeln(' (Log)');
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof6;    {set label}
var Lab : str255;
    i : integer;
begin
  writeln('Enter Label Information');
  writeln;
  Lab :=       EntLab('       Date:__________________|',18);
  Lab := Lab + EntLab('     Model#:__________________|',18);
  Lab := Lab + EntLab('    Serial#:__________________|',18);
  Lab := Lab + EntLab('      Owner:__________________|',18);
  Lab := Lab + EntLab('   Comments:__________________|',18);
  Lab := Lab + EntLab('C2:___________________________|',27);
  Lab := Lab + EntLab('C3:___________________________|',27);
  Lab := Lab + EntLab('C4:___________________________|',27);
  i := 1;
  while i < MaxLabelSize do
  begin
    FIPPrec.LabelData[pred(i)] := Lab[i];
    inc(i);
  end;
  FIPPrec.LabelData[pred(i)] := #0;

  if not(SetLabel(FIPPrec)) then Exit;
  writeln;
  writeln('* Label Sent *');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof7; {set probe state}
begin
  with FIPPrec do
  begin
    if not(GetProbeState(FIPPrec)) then Exit;
    writeln('Current Probe State = ',OnOff(ProbeState));
    write('Enter new Probe State (0=off 1=on) : ');
    readln(temp);
    ProbeState := temp;
    if not(SetProbeState(FIPPrec)) then Exit;
    writeln('New Probe State = ',onoff(ProbeState));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof8;  {set weighting}
begin
  with FIPPrec do
  begin
    if not(GetWeightState(FIPPrec)) then Exit;
    write('Current Weight State = ');
    case WeightState of
      0 : writeln('(0) UnWeighted (Flat)');
      1 : writeln('(1) Weighted Power ');
      2 : writeln('(2) Weighted Gain');
    else
      writeln(WeightState);
    end;
    write('Enter new Weight State (0=Flat 1=Power 2=Gain) : ');
    readln(temp);
    WeightState := temp;
    if not(SetWeightState(FIPPrec)) then Exit;
    write('New Weight State = ');
    case WeightState of
      0 : writeln('(0) UnWeighted (Flat)');
      1 : writeln('(1) Weighted Power ');
      2 : writeln('(2) Weighted Gain');
    else
      writeln(WeightState);
    end;
  end;
  pfunerr := 0;
end;

{-------}
procedure dof9;                         {set curve frame}
var i,ii : integer;
    What:string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
begin
  with FIPPrec do
  begin
    write('Enter Curve Number to Send (0-13) : ');
    readln(temp);
    CurveNumber := temp;
    What := 'curve'+fstr(CurveNumber)+'.DAT';
    if FileExists(What) then
    begin
      assign(fc,What);
      reset(fc);
      for i := 0 to pred(MaxCurveSize) do
      begin
        readln(fc,CurveFrame[i]);
        if eof(fc) then break;
      end;
      close(fc);
    end;
    if not(SetCurveFrame(FIPPrec)) then Exit;
    write('Crv ',CurveNumber,':');
    ShowCurve(FIPPrec);
  end;
  pfunerr := 0;
end;


{-----}
procedure dof10;              {io mode}
begin
   with FIPPrec do
   begin
     GetIOmode(FIPPrec);
     write('Current IO Test Frequency = ');
     if IOFrequency = 0 then writeln('Composite (0Hz)')
     else writeln(IOfrequency);
     if IOgain = 0 then writeln('  In Amplitude mode (0)')
     else writeln('  In Gain mode (1)');
     if (IOModeCount > 2) then
     begin
       writeln('Current IO Start Delay  = ',IOStartMs,' (mS)');
       writeln('Current IO Sweep Settle = ',IOSweepMs,' (mS)');
     end;

     write('Enter new IO Test Frequency : ');
     readln(temp);
     IOFrequency := temp;
     write('Enter new IO Gain mode (0=Amplitude 1=Gain) : ');
     readln(temp);
     IOgain := temp;
     if (IOModeCount > 2) then
     begin
       write('Enter new Start Delay (milliseconds): ');
       readln(temp);
       IOStartMS := temp;
       write('Enter new Sweep Settle (milliseconds) : ');
       readln(temp);
       IOSweepMs := temp;
     end;

     if not(SetIOmode(FIPPrec)) then Exit;

     write('New IO Test Frequency = ');
     if IOFrequency = 0 then writeln('Composite (0Hz)')
     else writeln(IOfrequency);
     if IOgain = 0 then writeln('  In Amplitude mode (0)')
     else writeln('  In Gain mode (1)');
     if (IOModeCount > 2) then
     begin
       writeln('New IO Start Delay  = ',IOStartMs,' (mS)');
       writeln('New IO Sweep Settle = ',IOSweepMs,' (mS)');
     end;
   end;
  pfunerr := 0;
end;

{------}
procedure dof11;    {set telecoil state}
begin
  with FIPPrec do
  begin
    if not(GetTelCoilState(FIPPrec)) then Exit;
    writeln('Current TeleCoil State = ',onoff(TelCoilState));
    write('Enter new TelCoil State (0=off 1=on) : ');
    readln(temp);
    TelCoilState := temp;
    if not(SetTelCoilState(FIPPrec)) then Exit;
    writeln('New TeleCoil State = ',onoff(TelCoilState));
  end;
  pfunerr := 0;
end;

{-----}
procedure dof12;       {set gain status}
begin
  with FIPPrec do
  begin
    if not(GetGainState(FIPPrec)) then Exit;
    write('Current Gain State = ');
    case GainState of
      0 : writeln('OFF (Amplitude)');
      1 : writeln('ON  (Gain)');
    else
      writeln(GainState);
    end;
    write('Enter new Gain State (0=amp 1=gain) : ');
    readln(temp);
    GainState := temp;
    if not(SetGainState(FIPPrec)) then Exit;
    write('New Gain State = ');
    case GainState of
      0 : writeln('OFF (Amplitude)');
      1 : writeln('ON  (Gain)');
    else
      writeln(GainState);
    end;
  end;
  pfunerr := 0;
end;

{-------}
procedure dof13; {do relatt}
begin
   with FIPPrec do
   begin
     writeln('Current Release Attack State = ',onoff(RelAttState));
     write('Enter new Release Attack State (0=OFF 1=ON) : ');
     readln(temp);
     RelAttState := temp;
     if not(DoRelAttSelect(FIPPrec)) then Exit;
     writeln('New Release Attack State = ',onoff(RelAttState));
   end;
   pfunerr := 0;
end;

{--------}
procedure dof14;            {do batt}
begin
  if (GetDevVersion(FIPPrec) = false) then Exit;

  with FIPPrec do
  begin
    if ((Version[5] = 0) or (Version[5] = 1) or (Version[5] = 35) or (version[5] = 40)) then
    begin
      {no parameters for 6400/6500/FP35/FP40}
    end
    else
    begin
      write('Enter battery test state (0=OFF 1=ON) : ');
      readln(temp);
      FIPPrec.BatteryTestEnable := temp;
    end;
  end;
  if not(SetBatteryTest(FIPPrec)) then Exit;
  pfunerr := 0;
 end;

{-------}
procedure dof15;   {do io}
begin
   with FIPPrec do
   begin
     writeln('Current IO select state = ',onoff(IOstate));
     write('Enter new IO Select State (0=OFF 1=ON) : ');
     readln(temp);
     IOstate := temp;
     if not(DoIOSelect(FIPPrec)) then Exit;
     if IOstate <> 0 then writeln('IO measurement has been performed');
     writeln('New IO select state = ',onoff(IOstate));
   end;
  pfunerr := 0;
end;

{-------}
procedure dof16; {do test}
begin
  with FIPPrec do
  begin
    if not(DoTest(FIPPrec)) then Exit;
    writeln('Start/Stop has been initiated.');
  end;
  pfunerr := 0;
end;

{------}
procedure dof17;  {do level}
begin
  with FIPPrec do
  begin
    if not(DoLevel(FIPPrec)) then Exit;
    writeln('Leveling in progress...');
    if not(GetLevelState(FIPPrec)) then Exit;
    write('Current Leveling State = ');
    case LevelState of
      0 : writeln('Leveled      (0)');
      1 : writeln('Semi-leveled (1)');
      2 : writeln('Un-leveled   (2)');
    else
      writeln(LevelState);
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof18;   {rel Attack data}
begin
  with FIPPrec do
  begin
    if not(GetRelAttData(FIPPrec)) then Exit;
    writeln('Attack time: ',AttackTime,'Ms  Release Time: ',ReleaseTime,
            'Ms   at ',RelAttFreq,'Hz');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof19;     {get batt}
begin
  if not(GetBatteryData(FIPPrec)) then Exit;
  with FIPPrec do
  begin
     writeln('Battery current   = ',Str3D(BatteryCurrent),' ma');
     WRITELN('Battery Type      = ','   ',BatteryType);
    if fipprec.rcvarray[1] > 2 then
     writeln('Battery Voltage   = ',Str2d(BatteryVolt),' V');
    if fipprec.rcvarray[1] > 3 then
     WRITELN('Battery Impedence = ',Str2d(BatteryImp),' Ohms');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof20;     {get io data}
var i:integer;
begin
  with FIPPrec do
  begin
    if not(GetIOdata(FIPPrec)) then Exit;
    write('IO Curve: ',IOcurve[0]);
    for i := 1 to 9 do write(Str2d(integer(IOcurve[i])));
    writeln;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof21; {get source amp}
begin
  with FIPPrec do
  begin
    if not(GetSourceAmp(FIPPrec)) then Exit;
    writeln('Current Source Amplitude = ',DbStr(SourceAmp,true));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof22;   {get dist mode}
begin
  with FIPPrec do
  begin
    if not(GetDistMode(FIPPrec)) then Exit;
    write('Current Distortion mode = ');
    case DistMode of
      0 : writeln('None  (0)');
      1 : writeln('2nd   (1)');
      2 : writeln('3rd   (2)');
      3 : writeln('Total (3)');
    else
      writeln(DistMode);
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof23;     {get freq}
begin
  with FIPPrec do
  begin
    if not(GetFrequency(FIPPrec)) then Exit;
    write('Current Frequency = ');
    if Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Frequency,'Hz');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof24;      {get OES state}
begin
  with FIPPrec do
  begin
    if not(GetOESstate(FIPPrec)) then Exit;
    writeln('OES is ',onoff(OESstate));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof25;        {get curve frame}
var i,ii : integer;
    N : longint;
    fc:text;
begin
  with FIPPrec do
  begin
    write('Enter Curve Number to Get (0-13) : ');
    readln(temp);
    CurveNumber := temp;
    if not(GetCurveFrame(FIPPrec)) then Exit;
    write('Crv ',CurveNumber,':');
    ShowCurve(FIPPrec);
    assign(fc,'curve'+fstr(CurveNumber)+'.DAT');
    rewrite(fc);
    for i := 0 to pred(CurveFrameSize) do
    begin
      if ShowInt = true then
        N := smallint(CurveFrame[i])
      else N := word(CurveFrame[i]);
      if (Delimit = true) and (i < pred(CurveFrameSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof26;         {get noise red}
begin
  with FIPPrec do
  begin
    if not(GetNoiseRedCount(FIPPrec)) then Exit;
    writeln('Current Noise Reduction Count = ',NoiseRedCount);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof27;         {get smoothing}
begin
  with FIPPrec do
  begin
    if not(GetSmoothState(FIPPrec)) then Exit;
    write('Smoothing is: ',SmoothState);
    case SmoothState of
     0: writeln(' (OFF)');
     1: writeln(' (100Hz)');
     2: writeln(' (Log)');
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof28;    {version}
var s:str255;
    bt:boolean;
begin
  writeln;
  with FIPPrec do
  begin
   fillchar(FIPPrec.version,sizeof(FIPPrec.Version),0);
   bt := (GetDevVersion(FIPPrec));
   if not bt then bt := (GetDevVersion(FIPPrec)); {try again if didn't make it}
   if bt then
   begin
    DeviceType := fipprec.version[5];
    s := fstr(version[0] div 100) + '.';
    if version[0] mod 100 < 10 then s := s + '0';
    S := s + fstr(version[0] mod 100);
    writeln('Version: ',s,'      ');
    writeln('Options: ',hexW(word(version[2])),hexW(word(version[1])) );
    writeln('Custom : ',hexW(word(version[4])),hexW(word(version[3])) );
    if word(version[5]) = $8000 then
      write('Machine: ',0)
    else
      write('Machine: ',version[5]);
    if word(version[5]) = $8000 then write('  (6500)')
    else if version[5] = 0 then write('  (6500)')
    else if version[5] = 1 then write('  (6400)')
    else if version[5] = 7000 then write('  (7000)')
    else if version[5] = 35 then write('  (FP35)')
    else if (version[5] = 40) then
    begin
      if (version[6] and 1 = 1) then write('  (FP40-D)')
      else write('  (FP40)');
    end
    else if (version[5] >= 100) and (version[5] < 200) then
        write('  (FA',version[5]-90,')')
    else if (version[5] = $FFFF) then
      write('  (Fake)')
    else write('  (?)');
    writeln;
    if word(version[6]) = $8000 then
      writeln('SubType: ',0)
    else
    BEGIN
      write('SubType: ',version[6]);
      if version[5] = 40 then
      begin
        case version[6] and $06 of
          0: write('  Portable');  {original fp40}
          1: write('  Desktop');   {original fp40}
          2: write('  Portable (LCD)'); {94 version}
          3: write('  Desktop (LCD)');  {94 version}
          4: write('  Portable (VGA)'); {94 version}
          5: write('  Desktop (VGA)');  {94 version}
        end;
      end;
      writeln;
    END;
    DeviceType := fipprec.version[5];
   end
   else
   begin
     writeln('** Warning ** Communication failure **');
   end;
   writeln('-----------------------');
   UpdateFryersInfo(FIPPrec);
   s := FverStr(FIPPrec);
   writeln('Fryers :  Version ',s);
   write('Using  :  COM',succ(comport));
   {$IFNDEF WIN32}
     write('  with IRQ',irqnum[comport]);
   {$ENDIF}
   write('  at ',RealBaudRate,' Baud');
   if AutoBaud then write(' (Autobaud)');
   if QTon(fipprec) then write(' (Quick)');
   writeln;
   if Fversion < 400 then
   begin
     writeln('Note   :  The version of the Fryers driver you are using is out of date');
   end;
   writeln;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof29;       {get level state}
begin
  with FIPPrec do
  begin
    if not(GetLevelState(FIPPrec)) then Exit;
    write('Current Leveling State = ');
    case LevelState of
      0 : writeln('Leveled      (0)');
      1 : writeln('Semi-leveled (1)');
      2 : writeln('Un-leveled   (2)');
    else
      writeln(LevelState);
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof30;   {get weighting}
begin
  with FIPPrec do
  begin
    if not(GetWeightState(FIPPrec)) then Exit;
    write('Current Weight State = ');
    case WeightState of
      0 : writeln('(0) UnWeighted (Flat)');
      1 : writeln('(1) Weighted Power');
      2 : writeln('(2) Weighted Gain');
    else
      writeln('(',WeightState,')');
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof31;       {get mic input value}
begin
  with FIPPrec do
  begin
    if not(GetMicData(FIPPrec)) then Exit;
    writeln('Current Microphone Input = ',Str3D(MicData),'dB');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof32;      {get distortion reading}
begin
  with FIPPrec do
  begin
    if not(GetDistPercent(FIPPrec)) then Exit;
    writeln('Current Distortion = ',Str3D(DistPercent),'%');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof33;    {get cmd status}
begin
  with FIPPrec do
  begin
    if not(GetCmdStatus(FIPPrec)) then Exit;
    writeln('Command Result Status = ',CmdStatus);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof34;   {get io mode}
begin
  with FIPPrec do
  begin
    if not(GetIOmode(FIPPrec)) then Exit;
    write('Current IO Test Frequency = ');
    if IOFrequency = 0 then writeln('Composite (0Hz)')
    else writeln(IOfrequency);
    if IOgain = 0 then writeln('  In Amplitude mode (0)')
    else writeln('  In Gain mode (1)');
    if (IOModeCount > 2) then
    begin
      writeln('Current IO Start Delay  = ',IOStartMs,' (mS)');
      writeln('Current IO Sweep Settle = ',IOSweepMs,' (mS)');
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof35;   {get probe state}
begin
  with FIPPrec do
  begin
    if not(GetProbeState(FIPPrec)) then Exit;
    Writeln('Probe State is ',onoff(ProbeState));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof36;   {get gain state}
begin
  with FIPPrec do
  begin
    if not(GetGainState(FIPPrec)) then Exit;
    write('Curve data is shown as ');
    case GainState of
      0 : writeln('OFF (0 - Amplitude)');
      1 : writeln('ON  (1 - Gain)');
    else
      writeln(GainState);
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof37;    {get telecoil state}
begin
  with FIPPrec do
  begin
    if not(GetTelCoilState(FIPPrec)) then Exit;
    writeln('Current TeleCoil State = ',onoff(TelCoilState));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof38;    {do reset}
begin
  with FIPPrec do
  begin
    if not(DoReset(FIPPrec)) then Exit;
    writeln('Reset has been performed');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof39;   {set tcoil mode }
begin
  with FIPPrec do
  begin
    if not(GetTelCoilMode(FIPPrec)) then Exit;
    write('Current Telecoil mode = ');
    case FIPPrec.TelCoilMode of
     0 : writeln('Composite (0)');
     1 : writeln('ANSI      (1)');
     2 : writeln('IEC       (2)');
    else
      writeln('** Invalid Telecoil mode **');
    end;
    write('Enter new TelCoil Mode (0=Composite, 1=ANSI, 2=IEC): ');
    readln(temp);
    TelCoilMode := temp;
    if not(SetTelCoilMode(FIPPrec)) then Exit;
    write('Current Telecoil mode = ');
    case FIPPrec.TelCoilMode of
     0 : writeln('Composite (0)');
     1 : writeln('ANSI      (1)');
     2 : writeln('IEC       (2)');
    else
      writeln('** Invalid Telecoil mode **');
    end;
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof40;   {set rel att frq}
begin
  with FIPPrec do
  begin
    if not(GetRelAttFreq(FIPPrec)) then Exit;
    writeln('Current Attack Release Test Frequency = ',RelAttFreq,'Hz');
    writeln('Frequencies: 1600,2000,2500,0');
    write('Enter new Attack Release Test Frequency : ');
    readln(temp);
    RelAttFreq := temp;
    if not(SetRelAttFreq(FIPPrec)) then Exit;
    writeln('New Attack Release Test Frequency = ',RelAttFreq,'Hz');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof41;  {get att/rel test freq}
begin
  with FIPPrec do
  begin
    if not(GetRelAttFreq(FIPPrec)) then Exit;
    writeln('Current Attack Release Test Frequency = ',RelAttFreq,'Hz');
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof42;   {get last measured curve}
var i,ii : integer;
    N : longint;
    fc:text;
begin
  if not(GetLastCurve(FIPPrec)) then Exit;
  with FIPPrec do
  begin
    write('Curve:');
    ShowCurve(FIPPrec);
    assign(fc,'LCURVE.DAT');
    rewrite(fc);
    for i := 0 to pred(CurveFrameSize) do
    begin
      if (ShowInt = true) then
        N := smallint(CurveFrame[i])
      else N:= word(CurveFrame[i]);
      if (Delimit = true) and (i < pred(CurveFrameSize)) then
        write(fc,N,',')
      else writeln(fc,N);
    end;
    close(fc);
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof43;   { set new zeta state }
begin
  with FIPPrec do
  begin
    if not(GetZetaState(FIPPrec)) then Exit;
    writeln('Current Zeta State = ',OnOff(ZetaState));
    write('Enter new Zeta State (0=off 1=on) : ');
    readln(temp);
    ZetaState := temp;
    if not(SetZetaState(FIPPrec)) then Exit;
    writeln('New Zeta State = ',onoff(ZetaState));
  end;
  pfunerr := 0;
end;



{-----------------------------------------------}
procedure dof44; {get tel coil mode}
begin
  if not(GetTelCoilMode(FIPPrec)) then Exit; {always returns true}
  write('Current Telecoil mode = ');
  case FIPPrec.TelCoilMode of
   0 : writeln('Composite (0)');
   1 : writeln('ANSI      (1)');
   2 : writeln('IEC       (2)');
  else
    writeln('** Invalid Telecoil mode **');
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof45;   { get Zeta state - }
begin
  with FIPPrec do
  begin
    if not(GetZetaState(FIPPrec)) then Exit;
    Writeln('Zeta State is ',onoff(ZetaState));
  end;
  pfunerr := 0;
end;


{-----}
procedure dof46;   {get insitu mode}
begin
  with FIPPrec do
  begin
     if not(GetInsitu(FIPPrec)) then Exit;
     writeln('Current Insitu is = ',onoff(Insitu[0]));
     write  ('Output Correction = ');
     case Insitu[1] of
        0: writeln('None');
        1: writeln('OES + Insertion gain');
        2: writeln('OES only');
        3: writeln('Insertion gain only');
     end;
     write  ('Source Correction = ');
     case Insitu[2] of
        0: writeln('None');
        1: writeln('ITE');
        2: writeln('BTE');
        3: writeln('ITC');
     end;
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof47;   {set insitu mode}
begin
   with FIPPrec do
   begin
     writeln('Current Insitu is = ',onoff(Insitu[0]));
     write  ('Output Correction = ');
     case Insitu[1] of
        0: writeln('None');
        1: writeln('OES + Insertion gain');
        2: writeln('OES only');
        3: writeln('Insertion gain only');
     end;
     write  ('Source Correction = ');
     case Insitu[2] of
        0: writeln('None');
        1: writeln('ITE');
        2: writeln('BTE');
        3: writeln('ITC');
     end;

     write('Enter new Insitu State (0=OFF 1=ON) : ');
     readln(temp);
     Insitu[0] := temp;
     write('Enter new Output correction (0=none,1=OES+INS,2=OES,3=INS) : ');
     readln(temp);
     Insitu[1] := temp;
     write('Enter new Source correction (0=none,1=ITE,2=BTE,3=ITC) : ');
     readln(temp);
     Insitu[2] := temp;

     if not(SetInsitu(FIPPrec)) then Exit;

     writeln('    New Insitu is = ',onoff(Insitu[0]));
     write  ('Output Correction = ');
     case Insitu[1] of
        0: writeln('None');
        1: writeln('OES + Insertion gain');
        2: writeln('OES only');
        3: writeln('Insertion gain only');
     end;
     write  ('Source Correction = ');
     case Insitu[2] of
        0: writeln('None');
        1: writeln('ITE');
        2: writeln('BTE');
        3: writeln('ITC');
     end;
   end;
  pfunerr := 0;
end;


{------}
procedure dof48;   { set new automatic state }
begin
  with FIPPrec do
  begin
    if not(GetAutoState(FIPPrec)) then Exit;
    write('Current Automatic State = (',AutoState,') ');
    case AutoState of
     0: writeln('Manual');
     1: writeln('Automatic');
    end;
    write('Enter new Operation State (0=Manual 1=Automatic) : ');
    readln(temp);
    AutoState := temp;
    if not(SetAutoState(FIPPrec)) then Exit;
    write('New Automatic State = (',AutoState,') ');
    case AutoState of
     0: writeln('Manual');
     1: writeln('Automatic');
    end;
  end;
  pfunerr := 0;
end;



{-------}
procedure dof49;   { get automatic state - }
begin
  with FIPPrec do
  begin
    if not(GetAutoState(FIPPrec)) then Exit;
    write('Current Automatic State = (',AutoState,') ');
    case AutoState of
     0: writeln('Manual');
     1: writeln('Automatic');
    end;
  end;
  pfunerr := 0;
end;


{------}
procedure dof50;   { set new limit value }
begin
  with FIPPrec do
  begin
    if not(GetLimitValue(FIPPrec)) then Exit;
    writeln('Current Output Limit Value = ',Str2D(LimitValue),'dB');
    write('Enter new Output Limit Value : ');
    readln(temp);
    LimitValue := temp*100;
    if not(SetLimitValue(FIPPrec)) then Exit;
    writeln('New Ouput Limit Value = ',Str2D(LimitValue),'dB');
  end;
  pfunerr := 0;
end;



{----------}
procedure dof51;   { get Ouput Limit value - }
begin
  with FIPPrec do
  begin
    if not(GetLimitValue(FIPPrec)) then Exit;
    Writeln('Output Limit Value is ',Str2D(LimitValue),'dB');
  end;
  pfunerr := 0;
end;


{---------}
procedure dof52;   { set new refmic state }
begin
  with FIPPrec do
  begin
    if not(GetRefMicState(FIPPrec)) then Exit;
    writeln('Current RefMic State = ',OnOff(RefMicState));
    write('Enter new RefMic State (0=off 1=on) : ');
    readln(temp);
    RefMicState := temp;
    if not(SetRefMicState(FIPPrec)) then Exit;
    writeln('New RefMic State = ',onoff(RefMicState));
  end;
  pfunerr := 0;
end;


{-------}
procedure dof53;   { get RefMic state - }
begin
  with FIPPrec do
  begin
    if not(GetRefMicState(FIPPrec)) then Exit;
    Writeln('RefMic State is ',onoff(RefMicState));
  end;
  pfunerr := 0;
end;

{---------}
procedure dof54; {set active mode}
begin
  with FIPPrec do
  begin
    if not(GetActiveStatus(FIPPrec)) then Exit;
    writeln('Current Active State = ',OnOff(ActiveStatus));
    write('Enter new Active State (0=off 1=on) : ');
    readln(temp);
    ActiveStatus := temp;
    if temp = 0 then DefaultPoll := ShortPoll else DefaultPoll := LongPoll;
    if not(SetActiveStatus(FIPPrec)) then Exit;
    writeln('New Active State = ',onoff(ActiveStatus));
  end;
  pfunerr := 0;
end;


{---------}
procedure dof55; {Get Active mode}
begin
  with FIPPrec do
  begin
    if not(GetActiveStatus(FIPPrec)) then Exit;
    Writeln('Active State is ',onoff(ActiveStatus));
  end;
  pfunerr := 0;
end;


{----------}
procedure dof56; {do sleep}
begin
   with FIPPrec do
   begin
     if (GetDevVersion(FIPPrec)) then
       DeviceType := fipprec.version[5];

     if (DeviceType = 40) then
     begin
       write('Enter power command (0=Wake up, 1=Power Save, 2=Power Off) : ');
       readln(temp);
       PowerStatus := temp;
       if not(DoPower(FIPPrec)) then Exit;
       writeln('Power command performed');
     end
     else if (DeviceType = 35) then
     begin
       write('Enter power command (0=Wake up, 1=Power Save, 2=Power Down) : ');
       readln(temp);
       PowerStatus := temp;
       if not(DoPower(FIPPrec)) then Exit;
       writeln('Power command performed');
     end
     else if (DeviceType <= 10) or ((version[5] >= 100) and (version[5] < 200)) then
     begin
       if not(DoSleep(FIPPrec)) then Exit;
       writeln('Sleep has been performed');
     end
     else exit; {don't know how to support the function here}
   end;
  pfunerr := 0;
end;



{-----}
procedure dof57; {get ref mic value}
begin
  with FIPPrec do
  begin
    if not(GetRefMicData(FIPPrec)) then Exit;
    writeln('Current RefMic Input = ',Str3D(RefMicData),'dB');
  end;
  pfunerr := 0;
end;


{------}
procedure dof58; {get key scan code}
begin
  with FIPPrec do
  begin
    if not(GetKeyScanCode(FIPPrec)) then Exit;
    Writeln('KeyBoard Scan Code is ',KeyScanCode);
  end;
  pfunerr := 0;
end;



{------}
function MajorStateStr(MS:word):string20;
begin
    case MS of
      0: MajorStateStr := ' (Open/Logo Screen)';
      1: MajorStateStr := ' (Coupler Screen)';
      2: MajorStateStr := ' (ANSI87 Test)';
      3: MajorStateStr := ' (IEC Test)';
      4: MajorStateStr := ' (JIS Test)';
      5: MajorStateStr := ' (ISI Test)';
      6: MajorStateStr := ' (Probe Ins.Gain)';
      7: MajorStateStr := ' (TCoil Test)';
      8: MajorStateStr := ' (Zeta Test)';
      9: MajorStateStr := ' (XAR Test)';    {fixed att/rel}
     10: MajorStateStr := ' (VAR Test)';    {variable att/rel}
     11: MajorStateStr := ' (IO Test)';
     12: MajorStateStr := ' (ANSI92 Test)';
     13: MajorStateStr := ' (AVG Test)';
     14: MajorStateStr := ' (Multi-curve)';
     15: MajorStateStr := ' (CIC Test)';
     16: MajorStateStr := ' (Main Menu)';
     17: MajorStateStr := ' (DSIN Test)';
     18: MajorStateStr := ' (ANSI96 Test)';
     19: MajorStateStr := ' (Profiler Test)';
     20: MajorStateStr := ' (Probe Multi-Crv)';
     21: MajorStateStr := ' (Message Display)';
     22: MajorStateStr := ' (Local Menu)';
     23: MajorStateStr := ' (Probe SPL)';
     24: MajorStateStr := ' (Probe AI)';
     25: MajorStateStr := ' (Probe Audiogram)';
     26: MajorStateStr := ' (Coupler Target)';
     27: MajorStateStr := ' (Ear Simulator)';
     28: MajorStateStr := ' (Phase Delay)';
     29: MajorStateStr := ' (Target Edit)';
     30: MajorStateStr := ' (Probe Navigation)';
     31: MajorStateStr := ' (Probe I/O)';
     32: MajorStateStr := ' (Calibration)';
     33: MajorStateStr := ' (ANSI03 Test)';
     else MajorStateStr := ' (unknown)';
    end;
end;

procedure ShowMajors;
begin
  writeln('Major State: 0=Open,    1=Coupler,  2=ANSI87,     3=IEC,    4=JIS,');
  writeln('  5=ISI,     6=Probe,   7=Tcoil,    8=Zeta,       9=StdAR, 10=VarAR,');
  writeln(' 11=IO,     12=ANSI92, 13=Avg,     14=Multi-Crv,  15=ACIC, 16=Main Menu,');
  writeln(' 17=DSIN,   18=ANSI96, 19=Profile, 20=Probe Multicrv,      21=Message,');
  writeln(' 22=Local Menu,        23=Prb SPL, 24=Prb AI,     25=Probe Aud,');
  writeln(' 26=Coupler Target,    27=Ear Sim, 28=Phase Dly,  29=Target Edit');
  writeln(' 30=Probe Nav,       31=Probe I/O, 32=Calibration,33=ANSI03');
end;

procedure dof59; {Set machine state}
begin
  with FIPPrec do
  begin
    if not(GetMachineState(FIPPrec)) then Exit;
    ShowMajors;
    write('Current Test state is -  Major State: ',MajorMachineState,
                                 '  Minor State: ',MinorMachineState,' ');

    write(MajorStateStr(MajorMachineState));
    writeln;
    write('Enter new major state: ');
    readln(temp);
    MajorMachineState := temp;
    write('Enter new minor state: ');
    readln(temp);
    MinorMachineState := temp;

    if not(SetMachineState(FIPPrec)) then Exit;
    QuickTerminate(FIPPrec);
    if not(GetMachineState(FIPPrec)) then Exit;
    write('New Test state is -  Major State: ',MajorMachineState,
                             '  Minor State: ',MinorMachineState,' ');
    write(MajorStateStr(MajorMachineState));
    writeln;
  end;
  pfunerr := 0;
end;


{------}
procedure dof60; {Get machine state}
begin
  with FIPPrec do
  begin
    if not(GetMachineState(FIPPrec)) then Exit;
    write('Major State: ',MajorMachineState,' ');
    write(MajorStateStr(MajorMachineState));
    writeln;
    writeln('Minor State: ',MinorMachineState);
  end;
  pfunerr := 0;
end;



{------}
procedure dof61; {Get BLOB}
var fc:text;
    i,ii:integer;
    N:longint;
begin
  with FIPPrec do
  begin
    if not(GetBlob(FIPPrec)) then Exit;

    if      Blob[0] = 2 then ShowAnsiBlob(FIPPrec)
    else if Blob[0] = 3 then ShowIecBlob(FIPPrec)
    else if Blob[0] = 4 then ShowJisBlob(FIPPrec)
    else if Blob[0] = 12 then ShowAnsi92Blob(FIPPrec)
    else if Blob[0] = 15 then ShowAnsiBlob(FIPPrec)  {CIC is same as ansi}
    else if Blob[0] = 18 then ShowAnsiBlob(FIPPrec)  {ansi96 is like ansi87}
    else if Blob[0] = 33 then ShowAnsiBlob(FIPPrec)  {ansi03 is like ansi96}
    else ShowUnknownBlob(FIPPrec);
    writeln;
    assign(fc,'BLOB.DAT');
    rewrite(fc);
    if BlobSize > 0 then
    begin
      for i := 0 to pred(BlobSize) do
      begin
        if ShowInt = true then
          N := smallint(Blob[i])
        else N:= word(Blob[i]);
        if (Delimit = true) and (i < pred(BlobSize)) then
          write(fc,N,',')
        else writeln(fc,N);
      end;
    end;
    close(fc);
  end;
  pfunerr := 0;
end;

{------}
procedure dof62; {set control lock}
begin
  with FIPPrec do
  begin
    if not(GetControlLock(FIPPrec)) then Exit;
    write('Current Control Lock State = ');
    case ControlLock of
      0 : writeln('0 - Local Instrument control');
      1 : writeln('1 - RS232 control, Display enabled');
      2 : writeln('2 - RS232 control, Display disabled');
      3 : writeln('3 - RS232 control, Display blanked');
    else
      writeln(ControlLock);
    end;
    writeln('Enter new Control Lock State  (0=Local) ');
    write('(1=RS232:DispEn, 2=RS232:DispOff, 3=RS232:NoDisp) : ');
    readln(temp);
    ControlLock := temp;
    if not(SetControlLock(FIPPrec)) then Exit;
    write('New Control Lock State = ');
    case ControlLock of
      0 : writeln('0 - Local Instrument control');
      1 : writeln('1 - RS232 control, Display enabled');
      2 : writeln('2 - RS232 control, Display disabled');
      3 : writeln('3 - RS232 control, Display blanked');
    else
      writeln(ControlLock);
    end;
  end;
  pfunerr := 0;
end;

{--------}
procedure dof63; {get key control}
begin
  with FIPPrec do
  begin
    if not(GetControlLock(FIPPrec)) then Exit;
    Write('Control Lock State is: ');
    case ControlLock of
      0 : writeln('0 - Local Instrument control');
      1 : writeln('1 - RS232 control, Display enabled');
      2 : writeln('2 - RS232 control, Display disabled');
      3 : writeln('3 - RS232 control, Display blanked');
    else
      writeln(ControlLock);
    end;
  end;
  pfunerr := 0;
end;



{------}
procedure dof64; {Do line feeds}
begin
  with FIPPrec do
  begin
     write('Enter line feeds to perform : ');
     readln(temp);
     PrintFeeds := temp;
     if not(DoLineFeeds(FIPPrec)) then Exit;
     writeln(PrintFeeds,' - Line feeds have been performed');
  end;
  pfunerr := 0;
end;


{----------}
procedure dof65; {do print }
begin
   if (GetDevVersion(FIPPrec)) then
     DeviceType := fipprec.version[5];
   with FIPPrec do
   begin
     if (DeviceType < 10) then
     begin
       writeln('1=Label, 2=Top, 3=Top+Label, 4=Bot, 5=Bot+Label, 6=Top+Bot, 7=Top+Bot+Label');
     end
     else
     begin
       writeln('0=label off, 1=Label on;  2=Print (Label off), 3=Print (Label on)');
     end;
     write('Enter Print command:  ');
     readln(temp);
     PrintType := temp;
     if not(DoPrint(FIPPrec)) then Exit;
     writeln('Print has been performed');
   end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof66;    {set extended label}
var Lab : str255;
    i : integer;
    c : char;
begin
  writeln;
  write('Enter Extended label to read (0=Current, 1=Factory, 2=Stored): ');
  readln(temp);
  FIPPrec.LabelType := temp;
  if not(GetExtendedLabel(FIPPrec)) then Exit;
  c := #255;
  if not(LabelBlank) then
  begin
    ShowLabel(0);
    writeln;
    writeln('Press ESCape to send this label,');
    write('Press any other key to enter a new label: ');
    c := GetKey;
    writeln;
  end
  else
  begin
    writeln('Enter Label Information');
  end;
  writeln;
  if (c <> #$1b) then
  begin
    Lab :=       EntLab('L1:___________________________|',27)+#0;
    Lab := Lab + EntLab('L2:___________________________|',27)+#0;
    Lab := Lab + EntLab('L3:___________________________|',27)+#0;
    Lab := Lab + EntLab('L4:___________________________|',27)+#0;
    Lab := Lab + EntLab('L5:___________________________|',27)+#0;
    Lab := Lab + EntLab('L6:___________________________|',27)+#0;
    Lab := Lab + EntLab('L7:___________________________|',27)+#0;
    Lab := Lab + EntLab('L8:___________________________|',27)+#0;
    i := 1;
    while i < MaxExtLabelSize do
    begin
      FIPPrec.ExtLabelData[pred(i)] := Lab[i];
      inc(i);
    end;
    FIPPrec.ExtLabelData[pred(i)] := #0;
  end;
  if not(SetExtendedLabel(FIPPrec)) then Exit;
  writeln;
  writeln('* Label Sent *');
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof86;    {get extended label}
begin
  write('Enter Extended label to read (0=Current, 1=Factory, 2=Stored): ');
  readln(temp);
  FIPPrec.LabelType := temp;
  if not(GetExtendedLabel(FIPPrec)) then Exit;
  writeln('Current Label Information');
  writeln;
  ShowLabel(0);
  writeln;
  pfunerr := 0;
end;


{-----------------------------------------------}
function LabelMethodStr(LabelMethod:integer):string80;
begin
  case LabelMethod of
   0 : LabelMethodStr := 'Store and use current label and ID';
   1 : LabelMethodStr := 'Store and use factory default label';
   2 : LabelMethodStr := 'Read and use stored printer label';
   3 : LabelMethodStr := 'Read and use factory default label';
   4 : LabelMethodStr := 'Store and use current label bitmap';
   5 : LabelMethodStr := 'Store and use factory label bitmap';
   6 : LabelMethodStr := 'Read and use stored label bitmap';
   7 : LabelMethodStr := 'Read and use factory label bitmap';
   8 : LabelMethodStr := 'Disable Label Time Stamp';
   9 : LabelMethodStr := 'Enable Label Time Stamp';
  else LabelMethodStr := '?';
  end;
end;

procedure dof89;    {set default label}
var i : integer;
begin
  for i := 0 to 7 do
    writeln(i,' = ',LabelMethodStr(i));
  write('Select label storage action: ');
  readln(temp);
  FIPPrec.PrinterLabelStorage := temp;
  if not(SetPrinterLabelStorage(FIPPrec)) then Exit;
  FIPPrec.LabelType := 0;
  if not(GetExtendedLabel(FIPPrec)) then Exit;
  writeln('Current Label Information');
  writeln;
  ShowLabel(0);
  writeln;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof67;    {do error}
begin
  with FIPPrec do
  begin
    if not(DoError(FIPPrec)) then Exit;
    writeln('Error flash has been performed');
  end;
  pfunerr := 0;
end;

{------}
procedure dof68; {Set spectrum}
var What : string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
    ii:word;
    i : integer;
begin
  with FIPPrec do
  begin
    What := 'Spectrum.DAT';
    if FileExists(What) then
    begin
      assign(fc,What);
      writeln('Loading specturm data from SPECTRUM.DAT file');
      reset(fc);
      for i := 0 to pred(MaxSpectrumPos) do
      begin
        readln(fc,Spectrum[i]);
      end;
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find SPECTRUM.DAT file');
      Exit;
    end;

    if not(SetSpectrum(FIPPrec)) then Exit;
    ii := 0;
    for i := 0 to pred(MaxSpectrumPos) do
    begin
      write(fStr(Spectrum[i]),' ');
      inc(ii);
      if ii > 9 then
      begin
        writeln;
        ii := 0;
      end;
    end;

  end;
  pfunerr := 0;
end;

{------}
procedure dof69; {Set phase}
var what:string[80];
    Src,Dest:array[0..80] of char;
    fc:text;
    i,ii:integer;
begin
  with FIPPrec do
  begin
    What := 'Phase.DAT';
    if FileExists(what) then
    begin
      assign(fc,What);
      writeln('Loading phase data from PHASE.DAT file');
      reset(fc);
      for i := 0 to pred(MaxPhasePos) do
      begin
        readln(fc,PhaseTable[i]);
      end;
      close(fc);
    end
    else
    begin
      writeln('Error: Could not find PHASE.DAT file');
      Exit;
    end;

    if not(SetPhaseTable(FIPPrec)) then Exit;
    ii := 0;
    for i := 0 to pred(MaxPhasePos) do
    begin
      write(fStr(PhaseTable[i]),' ');
      inc(ii);
      if ii > 9 then
      begin
        writeln;
        ii := 0;
      end;
    end;
  end;
  pfunerr := 0;
end;


{=================}
procedure ShowOptParams;
var i : integer;
begin
  with FIPPrec do
  begin
  {  Writeln('Option State is    =   ',Options[0]); }
    writeln('Option selects are === 1: ',Options[1]);
    if OptionSize > 0 then
    begin
      for i := 2 to pred(OptionSize) do
      begin
        writeln('                               ',i,': ',Options[i]);
      end;
    end;
  end;
end;


{------}
procedure dof70; {Set option params}
var i:word;
begin
  with FIPPrec do
  begin
    writeln('Major: 2=ANSI87, 3=IEC, 4=JIS, 12=ANSI92, 15=ACIC, 17=DSIN,');
    writeln('      18=ANSI96, 20=PROFILE');
    write('Enter Major State Options to set: ');
    readln(temp);
    Options[0] := temp;
    if not(GetOptionParams(FIPPrec)) then Exit;
    write('Current ');
    ShowOptParams;
    writeln;
    if OptionSize > 0 then
    begin
      for i := 1 to pred(OptionSize) do
      begin
        write('Enter new option parameter ',i,':');
        readln(temp);
        Options[i] := temp;
      end;
    end;
    if not(SetOptionParams(FIPPrec)) then Exit;
    if not(GetOptionParams(FIPPrec)) then Exit;
    writeln;
    write('    New ');
    ShowOptParams;

  end;
  pfunerr := 0;
end;

{------}
procedure dof71; {Get option params}
var i:word;
begin
  with FIPPrec do
  begin
    writeln('Major: 2=ANSI87, 3=IEC, 4=JIS, 12=ANSI92, 15=ACIC, 17=DSIN,');
    writeln('      18=ANSI96, 20=PROF');
    write('Enter Major State Options to get: ');
    readln(temp);
    Options[0] := temp;
    if not(GetOptionParams(FIPPrec)) then Exit;
    write('        ');
    ShowOptParams;
  end;
  pfunerr := 0;
end;



{---------}
procedure dof72; {set key scan code}
begin
  with FIPPrec do
  begin
    if not(GetKeyScanCode(FIPPrec)) then Exit;
    writeln('Current KeyBoard Scan Code = ',KeyScanCode);
    write('Enter new KeyBoard Scan Code: ');
    readln(temp);
    KeyScanCode := temp;
    if not(SetKeyScanCode(FIPPrec)) then Exit;
    writeln('New KeyBoard Scan Code = ',KeyScanCode);
  end;
  pfunerr := 0;
end;

{---------}
procedure dof73; {set POLL DELAY}
begin
  with FIPPrec do
  begin
    if not(GetPollDelay(FIPPrec)) then Exit;
    writeln('Current Poll Delay = ',PollDelay);
    write('Enter new Poll Delay Time (mS): ');
    readln(temp);
    PollDelay := temp;
    if not(SetPollDelay(FIPPrec)) then Exit;
    writeln('New Poll Delay = ',PollDelay);
  end;
  pfunerr := 0;
end;



{---------}
procedure dof74; {get POLL DELAY}
begin
  with FIPPrec do
  begin
    if not(GetPollDelay(FIPPrec)) then Exit;
    writeln('Poll Delay: ',PollDelay);
  end;
  pfunerr := 0;
end;


procedure ShowWhichEar(TestEar:integer);
begin
  if FIPPrec.EarConfig < 0 then
  begin
    case TestEar of
     0:writeln(' (Left)');
     1:writeln(' (Right)');
    end;
  end
  else
  begin
    case TestEar of
     0:writeln(' (None)');
     1:writeln(' (Left)');
     2:writeln(' (Right)');
     3:writeln(' (Bone)');
    end;
  end;
end;

{---------}
procedure dof75; {set test ear}
begin
  with FIPPrec do
  begin
    EarConfig := -1;
    if not(GetTestEar(FIPPrec)) then Exit;
    write('Current Test Ear = ',TestEar);
    ShowWhichEar(TestEar);
    if EarConfig < 0 then
      write('Enter new Test Ear (0=Left, 1=Right): ')
    else write('Enter new Test Ear (0=None, 1=Left, 2=Right): ');
    readln(temp);
    TestEar := temp;
    if not(SettestEar(FIPPrec)) then Exit;
    write('New Test Ear = ',TestEar);
    ShowWhichEar(TestEar);
  end;
  pfunerr := 0;
end;



{---------}
procedure dof76; {get test ear}
begin
  with FIPPrec do
  begin
    if not(GetTestEar(FIPPrec)) then Exit;
    write('Test Ear : ',TestEar);
    ShowWhichEar(TestEar);
  end;
  pfunerr := 0;
end;

procedure ShowOpState(OpState:integer);
begin
  case OpState of
    0: write('Pure sweep');
    1: write('Composite (chirp)');
    2: write('Fast sweep');
    3: write('Single tone');
    4: write('Short (burst) tone');
    5: write('Composite noise');
    6: write('Digital Speech');
    7: write('ICRA Dig Speech');
    8: write('Intermod Dist.');
  end;
end;

{------}
procedure dof77;   { set new operation state }
begin
   if (GetDevVersion(FIPPrec)) then
     DeviceType := fipprec.version[5];
  with FIPPrec do
  begin
    if not(GetOpState(FIPPrec)) then Exit;
{//    if (devicetype = 40) or (DeviceType = 35) then}
{//    begin}
      write('Current Operation State = (',OpState,') ');
      ShowOpState(OpState);
      writeln;
      writeln;
      writeln('0=Pure tone, 1=Composite(chirp), 2=Fast tone,   3=Single tone(probe),');
      writeln('4=Short,     5=Composite(noise), 6=Dig Speech,  8=IDist');
 { //    if ProbeState <> 0 then}
 { //      write(', 3=single');  }
      write('Enter new Operation State : ');
{//    end  }
{//    else }
{//    begin}
{//      writeln('Current operation State = ',OpState);}
{//      write('Enter new operation State : ');}
{//    end;}
    readln(temp);
    OpState := temp;
    if not(SetOpState(FIPPrec)) then Exit;
{//    if (devicetype = 40) or (devicetype = 35) then}
{//    begin                                         }
      write('New Operation State = (',OpState,') ');
      ShowOpState(OpState);
      writeln;
{//    end}
{//    else}
{//      writeln('New operation State = ',OpState);}
  end;
  pfunerr := 0;
end;



{-------}
procedure dof78;   { get operating state - }
begin
  if (GetDevVersion(FIPPrec)) then
    DeviceType := fipprec.version[5];
  with FIPPrec do
  begin
    if not(GetOpState(FIPPrec)) then Exit;
{//    if (devicetype = 0) or (devicetype = 1) then}
{//    begin                                        }
{//      write('Current Operation State = (',OpState,') ');}
{//      case OpState of                                   }
{//       0: writeln('Manual');                            }
{//       1: writeln('Automatic');                         }
{//      end;                                              }
{//    end                                                 }
{//    else       }
{//    begin      }
      write('Current Operation State = (',OpState,') ');
      ShowOpState(OpState);
      writeln;
{//    end   }
{//    else  }
{//    begin }
{//      writeln('Current operation State = ',OpState);}
{//    end; }
  end;
  pfunerr := 0;
end;



{---------}
procedure dof79; {set batt type}
begin
  with FIPPrec do
  begin
    BatterySelect := 0; {0=use single parameter, 1=use all}
    if not(GetBatteryInfo(FIPPrec)) then Exit;
    writeln('Current Battery Type = ',BatteryType);
    write('Enter new Battery Type: ');
    readln(temp);
    BatteryType := temp;
    BatterySelect := 1;  {one parameter entered}
    if (Version[5] = 0) or (Version[5] = 1) or(Version[5] = 35) or (Version[5] = 40) then
    begin
      write('Enter new Battery Size (use -1 if unknown): ');
      readln(temp);
      if (temp >= 0) then
      begin
        BatterySize := temp;
        BatterySelect := 2;
      end;
    end;
    if not(SetBatteryType(FIPPrec)) then Exit;
    writeln('New Battery Type = ',BatteryType);
  end;
  pfunerr := 0;
end;

{------}
procedure dof80; {Get power status}
begin
  with FIPPrec do
  begin
    if not(GetPowerStatus(FIPPrec)) then Exit;
    if PowerVoltage <> $8000 then
      write('Power Volts: ',str2d(PowerVoltage),'V');
    writeln('  Power Flags: ',hexw(PowerFlags),'H');
    if (PowerFlags and $0080) <> 0 then
    begin
      if (PowerFlags and $0002) <> 0 then writeln('Battery is fully charged');
      if (PowerFlags and $1000) <> 0 then writeln('Battery is nearly empty');
      if (PowerFlags and $0004) <> 0 then writeln('Battery in overcharge mode');
      if (PowerFlags and $0010) <> 0 then writeln('Battery charger is ON');
      if (PowerFlags and $0080) <> 0 then writeln('Charger status is valid');
    end;
    if (PowerFlags and $0020) =  0 then writeln('External Power is ON');
    if (PowerFlags and $2000) <> 0 then writeln('Instrument is in Standby mode');
    if (PowerFlags and $4000) <> 0 then writeln('Instrument is asleep (power down)');
    if (PowerFlags and $8000) <> 0 then writeln('Screen Saver is enabled');
    if (PowerFlags and $8000) =  0 then writeln('Screen Saver is disabled');

    if StandbyTimeout = 0 then
      writeln('Screen Saver Standby Timeout: OFF')
    else if StandbyTimeout > 0 then
      writeln('Screen Saver Standby Timeout: ',fstr(StandbyTimeout),' Minutes');
    if PowerDownTimeout = 0 then
      writeln('Power Saver Timeout: OFF')
    else if PowerDownTimeout > 0 then
      writeln('Power Saver Timeout: ',fstr(PowerDownTimeout),' Minutes');
  end;
  pfunerr := 0;
end;


{-----------------------------------------------------------------------------}
  function AvgFrqStr(Select:word):string20;
  begin
    case Select of
     0: AvgFrqStr := ' 800,1250,2000';
     1: AvgFrqStr := '1000,1600,2500';
     2: AvgFrqStr := '1250,2000,3150';
     3: AvgFrqStr := '1600,2500,4000';
     4: AvgFrqStr := '2000,3150,5000';
     5: AvgFrqStr := ' 500,1000,2000';
    end;
  end;
  function DistFrqStr(Select:word):string20;
  begin
    case Select of
     0: DistFrqStr := ' 400, 650,1000';
     1: DistFrqStr := ' 500, 800,1600';
     2: DistFrqStr := ' 650,1000,1600';
     3: DistFrqStr := ' 800,1250,2000';
     4: DistFrqStr := '1000,1250,2000';
     5: DistFrqStr := ' 250, 500,1000';
    end;
  end;
  function AvgTypeStr(Select:word):string8;
  begin
    case Select of
     0: AvgTypeStr := '(SPA)';
     1: AvgTypeStr := '(HFA)';
     2: AvgTypeStr := '(SPA)';
     3: AvgTypeStr := '(SPA)';
     4: AvgTypeStr := '(SPA)';
     5: AvgTypeStr := '(IEC)';
    end;
  end;


procedure ShowAvgFreqs(Select:smallint; ShowValues:boolean);
begin
  with FIPPrec do
  begin
    if ShowValues then
    begin
      if Select < 0 then writeln('(CST) Custom Values')
      else writeln(AvgTypeStr(Select),' Values');
      writeln('    [Freqs: ',fstr(AvgFreqValues.F1),',',fstr(AvgFreqValues.F2),',',fstr(AvgFreqValues.F3),' Hz]');
      writeln('    [ Dist: ',fstr(AvgFreqValues.D1),',',fstr(AvgFreqValues.D2),',',fstr(AvgFreqValues.D3),' Hz]');
    end
    else
    begin
      if (Select < 6) and (Select >= 0) then
      begin
        writeln('  ',AvgTypeStr(Select),' Selection');
        writeln('    [Freqs: ', AvgFrqStr(Select),' Hz]');
        writeln('    [ Dist: ',DistFrqStr(Select),' Hz]');
      end
      else if Select = -1 then
        writeln('    [Custom Frequencies]')
      else writeln;
    end;
  end;
end;

{---------}
procedure dof81; {get avg freqs}
begin
  with FIPPrec do
  begin
    if not(GetAvgFreqs(FIPPrec)) then Exit;
      write(' Avg Freqs: ',AvgFreqs,'  ');
    ShowAvgFreqs(AvgFreqs,UseAvgFreqValues);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof82; {set avg freqs}
begin
  with FIPPrec do
  begin
    {UseAvgFreqValues := false;}
    if not(GetAvgFreqs(FIPPrec)) then Exit;
    write('Current Avg Freqs = ',AvgFreqs,'  ');
    ShowAvgFreqs(AvgFreqs,UseAvgFreqValues);

    write('Enter new Avg Freq Selection (0-5),(-1=Custom),(6=New Custom): ');
    readln(temp);
    if Temp > 5 then
    begin
      write('Enter new F1 (Hz) ');
      readln(temp);
      AvgFreqValues.F1 := temp;
      write('Enter new F2 (Hz) ');
      readln(temp);
      AvgFreqValues.F2 := temp;
      write('Enter new F3 (Hz) ');
      readln(temp);
      AvgFreqValues.F3 := temp;
      write('Enter new D1 (Hz) ');
      readln(temp);
      AvgFreqValues.D1 := temp;
      write('Enter new D2 (Hz) ');
      readln(temp);
      AvgFreqValues.D2 := temp;
      write('Enter new D3 (Hz) ');
      readln(temp);
      AvgFreqValues.D3 := temp;
      UseAvgFreqValues := true;
      AvgFreqs := -1;
    end
    else
    begin
      AvgFreqs := temp;
      UseAvgFreqValues := false;
    end;
    if not(SetAvgFreqs(FIPPrec)) then Exit;
    write('New Avg Freqs = ',AvgFreqs,'      ');
    ShowAvgFreqs(AvgFreqs,UseAvgFreqValues);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof83; {get measurment settle delay}
begin
  with FIPPrec do
  begin
    if not(GetSettleTime(FIPPrec)) then Exit;
    if SettleType >= 1 then
    begin
      writeln('Measurment Settle Time: ',FreqSettleTime,' (mS)');
    end;
    if SettleType >= 3 then
    begin
      writeln('Amplitude Settle Time = ',AmpSettleTime,' (mS)');
      writeln('Start Delay Time = ',MeasureStartTime,' (mS)');
    end;
    if (SettleType > 3) then
    begin
      writeln('Io Start Delay Time = ',IoStartDelayTime,' (mS)');
      writeln('Io Amplitude Settle Time = ',IoAmpSettleTime,' (mS)');
    end;
  end;
  pfunerr := 0;
end;

{---------}
procedure dof84; {set measurment settle DELAY}
begin
  with FIPPrec do
  begin
    if not(GetSettleTime(FIPPrec)) then Exit;
    if SettleType <= 1 then
    begin
      writeln('Current Measurement Settle Time = ',FreqSettleTime,' (mS)');
    end
    else if (SettleType >= 3) then
    begin
      writeln('Current Frequency Settle Time = ',FreqSettleTime,' (mS)');
      writeln('Current Amplitude Settle Time = ',AmpSettleTime,' (mS)');
      writeln('Current Start Delay Time = ',MeasureStartTime,' (mS)');
    end;
    if (SettleType >= 5) then
    begin
      writeln('Current I/O Settle Time = ',IoAmpSettleTime,' (mS)');
      writeln('Current I/O Start Delay Time = ',IoStartDelayTime,' (mS)');
    end;

    if (SettleType <= 1) then
    begin
      write  ('Enter new Measurment Settle Time (mS): ');
      readln(temp);
      FreqSettleTime := temp;
      if not(SetSettleTime(FIPPrec)) then Exit;
      writeln('New Measurment Settle Time = ',FreqSettleTime);
    end
    else if (SettleType >= 3) then
    begin
      write  ('Enter new Frequency Settle Time (mS): ');
      readln(temp);
      FreqSettleTime := temp;
      write  ('Enter new Amplitude Settle Time (mS): ');
      readln(temp);
      AmpSettleTime := temp;
      write  ('Enter new Start Delay Time (mS): ');
      readln(temp);
      MeasureStartTime := temp;
      if (SettleType >= 5) then
      begin
        write  ('Enter new I/O Settle Time (mS): ');
        readln(temp);
        IoAmpSettleTime := temp;
        write  ('Enter new I/O Start Delay Time (mS): ');
        readln(temp);
        IoStartDelayTime := temp;
      end;
      if not(SetNewSettleTime(FIPPrec)) then Exit;
      writeln('New Frequency Settle Time = ',FreqSettleTime);
      writeln('New Amplitude Settle Time = ',AmpSettleTime);
      writeln('New Start Delay Time = ',MeasureStartTime);
      if (SettleType >= 5) then
      begin
        writeln('New I/O Settle Time = ',IoAmpSettleTime);
        writeln('New I/O Start Delay Time = ',IoStartDelayTime);
      end;
    end;
  end;
  pfunerr := 0;
end;


{-----------------------------------------------}
procedure dof85; {do measurment}
var tmp:real;
begin
  with FIPPrec do
  begin
    if not(GetFrequency(FIPPrec)) then Exit;
    if not(GetSourceAmp(FIPPrec)) then Exit;
    write('Current Frequency = ');
    if Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Frequency,'Hz');
    writeln('Current source = ',SourceAmp div 100,'dB');
    writeln;

    write('Enter new Frequency (Composite = 0) : ');
    readln(temp);
    Frequency := temp;
    write('New Frequency = ');
    if Frequency = 0 then
      writeln('Composite (0Hz)')
    else
      writeln(Frequency,'Hz');

    write('Enter new Source Amp value (50, 60, etc. 0=off) : ');
    readln(tmp);
    if tmp > 300 then Exit;
    SourceAmp := trunc(tmp * 100);
    writeln('New Source Amplitude = ',DbStr100(SourceAmp,true));

    write  ('Enter Measurment Settle Time (mS): ');
    readln(temp);
    DoMeasureSettleTime := temp;

    if not(DoMeasurement(FIPPrec)) then Exit;

    writeln('Microphone Input = ',Str3D(MeasureMicData),'dB');

  end;
  pfunerr := 0;
end;



{-----------------------------------------------}
procedure dof87;      {get CIC state}
begin
  with FIPPrec do
  begin
    if not(GetCICstate(FIPPrec)) then Exit;
    writeln('CIC is ',onoff(CICstate));
  end;
  pfunerr := 0;
end;

{-----------------------------------------------}
procedure dof88;
begin
  with FIPPrec do
  begin
    if not(GetCICstate(FIPPrec)) then Exit;
    writeln('Current CIC state = ',OnOff(CICstate));
    write('Enter new CIC state (0=off 1=on) : ');
    readln(temp);
    CICstate := temp;
    if not(SetCICstate(FIPPrec)) then Exit;
    writeln('New CIC state = ',OnOff(CICstate));
  end;
  pfunerr := 0;
end;


{---------}
procedure dof90; {set avg DELAY time}
begin
  with FIPPrec do
  begin
    if not(GetAvgDelayTime(FIPPrec)) then Exit;
    writeln('Current Average Start Delay Time = ',AvgStartTime,' (mS)');
    writeln('Current Average      Settle Time = ',AvgSettleTime,' (mS)');
    writeln;
    write  ('Enter new Average Start Delay Time (mS): ');
    readln(temp);
    AvgStartTime := temp;
    write  ('Enter new Average      Settle Time (mS): ');
    readln(temp);
    AvgSettleTime := temp;
    if not(SetAvgDelayTime(FIPPrec)) then Exit;
    writeln;
    writeln('New Average Start Delay Time = ',AvgStartTime,' (mS)');
    writeln('New Average      Settle Time = ',AvgSettleTime,' (mS)');
  end;
  pfunerr := 0;
end;


{---------}
procedure dof91; {get avg delay time}
begin
  with FIPPrec do
  begin
    if not(GetAvgDelayTime(FIPPrec)) then Exit;
    writeln('Average Start Delay Time : ',AvgStartTime,' (mS)');
    writeln('Average Settle Time      : ',AvgSettleTime,' (mS)');
  end;
  pfunerr := 0;
end;

{---------}
procedure dof92; {set printer type}
begin
  with FIPPrec do
  begin
    if not(GetPrinterSelect(FIPPrec)) then Exit;
    writeln('Current Printer Type  = ',PrinterType);
    if (PrinterCount > 1) then
      writeln('Current Printer Setup = ',PrinterSetup);
    writeln;
    write  ('Enter new Printer Type : ');
    readln(temp);
    PrinterType := temp;
    if PrinterCount > 1 then
    begin
      write  ('Enter new Printer Setup : ');
      readln(temp);
      PrinterSetup := temp;
    end;
    if not(SetPrinterSelect(FIPPrec)) then Exit;
    writeln;
    writeln('New Printer Type = ',PrinterType);
    if PrinterCount > 1 then
      writeln('New Printer Setup = ',PrinterSetup);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof93; {get printer Type}
begin
  with FIPPrec do
  begin
    if not(GetPrinterSelect(FIPPrec)) then Exit;
    writeln('Printer Type : ',PrinterType);
    if (PrinterCount > 1) then
      writeln('Printer Setup : ',PrinterSetup);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof94; {get HFA measurement}
begin
  with FIPPrec do
  begin
    if not(GetHFAMeasurement(FIPPrec)) then Exit;
    writeln('HFA: ',Str3D(HFAData),'dB');
  end;
  pfunerr := 0;
end;

{-------------------------------------------------}
function GetFryeDateToStr(FryeDate:longint):str255;
var S:str255;
var valid:boolean;
begin
  S := FryeDateToStr(FryeDate,Valid);
  if length(sTrim(S)) = 0 then
    S := '?';
  GetFryeDateToStr := S;
end;
function GetSerialNumberString(S:str255):str255;
begin
  if length(sTrim(S)) = 0 then
    S := '?';
  GetSerialNumberString := S;
end;

procedure dof95; {get software info}
var fc:text;
{var Serial:string[80]; }
{var MfgDate : string[80];}
begin
  with FIPPrec do
  begin
    if not(GetInstrumentInfo(FIPPrec)) then Exit;
    writeln('      Instrument : ',InstrumentInfo.Machine);
    writeln('Software Version : ',InstrumentInfo.Version);
    writeln('        Language : ',InstrumentInfo.Language);
    writeln('  Loader Version : ',InstrumentInfo.LoaderVersion);
    writeln('   EErom Version : ',InstrumentInfo.EEromVersion);
    writeln('   Serial Number : ',GetSerialNumberString(InstrumentInfo.SerialNumber));
    writeln('    Manufactured : ',GetFryeDateToStr(InstrumentInfo.MfgDate));
    writeln('    Hardware Cal : ',GetFryeDateToStr(InstrumentInfo.HwCalDate));
    writeln('    Software Cal : ',GetFryeDateToStr(InstrumentInfo.SwCalDate));
    assign(fc,'SOFTWARE.DAT');
    rewrite(fc);
    writeln(fc,InstrumentInfo.Machine);
    writeln(fc,Instrumentinfo.Version);
    writeln(fc,InstrumentInfo.Language);
    writeln(fc,InstrumentInfo.LoaderVersion);
    writeln(fc,InstrumentInfo.EEromVersion);
    writeln(fc,InstrumentInfo.SerialNumber);
    writeln(fc,InstrumentInfo.MfgDate);
    writeln(fc,InstrumentInfo.HwCalDate);
    writeln(fc,InstrumentInfo.SwCalDate);
    close(fc);
  end;
  pfunerr := 0;
end;


{---------}
procedure dof96; {set printer label bitmap}
var s : string80;
begin
  with FIPPrec do
  begin
    s := 'LABEL.BMP';
    if GetBitmapFile(s) <> 0 then Exit;
    if ConvertBmpToFrye <> 0 then Exit;
    if not SetPrinterLabelBitmap(FIPPrec) then Exit;
    writeln('Bitmap: ',S,' sent to printer label');
  end;
  pfunerr := 0;
end;

{---------}
function ARTestTypeStr(Test:integer):string20;
begin
  case Test of
    0 : ARTestTypeStr := '(XAR)';
    1 : ARTestTypeStr := '(VAR)';
    2 : ARTestTypeStr := '(ANSI96)';
  else ARTestTypeStr := '(?)';
  end;
end;

procedure ShowARParams;
begin
  with FIPPrec do
  begin
    writeln('  A/R Test Type  : ',ARParams[0],ARTestTypeStr(ARParams[0]));
    writeln('  A/R Frequency  : ',ARParams[1],' (Hz)');
    writeln('  Attack Window  : ',ARParams[2]);
    writeln('  Release Window : ',ARParams[3]);
  end;
end;

{---------}
procedure dof97; {set A&R Params}
begin
  with FIPPrec do
  begin
    if not(GetARparams(FIPPrec)) then Exit;
    writeln('Current Attack and Release Parameters:');
    ShowARparams;
    writeln;
    write  ('Enter new Test Type: ');
    readln(temp);
    ARParams[0] := temp;
    write  ('Enter new Test Frequency: ');
    readln(temp);
    ARParams[1] := temp;
    write  ('Enter new Attack Window:');
    readln(temp);
    ARParams[2] := temp;
    write  ('Enter new Release Window:');
    readln(temp);
    ARParams[3] := temp;
    if not(SetARparams(FIPPrec)) then Exit;
    writeln;
    ShowARParams;
  end;
  pfunerr := 0;
end;

{---------}
procedure dof98; {get attack and release}
begin
  if not(GetARparams(FIPPrec)) then Exit;
  ShowARparams;
  pfunerr := 0;
end;

{------}
procedure dof99; {Set BLOB}
var fc:text;
    ii:integer;
begin
  with FIPPrec do
  begin
    writeln;
    assign(fc,'BLOB.DAT');
    reset(fc);
    BlobSize := 0;
    while not(eof(fc)) do
    begin
      Readln(fc,BLOB[BlobSize]);
      inc(BlobSize);
    end;
    close(fc);
    if not(SetBlob(FIPPrec)) then Exit;
    writeln('Blob has been uploaded to instrument');
  end;
  pfunerr := 0;
end;



end.
