90  PRINT "B&K mastoid 983786 TABLE as of APR 20, 1992 for ANSI89"
91 PRINT
92 LN10 = 1 / LOG(10)
100   ' mastoid correction table
110 N = 9  'number of frequency points in MASTOID ERROR table
120 PRINT "freq  mastoid   ansi";
121 PRINT "    output      output at    output at  output at output at"
130 PRINT "       error   thresh   0 HL        0 HL         40 HL       0 HL";
131 PRINT "      70 HL "
140 DIM A(N + 4), B(N + 4), C(N + 4), D(N + 4), E(N + 4), F(N + 4), FR(N)
141 DIM G(N + 4)
150 S = 1.03E-07   ' 103nV/uNewton MASTOID SENSITIVITY AT 1000 Hz
170   ' new MASTOID ERROR TABLE (9 points): stored in A
171   ' POSITIVE NUMBER MEANS MORE OUTPUT FROM THE MASTOID
180 DATA -0.5,-0.5,-0.2,0,1,2,3,-1,-9         
181 '(250hz 500hz 750hz 1Khz 1.5khz 2khz 3khz 4khz 6khz)
190 FOR I = 0 TO N - 1: READ A(I): NEXT I
191 A(N) = A(3): A(N + 1) = A(3): A(N + 2) = A(3): A(N + 3) = A(3)
192 ' NBN = SPN = EXT = WHITE NOISE = ERROR AT 1000 Hz
211   ' ansi thresholds at 250 500 750 1k 1.5k 2k 3k 4k 6k NBN SPN EXT WN
212   'NBN = 1000 HZ +3DB; SPN = 1000 HZ+ 12.5 DB ; EXT = SPN; WN=1000 - 6DB
213   ' 750,1500 interpolated, 6000 from Grace and Stadtler
214 DATA 61,59,47,39,35,32.5,28,31,35,42,51.5,51.5,33.0
215 FOR I = 0 TO N + 3: READ B(I): NEXT I
220 DATA 250,500,750,1000,1500,2000,3000,4000,6000
230 FOR I = 0 TO N - 1: READ FR(I): NEXT I    ' the ansi frequencies
240 FOR I = 0 TO N + 3
241 C(I) = B(I) + A(I)' this is the actual mastoid output re 103nV/uNt
250 D(I) = S * 10 ^ (C(I) / 20)' volts out at threshold
260 E(I) = D(I) * 100 ' volts out at 40 db above threshold 
270 F(I) = E(I) * SQR(1000) ' volts out at 70 db above threshold
275 G(I) = 20 * LN10 * LOG(D(I))
280 NEXT I
290 FOR I = 0 TO N - 1  ' the tone entries
291 PRINT USING "####  ##.##db  ##.##"; FR(I); A(I); B(I);
292 PRINT USING "   ##.##db     ###.###uV"; C(I); D(I) * 1000000!;
293 PRINT USING "    ##.###mV  ####.## dbV  ###.###mV"; E(I) * 1000; G(I); F(I) * 1000
300 NEXT I
311 PRINT USING "NBN   ##.##db  ##.##"; A(N); B(N);
312 PRINT USING "   ##.##db     ###.###uV"; C(N); D(N) * 1000000!;
313 PRINT USING "    ##.###mV  ####.## dbV  ###.###mV"; E(N) * 1000; G(N); F(N) * 1000
321 PRINT USING "SPN   ##.##db  ##.##"; A(N + 1); B(N + 1);
322 PRINT USING "   ##.##db     ###.###uV"; C(N + 1); D(N + 1) * 1000000!;
323 PRINT USING "    ##.###mV  ####.## dbV  ###.###mV"; E(N + 1) * 1000; G(N + 1); F(N + 1) * 1000
331 PRINT USING "EXT   ##.##db  ##.##"; A(N + 2); B(N + 2);
332 PRINT USING "   ##.##db     ###.###uV"; C(N + 2); D(N + 2) * 1000000!;
333 PRINT USING "    ##.###mV  ####.## dbV  ###.###mV"; E(N + 2) * 1000; G(N + 2); F(N + 2) * 1000
341 PRINT USING "WN    ##.##db  ##.##"; A(N + 3); B(N + 3);
342 PRINT USING "   ##.##db     ###.###uV"; C(N + 3); D(N + 3) * 1000000!;
343 PRINT USING "    ##.###mV  ####.## dbV  ###.###mV"; E(N + 3) * 1000; G(N + 3); F(N + 3) * 1000
900 END
                     

