
{ FA series audiometer front panel control program }
{ V2.00 as of 9 April 1997 }
{ Copyright 1992,1997 Frye Electronics }
{ written by Michael Day }

unit ApacUnit;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  {$R AUD.RES}
  uses DosCrt,WinTypes,Strings,Audunit,AudIO,AudSubs,VidSubs,AudFipp,AudMisc;
{$ENDIF}
{$IFDEF ISDOS}
  uses crt,Audunit,AudIO,AudSubs,VidSubs,AudFipp,AudMisc,Mouse;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,Audunit,AudIO,AudSubs,VidSubs,AudFipp,AudMisc;
{$ENDIF}

procedure RunProgram;

{$I+,R+}
implementation
{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if AudCom^.D.PortOpen then
    AudCom^.CloseRS232;
  SelectCursor(On);
  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}
end;

{--------------------------------------------------}
{main}
procedure RunProgram;
const VersionNotice   = 'Audiometer Panel V2.00 04/09/97';
      CopyrightNotice = 'Copyright Frye Electronics 1997';

var IOport,IRQn:word;
    pcnt,Err:integer;
    PStr : str255;

begin
 {$IFDEF WIN16}
    DosCrt.TextAttr := $07;
    DosCrtFont := OEM_FIXED_FONT;
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'Audiometer Panel');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

  NormalText;
  clrscr;

   {$IFDEF WIN32}
     SetConsoleCtrlHandler(nil,false);
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
     '1','2','3','4','5','6','7','8','9' : IOPort := ord(Pstr[1]) and $f;
     'I': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,Irqn,Err);
            if (IrqN > 15) or (Err <> 0) then IrqN := 0;
          end; {case 'I'}
     'C': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,IOport,Err);
            if (IOport > 15) or (Err <> 0) then IOport := 0;
          end; {case 'I'}
    end; {case}
    dec(Pcnt);
  end;
  if IOport = 0 then IOport := 1;

  if not AudCom^.InitRS232(IOport,IRQn) then
  begin
    writeln('** Error **');
    writeln('Unable to establish communications with Audiometer');
    writeln('Fryers probably not installed');
    Halt(1);
  end;

  ComputerControl := false;
  SelectCursor(Off);
  InitScreen;
  ResetAudiometer;

  {$IFNDEF WIN32}
    InitMouse;
  {$ENDIF}
  TransferData;
  InitScreen;
  SetLabel(VersionNotice,25,1);
  SetLabel(CopyrightNotice,25,2);
  UpdateComputer;
  UpdateDisplay;
  {$IFNDEF WIN32}
    ShowMouse;
  {$ENDIF}
  while not(AllDone) do
  begin
    TransferData;
    if ComputerControl then UpdateAudiometer
      else UpdateComputer;
    ManageIO;
    {$IFNDEF WIN32}
      HideMouse;
    {$ENDIF}
    UpdateDisplay;
    {$IFNDEF WIN32}
      ShowMouse;
    {$ENDIF}
    IncCurCnt;
  end;

  AudCom^.CloseRS232;
  SelectCursor(On);
  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}
end;

end.


