
{misc audiometer routines for use with audiometer programs}
{Copyright 1992,1997 Frye Electronics -- writen by Michael Day}
{V2.00 as of 09 April 1997}

unit audsubs;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  uses WinProcs,WinDos,DosCrt;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF ISDOS}
  uses Dos,Ticker;
  type SmallInt = integer;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,SysUtils;
{$ENDIF}

{$I+,R+}

type string2 = string[2];
     string4 = string[4];
     string8 = string[8];
     string9 = string[9];
     string12 = string[12];
     string80 = string[80];
     str255 = string[255];

     LongArray = array[0..65520 div 4] of Longint;
     WordArray = array[0..65520 div 2] of word;
     IntArray = array[0..65520 div 2] of SmallInt;
     Dval=Packed Record  Lw, Hw:word; End;

const Hex : array[0..15] of char = '0123456789ABCDEF';
const KeyData : integer = -1;

function hexB(B:byte):string2;
function hexW(W:word):string4;
function hexL(L:longint):string8;
function hexP(P:pointer):string9;
function fstr(L:longint):string12;
function Argval(var S; var Index:integer):longint;
function KeyWaiting:boolean;
function GetKey:char;
procedure fillword(var D; Ws,V:word);
procedure fillint(var D; Ws,V:integer);
procedure fillLong(var D; Ws:word; V:longint);
procedure outint(i:integer; d:byte);           {print a decimal integer}
function rstr(i:integer; L:byte):str255;       {right justified integer}
function lstr(i:integer; L:byte):str255;        {left justified integer}
function spc(cnt:integer):str255;                    {return cnt spaces}
function Str2D(value:integer):string9;
function Str2Df(value:integer):string12;
procedure ClkWait(Value:word);
function GetTick:longint;
{$IFNDEF WIN32}
  procedure SetLength(var S:str255; L:byte);
{$ENDIF}
{$IFDEF WIN32}
  procedure GetDate(var Year,Month,Day,WeekDay:word);
  procedure GetTime(var Hour,Minute,Second,Sec100:word);
{$ENDIF}

implementation


{----------------------------------------------------}
{convert a byte to hex}
function hexB(B:byte):string2;
begin
  hexB[1] := Hex[B shr 4];
  hexB[2] := Hex[B and 15];
  hexB[0] := #2;
end;

{convert a word to hex}
function hexW(W:word):string4;
Begin
  hexW[1] := Hex[hi(W) shr 4];
  hexW[2] := Hex[hi(W) and 15];
  hexW[3] := Hex[lo(W) shr 4];
  hexW[4] := Hex[lo(W) and 15];
  hexW[0] := #4;
end;

{convert a longint to hex}
function hexL(L:longint):string8;
Begin
  hexL := hexW(Dval(L).Hw)+hexW(Dval(L).Lw);
end;

{hex value of a pointer}
function hexP(P:Pointer):String9;
Begin
  hexP := hexW(Dval(longint(P)).Hw)+':'+hexW(Dval(longint(P)).Lw);
End;


function fstr(L:longint):string12;
var S : string12;
begin
  str(L,S);
  fstr := s;
end;


{--------------------------------------------------}

{$IFDEF WIN16}
  function KeyWaiting:boolean;
  begin
    Keywaiting := KeyPressed;
  end;

  function GetKey:char;
  begin
    GetKey := ReadKey;
  end;
{$ENDIF}

{$IFDEF ISDOS}
  function KeyStat:boolean;
  inline(
   $31/$C0      { xor ax,ax }
  /$FE/$C4      { inc ah    }
  /$CD/$16      { int $16   }
  /$B0/$00      { mov al,0  }
  /$74/$02      { jr z,done }
  /$FE/$C0      { inc al    }
                {done:      }
  );
  function KeyWaiting:boolean;
  begin
    KeyWaiting := KeyStat;
  end;

  function InputKey:char;
  inline(
   $31/$C0      { xor ax,ax  }
  /$CD/$16      { int $16    }
  /$08/$C0      { or al,al   }
  /$75/$06      { jr nz,done }
  /$31/$C0      { xor ax,ax  }
  /$CD/$16      { int $16    }
  /$0C/$80      { or al,$80  }
                {done:       }
  );
  function GetKey:char;
  begin
    GetKey := InputKey;
  end;
{$ENDIF}

{$IFDEF WIN32}
  function KeyWaiting:boolean;
  var InputEvents : DWORD;
  var InputEventsRead : DWORD;
  var KeyBuf : TInputRecord;
  begin
    if KeyData < 0 then
    begin
      GetNumberOfConsoleInputEvents(GetStdHandle(STD_INPUT_HANDLE),InputEvents);
      if InputEvents <> 0 then
      begin
        ReadConsoleInput(GetStdHandle(STD_INPUT_HANDLE),KeyBuf,1,InputEventsRead);
        if (KeyBuf.EventType = KEY_EVENT) and (KeyBuf.KeyEvent.bKeyDown) then
        begin
          KeyData := integer(KeyBuf.KeyEvent.AsciiChar);
        end;
      end;
    end;
    KeyWaiting := KeyData >= 0;
  end;
  function GetKey:char;
  begin
    if KeyData < 0 then
      while not(KeyWaiting) do {nop};
    if KeyData >= 0 then
      GetKey := char(KeyData)
    else GetKey := #255;  
    KeyData := -1;
  end;
{$ENDIF}


{$IFNDEF WIN32}
  procedure SetLength(var S:str255; L:byte);
  begin
    s[0] := char(L);
  end;
{$ENDIF}

{++++++++++++++++++++++++++++++++++++++++++}
procedure outint(i:integer; d:byte);
var stemp:string[8];
begin
  str(i:d,stemp);
  write(stemp);
end;
function rstr(i:integer; L:byte):str255;
var stemp:str255;
begin
  str(i,stemp);
  while length(stemp) < L do
    stemp := ' '+stemp;
  rstr:=stemp;
end;
function lstr(i:integer; L:byte):str255;
var stemp:str255;
begin
  str(i,stemp);
  while length(stemp) < L do
    stemp := stemp+' ';
  lstr:=stemp;
end;

function spc(cnt:integer):str255;
var temp:str255;
    i:integer;
begin
   temp := '';
   for i := 1 to cnt do
     temp := temp+' ';
   spc := temp;
end;

{------------------------------------------------}
function Str2D(value:integer):string9;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value+5) div 100;  {force roundup}
  str(ts,ts1);
  if ((value+5) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value+5) mod 100) div 10;
  str(ts,ts2);
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str2D := ts3+ts1+'.'+ts2;
end;

{------------------------------------------------}
function Str2Df(value:integer):string12;
var ts1,ts2,ts3 : string9;
    i,ts : integer;
begin
  ts3 := '';
  ts := (value+5) div 100;
  str(ts,ts1);
  if ((value+5) < 0) and (ts = 0) then ts1 := '-0';
  ts := abs((value+5) mod 100);  {force roundup}
  str(ts,ts2);
  if length(ts2) < 2 then ts2 := ts2+'0';
  if length(ts1) < 4 then
    for i := 1 to 4 - length(ts1) do
      ts3 := ts3+' ';
  Str2Df := ts3+ts1+'.'+ts2;
end;


{+++++++++++++++++++++++++++++++++}
{misc fill routines}

procedure fillword(var D; Ws,V:word);
var Da : wordarray absolute D;
var i : integer;
begin
  for i := 0 to pred(Ws) do
    Da[i] := V;
end;

procedure fillint(var D; Ws,V:integer);
var Da : IntArray absolute D;
var i : integer;
begin
  for i := 0 to pred(Ws) do
    Da[i] := V;
end;

procedure fillLong(var D; Ws:word; V:longint);
var Da : LongArray absolute D;
var i : integer;
begin
  for i := 0 to pred(Ws) do
    Da[i] := V;
end;


  {CONV ASCII # TO BINARY - my own version}
  function Argval(var S; var Index:integer):longint;
  type ByteArray = array[0..255] of byte;
  var Data : ByteArray absolute S;
  var Done : boolean;
  var Value : integer;
  var Work : longint;
  begin
    Done := false;
    Work := 0;
    Index := 0;
    if Data[0] = ord('-') then
      inc(Index);
    while not(Done) do
    begin
      Value := Data[Index]-ord('0');
      if (Value < 0) or (Value > 10) then      
        done := true
      else
      begin
        Work := (Work*10)+Value;
        inc(Index);
      end;
    end;
    if Data[0] = ord('-') then
      Work := -(Work);
    ArgVal := Work;
  end;

(*
{Warning: this is an assembler macro do not interface it}
function InArgval(var S):longint;
Inline(         {;CONV ASCII # TO BINARY}
  $5F           {  POP DI}
  /$07          {  POP ES     ;GET ADDRESS OF BUFFER}
  /$31/$DB      {  XOR BX,BX}
  /$31/$D2      {  XOR DX,DX  ;INIT REGISTERS}
  /$31/$C0      {  XOR AX,AX}
  /$26          {  ES:}
  /$8A/$09      {  MOV CL,[DI+BX]  ;READ CHARACTER}
  /$80/$F9/$2D  {  CMP CL,'-'  ;SEE IF NEG NUMBER}
  /$75/$01      {  JNZ AR810   ;IF SO, DO AS NEGATIVE}
  /$43          {  INC BX}
                {AR810:}
  /$26          {  ES:}
  /$8A/$01      {  MOV AL,[DI+BX]  ;READ CHARACTER}
  /$2C/$30      {  SUB AL,'0'  ;CONVERT TO BINARY}
  /$3C/$0A      {  CMP AL,10   ;SEE IF VALID ASCII #}
  /$73/$10      {  JNC AR820   ;IF NOT WE ARE DONE}
  /$89/$D6      {  MOV SI,DX}
  /$01/$D2      {  ADD DX,DX}
  /$01/$D2      {  ADD DX,DX   ;MULT X10}
  /$01/$F2      {  ADD DX,SI}
  /$01/$D2      {  ADD DX,DX}
  /$01/$C2      {  ADD DX,AX   ;ADD NEW VALUE}
  /$43          {  INC BX}
  /$E9/$E7/$FF  {  JMP NEAR AR810 ;LOOP TIL DONE}
                {AR820:}
  /$80/$F9/$2D  {  CMP CL,'-'  ;IF WAS NEGATIVE NUMBER}
  /$75/$02      {  JNZ AR830   ;MAKE IT SO}
  /$F7/$DA      {  NEG DX}
                {AR830:}
  /$89/$D0      {  MOV AX,DX  ;RET DATA IN AX}
  /$89/$DA      {  MOV DX,BX  ;RET INDEX IN DX }
  );            {;USAGE =  VAR NUM,CNT : WORD;}
                {;              TMP : LONGINT;}
                {;          BEGIN}
                {;            TMP := ARGVAL(ARRAY);  {CONVERT TO BIN}
                {;            CNT := SEG(TMP^);      {# CHARS READ}
                {;            NUM := OFS(TMP^);      {CONVERTED NUMBER}
                {;            IF CNT = 0 THEN ERROR; {IF CNT=0 NO NUMBER}
                {;          END;}


function ArgVal(var S; var C:word):word;
type Trec = record lo,hi:word; end;
var  Tmp : longint;
begin
  Tmp := InArgVal(S);
  ArgVal := trec(Tmp).lo;
  C := trec(Tmp).hi;
end;
*)


{++++++++++++++++++++++++++++++++++++++++++}
{misc time routines}

{get number ms that have passed}
function GetTick:longint;
{$IFDEF MSDOS}
  var SysClock : longint absolute $40:$6c;
  begin
    GetTick := SysClock*55;
  end;
{$ENDIF}
{$IFDEF PMDOS}
  var SysClock : longint absolute $40:$6c;
  begin
    GetTick := SysClock*55;
  end;
{$ENDIF}
{$IFDEF WIN16}
  begin
    GetTick := GetTickCount;
  end;
{$ENDIF}
{$IFDEF WIN32}
  begin
    GetTick := GetTickCount;
  end;
{$ENDIF}


{-------------------------------------------------}
{waits for the number of 55ms ticks given in Value}
procedure ClkWait(Value:word);
var Start : longint;
begin
  Start := GetTick;
  while GetTick-Start < Value*55 do
  begin
    if KeyWaiting then Exit;
  end;
end;


{-------------------------------------------------}
{code used to emulate old dos calls}
{$IFDEF WIN32}
  procedure GetTime(var Hour,Minute,Second,Sec100:word);
  var Present : TDateTime;
  begin
    Present := Now;
    DecodeTime(Present,Hour,Minute,Second,Sec100);
  end;

  procedure GetDate(var Year,Month,Day,WeekDay:word);
  var Present : TDateTime;
  begin
    Present := Now;
    DecodeDate(Present,year,Month,Day);
    WeekDay := DayofWeek(Present);
  end;
{$ENDIF}


{------}
end.


