
{program to print the current calibration table values in the audiometer}
{10 November 1992 written by Michael Day}
{Copyright 1992 Frye Electronics}

unit CPunit;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  {$R AUD.RES}
  uses DosCrt,WinDos,strings,audsubs,AudFipp;
{$ENDIF}
{$IFDEF ISDOS}
  uses dos,audsubs,AudFipp;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,audsubs,AudFipp;
{$ENDIF}

procedure RunProgram;

{$I+,R+}
implementation
{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if AudCom^.D.PortOpen then
    AudCom^.CloseRS232;
  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}  
end;


var comp:word;

  procedure ResetAudiometer;
  begin
    AudCom^.Cmd(DoReset);
    AudCom^.Cmd(GetCmdStatus);
    if AudCom^.Fail then
    begin
      writeln('Ack! can''t find Audiometer (reset) ',AudCom^.FailMsg,' ',AudCom^.D.Rserr);
      halt(1);
    end;
  end;

  procedure GetAudVersion;
  begin
    AudCom^.Cmd(GetVersion);
    if AudCom^.Fail then
    begin
      writeln('Ack! can''t find Audiometer ',AudCom^.FailMsg);
      halt(1);
    end;
  end;

  procedure ReadCalTable;
  begin
     AudCom^.Cmd(GetCalData);
     if AudCom^.Fail then
     begin
       writeln('Ack!!! Communication Failure!  ',AudCom^.FailMsg);
       halt(2);
     end;
  end;

  procedure ShowHeader;
  var Year,Month,Day,Dayofweek,Hour,Minute,Second,Hundred:word;
  begin
    GetDate(Year,Month,Day,DayofWeek);
    GetTime(Hour,Minute,Second,Hundred);
    writeln('Calibration table values for Audiometer Model FA-',
      AudCom^.D.VerRec.Model-90,'   ',Month,'/',Day,'/',Year,'  ',Hour,':',Minute);
    writeln('Software Version:',AudCom^.D.VerRec.Version/100:3:2,
      '   Options:',HexL(AudCom^.D.VerRec.Option));
    writeln;
  end;


  procedure ShowCalTable;

    procedure ShowCRC;
    begin
      write(0:3,':(',AudCom^.D.CalRec[0]+(AudCom^.D.CalRec[1] shl 8):5,')');
    end;

    procedure ShowValue(N:word);
    begin
      write(N:3,':(',AudCom^.D.CalRec[N]:3,') ',
            AudCom^.D.CalRec[N]*0.5:5:1,'dB');
    end;

    procedure ShowLine(L,R,B,C,N:word);
    begin
      If L > 0 then
        ShowValue(L+N);
      if R > 0 then
      begin
        write('|');
        ShowValue(R+N);
      end;
      if B > 0 then
      begin
        write('||');
        if (N > 10) and (C = 0) then
          write('                 ')
        else
          ShowValue(B+N);
      end;
      if C > 0 then
      begin
        write('|');
        ShowValue(C+N);
      end;
      write('|');
    end;

    procedure ShowFreq(L,R,B,C:word);
    begin
      write('Freq |Pos Value  Offset');
        if R > 0 then
          write('|Pos Value  Offset');
        if B > 0 then
          write('||Pos Value  Offset');
        if C > 0 then
          write('|Pos Value  Offset');
      write('|');
      writeln;
      write('  125|'); ShowLine(L,R,B,C,0); writeln;
      write('  250|'); ShowLine(L,R,B,C,1); writeln;
      write('  500|'); ShowLine(L,R,B,C,2); writeln;
      write('  750|'); ShowLine(L,R,B,C,3); writeln;
      write(' 1000|'); ShowLine(L,R,B,C,4); writeln;
      write(' 1500|'); ShowLine(L,R,B,C,5); writeln;
      write(' 2000|'); ShowLine(L,R,B,C,6); writeln;
      write(' 3000|'); ShowLine(L,R,B,C,7); writeln;
      write(' 4000|'); ShowLine(L,R,B,C,8); writeln;
      write(' 6000|'); ShowLine(L,R,B,C,9); writeln;
      write(' 8000|'); ShowLine(L,R,B,C,10); writeln;
      write('12000|'); ShowLine(L,R,B,C,11); writeln;
      write('16000|'); ShowLine(L,R,B,C,12); writeln;
    end;

    procedure ShowOther(N1,N2:word);
    begin
      write('Dest |Pos Value  Offset|Pos Value  Offset|');
        if N2 > 0 then
          write('|Pos Value  Offset|Pos Value  Offset|');
      writeln;
      write('EarA |'); ShowValue(N1); write('|'); ShowValue(N1+1); write('|');
      if N2 > 0 then
        begin write('|'); ShowValue(N2); write('|'); ShowValue(N2+1); write('|'); end;
      writeln;
      write('EarB |'); ShowValue(N1+2); write('|'); ShowValue(N1+3); write('|');
      if N2 > 0 then
        begin write('|'); ShowValue(N2+2); write('|'); ShowValue(N2+3); write('|'); end;
      writeln;
      write('Spkr |'); ShowValue(N1+4); write('|'); ShowValue(N1+5); write('|');
      if N2 > 0 then
        begin write('|'); ShowValue(N2+4); write('|'); ShowValue(N2+5); write('|'); end;
      writeln;
      write('Bone |'); ShowValue(N1+6); write('|                 |');
      if N2 > 0 then
        begin  write('|'); ShowValue(N2+6); write('|                 |'); end;
      writeln;
    end;


  begin
    writeln('===============================================================================');
    writeln('     | Tone Left Ear A |Tone Right Ear A || Tone Left Ear B |Tone Right Ear B |');
    ShowFreq(2,15,28,41);
    writeln('-------------------------------------------------------------------------------');
    writeln('     | Tone Left Spkr  | Tone Right Spkr ||    Tone Bone    |');
    ShowFreq(54,67,80,0);
    writeln('===============================================================================');
    writeln('     |       Left      |     Right       ||      Left       |      Right      |');
    writeln('-------------------------------------------------------------------------------');
    writeln('     |       NBN       |      NBN        || White Tone Mask | White Tone Mask |');
    ShowOther(93,100);
    writeln('-------------------------------------------------------------------------------');
    writeln('     | White Spch Mask | White Spch Mask ||  Speech Noise   |  Speech Noise   |');
    ShowOther(107,114);
    writeln('-------------------------------------------------------------------------------');
    writeln('     |    Ext/Mic      |     Ext/Mic     |');
    ShowOther(121,0);

    writeln('============================================================================');
    writeln('      |Pos Value  Offset ||       |Pos Value  Offset ||       |Pos  Value  |');
      write('Spare1|'); ShowValue(91); write(' || ');
      write('Spare2|'); ShowValue(92); write(' || ');
      write('   CRC|'); ShowCrc; write(' |');
    writeln;
    writeln('----------------------------------------------------------------------------');

  end;


{-----------------------------------------------------------}
{main}
procedure RunProgram;
var IOport,IRQn:word;
    pcnt,Err:integer;
    Pstr : str255;

begin
 {$IFDEF WIN16}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 200 {800} {439};
    StrCopy(WindowTitle,'CALPRN');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

   {$IFDEF WIN32}
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

  ExitSave := ExitProc;
  ExitProc := @PrgExit;

  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
     '1','2','3','4','5','6','7','8','9' : IOPort := ord(Pstr[1]) and $f;
     'I': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,Irqn,Err);
            if (IrqN > 15) or (Err <> 0) then IrqN := 0;
          end; {case 'I'}
     'C': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,IOport,Err);
            if (IOport > 15) or (Err <> 0) then IOport := 0;
          end; {case 'I'}
    end; {case}
    dec(Pcnt);
  end;
  if IOport = 0 then IOport := 1;

  writeln('Calibration table print program. ');
  writeln('Copyright 1992 Frye Electronics, Inc.');
  writeln('Version 2.00  as of 09 April 1997  ');
  write('Using COM',IOport,' to communicate to audiometer ');

  if not AudCom^.InitRS232(IOport,IRQn) then
  begin
    writeln;
    writeln('** Error **');
    writeln('Unable to establish communications with Audiometer');
    writeln('Fryers probably not installed');
    Halt(1);
  end;

  {$IFNDEF WIN32}
    writeln('on IRQ',AudCom^.D.IRQnum[AudCom^.D.comport]);
  {$ELSE}
    writeln;
  {$ENDIF}
  writeln;
  ResetAudiometer;
  GetAudVersion;

  assign(output,'LPT1');
  rewrite(output);

  ShowHeader;
  ReadCalTable;
  ShowCalTable;
  writeln(#$C);

  close(output);
  AudCom^.CloseRS232;
  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}
end;

end.





