
{IO routines used for terminal emulation}
{10 April 1997 written by Michael Day }
{Copyright 1992,1997 Frye Electronics}

{Warning: don't mix AudFIPP and TermSub unit usage in same program - they don't mix}

unit TermSub;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  uses DosCrt,WinDos,audsubs;
  type F_RegsType = tRegisters;
{$ENDIF}
{$IFDEF ISDOS}
  uses crt,dos,audsubs,Ticker;
  type F_RegsType = Registers;
{$ENDIF}
{$IFDEF WIN32}
  uses audsubs,Windows;
  {$I FRYEREGS.INC}
{$ENDIF}

{$I-,R-}

const cport : word = 0;
      IRQn : byte = 0;
      IOport : byte = 1;
      baudrate : longint = 9600;
      portbase : word = $3f8;
      FryersOK : boolean = true; {true = use Fryers driver}
      PortOpen : boolean = false;

const On = true;
      Off = false;

var Regs : F_RegsType;

function InitPort(UseInt:boolean):byte;  {init communications port}
procedure Packet(SetOn:boolean);
procedure ClosePort;        {turn off the lights please}

function GetStat:boolean;
function GetChar:char;
function PutStat:boolean;
procedure PutChar(What:byte);

{$IFDEF WIN32}
  function LoadFryers:boolean;

  {we use the dynamic dll load method so that we can catch the Error}
  const LibHandle : integer = 0;
  var CallFryers : procedure(var FIregs:F_RegsType); stdcall;
{$ELSE}
  procedure CallFryers(var FRegs:F_RegsType);
{$ENDIF}

{----------------------------------------------------------}
implementation

{$IFDEF WIN32}
  {this defines the call to the FRYERS32.DLL for static dll load }
  {however, we will use dynamic loading so as to catch the error}
//  procedure CallFryers(var FRegs:F_RegsType); stdcall external 'Fryers32.DLL';

    {this call is used for non-dll testing of the fryers dll}
//    procedure CallFryers(var FRegs:F_RegsType);
//    begin
//      ServiceFryers(FryerDef.F_RegsType(FRegs));
//    end;
{$ELSE}
  procedure CallFryers(var FRegs:F_RegsType);
  begin
    INTR($14,FRegs);
  end;
{$ENDIF}


{$IFDEF WIN32}
  {try to load fryers32.dll}
  {returns false if cannot find Fryers}
  {this is only used in 32 bit mode}
  function LoadFryers:boolean;
  begin
    LoadFryers := true;
    if LibHandle > 0 then Exit;
    LoadFryers := false;
    LibHandle := LoadLibrary('fryers32.dll');
    if LibHandle < 32 then
    begin
      {showmessage('Unable to load fryers32.dll');}
      Exit;
    end;
    @CallFryers := GetProcAddress(LibHandle,'CallFryers');
    if @CallFryers = nil then
    begin
     { showmessage('Failed to lookup CallFryers');}
      Exit;
    end;
    LoadFryers := true;
  end;
{$ENDIF}


  function FryersExists:boolean;
  begin
    Regs.ax := $ffff;  {check if Fryers driver is out there}
    Regs.dx := 0;
    CallFryers(Regs);
    FryersExists := Regs.DX = $ffff;
  end;


{declare the various variables used in the program}
var Perr : word;
    OldUart : array[0..15] of byte;

function GetStat:boolean;
begin
  {$IFDEF WIN32}
    GetStat := false;
    if not(FryersOK) then Exit;
    if KeyWaiting then Exit;
    Regs.ah := $03;
    Regs.dx := cport;
    CallFryers(Regs);
    GetStat := Regs.AH and 1 <> 0;
  {$ELSE}
    asm
      mov al,[FryersOK]  {if fryers driver available, use it}
      or al,al
      jnz @Istat
      mov dx,[portbase]  {otherwise use polled IO}
      add dx,5
      in al,dx
      and al,1
      jmp @StatDone
     @Istat:
      mov ah,03
      mov dx,[cport]
      and dx,1
      int $14
      xchg al,ah
      and al,1
     @StatDone:
      mov @Result,al
    end;
  {$ENDIF}
end;

function GetChar:char;
begin
  {$IFDEF WIN32}
    GetChar := #255;
    if not(FryersOK) then Exit;
    if KeyWaiting then Exit;
    Regs.ah := $02;
    Regs.dx := cport;
    CallFryers(Regs);
    GetChar := char(Regs.AL);
  {$ELSE}
    asm
      mov al,[FryersOK]  {if fryers driver available, use it}
      or al,al
      jnz @IcGet
      mov dx,[portbase]  {otherwise use polled IO}
      in al,dx
      jmp @IcGetDone
     @IcGet:
      mov ah,02
      mov dx,[cport]
      and dx,1
      int $14
     @IcGetDone:
      mov @Result,al
    end;
  {$ENDIF}
end;

{returns NZ if ready for a char}
function PutStat:boolean;
begin
  {$IFDEF WIN32}
    PutStat := false;
    if not(FryersOK) then Exit;
    Regs.ah := $03;
    Regs.dx := cport;
    CallFryers(Regs);
    PutStat := Regs.AH and $20 <> 0;
  {$ELSE}
  asm
    mov al,[FryersOK]  {if fryers driver available, use it}
    or al,al
    jnz @Pstat
    mov dx,[portbase]  {otherwise use polled IO}
    add dx,5
    in al,dx
    and al,$20
    jmp @PStatDone
   @Pstat:
    mov ah,03
    mov dx,[cport]
    and dx,1
    int $14
    xchg al,ah
    and al,$20
   @PStatDone:
    or al,al
    jz @PstatExit
    mov al,1
   @PstatExit:
    mov @Result,al
  end;
  {$ENDIF}
end;

procedure PutChar(What:byte);
begin
  {$IFDEF WIN32}
    if not(FryersOK) then Exit;
    Regs.ah := $01;
    Regs.AL := What;
    Regs.dx := cport;
    CallFryers(Regs);
  {$ELSE}
  asm
    mov al,[FryersOK]  {if fryers driver available, use it}
    or al,al
    jnz @PcGet
    mov dx,[portbase]  {otherwise use polled IO}
    mov al,[what]
    out dx,al
    jmp @PcGetDone
   @PcGet:
    mov ah,01
    mov al,[what]
    mov dx,[cport]
    and dx,1
    int $14
   @PcGetDone:
  end;
  {$ENDIF}
end;


{returns 0 if all ok, 1 if fryers not found, 2 if port failure}
function InitPort(UseInt:boolean):byte;
var rax : byte;
begin
  if IOport < 1 then IOport := 1;
  {$IFDEF WIN32}
    if IOport > 15 then IOport := 1;
    cport := pred(IOport);
  {$ELSE}
    if IOport > 4 then IOport := 1;
    cport := pred(IOport) and 1;
  {$ENDIF}

  PortOpen := false;
  InitPort := 0;
  case cport of
    0: Portbase := $3f8;
    1: Portbase := $2f8;
    2: Portbase := $3e8;
    3: Portbase := $2e8;
    else Portbase := $3f8;
  end;

{$IFNDEF WIN32}
  {init uart for talking to the remote system - 9600 baud 8data, 1stop, no parity}
  ASM CLI; END;
    OldUart[3] := Port[PortBase+3]; {save old info}
    Port[PortBase+3] := $80;
    OldUart[8] := Port[PortBase];
    OldUart[9] := Port[PortBase+1];
    Port[PortBase+0] := 12;    {set uart to 9600 baud}
    Port[PortBase+1] := 0;
    Port[PortBase+3] := $03;
    OldUart[0] := Port[PortBase];
    OldUart[1] := Port[PortBase+1];
    Port[PortBase+1] := 0;          {disable uart interrupts}
    OldUart[4] := Port[PortBase+4];
    Port[PortBase+4] := $0B;   {8 bits no parity}
    OldUart[5] := Port[PortBase+5];
    OldUart[6] := Port[PortBase+6];
  ASM STI; END;
{$ENDIF}

  if FryersExists then
  begin
    Regs.ax := $ff00;  {make sure interrupt based input is off}
    Regs.dx := Cport;
    Regs.ch := $ff;
    Regs.cl := 0;
    CallFryers(Regs);
  end
  else
  begin
    InitPort := 1; {failed}
    Exit;
  end;

  {$IFNDEF WIN32}
    Regs.ax := $ff0a;     {select the desired port to use}
    Regs.ch := $ff;
    Regs.cl := IRQn;  {use the selected IRQ number}
    Regs.bx := (IOport shr 1) and 1; {select the uart to use}
    Regs.dx := cport;  {init the port}
    CallFryers(Regs);
    if Regs.AH = $ff then
    begin
      InitPort := 2; {failed}
      Exit;
    end;
  {$ENDIF}

    if UseInt then  {if don't use interrupt, don't turn it on}
    begin
      Regs.ax :=$ff00;
      Regs.dx := Cport;  {if Fryers was found,}
      Regs.ch := $ff;     {make sure interrupt based input is on}
      Regs.cl := $ff;
      CallFryers(Regs);
    end;

    Regs.ax := $ff08;  {disable CTS/RTS flow control}
    Regs.cx := $ff00;
    Regs.dx := Cport;
    CallFryers(Regs);

    Regs.ax := $ff05;  {make sure dtr is on}
    Regs.cx := $ffff;
    Regs.dx := Cport;
    CallFryers(Regs);

    Regs.ax := $ff04;  {make sure rts is on}
    Regs.cx := $ffff;
    Regs.dx := Cport;
    CallFryers(Regs);

    rax := $00e3;         {default to 9600 if bad value given}
    case baudrate div 10 of
         0 : rax := $00f3; {select autobaud starting at 9600}
       120 : rax := $0083;
       240 : rax := $00a3;
       480 : rax := $00c3;
       960 : rax := $00e3;
      1920 : rax := $0003;
      2880 : rax := $0023;
      3840 : rax := $0043;
      5600 : rax := $0063; {56k is a special case 600 (autobaud only)}
    end;
    Regs.ax := rax;    {init to 9600 baud, no parity, one stop}
    Regs.dx := Cport;
    CallFryers(Regs);

  InitPort := 0;
  PortOpen := true;
end;

procedure Packet(SetOn:boolean);
begin
    Regs.ax := $ff10;
    Regs.dx := Cport;
    Regs.ch := $ff;
    Regs.cl := $00;     {default packet based op as off}
    if not(SetOn) then
      Regs.cl := $00 {if don't use packets, don't turn it on}
    else Regs.cl := $ff;  {else make sure packet based op is on}
    CallFryers(Regs);
end;

procedure ClosePort;
begin
    Regs.ax := $ff00;  {make sure interrupt based input is off}
    Regs.dx := Cport;
    Regs.ch := $ff;
    Regs.cl := 0;
    CallFryers(Regs);

{$IFNDEF WIN32}
  ASM; CLI; END;
    Port[PortBase+3] := $80;
    Port[PortBase] := OldUart[8];  {restore old baudrate}
    Port[PortBase+1] := OldUart[9];
    Port[PortBase+3] := $03;
    Port[PortBase+1] := OldUart[1];  {and the rest of the stuff}
    Port[PortBase+4] := OldUart[4];
    Port[PortBase+3] := OldUart[3];
  ASM STI; END;
{$ENDIF}

end;


{--------}
begin
  fillchar(OldUart,sizeof(OldUart),0);
end.
