{misc video routines}
{09 Apr 1997  written by Michael Day}
{Copyright 1992,1997 Frye Electronics}


Unit VidSubs;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  uses DosCrt, WinProcs;
{$ENDIF}
{$IFDEF ISDOS}
  uses crt;
{$ENDIF}
{$IFDEF WIN32}
  uses Windows,SysUtils;
{$ENDIF}

{$IFNDEF PMODE}
   const Seg0040 = $0040;  SegA000 = $A000;
         SegB000 = $B000;  SegB800 = $B800;
{$ENDIF}

{$IFDEF ISDOS}
  const LineDrawFonts : boolean = true;
{$ENDIF}
{$IFDEF WIN32}
  const LineDrawFonts : boolean = true;
  const TextAttr : byte = $07;
  const MouseClickX : integer = 1;
  const MouseClickY : integer = 1;
  const MouseClicked : boolean = false;
  procedure ReadMouse;
  function MouseClick:boolean;
  procedure SelectCursor(CurOn:boolean);
  procedure clrscr;
  procedure gotoxy(X,Y:integer);
  procedure GetTime(var Hour,Minute,Second,Sec100:word);
  procedure GetDate(var Year,Month,Day,WeekDay:word);
  function WhereX:integer;
  function WhereY:integer;
{$ENDIF}

function GetKey:char;
function KeyWaiting:boolean;

const mono = 7;
      On = true;
      Off = false;
      CursorCount : byte = 0;
      OldCur : word = 0;

var CrtMode : byte;

procedure InverseText;
procedure NormalText;
procedure BrightText;
procedure CursorText;
procedure IncCurCnt;
{$IFDEF ISDOS}
  procedure SelectCursor(CurOn:boolean);
{$ENDIF}

implementation

{+++++++++++++++++++++++++++++++++}
procedure InverseText;
begin
  if CrtMode = mono then
    TextAttr := $10
  else
    TextAttr := $70;
  {$IFDEF WIN32}
    SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TextAttr);
  {$ENDIF}
end;

procedure NormalText;
begin
  if CrtMode = mono then
    TextAttr := $01
  else
    TextAttr := $07;
  {$IFDEF WIN32}
    SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TextAttr);
  {$ENDIF}
end;

procedure BrightText;
begin
  TextAttr := TextAttr+$08;
  {$IFDEF WIN32}
    SetConsoleTextAttribute(GetStdHandle(STD_OUTPUT_HANDLE),TextAttr);
  {$ENDIF}
end;

procedure CursorText;
begin
   if CursorCount = 0 then
     InverseText
   else
     Normaltext;
end;

procedure IncCurCnt;
begin
   inc(CursorCount);
   if CursorCount > 1 then
     CursorCount := 0;
end;

{$IFDEF ISDOS}
  procedure SelectCursor(CurOn:boolean);
  begin
    if CurOn then
    begin
      asm
        mov cx,[OldCur]
        mov ah,$01
        int $10
      end;
    end
    else
    begin
      asm
        mov ah,$03
        mov bx,0
        int $10
        mov [OldCur],cx

        mov ah,$01
        mov cx,$2000
        int $10
      end;
    end;
  end;
{$ENDIF}

{------------------------------------------------------------------}
{code used to emulate old dos calls}
{$IFDEF WIN32}
  procedure GetTime(var Hour,Minute,Second,Sec100:word);
  var Present : TDateTime;
  begin
    Present := Now;
    DecodeTime(Present,Hour,Minute,Second,Sec100);
  end;

  procedure GetDate(var Year,Month,Day,WeekDay:word);
  var Present : TDateTime;
  begin
    Present := Now;
    DecodeDate(Present,year,Month,Day);
    WeekDay := DayofWeek(Present);
  end;
{$ENDIF}


{$IFDEF WIN32}
  var KeyData : integer = -1;
  function KeyWaiting:boolean;
  var InputEvents : DWORD;
  var InputEventsRead : DWORD;
  var KeyBuf : TInputRecord;
  begin
    if KeyData < 0 then
    begin
      GetNumberOfConsoleInputEvents(GetStdHandle(STD_INPUT_HANDLE),InputEvents);
      if InputEvents <> 0 then
      begin
        ReadConsoleInput(GetStdHandle(STD_INPUT_HANDLE),KeyBuf,1,InputEventsRead);
        if (KeyBuf.EventType = KEY_EVENT) and (KeyBuf.KeyEvent.bKeyDown) then
        begin
          KeyData := KeyBuf.KeyEvent.wVirtualKeyCode; {AsciiChar);}
        end;
        if (KeyBuf.EventType = _MOUSE_EVENT) and
           ((KeyBuf.MouseEvent.dwButtonState = FROM_LEFT_1ST_BUTTON_PRESSED) or
            (KeyBuf.MouseEvent.dwButtonState = RIGHTMOST_BUTTON_PRESSED)) then
        begin
          MouseClickX := integer(KeyBuf.MouseEvent.dwMousePosition.X)+1;
          MouseClickY := integer(KeyBuf.MouseEvent.dwMousePosition.Y)+1;
          MouseClicked := true;
        end;
      end;
    end;
    KeyWaiting := KeyData >= 0;
  end;
  function GetKey:char;
  begin
    if KeyData < 0 then
      while not(KeyWaiting) do {nop};
    if KeyData >= 0 then
      GetKey := char(KeyData)
    else GetKey := #255;
    KeyData := -1;
  end;
  procedure ReadMouse;
  begin
    {nop}
  end;
  function MouseClick:boolean;
  begin
    MouseClick := MouseClicked;
    MouseClicked := false;
  end;
{$ELSE}
  function KeyWaiting:boolean;
  begin
    Keywaiting := KeyPressed;
  end;
  function GetKey:char;
  begin
    GetKey := ReadKey;
  end;
{$ENDIF}

{$IFDEF WIN32}
  procedure gotoxy(X,Y:integer);
  var Cord:tCoord;
  begin
    if X > 0 then
      Cord.X := pred(X)
    else Cord.X := 0;
    if Y > 0 then
      Cord.Y := pred(Y)
    else Cord.Y := 0;  
    SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE),Cord);
  end;

  procedure clrscr;
  var Cord : tCoord;
      CharactersWritten : integer;
      Info : tConsoleScreenBufferInfo;
      Size : integer;
  begin
    Cord.X := 0;
    Cord.Y := 0;
    NormalText;
    GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),Info);
    Size := succ(Info.dwSize.X)*succ(Info.dwSize.Y);
    FillConsoleOutputCharacter(GetStdHandle(STD_OUTPUT_HANDLE),
                               ' ',Size,Cord,CharactersWritten);
  end;
{$ENDIF}

{$IFDEF WIN32}
  procedure SelectCursor(CurOn:boolean);
  var Info:tConsoleCursorInfo;
  begin
    GetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE),Info);
    if CurOn then
      Info.bVisible := true
    else
      Info.bVisible := false;
    SetConsoleCursorInfo(GetStdHandle(STD_OUTPUT_HANDLE),Info);
  end;
{$ENDIF}

{$IFDEF WIN32}
  function WhereX:integer;
  var Info : tConsoleScreenBufferInfo;
  begin
    GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),Info);
    WhereX := Info.dwCursorPosition.X+1;
  end;

  function WhereY:integer;
  var Info : tConsoleScreenBufferInfo;
  begin
    GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),Info);
    WhereY := Info.dwCursorPosition.Y+1;
  end;
{$ENDIF}



{-----------------------------}
begin
  {$IFDEF WIN16}
     CrtMode := 3;
  {$ENDIF}
  {$IFDEF ISDOS}
     CrtMode := mem[Seg0040:$49];
  {$ENDIF}
end.
