
{This program shows the current state of the front panel switches}
{it uses the fipp packets to read the state of the audiometer}
{The program shows example programming for MSDOS real mode, }
{MSDOS protected mode, and Windows programming using Borland Pascal}
{and Delphi 2.0. In most cases very little changing needs to be done }
{to switch between the various methods.}

{In most cases the programs are backward compatible to Turbo Pascal V6.0}
{and will compile without changes. Since BASM functions were used in some}
{of the units, the code will not compile on versions of Turbo Pascal}
{prior to TP6.0.  However, if you have a need to compile in the earlier}
{TP5.x versions of Turbo Pascal, you could change the ASM code to be}
{implemented as register based calls to the interrupts since the interrupt}
{calls are the only thing that really is important to the code.}

{Note that DOSCRT is derived from Borland's WINCRT unit.}
{DOSCRT allows the program to have greater control over the unit. }
{I called it DOSCRT to keep it seperately identified from WINCRT}
{so that the two would not get confused. DOSCRT is only needed for Win3.1}

{10 April 1997 written by Michael Day}
{Copyright 1992,1997 Frye Electronics}


unit AkeyUnit;
interface
{$I PLATFORM.INC}

{$IFDEF WIN16}
  {$R AUD.RES}
  USES Windos,DosCrt,Strings,AudFipp,AudParms,Audsubs,VidSubs;
{$ENDIF}
{$IFDEF ISDOS}
  USES dos,crt,AudFipp,AudParms,Audsubs,VidSubs;
{$ENDIF}
{$IFDEF WIN32}
  USES Windows,AudFipp,AudParms,Audsubs,VidSubs;
{$ENDIF}

procedure RunProgram;

{$I+,R+}
implementation

{-----------------------------------------------}
{Program exit procedure to restore things back like they should be}

var ExitSave:pointer;
{$F+} procedure PrgExit;
begin
  ExitProc := ExitSave;
  if AudCom^.D.PortOpen then
    AudCom^.CloseRS232;
  SelectCursor(On);
  {$IFDEF WIN16}
    DoneDosCrtWindow;
  {$ENDIF}
end;

var
    OldCur : word;
    Ch : char;
    SpinCnt : word;
    IOport,IRQn:word;
    Pcnt,Err:integer;
    Pstr:str255;

procedure Spin;
begin
   gotoxy(39,12);
   case SpinCnt of
    0: write('|');
    1: write('/');
    2: write('-');
    3: write('\');
   end;
   SpinCnt := Succ(SpinCnt) and $3;
end;


{-----------------------------------------------------}
{main}
procedure RunProgram;
begin
   InitAudCom;

 {$IFDEF WIN16}
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'AUDKEY');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

   NormalText;
   clrscr;
   
   {$IFDEF WIN32}
     SetConsoleCtrlHandler(nil,false);
     if not(LoadFryers) then
     begin
       writeln;
       writeln('Error: FRYERS32.DLL not loaded, or bad version.');
       Halt(1);
     end;
   {$ENDIF}

  ExitSave := ExitProc;
  ExitProc := @PrgExit;


  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
     '1','2','3','4','5','6','7','8','9' : IOPort := ord(Pstr[1]) and $f;
     'I': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,Irqn,Err);
            if (IrqN > 15) or (Err <> 0) then IrqN := 0;
          end; {case 'I'}
     'C': begin
            while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
              delete(Pstr,1,1);
            while ((Pstr[length(Pstr)] < '0') or
                  (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
              SetLength(Pstr,length(Pstr)-1);
            val(Pstr,IOport,Err);
            if (IOport > 15) or (Err <> 0) then IOport := 0;
          end; {case 'I'}
    end; {case}
    dec(Pcnt);
  end;
  if IOport = 0 then IOport := 1;
  
   gotoxy(40,1);
   write('| Audiometer Keyboard Test Program');
   gotoxy(40,2);
   write('| Version 2.00 - 10 April 1997');
   gotoxy(40,3);
   write('| Copyright 1997 Frye Electronics');
   gotoxy(40,4);
   write('---------------------------------------');

   if not(AudCom^.InitRS232(IOport,IRQn)) then
   begin
     gotoxy(1,24);
     write('Could not open com port',IOport);
     {$IFNDEF WIN32}
       write(' IRQ',AudCom^.D.IRQnum[IOport]);
     {$ENDIF}
     writeln;
     if getkey = #0 then {nop};
     halt(1);
   end;
   SelectCursor(Off);
   NormalText;

   Ch := #255;

   repeat
     AudCom^.Cmd(GetPLcount);
     gotoxy(42,6);
     if AudCom^.Fail then
        write('PLR read error ',AudCom^.FailMsg)
     else
        write('                                     ');

     if AudCom^.D.PLcount <> 0 then
     begin
       if (Ch <> 'S') and (Ch <> 's') then
       begin
         AudCom^.Cmd(GetPrlImg);
         gotoxy(62,6);
         if AudCom^.Fail then
            write('PRL read error ',AudCom^.FailMsg)
         else
            write('                                 ');
       end;
     end;

     AudCom^.Cmd(GetXpnImg);
     gotoxy(42,7);
     if AudCom^.Fail then
        write('XPN read error',AudCom^.FailMsg)
     else
        write('                                     ');
     AudCom^.Cmd(GetKeyImg);
     gotoxy(62,7);
     if AudCom^.Fail then
        write('KEY read error',AudCom^.FailMsg)
     else
        write('                                     ');

     ShowPrlParms;
     ShowXpnParms;
     ShowAudKeys;
     if KeyWaiting then
       Ch := GetKey;

     Spin;

   until Ch < #$20;

   AudCom^.CloseRS232;
   SelectCursor(On);
   {$IFDEF WIN16}
     DoneDosCrtWindow;
   {$ENDIF}
end;

end.

