
{Misc routines used by AUDGRAM program }
{09 November 1992 written by Michael Day}
{Copyright 1992 Frye Electronics, Inc. }

unit AgSub;
interface
{$IFDEF WINDOWS}
  uses DosCrt,WinDos,audsubs,VidSubs,Termsub;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,dos,audsubs,VidSubs,TermSub;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$I-,R-}

type string3 = string[3];
     string4 = string[4];
     string5 = string[5];
     string12 = string[12];


{$IFNDEF DPMI}
const  Seg0040 : word = $40;
{$ENDIF}

const DoASCII : boolean = true;

      Hex : array[0..15] of char =
        ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

      sc : array[1..25] of string3 =
        ('-10',' -5','  0','  5',' 10',' 15',' 20',' 25',' 30',
         ' 35',' 40',' 45',' 50',' 55',' 60',' 65',' 70',' 75',
         ' 80',' 85',' 90',' 95','100','105','110');
      fc : array[1..13] of string4 =
        (' 125',' 188',' 250',' 375',' 500',' 750','1000',
         '1500','2000','3000','4000','6000','8000');
      Lic : array[0..7] of string4 =
        ('Tone','Mic ','Ext ','Rext','Stng','WhtN','SpN ','NBN ');
      Ric : array[0..7] of string4 =
        ('Tone','Mic ','Ext ','Rext','Stng','WhtN','SpN ','NBN ');
      Loc : array[0..7] of string5 =
        ('Off  ','Phone','Bone ','Spkr ','Lchan','Lc+Ph','Lc+Bn','Lc+Sp');
      Roc : array[0..7] of string5 =
        ('Off  ','Phone','Bone ','Spkr ','Lchan','Lc+Ph','Lc+Bn','Lc+Sp');
      hc : array[0..7] of string4 =
        ('Off ','6dB ','12dB','18dB','HFE ','OptA','OptB','OptC');


  var Frame : array[0..7] of char;
(*
{$IFDEF WINDOWS}
        (#32,#$7c,#$7c,#$7c,#32,#$2d,#$2d,#32);
{$ELSE}

  const Frame : array[0..7] of char =
        (#32,#182,#186,#199,#200,#209,#205,#188);  
{--$ENDIF}
*)

const

{RspDelay = 36; }

      MaxIndex = 13;    {number of freqs in audiogram}
      MinInt = -32768;  {define what a minint is}

      NBN = 7;    {define various front panel switch positions}
      Tone = 0;
      WN = 5;
      SPN = 6;
      Ear = 1;
      Bone = 2;
      Spkr = 3;

      LMaskChar = '}';       {define audiogram marking chars}
      RMaskChar = '{';
      LEarChar = 'X';
      REarChar = 'O';
      LSpkrChar = 'S';
      RSpkrChar = 'S';
      LBoneChar = '>';
      RboneChar = '<';
      SpaceChar = ' ';
      NrspChar = 'N';

     {define audiogram storage registers}
type PanelArray = array[0..MaxIndex] of integer;

     PanelRegsRec = record
       LElev : PanelArray;
       RElev : PanelArray;
       LBlev : PanelArray;
       RBlev : PanelArray;
       LSlev : PanelArray;
       RSlev : PanelArray;
       LMask : PanelArray;
       RMask : PanelArray;
     end;

type PanelRspRec = record    {define front panel registers}
       PBSTAT  : word;
       PBSPARE : word;
       LFREQ   : integer;
       LLEVEL  : integer;
       LSRC    : integer;
       LDEST   : integer;
       LSIM    : integer;
       LOFS    : integer;
       RFREQ   : integer;
       RLEVEL  : integer;
       RSRC    : integer;
       RDEST   : integer;
       RSIM    : integer;
       ROFS    : integer;
     end;   

{decalre the various variables used in the program}
var chk : char;
    BlankChar : char;
    done : boolean;
    PatReq : boolean;
    Ltrg, Rtrg : boolean;
    Ltgl, Rtgl : boolean;
    NP : PanelRegsRec;
    OP : PanelRegsRec;
    NR : PanelRspRec;
    PR : PanelRspRec;

    Tstring : string;
    LFreqIndex : byte;
    RFreqIndex : byte;
    LPatRsp,RPatRsp : boolean;
    Perr : word;

const ArrayMax = 1000;
var SndArray : array[0..ArrayMax] of word;    {arrays used for packet xfers}
    RcvArray : array[0..ArrayMax] of word;

function InitAGPort(IOport,IRQn:word):boolean;  {init communications port}
procedure RestorePacketMode;    {force audiometer back into packet mode}
procedure InitGraph;      {init screen and graph registers}
procedure drawgraph;      {draw graph on screen}
procedure GetPanel;       {get front panel data from audiometer}
procedure UpdateRegs;     {update the audiogram registers}
procedure UpdateGraph;    {update the screen}
procedure GetKey;         {read the keyboard}
procedure Trigger;        {demand data from the audiometer}
procedure DoSpin;         {yes, I'm still alive}

{----------------------------------------------------------}
implementation

{show the world that we are still working}
procedure DoSpin;           
const Spin   : word = 0;
      OldHnd : word = 0;
var Hr,Min,Sec,Hnd:word;
begin
  gotoxy(1,25);
  GetTime(Hr,Min,Sec,Hnd);
  if Hnd <> OldHnd then
  begin
    OldHnd := Hnd;
    case Spin and $03 of
      0: write('/');
      1: write('-');
      2: write('\');
      3: write('|');
    end;
    inc(Spin);
  end;
end;

{convert a word to a hex string}
function Hexword(W:word):string12;
begin
  HexWord := Hex[hi(W) shr 4] + Hex[hi(W) and $f] +
             Hex[lo(W) shr 4] + Hex[low(W) and $f];
end;

{init the internal audiogram registers}
procedure InitGraph;
var i : word;
begin
  RPatRsp := false;
  LPatRsp := false;
  NR.Llevel := 0;
  NR.Rlevel := 0;
  LfreqIndex := 1;
  RfreqIndex := 1;
  for i := 1 to MaxIndex do
  begin
    NP.LElev[i] := MinInt;
    NP.RElev[i] := MinInt;
    NP.LBlev[i] := MinInt;
    NP.RBlev[i] := MinInt;
    NP.LSlev[i] := MinInt;
    NP.RSlev[i] := MinInt;
    NP.LMask[i] := MinInt;
    NP.RMask[i] := MinInt;
    OP.LElev[i] := MinInt;
    OP.RElev[i] := MinInt;
    OP.LBlev[i] := MinInt;
    OP.RBlev[i] := MinInt;
    OP.LSlev[i] := MinInt;
    OP.RSlev[i] := MinInt;
    OP.LMask[i] := MinInt;
    OP.RMask[i] := MinInt;
  end;

  if not(LineDrawFonts) then
  begin
    Frame := #32#$7c#$7c#$7c#32#$2d#$2d#32;
    BlankChar := '.';
  end
  else
  begin
    Frame := #32#182#186#199#200#209#205#188;
    BlankChar := #249;
  end;
end;

{show the graph on the screen}
procedure drawgraph;
var x,y,xp:word;
begin
  for y := 1 to 23 do
  begin
    gotoxy(1,y);
    if y and 1 = 1 then
    begin
      write(sc[y],' ',frame[1]);
    end
    else
    begin
      write('    ',frame[2]);
    end;
    gotoxy(63,y);
    if y and 1 = 1 then
      write(frame[3],' ',sc[y])
    else
      write(frame[2]);

  end;

  gotoxy(5,24);
  write(frame[4]);

  for x := 1 to 57 do
  begin
    gotoxy(x+5,24);
    if x mod 9 = 2 then
    begin
      write(frame[5]);
      gotoxy(x+3,25);
      write(fc[trunc(x / 4.5)+1],'Hz');
    end
    else
    begin
      write(frame[6]);
    end;
  end;
  gotoxy(63,24);
  write(frame[7]);

  gotoxy(1,24);
  write('dBHL');
  gotoxy(64,24);
  write('dBHL');

  for x := 1 to MaxIndex do
  begin
    xp := trunc(x*4.5)+3;
    if x and 1 = 0 then
    begin
      for y := 1 to 23 do
      begin
        gotoxy(xp,y);
        write(BlankChar);
      end;
    end;
  end;
end;


{using the obtained front panel data, update the audiogram registers}
procedure UpdateRegs;
var r,l:integer;
begin

  {update the Left channel}
  if LPatRsp or Ltrg or (not(PatReq) and (NR.PBstat and 1 <> 0)) then
  begin
    L := (NR.Llevel div 50)+(NR.Lofs div 50)-1;
    if L < 1 then L := MinInt;
    if L > 23 then L := 23;

    if (NR.LSRC = NBN) or (NR.LSRC = WN) or (NR.LSRC = SPN) then
    begin
      {fillint(NP.LMask,sizeof(NP.LMask) shr 1,MinInt);}
      NP.LMask[LFreqIndex] := L;
    end;
    if NR.LSRC = Tone then
    begin
      if Ltrg then
      begin
        if Ltgl then L := Maxint
          else L := MinInt;
      end
      else
        if (L > MinInt) and (L < MaxInt) then Ltgl := false;
      Case NR.LDEST of
        Ear  : begin
                 {fillint(NP.LElev,sizeof(NP.LElev) shr 1,MinInt);}
                 NP.LElev[LFreqIndex] := L;
               end;
        Spkr : begin
                 {fillint(NP.LSlev,sizeof(NP.LSlev) shr 1,MinInt);}
                 NP.LSlev[LFreqIndex] := L;
               end;
        Bone : begin
                 {fillint(NP.LBlev,sizeof(NP.LBlev) shr 1,MinInt);}
                 NP.LBlev[LFreqIndex] := L;
               end;
      end;
    end;
  end;

  {update the right channel}
  if RPatRsp or Rtrg or (not(PatReq) and (NR.PBstat and $100 <> 0)) then
  begin
    R := (NR.Rlevel div 50)+(NR.Rofs div 50)-1;
    if R < 1 then R := MinInt;
    if R > 23 then R := 23;

    if (NR.RSRC = NBN) or (NR.RSRC = WN) or (NR.RSRC = SPN) then
    begin
      {fillint(NP.RMask,sizeof(NP.RMask) shr 1,MinInt); }
      NP.RMask[RFreqIndex] := R;
    end;
    if NR.RSRC = Tone then
    begin
      if Rtrg then
      begin
        if Rtgl then R := Maxint
          else R := MinInt;
      end
      else
        if (R > MinInt) and (R < MaxInt) then Rtgl := false;
      case NR.RDEST of
        Ear  : begin
                 {fillint(NP.RElev,sizeof(NP.RElev) shr 1,MinInt);}
                 NP.RElev[RFreqIndex] := R;
               end;
        Spkr : begin
                 {fillint(NP.RSlev,sizeof(NP.RSlev) shr 1,MinInt);}
                 NP.RSlev[RFreqIndex] := R;
               end;
        Bone : begin
                 {fillint(NP.RBlev,sizeof(NP.RBlev) shr 1,MinInt); }
                 NP.RBlev[RFreqIndex] := R;
               end;
      end;
    end;
  end;
end;

{update the graph with the new audiogram data}
procedure UpdateGraph;
var o,x,y,xp:integer;
    b : char;

   procedure WritePoint(var H:integer; L,R,Xa:integer;
                        Lc,LRc,Rc,RLc,Nrc,Nrcx:char);
   begin
     if (L <> MinInt) then
     begin
       if L = MaxInt then
       begin
         L := 23;         {overload if no response}
         Lc := Nrc;
         LRc := Nrcx;
       end;
       if H > 0 then
       begin
         gotoxy(xa+h,L);
         write(LRc);
       end
       else
       begin
         gotoxy(xa,L);
         write(Lc);
       end;
       inc(H);
     end;
     if (R <> MinInt) then
     begin
       if R = MaxInt then
       begin
         R := 23;         {overload if no response}
         Rc := Nrc;
         RLc := Nrcx;
       end;
       if H > 0 then
       begin
         gotoxy(xa+h,R);
         write(RLc);
       end
       else
       begin
         gotoxy(xa,R);
         write(Rc);
       end;
       inc(H);
     end;
   end;

begin
  for x := 1 to 13 do
  begin
    xp := trunc(x*4.5)+3;
    if x and 1 = 0 then
      b := BlankChar
    else
      b := SpaceChar;

    O := 0;
    WritePoint(O,OP.LMask[x],OP.RMask[x],Xp,B,SpaceChar,B,SpaceChar,B,SpaceChar);
    WritePoint(O,OP.LElev[x],OP.RElev[x],Xp,B,SpaceChar,B,SpaceChar,B,SpaceChar);
    WritePoint(O,OP.LBlev[x],OP.RBlev[x],Xp,B,SpaceChar,B,SpaceChar,B,SpaceChar);
    WritePoint(O,OP.LSlev[x],OP.RSlev[x],Xp,B,SpaceChar,B,SpaceChar,B,SpaceChar);

    O := 0;
    WritePoint(O,NP.LMask[x],NP.RMask[x],Xp,LMaskChar,LMaskChar,RMaskChar,RMaskChar,NrspChar,NrspChar);
    WritePoint(O,NP.LElev[x],NP.RElev[x],Xp,LEarChar,LEarChar,REarChar,REarChar,NrspChar,NrspChar);
    WritePoint(O,NP.LBlev[x],NP.RBlev[x],Xp,LBoneChar,LBoneChar,RBoneChar,RBoneChar,NrspChar,NrspChar);
    WritePoint(O,NP.LSlev[x],NP.RSlev[x],Xp,LSpkrChar,LSpkrChar,RSpkrChar,RSpkrChar,NrspChar,NrspChar);
  end;
  if not(DoASCII) then
  begin
    gotoxy(70,6);
    if Perr and $fc <> 0 then
      write('Err:',hexword(Perr))
    else
      write('      ');
  end;  
  OP := NP;  {save new regs to old ones}
end;


function SendStr(s:string):boolean;
var i : word;
begin
  for i := 1 to length(s) do
  begin
     while not(PutStat) and not(KeyPressed) do {nop};
     PutChar(ord(s[i]));
     if s[i] < #32 then
       ClkWait(8);      {wait 1/2 sec after control chars}
  end;
end;

function SendPacket:boolean;
var i,value:word;
    P:pointer;
begin
  SendPacket := false;
  Perr := 0;

  while Perr and $0001 <> 1 do
  begin
    if Keypressed or (Perr and $00f0 <> 0) then Exit;
    asm
      mov ax,$ff13
      mov dx,[Cport]
      and dx,1
      int $14
      mov [Perr],ax
    end;
  end;

    {$IFDEF PMODE}
      for i := 0 to succ(SndArray[1]) do
      begin
        value := SndArray[i];
        asm
          push ds
          mov ax,$ff23
          mov bx,[value]
          mov cx,[i]
          mov dx,[Cport]
          and dx,1
          int $14
          pop ds
        end;
      end;
      asm
        mov ax,$ff15
        mov dx,[Cport]
        and dx,1
        int $14
      end;
    {$ELSE}
      P := @SndArray;
      asm
        push ds
        mov ax,$ff11
        mov dx,[cport]
        and dx,1
        lds bx,[P]
        int $14
        pop ds
      end;
    {$ENDIF}

  SendPacket := true;
end;

procedure GetPacket;
var i,value,Size:word;
    P:pointer;
begin
  Perr := 0;
  while Perr and $0002 <> 2 do
  begin
    if Keypressed or (Perr and $00f0 <> 0) then Exit;
    asm
      mov ax,$ff13
      mov dx,[Cport]
      and dx,1
      int $14
      mov [Perr],ax
    end;
  end;
  asm
    mov ax,$ff26
    mov dx,[Cport]
    and dx,1
    int $14
    mov [Size],cx
  end;

  if Size < ArrayMax then
  begin
    {$IFDEF PMODE}
      for i := 0 to succ(Size) do
      begin
        asm
          push ds
          mov ax,$ff26
          mov dx,[Cport]
          and dx,1
          mov cx,[i]
          int $14
          pop ds
          mov [value],dx
        end;
        Rcvarray[i] := value;
      end;
      asm
        mov ax,$ff16
        mov dx,[Cport]
        and dx,1
        int $14
      end;
    {$ELSE}
      P := @RcvArray;
      asm
        push ds
        mov ax,$ff12
        mov dx,[cport]
        and dx,1
        lds bx,[P]
        int $14
        pop ds
      end;
    {$ENDIF}
    move(RcvArray[2],PR,sizeof(PR));
  end;
end;

(*
{try to put audiometer into desired mode}
function SyncPort(DoA:boolean):boolean;
begin
  SyncPort := false;
  if DoA then
  begin
    SendStr(#13);   {send a couple CRs to sync things up}
    SendStr(#13);
  end
  else
  begin   {try to dump it out of packet mode if in there}
     if not(SendStr(#13'FIPP ON'#13)) then Exit;
     if not(SendStr(#13'FIPP ON'#13)) then Exit;
  end;
  SyncPort := true;
end;
*)

function InitAGport(IOport,IRQn:word):boolean;
var err : boolean;
begin
  InitAGport := false;
  cport := IOport;
  IRQnum := IRQn;
  write('.');
  if InitPort(true) <> 0 then Exit;
  write(':');
  if not(SendStr(#13'FIPP ON'#13)) then Exit;
  if not(SendStr(#13'FIPP ON'#13)) then Exit;

  ClkWait(4);  {wait 1/4 sec}
  write('.');

  Packet(On);
  SndArray[0] := 38;   {send a reset command}
  SndArray[1] := 0;
  if SendPacket then
    GetPacket;
  write(':');
  ClkWait(5);  {wait 1/4 sec}
  write('.');

  if DoASCII then
  begin
    write(':');
    SndArray[0] := $101E;   {request ascii mode}
    SndArray[1] := 0;    {just in case fa1x is in packet mode}
    if SendPacket then
      GetPacket;
    ClkWait(2);  {wait 1/8 sec}
    write('.');

    asm
      mov ax,$ff10  {disable packet proto}
      mov dx,[Cport]
      and dx,1
      mov ch,$ff
      mov cl,0
      int $14
    end;
  end;
  write(':');
  InitAGport := true;
end;


procedure RestorePacketMode;
begin
  if DOASCII then
  begin
    if not(SendStr(#13'FIPP ON'#13)) then Exit;
    if not(SendStr(#13'FIPP ON'#13)) then Exit;
  end;
end;

procedure GetKey;
begin
  chk := Readkey;
  if chk = #0 then
     chk := char(ord(readkey)+$80);
end;

function GetHex(What:string4):word;
var T,N : word;

  function H2N(What:char):word;
  begin
    if What > '9' then dec(What,7);
    H2N := ord(What) and $0F;
  end;

begin
  GetHex := 0;
  T := pos(What+':',Tstring);
  if T > 0 then
  begin
    N := 0;
    N :=   H2N(Tstring[T+3]) shl 12;
    N := N+H2N(Tstring[T+4]) shl 8;
    N := N+H2N(Tstring[T+5]) shl 4;
    N := N+H2N(Tstring[T+6]) ;
    GetHex := N;
  end;
end;

function GetNum(What:string4):integer;
var T,N,E : word;
begin
  GetNum := MinInt;
  T := pos(What+':',Tstring);
  N := Argval(Tstring[T+3],E);
  if E > 0 then
    GetNum := N;
end;

function GetFindex(What:word):word;
begin
    case What of
      125:GetFindex := 1;
      188:GetFindex := 2;
      250:GetFindex := 3;
      375:GetFindex := 4;
      500:GetFindex := 5;
      750:GetFindex := 6;
      1000:GetFindex := 7;
      1500:GetFindex := 8;
      2000:GetFindex := 9;
      3000:GetFindex := 10;
      4000:GetFindex := 11;
      6000:GetFindex := 12;
      8000:GetFindex := 13;
      else GetFindex := 0;
    end;
end;


procedure GetPanel;
var C : char;
    i : word;
    P : pointer;
begin
  if DoASCII then
  begin
    c := #255;
    while C <> '!' do
    begin
      while not GetStat do
      begin
        if Keypressed then Exit;
        DoSpin;
      end;
      C := char(ord(GetChar) and $7f);
    end;

    Tstring := '';
    while C <> #13 do
    begin
      while not GetStat do
        if Keypressed then Exit;
      C := char(ord(GetChar) and $7f);
      Tstring[succ(length(Tstring))] := C;
      inc(Tstring[0]);
      if length(Tstring) > 254 then Exit;
    end;

    NR.PBstat := GetHex('PS');
    NR.PBspare := GetHex('PM');
    NR.Llevel := GetNum('LL'){+GetNum('LX')}+200;
    NR.Rlevel := GetNum('RL'){+GetNum('RX')}+200;
    NR.Lsrc := GetNum('LI');
    NR.Rsrc := GetNum('RI');
    NR.Ldest := GetNum('LO');
    NR.Rdest := GetNum('RO');
    NR.Lfreq := GetNum('LF');
    NR.Rfreq := GetNum('RF');
    NR.Lsim := GetNum('LS');
    NR.Rsim := GetNum('RS');
    NR.Lofs := GetNum('LX');
    NR.Rofs := GetNum('RX');
  end
  else
  begin
    SndArray[0] := $1001;
    SndArray[1] := 0;
    if SendPacket then
    begin
      GetPacket;
      NR := PR;
      NR.Llevel := (NR.Llevel div 10) +200;
      NR.Rlevel := (NR.Rlevel div 10) +200;
      NR.Lofs := NR.Lofs div 10;
      NR.Rofs := NR.Rofs div 10;
    end;
  end;

  LfreqIndex := GetFindex(NR.Lfreq);
  RfreqIndex := GetFindex(NR.Rfreq);

  if (NR.PBstat and $0001 <> 0) and (NR.PBstat and $0020 <> 0) then
  begin
    LPatRsp := true;
  end
  else
  begin
    LPatRsp := false;
  end;

  if (NR.PBstat and $0100 <> 0) and (NR.PBstat and $2000 <> 0)  then
  begin
    RPatRsp := true;
  end
  else
  begin
    RPatRsp := false;
  end;

  gotoxy(70,7);
  write('<Left>');
  gotoxy(70,8);
  write('Stim:');
  if NR.PBstat and 1 <> 0 then
  begin
    InverseText;
    write(' ON ')
  end
  else
  begin
    NormalText;
    write(' off');
  end;
  NormalText;
  gotoxy(70,9);
  write('Freq:',NR.Lfreq);
  gotoxy(70,10);
  write('Levl:',((NR.Llevel-200)+(NR.Lofs))/10:5:1);
  gotoxy(70,11);
  write('Inp :',Lic[NR.Lsrc]);
  gotoxy(70,12);
  write('Out :',Loc[NR.Ldest]);
  gotoxy(70,13);
  write('HSim:',hc[NR.Lsim]);


  gotoxy(70,15);
  write('<Right>');
  gotoxy(70,16);
  write('Stim:');
  if NR.PBstat and $100 <> 0 then
  begin
    InverseText;
    write(' ON ')
  end
  else
  begin
    NormalText;
    write(' off');
  end;
  NormalText;
  gotoxy(70,17);
  write('Freq:',NR.Rfreq);
  gotoxy(70,18);
  write('Levl:',((NR.Rlevel-200)+(NR.Rofs))/10:5:1);
  gotoxy(70,19);
  write('Inp :',Ric[NR.Rsrc]);
  gotoxy(70,20);
  write('Out :',Roc[NR.Rdest]);
  gotoxy(70,21);
  write('HSim:',hc[NR.Rsim]);

  gotoxy(70,23);
  write('Prsp:');
  if NR.PBstat and $20 <> 0 then
  begin
    InverseText;
    write(' ON ')
  end
  else
  begin
    NormalText;
    write(' off');
  end;
  NormalText;

  gotoxy(70,25);
  write('Tgls:');
  if NR.PBstat and $1010 <> 0 then write('O') else write(' ');
  if NR.PBstat and $0202 <> 0 then write('P') else Write(' ');
  if NR.PBStat and $0404 <> 0 then write('W') else Write(' ');
  if NR.PBstat and $0808 <> 0 then write('T') else write(' ');

end;


procedure Trigger;
begin
  if DoASCII then
  begin
    while not(PutStat) do
      if KeyPressed then Exit;
    PutChar(ord('T'));
    while not(PutStat) do
      if KeyPressed then Exit;
    PutChar(13);
  end;
end;


{--------}
end.
