
{ FA series audiometer front panel control program }
{ V1.30 as of 10 November 1992 }
{ Copyright 1992 Frye Electronics }
{ written by Michael Day }

program apac;
{$IFDEF WINDOWS}
  {$R AUD.RES}
  uses DosCrt,WinTypes,Strings,Audunit,AudIO,AudSubs,VidSubs,AudFipp,AudMisc;
  {$DEFINE PMODE}
{$ELSE}
  uses crt,Audunit,AudIO,AudSubs,VidSubs,AudFipp,AudMisc,Mouse;
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}


{$I+,R+}

const VersionNotice   = 'Audiometer Panel V1.30 11-10-92';
      CopyrightNotice = 'Copyright Frye Electronics 1992';

var IOport,IRQn:word;
    pcnt,Err:integer;
    PStr : string;

begin
 {$IFDEF WINDOWS}
    DosCrt.TextAttr := $07;
    DosCrtFont := OEM_FIXED_FONT;
    ScreenSize.X := 80;
    ScreenSize.Y := 25;
    WindowSize.X := 1000 {639};
    WindowSize.Y := 800 {439};
    StrCopy(WindowTitle,'Audiometer Panel');
    InitDosCrtWindow;
    AutoTracking := false;
 {$ENDIF}

  NormalText;
  clrscr;

  IOport := 0;
  IRQn := 0;
  pcnt := ParamCount;
  while Pcnt > 0 do
  begin
    PStr := ParamStr(Pcnt);
    case upcase(Pstr[1]) of
      '2': IOPort := 1;
      '3': IOPort := 2;
      '4': IOPort := 3;
      'I': begin
              while ((Pstr[1] < '0') or (Pstr[1] > '9')) and (length(Pstr) > 0) do
                delete(Pstr,1,1);
              while ((Pstr[length(Pstr)] < '0') or
                    (Pstr[length(Pstr)] > '9')) and (length(Pstr) > 0) do
                dec(Pstr[0]);
              val(Pstr,Irqn,Err);
              if (IrqN > 15) or (Err <> 0) then IrqN := 0;
           end;
    end;
    dec(Pcnt);
  end;


  if not AudCom^.InitRS232(IOport,IRQn,true) then
  begin
    writeln('** Error **');
    writeln('Unable to establish communications with Audiometer');
    writeln('Fryers probably not installed');
    Halt(1);
  end;

  ComputerControl := false;
  SelectCursor(Off);
  InitScreen;
  ResetAudiometer;

  InitMouse;
  TransferData;
  InitScreen;
  SetLabel(VersionNotice,25,1);
  SetLabel(CopyrightNotice,25,2);
  UpdateComputer;
  UpdateDisplay;
  ShowMouse;
  while not(AllDone) do
  begin
    TransferData;
    if ComputerControl then UpdateAudiometer
      else UpdateComputer;
    ManageIO;
    HideMouse;
    UpdateDisplay;
    ShowMouse;
    IncCurCnt;
  end;

  AudCom^.CloseRS232(AudCom^.D.ComPort);
  SelectCursor(On);
  {$IFDEF WINDOWS}
    DoneDosCrtWindow;
  {$ENDIF}

end.


